/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jdk;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.VariableElement;
import org.netbeans.api.java.source.support.ErrorAwareTreePathScanner;
import org.netbeans.modules.java.hints.jdk.CheckRegex;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.openide.util.NbBundle;

public class Regexp {
    public static ErrorDescription hint(final HintContext ctx) {
        String val;
        final StringBuilder regexp = new StringBuilder();
        final boolean[] accept = new boolean[]{true};
        Tree leaf = ((TreePath)ctx.getVariables().get("$pattern")).getLeaf();
        if (leaf.getKind() == Tree.Kind.STRING_LITERAL) {
            TreePath pattern = (TreePath)ctx.getVariables().get("$pattern");
            new ErrorAwareTreePathScanner<Void, Void>(){

                public Void visitLiteral(LiteralTree node, Void p) {
                    if (node.getValue() instanceof String) {
                        regexp.append(node.getValue());
                        return null;
                    }
                    accept[0] = false;
                    return null;
                }

                public Void visitIdentifier(IdentifierTree node, Void p) {
                    VariableElement ve;
                    Element el = ctx.getInfo().getTrees().getElement(this.getCurrentPath());
                    if (el != null && el.getKind() == ElementKind.FIELD && (ve = (VariableElement)el).getConstantValue() instanceof String) {
                        regexp.append(ve.getConstantValue());
                        return null;
                    }
                    accept[0] = false;
                    return null;
                }

                public Void visitMemberSelect(MemberSelectTree node, Void p) {
                    VariableElement ve;
                    Element el = ctx.getInfo().getTrees().getElement(this.getCurrentPath());
                    if (el != null && el.getKind() == ElementKind.FIELD && (ve = (VariableElement)el).getConstantValue() instanceof String) {
                        regexp.append(ve.getConstantValue());
                        return null;
                    }
                    accept[0] = false;
                    return null;
                }

                public Void visitBinary(BinaryTree node, Void p) {
                    if (node.getKind() != Tree.Kind.PLUS) {
                        return (Void)super.visitBinary(node, (Object)p);
                    }
                    accept[0] = false;
                    return null;
                }

                public Void visitMethodInvocation(MethodInvocationTree node, Void p) {
                    accept[0] = false;
                    return null;
                }
            }.scan(pattern, null);
            if (!accept[0] || regexp.length() == 0) {
                return null;
            }
        } else if (leaf.getKind() == Tree.Kind.IDENTIFIER && (val = CheckRegex.identifierSearch(leaf, ctx)) != null) {
            regexp.append(val);
        }
        try {
            Pattern.compile(regexp.toString());
            return null;
        }
        catch (PatternSyntaxException pse) {
            String displayName = NbBundle.getMessage(Regexp.class, (String)"DN_RegExp", (Object[])new Object[]{pse.getDescription(), pse.getMessage(), pse.getPattern(), pse.getIndex()});
            return ErrorDescriptionFactory.forTree((HintContext)ctx, (Tree)leaf, (String)displayName, (Fix[])new Fix[0]);
        }
    }
}

