/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.core.model.IcmpOptions;
import com.oracle.bmc.core.model.TcpOptions;
import com.oracle.bmc.core.model.UdpOptions;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class EgressSecurityRule
extends ExplicitlySetBmcModel {
    @JsonProperty(value="destination")
    private final String destination;
    @JsonProperty(value="destinationType")
    private final DestinationType destinationType;
    @JsonProperty(value="icmpOptions")
    private final IcmpOptions icmpOptions;
    @JsonProperty(value="isStateless")
    private final Boolean isStateless;
    @JsonProperty(value="protocol")
    private final String protocol;
    @JsonProperty(value="tcpOptions")
    private final TcpOptions tcpOptions;
    @JsonProperty(value="udpOptions")
    private final UdpOptions udpOptions;
    @JsonProperty(value="description")
    private final String description;

    @Deprecated
    @ConstructorProperties(value={"destination", "destinationType", "icmpOptions", "isStateless", "protocol", "tcpOptions", "udpOptions", "description"})
    public EgressSecurityRule(String destination, DestinationType destinationType, IcmpOptions icmpOptions, Boolean isStateless, String protocol, TcpOptions tcpOptions, UdpOptions udpOptions, String description) {
        this.destination = destination;
        this.destinationType = destinationType;
        this.icmpOptions = icmpOptions;
        this.isStateless = isStateless;
        this.protocol = protocol;
        this.tcpOptions = tcpOptions;
        this.udpOptions = udpOptions;
        this.description = description;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDestination() {
        return this.destination;
    }

    public DestinationType getDestinationType() {
        return this.destinationType;
    }

    public IcmpOptions getIcmpOptions() {
        return this.icmpOptions;
    }

    public Boolean getIsStateless() {
        return this.isStateless;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public TcpOptions getTcpOptions() {
        return this.tcpOptions;
    }

    public UdpOptions getUdpOptions() {
        return this.udpOptions;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("EgressSecurityRule(");
        sb.append("super=").append(super.toString());
        sb.append("destination=").append(String.valueOf(this.destination));
        sb.append(", destinationType=").append(String.valueOf((Object)this.destinationType));
        sb.append(", icmpOptions=").append(String.valueOf((Object)this.icmpOptions));
        sb.append(", isStateless=").append(String.valueOf(this.isStateless));
        sb.append(", protocol=").append(String.valueOf(this.protocol));
        sb.append(", tcpOptions=").append(String.valueOf((Object)this.tcpOptions));
        sb.append(", udpOptions=").append(String.valueOf((Object)this.udpOptions));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EgressSecurityRule)) {
            return false;
        }
        EgressSecurityRule other = (EgressSecurityRule)((Object)o);
        return Objects.equals(this.destination, other.destination) && Objects.equals((Object)this.destinationType, (Object)other.destinationType) && Objects.equals((Object)this.icmpOptions, (Object)other.icmpOptions) && Objects.equals(this.isStateless, other.isStateless) && Objects.equals(this.protocol, other.protocol) && Objects.equals((Object)this.tcpOptions, (Object)other.tcpOptions) && Objects.equals((Object)this.udpOptions, (Object)other.udpOptions) && Objects.equals(this.description, other.description) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.destination == null ? 43 : this.destination.hashCode());
        result = result * 59 + (this.destinationType == null ? 43 : this.destinationType.hashCode());
        result = result * 59 + (this.icmpOptions == null ? 43 : this.icmpOptions.hashCode());
        result = result * 59 + (this.isStateless == null ? 43 : this.isStateless.hashCode());
        result = result * 59 + (this.protocol == null ? 43 : this.protocol.hashCode());
        result = result * 59 + (this.tcpOptions == null ? 43 : this.tcpOptions.hashCode());
        result = result * 59 + (this.udpOptions == null ? 43 : this.udpOptions.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum DestinationType implements BmcEnum
    {
        CidrBlock("CIDR_BLOCK"),
        ServiceCidrBlock("SERVICE_CIDR_BLOCK"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, DestinationType> map;

        private DestinationType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DestinationType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'DestinationType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(DestinationType.class);
            map = new HashMap<String, DestinationType>();
            for (DestinationType v : DestinationType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="destination")
        private String destination;
        @JsonProperty(value="destinationType")
        private DestinationType destinationType;
        @JsonProperty(value="icmpOptions")
        private IcmpOptions icmpOptions;
        @JsonProperty(value="isStateless")
        private Boolean isStateless;
        @JsonProperty(value="protocol")
        private String protocol;
        @JsonProperty(value="tcpOptions")
        private TcpOptions tcpOptions;
        @JsonProperty(value="udpOptions")
        private UdpOptions udpOptions;
        @JsonProperty(value="description")
        private String description;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder destination(String destination) {
            this.destination = destination;
            this.__explicitlySet__.add("destination");
            return this;
        }

        public Builder destinationType(DestinationType destinationType) {
            this.destinationType = destinationType;
            this.__explicitlySet__.add("destinationType");
            return this;
        }

        public Builder icmpOptions(IcmpOptions icmpOptions) {
            this.icmpOptions = icmpOptions;
            this.__explicitlySet__.add("icmpOptions");
            return this;
        }

        public Builder isStateless(Boolean isStateless) {
            this.isStateless = isStateless;
            this.__explicitlySet__.add("isStateless");
            return this;
        }

        public Builder protocol(String protocol) {
            this.protocol = protocol;
            this.__explicitlySet__.add("protocol");
            return this;
        }

        public Builder tcpOptions(TcpOptions tcpOptions) {
            this.tcpOptions = tcpOptions;
            this.__explicitlySet__.add("tcpOptions");
            return this;
        }

        public Builder udpOptions(UdpOptions udpOptions) {
            this.udpOptions = udpOptions;
            this.__explicitlySet__.add("udpOptions");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public EgressSecurityRule build() {
            EgressSecurityRule model = new EgressSecurityRule(this.destination, this.destinationType, this.icmpOptions, this.isStateless, this.protocol, this.tcpOptions, this.udpOptions, this.description);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(EgressSecurityRule model) {
            if (model.wasPropertyExplicitlySet("destination")) {
                this.destination(model.getDestination());
            }
            if (model.wasPropertyExplicitlySet("destinationType")) {
                this.destinationType(model.getDestinationType());
            }
            if (model.wasPropertyExplicitlySet("icmpOptions")) {
                this.icmpOptions(model.getIcmpOptions());
            }
            if (model.wasPropertyExplicitlySet("isStateless")) {
                this.isStateless(model.getIsStateless());
            }
            if (model.wasPropertyExplicitlySet("protocol")) {
                this.protocol(model.getProtocol());
            }
            if (model.wasPropertyExplicitlySet("tcpOptions")) {
                this.tcpOptions(model.getTcpOptions());
            }
            if (model.wasPropertyExplicitlySet("udpOptions")) {
                this.udpOptions(model.getUdpOptions());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            return this;
        }
    }
}

