/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.devops.model.BuildRunnerShapeConfig;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="buildRunnerType")
@JsonFilter(value="explicitlySetFilter")
public final class CustomBuildRunnerShapeConfig
extends BuildRunnerShapeConfig {
    @JsonProperty(value="ocpus")
    private final Integer ocpus;
    @JsonProperty(value="memoryInGBs")
    private final Integer memoryInGBs;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public CustomBuildRunnerShapeConfig(Integer ocpus, Integer memoryInGBs) {
        this.ocpus = ocpus;
        this.memoryInGBs = memoryInGBs;
    }

    public Integer getOcpus() {
        return this.ocpus;
    }

    public Integer getMemoryInGBs() {
        return this.memoryInGBs;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CustomBuildRunnerShapeConfig(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", ocpus=").append(String.valueOf(this.ocpus));
        sb.append(", memoryInGBs=").append(String.valueOf(this.memoryInGBs));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CustomBuildRunnerShapeConfig)) {
            return false;
        }
        CustomBuildRunnerShapeConfig other = (CustomBuildRunnerShapeConfig)((Object)o);
        return Objects.equals(this.ocpus, other.ocpus) && Objects.equals(this.memoryInGBs, other.memoryInGBs) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.ocpus == null ? 43 : this.ocpus.hashCode());
        result = result * 59 + (this.memoryInGBs == null ? 43 : this.memoryInGBs.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="ocpus")
        private Integer ocpus;
        @JsonProperty(value="memoryInGBs")
        private Integer memoryInGBs;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder ocpus(Integer ocpus) {
            this.ocpus = ocpus;
            this.__explicitlySet__.add("ocpus");
            return this;
        }

        public Builder memoryInGBs(Integer memoryInGBs) {
            this.memoryInGBs = memoryInGBs;
            this.__explicitlySet__.add("memoryInGBs");
            return this;
        }

        public CustomBuildRunnerShapeConfig build() {
            CustomBuildRunnerShapeConfig model = new CustomBuildRunnerShapeConfig(this.ocpus, this.memoryInGBs);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CustomBuildRunnerShapeConfig model) {
            if (model.wasPropertyExplicitlySet("ocpus")) {
                this.ocpus(model.getOcpus());
            }
            if (model.wasPropertyExplicitlySet("memoryInGBs")) {
                this.memoryInGBs(model.getMemoryInGBs());
            }
            return this;
        }
    }
}

