/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.identity.model.CreateTagDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreateTagRequest
extends BmcRequest<CreateTagDetails> {
    private String tagNamespaceId;
    private CreateTagDetails createTagDetails;
    private String opcRetryToken;
    private Boolean isLockOverride;

    public String getTagNamespaceId() {
        return this.tagNamespaceId;
    }

    public CreateTagDetails getCreateTagDetails() {
        return this.createTagDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public Boolean getIsLockOverride() {
        return this.isLockOverride;
    }

    @InternalSdk
    public CreateTagDetails getBody$() {
        return this.createTagDetails;
    }

    public Builder toBuilder() {
        return new Builder().tagNamespaceId(this.tagNamespaceId).createTagDetails(this.createTagDetails).opcRetryToken(this.opcRetryToken).isLockOverride(this.isLockOverride);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",tagNamespaceId=").append(String.valueOf(this.tagNamespaceId));
        sb.append(",createTagDetails=").append(String.valueOf((Object)this.createTagDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",isLockOverride=").append(String.valueOf(this.isLockOverride));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateTagRequest)) {
            return false;
        }
        CreateTagRequest other = (CreateTagRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.tagNamespaceId, other.tagNamespaceId) && Objects.equals((Object)this.createTagDetails, (Object)other.createTagDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.isLockOverride, other.isLockOverride);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.tagNamespaceId == null ? 43 : this.tagNamespaceId.hashCode());
        result = result * 59 + (this.createTagDetails == null ? 43 : this.createTagDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.isLockOverride == null ? 43 : this.isLockOverride.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateTagRequest, CreateTagDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String tagNamespaceId = null;
        private CreateTagDetails createTagDetails = null;
        private String opcRetryToken = null;
        private Boolean isLockOverride = null;

        public Builder tagNamespaceId(String tagNamespaceId) {
            this.tagNamespaceId = tagNamespaceId;
            return this;
        }

        public Builder createTagDetails(CreateTagDetails createTagDetails) {
            this.createTagDetails = createTagDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder isLockOverride(Boolean isLockOverride) {
            this.isLockOverride = isLockOverride;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateTagRequest o) {
            this.tagNamespaceId(o.getTagNamespaceId());
            this.createTagDetails(o.getCreateTagDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.isLockOverride(o.getIsLockOverride());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateTagRequest build() {
            CreateTagRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateTagDetails body) {
            this.createTagDetails(body);
            return this;
        }

        public CreateTagRequest buildWithoutInvocationCallback() {
            CreateTagRequest request = new CreateTagRequest();
            request.tagNamespaceId = this.tagNamespaceId;
            request.createTagDetails = this.createTagDetails;
            request.opcRetryToken = this.opcRetryToken;
            request.isLockOverride = this.isLockOverride;
            return request;
        }
    }
}

