/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.requirejs.editor.index;

import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.javascript2.types.api.TypeUsage;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.netbeans.modules.parsing.spi.indexing.EmbeddingIndexer;
import org.netbeans.modules.parsing.spi.indexing.EmbeddingIndexerFactory;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.netbeans.modules.parsing.spi.indexing.support.IndexDocument;
import org.netbeans.modules.parsing.spi.indexing.support.IndexingSupport;
import org.openide.filesystems.FileObject;
import org.openide.util.Parameters;

public class RequireJsIndexer
extends EmbeddingIndexer {
    private static final Logger LOG = Logger.getLogger(RequireJsIndexer.class.getName());
    public static final String FIELD_EXPOSED_TYPES = "et";
    public static final String FIELD_MODULE_NAME = "mn";
    public static final String FIELD_PATH_MAP = "mp";
    public static final String FIELD_BASE_PATH = "bp";
    public static final String FIELD_USED_PLUGINS = "up";
    public static final String FIELD_PACKAGES = "pk";
    public static final String FIELD_SOURCE_ROOT = "sr";
    private static final ThreadLocal<Map<URI, Collection<? extends TypeUsage>>> exposedTypes = new ThreadLocal();
    private static final ThreadLocal<Map<URI, Map<String, String>>> pathsMapping = new ThreadLocal();
    private static final ThreadLocal<Map<URI, String>> basePath = new ThreadLocal();
    private static final ThreadLocal<Map<URI, Collection<String>>> usedPlugins = new ThreadLocal();
    private static final ThreadLocal<Map<URI, Map<String, String>>> packageLocations = new ThreadLocal();
    private static final ThreadLocal<Map<URI, String>> sourceRoot = new ThreadLocal();

    protected void index(Indexable indexable, Parser.Result parserResult, Context context) {
        String rootName;
        Map<URI, String> sourceRoots;
        Map<String, String> pkgLocation;
        Map<URI, Map<String, String>> map;
        Collection<String> collection;
        Map<URI, Collection<String>> map2;
        String string;
        Map<URI, String> baseUrls;
        StringBuilder sb;
        Map<String, String> pathMappings;
        Map<URI, Map<String, String>> mappings;
        Collection<? extends TypeUsage> resolvedTypes;
        IndexingSupport support;
        FileObject fo = parserResult.getSnapshot().getSource().getFileObject();
        if (fo == null) {
            return;
        }
        try {
            support = IndexingSupport.getInstance((Context)context);
        }
        catch (IOException ioe) {
            LOG.log(Level.WARNING, null, ioe);
            return;
        }
        IndexDocument elementDocument = support.createDocument(fo);
        boolean storeDocument = false;
        Map<URI, Collection<? extends TypeUsage>> types = exposedTypes.get();
        if (types != null && !types.isEmpty() && (resolvedTypes = types.remove(fo.toURI())) != null && !resolvedTypes.isEmpty()) {
            for (TypeUsage typeUsage : resolvedTypes) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(typeUsage.getType()).append(":").append(typeUsage.getOffset()).append(":").append(typeUsage.isResolved() ? "1" : "0");
                elementDocument.addPair(FIELD_EXPOSED_TYPES, stringBuilder.toString(), false, true);
            }
            storeDocument = true;
            elementDocument.addPair(FIELD_MODULE_NAME, fo.getName(), true, true);
        }
        if ((mappings = pathsMapping.get()) != null && !mappings.isEmpty() && (pathMappings = mappings.remove(fo.toURI())) != null && !pathMappings.isEmpty()) {
            for (Map.Entry<String, String> entry : pathMappings.entrySet()) {
                sb = new StringBuilder();
                sb.append(entry.getKey()).append(";").append(entry.getValue());
                elementDocument.addPair(FIELD_PATH_MAP, sb.toString(), true, true);
            }
            storeDocument = true;
        }
        if ((baseUrls = basePath.get()) != null && !baseUrls.isEmpty() && (string = baseUrls.remove(fo.toURI())) != null && !string.isEmpty()) {
            elementDocument.addPair(FIELD_BASE_PATH, string, true, true);
            storeDocument = true;
        }
        if ((map2 = usedPlugins.get()) != null && !map2.isEmpty() && (collection = map2.remove(fo.toURI())) != null && !collection.isEmpty()) {
            sb = new StringBuilder();
            for (String string2 : collection) {
                sb.append(string2);
                sb.append(';');
            }
            Object pluginNames = sb.toString();
            pluginNames = ((String)pluginNames).substring(0, ((String)pluginNames).length() - 1);
            elementDocument.addPair(FIELD_USED_PLUGINS, (String)pluginNames, true, true);
            storeDocument = true;
        }
        if ((map = packageLocations.get()) != null && !map.isEmpty() && (pkgLocation = map.remove(fo.toURI())) != null && !pkgLocation.isEmpty()) {
            for (Map.Entry entry : pkgLocation.entrySet()) {
                StringBuilder sb3 = new StringBuilder();
                sb3.append((String)entry.getKey()).append(";").append((String)entry.getValue());
                elementDocument.addPair(FIELD_PACKAGES, sb3.toString(), true, true);
            }
            storeDocument = true;
        }
        if ((sourceRoots = sourceRoot.get()) != null && !sourceRoots.isEmpty() && (rootName = sourceRoots.remove(fo.toURI())) != null && !rootName.isEmpty()) {
            elementDocument.addPair(FIELD_SOURCE_ROOT, rootName, true, true);
            storeDocument = true;
        }
        if (storeDocument) {
            support.addDocument(elementDocument);
        }
    }

    public static void addTypes(URI uri, Collection<? extends TypeUsage> exported) {
        Map<URI, Collection<? extends TypeUsage>> map = exposedTypes.get();
        if (map == null) {
            throw new IllegalStateException("RequireJsIndexer.addTypes can be called only from scanner thread.");
        }
        map.put(uri, exported);
    }

    public static void addPathMapping(URI uri, Map<String, String> mappings) {
        Map<URI, Map<String, String>> map = pathsMapping.get();
        if (map == null) {
            throw new IllegalStateException("RequireJsIndexer.addPathMapping can be called only from scanner thread.");
        }
        map.put(uri, mappings);
    }

    public static void addBasePath(URI uri, String path) {
        Map<URI, String> map = basePath.get();
        if (map == null) {
            throw new IllegalStateException("RequireJsIndexer.addBasePath can be called only from scanner thread.");
        }
        map.put(uri, path);
    }

    public static void addUsedPlugings(URI uri, Collection<String> plugins) {
        Map<URI, Collection<String>> map = usedPlugins.get();
        if (map == null) {
            throw new IllegalStateException("RequireJsIndexer.addUsedPlugins can be called only from scanner thread.");
        }
        map.put(uri, plugins);
    }

    public static void addPackages(URI uri, Map<String, String> packages) {
        Map<URI, Map<String, String>> map = packageLocations.get();
        if (map == null) {
            throw new IllegalStateException("RequireJsIndexer.addPackages can be called only from scanner thread.");
        }
        map.put(uri, packages);
    }

    public static void addSourceRoot(URI uri, String rootName) {
        Map<URI, String> map = sourceRoot.get();
        if (map == null) {
            throw new IllegalStateException("RequireJsIndexer.addSourceRoot can be called only from scanner thread.");
        }
        map.put(uri, rootName);
    }

    public static final class Factory
    extends EmbeddingIndexerFactory {
        public static final String NAME = "requirejs";
        public static final int VERSION = 2;
        private static final int PRIORITY = 210;
        private static final ThreadLocal<Collection<Runnable>> postScanTasks = new ThreadLocal();

        public EmbeddingIndexer createIndexer(Indexable indexable, Snapshot snapshot) {
            if (this.isIndexable(indexable, snapshot)) {
                return new RequireJsIndexer();
            }
            return null;
        }

        public void filesDeleted(Iterable<? extends Indexable> deleted, Context context) {
            try {
                IndexingSupport is = IndexingSupport.getInstance((Context)context);
                for (Indexable indexable : deleted) {
                    is.removeDocuments(indexable);
                }
            }
            catch (IOException ioe) {
                LOG.log(Level.WARNING, null, ioe);
            }
        }

        public void filesDirty(Iterable<? extends Indexable> dirty, Context context) {
        }

        public String getIndexerName() {
            return NAME;
        }

        public int getIndexVersion() {
            return 2;
        }

        private boolean isIndexable(Indexable indexable, Snapshot snapshot) {
            return "text/javascript".equals(snapshot.getMimeType());
        }

        public boolean scanStarted(Context context) {
            postScanTasks.set(new LinkedList());
            exposedTypes.set(new HashMap());
            pathsMapping.set(new HashMap());
            basePath.set(new HashMap(1));
            usedPlugins.set(new HashMap());
            packageLocations.set(new HashMap());
            sourceRoot.set(new HashMap(1));
            return super.scanStarted(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scanFinished(Context context) {
            try {
                for (Runnable task : postScanTasks.get()) {
                    task.run();
                }
            }
            finally {
                postScanTasks.remove();
                super.scanFinished(context);
            }
        }

        public static boolean isScannerThread() {
            return postScanTasks.get() != null;
        }

        public static void addPostScanTask(Runnable task) {
            Parameters.notNull((CharSequence)"task", (Object)task);
            Collection<Runnable> tasks = postScanTasks.get();
            if (tasks == null) {
                throw new IllegalStateException("JsIndexer.postScanTask can be called only from scanner thread.");
            }
            tasks.add(task);
        }

        public int getPriority() {
            return 210;
        }
    }
}

