/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.spi.ejbjar.support;

import java.awt.Image;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.netbeans.api.project.Project;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.ejbjar.project.ui.EjbContainerNode;
import org.netbeans.modules.j2ee.ejbjar.project.ui.ServerResourceNode;
import org.netbeans.modules.j2ee.spi.ejbjar.EjbNodesFactory;
import org.openide.actions.FindAction;
import org.openide.filesystems.FileObject;
import org.openide.loaders.ChangeableDataFilter;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public final class J2eeProjectView {
    public static final String CONFIG_FILES_VIEW_NAME = "configurationFiles";
    private static final Logger LOGGER = Logger.getLogger(J2eeProjectView.class.getName());
    private static EjbNodesFactory factoryInstance = null;

    private J2eeProjectView() {
    }

    public static EjbNodesFactory getEjbNodesFactory() {
        if (factoryInstance == null) {
            factoryInstance = (EjbNodesFactory)Lookup.getDefault().lookup(EjbNodesFactory.class);
        }
        if (factoryInstance == null) {
            Logger.getLogger("global").log(Level.INFO, "No EjbNodesFactory instance available: Enterprise Beans nodes cannot be creater");
        }
        return factoryInstance;
    }

    public static Node createServerResourcesNode(Project p) {
        try {
            return new ServerResourceNode(p);
        }
        catch (DataObjectNotFoundException ex) {
            LOGGER.log(Level.INFO, "Project directory FileObject became invalid.", ex);
            return null;
        }
    }

    public static Node createEjbsView(EjbJar ejbModule, Project p) {
        try {
            return new EjbContainerNode(ejbModule, p, J2eeProjectView.getEjbNodesFactory());
        }
        catch (DataObjectNotFoundException ex) {
            LOGGER.log(Level.INFO, "Project directory FileObject became invalid.", ex);
            return null;
        }
    }

    public static Node createConfigFilesView(FileObject folder) {
        return new DocBaseNode(DataFolder.findFolder((FileObject)folder));
    }

    private static final class DocBaseNode
    extends FilterNode {
        private static final DataFilter VISIBILITY_QUERY_FILTER = new VisibilityQueryDataFilter();
        private static Image CONFIGURATION_FILES_BADGE = ImageUtilities.loadImage((String)"org/netbeans/modules/j2ee/ejbjar/project/ui/ejbjar.gif", (boolean)true);

        public DocBaseNode(DataFolder folder) {
            super(folder.getNodeDelegate(), folder.createNodeChildren(VISIBILITY_QUERY_FILTER));
        }

        public Image getIcon(int type) {
            return this.computeIcon(false, type);
        }

        public Image getOpenedIcon(int type) {
            return this.computeIcon(true, type);
        }

        private Image computeIcon(boolean opened, int type) {
            Node folderNode = this.getOriginal();
            Image image = opened ? folderNode.getOpenedIcon(type) : folderNode.getIcon(type);
            return ImageUtilities.mergeImages((Image)image, (Image)CONFIGURATION_FILES_BADGE, (int)7, (int)7);
        }

        public String getName() {
            return J2eeProjectView.CONFIG_FILES_VIEW_NAME;
        }

        public String getDisplayName() {
            return NbBundle.getMessage(J2eeProjectView.class, (String)"LBL_Node_ConfigFiles");
        }

        public boolean canCopy() {
            return false;
        }

        public boolean canCut() {
            return false;
        }

        public boolean canRename() {
            return false;
        }

        public boolean canDestroy() {
            return false;
        }

        public Action[] getActions(boolean context) {
            return new Action[]{SystemAction.get(FindAction.class)};
        }
    }

    private static final class VisibilityQueryDataFilter
    implements ChangeListener,
    ChangeableDataFilter {
        EventListenerList ell = new EventListenerList();

        public VisibilityQueryDataFilter() {
            VisibilityQuery.getDefault().addChangeListener((ChangeListener)this);
        }

        public boolean acceptDataObject(DataObject obj) {
            FileObject fo = obj.getPrimaryFile();
            return VisibilityQuery.getDefault().isVisible(fo);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Object[] listeners = this.ell.getListenerList();
            ChangeEvent event = null;
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != ChangeListener.class) continue;
                if (event == null) {
                    event = new ChangeEvent(this);
                }
                ((ChangeListener)listeners[i + 1]).stateChanged(event);
            }
        }

        public void addChangeListener(ChangeListener listener) {
            this.ell.add(ChangeListener.class, listener);
        }

        public void removeChangeListener(ChangeListener listener) {
            this.ell.remove(ChangeListener.class, listener);
        }
    }
}

