/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5.customizer;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.modules.tomcat5.customizer.CustomizerSupport;
import org.netbeans.modules.tomcat5.deploy.TomcatManager;
import org.netbeans.modules.tomcat5.j2ee.TomcatPlatformImpl;
import org.netbeans.modules.tomcat5.util.TomcatProperties;
import org.openide.util.Exceptions;

public class CustomizerDataSupport {
    private DefaultComboBoxModel jvmModel;
    private Document javaOptsModel;
    private ButtonModel secManagerModel;
    private Document catalinaHomeModel;
    private Document catalinaBaseModel;
    private Document usernameModel;
    private Document passwordModel;
    private Document scriptPathModel;
    private ButtonModel customScriptModel;
    private ButtonModel forceStopModel;
    private ButtonModel sharedMemModel;
    private ButtonModel socketModel;
    private ButtonModel monitorModel;
    private ButtonModel proxyModel;
    private Document sharedMemNameModel;
    private CustomizerSupport.PathModel sourceModel;
    private CustomizerSupport.PathModel classModel;
    private CustomizerSupport.PathModel javadocModel;
    private SpinnerNumberModel serverPortModel;
    private SpinnerNumberModel shutdownPortModel;
    private SpinnerNumberModel debugPortModel;
    private SpinnerNumberModel deploymentTimeoutModel;
    private SpinnerNumberModel startupTimeoutModel;
    private SpinnerNumberModel shutdownTimeoutModel;
    private ButtonModel driverDeploymentModel;
    private boolean jvmModelFlag;
    private boolean javaOptsModelFlag;
    private boolean secManagerModelFlag;
    private boolean usernameModelFlag;
    private boolean passwordModelFlag;
    private boolean scriptPathModelFlag;
    private boolean customScriptModelFlag;
    private boolean forceStopModelFlag;
    private boolean sharedMemModelFlag;
    private boolean socketModelFlag;
    private boolean monitorModelFlag;
    private boolean proxyModelFlag;
    private boolean sharedMemNameModelFlag;
    private boolean sourceModelFlag;
    private boolean javadocModelFlag;
    private boolean serverPortModelFlag;
    private boolean shutdownPortModelFlag;
    private boolean debugPortModelFlag;
    private boolean deploymentTimeoutModelFlag;
    private boolean driverDeploymentModelFlag;
    private boolean startupTimeoutModelFlag;
    private boolean shutdownTimeoutModelFlag;
    private TomcatProperties tp;
    private TomcatManager tm;

    public CustomizerDataSupport(TomcatManager tm) {
        this.tm = tm;
        this.tp = tm.getTomcatProperties();
        this.init();
    }

    private void init() {
        this.jvmModel = new DefaultComboBoxModel();
        this.loadJvmModel();
        this.jvmModel.addListDataListener(new ListDataListener(){

            @Override
            public void contentsChanged(ListDataEvent e) {
                CustomizerDataSupport.this.jvmModelFlag = true;
                CustomizerDataSupport.this.store();
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }
        });
        this.javaOptsModel = this.createDocument(this.tp.getJavaOpts());
        this.javaOptsModel.addDocumentListener(new ModelChangeAdapter(){

            @Override
            public void modelChanged() {
                CustomizerDataSupport.this.javaOptsModelFlag = true;
                CustomizerDataSupport.this.store();
            }
        });
        this.catalinaHomeModel = this.createDocument(this.tp.getCatalinaHome().toString());
        this.catalinaBaseModel = this.createDocument(this.tp.getCatalinaDir().toString());
        this.usernameModel = this.createDocument(this.tp.getUsername());
        this.usernameModel.addDocumentListener(new ModelChangeAdapter(){

            @Override
            public void modelChanged() {
                CustomizerDataSupport.this.usernameModelFlag = true;
                CustomizerDataSupport.this.store();
            }
        });
        this.passwordModel = this.createDocument(this.tp.getPassword());
        this.passwordModel.addDocumentListener(new ModelChangeAdapter(){

            @Override
            public void modelChanged() {
                CustomizerDataSupport.this.passwordModelFlag = true;
                CustomizerDataSupport.this.store();
            }
        });
        this.sharedMemNameModel = this.createDocument(this.tp.getSharedMem());
        this.sharedMemNameModel.addDocumentListener(new ModelChangeAdapter(){

            @Override
            public void modelChanged() {
                CustomizerDataSupport.this.sharedMemNameModelFlag = true;
                CustomizerDataSupport.this.store();
            }
        });
        this.scriptPathModel = this.createDocument(this.tp.getScriptPath());
        this.scriptPathModel.addDocumentListener(new ModelChangeAdapter(){

            @Override
            public void modelChanged() {
                CustomizerDataSupport.this.scriptPathModelFlag = true;
                CustomizerDataSupport.this.store();
            }
        });
        this.secManagerModel = this.createToggleButtonModel(this.tp.getSecManager());
        this.secManagerModel.addItemListener(new ModelChangeAdapter(){

            @Override
            public void modelChanged() {
                CustomizerDataSupport.this.secManagerModelFlag = true;
                CustomizerDataSupport.this.store();
            }
        });
        this.customScriptModel = this.createToggleButtonModel(this.tp.getCustomScript());
        this.customScriptModel.addItemListener(new ModelChangeAdapter(){

            @Override
            public void modelChanged() {
                CustomizerDataSupport.this.customScriptModelFlag = true;
                CustomizerDataSupport.this.store();
            }
        });
        this.forceStopModel = this.createToggleButtonModel(this.tp.getForceStop());
        this.forceStopModel.addItemListener(new ModelChangeAdapter(){

            @Override
            public void modelChanged() {
                CustomizerDataSupport.this.forceStopModelFlag = true;
                CustomizerDataSupport.this.store();
            }
        });
        this.monitorModel = this.createToggleButtonModel(this.tp.getMonitor());
        this.monitorModel.addItemListener(new ModelChangeAdapter(){

            @Override
            public void modelChanged() {
                CustomizerDataSupport.this.monitorModelFlag = true;
                CustomizerDataSupport.this.store();
            }
        });
        this.proxyModel = this.createToggleButtonModel(this.tp.getProxyEnabled());
        this.proxyModel.addItemListener(new ModelChangeAdapter(){

            @Override
            public void modelChanged() {
                CustomizerDataSupport.this.proxyModelFlag = true;
                CustomizerDataSupport.this.store();
            }
        });
        this.classModel = new CustomizerSupport.PathModel(this.tp.getClasses());
        this.sourceModel = new CustomizerSupport.PathModel(this.tp.getSources());
        this.sourceModel.addListDataListener(new ModelChangeAdapter(){

            @Override
            public void modelChanged() {
                CustomizerDataSupport.this.sourceModelFlag = true;
                CustomizerDataSupport.this.store();
            }
        });
        this.javadocModel = new CustomizerSupport.PathModel(this.tp.getJavadocs());
        this.javadocModel.addListDataListener(new ModelChangeAdapter(){

            @Override
            public void modelChanged() {
                CustomizerDataSupport.this.javadocModelFlag = true;
                CustomizerDataSupport.this.store();
            }
        });
        this.serverPortModel = new SpinnerNumberModel(this.tm.getServerPort(), 0, 65535, 1);
        this.serverPortModel.addChangeListener(new ModelChangeAdapter(){

            @Override
            public void modelChanged() {
                CustomizerDataSupport.this.serverPortModelFlag = true;
                CustomizerDataSupport.this.store();
            }
        });
        this.shutdownPortModel = new SpinnerNumberModel(this.tm.getShutdownPort(), 0, 65535, 1);
        this.shutdownPortModel.addChangeListener(new ModelChangeAdapter(){

            @Override
            public void modelChanged() {
                CustomizerDataSupport.this.shutdownPortModelFlag = true;
                CustomizerDataSupport.this.store();
            }
        });
        this.debugPortModel = new SpinnerNumberModel(this.tp.getDebugPort(), 0, 65535, 1);
        this.debugPortModel.addChangeListener(new ModelChangeAdapter(){

            @Override
            public void modelChanged() {
                CustomizerDataSupport.this.debugPortModelFlag = true;
                CustomizerDataSupport.this.store();
            }
        });
        ButtonGroup debugButtonGroup = new ButtonGroup();
        this.socketModel = new JToggleButton.ToggleButtonModel();
        this.socketModel.setGroup(debugButtonGroup);
        this.socketModel.addItemListener(new ModelChangeAdapter(){

            @Override
            public void modelChanged() {
                CustomizerDataSupport.this.socketModelFlag = true;
                CustomizerDataSupport.this.store();
            }
        });
        this.sharedMemModel = new JToggleButton.ToggleButtonModel();
        this.sharedMemModel.setGroup(debugButtonGroup);
        this.sharedMemModel.addItemListener(new ModelChangeAdapter(){

            @Override
            public void modelChanged() {
                CustomizerDataSupport.this.sharedMemModelFlag = true;
                CustomizerDataSupport.this.store();
            }
        });
        boolean socketEnabled = "SEL_debuggingType_socket".equalsIgnoreCase(this.tp.getDebugType());
        debugButtonGroup.setSelected(socketEnabled ? this.socketModel : this.sharedMemModel, true);
        this.deploymentTimeoutModel = new SpinnerNumberModel(this.tp.getDeploymentTimeout(), 1, Integer.MAX_VALUE, 1);
        this.deploymentTimeoutModel.addChangeListener(new ModelChangeAdapter(){

            @Override
            public void modelChanged() {
                CustomizerDataSupport.this.deploymentTimeoutModelFlag = true;
                CustomizerDataSupport.this.store();
            }
        });
        this.driverDeploymentModel = this.createToggleButtonModel(this.tp.getDriverDeployment());
        this.driverDeploymentModel.addItemListener(new ModelChangeAdapter(){

            @Override
            public void modelChanged() {
                CustomizerDataSupport.this.driverDeploymentModelFlag = true;
                CustomizerDataSupport.this.store();
            }
        });
        this.startupTimeoutModel = new SpinnerNumberModel(this.tp.getStartupTimeout(), 1, Integer.MAX_VALUE, 1);
        this.startupTimeoutModel.addChangeListener(new ModelChangeAdapter(){

            @Override
            public void modelChanged() {
                CustomizerDataSupport.this.startupTimeoutModelFlag = true;
                CustomizerDataSupport.this.store();
            }
        });
        this.shutdownTimeoutModel = new SpinnerNumberModel(this.tp.getShutdownTimeout(), 1, Integer.MAX_VALUE, 1);
        this.shutdownTimeoutModel.addChangeListener(new ModelChangeAdapter(){

            @Override
            public void modelChanged() {
                CustomizerDataSupport.this.shutdownTimeoutModelFlag = true;
                CustomizerDataSupport.this.store();
            }
        });
    }

    public boolean useManagerScript() {
        return this.tm.isAboveTomcat70();
    }

    public void loadJvmModel() {
        JavaPlatformManager jpm = JavaPlatformManager.getDefault();
        JavaPlatformAdapter curJvm = (JavaPlatformAdapter)this.jvmModel.getSelectedItem();
        String curPlatformName = curJvm != null ? curJvm.getName() : (String)this.tp.getJavaPlatform().getProperties().get("platform.ant.name");
        this.jvmModel.removeAllElements();
        TomcatPlatformImpl tomcatPlatformImpl = new TomcatPlatformImpl(this.tm);
        Set<String> tomcatPlatforms = tomcatPlatformImpl.getSupportedJavaPlatformVersions();
        JavaPlatform[] j2sePlatforms = jpm.getPlatforms(null, new Specification("J2SE", null));
        TreeSet<JavaPlatformAdapter> platformAdapters = new TreeSet<JavaPlatformAdapter>();
        for (JavaPlatform jp : j2sePlatforms) {
            if (!tomcatPlatforms.contains(jp.getSpecification().getVersion().toString())) continue;
            platformAdapters.add(new JavaPlatformAdapter(jp));
        }
        if (platformAdapters.isEmpty()) {
            this.jvmModel.setSelectedItem(null);
            return;
        }
        for (JavaPlatformAdapter platformAdapter : platformAdapters) {
            this.jvmModel.addElement(platformAdapter);
        }
        for (JavaPlatformAdapter j2sePlatform : platformAdapters) {
            if (curPlatformName == null) continue;
            if (curPlatformName.equals(j2sePlatform.getName())) {
                this.jvmModel.setSelectedItem(j2sePlatform);
                this.jvmModelFlag = true;
                break;
            }
            this.jvmModel.setSelectedItem(j2sePlatform);
            this.jvmModelFlag = true;
        }
    }

    public DefaultComboBoxModel getJvmModel() {
        return this.jvmModel;
    }

    public Document getJavaOptsModel() {
        return this.javaOptsModel;
    }

    public Document getCatalinaHomeModel() {
        return this.catalinaHomeModel;
    }

    public Document getCatalinaBaseModel() {
        return this.catalinaBaseModel;
    }

    public Document getUsernameModel() {
        return this.usernameModel;
    }

    public Document getPasswordModel() {
        return this.passwordModel;
    }

    public ButtonModel getCustomScriptModel() {
        return this.customScriptModel;
    }

    public ButtonModel getForceStopModel() {
        return this.forceStopModel;
    }

    public Document getScriptPathModel() {
        return this.scriptPathModel;
    }

    public ButtonModel getSharedMemModel() {
        return this.sharedMemModel;
    }

    public ButtonModel getSocketModel() {
        return this.socketModel;
    }

    public ButtonModel getMonitorModel() {
        return this.monitorModel;
    }

    public ButtonModel getProxyModel() {
        return this.proxyModel;
    }

    public ButtonModel getSecManagerModel() {
        return this.secManagerModel;
    }

    public Document getSharedMemNameModel() {
        return this.sharedMemNameModel;
    }

    public CustomizerSupport.PathModel getClassModel() {
        return this.classModel;
    }

    public CustomizerSupport.PathModel getSourceModel() {
        return this.sourceModel;
    }

    public CustomizerSupport.PathModel getJavadocsModel() {
        return this.javadocModel;
    }

    public SpinnerNumberModel getServerPortModel() {
        return this.serverPortModel;
    }

    public SpinnerNumberModel getShutdownPortModel() {
        return this.shutdownPortModel;
    }

    public SpinnerNumberModel getDebugPortModel() {
        return this.debugPortModel;
    }

    public SpinnerNumberModel getDeploymentTimeoutModel() {
        return this.deploymentTimeoutModel;
    }

    public SpinnerNumberModel getStartupTimeoutModel() {
        return this.startupTimeoutModel;
    }

    public SpinnerNumberModel getShutdownTimeoutModel() {
        return this.shutdownTimeoutModel;
    }

    public ButtonModel getDriverDeploymentModel() {
        return this.driverDeploymentModel;
    }

    private void store() {
        if (this.jvmModelFlag) {
            JavaPlatformAdapter platformAdapter = (JavaPlatformAdapter)this.jvmModel.getSelectedItem();
            if (platformAdapter != null) {
                this.tp.setJavaPlatform(platformAdapter.getJavaPlatform());
            } else {
                this.tp.setJavaPlatform(null);
            }
            this.jvmModelFlag = false;
        }
        if (this.javaOptsModelFlag) {
            this.tp.setJavaOpts(this.getText(this.javaOptsModel));
            this.javaOptsModelFlag = false;
        }
        if (this.secManagerModelFlag) {
            this.tp.setSecManager(this.secManagerModel.isSelected());
            this.secManagerModelFlag = false;
        }
        if (this.usernameModelFlag) {
            this.tp.setUsername(this.getText(this.usernameModel));
            this.usernameModelFlag = false;
        }
        if (this.passwordModelFlag) {
            this.tp.setPassword(this.getText(this.passwordModel));
            this.passwordModelFlag = false;
        }
        if (this.scriptPathModelFlag) {
            this.tp.setScriptPath(this.getText(this.scriptPathModel));
            this.scriptPathModelFlag = false;
        }
        if (this.customScriptModelFlag) {
            this.tp.setCustomScript(this.customScriptModel.isSelected());
            this.customScriptModelFlag = false;
        }
        if (this.forceStopModelFlag) {
            this.tp.setForceStop(this.forceStopModel.isSelected());
            this.forceStopModelFlag = false;
        }
        if (this.sharedMemModelFlag || this.socketModelFlag) {
            this.tp.setDebugType(this.sharedMemModel.isSelected() ? "SEL_debuggingType_shared" : "SEL_debuggingType_socket");
            this.sharedMemModelFlag = false;
            this.socketModelFlag = false;
        }
        if (this.monitorModelFlag) {
            this.tp.setMonitor(this.monitorModel.isSelected());
            this.monitorModelFlag = false;
        }
        if (this.proxyModelFlag) {
            this.tp.setProxyEnabled(this.proxyModel.isSelected());
            this.proxyModelFlag = false;
        }
        if (this.sharedMemNameModelFlag) {
            this.tp.setSharedMem(this.getText(this.sharedMemNameModel));
            this.sharedMemNameModelFlag = false;
        }
        if (this.sourceModelFlag) {
            this.tp.setSources(this.sourceModel.getData());
            this.sourceModelFlag = false;
        }
        if (this.javadocModelFlag) {
            this.tp.setJavadocs(this.javadocModel.getData());
            this.javadocModelFlag = false;
        }
        if (this.serverPortModelFlag) {
            this.tm.setServerPort((Integer)this.serverPortModel.getValue());
            this.serverPortModelFlag = false;
        }
        if (this.shutdownPortModelFlag) {
            this.tm.setShutdownPort((Integer)this.shutdownPortModel.getValue());
            this.shutdownPortModelFlag = false;
        }
        if (this.debugPortModelFlag) {
            this.tp.setDebugPort((Integer)this.debugPortModel.getValue());
            this.debugPortModelFlag = false;
        }
        if (this.deploymentTimeoutModelFlag) {
            this.tp.setDeploymentTimeout((Integer)this.deploymentTimeoutModel.getValue());
            this.deploymentTimeoutModelFlag = false;
        }
        if (this.driverDeploymentModelFlag) {
            this.tp.setDriverDeployment(this.driverDeploymentModel.isSelected());
            this.driverDeploymentModelFlag = false;
        }
        if (this.startupTimeoutModelFlag) {
            this.tp.setStartupTimeout((Integer)this.startupTimeoutModel.getValue());
            this.startupTimeoutModelFlag = false;
        }
        if (this.shutdownTimeoutModelFlag) {
            this.tp.setShutdownTimeout((Integer)this.shutdownTimeoutModel.getValue());
            this.shutdownTimeoutModelFlag = false;
        }
    }

    private Document createDocument(String text) {
        PlainDocument doc = new PlainDocument();
        if (text != null) {
            try {
                doc.insertString(0, text, null);
            }
            catch (BadLocationException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
        return doc;
    }

    private JToggleButton.ToggleButtonModel createToggleButtonModel(boolean selected) {
        JToggleButton.ToggleButtonModel model = new JToggleButton.ToggleButtonModel();
        model.setSelected(selected);
        return model;
    }

    private String getText(Document doc) {
        try {
            return doc.getText(0, doc.getLength());
        }
        catch (BadLocationException e) {
            Exceptions.printStackTrace((Throwable)e);
            return null;
        }
    }

    private static class JavaPlatformAdapter
    implements Comparable {
        private JavaPlatform platform;

        public JavaPlatformAdapter(JavaPlatform platform) {
            this.platform = platform;
        }

        public JavaPlatform getJavaPlatform() {
            return this.platform;
        }

        public String getName() {
            return (String)this.platform.getProperties().get("platform.ant.name");
        }

        public String toString() {
            return this.platform.getDisplayName();
        }

        public int compareTo(Object o) {
            return this.toString().compareTo(o.toString());
        }
    }

    private abstract class ModelChangeAdapter
    implements ListDataListener,
    DocumentListener,
    ItemListener,
    ChangeListener {
        private ModelChangeAdapter() {
        }

        public abstract void modelChanged();

        @Override
        public void contentsChanged(ListDataEvent e) {
            this.modelChanged();
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            this.modelChanged();
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            this.modelChanged();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.modelChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.modelChanged();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.modelChanged();
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            this.modelChanged();
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.modelChanged();
        }
    }
}

