/*
 * Decompiled with CFR 0.152.
 */
package xsbti.api;

import java.util.function.Supplier;
import xsbti.api.AbstractLazy;
import xsbti.api.Lazy;

public final class SafeLazy {
    public static <T> Lazy<T> apply(Supplier<T> supplier) {
        return new Impl<T>(supplier);
    }

    public static <T> Lazy<T> strict(T t) {
        return new StrictImpl<T>(t);
    }

    private static final class StrictImpl<T>
    extends AbstractLazy<T> {
        private final T value;

        StrictImpl(T t) {
            this.value = t;
        }

        @Override
        public T get() {
            return this.value;
        }
    }

    private static final class Impl<T>
    extends AbstractLazy<T> {
        private Thunky<T> thunky;

        Impl(Supplier<T> supplier) {
            this.thunky = new Thunky<Object>(supplier, null);
        }

        @Override
        public T get() {
            Thunky<T> thunky = this.thunky;
            if (thunky.result == null) {
                Object t = thunky.thunk.get();
                this.thunky = thunky = new Thunky(null, t);
            }
            return thunky.result;
        }
    }

    private static final class Thunky<T> {
        final Supplier<T> thunk;
        final T result;

        Thunky(Supplier<T> supplier, T t) {
            this.thunk = supplier;
            this.result = t;
        }
    }
}

