/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import org.infinispan.Cache;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.connections.infinispan.InfinispanUtil;
import org.keycloak.models.KeycloakSession;
import org.keycloak.sessions.StickySessionEncoderProvider;

public class InfinispanStickySessionEncoderProvider
implements StickySessionEncoderProvider {
    private final KeycloakSession session;
    private final boolean shouldAttachRoute;

    public InfinispanStickySessionEncoderProvider(KeycloakSession session, boolean shouldAttachRoute) {
        this.session = session;
        this.shouldAttachRoute = shouldAttachRoute;
    }

    public String encodeSessionId(String sessionId) {
        if (!this.shouldAttachRoute) {
            return sessionId;
        }
        String route = this.getRoute(sessionId);
        if (route != null) {
            return sessionId + "." + route;
        }
        return sessionId;
    }

    public String decodeSessionId(String encodedSessionId) {
        int index = encodedSessionId.indexOf(46);
        return index == -1 ? encodedSessionId : encodedSessionId.substring(0, index);
    }

    public boolean shouldAttachRoute() {
        return this.shouldAttachRoute;
    }

    public void close() {
    }

    private String getRoute(String sessionId) {
        InfinispanConnectionProvider ispnProvider = (InfinispanConnectionProvider)this.session.getProvider(InfinispanConnectionProvider.class);
        Cache cache = ispnProvider.getCache("authenticationSessions");
        return InfinispanUtil.getTopologyInfo(this.session).getRouteName(cache, sessionId);
    }
}

