/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventhubs;

import com.microsoft.azure.eventhubs.SecurityToken;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.JWTParser;
import java.text.ParseException;
import java.util.Date;

public class JsonSecurityToken
extends SecurityToken {
    public JsonSecurityToken(String rawToken, String audience) throws ParseException {
        super(rawToken, JsonSecurityToken.getExpirationDateTimeUtcFromToken(rawToken), audience, "jwt");
    }

    static Date getExpirationDateTimeUtcFromToken(String token) throws ParseException {
        JWT jwt = JWTParser.parse((String)token);
        JWTClaimsSet claims = jwt.getJWTClaimsSet();
        return claims.getExpirationTime();
    }
}

