/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.Controller;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.InstructionDetails;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.lib.Logger;
import net.sf.saxon.lib.TraceListener;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.SequenceExtent;

public class Trace
extends SystemFunctionCall
implements Callable {
    public Expression preEvaluate(ExpressionVisitor visitor) {
        return this;
    }

    public int computeSpecialProperties() {
        return this.argument[0].getSpecialProperties();
    }

    public int computeCardinality() {
        return this.argument[0].getCardinality();
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        Item val = this.argument[0].evaluateItem(context);
        String label = this.argument[1].evaluateAsString(context).toString();
        Controller controller = context.getController();
        if (controller.isTracing()) {
            this.notifyListener(label, val, context);
        } else {
            Logger out = controller.getTraceFunctionDestination();
            if (out != null) {
                if (val == null) {
                    Trace.traceItem(val, label + ": empty sequence", out);
                } else {
                    Trace.traceItem(val, label, out);
                }
            }
        }
        return val;
    }

    public void notifyListener(String label, Sequence val, XPathContext context) {
        InstructionDetails info = new InstructionDetails();
        info.setConstructType(2041);
        info.setLineNumber(this.getLineNumber());
        info.setSystemId(this.getSystemId());
        info.setProperty("label", label);
        info.setProperty("value", val);
        TraceListener listener = context.getController().getTraceListener();
        listener.enter(info, context);
        listener.leave(info);
    }

    public static void traceItem(Item val, String label, Logger out) {
        if (val == null) {
            out.info(label);
        } else if (val instanceof NodeInfo) {
            out.info(label + ": " + Type.displayTypeName(val) + ": " + Navigator.getPath((NodeInfo)val));
        } else {
            out.info(label + ": " + Type.displayTypeName(val) + ": " + val.getStringValue());
        }
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        Controller controller = context.getController();
        if (controller.isTracing()) {
            String label = this.argument[1].evaluateAsString(context).toString();
            Sequence value = ExpressionTool.eagerEvaluate(this.argument[0], context);
            this.notifyListener(label, value, context);
            return value.iterate();
        }
        Logger out = controller.getTraceFunctionDestination();
        if (out == null) {
            return this.argument[0].iterate(context);
        }
        return new TracingIterator(this.argument[0].iterate(context), this.argument[1].evaluateAsString(context).toString(), out);
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        Controller controller = context.getController();
        if (controller.isTracing()) {
            String label = arguments[1].head().getStringValue();
            GroundedValue value = SequenceExtent.makeSequenceExtent(arguments[0].iterate());
            this.notifyListener(label, value, context);
            return value;
        }
        Logger out = controller.getTraceFunctionDestination();
        if (out == null) {
            return arguments[0];
        }
        return SequenceTool.toLazySequence(new TracingIterator(arguments[0].iterate(), arguments[1].head().toString(), out));
    }

    private class TracingIterator
    implements SequenceIterator {
        private SequenceIterator base;
        private String label;
        private Logger out;
        private boolean empty = true;
        private int position = 0;

        public TracingIterator(SequenceIterator base, String label, Logger out) {
            this.base = base;
            this.label = label;
            this.out = out;
        }

        public Item next() throws XPathException {
            Item n = this.base.next();
            ++this.position;
            if (n == null) {
                if (this.empty) {
                    Trace.traceItem(null, this.label + ": empty sequence", this.out);
                }
            } else {
                Trace.traceItem(n, this.label + " [" + this.position + ']', this.out);
                this.empty = false;
            }
            return n;
        }

        public void close() {
            this.base.close();
        }

        public TracingIterator getAnother() throws XPathException {
            return new TracingIterator(this.base.getAnother(), this.label, this.out);
        }

        public int getProperties() {
            return 0;
        }
    }
}

