/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.config.discovery.internal.console;

import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.config.discovery.DiscoveryResult;
import org.openhab.core.config.discovery.DiscoveryResultFlag;
import org.openhab.core.config.discovery.inbox.Inbox;
import org.openhab.core.config.discovery.inbox.InboxPredicates;
import org.openhab.core.config.discovery.internal.PersistentInbox;
import org.openhab.core.io.console.Console;
import org.openhab.core.io.console.ConsoleCommandCompleter;
import org.openhab.core.io.console.StringsCompleter;
import org.openhab.core.io.console.extensions.AbstractConsoleCommandExtension;
import org.openhab.core.io.console.extensions.ConsoleCommandExtension;
import org.openhab.core.thing.ThingTypeUID;
import org.openhab.core.thing.ThingUID;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ConsoleCommandExtension.class})
@NonNullByDefault
public class InboxConsoleCommandExtension
extends AbstractConsoleCommandExtension {
    private static final String SUBCMD_APPROVE = "approve";
    private static final String SUBCMD_IGNORE = "ignore";
    private static final String SUBCMD_LIST = "list";
    private static final String SUBCMD_LIST_IGNORED = "listignored";
    private static final String SUBCMD_CLEAR = "clear";
    private static final String SUBCMD_REMOVE = "remove";
    private static final StringsCompleter SUBCMD_COMPLETER = new StringsCompleter(List.of("approve", "ignore", "list", "listignored", "clear", "remove"), false);
    private final Inbox inbox;

    @Activate
    public InboxConsoleCommandExtension(@Reference Inbox inbox) {
        super("inbox", "Manage your inbox.");
        this.inbox = inbox;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(String[] args, Console console) {
        block38: {
            String subCommand;
            if (args.length <= 0) break block38;
            switch (subCommand = args[0]) {
                case "approve": {
                    if (args.length > 2) {
                        String label = args[2];
                        String newThingId = null;
                        if (args.length > 3) {
                            newThingId = args[3];
                        }
                        try {
                            ThingUID thingUID = new ThingUID(args[1]);
                            List<DiscoveryResult> results = this.inbox.stream().filter(InboxPredicates.forThingUID(thingUID)).toList();
                            if (results.isEmpty()) {
                                console.println("No matching inbox entry could be found.");
                                return;
                            }
                            this.inbox.approve(thingUID, label, newThingId);
                            return;
                        }
                        catch (IllegalArgumentException e) {
                            console.println(Objects.requireNonNullElse(e.getMessage(), String.format("An error occurred while approving '%s'", args[1])));
                        }
                        return;
                    }
                    console.println("Specify thing id to approve: inbox approve <thingUID> <label> [<newThingID>]");
                    return;
                }
                case "ignore": {
                    if (args.length > 1) {
                        try {
                            ThingUID thingUID = new ThingUID(args[1]);
                            PersistentInbox persistentInbox = (PersistentInbox)this.inbox;
                            persistentInbox.setFlag(thingUID, DiscoveryResultFlag.IGNORED);
                            return;
                        }
                        catch (IllegalArgumentException e) {
                            console.println("'" + args[1] + "' is no valid thing UID.");
                        }
                        return;
                    }
                    console.println("Cannot approve thing as managed thing provider is missing.");
                    return;
                }
                case "list": {
                    this.printInboxEntries(console, this.inbox.stream().filter(InboxPredicates.withFlag(DiscoveryResultFlag.NEW)).toList());
                    return;
                }
                case "listignored": {
                    this.printInboxEntries(console, this.inbox.stream().filter(InboxPredicates.withFlag(DiscoveryResultFlag.IGNORED)).toList());
                    return;
                }
                case "clear": {
                    this.clearInboxEntries(console, this.inbox.getAll());
                    return;
                }
                case "remove": {
                    if (args.length > 1) {
                        List<DiscoveryResult> results;
                        boolean validParam = true;
                        try {
                            ThingUID thingUID = new ThingUID(args[1]);
                            results = this.inbox.stream().filter(InboxPredicates.forThingUID(thingUID)).toList();
                            if (results.isEmpty()) {
                                console.println("No matching inbox entry could be found.");
                            } else {
                                this.clearInboxEntries(console, results);
                            }
                        }
                        catch (IllegalArgumentException e) {
                            validParam = false;
                        }
                        if (validParam) return;
                        try {
                            ThingTypeUID thingTypeUID = new ThingTypeUID(args[1]);
                            results = this.inbox.stream().filter(InboxPredicates.forThingTypeUID(thingTypeUID)).toList();
                            if (results.isEmpty()) {
                                console.println("No matching inbox entry could be found.");
                                return;
                            }
                            this.clearInboxEntries(console, results);
                            return;
                        }
                        catch (IllegalArgumentException e) {
                            console.println("'" + args[1] + "' is no valid thing UID or thing type.");
                        }
                        return;
                    }
                    console.println("Specify thing id or thing type to remove: inbox remove [<thingUID>|<thingTypeUID>]");
                    return;
                }
                default: {
                    this.printUsage(console);
                    return;
                }
            }
        }
        this.printUsage(console);
    }

    private void printInboxEntries(Console console, List<DiscoveryResult> discoveryResults) {
        if (discoveryResults.isEmpty()) {
            console.println("No inbox entries found.");
        }
        for (DiscoveryResult discoveryResult : discoveryResults) {
            ThingTypeUID thingTypeUID = discoveryResult.getThingTypeUID();
            ThingUID thingUID = discoveryResult.getThingUID();
            String label = discoveryResult.getLabel();
            DiscoveryResultFlag flag = discoveryResult.getFlag();
            ThingUID bridgeId = discoveryResult.getBridgeUID();
            Map<String, Object> properties = discoveryResult.getProperties();
            String representationProperty = discoveryResult.getRepresentationProperty();
            String timestamp = Instant.ofEpochMilli(discoveryResult.getTimestamp()).toString();
            String timeToLive = discoveryResult.getTimeToLive() == -1L ? "UNLIMITED" : "" + discoveryResult.getTimeToLive();
            console.println(String.format("%s [%s]: %s [thingId=%s, bridgeId=%s, properties=%s, representationProperty=%s, timestamp=%s, timeToLive=%s]", flag.name(), thingTypeUID, label, thingUID, bridgeId, properties, representationProperty, timestamp, timeToLive));
        }
    }

    private void clearInboxEntries(Console console, List<DiscoveryResult> discoveryResults) {
        if (discoveryResults.isEmpty()) {
            console.println("No inbox entries found.");
        }
        for (DiscoveryResult discoveryResult : discoveryResults) {
            ThingTypeUID thingTypeUID = discoveryResult.getThingTypeUID();
            ThingUID thingUID = discoveryResult.getThingUID();
            String label = discoveryResult.getLabel();
            DiscoveryResultFlag flag = discoveryResult.getFlag();
            ThingUID bridgeId = discoveryResult.getBridgeUID();
            Map<String, Object> properties = discoveryResult.getProperties();
            console.println(String.format("REMOVED [%s]: %s [label=%s, thingId=%s, bridgeId=%s, properties=%s]", flag.name(), thingTypeUID, label, thingUID, bridgeId, properties));
            this.inbox.remove(thingUID);
        }
    }

    public List<String> getUsages() {
        return List.of(this.buildCommandUsage(SUBCMD_LIST, "lists all current inbox entries"), this.buildCommandUsage(SUBCMD_LIST_IGNORED, "lists all ignored inbox entries"), this.buildCommandUsage("approve <thingUID> <label> [<newThingID>]", "creates a thing for an inbox entry"), this.buildCommandUsage(SUBCMD_CLEAR, "clears all current inbox entries"), this.buildCommandUsage("remove [<thingUID>|<thingTypeUID>]", "remove the inbox entries of a given thing id or thing type"), this.buildCommandUsage("ignore <thingUID>", "ignores an inbox entry permanently"));
    }

    public @Nullable ConsoleCommandCompleter getCompleter() {
        return new InboxConsoleCommandCompleter();
    }

    private class InboxConsoleCommandCompleter
    implements ConsoleCommandCompleter {
        private InboxConsoleCommandCompleter() {
        }

        public boolean complete(String[] args, int cursorArgumentIndex, int cursorPosition, List<String> candidates) {
            if (cursorArgumentIndex <= 0) {
                return SUBCMD_COMPLETER.complete(args, cursorArgumentIndex, cursorPosition, candidates);
            }
            if (cursorArgumentIndex == 1) {
                if (InboxConsoleCommandExtension.SUBCMD_IGNORE.equalsIgnoreCase(args[0]) || InboxConsoleCommandExtension.SUBCMD_APPROVE.equalsIgnoreCase(args[0])) {
                    return new StringsCompleter(this.getThingUIDs(), true).complete(args, cursorArgumentIndex, cursorPosition, candidates);
                }
                if (InboxConsoleCommandExtension.SUBCMD_REMOVE.equalsIgnoreCase(args[0])) {
                    return new StringsCompleter(this.getThingAndThingTypeUIDs(), true).complete(args, cursorArgumentIndex, cursorPosition, candidates);
                }
            }
            return false;
        }

        private Collection<String> getThingUIDs() {
            return InboxConsoleCommandExtension.this.inbox.stream().map(r -> r.getThingUID().getAsString()).toList();
        }

        private Collection<String> getThingAndThingTypeUIDs() {
            return InboxConsoleCommandExtension.this.inbox.stream().flatMap(r -> Stream.of(r.getThingUID().getAsString(), r.getThingTypeUID().getAsString())).toList();
        }
    }
}

