'\"
'\" Generated from file 'connect\&.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2006-2009 Andreas Kupries <andreas_kupries@users\&.sourceforge\&.net>
'\"
.TH "transfer::connect" n 0\&.3 tcllib "Data transfer facilities"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
transfer::connect \- Connection setup
.SH SYNOPSIS
package require \fBTcl 8\&.5 9\fR
.sp
package require \fBsnit ?1\&.0?\fR
.sp
package require \fBtransfer::connect ?0\&.3?\fR
.sp
\fBtransfer::connect\fR \fIobjectName\fR ?\fIoptions\fR\&.\&.\&.?
.sp
\fIobjectName\fR \fBmethod\fR ?\fIarg arg \&.\&.\&.\fR?
.sp
\fIobjectName\fR \fBdestroy\fR
.sp
\fIobjectName\fR \fBconnect\fR \fIcommand\fR
.sp
.BE
.SH DESCRIPTION
.PP
This package provides objects holding enough information to enable
them to either actively connect to a counterpart, or to passively wait
for a connection from said counterpart\&.
I\&.e\&. any object created by this packages is always in one of two
complementary modes, called \fIactive\fR (the object initiates the
connection) and \fIpassive\fR (the object receives the connection)\&.
.PP
Of the two objects in a connecting pair one has to be configured for
\fIactive\fR mode, and the other then has to be configured for
\fIpassive\fR mode\&. This establishes which of the two partners
connects to whom (the \fIactive\fR to the other), or, who is waiting
on whom (the \fIpassive\fR on the other)\&.
Note that this is completely independent of the direction of any data
transmission using the connection after it has been established\&.
An active object can, after establishing the connection, either
transmit or receive data\&. Equivalently the passive object can do the
same after the waiting for its partner has ended\&.
.SH API
.SS "PACKAGE COMMANDS"
.TP
\fBtransfer::connect\fR \fIobjectName\fR ?\fIoptions\fR\&.\&.\&.?
This command creates a new connection object with an associated Tcl
command whose name is \fIobjectName\fR\&.
This \fIobject\fR command is explained in full detail in the sections
\fBObject command\fR and \fBObject methods\fR\&. The set of
supported \fIoptions\fR is explained in section \fBOptions\fR\&.
.sp
The object command will be created under the current namespace if the
\fIobjectName\fR is not fully qualified, and in the specified
namespace otherwise\&.
The fully qualified name of the object command is returned as the
result of the command\&.
.PP
.SS "OBJECT COMMAND"
All objects created by the \fB::transfer::connect\fR command have the
following general form:
.TP
\fIobjectName\fR \fBmethod\fR ?\fIarg arg \&.\&.\&.\fR?
The method \fBmethod\fR and its \fIarg\fR'uments determine the
exact behavior of the command\&.
See section \fBObject methods\fR for the detailed
specifications\&.
.PP
.SS "OBJECT METHODS"
.TP
\fIobjectName\fR \fBdestroy\fR
This method destroys the object\&.
This is safe to do for an \fIactive\fR object when a connection has
been started, as the completion callback is synchronous\&.
For a \fIpassive\fR object currently waiting for its partner to
establish the connection however this is not safe and will cause
errors later on, when the connection setup completes and tries to
access the now missing data structures of the destroyed object\&.
.TP
\fIobjectName\fR \fBconnect\fR \fIcommand\fR
This method starts the connection setup per the configuration of the
object\&. When the connection is established the callback \fIcommand\fR
will be invoked with one additional argument, the channel handle of
the socket over which data can be transfered\&.
.sp
The detailed behaviour of the method depends on the configured
mode\&.
.RS
.TP
\fIactive\fR
The connection setup is done synchronously\&. The object waits until the
connection is established\&. The method returns the empty string as its
result\&.
.TP
\fIpassive\fR
The connection setup is done asynchronously\&. The method returns
immediately after a listening socket has been set up\&. The connection
will be established in the background\&.
The method returns the port number of the listening socket, for use by
the caller\&. One important use is the transfer of this information to
the counterpart so that it knows where it has to connect to\&.
.sp
This is necessary as the object might have been configured for port
\fB0\fR, allowing the operating system to choose the actual port it
will listen on\&.
.sp
The listening port is closed immediately when the connection was
established by the partner, to keep the time interval small within
which a third party can connect to the port too\&.
Even so it is recommended to use additional measures in the protocol
outside of the connect and transfer object to ensure that a connection
is not used with an unidentified/unauthorized partner
One possibility for this is the use of SSL/TLS\&.
See the option \fB-socketcmd\fR and section
\fBSecure connections\fR for information on how to do this\&.
.RE
.PP
.SS OPTIONS
Connection objects support the set of options listed below\&.
.TP
\fB-mode\fR \fImode\fR
This option specifies the mode the object is in\&. It is optional and
defaults to \fBactive\fR mode\&. The two possible modes are:
.RS
.TP
\fBactive\fR
In this mode the two options \fB-host\fR and \fB-port\fR are
relevant and specify the host and TCP port the object has to connect
to\&. The host is given by either name or IP address\&.
.TP
\fBpassive\fR
In this mode the option \fB-host\fR has no relevance and is ignored
should it be configured\&.
The only option the object needs is \fB-port\fR, and it specifies
the TCP port on which the listening socket is opened to await the
connection from the partner\&.
.RE
.TP
\fB-host\fR \fIhostname-or-ipaddr\fR
This option specifies the host to connect to in \fIactive\fR mode,
either by name or ip-address\&. An object configured for \fIpassive\fR
mode ignores this option\&.
.TP
\fB-port\fR \fIint\fR
For \fIactive\fR mode this option specifies the port the object is
expected to connect to\&. For \fIpassive\fR mode however it is the port
where the object creates the listening socket waiting for a
connection\&. It defaults to \fB0\fR, which allows the OS to choose
the actual port to listen on\&.
.TP
\fB-socketcmd\fR \fIcommand\fR
This option allows the user to specify which command to use to open a
socket\&. The default is to use the builtin \fB::socket\fR\&. Any
compatible with that command is allowed\&.
.sp
The envisioned main use is the specfication of \fBtls::socket\fR\&. I\&.e\&.
this option allows the creation of secure transfer channels, without
making this package explicitly dependent on the \fBtls\fR package\&.
.sp
See also section \fBSecure connections\fR\&.
.TP
\fB-encoding\fR encodingname
.TP
\fB-eofchar\fR eofspec
.TP
\fB-translation\fR transspec
These options are the same as are recognized by the builtin command
\fBfconfigure\fR\&. They provide the configuration to be set for the
channel between the two partners after it has been established, but
before the callback is invoked (See method \fBconnect\fR)\&.
.PP
.SH "SECURE CONNECTIONS"
One way to secure connections made by objects of this package is to
require the package \fBtls\fR and then configure the option
\fB-socketcmd\fR to force the use of command \fBtls::socket\fR to
open the socket\&.
.CS


    # Load and initialize tls
    package require tls
    tls::init -cafile /path/to/ca/cert -keyfile \&.\&.\&.

    # Create a connector with secure socket setup,
    transfer::connect C -socketcmd tls::socket \&.\&.\&.
    \&.\&.\&.

.CE
.SH "TLS SECURITY CONSIDERATIONS"
.PP
This package uses the \fBTLS\fR package to handle the
security for \fBhttps\fR urls and other socket connections\&.
.PP
Policy decisions like the set of protocols to support and what
ciphers to use are not the responsibility of \fBTLS\fR, nor of
this package itself however\&.
Such decisions are the responsibility of whichever application is
using the package, and are likely influenced by the set of servers
the application will talk to as well\&.
.PP
For example, in light of the recent
\fIPOODLE attack\fR [http://googleonlinesecurity\&.blogspot\&.co\&.uk/2014/10/this-poodle-bites-exploiting-ssl-30\&.html] discovered by Google many servers will disable support
for the SSLv3 protocol\&.
To handle this change the applications using \fBTLS\fR must be
patched, and not this package, nor \fBTLS\fR itself\&.
Such a patch may be as simple as generally activating \fBtls1\fR
support, as shown in the example below\&.
.CS


    package require tls
    tls::init -tls1 1 ;# forcibly activate support for the TLS1 protocol

    \&.\&.\&. your own application code \&.\&.\&.

.CE
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems\&.
Please report such in the category \fItransfer\fR of the
\fITcllib Trackers\fR [http://core\&.tcl\&.tk/tcllib/reportlist]\&.
Please also report any ideas for enhancements you may have for either
package and/or documentation\&.
.PP
When proposing code changes, please provide \fIunified diffs\fR,
i\&.e the output of \fBdiff -u\fR\&.
.PP
Note further that \fIattachments\fR are strongly preferred over
inlined patches\&. Attachments can be made by going to the \fBEdit\fR
form of the ticket immediately after its creation, and then using the
left-most button in the secondary navigation bar\&.
.SH KEYWORDS
active, channel, connection, passive, secure, ssl, tls, transfer
.SH CATEGORY
Transfer module
.SH COPYRIGHT
.nf
Copyright (c) 2006-2009 Andreas Kupries <andreas_kupries@users\&.sourceforge\&.net>

.fi
