/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.InGameController;
import net.sf.freecol.client.gui.FontLibrary;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.action.UnloadAction;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.debug.DebugUtils;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.LogBuilder;

public final class TilePopup
extends JPopupMenu {
    private static final Logger logger = Logger.getLogger(TilePopup.class.getName());
    public static final int UNIT_LINES_IN_FIRST_MENU = 9;
    public static final int UNIT_LINES_IN_OTHER_MENUS = 19;
    private final FreeColClient freeColClient;
    private final GUI gui;
    private Font font;
    private boolean hasAnItem = false;

    public TilePopup(FreeColClient freeColClient, Tile tile) {
        super(Messages.message(tile.getSimpleLabel()));
        Component lastComponent;
        Settlement settlement;
        this.freeColClient = freeColClient;
        this.gui = freeColClient.getGUI();
        this.font = FontLibrary.getScaledFont("normal-bold-tiny");
        InGameController igc = freeColClient.getInGameController();
        Player player = freeColClient.getMyPlayer();
        Unit activeUnit = this.gui.getActiveUnit();
        if (activeUnit != null) {
            boolean owned = player != null && player.owns(activeUnit);
            Tile unitTile = activeUnit.getTile();
            if (owned && unitTile != null) {
                JMenuItem gotoMenuItem = null;
                if (activeUnit.isOffensiveUnit() && unitTile.isAdjacent(tile) && activeUnit.getMoveType(tile).isAttack()) {
                    gotoMenuItem = Utility.localizedMenuItem(activeUnit.getCombatLabel(tile));
                } else if (activeUnit.getSimpleMoveType(unitTile, tile).isLegal()) {
                    gotoMenuItem = Utility.localizedMenuItem("goToThisTile");
                }
                if (gotoMenuItem != null) {
                    gotoMenuItem.addActionListener(ae -> {
                        if (!freeColClient.currentPlayerIsMyPlayer()) {
                            return;
                        }
                        this.gui.performGoto(tile);
                    });
                    this.add(gotoMenuItem);
                }
                if (unitTile == tile) {
                    if (activeUnit.canMoveToHighSeas()) {
                        JMenuItem europeMenuItem = Utility.localizedMenuItem(StringTemplate.template("goToEurope"));
                        europeMenuItem.addActionListener(ae -> {
                            if (!freeColClient.currentPlayerIsMyPlayer()) {
                                return;
                            }
                            igc.moveTo(activeUnit, player.getEurope());
                        });
                        this.add(europeMenuItem);
                        this.hasAnItem = true;
                    }
                    JMenuItem ji = null;
                    if (activeUnit.checkSetState(Unit.UnitState.ACTIVE)) {
                        ji = Utility.localizedMenuItem("activateUnit");
                        ji.addActionListener(ae -> igc.changeState(activeUnit, Unit.UnitState.ACTIVE));
                        this.add(ji);
                        this.hasAnItem = true;
                    }
                    if (activeUnit.checkSetState(Unit.UnitState.FORTIFYING)) {
                        ji = Utility.localizedMenuItem("fortify");
                        ji.addActionListener(ae -> igc.changeState(activeUnit, Unit.UnitState.FORTIFYING));
                        this.add(ji);
                        this.hasAnItem = true;
                    }
                    if (activeUnit.checkSetState(Unit.UnitState.SKIPPED)) {
                        ji = Utility.localizedMenuItem("skip");
                        ji.addActionListener(ae -> igc.changeState(activeUnit, Unit.UnitState.SKIPPED));
                        this.add(ji);
                        this.hasAnItem = true;
                    }
                    if (activeUnit.canCarryTreasure() && activeUnit.canCashInTreasureTrain()) {
                        ji = Utility.localizedMenuItem("cashInTreasureTrain");
                        ji.addActionListener(ae -> igc.checkCashInTreasureTrain(activeUnit));
                        ji.setEnabled(true);
                        this.add(ji);
                        this.hasAnItem = true;
                    }
                    if (activeUnit.getDestination() != null) {
                        ji = Utility.localizedMenuItem("clearOrders");
                        ji.addActionListener(ae -> igc.clearOrders(activeUnit));
                        this.add(ji);
                        this.hasAnItem = true;
                    }
                }
            }
            if (this.hasAnItem) {
                this.addSeparator();
            }
        }
        if ((settlement = tile.getSettlement()) != null) {
            if (settlement.getOwner() == player) {
                this.addColony((Colony)settlement);
            } else if (settlement instanceof IndianSettlement) {
                this.addIndianSettlement((IndianSettlement)settlement);
            }
            if (this.hasAnItem) {
                this.addSeparator();
            }
        }
        this.addTile(tile);
        this.addSeparator();
        int lineCount = 0;
        int maxUnits = 9;
        JComponent currentMenu = this;
        boolean moreUnits = false;
        Unit firstUnit = tile.getFirstUnit();
        for (Unit u : CollectionUtils.sort(tile.getUnits(), Unit.typeRoleComparator)) {
            if (lineCount > maxUnits) {
                JMenu more = Utility.localizedMenu("more");
                more.setFont(more.getFont().deriveFont(2));
                more.setOpaque(false);
                currentMenu.add(more);
                currentMenu = more;
                moreUnits = true;
                lineCount = 0;
                maxUnits = 19;
            }
            lineCount += this.addUnit(currentMenu, u, !u.isDamaged(), false);
        }
        if (tile.getUnitCount() > 1 && player.owns(firstUnit)) {
            if (moreUnits) {
                this.addSeparator();
            }
            JMenuItem activateAllItem = Utility.localizedMenuItem(StringTemplate.template("activateAllUnits"));
            activateAllItem.addActionListener(ae -> {
                for (Unit unit : tile.getUnitList()) {
                    igc.clearOrders(unit);
                }
                this.gui.changeView(tile.getFirstUnit(), false);
            });
            this.add(activateAllItem);
        }
        if (FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.MENUS) && freeColClient.getFreeColServer() != null) {
            this.addDebugItems(freeColClient, tile);
        }
        if ((lastComponent = this.getComponent(this.getComponentCount() - 1)) instanceof JSeparator) {
            this.remove(lastComponent);
        }
    }

    private void addDebugItems(FreeColClient freeColClient, Tile tile) {
        Unit unit;
        Unit activeUnit;
        this.addSeparator();
        JMenu changeOwnership = new JMenu("Change ownership");
        changeOwnership.setOpaque(false);
        JMenu transportLists = new JMenu("Transport lists");
        transportLists.setOpaque(false);
        JMenu changeRole = new JMenu("Change role");
        changeRole.setOpaque(false);
        for (Unit unit2 : tile.getUnitList()) {
            JMenuItem toMenuItem = new JMenuItem(unit2.toString());
            toMenuItem.addActionListener(ae -> DebugUtils.changeOwnership(freeColClient, unit2));
            changeOwnership.add(toMenuItem);
            if (unit2.isCarrier()) {
                JMenuItem menuItem = new JMenuItem(unit2.toString());
                menuItem.addActionListener(ae -> DebugUtils.displayMission(freeColClient, unit2));
                transportLists.add(menuItem);
            }
            if (!unit2.isPerson()) continue;
            JMenuItem roleMenuItem = new JMenuItem(unit2.toString());
            roleMenuItem.addActionListener(ae -> DebugUtils.changeRole(freeColClient, unit2));
            changeRole.add(roleMenuItem);
        }
        if (transportLists.getItemCount() > 0) {
            this.add(transportLists);
        }
        if (tile.getColony() != null) {
            if (changeOwnership.getItemCount() > 0) {
                changeOwnership.addSeparator();
            }
            JMenuItem toMenuItem = new JMenuItem(tile.getColony().toString());
            Colony colony = tile.getColony();
            toMenuItem.addActionListener(ae -> DebugUtils.changeOwnership(freeColClient, colony));
            changeOwnership.add(toMenuItem);
            JMenuItem displayColonyPlan = new JMenuItem("Display Colony Plan");
            displayColonyPlan.addActionListener(ae -> DebugUtils.displayColonyPlan(freeColClient, colony));
            this.add(displayColonyPlan);
            JMenuItem applyDisaster = new JMenuItem("Apply Disaster");
            applyDisaster.addActionListener(ae -> DebugUtils.applyDisaster(freeColClient, colony));
            this.add(applyDisaster);
        }
        if (tile.getIndianSettlement() != null) {
            JMenuItem displayGoods = new JMenuItem("Examine Settlement");
            IndianSettlement is = tile.getIndianSettlement();
            displayGoods.addActionListener(ae -> DebugUtils.summarizeSettlement(freeColClient, is));
            this.add(displayGoods);
        }
        if (changeOwnership.getItemCount() > 0) {
            this.add(changeOwnership);
        }
        if (changeRole.getItemCount() > 0) {
            this.add(changeRole);
        }
        if (tile.hasLostCityRumour()) {
            JMenuItem rumourItem = new JMenuItem("Set Lost City Rumour type");
            rumourItem.setOpaque(false);
            rumourItem.addActionListener(ae -> DebugUtils.setRumourType(freeColClient, tile));
            this.add(rumourItem);
        }
        JMenuItem addu = new JMenuItem("Add unit");
        addu.setOpaque(false);
        addu.addActionListener(ae -> DebugUtils.addNewUnitToTile(freeColClient, tile));
        this.add(addu);
        if (!tile.isEmpty()) {
            JMenuItem adda = new JMenuItem("Reset moves");
            adda.setOpaque(false);
            List<Unit> tileUnits = tile.getUnitList();
            adda.addActionListener(ae -> DebugUtils.resetMoves(freeColClient, tileUnits));
            this.add(adda);
        }
        if ((activeUnit = this.gui.getActiveUnit()) != null && activeUnit.getTile() != null) {
            JMenuItem menuItem = new JMenuItem("Show search");
            menuItem.addActionListener(ae -> {
                if (!freeColClient.currentPlayerIsMyPlayer()) {
                    return;
                }
                Tile currTile = activeUnit.getTile();
                if (currTile == tile) {
                    return;
                }
                Map map = activeUnit.getGame().getMap();
                LogBuilder lb = new LogBuilder(512);
                PathNode path = activeUnit.findPath(activeUnit.getTile(), tile, activeUnit.getCarrier(), null, lb);
                this.gui.showInformationPanel(lb.toString());
                this.gui.setUnitPath(path);
                this.gui.refresh();
            });
            this.add(menuItem);
        }
        if ((unit = CollectionUtils.find(tile.getUnits(), u -> u.canCarryGoods() && u.hasSpaceLeft())) != null) {
            DebugUtils.addGoodsAdditionEntry(freeColClient, unit, this);
        }
        JMenuItem dumpItem = new JMenuItem("Dump tile");
        dumpItem.setOpaque(false);
        dumpItem.addActionListener(ae -> DebugUtils.dumpTile(freeColClient, tile));
        this.add(dumpItem);
    }

    private int addUnit(Container menu, Unit unit, boolean enabled, boolean indent) {
        StringTemplate occ = unit.getOccupationLabel(this.freeColClient.getMyPlayer(), true);
        String text = (indent ? "    " : "") + unit.getDescription(Unit.UnitLabelType.NATIONAL) + " (" + Messages.message(occ) + ")";
        JMenuItem menuItem = new JMenuItem(text);
        menuItem.setFont(this.font);
        menuItem.addActionListener(ae -> this.gui.changeView(unit, false));
        if (indent) {
            menuItem.setFont(menuItem.getFont().deriveFont(2));
        }
        menuItem.setEnabled(enabled);
        menu.add(menuItem);
        int lineCount = 1 + CollectionUtils.sum(unit.getUnits(), u -> this.addUnit(menu, (Unit)u, true, true));
        boolean hasGoods = false;
        for (Goods goods : unit.getGoodsList()) {
            text = (indent ? "         " : "     ") + Messages.message(goods.getLabel(true));
            menuItem = new JMenuItem(text);
            menuItem.setFont(menuItem.getFont().deriveFont(2));
            menuItem.setEnabled(false);
            menu.add(menuItem);
            ++lineCount;
            hasGoods = true;
        }
        if (hasGoods) {
            JMenuItem dumpItem = Utility.localizedMenuItem("dumpCargo");
            dumpItem.setAction(new UnloadAction(this.freeColClient, unit));
            dumpItem.setText(Messages.message("dumpCargo"));
            menu.add(dumpItem);
            ++lineCount;
        }
        this.hasAnItem = true;
        return lineCount;
    }

    private void addColony(Colony colony) {
        StringTemplate name = colony.getLocationLabelFor(this.freeColClient.getMyPlayer());
        JMenuItem menuItem = Utility.localizedMenuItem(name);
        menuItem.setFont(this.font);
        menuItem.addActionListener(ae -> this.gui.showColonyPanel(colony, null));
        this.add(menuItem);
        menuItem = Utility.localizedMenuItem("rename");
        menuItem.addActionListener(ae -> this.freeColClient.getInGameController().rename(colony));
        this.add(menuItem);
        this.hasAnItem = true;
    }

    private void addIndianSettlement(IndianSettlement is) {
        StringTemplate name = is.getLocationLabelFor(this.freeColClient.getMyPlayer());
        JMenuItem menuItem = Utility.localizedMenuItem(name);
        menuItem.setFont(this.font);
        menuItem.addActionListener(ae -> this.gui.showIndianSettlementPanel(is));
        this.add(menuItem);
        this.hasAnItem = true;
    }

    private void addTile(Tile tile) {
        JMenuItem menuItem = new JMenuItem(Messages.message(tile.getLabel()));
        if (tile.isExplored()) {
            menuItem.addActionListener(ae -> this.gui.showTilePanel(tile));
        }
        this.add(menuItem);
    }

    public boolean hasItem() {
        return this.getComponentCount() > 0;
    }
}

