/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import javax.swing.JPanel;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.FontLibrary;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.util.ImageUtils;

public class FreeColProgressBar
extends JPanel {
    private int min = 0;
    private int max = 100;
    private int value = 0;
    private int step = 0;
    private final GoodsType goodsType;
    private final Image image;
    private final Font font;

    public FreeColProgressBar(FreeColClient freeColClient, GoodsType goodsType) {
        this(freeColClient, goodsType, 0, 100, 0, 0);
    }

    public FreeColProgressBar(FreeColClient freeColClient, GoodsType goodsType, int min, int max) {
        this(freeColClient, goodsType, min, max, 0, 0);
    }

    public FreeColProgressBar(FreeColClient freeColClient, GoodsType goodsType, int min, int max, int value, int step) {
        ImageLibrary lib = freeColClient.getGUI().getFixedImageLibrary();
        int iconHeight = (int)((float)ImageLibrary.ICON_SIZE.height * lib.getScaleFactor() / 2.0f);
        this.min = min;
        this.max = max;
        this.value = value;
        this.step = step;
        this.goodsType = goodsType;
        this.image = goodsType == null ? null : lib.getGoodsTypeImage(goodsType, new Dimension(-1, iconHeight));
        this.font = FontLibrary.getScaledFont("simple-plain-tiny");
        int padding = (int)(5.0f * lib.getScaleFactor());
        int width = (int)(200.0f * lib.getScaleFactor());
        this.setBorder(Utility.PROGRESS_BORDER);
        this.setPreferredSize(new Dimension(width, iconHeight + padding));
    }

    public void update(int value, int step) {
        this.update(this.min, this.max, value, step);
    }

    private void update(int min, int max, int value, int step) {
        this.min = min;
        this.max = max;
        this.value = value;
        this.step = step;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        String turnsString;
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setFont(this.font);
        int width = this.getWidth() - this.getInsets().left - this.getInsets().right;
        int height = this.getHeight() - this.getInsets().top - this.getInsets().bottom;
        if (this.isOpaque()) {
            ImageUtils.drawTiledImage(ImageLibrary.getProgressBarBackground(), g, this, this.getInsets());
        }
        int dvalue = 0;
        if (this.value >= this.max) {
            dvalue = width;
        } else if (this.max > 0) {
            dvalue = width * this.value / this.max;
        }
        if (dvalue > 0) {
            if (dvalue > width) {
                dvalue = width;
            }
            g2d.setColor(new Color(0, 0, 0, 70));
            g2d.fillRect(this.getInsets().left, this.getInsets().top, dvalue, height);
        }
        int dstep = 0;
        if (this.max > 0 && (dstep = width * this.step / this.max) > 0) {
            if (dstep + dvalue > width) {
                dstep = width - dvalue;
            }
            g2d.setColor(new Color(0, 0, 0, 40));
            g2d.fillRect(this.getInsets().left + dvalue, this.getInsets().top, dstep, height);
        }
        String stepSignal = this.step < 0 ? "-" : "+";
        StringBuilder progress = new StringBuilder(32);
        progress.append(String.valueOf(this.value)).append(stepSignal).append(Math.abs(this.step)).append('/').append(this.max);
        if (this.max <= this.value) {
            turnsString = "0";
        } else if (this.step > 0) {
            int turns = (this.max - this.value) / this.step;
            if ((this.max - this.value) % this.step > 0) {
                ++turns;
            }
            turnsString = Integer.toString(turns);
        } else {
            turnsString = Messages.message("notApplicable");
        }
        Object t = StringTemplate.template("freeColProgressBar.turnsToComplete").addName("%number%", turnsString);
        progress.append(' ').append(Messages.message(t));
        int stringWidth = g2d.getFontMetrics().stringWidth(progress.toString());
        int stringHeight = g2d.getFontMetrics().getAscent() + g2d.getFontMetrics().getDescent();
        int restWidth = this.getWidth() - stringWidth;
        int iconWidth = 0;
        int iconHeight = 0;
        if (this.image != null) {
            iconWidth = this.image.getWidth(this);
            iconHeight = this.image.getHeight(this);
            g2d.drawImage(this.image, (restWidth -= iconWidth * 2) / 2, (this.getHeight() - iconHeight) / 2, null);
        }
        g2d.setColor(Color.BLACK);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.drawString(progress.toString(), (restWidth - iconWidth) / 2 + iconWidth * 2, this.getHeight() / 2 + stringHeight / 4);
        g2d.dispose();
    }
}

