/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.PanelUI;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.label.GoodsTypeLabel;
import net.sf.freecol.client.gui.panel.DefaultTransferHandler;
import net.sf.freecol.client.gui.panel.DragListener;
import net.sf.freecol.client.gui.panel.FreeColButton;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.GoodsTypePanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.client.gui.plaf.FreeColSelectedPanelUI;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.TradeLocation;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.model.TradeRouteStop;
import net.sf.freecol.common.util.CollectionUtils;

public final class TradeRouteInputPanel
extends FreeColPanel
implements ListSelectionListener {
    private static final Logger logger = Logger.getLogger(TradeRouteInputPanel.class.getName());
    public static final DataFlavor STOP_FLAVOR = new DataFlavor(TradeRouteStop.class, "Stop");
    private final TradeRoute newRoute;
    private TransferHandler transferHandler;
    private transient MouseListener dragListener;
    private DefaultListModel<TradeRouteStop> stopListModel;
    private JList<TradeRouteStop> stopList;
    private JTextField tradeRouteName;
    private JComboBox<String> destinationSelector;
    private JCheckBox messagesBox;
    private JButton addStopButton;
    private JButton removeStopButton;
    private AllGoodsTypesPanel allGoodsTypesPanel;
    private StopGoodsTypesPanel stopGoodsTypesPanel;

    public TradeRouteInputPanel(FreeColClient freeColClient, TradeRoute newRoute) {
        super(freeColClient, null, new MigLayout("wrap 4, fill", "[]20[fill]rel"));
        Game game = freeColClient.getGame();
        Player player = this.getMyPlayer();
        TradeRoute tradeRoute = (TradeRoute)newRoute.copy(game);
        this.newRoute = newRoute;
        this.transferHandler = new DefaultTransferHandler(freeColClient, this);
        this.dragListener = new DragListener(freeColClient, this);
        this.stopListModel = new DefaultListModel();
        for (TradeRouteStop stop : tradeRoute.getStopList()) {
            this.stopListModel.addElement(stop);
        }
        this.stopList = new JList<TradeRouteStop>(this.stopListModel);
        this.stopList.setCellRenderer(new StopRenderer());
        this.stopList.setDragEnabled(true);
        this.stopList.setTransferHandler(new StopListHandler());
        this.stopList.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\u007f') {
                    TradeRouteInputPanel.this.deleteCurrentlySelectedStops();
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        this.stopList.addListSelectionListener(this);
        JScrollPane tradeRouteView = new JScrollPane(this.stopList);
        JLabel nameLabel = Utility.localizedLabel("tradeRouteInputPanel.nameLabel");
        this.tradeRouteName = new JTextField(tradeRoute.getName());
        JLabel destinationLabel = Utility.localizedLabel("tradeRouteInputPanel.destinationLabel");
        this.destinationSelector = new JComboBox();
        this.destinationSelector.setRenderer(new DestinationCellRenderer());
        StringTemplate template = StringTemplate.template("tradeRouteInputPanel.allColonies");
        this.destinationSelector.addItem(Messages.message(template));
        if (player.getEurope() != null) {
            this.destinationSelector.addItem(player.getEurope().getId());
        }
        for (Colony colony : player.getColonyList()) {
            this.destinationSelector.addItem(colony.getId());
        }
        this.messagesBox = new JCheckBox(Messages.message("tradeRouteInputPanel.silence"));
        this.messagesBox.setSelected(tradeRoute.isSilent());
        this.messagesBox.addActionListener(ae -> tradeRoute.setSilent(this.messagesBox.isSelected()));
        this.addStopButton = Utility.localizedButton("tradeRouteInputPanel.addStop");
        this.addStopButton.addActionListener(ae -> this.addSelectedStops());
        this.removeStopButton = Utility.localizedButton("tradeRouteInputPanel.removeStop");
        this.removeStopButton.addActionListener(ae -> this.deleteCurrentlySelectedStops());
        List<GoodsType> gtl = this.getSpecification().getGoodsTypeList();
        this.allGoodsTypesPanel = new AllGoodsTypesPanel(CollectionUtils.transform(gtl, GoodsType::isStorable, gt -> this.buildCargoLabel((GoodsType)gt)));
        this.allGoodsTypesPanel.setTransferHandler(this.transferHandler);
        this.allGoodsTypesPanel.setEnabled(false);
        this.stopGoodsTypesPanel = new StopGoodsTypesPanel();
        this.stopGoodsTypesPanel.setTransferHandler(this.transferHandler);
        final FreeColButton cancelButton = Utility.localizedButton("cancel");
        cancelButton.setActionCommand("CANCEL");
        cancelButton.addActionListener(this);
        this.setEscapeAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TradeRouteInputPanel.this.cancelTradeRoute();
            }
        });
        this.add((Component)Utility.localizedHeader("tradeRouteInputPanel.editRoute", Utility.FONTSPEC_TITLE), "span, align center");
        this.add((Component)tradeRouteView, "span 1 5, grow");
        this.add(nameLabel);
        this.add((Component)this.tradeRouteName, "span");
        this.add(destinationLabel);
        this.add(this.destinationSelector, "span");
        this.add(this.messagesBox);
        this.add(this.addStopButton);
        this.add((Component)this.removeStopButton, "span");
        this.add((Component)this.allGoodsTypesPanel, "span");
        int iconHeight = (int)(80.0f * this.getImageLibrary().getScaleFactor());
        this.add((Component)this.stopGoodsTypesPanel, "span, height " + iconHeight + "px:, growy");
        this.add((Component)this.okButton, "newline 20, span, split 2, tag ok");
        this.add((Component)cancelButton, "tag cancel");
        this.setEscapeAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                cancelButton.doClick();
            }
        });
        if (this.stopListModel.getSize() > 0) {
            this.stopList.setSelectedIndex(0);
            this.updateCargoPanel(this.stopListModel.firstElement());
        }
        this.updateButtons();
        this.getGUI().restoreSavedSize(this, this.getPreferredSize());
    }

    private void updateCargoPanel(TradeRouteStop stop) {
        this.stopGoodsTypesPanel.setLabels(stop == null ? null : CollectionUtils.transform(stop.getCargo(), GoodsType::isStorable, gt -> this.buildCargoLabel((GoodsType)gt)));
    }

    private void enableImport(GoodsType gt) {
        if (gt == null) {
            return;
        }
        for (int stopIndex : this.stopList.getSelectedIndices()) {
            TradeRouteStop stop = this.stopListModel.get(stopIndex);
            stop.addCargo(gt);
            int[] idx = this.stopList.getSelectedIndices();
            if (idx.length <= 0) continue;
            this.updateCargoPanel(this.stopListModel.get(idx[0]));
        }
        this.stopList.revalidate();
        this.stopList.repaint();
    }

    private void cancelImport(GoodsTypeLabel gtl) {
        this.stopGoodsTypesPanel.remove(gtl);
        GoodsType gt = gtl.getType();
        for (int stopIndex : this.stopList.getSelectedIndices()) {
            TradeRouteStop stop = this.stopListModel.get(stopIndex);
            ArrayList<GoodsType> cargo = new ArrayList<GoodsType>(stop.getCargo());
            int cargoIndex = cargo.indexOf(gt);
            if (cargoIndex < 0) continue;
            cargo.remove(cargoIndex);
            stop.setCargo(cargo);
        }
        this.stopList.revalidate();
        this.stopList.repaint();
        this.stopGoodsTypesPanel.revalidate();
        this.stopGoodsTypesPanel.repaint();
    }

    private void addSelectedStops() {
        int startIndex = -1;
        int endIndex = -1;
        int sel = this.destinationSelector.getSelectedIndex();
        if (sel == 0) {
            startIndex = 1;
            endIndex = this.destinationSelector.getItemCount();
        } else {
            startIndex = sel;
            endIndex = startIndex + 1;
        }
        List<GoodsType> cargo = CollectionUtils.transform(this.stopGoodsTypesPanel.getComponents(), c -> c instanceof GoodsTypeLabel, c -> ((GoodsTypeLabel)c).getType());
        int maxIndex = this.stopList.getMaxSelectionIndex();
        for (int i = startIndex; i < endIndex; ++i) {
            String id = this.destinationSelector.getItemAt(i);
            FreeColGameObject fcgo = this.getGame().getFreeColGameObject(id);
            if (!(fcgo instanceof Location)) continue;
            TradeRouteStop stop = new TradeRouteStop(this.getGame(), (Location)((Object)fcgo));
            stop.setCargo(cargo);
            if (maxIndex < 0) {
                this.stopListModel.addElement(stop);
                continue;
            }
            this.stopListModel.add(++maxIndex, stop);
        }
    }

    private GoodsTypeLabel buildCargoLabel(GoodsType gt) {
        GoodsTypeLabel label = new GoodsTypeLabel(this.getFreeColClient(), gt);
        label.setTransferHandler(this.transferHandler);
        label.addMouseListener(this.dragListener);
        return label;
    }

    private void deleteCurrentlySelectedStops() {
        int count = 0;
        int lastIndex = 0;
        for (int index : this.stopList.getSelectedIndices()) {
            this.stopListModel.remove(index - count);
            ++count;
            lastIndex = index;
        }
        if (this.stopListModel.getSize() > 0) {
            this.stopList.setSelectedIndex(lastIndex - count + 1);
        }
    }

    public void cancelTradeRoute() {
        this.newRoute.setName(null);
        this.getGUI().removeComponent(this);
    }

    private void updateButtons() {
        this.addStopButton.setEnabled(this.stopListModel.getSize() < this.destinationSelector.getItemCount() - 1);
        this.removeStopButton.setEnabled(this.stopList.getSelectedIndices().length > 0);
    }

    private boolean verifyNewTradeRoute() {
        this.newRoute.setName(this.tradeRouteName.getText());
        this.newRoute.clearStops();
        for (int index = 0; index < this.stopListModel.getSize(); ++index) {
            this.newRoute.addStop(this.stopListModel.get(index));
        }
        this.newRoute.setSilent(this.messagesBox.isSelected());
        StringTemplate err = this.newRoute.verify();
        if (err != null) {
            this.getGUI().showInformationPanel(err);
            this.newRoute.setName(null);
            return false;
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        if (command == null) {
            return;
        }
        switch (command) {
            case "OK": {
                if (!this.verifyNewTradeRoute()) {
                    return;
                }
                super.actionPerformed(ae);
                break;
            }
            case "CANCEL": {
                this.cancelTradeRoute();
                break;
            }
            default: {
                super.actionPerformed(ae);
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        int[] idx = this.stopList.getSelectedIndices();
        if (idx.length > 0) {
            this.updateCargoPanel(this.stopListModel.get(idx[0]));
            this.allGoodsTypesPanel.setEnabled(true);
        } else {
            this.allGoodsTypesPanel.setEnabled(false);
        }
        this.updateButtons();
    }

    @Override
    public void removeNotify() {
        this.transferHandler = null;
        this.dragListener = null;
        this.stopListModel.clear();
        this.stopListModel = null;
        this.stopList = null;
        this.tradeRouteName = null;
        this.destinationSelector = null;
        this.messagesBox = null;
        this.addStopButton = null;
        this.removeStopButton = null;
        this.stopGoodsTypesPanel = null;
        this.allGoodsTypesPanel = null;
        super.removeNotify();
    }

    private class StopRenderer
    implements ListCellRenderer<TradeRouteStop> {
        private final JPanel SELECTED_COMPONENT = new JPanel();
        private final JPanel NORMAL_COMPONENT = new JPanel();

        public StopRenderer() {
            this.NORMAL_COMPONENT.setLayout(new MigLayout("", "[center][]"));
            this.NORMAL_COMPONENT.setOpaque(false);
            this.SELECTED_COMPONENT.setLayout(new MigLayout("", "[center][]"));
            this.SELECTED_COMPONENT.setOpaque(false);
            this.SELECTED_COMPONENT.setUI((PanelUI)FreeColSelectedPanelUI.createUI(this.SELECTED_COMPONENT));
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends TradeRouteStop> list, TradeRouteStop value, int index, boolean isSelected, boolean hasFocus) {
            ImageIcon ii;
            TradeLocation tl;
            JPanel panel = isSelected ? this.SELECTED_COMPONENT : this.NORMAL_COMPONENT;
            panel.removeAll();
            panel.setForeground(list.getForeground());
            panel.setFont(list.getFont());
            Location location = value.getLocation();
            ImageLibrary lib = TradeRouteInputPanel.this.getImageLibrary();
            if (location instanceof TradeLocation) {
                tl = (TradeLocation)((Object)location);
                if (!tl.canBeInput()) {
                    throw new IllegalStateException("Bogus location: " + location);
                }
            } else {
                throw new IllegalStateException("Bogus location: " + location);
            }
            JLabel name = tl.getNameAsJlabel();
            if (location instanceof Europe) {
                Player owner = ((Europe)location).getOwner();
                ii = new ImageIcon(lib.getSmallerNationImage(owner.getNation()));
            } else if (location instanceof Colony) {
                Colony colony = (Colony)location;
                ii = new ImageIcon(lib.getSmallerSettlementImage(colony));
            } else {
                throw new IllegalStateException("Bogus location: " + location);
            }
            name.setVerticalTextPosition(0);
            int width = (int)(80.0f * TradeRouteInputPanel.this.getImageLibrary().getScaleFactor());
            int height = (int)(60.0f * TradeRouteInputPanel.this.getImageLibrary().getScaleFactor());
            panel.add((Component)new JLabel(ii), "spany, width " + width + ", height " + height);
            panel.add((Component)name, "span, wrap");
            for (GoodsType cargo : value.getCargo()) {
                ii = new ImageIcon(lib.getSmallerGoodsTypeImage(cargo));
                panel.add(new JLabel(ii));
            }
            return panel;
        }
    }

    private class StopListHandler
    extends TransferHandler {
        private StopListHandler() {
        }

        @Override
        public boolean canImport(JComponent c, DataFlavor[] flavors) {
            return CollectionUtils.any(flavors, CollectionUtils.matchKeyEquals(STOP_FLAVOR));
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            JList list = (JList)c;
            DefaultListModel model = (DefaultListModel)list.getModel();
            int[] indicies = list.getSelectedIndices();
            ArrayList<TradeRouteStop> stops = new ArrayList<TradeRouteStop>(indicies.length);
            for (int i : indicies) {
                stops.add((TradeRouteStop)model.get(i));
            }
            return new StopListTransferable(stops);
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 2;
        }

        @Override
        public boolean importData(JComponent target, Transferable data) {
            JList<TradeRouteStop> stl = TradeRouteInputPanel.this.stopList;
            try {
                if (target == stl && this.canImport(target, data.getTransferDataFlavors())) {
                    List stops = (List)data.getTransferData(STOP_FLAVOR);
                    DefaultListModel<TradeRouteStop> newModel = new DefaultListModel<TradeRouteStop>();
                    int targetIndex = stl.getMaxSelectionIndex();
                    List<TradeRouteStop> oldList = this.getAllValues(stl);
                    if (targetIndex < 0) {
                        oldList.removeAll(stops);
                        newModel.addAll(oldList);
                        newModel.addAll(stops);
                    } else {
                        ArrayList<TradeRouteStop> beforeList = new ArrayList<TradeRouteStop>(oldList.subList(0, targetIndex));
                        beforeList.removeAll(stops);
                        ArrayList<TradeRouteStop> afterList = new ArrayList<TradeRouteStop>(oldList.subList(targetIndex, oldList.size()));
                        afterList.removeAll(stops);
                        newModel.addAll(beforeList);
                        newModel.addAll(stops);
                        newModel.addAll(afterList);
                    }
                    TradeRouteInputPanel.this.stopListModel = newModel;
                    stl.setModel(newModel);
                    if (targetIndex < 0) {
                        stl.setSelectedIndex(newModel.getSize() - 1);
                    } else {
                        stl.setSelectedIndex(targetIndex);
                    }
                    stl.invalidate();
                    stl.repaint();
                    return true;
                }
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Drag&drop failed.", e);
                return false;
            }
            catch (UnsupportedFlavorException e) {
                logger.log(Level.WARNING, "Drag&drop failed.", e);
                return false;
            }
            catch (RuntimeException e) {
                logger.log(Level.WARNING, "Drag&drop failed.", e);
                throw e;
            }
            return false;
        }

        private List<TradeRouteStop> getAllValues(JList<TradeRouteStop> jList) {
            ArrayList<TradeRouteStop> oldList = new ArrayList<TradeRouteStop>();
            for (int i = 0; i < jList.getModel().getSize(); ++i) {
                oldList.add(jList.getModel().getElementAt(i));
            }
            return oldList;
        }

        @Override
        protected void exportDone(JComponent source, Transferable data, int action) {
        }
    }

    private static class StopListTransferable
    implements Transferable {
        private final List<TradeRouteStop> stops;

        public StopListTransferable(List<TradeRouteStop> stops) {
            this.stops = stops;
        }

        public List<TradeRouteStop> getStops() {
            return this.stops;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) {
            return flavor == STOP_FLAVOR ? this.stops : null;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{STOP_FLAVOR};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor == STOP_FLAVOR;
        }
    }

    private class StopGoodsTypesPanel
    extends GoodsTypePanel {
        public StopGoodsTypesPanel() {
            super(new MigLayout("wrap 10"), false);
        }

        @Override
        public Component add(Component comp, boolean editState) {
            if (comp instanceof GoodsTypeLabel) {
                GoodsTypeLabel dndComp = (GoodsTypeLabel)comp;
                Component newComp = super.add((Component)new GoodsTypeLabel(dndComp), editState);
                TradeRouteInputPanel.this.enableImport(dndComp.getType());
                this.revalidate();
                this.repaint();
                return newComp;
            }
            return super.add(comp);
        }
    }

    private class AllGoodsTypesPanel
    extends GoodsTypePanel {
        private List<GoodsTypeLabel> labels;

        public AllGoodsTypesPanel(List<GoodsTypeLabel> labels) {
            super(new GridLayout(0, 4, 3, 3), true);
            this.labels = labels;
            this.setOpaque(false);
            this.setBorder(Utility.localizedBorder("goods"));
            this.reset();
        }

        public void reset() {
            this.setLabels(this.labels);
        }

        @Override
        public void setEnabled(boolean enable) {
            super.setEnabled(enable);
            for (Component child : this.getComponents()) {
                if (!(child instanceof GoodsTypeLabel)) continue;
                child.setEnabled(enable);
            }
        }

        @Override
        public Component add(Component comp, boolean editState) {
            if (comp instanceof GoodsTypeLabel) {
                GoodsTypeLabel gtl = (GoodsTypeLabel)comp;
                TradeRouteInputPanel.this.cancelImport(gtl);
                return comp;
            }
            return super.add(comp);
        }
    }

    private class DestinationCellRenderer
    extends JLabel
    implements ListCellRenderer<String> {
        public DestinationCellRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends String> list, String value, int index, boolean isSelected, boolean cellHasFocus) {
            FreeColGameObject fcgo = TradeRouteInputPanel.this.getGame().getFreeColGameObject(value);
            if (fcgo instanceof Location) {
                this.setText(Messages.message(((Location)((Object)fcgo)).getLocationLabel()));
            } else {
                this.setText(value);
            }
            this.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
            this.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
            return this;
        }
    }
}

