/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.debug;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.common.io.FreeColDirectories;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.common.util.StringUtils;
import net.sf.freecol.server.FreeColServer;

public class FreeColDebugger {
    private static final Logger logger = Logger.getLogger(FreeColDebugger.class.getName());
    private static int debugMode = 0;
    private static int debugRunTurns = -1;
    private static String debugRunSave = null;
    private static boolean normalGameFogOfWar = false;
    private static boolean debugRendering = false;
    private static boolean displayCoordinates = false;
    private static Player displayColonyValuePlayer = null;
    private static boolean showMission = false;
    private static boolean showMissionInfo = false;
    private static final AtomicReference<PrintStream> debugStream = new AtomicReference<Object>(null);
    private static Player defenceMapPlayer = null;

    public static boolean isInDebugMode() {
        return debugMode != 0;
    }

    public static boolean isInDebugMode(DebugMode mode) {
        return (1 << mode.ordinal() & debugMode) != 0;
    }

    public static void setDebugMode(DebugMode mode, boolean val) {
        if (val) {
            FreeColDebugger.enableDebugMode(mode);
        } else {
            FreeColDebugger.disableDebugMode(mode);
        }
    }

    public static void enableDebugMode(DebugMode mode) {
        debugMode |= 1 << mode.ordinal();
    }

    private static void disableDebugMode(DebugMode mode) {
        if (mode != DebugMode.MENUS) {
            debugMode &= ~(1 << mode.ordinal());
        }
    }

    public static String getDebugModes() {
        return CollectionUtils.transform(DebugMode.values(), m -> FreeColDebugger.isInDebugMode(m), Enum::toString, Collectors.joining(","));
    }

    public static boolean setDebugModes(String optionValue) {
        if (optionValue == null) {
            return false;
        }
        if (optionValue.isEmpty()) {
            return true;
        }
        for (String s : optionValue.split(",")) {
            try {
                DebugMode mode = Enum.valueOf(DebugMode.class, StringUtils.upCase(s));
                FreeColDebugger.enableDebugMode(mode);
            }
            catch (RuntimeException e) {
                logger.warning("Unrecognized debug mode: " + optionValue);
                return false;
            }
        }
        return true;
    }

    public static void configureDebugRun(String option) {
        int comma = option.indexOf(44);
        String turns = option.substring(0, comma < 0 ? option.length() : comma);
        try {
            FreeColDebugger.setDebugRunTurns(Integer.parseInt(turns));
        }
        catch (NumberFormatException e) {
            FreeColDebugger.setDebugRunTurns(-1);
        }
        if (comma > 0) {
            FreeColDebugger.setDebugRunSave(option.substring(comma + 1));
        }
    }

    public static int getDebugRunTurns() {
        return debugRunTurns;
    }

    public static void setDebugRunTurns(int debugRunTurns) {
        FreeColDebugger.debugRunTurns = debugRunTurns;
    }

    public static String getDebugRunSave() {
        return debugRunSave;
    }

    public static void setDebugRunSave(String debugRunSave) {
        FreeColDebugger.debugRunSave = debugRunSave;
    }

    public static boolean getNormalGameFogOfWar() {
        return normalGameFogOfWar;
    }

    public static void setNormalGameFogOfWar(boolean normalGameFogOfWar) {
        FreeColDebugger.normalGameFogOfWar = normalGameFogOfWar;
    }

    public static boolean finishDebugRun(FreeColClient freeColClient, boolean force) {
        int turns = FreeColDebugger.getDebugRunTurns();
        if (turns < 0 || turns > 0 && !force) {
            return false;
        }
        FreeColDebugger.setDebugRunTurns(-1);
        if (FreeColDebugger.getDebugRunSave() != null) {
            FreeColServer fcs = freeColClient.getFreeColServer();
            if (fcs != null) {
                try {
                    fcs.saveGame(FreeColDirectories.getDebugRunSaveFile(), freeColClient.getClientOptions(), null);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            freeColClient.quit();
        }
        return true;
    }

    public static void signalEndDebugRun() {
        if (debugRunTurns > 0) {
            FreeColDebugger.setDebugRunTurns(0);
        }
    }

    public static boolean debugRendering() {
        return debugRendering;
    }

    public static void setDebugRendering(boolean _debugRendering) {
        debugRendering = _debugRendering;
    }

    public static boolean debugDisplayCoordinates() {
        return displayCoordinates;
    }

    public static void setDebugDisplayCoordinates(boolean display) {
        displayCoordinates = display;
    }

    public static Player debugDisplayColonyValuePlayer() {
        return displayColonyValuePlayer;
    }

    public static void setDebugDisplayColonyValuePlayer(Player display) {
        displayColonyValuePlayer = display;
    }

    public static boolean debugShowMission() {
        return showMission;
    }

    public static void setDebugShowMission(boolean display) {
        showMission = display;
    }

    public static boolean debugShowMissionInfo() {
        return showMissionInfo;
    }

    public static void setDebugShowMissionInfo(boolean display) {
        showMissionInfo = display;
    }

    public static void setDebugShowDefenceMapForPlayer(Player defenceMapPlayer) {
        FreeColDebugger.defenceMapPlayer = defenceMapPlayer;
    }

    public static Player debugShowDefenceMapForPlayer() {
        return defenceMapPlayer;
    }

    public static void handleCrash() {
        if (debugRunSave != null) {
            FreeColDebugger.signalEndDebugRun();
        }
    }

    public static void debugLog(String msg) {
        PrintStream print = debugStream.get();
        if (print == null) {
            String tmp = System.getenv("TMPDIR");
            if (tmp == null) {
                tmp = "/tmp";
            }
            Path path = Paths.get(tmp, "freecol.debug");
            try {
                OutputStream fos = Files.newOutputStream(path, StandardOpenOption.CREATE, StandardOpenOption.APPEND);
                print = new PrintStream(fos, true, "UTF-8");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            debugStream.set(print);
        }
        if (print != null) {
            print.println(msg);
        }
    }

    public static String stackTraceToString() {
        return FreeColDebugger.stackTraceToString(Thread.currentThread());
    }

    private static String stackTraceToString(Thread thread) {
        LogBuilder lb = new LogBuilder(512);
        FreeColDebugger.addStackTrace(lb, thread);
        return lb.toString();
    }

    public static void addStackTrace(LogBuilder lb) {
        FreeColDebugger.addStackTrace(lb, Thread.currentThread());
    }

    private static void addStackTrace(LogBuilder lb, Thread thread) {
        for (StackTraceElement s : thread.getStackTrace()) {
            lb.add(s.toString(), "\n");
        }
        lb.shrink("\n");
    }

    public static void trace(Logger logger, String warn) {
        LogBuilder lb = new LogBuilder(512);
        lb.add(warn, "\n");
        FreeColDebugger.addStackTrace(lb);
        if (logger == null) {
            System.err.println(lb.toString());
        } else {
            logger.warning(lb.toString());
        }
    }

    public static enum DebugMode {
        COMMS,
        DESYNC,
        MENUS,
        INIT,
        PATHS;

    }
}

