/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.io;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.freecol.common.io.FreeColDirectories;
import net.sf.freecol.common.io.FreeColModFile;

public class FreeColRules {
    private static final Logger logger = Logger.getLogger(FreeColRules.class.getName());
    private static final Map<String, FreeColModFile> allRules = new HashMap<String, FreeColModFile>();

    public static List<FreeColModFile> getRulesList() {
        ArrayList<FreeColModFile> ret = new ArrayList<FreeColModFile>();
        for (File f : FreeColDirectories.getRulesFileList()) {
            try {
                ret.add(new FreeColModFile(f));
            }
            catch (IOException ioe) {
                logger.log(Level.WARNING, "Failed to load TC from: " + f, ioe);
            }
        }
        return ret;
    }

    public static void loadRules() {
        if (allRules.isEmpty()) {
            for (FreeColModFile fctf : FreeColRules.getRulesList()) {
                allRules.put(fctf.getId(), fctf);
            }
        }
    }

    public static FreeColModFile getFreeColRulesFile(String id) {
        return allRules.get(id);
    }
}

