/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.networking.AttributeMessage;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.model.ServerPlayer;

public class DeleteTradeRouteMessage
extends AttributeMessage {
    public static final String TAG = "deleteTradeRoute";
    private static final String TRADE_ROUTE_TAG = "tradeRoute";

    public DeleteTradeRouteMessage(TradeRoute tradeRoute) {
        super(TAG, TRADE_ROUTE_TAG, tradeRoute.getId());
    }

    public DeleteTradeRouteMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(TAG, xr, TRADE_ROUTE_TAG);
    }

    @Override
    public boolean currentPlayerMessage() {
        return true;
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.NORMAL;
    }

    @Override
    public void aiHandler(FreeColServer freeColServer, AIPlayer aiPlayer) {
    }

    @Override
    public ChangeSet serverHandler(FreeColServer freeColServer, ServerPlayer serverPlayer) {
        TradeRoute tradeRoute;
        String tradeRouteId = this.getStringAttribute(TRADE_ROUTE_TAG);
        try {
            tradeRoute = serverPlayer.getOurFreeColGameObject(tradeRouteId, TradeRoute.class);
        }
        catch (Exception e) {
            return serverPlayer.clientError(e.getMessage());
        }
        return this.igc(freeColServer).deleteTradeRoute(serverPlayer, tradeRoute);
    }
}

