/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.resources;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import net.sf.freecol.common.resources.AudioResource;
import net.sf.freecol.common.resources.ColorResource;
import net.sf.freecol.common.resources.FAFileResource;
import net.sf.freecol.common.resources.FontResource;
import net.sf.freecol.common.resources.ImageResource;
import net.sf.freecol.common.resources.Resource;
import net.sf.freecol.common.resources.SZAResource;
import net.sf.freecol.common.resources.StringResource;
import net.sf.freecol.common.resources.VideoResource;

public final class ResourceMapping {
    private static final Logger logger = Logger.getLogger(ResourceMapping.class.getName());
    private final Map<String, ColorResource> colorResources = new HashMap<String, ColorResource>();
    private final Map<String, FontResource> fontResources = new HashMap<String, FontResource>();
    private final Map<String, StringResource> stringResources = new HashMap<String, StringResource>();
    private final Map<String, FAFileResource> fafResources = new HashMap<String, FAFileResource>();
    private final Map<String, SZAResource> szaResources = new HashMap<String, SZAResource>();
    private final Map<String, AudioResource> audioResources = new HashMap<String, AudioResource>();
    private final Map<String, VideoResource> videoResources = new HashMap<String, VideoResource>();
    private final Map<String, ImageResource> imageResources = new HashMap<String, ImageResource>();
    private final Map<Class<?>, ResourceType<?>> resourceTypes = ResourceMapping.mapFrom(new ResourceType<ColorResource>(ColorResource.class, "color.", this.colorResources), new ResourceType<FontResource>(FontResource.class, "font.", this.fontResources), new ResourceType<StringResource>(StringResource.class, null, this.stringResources), new ResourceType<FAFileResource>(FAFileResource.class, "animatedfont.", this.fafResources), new ResourceType<SZAResource>(SZAResource.class, "animation.", this.szaResources), new ResourceType<AudioResource>(AudioResource.class, "sound.", this.audioResources), new ResourceType<VideoResource>(VideoResource.class, "video.", this.videoResources), new ResourceType<ImageResource>(ImageResource.class, "image.", this.imageResources));

    public boolean add(String key, Resource resource) {
        ResourceType<?> resourceType = this.resourceTypes.get(resource.getClass());
        return resourceType.put(key, resource);
    }

    public boolean duplicateResource(String key, String keyNew) {
        ColorResource cr = this.colorResources.get(key);
        if (cr != null) {
            return this.add(keyNew, cr);
        }
        FontResource fr = this.fontResources.get(key);
        if (fr != null) {
            return this.add(keyNew, fr);
        }
        StringResource sr = this.stringResources.get(key);
        if (sr != null) {
            return this.add(keyNew, sr);
        }
        FAFileResource far = this.fafResources.get(key);
        if (far != null) {
            return this.add(keyNew, far);
        }
        SZAResource szr = this.szaResources.get(key);
        if (szr != null) {
            return this.add(keyNew, szr);
        }
        AudioResource ar = this.audioResources.get(key);
        if (ar != null) {
            return this.add(keyNew, ar);
        }
        VideoResource vr = this.videoResources.get(key);
        if (vr != null) {
            return this.add(keyNew, vr);
        }
        ImageResource ir = this.imageResources.get(key);
        if (ir != null) {
            return this.add(keyNew, ir);
        }
        return false;
    }

    public void addAll(ResourceMapping rc) {
        if (rc == null) {
            return;
        }
        this.colorResources.putAll(rc.colorResources);
        this.fontResources.putAll(rc.fontResources);
        this.stringResources.putAll(rc.stringResources);
        this.fafResources.putAll(rc.fafResources);
        this.szaResources.putAll(rc.szaResources);
        this.audioResources.putAll(rc.audioResources);
        this.videoResources.putAll(rc.videoResources);
        this.imageResources.putAll(rc.imageResources);
    }

    public AudioResource getAudioResource(String key) {
        return this.audioResources.get(key);
    }

    public ColorResource getColorResource(String key) {
        return this.colorResources.get(key);
    }

    public FAFileResource getFAFileResource(String key) {
        return this.fafResources.get(key);
    }

    public FontResource getFontResource(String key) {
        return this.fontResources.get(key);
    }

    public ImageResource getImageResource(String key) {
        return this.imageResources.get(key);
    }

    public StringResource getStringResource(String key) {
        return this.stringResources.get(key);
    }

    public SZAResource getSZAResource(String key) {
        return this.szaResources.get(key);
    }

    public VideoResource getVideoResource(String key) {
        return this.videoResources.get(key);
    }

    public Set<String> getImageKeySet() {
        return this.imageResources.keySet();
    }

    public int preload(PreloadController preloadController) {
        int ret = 0;
        for (Resource resource : this.colorResources.values()) {
            if (!preloadController.shouldContinue()) {
                return ret;
            }
            resource.preload();
            ++ret;
        }
        for (Resource resource : this.fontResources.values()) {
            if (!preloadController.shouldContinue()) {
                return ret;
            }
            resource.preload();
            ++ret;
        }
        for (Resource resource : this.stringResources.values()) {
            if (!preloadController.shouldContinue()) {
                return ret;
            }
            resource.preload();
            ++ret;
        }
        for (Resource resource : this.videoResources.values()) {
            if (!preloadController.shouldContinue()) {
                return ret;
            }
            resource.preload();
            ++ret;
        }
        for (Resource resource : this.imageResources.values()) {
            if (!preloadController.shouldContinue()) {
                return ret;
            }
            resource.preload();
            ++ret;
        }
        for (Resource resource : this.fafResources.values()) {
            if (!preloadController.shouldContinue()) {
                return ret;
            }
            resource.preload();
            ++ret;
        }
        for (Resource resource : this.szaResources.values()) {
            if (!preloadController.shouldContinue()) {
                return ret;
            }
            resource.preload();
            ++ret;
        }
        for (Resource resource : this.audioResources.values()) {
            if (!preloadController.shouldContinue()) {
                return ret;
            }
            resource.preload();
            ++ret;
        }
        return ret;
    }

    public void clearCaches() {
        this.imageResources.values().stream().forEach(r -> r.clean());
    }

    private static final Map<Class<?>, ResourceType<?>> mapFrom(ResourceType<?> ... resourceTypes) {
        HashMap map = new HashMap();
        for (ResourceType<?> r : resourceTypes) {
            map.put(r.clazz, r);
        }
        return map;
    }

    private static class ResourceType<T> {
        private final Class<T> clazz;
        private final String requiredKeyPrefix;
        private final Map<String, T> resources;

        public ResourceType(Class<T> clazz, String requiredKeyPrefix, Map<String, T> resources) {
            this.clazz = clazz;
            this.requiredKeyPrefix = requiredKeyPrefix;
            this.resources = resources;
        }

        boolean put(String key, Object resource) {
            if (this.requiredKeyPrefix != null && !key.startsWith(this.requiredKeyPrefix)) {
                logger.warning("Rejecting malformed resource key: \"" + key + "\". The key should have started with: \"" + this.requiredKeyPrefix + "\".");
                return false;
            }
            this.resources.put(key, this.clazz.cast(resource));
            return true;
        }
    }

    public static interface PreloadController {
        public boolean shouldContinue();
    }
}

