/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTradeItem;
import net.sf.freecol.common.model.Constants;
import net.sf.freecol.common.model.DiplomaticTrade;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Feature;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoldTradeItem;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.HistoryEvent;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.NationSummary;
import net.sf.freecol.common.model.NativeTrade;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Stance;
import net.sf.freecol.common.model.StanceTradeItem;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TradeItem;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.pathfinding.CostDeciders;
import net.sf.freecol.common.model.pathfinding.GoalDeciders;
import net.sf.freecol.common.util.CachingFunction;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.common.util.RandomChoice;
import net.sf.freecol.common.util.RandomUtils;
import net.sf.freecol.server.ai.AIColony;
import net.sf.freecol.server.ai.AIGoods;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIMessage;
import net.sf.freecol.server.ai.AIObject;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.Cargo;
import net.sf.freecol.server.ai.GoodsWish;
import net.sf.freecol.server.ai.MissionAIPlayer;
import net.sf.freecol.server.ai.TileImprovementPlan;
import net.sf.freecol.server.ai.TransportableAIObject;
import net.sf.freecol.server.ai.ValuedAIObject;
import net.sf.freecol.server.ai.Wish;
import net.sf.freecol.server.ai.WorkerWish;
import net.sf.freecol.server.ai.military.MilitaryCoordinator;
import net.sf.freecol.server.ai.mission.BuildColonyMission;
import net.sf.freecol.server.ai.mission.CashInTreasureTrainMission;
import net.sf.freecol.server.ai.mission.DefendSettlementMission;
import net.sf.freecol.server.ai.mission.IdleAtSettlementMission;
import net.sf.freecol.server.ai.mission.Mission;
import net.sf.freecol.server.ai.mission.MissionaryMission;
import net.sf.freecol.server.ai.mission.PioneeringMission;
import net.sf.freecol.server.ai.mission.PrivateerMission;
import net.sf.freecol.server.ai.mission.ScoutingMission;
import net.sf.freecol.server.ai.mission.TransportMission;
import net.sf.freecol.server.ai.mission.UnitSeekAndDestroyMission;
import net.sf.freecol.server.ai.mission.UnitWanderHostileMission;
import net.sf.freecol.server.ai.mission.WishRealizationMission;
import net.sf.freecol.server.ai.mission.WorkInsideColonyMission;
import net.sf.freecol.server.model.ServerPlayer;

public class EuropeanAIPlayer
extends MissionAIPlayer {
    private static final Logger logger = Logger.getLogger(EuropeanAIPlayer.class.getName());
    private static final Predicate<Unit> equipPred = u -> u.hasDefaultRole() && u.hasAbility("model.ability.canBeEquipped");
    private static final Predicate<Modifier> partyPred = CollectionUtils.matchKey(Specification.COLONY_GOODS_PARTY_SOURCE, Feature::getSource);
    private static final int buildingRange = 5;
    private static final int cashInRange = 20;
    private static final int missionaryRange = 20;
    private static final int pioneeringRange = 10;
    private static final int privateerRange = 1;
    private static final int scoutingRange = 20;
    private static final Comparator<AIUnit> builderComparator = Comparator.comparingInt(AIUnit::getBuilderScore).reversed();
    public static final Comparator<AIUnit> pioneerComparator = Comparator.comparingInt(AIUnit::getPioneerScore).reversed();
    public static final Comparator<AIUnit> scoutComparator = Comparator.comparingInt(AIUnit::getScoutScore).reversed();
    private static int liftBoycottCheatPercent;
    private static int equipScoutCheatPercent;
    private static int equipPioneerCheatPercent;
    private static int landUnitCheatPercent;
    private static int offensiveLandUnitCheatPercent;
    private static int offensiveNavalUnitCheatPercent;
    private static int transportNavalUnitCheatPercent;
    private static Role pioneerRole;
    private static Role scoutRole;
    private final java.util.Map<Tile, TileImprovementPlan> tipMap = new HashMap<Tile, TileImprovementPlan>();
    private final java.util.Map<Location, List<Wish>> transportDemand = new HashMap<Location, List<Wish>>();
    private final List<TransportableAIObject> transportSupply = new ArrayList<TransportableAIObject>();
    private final java.util.Map<GoodsType, List<GoodsWish>> goodsWishes = new HashMap<GoodsType, List<GoodsWish>>();
    private final java.util.Map<UnitType, List<WorkerWish>> workerWishes = new HashMap<UnitType, List<WorkerWish>>();
    private final java.util.Map<Integer, Integer> wagonsNeeded = new HashMap<Integer, Integer>();
    private final List<AIColony> badlyDefended = new ArrayList<AIColony>();
    private int nBuilders = 0;
    private int nPioneers = 0;
    private int nScouts = 0;
    private int nNavalCarrier = 0;

    public EuropeanAIPlayer(AIMain aiMain, Player player) {
        super(aiMain, player);
    }

    public EuropeanAIPlayer(AIMain aiMain, FreeColXMLReader xr) throws XMLStreamException {
        super(aiMain, xr);
    }

    public boolean isAggressive() {
        return this.getPlayer().getNation().getType().getId().equals("model.nationType.conquest") || this.getPlayer().getNation().getType().getId().equals("model.nationType.immigration");
    }

    public boolean isLikesAttackingNatives() {
        return this.getPlayer().getNation().getType().getId().equals("model.nationType.conquest");
    }

    @Override
    public void removeAIObject(AIObject ao) {
        if (ao instanceof AIColony) {
            this.removeAIColony((AIColony)ao);
        } else {
            super.removeAIObject(ao);
        }
    }

    private void removeAIColony(AIColony aic) {
        Colony colony = aic.getColony();
        HashSet<TileImprovementPlan> tips = new HashSet<TileImprovementPlan>();
        for (Tile t : colony.getOwnedTiles()) {
            TileImprovementPlan tip = this.tipMap.remove(t);
            if (tip == null) continue;
            tips.add(tip);
        }
        for (AIGoods aig : aic.getExportGoods()) {
            if (!Map.isSameLocation(aig.getLocation(), colony)) continue;
            aig.changeTransport(null);
            aig.dispose();
        }
        this.transportDemand.remove(colony);
        HashSet<Wish> wishes = new HashSet<Wish>(aic.getWishes());
        for (AIUnit aiu : this.getAIUnits()) {
            PioneeringMission pm = aiu.getMission(PioneeringMission.class);
            if (pm != null) {
                if (!tips.contains(pm.getTileImprovementPlan())) continue;
                logger.info(pm + " collapses with loss of " + colony);
                aiu.changeMission(null);
                continue;
            }
            WishRealizationMission wm = aiu.getMission(WishRealizationMission.class);
            if (wm == null || !wishes.contains(wm.getWish())) continue;
            logger.info(wm + " collapses with loss of " + colony);
            aiu.changeMission(null);
        }
    }

    private static synchronized void initializeFromSpecification(Specification spec) {
        if (pioneerRole != null) {
            return;
        }
        pioneerRole = spec.getRoleWithAbility("model.ability.improveTerrain", null);
        scoutRole = spec.getRoleWithAbility("model.ability.speakWithChief", null);
        liftBoycottCheatPercent = spec.getInteger("model.option.liftBoycottCheat");
        equipScoutCheatPercent = spec.getInteger("model.option.equipScoutCheat");
        equipPioneerCheatPercent = spec.getInteger("model.option.equipPioneerCheat");
        landUnitCheatPercent = spec.getInteger("model.option.landUnitCheat");
        offensiveLandUnitCheatPercent = spec.getInteger("model.option.offensiveLandUnitCheat");
        offensiveNavalUnitCheatPercent = spec.getInteger("model.option.offensiveNavalUnitCheat");
        transportNavalUnitCheatPercent = spec.getInteger("model.option.transportNavalUnitCheat");
    }

    protected List<AIColony> getBadlyDefended() {
        return this.badlyDefended;
    }

    private void initializeMissions(LogBuilder lb) {
        Mission m;
        AIMain aiMain = this.getAIMain();
        List<AIUnit> aiUnits = this.getAIUnits();
        lb.add("\n  Initialize ");
        Map map = this.getGame().getMap();
        int maxRange = map.getWidth() + map.getHeight();
        for (AIUnit aiCarrier : aiUnits) {
            AIUnit aiu;
            Unit carrier;
            if (aiCarrier.hasMission() || !(carrier = aiCarrier.getUnit()).isNaval()) continue;
            Location target = null;
            for (Unit u : carrier.getUnitList()) {
                aiu = aiMain.getAIUnit(u);
                for (int range = 5; range < maxRange && (target = BuildColonyMission.findMissionTarget(aiu, range, false)) == null; range += 5) {
                }
                if (target == null) {
                    throw new RuntimeException("Initial colony fail: " + u);
                }
                m = this.getBuildColonyMission(aiu, target);
                if (m == null) continue;
                lb.add(m, ", ");
            }
            TransportMission tm = (TransportMission)this.getTransportMission(aiCarrier);
            if (tm == null) continue;
            lb.add(tm);
            for (Unit u : carrier.getUnitList()) {
                aiu = this.getAIMain().getAIUnit(u);
                if (aiu == null) continue;
                tm.queueTransportable(aiu, false, lb);
            }
        }
        lb.mark();
        for (AIUnit aiu : aiUnits) {
            if (aiu.hasMission() || (m = this.getSimpleMission(aiu)) == null) continue;
            lb.add(m, ", ");
        }
        if (lb.grew("\n  Backup: ")) {
            lb.shrink(", ");
        }
    }

    public void cheatGold(int amount, LogBuilder lb) {
        Player player = this.getPlayer();
        int gold = player.getGold();
        if (gold < amount) {
            player.modifyGold(amount -= gold);
            lb.add("added ", amount, " gold");
        }
        player.logCheat(amount + " gold");
    }

    private void cheat(LogBuilder lb) {
        int nCarrier;
        AIMain aiMain = this.getAIMain();
        if (!aiMain.getFreeColServer().getSinglePlayer()) {
            return;
        }
        Player player = this.getPlayer();
        if (player.getPlayerType() != Player.PlayerType.COLONIAL) {
            return;
        }
        lb.mark();
        Specification spec = this.getSpecification();
        Game game = this.getGame();
        Market market = player.getMarket();
        Europe europe = player.getEurope();
        Random air = this.getAIRandom();
        ArrayList<GoodsType> arrears = new ArrayList<GoodsType>();
        if (market != null) {
            arrears.addAll(CollectionUtils.transform(spec.getGoodsTypeList(), gt -> market.getArrears((GoodsType)gt) > 0));
        }
        int nCheats = arrears.size() + 6;
        int[] randoms = RandomUtils.randomInts(logger, "cheats", air, 100, nCheats);
        int cheatIndex = 0;
        for (GoodsType goodsType : arrears) {
            if (randoms[cheatIndex++] >= liftBoycottCheatPercent) continue;
            market.setArrears(goodsType, 0);
            CachingFunction<Colony, Modifier> partyModifierMapper = new CachingFunction<Colony, Modifier>(c -> CollectionUtils.first(CollectionUtils.transform(c.getModifiers(), partyPred)));
            Colony party = RandomUtils.getRandomMember(logger, "end boycott", CollectionUtils.transform(player.getColonies(), CollectionUtils.isNotNull(c -> (Modifier)partyModifierMapper.apply((Colony)c))), air);
            if (party == null) continue;
            party.removeModifier(partyModifierMapper.apply(party));
            lb.add("lift-boycott at ", party, ", ");
            player.logCheat("lift boycott at " + party.getName());
        }
        if (!europe.isEmpty() && this.scoutsNeeded() > 0 && randoms[cheatIndex++] < equipScoutCheatPercent) {
            for (Unit u : CollectionUtils.transform(europe.getUnits(), equipPred)) {
                try {
                    int g = europe.priceGoods(u.getGoodsDifference(scoutRole, 1));
                    this.cheatGold(g, lb);
                }
                catch (FreeColException fce) {
                    continue;
                }
                if (!this.getAIUnit(u).equipForRole(spec.getRoleWithAbility("model.ability.speakWithChief", null))) continue;
                lb.add(" to equip scout ", u, ", ");
                player.logCheat("Equip scout " + u.toShortString());
                break;
            }
        }
        if (!europe.isEmpty() && this.pioneersNeeded() > 0 && randoms[cheatIndex++] < equipPioneerCheatPercent) {
            for (Unit u : CollectionUtils.transform(europe.getUnits(), equipPred)) {
                try {
                    int g = europe.priceGoods(u.getGoodsDifference(pioneerRole, 1));
                    this.cheatGold(g, lb);
                }
                catch (FreeColException fce) {
                    continue;
                }
                if (!this.getAIUnit(u).equipForRole(spec.getRoleWithAbility("model.ability.improveTerrain", null))) continue;
                lb.add(" to equip pioneer ", u, ", ");
                player.logCheat("Equip pioneer " + u.toShortString());
                break;
            }
        }
        if (randoms[cheatIndex++] < landUnitCheatPercent) {
            int cost;
            Predicate<Map.Entry> bestWishPred = e -> {
                UnitType ut = (UnitType)e.getKey();
                return ut != null && ut.isAvailableTo(player) && europe.getUnitPrice(ut) != Integer.MIN_VALUE && CollectionUtils.any((Collection)e.getValue());
            };
            WorkerWish bestWish = (WorkerWish)CollectionUtils.maximize(CollectionUtils.transform(this.workerWishes.entrySet(), bestWishPred, e -> (WorkerWish)CollectionUtils.first((Collection)e.getValue()), Collectors.toSet()), ValuedAIObject.ascendingValueComparator);
            int n = bestWish != null ? europe.getUnitPrice(bestWish.getUnitType()) : (cost = player.getImmigration() < player.getImmigrationRequired() / 2 ? player.getEuropeanRecruitPrice() : Integer.MAX_VALUE);
            if (cost != Integer.MAX_VALUE) {
                Object aiu;
                this.cheatGold(cost, lb);
                if (bestWish == null) {
                    aiu = this.recruitAIUnitInEurope(-1);
                    if (aiu != null) {
                        lb.add(" to recruit ", ((AIUnit)aiu).getUnit(), ", ");
                    }
                } else {
                    aiu = this.trainAIUnitInEurope(bestWish.getUnitType());
                    if (aiu != null) {
                        Mission m = this.getWishRealizationMission((AIUnit)aiu, bestWish);
                        if (m != null) {
                            lb.add(" to train for ", m, ", ");
                        } else {
                            lb.add(" to train ", ((AIUnit)aiu).getUnit(), ", ");
                        }
                    }
                }
                if (aiu != null) {
                    player.logCheat("Make " + ((AIUnit)aiu).getUnit());
                }
            }
        }
        if (game.getTurn().getNumber() > 300 && player.isAtWar() && randoms[cheatIndex++] < offensiveLandUnitCheatPercent) {
            List<Player> wars = CollectionUtils.transform(game.getLivePlayers(player), x -> player.atWarWith((Player)x));
            ArrayList<Player> preferred = new ArrayList<Player>(wars.size());
            ArrayList<Player> enemies = new ArrayList<Player>(wars.size());
            for (Player p : wars) {
                enemies.add(p);
                double strength = this.getStrengthRatio(p);
                if (!(strength < 1.5) || !(strength > 0.6666666666666666)) continue;
                preferred.add(p);
            }
            if (!preferred.isEmpty()) {
                enemies.clear();
                enemies.addAll(preferred);
            }
            List<Colony> colonies = player.getColonyList();
            Location target = null;
            if (colonies.size() < 3) {
                Comparator<Colony> targetScore = CollectionUtils.cachingDoubleComparator(c -> {
                    double score = 100000.0 / (double)c.getUnitCount();
                    Building stockade = c.getStockade();
                    return stockade == null ? 1.0 : score / ((double)stockade.getLevel() + 1.5);
                });
                target = CollectionUtils.maximize(CollectionUtils.flatten(enemies, Player::isEuropean, Player::getConnectedPorts), targetScore);
            }
            if (target == null && !colonies.isEmpty()) {
                ArrayList<AIColony> bad = new ArrayList<AIColony>(this.getBadlyDefended());
                if (bad.isEmpty()) {
                    bad.addAll(this.getAIColonies());
                }
                AIColony defend = RandomUtils.getRandomMember(logger, "AIColony to defend", bad, air);
                Tile center = defend.getColony().getTile();
                Tile t = game.getMap().searchCircle(center, GoalDeciders.getEnemySettlementGoalDecider(enemies), 30);
                if (t != null) {
                    target = t.getSettlement();
                }
            }
            if (target != null) {
                ArrayList<AbstractUnit> aMercs = new ArrayList<AbstractUnit>();
                int aPrice = player.getMonarch().loadMercenaries(air, aMercs);
                if (aPrice > 0) {
                    List<Unit> mercs = ((ServerPlayer)player).createUnits(aMercs, europe, air);
                    for (Unit u : mercs) {
                        AIUnit aiu = this.getAIUnit(u);
                        if (aiu == null) continue;
                        player.logCheat("Enlist " + aiu.getUnit());
                        Mission m = this.getSeekAndDestroyMission(aiu, target);
                        if (m != null) {
                            lb.add("enlisted ", m, ", ");
                            continue;
                        }
                        lb.add("enlisted ", aiu.getUnit(), ", ");
                    }
                }
            }
        }
        double naval = this.getNavalStrengthRatio();
        int nNaval = player.getUnitCount(true) == 0 ? 100 : (0.0 < naval && naval < 0.5 ? (int)(naval * (double)offensiveNavalUnitCheatPercent) : -1);
        Function<UnitType, RandomChoice> mapper = ut -> new RandomChoice<UnitType>((UnitType)ut, 100000 / europe.getUnitPrice((UnitType)ut));
        if (randoms[cheatIndex++] < nNaval) {
            this.cheatUnit(CollectionUtils.transform(spec.getUnitTypeList(), ut -> ut.hasAbility("model.ability.navalUnit") && ut.isAvailableTo(player) && ut.hasPrice() && ut.isOffensive(), mapper), "offensive-naval", lb);
        }
        int n = nCarrier = this.nNavalCarrier > 0 ? transportNavalUnitCheatPercent : -1;
        if (randoms[cheatIndex++] < nCarrier) {
            this.cheatUnit(CollectionUtils.transform(spec.getUnitTypeList(), ut -> ut.hasAbility("model.ability.navalUnit") && ut.isAvailableTo(player) && ut.hasPrice() && ut.getSpace() > 0, mapper), "transport-naval", lb);
        }
        if (lb.grew("\n  Cheats: ")) {
            lb.shrink(", ");
        }
    }

    private AIUnit cheatUnit(List<RandomChoice<UnitType>> rc, String what, LogBuilder lb) {
        UnitType unitToPurchase = (UnitType)RandomChoice.getWeightedRandom(logger, "Cheat which unit", rc, this.getAIRandom());
        return unitToPurchase == null ? null : this.cheatUnit(unitToPurchase, what, lb);
    }

    private AIUnit cheatUnit(UnitType unitType, String what, LogBuilder lb) {
        Player player = this.getPlayer();
        Europe europe = player.getEurope();
        int cost = europe.getUnitPrice(unitType);
        this.cheatGold(cost, lb);
        AIUnit result = this.trainAIUnitInEurope(unitType);
        lb.add(" to build ", what, " ", unitType.getSuffix(), result != null ? "" : "(failed)", ", ");
        if (result == null) {
            return null;
        }
        player.logCheat("Build " + result.getUnit());
        return result;
    }

    public void allocateTransportables(List<TransportableAIObject> transportables, List<TransportMission> missions, LogBuilder lb) {
        if (transportables.isEmpty()) {
            return;
        }
        if (missions.isEmpty()) {
            return;
        }
        lb.add("\n  Allocate Transport cargo=", transportables.size(), " carriers=", missions.size());
        LogBuilder lb2 = new LogBuilder(0);
        int i = 0;
        block0: while (i < transportables.size() && !missions.isEmpty()) {
            TransportableAIObject t = transportables.get(i);
            lb.add(" for ", t);
            Mission best = null;
            float bestValue = 0.0f;
            boolean present = false;
            for (TransportMission tm : missions) {
                float value;
                if (!tm.spaceAvailable(t)) continue;
                Cargo cargo = tm.makeCargo(t, lb2);
                if (cargo == null) {
                    transportables.remove(i);
                    continue block0;
                }
                int turns = cargo.getTurns();
                if (turns == 0) {
                    value = tm.destinationCapacity();
                    if (!present) {
                        bestValue = 0.0f;
                    }
                    present = true;
                } else {
                    float f = value = present ? -1.0f : (float)t.getTransportPriority() / (float)turns;
                }
                if (!(bestValue < value)) continue;
                bestValue = value;
                best = tm;
            }
            if (best == null) {
                lb.add(" nothing found");
            } else {
                lb.add(" ", best.getUnit(), " chosen");
                if (((TransportMission)best).queueTransportable(t, false, lb)) {
                    this.claimTransportable(t);
                    if (((TransportMission)best).destinationCapacity() <= 0) {
                        missions.remove(best);
                    }
                } else {
                    missions.remove(best);
                }
            }
            ++i;
        }
    }

    private void bringGifts(LogBuilder lb) {
    }

    private void demandTribute(LogBuilder lb) {
    }

    public void buildTipMap(LogBuilder lb) {
        this.tipMap.clear();
        for (AIColony aic : this.getAIColonies()) {
            for (TileImprovementPlan tip : aic.getTileImprovementPlans()) {
                if (tip == null || tip.isComplete()) {
                    aic.removeTileImprovementPlan(tip);
                    continue;
                }
                if (tip.getPioneer() != null) continue;
                if (!tip.validate()) {
                    aic.removeTileImprovementPlan(tip);
                    tip.dispose();
                    continue;
                }
                if (tip.getTarget() == null) {
                    logger.warning("No target for tip: " + tip);
                    continue;
                }
                TileImprovementPlan other = this.tipMap.get(tip.getTarget());
                if (other != null && other.getValue() >= tip.getValue()) continue;
                this.tipMap.put(tip.getTarget(), tip);
            }
        }
        if (!this.tipMap.isEmpty()) {
            lb.add("\n  Improvements:");
            CollectionUtils.forEachMapEntry(this.tipMap, e -> {
                Tile t = (Tile)e.getKey();
                TileImprovementPlan tip = (TileImprovementPlan)e.getValue();
                AIUnit pioneer = tip.getPioneer();
                lb.add(" ", t, "=", tip.getType().getSuffix());
                if (pioneer != null) {
                    lb.add("/", pioneer.getUnit());
                }
            });
        }
    }

    private void updateTipMap(AIColony aic) {
        for (TileImprovementPlan tip : aic.getTileImprovementPlans()) {
            this.tipMap.put(tip.getTarget(), tip);
        }
    }

    public TileImprovementPlan getBestPlan(Tile tile) {
        return this.tipMap == null ? null : this.tipMap.get(tile);
    }

    public Tile getBestPlanTile(Colony colony) {
        Comparator<TileImprovementPlan> valueComp = Comparator.comparingInt(ValuedAIObject::getValue);
        Function<Tile, TileImprovementPlan> tileMapper = t -> this.tipMap.get(t);
        TileImprovementPlan best = CollectionUtils.maximize(CollectionUtils.map(colony.getOwnedTiles(), tileMapper), CollectionUtils.isNotNull(), valueComp);
        return best == null ? null : best.getTarget();
    }

    public void removeTileImprovementPlan(TileImprovementPlan plan) {
        if (plan == null) {
            return;
        }
        if (plan.getTarget() != null) {
            this.tipMap.remove(plan.getTarget());
        }
        for (AIColony aic : this.getAIColonies()) {
            if (aic.removeTileImprovementPlan(plan)) break;
        }
    }

    public void updateTransport(AIUnit aiu, Location oldTarget, LogBuilder lb) {
        TransportMission tm;
        Location newTarget;
        AIUnit aiCarrier = aiu.getTransport();
        Mission newMission = aiu.getMission();
        Location location = newTarget = newMission == null ? null : newMission.getTarget();
        if (aiCarrier != null && (tm = aiCarrier.getMission(TransportMission.class)) != null && !Map.isSameLocation(oldTarget, newTarget)) {
            if (aiu.getUnit().getLocation() != aiCarrier.getUnit()) {
                lb.add(", drop transport ", aiCarrier.getUnit());
                aiu.dropTransport();
            } else if (newTarget == null) {
                tm.dumpTransportable(aiu, lb);
            } else {
                tm.requeueTransportable(aiu, lb);
            }
        }
    }

    private boolean requestsTransport(TransportableAIObject t) {
        return t.getTransport() == null && t.getTransportDestination() != null && t.getTransportSource() != null && !(t.getLocation() instanceof Unit);
    }

    private boolean checkTransport(TransportableAIObject t) {
        AIUnit aiCarrier = t.getTransport();
        if (aiCarrier == null) {
            return false;
        }
        TransportMission tm = aiCarrier.getMission(TransportMission.class);
        if (tm != null && tm.isTransporting(t)) {
            return true;
        }
        t.changeTransport(null);
        return false;
    }

    private void changeNeedWagon(Tile tile, int amount) {
        if (tile == null) {
            return;
        }
        int contig = tile.getContiguity();
        if (contig > 0) {
            Integer i = this.wagonsNeeded.get(contig);
            if (i == null) {
                if (amount == 0) {
                    this.wagonsNeeded.put(contig, 0);
                }
            } else {
                this.wagonsNeeded.put(contig, i + amount);
            }
        }
    }

    private void buildTransportMaps(LogBuilder lb) {
        Colony colony;
        this.transportDemand.clear();
        this.transportSupply.clear();
        this.wagonsNeeded.clear();
        this.nNavalCarrier = 0;
        for (AIColony aic : this.getAIColonies()) {
            colony = aic.getColony();
            if (!colony.isConnectedPort()) continue;
            this.changeNeedWagon(colony.getTile(), 0);
        }
        for (AIUnit aiu : this.getAIUnits()) {
            if (aiu.hasMission() && !aiu.getMission().isValid()) continue;
            Unit u = aiu.getUnit();
            if (u.isCarrier()) {
                if (u.isNaval()) {
                    --this.nNavalCarrier;
                    continue;
                }
                this.changeNeedWagon(u.getTile(), -1);
                continue;
            }
            this.checkTransport(aiu);
            if (!this.requestsTransport(aiu)) continue;
            this.transportSupply.add(aiu);
            aiu.incrementTransportPriority();
            ++this.nNavalCarrier;
        }
        for (AIColony aic : this.getAIColonies()) {
            for (AIGoods aig : aic.getExportGoods()) {
                Location dst;
                this.checkTransport(aig);
                if (!this.requestsTransport(aig)) continue;
                this.transportSupply.add(aig);
                aig.incrementTransportPriority();
                Location src = aig.getTransportSource();
                if (Map.isSameContiguity(src, dst = aig.getTransportDestination())) continue;
                ++this.nNavalCarrier;
            }
            colony = aic.getColony();
            if (colony.isConnectedPort()) continue;
            this.changeNeedWagon(colony.getTile(), 1);
        }
        for (Wish w : this.getWishes()) {
            TransportableAIObject t = w.getTransportable();
            if (t == null || t.getTransport() != null || t.getTransportDestination() == null) continue;
            Location loc = Location.upLoc(t.getTransportDestination());
            CollectionUtils.appendToMapList(this.transportDemand, loc, w);
        }
        if (!this.transportSupply.isEmpty()) {
            lb.add("\n  Transport Supply:");
            for (TransportableAIObject t : this.transportSupply) {
                lb.add(" ", t.getTransportPriority(), "+", t);
            }
        }
        if (!this.transportDemand.isEmpty()) {
            lb.add("\n  Transport Demand:");
            CollectionUtils.forEachMapEntry(this.transportDemand, e -> {
                Location ld = (Location)e.getKey();
                lb.add("\n    ", ld, "[");
                for (Wish w : (List)e.getValue()) {
                    lb.add(" ", w);
                }
                lb.add(" ]");
            });
        }
    }

    public List<TransportableAIObject> getTransportables() {
        return CollectionUtils.sort(this.transportSupply, ValuedAIObject.descendingValueComparator);
    }

    public List<TransportableAIObject> getUrgentTransportables() {
        return List.of();
    }

    public boolean claimTransportable(TransportableAIObject t) {
        return this.transportSupply.remove(t);
    }

    private void rearrangeColonies(LogBuilder lb) {
        for (AIColony aic : this.getAIColonies()) {
            aic.rearrangeColony(lb);
        }
    }

    private void suppressEuropeanTrade(GoodsType type, LogBuilder lb) {
        Player player = this.getPlayer();
        Europe europe = player.getEurope();
        lb.add("  Suppressing trade in ", type.getSuffix());
        ArrayList<Unit> units = new ArrayList<Unit>(europe.getUnitList());
        units.addAll(player.getHighSeas().getUnitList());
        for (Unit u : units) {
            AIUnit aiu;
            int amount;
            if (!u.isCarrier() || (amount = u.getGoodsCount(type)) <= 0 || (aiu = this.getAIUnit(u)) == null || !AIMessage.askUnloadGoods(type, amount, aiu)) continue;
            lb.add(", ", u, " sold ", amount);
        }
        for (AIUnit aiu : this.getAIUnits()) {
            TransportMission tm = aiu.getMission(TransportMission.class);
            if (tm == null) continue;
            tm.suppressEuropeanTrade(type, lb);
        }
        int n = 0;
        List<GoodsWish> wishes = this.goodsWishes.get(type);
        if (wishes != null) {
            for (GoodsWish gw : wishes) {
                if (gw.getGoodsType() != type || gw.getDestination() != europe) continue;
                if (gw.getTransportable() instanceof AIGoods) {
                    AIGoods aig = (AIGoods)gw.getTransportable();
                    this.consumeGoodsWish(aig, gw);
                    aig.setTransportDestination(null);
                }
                gw.dispose();
                ++n;
            }
            if (n > 0) {
                lb.add(", dropped ", n, " goods wishes");
            }
        }
        lb.add(".");
    }

    public List<WorkerWish> getWorkerWishesAt(Location loc, UnitType type) {
        List<Wish> demand = this.transportDemand.get(Location.upLoc(loc));
        return demand == null ? Collections.emptyList() : CollectionUtils.transform(demand, w -> w instanceof WorkerWish && ((WorkerWish)w).getUnitType() == type, w -> (WorkerWish)w);
    }

    public List<GoodsWish> getGoodsWishesAt(Location loc, GoodsType type) {
        List<Wish> demand = this.transportDemand.get(Location.upLoc(loc));
        return demand == null ? Collections.emptyList() : CollectionUtils.transform(demand, w -> w instanceof GoodsWish && ((GoodsWish)w).getGoodsType() == type, w -> (GoodsWish)w);
    }

    private WorkerWish getBestWorkerWish(AIUnit aiUnit, UnitType unitType) {
        List<WorkerWish> wishes = this.workerWishes.get(unitType);
        if (wishes == null) {
            return null;
        }
        Unit carrier = aiUnit.getUnit();
        WorkerWish carried = null;
        WorkerWish other = null;
        double bestCarriedValue = -1.0;
        double bestOtherValue = -1.0;
        for (WorkerWish w : wishes) {
            Location dest = w.getDestination();
            if (dest == null) continue;
            int turns = carrier.getTurnsToReach(dest);
            if (turns < 10000) {
                if (!(bestCarriedValue < (double)w.getValue() / (double)turns)) continue;
                bestCarriedValue = (double)w.getValue() / (double)turns;
                carried = w;
                continue;
            }
            if (!(bestOtherValue < (double)w.getValue())) continue;
            bestOtherValue = w.getValue();
            other = w;
        }
        return carried != null ? carried : (other != null ? other : null);
    }

    public GoodsWish getBestGoodsWish(AIUnit aiUnit, GoodsType goodsType) {
        Unit carrier = aiUnit.getUnit();
        ToDoubleFunction<GoodsWish> wishValue = CollectionUtils.cacheDouble(gw -> {
            int turns = carrier.getTurnsToReach(carrier.getLocation(), gw.getDestination());
            return turns >= 10000 ? -1.0 : (double)gw.getValue() / (double)turns;
        });
        Comparator<GoodsWish> comp = Comparator.comparingDouble(wishValue);
        List<GoodsWish> wishes = this.goodsWishes.get(goodsType);
        return wishes == null ? null : CollectionUtils.maximize(wishes, gw -> wishValue.applyAsDouble((GoodsWish)gw) > 0.0, comp);
    }

    private void buildWishMaps(LogBuilder lb) {
        for (UnitType unitType : this.getSpecification().getUnitTypeList()) {
            List<WorkerWish> wl = this.workerWishes.get(unitType);
            if (wl == null) {
                this.workerWishes.put(unitType, new ArrayList());
                continue;
            }
            wl.clear();
        }
        for (GoodsType goodsType : this.getSpecification().getStorableGoodsTypeList()) {
            List<GoodsWish> gl = this.goodsWishes.get(goodsType);
            if (gl == null) {
                this.goodsWishes.put(goodsType, new ArrayList());
                continue;
            }
            gl.clear();
        }
        for (Wish w : this.getWishes()) {
            GoodsWish gw;
            if (w instanceof WorkerWish) {
                WorkerWish ww = (WorkerWish)w;
                if (ww.getTransportable() != null) continue;
                CollectionUtils.appendToMapList(this.workerWishes, ww.getUnitType(), ww);
                continue;
            }
            if (!(w instanceof GoodsWish) || !((gw = (GoodsWish)w).getDestination() instanceof Colony)) continue;
            CollectionUtils.appendToMapList(this.goodsWishes, gw.getGoodsType(), gw);
        }
        if (!this.workerWishes.isEmpty()) {
            lb.add("\n  Wishes (workers):");
            CollectionUtils.forEachMapEntry(this.workerWishes, e -> {
                UnitType ut = (UnitType)e.getKey();
                List wl = (List)e.getValue();
                if (!wl.isEmpty()) {
                    lb.add("\n    ", ut.getSuffix(), ":");
                    for (WorkerWish ww : wl) {
                        lb.add(" ", ww.getDestination(), "(", ww.getValue(), ")");
                    }
                }
            });
        }
        if (!this.goodsWishes.isEmpty()) {
            lb.add("\n  Wishes (goods):");
            CollectionUtils.forEachMapEntry(this.goodsWishes, e -> {
                GoodsType gt = (GoodsType)e.getKey();
                List gl = (List)e.getValue();
                if (!gl.isEmpty()) {
                    lb.add("\n    ", gt.getSuffix(), ":");
                    for (GoodsWish gw : gl) {
                        lb.add(" ", gw.getDestination(), "(", gw.getValue(), ")");
                    }
                }
            });
        }
    }

    private void consumeWorkerWish(AIUnit aiUnit, WorkerWish ww) {
        Unit unit = aiUnit.getUnit();
        List<WorkerWish> wwL = this.workerWishes.get(unit.getType());
        wwL.remove(ww);
        List<Wish> wl = this.transportDemand.get(ww.getDestination());
        if (wl != null) {
            wl.remove(ww);
        }
        ww.setTransportable(aiUnit);
    }

    private void consumeGoodsWish(AIGoods aig, GoodsWish gw) {
        Goods goods = aig.getGoods();
        List<GoodsWish> gwL = this.goodsWishes.get(goods.getType());
        gwL.remove(gw);
        List<Wish> wl = this.transportDemand.get(gw.getDestination());
        if (wl != null) {
            wl.remove(gw);
        }
        gw.setTransportable(aig);
    }

    private int buildersNeeded() {
        Player player = this.getPlayer();
        if (!player.canBuildColonies()) {
            return 0;
        }
        int nColonies = 0;
        int nPorts = 0;
        int nColonySize1 = 0;
        for (Settlement settlement : player.getSettlementList()) {
            int colonySize;
            ++nColonies;
            if (settlement.isConnectedPort()) {
                ++nPorts;
            }
            if ((colonySize = settlement.getUnitList().size()) != 1) continue;
            ++nColonySize1;
        }
        if (nPorts == 0) {
            return 2;
        }
        if (nPorts == 1) {
            return 1;
        }
        if (nColonies < 3) {
            return 1;
        }
        if (nColonySize1 < 2) {
            return 1;
        }
        return 0;
    }

    private AIUnit recruitAIUnitInEurope(int slot) {
        AIUnit aiUnit = null;
        Europe europe = this.getPlayer().getEurope();
        if (europe == null) {
            return null;
        }
        int n = europe.getUnitCount();
        String selectAbility = "model.ability.selectRecruit";
        if (!Europe.MigrationType.validMigrantSlot(slot)) {
            int n2 = slot = this.getPlayer().hasAbility("model.ability.selectRecruit") ? Europe.MigrationType.getDefaultSlot() : Europe.MigrationType.getUnspecificSlot();
        }
        if (AIMessage.askEmigrate(this, slot) && europe.getUnitCount() == n + 1 && (aiUnit = this.getAIUnit(europe.getUnitList().get(n))) != null) {
            this.addAIUnit(aiUnit);
        }
        return aiUnit;
    }

    private AIUnit trainAIUnitInEurope(UnitType unitType) {
        if (unitType == null) {
            throw new RuntimeException("Invalid UnitType: " + this);
        }
        AIUnit aiUnit = null;
        Europe europe = this.getPlayer().getEurope();
        if (europe == null) {
            return null;
        }
        int n = europe.getUnitCount();
        if (AIMessage.askTrainUnitInEurope(this, unitType) && europe.getUnitCount() == n + 1 && (aiUnit = this.getAIUnit(europe.getUnitList().get(n))) != null) {
            this.addAIUnit(aiUnit);
        }
        return aiUnit;
    }

    public List<Wish> getWishes() {
        return CollectionUtils.sort(CollectionUtils.flatten(this.getAIColonies(), aic -> aic.getWishes().stream()), ValuedAIObject.descendingValueComparator);
    }

    private void determineStances(LogBuilder lb) {
        Player player = this.getPlayer();
        lb.mark();
        for (Player p : this.getGame().getLivePlayerList(player)) {
            Stance newStance = this.determineStance(p);
            if (newStance == player.getStance(p) || newStance == Stance.WAR && this.peaceHolds(p)) continue;
            this.getAIMain().getFreeColServer().getInGameController().changeStance(player, newStance, p, true);
            lb.add(" ", p.getDebugName(), "->", newStance, ", ");
        }
        if (lb.grew("\n  Stance changes:")) {
            lb.shrink(", ");
        }
    }

    private boolean peaceHolds(Player p) {
        Player player = this.getPlayer();
        Turn turn = this.getGame().getTurn();
        double peaceProb = this.getSpecification().getPercentageMultiplier("model.option.peaceProbability");
        int peaceTurn = -1;
        for (HistoryEvent h : player.getHistory()) {
            if (!p.getId().equals(h.getPlayerId()) || h.getTurn().getNumber() <= peaceTurn) continue;
            switch (h.getEventType()) {
                case MAKE_PEACE: 
                case FORM_ALLIANCE: {
                    peaceTurn = h.getTurn().getNumber();
                    break;
                }
                case DECLARE_WAR: {
                    peaceTurn = -1;
                    break;
                }
            }
        }
        if (peaceTurn < 0) {
            return false;
        }
        int n = turn.getNumber() - peaceTurn;
        float prob = (float)Math.pow(peaceProb, n);
        return (prob = p.apply(prob, turn, "model.modifier.peaceTreaty")) > 0.0f && RandomUtils.randomInt(logger, "Peace holds?", this.getAIRandom(), 100) < (int)(100.0f * prob);
    }

    protected NationSummary getNationSummary(Player other) {
        Player player = this.getPlayer();
        NationSummary ns = player.getNationSummary(other);
        if (ns != null) {
            return ns;
        }
        AIMessage.askNationSummary(this, other);
        return player.getNationSummary(other);
    }

    protected double getStrengthRatio(Player other) {
        return this.getPlayer().getStrengthRatio(other, false);
    }

    protected double getNavalStrengthRatio() {
        Player player = this.getPlayer();
        double navalAverage = 0.0;
        double navalStrength = 0.0;
        int nPlayers = 0;
        for (Player p : CollectionUtils.transform(this.getGame().getLiveEuropeanPlayers(player), x -> !x.isREF())) {
            NationSummary ns = this.getNationSummary(p);
            if (ns == null) continue;
            if (p == player) {
                navalStrength = ns.getNavalStrength();
                continue;
            }
            int st = ns.getNavalStrength();
            if (st >= 0) {
                navalAverage += (double)st;
            }
            ++nPlayers;
        }
        if (nPlayers <= 0 || navalStrength < 0.0) {
            return -1.0;
        }
        return (navalAverage /= (double)nPlayers) == 0.0 ? -1.0 : navalStrength / navalAverage;
    }

    private DiplomaticTrade.TradeStatus rejectAgreement(TradeItem stance, DiplomaticTrade agreement) {
        if (stance == null) {
            return DiplomaticTrade.TradeStatus.REJECT_TRADE;
        }
        agreement.clear();
        agreement.add(stance);
        return DiplomaticTrade.TradeStatus.PROPOSE_TRADE;
    }

    /*
     * WARNING - void declaration
     */
    protected void giveNormalMissions(LogBuilder lb, List<AIUnit> aiUnits) {
        Mission m;
        AIMain aiMain = this.getAIMain();
        Player player = this.getPlayer();
        BuildColonyMission bcm = null;
        this.nBuilders = this.buildersNeeded();
        this.nPioneers = this.pioneersNeeded();
        this.nScouts = this.scoutsNeeded();
        ArrayList<AIUnit> navalUnits = new ArrayList<AIUnit>(aiUnits.size() / 2);
        ArrayList<AIUnit> done = new ArrayList<AIUnit>(aiUnits.size());
        ArrayList<TransportMission> transportMissions = new ArrayList<TransportMission>(aiUnits.size() / 2);
        HashMap<Unit, String> reasons = new HashMap<Unit, String>(aiUnits.size());
        lb.mark();
        for (AIUnit aIUnit : aiUnits) {
            Location oldTarget2;
            Unit unit = aIUnit.getUnit();
            Colony colony = unit.getColony();
            m = aIUnit.getMission();
            Location location = oldTarget2 = m == null ? null : m.getTarget();
            if (!unit.isInitialized() || unit.isDisposed()) {
                reasons.put(unit, "Invalid");
            } else if (unit.isDamaged()) {
                if (!(m instanceof IdleAtSettlementMission) && (m = this.getIdleAtSettlementMission(aIUnit)) != null) {
                    lb.add(", ", m);
                }
                reasons.put(unit, "Damaged");
            } else if (unit.getState() == Unit.UnitState.IN_COLONY && colony.getUnitCount() <= 1) {
                if (!(m instanceof WorkInsideColonyMission) && (m = this.getWorkInsideColonyMission(aIUnit, aiMain.getAIColony(colony))) != null) {
                    logger.warning(aIUnit + " should WorkInsideColony at " + colony.getName());
                    lb.add(", ", m);
                    this.updateTransport(aIUnit, oldTarget2, lb);
                }
                reasons.put(unit, "Vital");
            } else if (unit.isInMission()) {
                reasons.put(unit, "Mission");
            } else if (m != null && m.isValid() && !m.isOneTime()) {
                if (m instanceof BuildColonyMission) {
                    bcm = (BuildColonyMission)m;
                    --this.nBuilders;
                } else if (m instanceof PioneeringMission) {
                    --this.nPioneers;
                } else if (m instanceof ScoutingMission) {
                    --this.nScouts;
                } else if (m instanceof TransportMission) {
                    TransportMission tm = (TransportMission)m;
                    if (tm.isEmpty() && unit.isNaval() && unit.isOffensiveUnit()) {
                        navalUnits.add(aIUnit);
                        done.add(aIUnit);
                        continue;
                    }
                    if (tm.destinationCapacity() > 0) {
                        transportMissions.add(tm);
                    }
                } else if (m instanceof PrivateerMission && !(m.getTarget() instanceof Unit)) {
                    navalUnits.add(aIUnit);
                    done.add(aIUnit);
                    continue;
                }
                reasons.put(unit, "Valid");
            } else if (unit.isNaval()) {
                navalUnits.add(aIUnit);
            } else {
                if (!unit.isAtSea()) continue;
                reasons.put(unit, "At-Sea");
            }
            done.add(aIUnit);
        }
        aiUnits.removeAll(done);
        done.clear();
        if (bcm != null && !player.hasSettlements()) {
            Location bcmTarget = bcm.getTarget();
            for (AIUnit aIUnit : CollectionUtils.sort(aiUnits, builderComparator)) {
                m = aIUnit.getMission();
                Location location = m == null ? null : m.getTarget();
                m = this.getBuildColonyMission(aIUnit, bcmTarget);
                if (m == null) continue;
                lb.add(", ", m);
                this.updateTransport(aIUnit, location, lb);
                done.add(aIUnit);
                if (this.requestsTransport(aIUnit)) {
                    this.transportSupply.add(aIUnit);
                }
                reasons.put(aIUnit.getUnit(), "0Builder");
            }
            aiUnits.removeAll(done);
            done.clear();
        }
        if (this.nBuilders > 0) {
            int MAX_BUILDING_MISSION_TRIES = 50;
            boolean bl = false;
            for (AIUnit aIUnit : CollectionUtils.sort(aiUnits, builderComparator)) {
                void var12_20;
                if (aIUnit.getUnit().isArmed() && this.getGame().getTurn().getNumber() > 20) continue;
                if (++var12_20 > 50) break;
                m = aIUnit.getMission();
                Location oldTarget = m == null ? null : m.getTarget();
                m = this.getBuildColonyMission(aIUnit, null);
                if (m == null) continue;
                lb.add(", ", m);
                this.updateTransport(aIUnit, oldTarget, lb);
                done.add(aIUnit);
                if (this.requestsTransport(aIUnit)) {
                    this.transportSupply.add(aIUnit);
                }
                reasons.put(aIUnit.getUnit(), "Builder" + this.nBuilders);
                if (--this.nBuilders > 0) continue;
                break;
            }
            aiUnits.removeAll(done);
            done.clear();
        }
        if (this.nScouts > 0) {
            for (AIUnit aIUnit : CollectionUtils.sort(aiUnits, scoutComparator)) {
                m = aIUnit.getMission();
                Location location = m == null ? null : m.getTarget();
                Unit unit = aIUnit.getUnit();
                m = this.getScoutingMission(aIUnit);
                if (m == null) continue;
                lb.add(", ", m);
                this.updateTransport(aIUnit, location, lb);
                done.add(aIUnit);
                if (this.requestsTransport(aIUnit)) {
                    this.transportSupply.add(aIUnit);
                }
                reasons.put(unit, "Scout" + this.nScouts);
                if (--this.nScouts > 0) continue;
                break;
            }
            aiUnits.removeAll(done);
            done.clear();
        }
        if (this.nPioneers > 0) {
            for (AIUnit aIUnit : CollectionUtils.sort(aiUnits, pioneerComparator)) {
                Unit unit = aIUnit.getUnit();
                m = aIUnit.getMission();
                Location location = m == null ? null : m.getTarget();
                m = this.getPioneeringMission(aIUnit, null);
                if (m == null) continue;
                lb.add(", ", m);
                this.updateTransport(aIUnit, location, lb);
                done.add(aIUnit);
                if (this.requestsTransport(aIUnit)) {
                    this.transportSupply.add(aIUnit);
                }
                reasons.put(unit, "Pioneer" + this.nPioneers);
                if (--this.nPioneers > 0) continue;
                break;
            }
            aiUnits.removeAll(done);
            done.clear();
        }
        for (AIUnit aIUnit : aiUnits) {
            Unit unit = aIUnit.getUnit();
            m = aIUnit.getMission();
            Location location = m == null ? null : m.getTarget();
            m = this.getSimpleMission(aIUnit);
            if (m == null) continue;
            lb.add(", ", m);
            this.updateTransport(aIUnit, location, lb);
            reasons.put(unit, "New-Land");
            done.add(aIUnit);
            if (!this.requestsTransport(aIUnit)) continue;
            this.transportSupply.add(aIUnit);
        }
        aiUnits.removeAll(done);
        done.clear();
        for (AIUnit aIUnit : navalUnits) {
            Unit unit = aIUnit.getUnit();
            m = aIUnit.getMission();
            Mission mission = m != null && m.isValid() ? m : null;
            m = this.getSimpleMission(aIUnit);
            if (m == null) continue;
            lb.add(", ", m, m == mission ? " (preserved)" : " (new)");
            reasons.put(unit, "New-Naval");
            done.add(aIUnit);
            if (!(m instanceof TransportMission)) continue;
            TransportMission tm = (TransportMission)m;
            if (tm.destinationCapacity() > 0) {
                transportMissions.add(tm);
            }
            for (Unit u : aIUnit.getUnit().getUnitList()) {
                AIUnit aiu = this.getAIUnit(u);
                Mission um = aiu.getMission();
                if (um == null || !um.isValid() || !aiUnits.contains(aiu)) continue;
                aiUnits.remove(aiu);
                reasons.put(aiu.getUnit(), "TNew");
            }
        }
        navalUnits.removeAll(done);
        done.clear();
        aiUnits.addAll(navalUnits);
        List<Colony> ports = null;
        int n = player.getNumberOfPorts();
        for (AIUnit aIUnit : aiUnits) {
            Location oldTarget4;
            Unit unit3 = aIUnit.getUnit();
            m = aIUnit.getMission();
            Location location = oldTarget4 = m == null ? null : m.getTarget();
            if (m != null && m.isValid() && !m.isOneTime()) {
                logger.warning("Trying fallback mission for unit " + unit3 + " with valid mission " + m + " reason " + (String)reasons.get(unit3));
                continue;
            }
            if (n > 0 && unit3.isInEurope() && unit3.isPerson()) {
                Colony c;
                AIColony aic;
                if (ports == null) {
                    ports = player.getConnectedPortList();
                }
                if ((m = this.getWorkInsideColonyMission(aIUnit, aic = aiMain.getAIColony(c = ports.remove(0)))) != null) {
                    lb.add(", ", m);
                    this.updateTransport(aIUnit, oldTarget4, lb);
                    reasons.put(unit3, "To-work");
                }
                ports.add(c);
                continue;
            }
            if (m instanceof IdleAtSettlementMission) {
                reasons.put(unit3, "Idle");
                continue;
            }
            m = this.getIdleAtSettlementMission(aIUnit);
            if (m == null) continue;
            lb.add(", ", m);
            this.updateTransport(aIUnit, oldTarget4, lb);
            reasons.put(unit3, "Idle");
        }
        lb.grew("\n  Mission changes");
        this.allocateTransportables(this.getUrgentTransportables(), transportMissions, lb);
        if (!aiUnits.isEmpty()) {
            lb.add("\n  Free Land Units:");
            for (AIUnit aIUnit : aiUnits) {
                lb.add(" ", aIUnit.getUnit());
            }
        }
        if (!navalUnits.isEmpty()) {
            lb.add("\n  Free Naval Units:");
            for (AIUnit aIUnit : navalUnits) {
                lb.add(" ", aIUnit.getUnit());
            }
        }
        lb.add("\n  Missions(colonies=", player.getSettlementCount(), " builders=", this.nBuilders, " pioneers=", this.nPioneers, " scouts=", this.nScouts, " naval-carriers=", this.nNavalCarrier, ")");
        this.logMissions(reasons, lb);
    }

    private Mission getSimpleMission(AIUnit aiUnit) {
        Mission old;
        Unit unit = aiUnit.getUnit();
        Mission m = aiUnit.getMission();
        Mission mission = old = m != null && m.isValid() ? m : null;
        Mission ret = unit.isNaval() ? (old instanceof PrivateerMission ? old : ((m = this.getPrivateerMission(aiUnit, null)) != null ? m : (old instanceof TransportMission ? old : ((m = this.getTransportMission(aiUnit)) != null ? m : (old instanceof UnitSeekAndDestroyMission ? old : ((m = this.getSeekAndDestroyMission(aiUnit, 8)) != null ? m : (old instanceof UnitWanderHostileMission ? old : this.getWanderHostileMission(aiUnit)))))))) : (unit.isCarrier() ? this.getTransportMission(aiUnit) : (old instanceof CashInTreasureTrainMission ? old : ((m = this.getCashInTreasureTrainMission(aiUnit)) != null ? m : (unit.isInColony() && old instanceof WorkInsideColonyMission ? old : (unit.isInColony() && (m = this.getWorkInsideColonyMission(aiUnit, null)) != null ? m : (old instanceof DefendSettlementMission && old.getTarget() instanceof Colony && !((Colony)old.getTarget()).isVeryWellDefended() ? old : ((m = this.getDefendCurrentSettlementMission(aiUnit)) != null ? m : (unit.hasAbility("model.ability.refUnit") ? (old instanceof UnitSeekAndDestroyMission ? old : ((m = this.getSeekAndDestroyMission(aiUnit, 12)) != null ? m : (m = this.getWanderHostileMission(aiUnit)))) : (unit.isColonist() && unit.getSkillLevel() > 0 && old instanceof WishRealizationMission ? old : (unit.isColonist() && unit.getSkillLevel() > 0 && (m = this.getWishRealizationMission(aiUnit, null)) != null ? m : ((m = this.getDefendSettlementMission(aiUnit, false, false)) != null ? m : (old instanceof UnitSeekAndDestroyMission ? old : ((m = this.getSeekAndDestroyMission(aiUnit, 8)) != null ? m : (old instanceof MissionaryMission ? old : ((m = this.getMissionaryMission(aiUnit)) != null ? m : (old instanceof WishRealizationMission ? old : ((m = this.getWishRealizationMission(aiUnit, null)) != null ? m : ((m = this.getDefendSettlementMission(aiUnit, true, false)) != null ? m : ((m = this.getSeekAndDestroyMission(aiUnit, 16)) != null ? m : ((m = this.getDefendSettlementMission(aiUnit, true, true)) != null ? m : (old instanceof UnitWanderHostileMission ? old : ((m = this.getWanderHostileMission(aiUnit)) != null ? m : null))))))))))))))))))))));
        return ret;
    }

    private Mission getBuildColonyMission(AIUnit aiUnit, Location target) {
        String reason = BuildColonyMission.invalidMissionReason(aiUnit);
        if (reason != null) {
            return null;
        }
        Unit unit = aiUnit.getUnit();
        if (target == null) {
            target = BuildColonyMission.findMissionTarget(aiUnit, 5, unit.isInEurope());
        }
        return target == null ? null : new BuildColonyMission(this.getAIMain(), aiUnit, target);
    }

    private Mission getCashInTreasureTrainMission(AIUnit aiUnit) {
        String reason = CashInTreasureTrainMission.invalidMissionReason(aiUnit);
        if (reason != null) {
            return null;
        }
        Unit unit = aiUnit.getUnit();
        Location loc = CashInTreasureTrainMission.findMissionTarget(aiUnit, 20, unit.isInEurope());
        return loc == null ? null : new CashInTreasureTrainMission(this.getAIMain(), aiUnit, loc);
    }

    public Mission getDefendSettlementMission(AIUnit aiUnit, boolean relaxed, boolean includeWellDefendedSettlements) {
        if (DefendSettlementMission.invalidMissionReason(aiUnit) != null) {
            return null;
        }
        Unit unit = aiUnit.getUnit();
        Location loc = unit.getLocation();
        double worstValue = Double.MAX_VALUE;
        Colony worstColony = null;
        for (AIColony aic : this.getAIColonies()) {
            double value;
            Colony colony = aic.getColony();
            if (!aic.isBadlyDefended() && !includeWellDefendedSettlements) continue;
            if (unit.isAtLocation(colony.getTile())) {
                worstColony = colony;
                break;
            }
            int ttr = 1 + unit.getTurnsToReach(loc, colony.getTile(), unit.getCarrier(), relaxed ? CostDeciders.numberOfTiles() : null);
            if (ttr >= 10000 || !((value = colony.getDefenceRatio() * 10.0 + (double)ttr) < worstValue)) continue;
            worstValue = value;
            worstColony = colony;
        }
        return worstColony == null ? null : this.getDefendSettlementMission(aiUnit, worstColony);
    }

    public Mission getMissionaryMission(AIUnit aiUnit) {
        if (MissionaryMission.prepare(aiUnit) != null) {
            return null;
        }
        Location loc = MissionaryMission.findMissionTarget(aiUnit, 20, true);
        if (loc == null) {
            aiUnit.equipForRole(this.getSpecification().getDefaultRole());
            return null;
        }
        return new MissionaryMission(this.getAIMain(), aiUnit, loc);
    }

    public Mission getPioneeringMission(AIUnit aiUnit, Location target) {
        if (PioneeringMission.prepare(aiUnit) != null) {
            return null;
        }
        if (target == null) {
            target = PioneeringMission.findMissionTarget(aiUnit, 10, true);
        }
        if (target == null) {
            Unit unit = aiUnit.getUnit();
            if (unit.isInEurope() || unit.getSettlement() != null) {
                aiUnit.equipForRole(this.getSpecification().getDefaultRole());
            }
            return null;
        }
        return new PioneeringMission(this.getAIMain(), aiUnit, target);
    }

    public Mission getPrivateerMission(AIUnit aiUnit, Location target) {
        if (PrivateerMission.invalidMissionReason(aiUnit) != null) {
            return null;
        }
        if (target == null) {
            target = PrivateerMission.findMissionTarget(aiUnit, 1, true);
        }
        return target == null ? null : new PrivateerMission(this.getAIMain(), aiUnit, target);
    }

    public Mission getScoutingMission(AIUnit aiUnit) {
        if (ScoutingMission.prepare(aiUnit) != null) {
            return null;
        }
        Location loc = ScoutingMission.findMissionTarget(aiUnit, 20, true);
        if (loc == null) {
            Unit unit = aiUnit.getUnit();
            if (unit.isInEurope() || unit.getSettlement() != null) {
                aiUnit.equipForRole(this.getSpecification().getDefaultRole());
            }
            return null;
        }
        return new ScoutingMission(this.getAIMain(), aiUnit, loc);
    }

    public Mission getTransportMission(AIUnit aiUnit) {
        if (TransportMission.invalidMissionReason(aiUnit) != null) {
            return null;
        }
        return new TransportMission(this.getAIMain(), aiUnit);
    }

    private Mission getWishRealizationMission(AIUnit aiUnit, WorkerWish wish) {
        if (WishRealizationMission.invalidMissionReason(aiUnit) != null) {
            return null;
        }
        Unit unit = aiUnit.getUnit();
        if (wish == null) {
            wish = this.getBestWorkerWish(aiUnit, unit.getType());
        }
        if (wish == null) {
            return null;
        }
        this.consumeWorkerWish(aiUnit, wish);
        return new WishRealizationMission(this.getAIMain(), aiUnit, wish);
    }

    public Mission getWorkInsideColonyMission(AIUnit aiUnit, AIColony aiColony) {
        if (aiColony == null) {
            aiColony = this.getAIColony(aiUnit.getUnit().getColony());
        }
        if (WorkInsideColonyMission.invalidMissionReason(aiUnit, aiColony.getColony()) != null) {
            return null;
        }
        return aiColony == null ? null : new WorkInsideColonyMission(this.getAIMain(), aiUnit, aiColony);
    }

    @Override
    protected Stance determineStance(Player other) {
        Player player = this.getPlayer();
        return other.isREF() ? (player.getREFPlayer() == other ? (player.isRebel() ? Stance.WAR : Stance.PEACE) : (!other.getRebels().isEmpty() ? Stance.PEACE : super.determineStance(other))) : super.determineStance(other);
    }

    @Override
    public void startWorking() {
        Player player = this.getPlayer();
        Turn turn = this.getGame().getTurn();
        Specification spec = this.getSpecification();
        EuropeanAIPlayer.initializeFromSpecification(spec);
        if (this.getAIMain().getAIPlayer(player) != this) {
            throw new RuntimeException("EuropeanAIPlayer integrity fail: " + player);
        }
        this.clearAIUnits();
        player.clearNationCache();
        this.badlyDefended.clear();
        LogBuilder lb = new LogBuilder(1024);
        int colonyCount = this.getAIColonies().size();
        lb.add(player.getDebugName(), " in ", turn, "/", turn.getNumber(), " units=", this.getAIUnits().size(), " colonies=", colonyCount, " declare=", player.checkDeclareIndependence() == null, " v-land-REF=", player.getRebelStrengthRatio(false), " v-naval-REF=", player.getRebelStrengthRatio(true));
        if (turn.isFirstTurn()) {
            this.initializeMissions(lb);
        }
        if (this.isLikesAttackingNatives() && this.getGame().getTurn().getNumber() > 100) {
            for (Player p : this.getGame().getLivePlayerList(player)) {
                if (!p.isIndian()) continue;
                player.getTension(p).setValue(Tension.TENSION_MAX);
            }
        }
        this.determineStances(lb);
        if (colonyCount > 0) {
            lb.add("\n  Badly defended:");
            for (AIColony aic : this.getAIColonies()) {
                if (!aic.isBadlyDefended()) continue;
                this.badlyDefended.add(aic);
                lb.add(" ", aic.getColony());
            }
            lb.add("\n  Update colonies:");
            for (AIColony aic : this.getAIColonies()) {
                aic.update(lb);
            }
            this.buildTipMap(lb);
            this.buildWishMaps(lb);
        }
        this.cheat(lb);
        this.buyUnitsInEurope(lb);
        List<AIUnit> aiUnits = this.getAIUnits();
        Set<AIUnit> militaryUnits = this.getAIUnits().stream().filter(MilitaryCoordinator.isUnitHandledByMilitaryCoordinator()).collect(Collectors.toSet());
        MilitaryCoordinator militaryCoordinator = new MilitaryCoordinator(this, militaryUnits);
        militaryCoordinator.determineMissions();
        this.buildTransportMaps(lb);
        List<AIUnit> normalAiUnits = this.getAIUnits().stream().filter(MilitaryCoordinator.isUnitHandledByMilitaryCoordinator().negate()).collect(Collectors.toList());
        for (int i = 0; i < 3; ++i) {
            this.rearrangeColonies(lb);
            this.giveNormalMissions(lb, normalAiUnits);
            this.bringGifts(lb);
            this.demandTribute(lb);
            if (aiUnits.isEmpty()) break;
            aiUnits = this.doMissions(aiUnits, lb);
        }
        lb.log(logger, Level.FINE);
        this.clearAIUnits();
        this.tipMap.clear();
        this.transportDemand.clear();
        this.transportSupply.clear();
        this.wagonsNeeded.clear();
        this.goodsWishes.clear();
        this.workerWishes.clear();
    }

    private void buyUnitsInEurope(LogBuilder lb) {
        boolean militaryUnitBought;
        Player player = this.getPlayer();
        Europe europe = player.getEurope();
        if (player.getEurope() == null) {
            return;
        }
        long numberOfUnitsInDock = player.getEurope().getUnits().filter(unit -> !unit.isNaval()).count();
        long numberOfShips = this.getAIUnits().stream().filter(au -> au.getUnit().isNaval()).count();
        if (player.getEurope() != null && numberOfUnitsInDock > 6L && numberOfShips < 15L && !this.buyShip()) {
            return;
        }
        if (numberOfUnitsInDock > 30L) {
            return;
        }
        boolean bl = militaryUnitBought = numberOfUnitsInDock >= 18L;
        if (!militaryUnitBought) {
            Object unitBought;
            if (this.reallyNeedsMoreArtillery() || this.isLikesAttackingNatives() && this.needsMoreArtillery()) {
                unitBought = this.buyArtillery();
                if (unitBought == null) {
                    return;
                }
                militaryUnitBought = true;
            }
            if (this.reallyNeedsMoreDragoons() || this.isLikesAttackingNatives() && this.needsMoreDragoons()) {
                unitBought = this.buyDragoon();
                if (unitBought == null) {
                    return;
                }
                militaryUnitBought = true;
            }
        }
        for (Wish w : this.getWishes()) {
            int unitPrice;
            if (!(w instanceof WorkerWish) || w.getTransportable() != null) continue;
            WorkerWish workerWish = (WorkerWish)w;
            UnitType unitType = workerWish.getUnitType();
            if (!unitType.isAvailableTo(player) || (unitPrice = europe.getUnitPrice(unitType)) <= 0) continue;
            if (unitPrice > player.getGold()) {
                return;
            }
            AIUnit newUnit = this.trainAIUnitInEurope(unitType);
            if (newUnit != null) {
                this.getWishRealizationMission(newUnit, workerWish);
            }
            if (militaryUnitBought) continue;
            militaryUnitBought = true;
            Unit unitBought = this.buyDragoon();
            if (unitBought != null) continue;
            return;
        }
        for (int i = 0; i < 6; ++i) {
            Unit unitBought = this.buyDragoon();
            if (unitBought != null) continue;
            return;
        }
    }

    private boolean buyShip() {
        ArrayList<UnitType> unitTypes = new ArrayList<UnitType>(CollectionUtils.transform(this.getSpecification().getUnitTypeList(), ut -> ut.hasAbility("model.ability.navalUnit") && ut.isAvailableTo(this.getPlayer()) && ut.hasPrice() && ut.getSpace() > 0));
        Collections.shuffle(unitTypes);
        if (unitTypes.isEmpty()) {
            return false;
        }
        AbstractUnit au = new AbstractUnit((UnitType)unitTypes.get(0), "model.role.default", 1);
        int purchasePrice = this.getPlayer().getEuropeanPurchasePrice(au);
        if (purchasePrice <= 0 || purchasePrice == Integer.MAX_VALUE) {
            return false;
        }
        if (purchasePrice > this.getPlayer().getGold()) {
            return false;
        }
        this.getPlayer().modifyGold(-purchasePrice);
        List<Unit> createdUnit = ((ServerPlayer)this.getPlayer()).createUnits(List.of(au), this.getPlayer().getEurope(), this.getAIRandom());
        return true;
    }

    private boolean needsMoreDragoons() {
        return (long)(2 * (this.getAIColonies().size() + 1)) > this.getAIUnits().stream().filter(au -> au.getUnit().isMounted() && au.getUnit().isArmed()).count();
    }

    private boolean reallyNeedsMoreDragoons() {
        return (long)(this.getAIColonies().size() + 1) > this.getAIUnits().stream().filter(au -> au.getUnit().isMounted() && au.getUnit().isArmed()).count();
    }

    public boolean reallyNeedsMoreArtillery() {
        return (long)(this.getAIColonies().size() / 2 + 1) > this.getAIUnits().stream().filter(au -> au.getUnit().hasAbility("model.ability.bombard")).count();
    }

    public boolean needsMoreArtillery() {
        return (long)(this.getAIColonies().size() + 1) > this.getAIUnits().stream().filter(au -> au.getUnit().hasAbility("model.ability.bombard")).count();
    }

    private Unit buyDragoon() {
        Player player = this.getPlayer();
        Role dragoonRole = this.getSpecification().getMilitaryRolesList().stream().filter(r -> r.hasAbility("model.ability.armed") && r.hasAbility("model.ability.mounted")).findFirst().orElse(null);
        if (dragoonRole == null) {
            return null;
        }
        UnitType cheapestUnitType = this.getSpecification().getUnitTypesTrainedInEurope(this.getPlayer()).stream().filter(ut -> ut.getPrice() > 0 && ut.getPrice() != Integer.MAX_VALUE).sorted((a, b) -> Integer.compare(a.getPrice(), b.getPrice())).findFirst().orElse(null);
        if (cheapestUnitType == null) {
            return null;
        }
        AbstractUnit au = new AbstractUnit(cheapestUnitType, dragoonRole.getId(), 1);
        int purchasePrice = player.getEuropeanPurchasePrice(au);
        if (purchasePrice <= 0 || purchasePrice == Integer.MAX_VALUE) {
            return null;
        }
        if (purchasePrice > this.getPlayer().getGold()) {
            return null;
        }
        player.modifyGold(-purchasePrice);
        AbstractUnit auForCreation = new AbstractUnit(this.getSpecification().getDefaultUnitType(), dragoonRole.getId(), 1);
        List<Unit> createdUnit = ((ServerPlayer)player).createUnits(List.of(auForCreation), player.getEurope(), this.getAIRandom());
        if (createdUnit.isEmpty()) {
            return null;
        }
        return createdUnit.get(0);
    }

    private Unit buyArtillery() {
        Player player = this.getPlayer();
        Europe europe = player.getEurope();
        UnitType cheapestArtilleryUnitType = this.getSpecification().getUnitTypesPurchasedInEurope(this.getPlayer()).stream().filter(ut -> ut.getPrice() > 0 && ut.getPrice() != Integer.MAX_VALUE).filter(ut -> ut.hasAbility("model.ability.bombard")).filter(ut -> ut.isAvailableTo(player)).sorted((a, b) -> Integer.compare(a.getPrice(), b.getPrice())).findFirst().orElse(null);
        if (cheapestArtilleryUnitType == null) {
            return null;
        }
        int unitPrice = europe.getUnitPrice(cheapestArtilleryUnitType);
        if (unitPrice > player.getGold()) {
            return null;
        }
        AIUnit newUnit = this.trainAIUnitInEurope(cheapestArtilleryUnitType);
        if (newUnit == null) {
            return null;
        }
        return newUnit.getUnit();
    }

    @Override
    protected List<AIUnit> doMissions(List<AIUnit> aiUnits, LogBuilder lb) {
        lb.add("\n  Do missions:");
        ArrayList<AIUnit> result = new ArrayList<AIUnit>();
        for (AIUnit aiu : aiUnits) {
            Unit unit = aiu.getUnit();
            if (unit == null || unit.isDisposed()) continue;
            Mission oldMission = aiu.getMission();
            if (oldMission == null) {
                result.add(aiu);
                continue;
            }
            Location oldTarget = oldMission.getTarget();
            Location oldLocation = unit.getLocation();
            Colony oldColony = oldLocation.getColony();
            lb.add("\n  ", unit, " ");
            try {
                aiu.doMission(lb);
            }
            catch (Exception e) {
                lb.add(", EXCEPTION: ", e.getMessage());
                logger.log(Level.WARNING, "doMissions failed for: " + aiu, e);
            }
            if (unit.isDisposed() || unit.getLocation() == null) {
                aiu.dropTransport();
                lb.add(", DIED.");
                continue;
            }
            this.updateTransport(aiu, oldTarget, lb);
            if (unit.isDisposed() || unit.getLocation() == null) {
                lb.add(", DIED.");
                continue;
            }
            if (!(unit.getMovesLeft() <= 0 || unit.isOnCarrier() && unit.getCarrier().getMovesLeft() <= 0)) {
                lb.add("+");
                result.add(aiu);
            } else {
                lb.add(".");
            }
            Colony newColony = unit.getLocation().getColony();
            if (oldColony != null || newColony == null || !Map.isSameLocation(oldLocation, newColony)) continue;
            AIColony aiColony = this.getAIColony(newColony);
            aiColony.update(lb);
            this.updateTipMap(aiColony);
        }
        return result;
    }

    @Override
    public int adjustMission(AIUnit aiUnit, PathNode path, Class type, int value) {
        if (value > 0 && type == DefendSettlementMission.class) {
            Location loc = DefendSettlementMission.extractTarget(aiUnit, path);
            if (!(loc instanceof Colony)) {
                throw new IllegalStateException("European players defend colonies: " + loc);
            }
            Colony colony = (Colony)loc;
            int defenders = this.getSettlementDefenders(colony);
            value -= 25 * defenders;
            if (colony.hasStockade()) {
                value = defenders > colony.getStockade().getLevel() + 1 ? (value -= 100 * colony.getStockade().getLevel()) : (value -= 20 * colony.getStockade().getLevel());
            }
        }
        return value;
    }

    @Override
    public Constants.IndianDemandAction indianDemand(Unit unit, Colony colony, GoodsType goods, int gold, Constants.IndianDemandAction accept) {
        return "conquest".equals(this.getAIAdvantage()) ? Constants.IndianDemandAction.INDIAN_DEMAND_ACCEPT : Constants.IndianDemandAction.INDIAN_DEMAND_REJECT;
    }

    @Override
    public DiplomaticTrade.TradeStatus acceptDiplomaticTrade(DiplomaticTrade agreement) {
        Player player = this.getPlayer();
        Player other = agreement.getOtherPlayer(player);
        boolean franklin = other.hasAbility("model.ability.alwaysOfferedPeace");
        HashMap<TradeItem, Integer> scores = new HashMap<TradeItem, Integer>();
        TradeItem peace = null;
        DiplomaticTrade.TradeStatus result = null;
        LogBuilder lb = new LogBuilder(64);
        lb.add("Evaluate trade offer to ", player.getName(), " from ", other.getName());
        if (agreement.getVersion() == 0) {
            result = DiplomaticTrade.TradeStatus.PROPOSE_TRADE;
        } else {
            int unacceptable = 0;
            int value = 0;
            int colonies = 0;
            for (TradeItem tradeItem : agreement.getItems()) {
                if (tradeItem instanceof StanceTradeItem) {
                    this.getNationSummary(other);
                }
                int score = tradeItem.evaluateFor(player);
                if (tradeItem instanceof ColonyTradeItem) {
                    colonies = tradeItem.getSource() == player ? ++colonies : --colonies;
                } else if (tradeItem instanceof StanceTradeItem) {
                    switch (tradeItem.getStance()) {
                        case ALLIANCE: 
                        case CEASE_FIRE: {
                            if (!franklin) break;
                            peace = tradeItem;
                            score = 0;
                            break;
                        }
                        case UNCONTACTED: 
                        case PEACE: {
                            if (agreement.getContext() != DiplomaticTrade.TradeContext.CONTACT) break;
                            peace = tradeItem;
                            score = 0;
                            break;
                        }
                    }
                }
                if (score == Integer.MIN_VALUE) {
                    ++unacceptable;
                } else {
                    value += score;
                }
                scores.put(tradeItem, score);
                lb.add(", ", Messages.message(tradeItem.getLabel()), " = ", score);
            }
            lb.add(".");
            if (colonies > 0 && colonies > player.getSettlementCount() - 5) {
                result = this.rejectAgreement(peace, agreement);
                lb.add("  Too many (", colonies, ") colonies lost.");
            } else if (unacceptable == 0 && value >= 0) {
                result = DiplomaticTrade.TradeStatus.ACCEPT_TRADE;
                lb.add("  All accepted at ", value, ".");
            } else {
                double ratio = (double)unacceptable / (double)(unacceptable + agreement.getItems().size());
                if (ratio > 0.5 - 0.5 * (double)agreement.getVersion()) {
                    result = this.rejectAgreement(peace, agreement);
                    lb.add("  Too many (", unacceptable, ") unacceptable.");
                }
            }
            if (result == null) {
                value = 0;
                for (Map.Entry entry : scores.entrySet()) {
                    if ((Integer)entry.getValue() == Integer.MIN_VALUE) {
                        agreement.remove((TradeItem)entry.getKey());
                        lb.add("  Dropped invalid ", entry.getKey(), ".");
                        continue;
                    }
                    lb.add("  Added valid ", entry.getKey(), ", total = ", value += ((Integer)entry.getValue()).intValue(), ".");
                }
                if (agreement.isEmpty()) {
                    result = this.rejectAgreement(peace, agreement);
                }
            }
            if (RandomUtils.randomInt(logger, "Enough diplomacy?", this.getAIRandom(), 1 + agreement.getVersion()) > 5) {
                result = this.rejectAgreement(peace, agreement);
                lb.add("  Ran out of patience at ", agreement.getVersion(), ".");
            }
            if (result == null) {
                for (Map.Entry entry : CollectionUtils.mapEntriesByValue(scores, CollectionUtils.ascendingIntegerComparator)) {
                    if (value >= 0) break;
                    TradeItem item = (TradeItem)entry.getKey();
                    if ((value -= ((Integer)entry.getValue()).intValue()) >= 50 && item instanceof GoldTradeItem) {
                        GoldTradeItem gti = (GoldTradeItem)item;
                        gti.setGold(gti.getGold() - value / 2);
                        value /= 2;
                        lb.add("  Reducing gold item to ", gti.getGold(), ".");
                        continue;
                    }
                    agreement.remove(item);
                    lb.add("  Dropped ", item, ", value now = ", value, ".");
                }
                if (value >= 0 && !agreement.isEmpty()) {
                    result = DiplomaticTrade.TradeStatus.PROPOSE_TRADE;
                    lb.add("  Pruned until acceptable at ", value, ".");
                } else {
                    result = this.rejectAgreement(peace, agreement);
                    lb.add("  Agreement unsalvageable at ", value, ".");
                }
            }
        }
        lb.add(new Object[]{" => ", result});
        lb.log(logger, Level.INFO);
        return result;
    }

    @Override
    public NativeTrade.NativeTradeAction handleTrade(NativeTrade.NativeTradeAction action, NativeTrade nt) {
        return NativeTrade.NativeTradeAction.NAK_INVALID;
    }

    @Override
    public boolean acceptTax(int tax) {
        GoodsType goodsType;
        boolean ret = true;
        LogBuilder lb = new LogBuilder(64);
        Goods toBeDestroyed = this.getPlayer().getMostValuableGoods();
        lb.add("Tax demand to ", this.getPlayer().getName(), " of ", tax, "% with ", this.getPlayer().getMostValuableGoods(), " ");
        GoodsType goodsType2 = goodsType = toBeDestroyed == null ? null : toBeDestroyed.getType();
        if (tax <= 2) {
            ret = true;
            lb.add("accepted: small rise.");
        } else if (toBeDestroyed == null) {
            ret = false;
            lb.add("rejected: no-goods-under-threat.");
        } else if (goodsType.isFoodType()) {
            ret = false;
            lb.add("rejected: food-type.");
        } else if (goodsType.isBreedable()) {
            int n = CollectionUtils.count(this.getPlayer().getSettlements(), s -> s.getGoodsCount(goodsType) > 0);
            boolean bl = ret = n < 2;
            if (ret) {
                lb.add("accepted: breedable-type-", goodsType.getSuffix(), "-missing.");
            } else {
                lb.add("rejected: breedable-type-", goodsType.getSuffix(), "-present-in-", n, "-settlements.");
            }
        } else if (goodsType.getMilitary() || goodsType.isTradeGoods() || goodsType.isBuildingMaterial()) {
            int turn = this.getGame().getTurn().getNumber();
            ret = turn < 300;
            lb.add(ret ? "accepted" : "rejected", ": special-goods-in-turn-", turn, ".");
        } else {
            List<GoodsType> goodsTypes = this.getSpecification().getStorableGoodsTypeList();
            int averageIncome = CollectionUtils.sum(goodsTypes, gt -> this.getPlayer().getIncomeAfterTaxes((GoodsType)gt)) / goodsTypes.size();
            int income = this.getPlayer().getIncomeAfterTaxes(toBeDestroyed.getType());
            ret = income <= 0 || income > averageIncome;
            lb.add(ret ? "accepted" : "rejected", ": goods(", goodsType.getSuffix(), ")-with-income(", income, ret ? ")non-positive-or-more-than(" : ")less-than-average(", averageIncome, ").");
        }
        if (!ret) {
            this.suppressEuropeanTrade(goodsType, lb);
        }
        lb.log(logger, Level.INFO);
        return ret;
    }

    @Override
    public boolean acceptMercenaries() {
        return this.getPlayer().isAtWar() || "conquest".equals(this.getAIAdvantage());
    }

    @Override
    public FoundingFather selectFoundingFather(List<FoundingFather> ffs) {
        int age = this.getGame().getAge();
        FoundingFather bestFather = null;
        int bestWeight = Integer.MIN_VALUE;
        for (FoundingFather father : ffs) {
            if (father == null) continue;
            if (father.hasAbility("model.ability.buildCustomHouse")) {
                bestFather = father;
                break;
            }
            int weight = father.getWeight(age);
            if (weight <= bestWeight) continue;
            bestWeight = weight;
            bestFather = father;
        }
        return bestFather;
    }

    @Override
    public int getNeededWagons(Tile tile) {
        Integer i;
        int contig;
        if (tile != null && (contig = tile.getContiguity()) > 0 && (i = this.wagonsNeeded.get(contig)) != null) {
            return i;
        }
        return 0;
    }

    @Override
    public int pioneersNeeded() {
        return (this.tipMap.size() + 1) / 2;
    }

    @Override
    public int scoutsNeeded() {
        return 3 - this.getGame().getTurn().getNumber() / 100;
    }

    @Override
    public void completeWish(Wish w) {
        if (w instanceof WorkerWish) {
            WorkerWish ww = (WorkerWish)w;
            List<WorkerWish> wl = this.workerWishes.get(ww.getUnitType());
            if (wl != null) {
                wl.remove(ww);
            }
        } else if (w instanceof GoodsWish) {
            GoodsWish gw = (GoodsWish)w;
            List<GoodsWish> gl = this.goodsWishes.get(gw.getGoodsType());
            if (gl != null) {
                gl.remove(gw);
            }
        } else {
            throw new IllegalStateException("Bogus wish: " + w);
        }
    }

    static {
        pioneerRole = null;
        scoutRole = null;
    }
}

