/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.military;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.stream.Collectors;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Stance;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.pathfinding.CostDecider;
import net.sf.freecol.common.model.pathfinding.CostDeciders;
import net.sf.freecol.server.ai.AIColony;
import net.sf.freecol.server.ai.EuropeanAIPlayer;
import net.sf.freecol.server.ai.military.DefensiveZone;

public class DefensiveMap {
    private static final int ZONE_SIZE_TURNS = 3;
    private final Map<AIColony, DefensiveZone> defensiveZones;
    private Map<String, DefensiveZone> tileDefensiveZone;

    private DefensiveMap(Map<AIColony, DefensiveZone> defensiveZones, Map<String, DefensiveZone> tileDefensiveZone) {
        this.defensiveZones = defensiveZones;
        this.tileDefensiveZone = tileDefensiveZone;
    }

    public DefensiveZone getDefensiveZone(Tile tile) {
        return this.tileDefensiveZone.get(tile.getId());
    }

    public List<DefensiveZone> getDefensiveZones() {
        return new ArrayList<DefensiveZone>(this.defensiveZones.values());
    }

    public List<DefensiveZone> getAttackedDefensiveZones() {
        return this.defensiveZones.values().stream().filter(dz -> dz.getNumberOfMilitaryEnemies() > 0).collect(Collectors.toList());
    }

    public List<AIColony> getAttackedColonies() {
        return this.getAttackedDefensiveZones().stream().map(DefensiveZone::getAiColony).collect(Collectors.toList());
    }

    public List<AIColony> getThreatenedColonies() {
        return this.defensiveZones.values().stream().filter(dz -> dz.isEnemiesInNeighbour() || dz.getNumberOfPotentialMilitaryEnemies() > 0).map(DefensiveZone::getAiColony).collect(Collectors.toList());
    }

    public List<AIColony> getColoniesExposedLand() {
        return this.defensiveZones.values().stream().filter(dz -> dz.isExposedLand()).map(DefensiveZone::getAiColony).collect(Collectors.toList());
    }

    public List<AIColony> getColoniesExposedWater() {
        return this.defensiveZones.values().stream().filter(dz -> dz.isExposedWater()).map(DefensiveZone::getAiColony).collect(Collectors.toList());
    }

    public static DefensiveMap createDefensiveMap(EuropeanAIPlayer aiPlayer) {
        List<AIColony> colonies = aiPlayer.getAIColonies();
        if (colonies.isEmpty()) {
            return new DefensiveMap(new HashMap<AIColony, DefensiveZone>(), new HashMap<String, DefensiveZone>());
        }
        HashMap<AIColony, DefensiveZone> defensiveZones = new HashMap<AIColony, DefensiveZone>();
        HashMap<String, DefensiveZone> tileDefensiveZone = new HashMap<String, DefensiveZone>();
        PriorityQueue<SearchNode> openMapQueue = new PriorityQueue<SearchNode>(1024, Comparator.comparingInt(SearchNode::getCost));
        HashMap<String, SearchNode> openMap = new HashMap<String, SearchNode>();
        HashMap<String, SearchNode> closedMap = new HashMap<String, SearchNode>();
        boolean movesLeft = true;
        for (AIColony ac : colonies) {
            DefensiveZone defensiveZone = new DefensiveZone(ac);
            defensiveZones.put(ac, defensiveZone);
            openMapQueue.add(new SearchNode(ac.getColony().getTile(), null, 1, 0, defensiveZone, 0));
        }
        CostDecider costDecider = CostDeciders.numberOfTiles();
        while (!openMapQueue.isEmpty()) {
            SearchNode searchNode = openMapQueue.poll();
            closedMap.put(searchNode.getTile().getId(), searchNode);
            tileDefensiveZone.put(searchNode.getTile().getId(), searchNode.defensiveZone);
            if (searchNode.getTile().hasSettlement()) {
                Settlement settlement = searchNode.getTile().getSettlement();
                if (aiPlayer.getPlayer().getStance(settlement.getOwner()) != Stance.ALLIANCE) {
                    searchNode.defensiveZone.addPotentialEnemySettlement(settlement);
                }
            } else {
                Set<Unit> enemyUnits = searchNode.getTile().getUnits().filter(u -> !aiPlayer.getPlayer().equals(u.getOwner()) && aiPlayer.getPlayer().getStance(u.getOwner()) != Stance.ALLIANCE).collect(Collectors.toSet());
                searchNode.defensiveZone.addAllPotentialEnemies(enemyUnits);
            }
            for (Tile tile : searchNode.getTile().getSurroundingTiles(1)) {
                if (!tile.isLand()) {
                    if (searchNode.previous == null) continue;
                    searchNode.previous.defensiveZone.setExposedWater(true);
                    continue;
                }
                SearchNode closedMatch = (SearchNode)closedMap.get(tile.getId());
                if (closedMatch != null) {
                    if (searchNode.defensiveZone == closedMatch.defensiveZone) continue;
                    closedMatch.defensiveZone.addNeighbour(searchNode.defensiveZone);
                    continue;
                }
                int cost = costDecider.getCost(null, searchNode.getTile(), tile, searchNode.movesLeft);
                SearchNode newSearchNode = new SearchNode(tile, searchNode, costDecider.getMovesLeft(), searchNode.turns + costDecider.getNewTurns(), searchNode.defensiveZone, searchNode.getCost() + cost);
                if (openMap.containsKey(tile.getId())) continue;
                if (newSearchNode.cost > 3) {
                    searchNode.defensiveZone.setExposedLand(true);
                    continue;
                }
                openMapQueue.add(newSearchNode);
                openMap.put(tile.getId(), newSearchNode);
            }
        }
        block3: for (DefensiveZone defensiveZone : defensiveZones.values()) {
            for (DefensiveZone neighbour : defensiveZone.getNeighbours()) {
                if (neighbour.getNumberOfMilitaryEnemies() <= 0) continue;
                defensiveZone.setEnemiesInNeighbour(true);
                continue block3;
            }
        }
        return new DefensiveMap(defensiveZones, tileDefensiveZone);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<AIColony, DefensiveZone> entry : this.defensiveZones.entrySet()) {
            sb.append(entry.getKey().getColony().getName());
            sb.append(": exposedLand=" + entry.getValue().isExposedLand());
            sb.append(": exposedWater=" + entry.getValue().isExposedWater());
            sb.append(" enemies=" + entry.getValue().getNumberOfMilitaryEnemies() + "\n");
        }
        return sb.toString();
    }

    private static final class SearchNode {
        private final Tile tile;
        private final SearchNode previous;
        private final int turns;
        private final int movesLeft;
        private final DefensiveZone defensiveZone;
        private final int cost;

        public SearchNode(Tile tile, SearchNode previous, int movesLeft, int turns, DefensiveZone defensiveZone, int cost) {
            this.tile = Objects.requireNonNull(tile);
            this.previous = previous;
            this.turns = turns;
            this.movesLeft = movesLeft;
            this.defensiveZone = Objects.requireNonNull(defensiveZone);
            this.cost = cost;
        }

        int getCost() {
            return this.cost;
        }

        Tile getTile() {
            return this.tile;
        }
    }
}

