/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.model;

import java.util.Iterator;
import java.util.List;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.server.ServerTestHelper;
import net.sf.freecol.server.model.ServerBuilding;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerUnit;
import net.sf.freecol.util.test.FreeColTestCase;
import net.sf.freecol.util.test.FreeColTestUtils;

public class ServerBuildingTest
extends FreeColTestCase {
    private static final BuildingType collegeType = ServerBuildingTest.spec().getBuildingType("model.building.college");
    private static final BuildingType lumberMillType = ServerBuildingTest.spec().getBuildingType("model.building.lumberMill");
    private static final BuildingType schoolType = ServerBuildingTest.spec().getBuildingType("model.building.schoolhouse");
    private static final BuildingType townHallType = ServerBuildingTest.spec().getBuildingType("model.building.townHall");
    private static final BuildingType universityType = ServerBuildingTest.spec().getBuildingType("model.building.university");
    private static final GoodsType bellsType = ServerBuildingTest.spec().getGoodsType("model.goods.bells");
    private static final GoodsType foodType = ServerBuildingTest.spec().getGoodsType("model.goods.food");
    private static final GoodsType grainType = ServerBuildingTest.spec().getGoodsType("model.goods.grain");
    private static final UnitType freeColonistType = ServerBuildingTest.spec().getUnitType("model.unit.freeColonist");
    private static final UnitType indenturedServantType = ServerBuildingTest.spec().getUnitType("model.unit.indenturedServant");
    private static final UnitType pettyCriminalType = ServerBuildingTest.spec().getUnitType("model.unit.pettyCriminal");
    private static final UnitType expertOreMinerType = ServerBuildingTest.spec().getUnitType("model.unit.expertOreMiner");
    private static final UnitType expertLumberJackType = ServerBuildingTest.spec().getUnitType("model.unit.expertLumberJack");
    private static final UnitType masterCarpenterType = ServerBuildingTest.spec().getUnitType("model.unit.masterCarpenter");
    private static final UnitType masterBlacksmithType = ServerBuildingTest.spec().getUnitType("model.unit.masterBlacksmith");
    private static final UnitType veteranSoldierType = ServerBuildingTest.spec().getUnitType("model.unit.veteranSoldier");
    private static final UnitType elderStatesmanType = ServerBuildingTest.spec().getUnitType("model.unit.elderStatesman");
    private static final UnitType colonialRegularType = ServerBuildingTest.spec().getUnitType("model.unit.colonialRegular");

    private Colony getSchoolColony(int n, SchoolLevel slevel) {
        Colony colony = this.getStandardColony(n);
        for (Unit u : colony.getUnitList()) {
            u.setType(elderStatesmanType);
        }
        BuildingType type = null;
        switch (slevel) {
            case SCHOOLHOUSE: {
                type = schoolType;
                break;
            }
            case COLLEGE: {
                type = collegeType;
                break;
            }
            case UNIVERSITY: {
                type = universityType;
                break;
            }
            default: {
                ServerBuildingTest.fail((String)"Setup error, cannot setup school");
            }
        }
        ServerBuilding school = new ServerBuilding(colony.getGame(), colony, type);
        colony.addBuilding(school);
        ServerBuildingTest.assertEquals((int)school.getUnitList().size(), (int)0);
        colony.addGoods(grainType, 150);
        return colony;
    }

    private void trainForTurns(Colony colony, int requiredTurns) {
        for (int turn = 0; turn < requiredTurns; ++turn) {
            ServerTestHelper.newTurn();
        }
    }

    private List<Unit> getUnitList(Colony colony, UnitType type) {
        return CollectionUtils.transform(colony.getUnits(), CollectionUtils.matchKey(type, Unit::getType));
    }

    public void testExpertTeaching() {
        ServerGame game = ServerTestHelper.startServerGame(ServerBuildingTest.getTestMap(true));
        boolean selection = FreeColTestUtils.setStudentSelection(false);
        Colony colony = this.getSchoolColony(4, SchoolLevel.SCHOOLHOUSE);
        Building school = colony.getBuilding(schoolType);
        ServerBuildingTest.assertTrue((boolean)school.canTeach());
        Iterator<Unit> units = colony.getUnitList().iterator();
        Unit colonist = units.next();
        colonist.setType(freeColonistType);
        colonist.setLocation(colony.getBuilding(townHallType));
        Unit lumber = units.next();
        lumber.setType(expertLumberJackType);
        Unit black = units.next();
        black.setType(masterBlacksmithType);
        Unit ore = units.next();
        ore.setType(expertOreMinerType);
        ServerBuildingTest.assertTrue((boolean)colony.canTrain(ore));
        ore.setLocation(school);
        ServerBuildingTest.assertEquals((Object)ore.getStudent(), (Object)colonist);
        this.trainForTurns(colony, ore.getNeededTurnsOfTraining());
        ServerBuildingTest.assertEquals((Object)expertOreMinerType, (Object)colonist.getType());
        FreeColTestUtils.setStudentSelection(selection);
    }

    public void testCollege() {
        ServerGame game = ServerTestHelper.startServerGame(ServerBuildingTest.getTestMap(true));
        boolean selection = FreeColTestUtils.setStudentSelection(false);
        Colony colony = this.getSchoolColony(4, SchoolLevel.COLLEGE);
        Building college = colony.getBuilding(collegeType);
        Iterator<Unit> units = colony.getUnitList().iterator();
        Unit colonist = units.next();
        colonist.setType(freeColonistType);
        colonist.setLocation(colony.getBuilding(townHallType));
        Unit blackSmith = units.next();
        blackSmith.setType(masterBlacksmithType);
        blackSmith.setLocation(college);
        ServerBuildingTest.assertEquals((Object)blackSmith.getStudent(), (Object)colonist);
        this.trainForTurns(colony, blackSmith.getNeededTurnsOfTraining());
        ServerBuildingTest.assertEquals((Object)masterBlacksmithType, (Object)colonist.getType());
        FreeColTestUtils.setStudentSelection(selection);
    }

    public void testUniversity() {
        ServerGame game = ServerTestHelper.startServerGame(ServerBuildingTest.getTestMap(true));
        boolean selection = FreeColTestUtils.setStudentSelection(false);
        Colony colony = this.getSchoolColony(4, SchoolLevel.UNIVERSITY);
        ServerBuildingTest.assertEquals((int)4, (int)colony.getUnitCount());
        Building university = colony.getBuilding(universityType);
        ServerBuildingTest.assertNotNull((Object)university);
        Iterator<Unit> units = colony.getUnitList().iterator();
        Unit colonist = units.next();
        colonist.setType(freeColonistType);
        colonist.setLocation(colony.getBuilding(townHallType));
        Unit elder = units.next();
        ServerBuildingTest.assertEquals((Object)elder.getType(), (Object)elderStatesmanType);
        elder.setLocation(university);
        ServerBuildingTest.assertEquals((Object)elder.getStudent(), (Object)colonist);
        this.trainForTurns(colony, elder.getNeededTurnsOfTraining());
        ServerBuildingTest.assertEquals((Object)elderStatesmanType, (Object)colonist.getType());
        FreeColTestUtils.setStudentSelection(selection);
    }

    public void testTrackerBug1616384() {
        ServerGame game = ServerTestHelper.startServerGame(ServerBuildingTest.getTestMap(true));
        boolean selection = FreeColTestUtils.setStudentSelection(false);
        Colony colony = this.getSchoolColony(8, SchoolLevel.COLLEGE);
        colony.addGoods(foodType, 100);
        Building townHall = colony.getBuilding(townHallType);
        Building lumberMill = colony.getBuilding(lumberMillType);
        Building college = colony.getBuilding(collegeType);
        Iterator<Unit> units = colony.getUnitList().iterator();
        this.clearWorkLocation(townHall);
        Unit colonist1 = units.next();
        colonist1.setType(freeColonistType);
        colonist1.setLocation(townHall);
        Unit colonist2 = units.next();
        colonist2.setType(freeColonistType);
        colonist2.setLocation(townHall);
        this.clearWorkLocation(lumberMill);
        Unit colonist3 = units.next();
        colonist3.setType(freeColonistType);
        colonist3.setLocation(lumberMill);
        Unit colonist4 = units.next();
        colonist4.setType(freeColonistType);
        colonist4.setLocation(lumberMill);
        Unit lumberjack = units.next();
        lumberjack.setType(expertLumberJackType);
        Unit blacksmith = units.next();
        blacksmith.setType(masterBlacksmithType);
        Unit veteran = units.next();
        veteran.setType(veteranSoldierType);
        Unit ore = units.next();
        ore.setType(expertOreMinerType);
        this.clearWorkLocation(college);
        lumberjack.setLocation(college);
        ServerBuildingTest.assertNotNull((Object)lumberjack.getStudent());
        blacksmith.setLocation(college);
        ServerBuildingTest.assertNotNull((Object)blacksmith.getStudent());
        ServerBuildingTest.assertEquals((int)4, (int)this.getUnitList(colony, freeColonistType).size());
        ServerBuildingTest.assertEquals((int)1, (int)this.getUnitList(colony, expertLumberJackType).size());
        ServerBuildingTest.assertEquals((int)1, (int)this.getUnitList(colony, masterBlacksmithType).size());
        while (4 == this.getUnitList(colony, freeColonistType).size()) {
            ServerTestHelper.newTurn();
        }
        ServerBuildingTest.assertEquals((int)3, (int)this.getUnitList(colony, freeColonistType).size());
        ServerBuildingTest.assertEquals((int)2, (int)this.getUnitList(colony, expertLumberJackType).size());
        ServerBuildingTest.assertEquals((int)1, (int)this.getUnitList(colony, masterBlacksmithType).size());
        lumberjack.setLocation(colony.getWorkLocationFor(lumberjack, grainType));
        ServerBuildingTest.assertNull((Object)lumberjack.getStudent());
        Unit smithToBe = blacksmith.getStudent();
        ServerBuildingTest.assertNotNull((Object)smithToBe);
        ore.setLocation(college);
        ServerBuildingTest.assertNotNull((Object)ore.getStudent());
        while (3 == this.getUnitList(colony, freeColonistType).size()) {
            ServerTestHelper.newTurn();
        }
        ServerBuildingTest.assertEquals((Object)masterBlacksmithType, (Object)smithToBe.getType());
        ServerBuildingTest.assertEquals((int)2, (int)this.getUnitList(colony, freeColonistType).size());
        ServerBuildingTest.assertEquals((int)1, (int)this.getUnitList(colony, expertOreMinerType).size());
        ServerBuildingTest.assertEquals((int)2, (int)this.getUnitList(colony, masterBlacksmithType).size());
        blacksmith.setLocation(colony.getWorkLocationFor(blacksmith, grainType));
        ServerBuildingTest.assertNull((Object)blacksmith.getStudent());
        veteran.setLocation(college);
        ServerBuildingTest.assertNotNull((Object)veteran.getStudent());
        while (2 == this.getUnitList(colony, freeColonistType).size()) {
            ServerTestHelper.newTurn();
        }
        ServerBuildingTest.assertEquals((int)1, (int)this.getUnitList(colony, freeColonistType).size());
        ServerBuildingTest.assertEquals((int)2, (int)this.getUnitList(colony, expertOreMinerType).size());
        ore.setLocation(colony.getWorkLocationFor(ore, grainType));
        ServerBuildingTest.assertNull((Object)ore.getStudent());
        while (1 == this.getUnitList(colony, freeColonistType).size()) {
            ServerTestHelper.newTurn();
        }
        ServerBuildingTest.assertEquals((int)0, (int)this.getUnitList(colony, freeColonistType).size());
        ServerBuildingTest.assertEquals((int)2, (int)this.getUnitList(colony, veteranSoldierType).size());
        FreeColTestUtils.setStudentSelection(selection);
    }

    public void testTwoTeachersSimple() {
        boolean selection = FreeColTestUtils.setStudentSelection(false);
        ServerGame game = ServerTestHelper.startServerGame(ServerBuildingTest.getTestMap(true));
        Colony colony = this.getSchoolColony(5, SchoolLevel.UNIVERSITY);
        colony.addGoods(foodType, 100);
        Building university = colony.getBuilding(universityType);
        Building townHall = colony.getBuilding(townHallType);
        this.clearWorkLocation(townHall);
        Iterator<Unit> units = colony.getUnitList().iterator();
        Unit colonist1 = units.next();
        colonist1.setType(freeColonistType);
        colonist1.setLocation(townHall);
        Unit colonist2 = units.next();
        colonist2.setType(freeColonistType);
        colonist2.setLocation(townHall);
        Unit colonist3 = units.next();
        colonist3.setType(freeColonistType);
        colonist3.setLocation(townHall);
        Unit black = units.next();
        black.setType(masterBlacksmithType);
        black.setLocation(university);
        Unit ore = units.next();
        ore.setType(expertOreMinerType);
        ore.setLocation(university);
        ServerBuildingTest.assertTrue((String)"Should be longer to train blacksmith then ore miner", (black.getNeededTurnsOfTraining() > ore.getNeededTurnsOfTraining() ? 1 : 0) != 0);
        ServerBuildingTest.assertEquals((int)3, (int)this.getUnitList(colony, freeColonistType).size());
        ServerBuildingTest.assertEquals((int)1, (int)this.getUnitList(colony, masterBlacksmithType).size());
        ServerBuildingTest.assertEquals((int)1, (int)this.getUnitList(colony, expertOreMinerType).size());
        this.trainForTurns(colony, ore.getNeededTurnsOfTraining());
        ServerBuildingTest.assertEquals((int)2, (int)this.getUnitList(colony, freeColonistType).size());
        ServerBuildingTest.assertEquals((int)1, (int)this.getUnitList(colony, masterBlacksmithType).size());
        ServerBuildingTest.assertEquals((int)2, (int)this.getUnitList(colony, expertOreMinerType).size());
        ServerBuildingTest.assertNotNull((Object)ore.getStudent());
        ServerBuildingTest.assertNotNull((Object)black.getStudent());
        this.trainForTurns(colony, black.getNeededTurnsOfTraining() - black.getTurnsOfTraining());
        ServerBuildingTest.assertEquals((int)1, (int)this.getUnitList(colony, freeColonistType).size());
        ServerBuildingTest.assertEquals((int)2, (int)this.getUnitList(colony, masterBlacksmithType).size());
        ServerBuildingTest.assertEquals((int)2, (int)this.getUnitList(colony, expertOreMinerType).size());
        FreeColTestUtils.setStudentSelection(selection);
    }

    public void testSingleGuyTwoTeachers() {
        boolean selection = FreeColTestUtils.setStudentSelection(false);
        ServerGame game = ServerTestHelper.startServerGame(ServerBuildingTest.getTestMap(true));
        Colony colony = this.getSchoolColony(4, SchoolLevel.UNIVERSITY);
        Building university = colony.getBuilding(universityType);
        Iterator<Unit> units = colony.getUnitList().iterator();
        Unit colonist = units.next();
        colonist.setType(freeColonistType);
        Building townHall = colony.getBuilding(townHallType);
        this.clearWorkLocation(townHall);
        colonist.setLocation(townHall);
        Unit lumberJack = units.next();
        lumberJack.setType(expertLumberJackType);
        Unit blackSmith = units.next();
        blackSmith.setType(masterBlacksmithType);
        blackSmith.setLocation(university);
        lumberJack.setLocation(university);
        ServerBuildingTest.assertTrue((colonist.getTeacher() == blackSmith ? 1 : 0) != 0);
        ServerBuildingTest.assertNull((Object)lumberJack.getStudent());
        ServerBuildingTest.assertEquals((int)1, (int)this.getUnitList(colony, freeColonistType).size());
        ServerBuildingTest.assertEquals((int)1, (int)this.getUnitList(colony, expertLumberJackType).size());
        ServerBuildingTest.assertEquals((int)1, (int)this.getUnitList(colony, masterBlacksmithType).size());
        this.trainForTurns(colony, blackSmith.getNeededTurnsOfTraining());
        ServerBuildingTest.assertEquals((int)0, (int)this.getUnitList(colony, freeColonistType).size());
        ServerBuildingTest.assertEquals((int)1, (int)this.getUnitList(colony, expertLumberJackType).size());
        ServerBuildingTest.assertEquals((int)2, (int)this.getUnitList(colony, masterBlacksmithType).size());
        FreeColTestUtils.setStudentSelection(selection);
    }

    public void testTwoTeachersOfSameKind() {
        boolean selection = FreeColTestUtils.setStudentSelection(false);
        ServerGame game = ServerTestHelper.startServerGame(ServerBuildingTest.getTestMap(true));
        Colony colony = this.getSchoolColony(4, SchoolLevel.UNIVERSITY);
        Building university = colony.getBuilding(universityType);
        Iterator<Unit> units = colony.getUnitList().iterator();
        Unit colonist = units.next();
        colonist.setType(freeColonistType);
        Building townHall = colony.getBuilding(townHallType);
        this.clearWorkLocation(townHall);
        colonist.setLocation(townHall);
        Unit lumberjack1 = units.next();
        lumberjack1.setType(expertLumberJackType);
        Unit lumberjack2 = units.next();
        lumberjack2.setType(expertLumberJackType);
        lumberjack1.setLocation(university);
        lumberjack2.setLocation(university);
        ServerBuildingTest.assertEquals((Object)colonist, (Object)lumberjack1.getStudent());
        ServerBuildingTest.assertNull((Object)lumberjack2.getStudent());
        for (int i = lumberjack1.getNeededTurnsOfTraining(); i > 0; --i) {
            ServerBuildingTest.assertEquals((int)1, (int)this.getUnitList(colony, freeColonistType).size());
            this.trainForTurns(colony, 1);
        }
        ServerBuildingTest.assertEquals((int)0, (int)this.getUnitList(colony, freeColonistType).size());
        ServerBuildingTest.assertEquals((int)3, (int)this.getUnitList(colony, expertLumberJackType).size());
        FreeColTestUtils.setStudentSelection(selection);
    }

    public void testSingleGuyTwoTeachers2() {
        boolean selection = FreeColTestUtils.setStudentSelection(false);
        ServerGame game = ServerTestHelper.startServerGame(ServerBuildingTest.getTestMap(true));
        Colony colony = this.getSchoolColony(4, SchoolLevel.UNIVERSITY);
        Building university = colony.getBuilding(universityType);
        Iterator<Unit> units = colony.getUnitList().iterator();
        Unit colonist = units.next();
        colonist.setType(freeColonistType);
        Building townHall = colony.getBuilding(townHallType);
        this.clearWorkLocation(townHall);
        colonist.setLocation(townHall);
        Unit lumber = units.next();
        lumber.setType(expertLumberJackType);
        Unit ore = units.next();
        ore.setType(expertOreMinerType);
        lumber.setLocation(university);
        ore.setLocation(university);
        ServerBuildingTest.assertEquals((Object)colonist.getTeacher(), (Object)lumber);
        ServerBuildingTest.assertNull((Object)ore.getStudent());
        ServerBuildingTest.assertEquals((int)1, (int)this.getUnitList(colony, freeColonistType).size());
        ServerBuildingTest.assertEquals((int)1, (int)this.getUnitList(colony, expertLumberJackType).size());
        ServerBuildingTest.assertEquals((int)1, (int)this.getUnitList(colony, expertOreMinerType).size());
        ServerTestHelper.newTurn();
        ServerBuildingTest.assertEquals((int)1, (int)this.getUnitList(colony, freeColonistType).size());
        ServerBuildingTest.assertEquals((int)1, (int)this.getUnitList(colony, expertLumberJackType).size());
        ServerBuildingTest.assertEquals((int)1, (int)this.getUnitList(colony, expertOreMinerType).size());
        ServerTestHelper.newTurn();
        ServerBuildingTest.assertEquals((int)1, (int)this.getUnitList(colony, freeColonistType).size());
        ServerBuildingTest.assertEquals((int)1, (int)this.getUnitList(colony, expertLumberJackType).size());
        ServerBuildingTest.assertEquals((int)1, (int)this.getUnitList(colony, expertOreMinerType).size());
        ServerTestHelper.newTurn();
        ServerBuildingTest.assertEquals((int)1, (int)this.getUnitList(colony, freeColonistType).size());
        ServerBuildingTest.assertEquals((int)1, (int)this.getUnitList(colony, expertLumberJackType).size());
        ServerBuildingTest.assertEquals((int)1, (int)this.getUnitList(colony, expertOreMinerType).size());
        ServerTestHelper.newTurn();
        ServerBuildingTest.assertEquals((int)0, (int)this.getUnitList(colony, freeColonistType).size());
        ServerBuildingTest.assertEquals((int)2, (int)this.getUnitList(colony, expertLumberJackType).size());
        ServerBuildingTest.assertEquals((int)1, (int)this.getUnitList(colony, expertOreMinerType).size());
        FreeColTestUtils.setStudentSelection(selection);
    }

    public void testTeachPettyCriminals() {
        boolean selection = FreeColTestUtils.setStudentSelection(false);
        ServerGame game = ServerTestHelper.startServerGame(ServerBuildingTest.getTestMap(true));
        Colony colony = this.getSchoolColony(4, SchoolLevel.UNIVERSITY);
        Building university = colony.getBuilding(universityType);
        Iterator<Unit> units = colony.getUnitList().iterator();
        Unit criminal = units.next();
        criminal.setType(pettyCriminalType);
        criminal.setLocation(colony.getBuilding(townHallType));
        Unit teacher = units.next();
        teacher.setType(expertOreMinerType);
        teacher.setLocation(university);
        ServerBuildingTest.assertEquals((int)teacher.getNeededTurnsOfTraining(), (int)4);
        ServerBuildingTest.assertTrue((boolean)criminal.canBeStudent(teacher));
        ServerBuildingTest.assertEquals((Object)criminal, (Object)teacher.getStudent());
        this.trainForTurns(colony, teacher.getNeededTurnsOfTraining());
        ServerBuildingTest.assertEquals((int)0, (int)this.getUnitList(colony, pettyCriminalType).size());
        ServerBuildingTest.assertEquals((Object)indenturedServantType, (Object)criminal.getType());
        FreeColTestUtils.setStudentSelection(selection);
    }

    public void testTeachPettyCriminalsByMaster() {
        boolean selection = FreeColTestUtils.setStudentSelection(false);
        ServerGame game = ServerTestHelper.startServerGame(ServerBuildingTest.getTestMap(true));
        Colony colony = this.getSchoolColony(4, SchoolLevel.UNIVERSITY);
        Building university = colony.getBuilding(universityType);
        Iterator<Unit> units = colony.getUnitList().iterator();
        Unit criminal = units.next();
        criminal.setType(pettyCriminalType);
        criminal.setLocation(colony.getBuilding(townHallType));
        Unit teacher = units.next();
        teacher.setType(masterBlacksmithType);
        teacher.setLocation(university);
        ServerBuildingTest.assertEquals((int)teacher.getNeededTurnsOfTraining(), (int)4);
        ServerBuildingTest.assertEquals((Object)criminal, (Object)teacher.getStudent());
        this.trainForTurns(colony, teacher.getNeededTurnsOfTraining());
        ServerBuildingTest.assertEquals((int)0, (int)this.getUnitList(colony, pettyCriminalType).size());
        ServerBuildingTest.assertEquals((Object)indenturedServantType, (Object)criminal.getType());
        FreeColTestUtils.setStudentSelection(selection);
    }

    public void testTeachIndenturedServants() {
        boolean selection = FreeColTestUtils.setStudentSelection(false);
        ServerGame game = ServerTestHelper.startServerGame(ServerBuildingTest.getTestMap(true));
        Colony colony = this.getSchoolColony(4, SchoolLevel.UNIVERSITY);
        Building university = colony.getBuilding(universityType);
        Iterator<Unit> units = colony.getUnitList().iterator();
        Unit indenturedServant = units.next();
        indenturedServant.setType(indenturedServantType);
        Unit teacher = units.next();
        teacher.setType(masterBlacksmithType);
        teacher.setLocation(university);
        ServerBuildingTest.assertEquals((int)teacher.getNeededTurnsOfTraining(), (int)4);
        ServerBuildingTest.assertEquals((Object)indenturedServant, (Object)teacher.getStudent());
        this.trainForTurns(colony, teacher.getNeededTurnsOfTraining());
        ServerBuildingTest.assertEquals((int)0, (int)this.getUnitList(colony, indenturedServantType).size());
        ServerBuildingTest.assertEquals((Object)freeColonistType, (Object)indenturedServant.getType());
        FreeColTestUtils.setStudentSelection(selection);
    }

    public void testTeacherStoresProgress() {
        boolean selection = FreeColTestUtils.setStudentSelection(false);
        ServerGame game = ServerTestHelper.startServerGame(ServerBuildingTest.getTestMap(true));
        Colony colony = this.getSchoolColony(4, SchoolLevel.UNIVERSITY);
        Building university = colony.getBuilding(universityType);
        Iterator<Unit> units = colony.getUnitList().iterator();
        ServerUnit outsider = new ServerUnit(game, colony.getTile(), colony.getOwner(), freeColonistType);
        Building townHall = colony.getBuilding(townHallType);
        Unit colonist = units.next();
        colonist.setType(freeColonistType);
        colonist.setLocation(townHall);
        Unit teacher = units.next();
        teacher.setType(expertOreMinerType);
        teacher.setLocation(university);
        ServerBuildingTest.assertEquals((Object)teacher.getStudent(), (Object)colonist);
        ServerBuildingTest.assertEquals((Object)colonist.getTeacher(), (Object)teacher);
        this.trainForTurns(colony, teacher.getNeededTurnsOfTraining() - 1);
        colonist.setLocation(colony.getTile());
        outsider.setLocation(townHall);
        ServerBuildingTest.assertEquals((int)1, (int)this.getUnitList(colony, freeColonistType).size());
        ServerBuildingTest.assertEquals((Object)teacher.getStudent(), (Object)outsider);
        ServerTestHelper.newTurn();
        ServerBuildingTest.assertEquals((int)0, (int)this.getUnitList(colony, freeColonistType).size());
        ServerBuildingTest.assertEquals((Object)expertOreMinerType, (Object)outsider.getType());
        FreeColTestUtils.setStudentSelection(selection);
    }

    public void testMoveTeacherInside() {
        boolean selection = FreeColTestUtils.setStudentSelection(false);
        ServerGame game = ServerTestHelper.startServerGame(ServerBuildingTest.getTestMap(true));
        Colony colony = this.getSchoolColony(4, SchoolLevel.UNIVERSITY);
        colony.addGoods(foodType, 100);
        Building university = colony.getBuilding(universityType);
        Iterator<Unit> units = colony.getUnitList().iterator();
        Unit colonist = units.next();
        colonist.setType(freeColonistType);
        colonist.setLocation(colony.getBuilding(townHallType));
        Unit criminal = units.next();
        criminal.setType(pettyCriminalType);
        criminal.setLocation(colony.getBuilding(townHallType));
        Unit teacher1 = units.next();
        teacher1.setType(expertOreMinerType);
        Unit teacher2 = units.next();
        teacher2.setType(masterCarpenterType);
        teacher2.setLocation(university);
        teacher1.setLocation(university);
        ServerBuildingTest.assertEquals((int)4, (int)teacher1.getNeededTurnsOfTraining());
        ServerBuildingTest.assertEquals((int)4, (int)teacher2.getNeededTurnsOfTraining());
        ServerTestHelper.newTurn();
        ServerTestHelper.newTurn();
        ServerBuildingTest.assertEquals((int)2, (int)teacher1.getTurnsOfTraining());
        ServerBuildingTest.assertEquals((int)2, (int)teacher2.getTurnsOfTraining());
        ServerBuildingTest.assertEquals((int)1, (int)this.getUnitList(colony, freeColonistType).size());
        ServerBuildingTest.assertEquals((int)1, (int)this.getUnitList(colony, pettyCriminalType).size());
        ServerBuildingTest.assertEquals((int)1, (int)this.getUnitList(colony, expertOreMinerType).size());
        ServerBuildingTest.assertEquals((int)1, (int)this.getUnitList(colony, masterCarpenterType).size());
        teacher2.setLocation(colony.getWorkLocationFor(teacher2, grainType));
        teacher1.setLocation(colony.getTile());
        ServerBuildingTest.assertNull((Object)teacher1.getStudent());
        ServerBuildingTest.assertNull((Object)teacher2.getStudent());
        ServerTestHelper.newTurn();
        ServerBuildingTest.assertEquals((int)0, (int)teacher1.getTurnsOfTraining());
        ServerBuildingTest.assertEquals((int)0, (int)teacher2.getTurnsOfTraining());
        ServerBuildingTest.assertEquals((int)1, (int)this.getUnitList(colony, freeColonistType).size());
        ServerBuildingTest.assertEquals((int)1, (int)this.getUnitList(colony, pettyCriminalType).size());
        teacher1.setLocation(university);
        ServerBuildingTest.assertNotNull((Object)teacher1.getStudent());
        ServerBuildingTest.assertEquals((Object)teacher1, (Object)teacher1.getStudent().getTeacher());
        ServerBuildingTest.assertEquals((Object)pettyCriminalType, (Object)teacher1.getStudent().getType());
        teacher2.setLocation(university);
        ServerBuildingTest.assertNotNull((Object)teacher2.getStudent());
        ServerBuildingTest.assertEquals((Object)teacher2, (Object)teacher2.getStudent().getTeacher());
        ServerBuildingTest.assertEquals((Object)freeColonistType, (Object)teacher2.getStudent().getType());
        ServerTestHelper.newTurn();
        ServerTestHelper.newTurn();
        ServerTestHelper.newTurn();
        ServerBuildingTest.assertEquals((int)3, (int)teacher1.getTurnsOfTraining());
        ServerBuildingTest.assertEquals((int)3, (int)teacher2.getTurnsOfTraining());
        ServerBuildingTest.assertEquals((int)4, (int)teacher1.getNeededTurnsOfTraining());
        ServerBuildingTest.assertEquals((int)4, (int)teacher2.getNeededTurnsOfTraining());
        ServerBuildingTest.assertEquals((int)1, (int)this.getUnitList(colony, freeColonistType).size());
        ServerBuildingTest.assertEquals((int)1, (int)this.getUnitList(colony, pettyCriminalType).size());
        ServerTestHelper.newTurn();
        ServerBuildingTest.assertEquals((int)0, (int)this.getUnitList(colony, freeColonistType).size());
        ServerBuildingTest.assertEquals((int)0, (int)this.getUnitList(colony, pettyCriminalType).size());
        ServerBuildingTest.assertEquals((int)1, (int)this.getUnitList(colony, indenturedServantType).size());
        ServerBuildingTest.assertEquals((int)1, (int)this.getUnitList(colony, expertOreMinerType).size());
        ServerBuildingTest.assertEquals((int)2, (int)this.getUnitList(colony, masterCarpenterType).size());
        ServerBuildingTest.assertEquals((int)0, (int)teacher1.getTurnsOfTraining());
        ServerBuildingTest.assertEquals((int)0, (int)teacher2.getTurnsOfTraining());
        FreeColTestUtils.setStudentSelection(selection);
    }

    public void testCaseTwoTeachersWithDifferentExp() {
        boolean selection = FreeColTestUtils.setStudentSelection(false);
        ServerGame game = ServerTestHelper.startServerGame(ServerBuildingTest.getTestMap(true));
        Colony colony = this.getSchoolColony(4, SchoolLevel.UNIVERSITY);
        Building university = colony.getBuilding(universityType);
        Iterator<Unit> units = colony.getUnitList().iterator();
        Unit colonist = units.next();
        colonist.setType(freeColonistType);
        colonist.setLocation(colony.getBuilding(townHallType));
        Unit teacher1 = units.next();
        teacher1.setType(expertOreMinerType);
        Unit teacher2 = units.next();
        teacher2.setType(masterCarpenterType);
        teacher1.setLocation(university);
        ServerTestHelper.newTurn();
        ServerTestHelper.newTurn();
        ServerTestHelper.newTurn();
        ServerBuildingTest.assertEquals((int)3, (int)teacher1.getTurnsOfTraining());
        teacher1.setLocation(colony.getWorkLocationFor(teacher1, grainType));
        teacher2.setLocation(university);
        ServerTestHelper.newTurn();
        ServerBuildingTest.assertEquals((int)0, (int)teacher1.getTurnsOfTraining());
        ServerBuildingTest.assertEquals((int)1, (int)teacher2.getTurnsOfTraining());
        teacher1.setLocation(university);
        ServerBuildingTest.assertNull((Object)teacher1.getStudent());
        ServerTestHelper.newTurn();
        ServerBuildingTest.assertEquals((int)0, (int)teacher1.getTurnsOfTraining());
        ServerBuildingTest.assertEquals((int)2, (int)teacher2.getTurnsOfTraining());
        FreeColTestUtils.setStudentSelection(selection);
    }

    public void testMoveTeacherOutside() {
        boolean selection = FreeColTestUtils.setStudentSelection(false);
        ServerGame game = ServerTestHelper.startServerGame(ServerBuildingTest.getTestMap(true));
        Colony otherColony = this.getStandardColony(1, 10, 10);
        Colony colony = this.getSchoolColony(4, SchoolLevel.UNIVERSITY);
        colony.addGoods(foodType, 100);
        Building university = colony.getBuilding(universityType);
        Iterator<Unit> units = colony.getUnitList().iterator();
        Unit colonist = units.next();
        colonist.setType(freeColonistType);
        colonist.setLocation(colony.getBuilding(townHallType));
        Unit criminal = units.next();
        criminal.setType(pettyCriminalType);
        criminal.setLocation(colony.getBuilding(townHallType));
        Unit teacher1 = units.next();
        teacher1.setType(expertOreMinerType);
        Unit teacher2 = units.next();
        teacher2.setType(masterCarpenterType);
        teacher2.setLocation(university);
        teacher1.setLocation(university);
        ServerTestHelper.newTurn();
        ServerTestHelper.newTurn();
        ServerBuildingTest.assertEquals((int)1, (int)this.getUnitList(colony, freeColonistType).size());
        ServerBuildingTest.assertEquals((int)1, (int)this.getUnitList(colony, pettyCriminalType).size());
        ServerBuildingTest.assertEquals((int)1, (int)this.getUnitList(colony, expertOreMinerType).size());
        ServerBuildingTest.assertEquals((int)1, (int)this.getUnitList(colony, masterCarpenterType).size());
        ServerBuildingTest.assertEquals((int)2, (int)teacher1.getTurnsOfTraining());
        ServerBuildingTest.assertEquals((int)2, (int)teacher2.getTurnsOfTraining());
        teacher1.setLocation(ServerBuildingTest.getGame().getMap().getTile(6, 8));
        teacher2.setLocation(otherColony);
        ServerBuildingTest.assertEquals((int)0, (int)teacher1.getTurnsOfTraining());
        ServerBuildingTest.assertEquals((int)0, (int)teacher2.getTurnsOfTraining());
        ServerBuildingTest.assertEquals((int)1, (int)this.getUnitList(colony, freeColonistType).size());
        ServerBuildingTest.assertEquals((int)1, (int)this.getUnitList(colony, pettyCriminalType).size());
        ServerBuildingTest.assertEquals((int)0, (int)this.getUnitList(colony, expertOreMinerType).size());
        ServerBuildingTest.assertEquals((int)0, (int)this.getUnitList(colony, masterCarpenterType).size());
        teacher2.setLocation(university);
        teacher1.setLocation(university);
        ServerBuildingTest.assertEquals((int)0, (int)teacher1.getTurnsOfTraining());
        ServerBuildingTest.assertEquals((int)0, (int)teacher2.getTurnsOfTraining());
        ServerBuildingTest.assertEquals((Object)teacher1, (Object)colonist.getTeacher());
        ServerBuildingTest.assertEquals((Object)teacher2, (Object)criminal.getTeacher());
        ServerTestHelper.newTurn();
        ServerBuildingTest.assertEquals((int)1, (int)this.getUnitList(colony, freeColonistType).size());
        ServerBuildingTest.assertEquals((int)1, (int)this.getUnitList(colony, pettyCriminalType).size());
        ServerBuildingTest.assertEquals((int)1, (int)this.getUnitList(colony, expertOreMinerType).size());
        ServerBuildingTest.assertEquals((int)1, (int)this.getUnitList(colony, masterCarpenterType).size());
        ServerTestHelper.newTurn();
        ServerBuildingTest.assertEquals((int)1, (int)this.getUnitList(colony, freeColonistType).size());
        ServerBuildingTest.assertEquals((int)1, (int)this.getUnitList(colony, pettyCriminalType).size());
        ServerBuildingTest.assertEquals((int)1, (int)this.getUnitList(colony, expertOreMinerType).size());
        ServerBuildingTest.assertEquals((int)1, (int)this.getUnitList(colony, masterCarpenterType).size());
        ServerTestHelper.newTurn();
        ServerBuildingTest.assertEquals((int)1, (int)this.getUnitList(colony, freeColonistType).size());
        ServerBuildingTest.assertEquals((int)1, (int)this.getUnitList(colony, pettyCriminalType).size());
        ServerBuildingTest.assertEquals((int)1, (int)this.getUnitList(colony, expertOreMinerType).size());
        ServerBuildingTest.assertEquals((int)1, (int)this.getUnitList(colony, masterCarpenterType).size());
        ServerTestHelper.newTurn();
        ServerBuildingTest.assertEquals((int)0, (int)this.getUnitList(colony, freeColonistType).size());
        ServerBuildingTest.assertEquals((int)0, (int)this.getUnitList(colony, pettyCriminalType).size());
        ServerBuildingTest.assertEquals((int)1, (int)this.getUnitList(colony, indenturedServantType).size());
        ServerBuildingTest.assertEquals((int)2, (int)this.getUnitList(colony, expertOreMinerType).size());
        ServerBuildingTest.assertEquals((int)1, (int)this.getUnitList(colony, masterCarpenterType).size());
        FreeColTestUtils.setStudentSelection(selection);
    }

    public void testSonsOfLiberty() {
        boolean selection = FreeColTestUtils.setStudentSelection(false);
        ServerGame game = ServerTestHelper.startServerGame(ServerBuildingTest.getTestMap(true));
        Colony colony = this.getSchoolColony(4, SchoolLevel.UNIVERSITY);
        Building university = colony.getBuilding(universityType);
        Iterator<Unit> units = colony.getUnitList().iterator();
        Unit colonist = units.next();
        colonist.setType(freeColonistType);
        colonist.setLocation(colony.getBuilding(townHallType));
        Unit lumberjack = units.next();
        lumberjack.setType(expertLumberJackType);
        lumberjack.setLocation(university);
        ServerBuildingTest.assertEquals((int)4, (int)lumberjack.getNeededTurnsOfTraining());
        colony.addGoods(bellsType, 100000);
        ServerBuildingTest.assertEquals((int)2, (int)lumberjack.getNeededTurnsOfTraining());
        this.trainForTurns(colony, 2);
        ServerBuildingTest.assertEquals((int)0, (int)this.getUnitList(colony, freeColonistType).size());
        ServerBuildingTest.assertEquals((int)2, (int)this.getUnitList(colony, expertLumberJackType).size());
        FreeColTestUtils.setStudentSelection(selection);
    }

    public void testPartTraining() {
        boolean selection = FreeColTestUtils.setStudentSelection(false);
        ServerGame game = ServerTestHelper.startServerGame(ServerBuildingTest.getTestMap(true));
        Colony colony = this.getSchoolColony(4, SchoolLevel.UNIVERSITY);
        Building university = colony.getBuilding(universityType);
        Iterator<Unit> units = colony.getUnitList().iterator();
        Unit colonist = units.next();
        colonist.setType(freeColonistType);
        colonist.setLocation(colony.getBuilding(townHallType));
        Unit lumberjack = units.next();
        lumberjack.setType(expertLumberJackType);
        Unit miner = units.next();
        miner.setType(expertOreMinerType);
        lumberjack.setLocation(university);
        ServerBuildingTest.assertEquals((Object)lumberjack.getStudent(), (Object)colonist);
        ServerBuildingTest.assertEquals((Object)colonist.getTeacher(), (Object)lumberjack);
        ServerTestHelper.newTurn();
        ServerTestHelper.newTurn();
        lumberjack.setLocation(colony.getWorkLocationFor(lumberjack, grainType));
        ServerBuildingTest.assertNull((Object)lumberjack.getStudent());
        ServerBuildingTest.assertNull((Object)colonist.getTeacher());
        miner.setLocation(university);
        ServerBuildingTest.assertEquals((Object)miner.getStudent(), (Object)colonist);
        ServerBuildingTest.assertEquals((Object)colonist.getTeacher(), (Object)miner);
        this.trainForTurns(colony, miner.getNeededTurnsOfTraining());
        ServerBuildingTest.assertEquals((int)0, (int)this.getUnitList(colony, freeColonistType).size());
        ServerBuildingTest.assertEquals((int)2, (int)this.getUnitList(colony, expertOreMinerType).size());
        FreeColTestUtils.setStudentSelection(selection);
    }

    public void testTeachingOrder() {
        boolean selection = FreeColTestUtils.setStudentSelection(false);
        ServerGame game = ServerTestHelper.startServerGame(ServerBuildingTest.getTestMap(true));
        Colony colony = this.getSchoolColony(4, SchoolLevel.UNIVERSITY);
        colony.addGoods(foodType, 100);
        Building university = colony.getBuilding(universityType);
        Iterator<Unit> units = colony.getUnitList().iterator();
        Unit colonist = units.next();
        colonist.setType(freeColonistType);
        colonist.setLocation(colony.getBuilding(townHallType));
        Unit indenturedServant = units.next();
        indenturedServant.setType(indenturedServantType);
        indenturedServant.setLocation(colony.getBuilding(townHallType));
        Unit criminal = units.next();
        criminal.setType(pettyCriminalType);
        criminal.setLocation(colony.getBuilding(townHallType));
        Unit teacher = units.next();
        teacher.setType(expertOreMinerType);
        teacher.setLocation(university);
        ServerBuildingTest.assertTrue((boolean)colonist.canBeStudent(teacher));
        ServerBuildingTest.assertTrue((boolean)indenturedServant.canBeStudent(teacher));
        ServerBuildingTest.assertTrue((boolean)criminal.canBeStudent(teacher));
        ServerBuildingTest.assertEquals((Object)teacher, (Object)criminal.getTeacher());
        ServerBuildingTest.assertEquals((Object)criminal, (Object)teacher.getStudent());
        this.trainForTurns(colony, teacher.getNeededTurnsOfTraining());
        ServerBuildingTest.assertEquals((int)0, (int)this.getUnitList(colony, pettyCriminalType).size());
        ServerBuildingTest.assertEquals((Object)indenturedServantType, (Object)criminal.getType());
        criminal.setLocation(ServerBuildingTest.getGame().getMap().getTile(10, 8));
        ServerBuildingTest.assertNull((Object)teacher.getStudent());
        ServerTestHelper.newTurn();
        ServerBuildingTest.assertEquals((Object)teacher, (Object)indenturedServant.getTeacher());
        ServerBuildingTest.assertEquals((Object)indenturedServant, (Object)teacher.getStudent());
        this.trainForTurns(colony, teacher.getNeededTurnsOfTraining());
        ServerBuildingTest.assertEquals((int)0, (int)this.getUnitList(colony, indenturedServantType).size());
        ServerBuildingTest.assertEquals((int)2, (int)this.getUnitList(colony, freeColonistType).size());
        ServerBuildingTest.assertEquals((int)1, (int)this.getUnitList(colony, expertOreMinerType).size());
        ServerBuildingTest.assertEquals((Object)freeColonistType, (Object)indenturedServant.getType());
        ServerBuildingTest.assertEquals((Object)teacher, (Object)indenturedServant.getTeacher());
        ServerBuildingTest.assertEquals((Object)indenturedServant, (Object)teacher.getStudent());
        ServerBuildingTest.assertEquals((Object)colonist.getTeacher(), null);
        this.trainForTurns(colony, teacher.getNeededTurnsOfTraining());
        ServerBuildingTest.assertEquals((int)0, (int)this.getUnitList(colony, indenturedServantType).size());
        ServerBuildingTest.assertEquals((int)1, (int)this.getUnitList(colony, freeColonistType).size());
        ServerBuildingTest.assertEquals((int)2, (int)this.getUnitList(colony, expertOreMinerType).size());
        ServerBuildingTest.assertEquals((Object)expertOreMinerType, (Object)indenturedServant.getType());
        ServerBuildingTest.assertEquals((Object)indenturedServant.getTeacher(), null);
        FreeColTestUtils.setStudentSelection(selection);
    }

    public void testTeachingDoublePromotion() {
        boolean selection = FreeColTestUtils.setStudentSelection(false);
        ServerGame game = ServerTestHelper.startServerGame(ServerBuildingTest.getTestMap(true));
        Colony colony = this.getSchoolColony(4, SchoolLevel.UNIVERSITY);
        colony.addGoods(foodType, 100);
        Building university = colony.getBuilding(universityType);
        Iterator<Unit> units = colony.getUnitList().iterator();
        Unit indenturedServant = units.next();
        indenturedServant.setType(indenturedServantType);
        indenturedServant.setLocation(colony.getBuilding(townHallType));
        Unit criminal = units.next();
        criminal.setType(pettyCriminalType);
        criminal.setLocation(colony.getBuilding(townHallType));
        Unit teacher1 = units.next();
        teacher1.setType(expertOreMinerType);
        Unit teacher2 = units.next();
        teacher2.setType(expertLumberJackType);
        teacher1.setLocation(university);
        teacher2.setLocation(university);
        ServerBuildingTest.assertEquals((Object)criminal, (Object)teacher1.getStudent());
        ServerBuildingTest.assertEquals((Object)indenturedServant, (Object)teacher2.getStudent());
        this.trainForTurns(colony, teacher1.getNeededTurnsOfTraining());
        ServerBuildingTest.assertEquals((Object)freeColonistType, (Object)indenturedServant.getType());
        ServerBuildingTest.assertEquals((Object)indenturedServantType, (Object)criminal.getType());
        ServerBuildingTest.assertEquals((int)1, (int)this.getUnitList(colony, expertOreMinerType).size());
        ServerBuildingTest.assertEquals((int)1, (int)this.getUnitList(colony, expertLumberJackType).size());
        ServerBuildingTest.assertEquals((int)1, (int)this.getUnitList(colony, freeColonistType).size());
        ServerBuildingTest.assertEquals((int)1, (int)this.getUnitList(colony, indenturedServantType).size());
        ServerBuildingTest.assertEquals((int)0, (int)this.getUnitList(colony, pettyCriminalType).size());
        criminal.setLocation(ServerBuildingTest.getGame().getMap().getTile(10, 8));
        ServerBuildingTest.assertNull((Object)teacher1.getStudent());
        ServerBuildingTest.assertEquals((Object)teacher2, (Object)indenturedServant.getTeacher());
        this.trainForTurns(colony, teacher2.getNeededTurnsOfTraining());
        ServerBuildingTest.assertEquals((Object)expertLumberJackType, (Object)indenturedServant.getType());
        ServerBuildingTest.assertEquals((int)1, (int)this.getUnitList(colony, expertOreMinerType).size());
        ServerBuildingTest.assertEquals((int)2, (int)this.getUnitList(colony, expertLumberJackType).size());
        ServerBuildingTest.assertEquals((int)0, (int)this.getUnitList(colony, freeColonistType).size());
        ServerBuildingTest.assertEquals((int)0, (int)this.getUnitList(colony, indenturedServantType).size());
        ServerBuildingTest.assertEquals((int)0, (int)this.getUnitList(colony, pettyCriminalType).size());
        FreeColTestUtils.setStudentSelection(selection);
    }

    public void testColonialRegular() {
        boolean selection = FreeColTestUtils.setStudentSelection(false);
        ServerGame game = ServerTestHelper.startServerGame(ServerBuildingTest.getTestMap(true));
        Colony colony = this.getSchoolColony(4, SchoolLevel.UNIVERSITY);
        Building university = colony.getBuilding(universityType);
        colony.getOwner().addAbility(new Ability("model.ability.independenceDeclared"));
        Iterator<Unit> units = colony.getUnitList().iterator();
        Unit regular = units.next();
        regular.setType(colonialRegularType);
        Unit colonist = units.next();
        colonist.setType(freeColonistType);
        colonist.setLocation(colony.getBuilding(townHallType));
        regular.setLocation(university);
        ServerBuildingTest.assertEquals((Object)colonist, (Object)regular.getStudent());
        this.trainForTurns(colony, ServerBuildingTest.spec().getNeededTurnsOfTraining(veteranSoldierType, freeColonistType));
        ServerBuildingTest.assertEquals((Object)veteranSoldierType, (Object)colonist.getType());
        FreeColTestUtils.setStudentSelection(selection);
    }

    public void testConcurrentUpgrade() {
        boolean selection = FreeColTestUtils.setStudentSelection(false);
        ServerGame game = ServerTestHelper.startServerGame(ServerBuildingTest.getTestMap(true));
        Colony colony = this.getSchoolColony(2, SchoolLevel.SCHOOLHOUSE);
        colony.addGoods(new AbstractGoods(foodType, 100));
        Building school = colony.getBuilding(schoolType);
        Iterator<Unit> units = colony.getUnitList().iterator();
        Unit lumber = units.next();
        lumber.setType(expertLumberJackType);
        Unit student = units.next();
        student.setType(pettyCriminalType);
        student.setLocation(colony.getBuilding(townHallType));
        ServerBuildingTest.assertTrue((boolean)school.canTeach());
        ServerBuildingTest.assertTrue((boolean)colony.canTrain(lumber));
        lumber.setLocation(school);
        ServerTestHelper.newTurn();
        ServerBuildingTest.assertEquals((Object)student, (Object)lumber.getStudent());
        student.changeType(indenturedServantType);
        ServerBuildingTest.assertEquals((Object)student, (Object)lumber.getStudent());
        student.changeType(freeColonistType);
        ServerBuildingTest.assertEquals((Object)student, (Object)lumber.getStudent());
        student.changeType(masterCarpenterType);
        ServerBuildingTest.assertNull((Object)lumber.getStudent());
        ServerBuildingTest.assertNull((Object)student.getTeacher());
        FreeColTestUtils.setStudentSelection(selection);
    }

    public void testProductionBonus() {
        boolean selection = FreeColTestUtils.setStudentSelection(false);
        ServerGame game = ServerTestHelper.startServerGame(ServerBuildingTest.getTestMap(true));
        Colony colony = this.getSchoolColony(6, SchoolLevel.UNIVERSITY);
        Building university = colony.getBuilding(universityType);
        Iterator<Unit> units = colony.getUnitList().iterator();
        Unit carpenter = units.next();
        carpenter.setType(masterCarpenterType);
        Unit blacksmith = units.next();
        blacksmith.setType(masterBlacksmithType);
        Unit statesman = units.next();
        statesman.setType(elderStatesmanType);
        units.next().setType(freeColonistType);
        units.next().setType(freeColonistType);
        units.next().setType(freeColonistType);
        carpenter.setLocation(university);
        blacksmith.setLocation(university);
        statesman.setLocation(university);
        for (int bonus = -2; bonus < 3; ++bonus) {
            this.setProductionBonus(colony, bonus);
            ServerBuildingTest.assertEquals((int)(4 - bonus), (int)carpenter.getNeededTurnsOfTraining());
            ServerBuildingTest.assertEquals((int)(6 - bonus), (int)blacksmith.getNeededTurnsOfTraining());
            ServerBuildingTest.assertEquals((int)(8 - bonus), (int)statesman.getNeededTurnsOfTraining());
        }
        FreeColTestUtils.setStudentSelection(selection);
    }

    private static enum SchoolLevel {
        SCHOOLHOUSE,
        COLLEGE,
        UNIVERSITY;

    }
}

