/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.tools;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.zip.GZIPInputStream;
import net.sf.freecol.FreeCol;

public class FSGConverter {
    private static FSGConverter singleton;
    private static Object singletonLock;

    private FSGConverter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FSGConverter getFSGConverter() {
        Object object = singletonLock;
        synchronized (object) {
            if (singleton == null) {
                singleton = new FSGConverter();
            }
            return singleton;
        }
    }

    private void convertToXML(File in, File out) throws IOException {
        try (InputStream fis = Files.newInputStream(in.toPath(), new OpenOption[0]);
             OutputStream fos = Files.newOutputStream(out.toPath(), new OpenOption[0]);){
            this.convertToXML(fis, fos);
        }
    }

    private void convertToXML(InputStream ins, OutputStream outs) throws IOException {
        BufferedInputStream in = new BufferedInputStream(ins);
        try (BufferedOutputStream out = new BufferedOutputStream(outs);){
            int i;
            in.mark(10);
            byte[] buf = new byte[5];
            if (in.read(buf, 0, buf.length) < buf.length) {
                System.err.println("Unable to read header");
                return;
            }
            in.reset();
            if (!"<?xml".equals(new String(buf, StandardCharsets.UTF_8))) {
                in = new BufferedInputStream(new GZIPInputStream(ins));
            }
            int indent = 0;
            while ((i = in.read()) != -1) {
                char c = (char)i;
                if (c == '<') {
                    i = in.read();
                    char b = (char)i;
                    if (b == '/') {
                        indent -= 4;
                    }
                    for (int h = 0; h < indent; ++h) {
                        out.write(32);
                    }
                    out.write(c);
                    if (b != '\n' && b != '\r') {
                        out.write(b);
                    }
                    if (b == '/' || b == '?') continue;
                    indent += 4;
                    continue;
                }
                if (c == '/') {
                    out.write(c);
                    i = in.read();
                    c = (char)i;
                    if (c != '>') continue;
                    indent -= 4;
                    out.write(c);
                    out.write(10);
                    continue;
                }
                if (c == '>') {
                    out.write(c);
                    out.write(10);
                    continue;
                }
                if (c == '\n' || c == '\r') continue;
                out.write(c);
            }
        }
        in.close();
    }

    private static void printUsage() {
        System.out.println("A program for converting FreeCol Savegames.");
        System.out.println();
        System.out.println("Usage: java -cp FreeCol.jar net.sf.freecol.tools.FSGConverter [-][-]output:xml FSG_FILE [OUTPUT_FILE]");
        System.out.println();
        System.out.println("output:xml \tThe output will be indented XML.");
        System.out.println();
        System.out.println("The output file will get the same name as FSG_FILE if not specified (with \".fsg\" replaced with \".xml\").");
    }

    public static void main(String[] args) {
        if (args.length >= 2 && args[0].endsWith("output:xml")) {
            File out;
            File in = new File(args[1]);
            if (!in.exists()) {
                FSGConverter.printUsage();
                System.exit(1);
            }
            if (args.length >= 3) {
                out = new File(args[2]);
            } else {
                String name = in.getName();
                Object filename = name.replaceAll(".fsg", ".xml");
                if (((String)filename).equals(name)) {
                    filename = (String)filename + ".xml";
                }
                out = new File((String)filename);
            }
            try {
                FSGConverter fsgc = FSGConverter.getFSGConverter();
                fsgc.convertToXML(in, out);
            }
            catch (IOException e) {
                FreeCol.fatal(null, "An error occured while converting the file.");
            }
        } else {
            FSGConverter.printUsage();
            System.exit(1);
        }
    }

    static {
        singletonLock = new Object();
    }
}

