/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.attributes;

import java.util.Comparator;
import org.gradle.api.attributes.AttributeMatchingStrategy;
import org.gradle.api.internal.attributes.DefaultCompatibilityRuleChain;
import org.gradle.api.internal.attributes.DefaultDisambiguationRuleChain;
import org.gradle.internal.instantiation.InstantiatorFactory;
import org.gradle.internal.isolation.IsolatableFactory;

public class DefaultAttributeMatchingStrategy<T>
implements AttributeMatchingStrategy<T> {
    private final DefaultCompatibilityRuleChain<T> compatibilityRules;
    private final DefaultDisambiguationRuleChain<T> disambiguationRules;

    public DefaultAttributeMatchingStrategy(InstantiatorFactory instantiatorFactory, IsolatableFactory isolatableFactory) {
        this.compatibilityRules = (DefaultCompatibilityRuleChain)instantiatorFactory.decorateLenient().newInstance(DefaultCompatibilityRuleChain.class, new Object[]{instantiatorFactory.inject(), isolatableFactory});
        this.disambiguationRules = (DefaultDisambiguationRuleChain)instantiatorFactory.decorateLenient().newInstance(DefaultDisambiguationRuleChain.class, new Object[]{instantiatorFactory.inject(), isolatableFactory});
    }

    public DefaultCompatibilityRuleChain<T> getCompatibilityRules() {
        return this.compatibilityRules;
    }

    public DefaultDisambiguationRuleChain<T> getDisambiguationRules() {
        return this.disambiguationRules;
    }

    public void ordered(Comparator<T> comparator) {
        this.ordered(true, comparator);
    }

    public void ordered(boolean pickLast, Comparator<T> comparator) {
        this.compatibilityRules.ordered(comparator);
        if (pickLast) {
            this.disambiguationRules.pickLast(comparator);
        } else {
            this.disambiguationRules.pickFirst(comparator);
        }
    }
}

