/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.bsd.ppc64;

import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.ThreadProxy;
import sun.jvm.hotspot.debugger.bsd.BsdDebugger;
import sun.jvm.hotspot.debugger.cdbg.CFrame;
import sun.jvm.hotspot.debugger.cdbg.ClosestSymbol;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicCFrame;

public final class BsdPPC64CFrame
extends BasicCFrame {
    public static int PPC64_STACK_BIAS = 0;
    private static int address_size;
    private Address pc;
    private Address sp;
    private BsdDebugger dbg;

    public BsdPPC64CFrame(BsdDebugger dbg, Address sp, Address pc, int address_size) {
        super(dbg.getCDebugger());
        this.sp = sp;
        this.pc = pc;
        this.dbg = dbg;
        BsdPPC64CFrame.address_size = address_size;
    }

    @Override
    public ClosestSymbol closestSymbolToPC() {
        return this.dbg.lookup(this.dbg.getAddressValue(this.pc()));
    }

    @Override
    public Address pc() {
        return this.pc;
    }

    @Override
    public Address localVariableBase() {
        return this.sp;
    }

    @Override
    public CFrame sender(ThreadProxy thread) {
        if (this.sp == null) {
            return null;
        }
        Address nextSP = this.sp.getAddressAt(0L);
        if (nextSP == null) {
            return null;
        }
        Address nextPC = this.sp.getAddressAt(2 * address_size);
        if (nextPC == null) {
            return null;
        }
        return new BsdPPC64CFrame(this.dbg, nextSP, nextPC, address_size);
    }
}

