/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.workflow;

import java.util.List;
import java.util.Map;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.component.ComponentModel;

public class Workflow {
    private MultivaluedHashMap<String, String> config;
    private final String providerId;
    private String id;
    private Long notBefore;

    public Workflow(ComponentModel c) {
        this.id = c.getId();
        this.providerId = c.getProviderId();
        this.config = c.getConfig();
    }

    public Workflow(String providerId, Map<String, List<String>> config) {
        this.providerId = providerId;
        MultivaluedHashMap c = new MultivaluedHashMap();
        config.forEach((arg_0, arg_1) -> ((MultivaluedHashMap)c).addAll(arg_0, arg_1));
        this.config = c;
    }

    public String getId() {
        return this.id;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public MultivaluedHashMap<String, String> getConfig() {
        return this.config;
    }

    public String getName() {
        return this.config != null ? (String)this.config.getFirst((Object)"name") : null;
    }

    public boolean isEnabled() {
        return this.config != null && Boolean.parseBoolean((String)this.config.getFirstOrDefault((Object)"enabled", (Object)"true"));
    }

    public boolean isRecurring() {
        return this.config != null && Boolean.parseBoolean((String)this.config.getFirst((Object)"recurring"));
    }

    public Long getNotBefore() {
        return this.notBefore;
    }

    public void setNotBefore(Long notBefore) {
        this.notBefore = notBefore;
    }

    public void setEnabled(boolean enabled) {
        if (this.config == null) {
            this.config = new MultivaluedHashMap();
        }
        this.config.putSingle((Object)"enabled", (Object)String.valueOf(enabled));
    }

    public void setError(String message) {
        if (this.config == null) {
            this.config = new MultivaluedHashMap();
        }
        this.config.putSingle((Object)"error", (Object)message);
    }
}

