/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.qt.clion.workspace;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.ProjectActivity;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.qt.clion.QtScopeService;
import com.intellij.qt.common.settings.QtSettings;
import com.intellij.util.PathUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.cidr.ToolVersion;
import com.jetbrains.cidr.cpp.cmake.CMakeException;
import com.jetbrains.cidr.cpp.cmake.CMakeRunner;
import com.jetbrains.cidr.cpp.cmake.model.CMakeConfigurator;
import com.jetbrains.cidr.cpp.cmake.model.CMakeGeneratorParameters;
import com.jetbrains.cidr.cpp.cmake.model.CMakeGeneratorSpec;
import com.jetbrains.cidr.cpp.cmake.model.CMakeGeneratorUtils;
import com.jetbrains.cidr.cpp.cmake.model.CMakeModelConfigurationData;
import com.jetbrains.cidr.cpp.cmake.model.CMakeVariable;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeProfileInfo;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspace;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspaceListener;
import com.jetbrains.cidr.cpp.execution.CMakeAppRunConfiguration;
import com.jetbrains.cidr.cpp.execution.CMakeBuildProfileExecutionTarget;
import com.jetbrains.cidr.cpp.toolchains.CMakeExecutableTool;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceListener;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.toolchains.wsl.CidrWSLHost;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J \u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0016\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0096@\u00a2\u0006\u0002\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lcom/intellij/qt/clion/workspace/QtWorkspaceListenerActivity;", "Lcom/intellij/openapi/startup/ProjectActivity;", "<init>", "()V", "findQtPaths", "Lkotlin/Pair;", "", "cmakePrefix", "environment", "Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;", "hasQt5", "", "hasQt6", "getMatchingModelConfig", "Lcom/jetbrains/cidr/cpp/cmake/model/CMakeModelConfigurationData;", "profileInfo", "Lcom/jetbrains/cidr/cpp/cmake/workspace/CMakeProfileInfo;", "modelConfigs", "", "updateQtSettings", "", "project", "Lcom/intellij/openapi/project/Project;", "listenChanges", "execute", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.qt.clion"})
@SourceDebugExtension(value={"SMAP\nQtWorkspaceListenerActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QtWorkspaceListenerActivity.kt\ncom/intellij/qt/clion/workspace/QtWorkspaceListenerActivity\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,298:1\n14#2:299\n14#2:300\n*S KotlinDebug\n*F\n+ 1 QtWorkspaceListenerActivity.kt\ncom/intellij/qt/clion/workspace/QtWorkspaceListenerActivity\n*L\n90#1:299\n96#1:300\n*E\n"})
final class QtWorkspaceListenerActivity
implements ProjectActivity {
    private final Pair<String, String> findQtPaths(String cmakePrefix, CPPEnvironment environment, boolean hasQt5, boolean hasQt6) {
        CMakeRunner.CMakeOutput processOutput;
        CMakeRunner.CMakeOutput cMakeOutput;
        HostMachine hostMachine = environment.getHostMachine();
        Intrinsics.checkNotNullExpressionValue((Object)hostMachine, (String)"getHostMachine(...)");
        HostMachine host = hostMachine;
        Path path = host.createTempDirectory("cmake_check_environment", null);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createTempDirectory(...)");
        Path projectDir = path;
        Path path2 = Files.createTempDirectory(projectDir, "_build", new FileAttribute[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"createTempDirectory(...)");
        Path outputDir = path2;
        CMakeExecutableTool cMakeExecutableTool = environment.getCMake();
        ToolVersion cmakeVersion = cMakeExecutableTool != null ? cMakeExecutableTool.readToolVersion() : null;
        List cmakeListsContent = new ArrayList();
        ToolVersion toolVersion = cmakeVersion;
        if (toolVersion != null) {
            ToolVersion it = toolVersion;
            boolean bl = false;
            cmakeListsContent.add("cmake_minimum_required(VERSION " + it.versionNumber.major + "." + it.versionNumber.minor + ")");
        }
        String qtVersionsList = (hasQt6 ? "Qt6" : "") + (hasQt5 ? " Qt5" : "");
        cmakeListsContent.add(StringsKt.trimIndent((String)("\n      project(qml_test_run)\n      set(CMAKE_CXX_STANDARD 17)\n      set(CMAKE_C_COMPILER_WORKS 1)\n      set(CMAKE_CXX_COMPILER_WORKS 1)\n      set(CMAKE_AUTOMOC ON)\n      set(CMAKE_AUTORCC ON)\n      set(CMAKE_AUTOUIC ON)\n      find_package(QT NAMES " + qtVersionsList + " COMPONENTS Core Quick REQUIRED)\n      find_package(Qt${QT_VERSION_MAJOR} COMPONENTS Core Quick REQUIRED)\n      message(\"QML ${QT6_INSTALL_PREFIX}/${QT6_INSTALL_QML}\")\n      message(\"BIN ${QT6_INSTALL_PREFIX}/${QT6_INSTALL_BINS}\")\n      message(\"MOC ${QT_MOC_EXECUTABLE}\")\n      add_executable(qtdiag main.cpp)\n      target_link_libraries(qtdiag Qt${QT_VERSION_MAJOR}::Core)\n      ")));
        List mainCppContent = new ArrayList();
        mainCppContent.add("#include <QtCore>\n#include <QDebug>\nint main() {\n#if QT_VERSION_MAJOR > 5\n    qDebug()  << \"QmlImportsPath:\" << QLibraryInfo::path(QLibraryInfo::QmlImportsPath);\n#else\n    qDebug()  << \"QmlImportsPath:\" << QLibraryInfo::location(QLibraryInfo::Qml2ImportsPath);\n#endif\n    return 0;\n}");
        Files.write(projectDir.resolve("main.cpp"), (Iterable<? extends CharSequence>)mainCppContent, new OpenOption[0]);
        Files.write(projectDir.resolve("CMakeLists.txt"), (Iterable<? extends CharSequence>)cmakeListsContent, new OpenOption[0]);
        List options = new ArrayList();
        options.add("-DCMAKE_PREFIX_PATH=" + cmakePrefix);
        CMakeGeneratorSpec spec = (CMakeGeneratorSpec)CMakeGeneratorParameters.Companion.calculateGeneratorSpec(options, cmakeVersion, null, environment, false).getSecond();
        List effectiveOptions = CMakeGeneratorParameters.Companion.calculateEffectiveGenerationOptions$default((CMakeGeneratorParameters.Companion)CMakeGeneratorParameters.Companion, (List)options, (CMakeGeneratorSpec)spec, (CPPEnvironment)environment, null, (int)8, null);
        try {
            cMakeOutput = CMakeGeneratorUtils.runCMakeGenerator((CPPEnvironment)environment, (Path)projectDir, (Path)outputDir, (List)effectiveOptions, (String)spec.getGenerator().getName());
        }
        catch (Exception ex) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(QtWorkspaceListenerActivity.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Failed to run cmake to detect Qt", (Throwable)ex);
            cMakeOutput = null;
        }
        CMakeRunner.CMakeOutput cMakeOutput2 = processOutput = cMakeOutput;
        Integer exitCode = cMakeOutput2 != null ? Integer.valueOf(cMakeOutput2.getExitCode()) : null;
        CMakeRunner.CMakeOutput cMakeOutput3 = processOutput;
        if (!(cMakeOutput3 != null ? cMakeOutput3.getExitCode() == 0 : false)) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(QtWorkspaceListenerActivity.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("CMake exit code is not 0: " + exitCode);
            return null;
        }
        String outputStr = ((Object)processOutput.getOutput()).toString();
        int qmlLineStart = StringsKt.indexOf$default((CharSequence)outputStr, (String)"\nQML ", (int)0, (boolean)false, (int)6, null);
        if (qmlLineStart == -1) {
            return null;
        }
        int binLineStart = StringsKt.indexOf$default((CharSequence)outputStr, (String)"\nBIN ", (int)(qmlLineStart + 5), (boolean)false, (int)4, null);
        if (binLineStart == -1) {
            return null;
        }
        int mocLineStart = StringsKt.indexOf$default((CharSequence)outputStr, (String)"\nMOC ", (int)(binLineStart + 5), (boolean)false, (int)4, null);
        if (mocLineStart == -1) {
            return null;
        }
        int mocLineEnd = StringsKt.indexOf$default((CharSequence)outputStr, (String)"\n", (int)(mocLineStart + 5), (boolean)false, (int)4, null);
        String string = outputStr.substring(qmlLineStart + 5, binLineStart);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String qmlPath = string;
        String string2 = outputStr.substring(binLineStart + 5, mocLineStart);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String binPath = string2;
        String string3 = outputStr.substring(mocLineStart + 5, mocLineEnd);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        String mocPath = string3;
        if (binPath.length() < 2) {
            if (((CharSequence)mocPath).length() == 0) {
                return null;
            }
            String string4 = PathUtil.getParentPath((String)mocPath);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getParentPath(...)");
            binPath = string4;
        }
        if (qmlPath.length() < 2) {
            if (binPath.length() < 2) {
                return null;
            }
            String qtDiagBinaryName = "qtdiag" + (SystemInfo.isWindows && !host.isWsl() && !host.isRemote() ? ".exe" : "");
            String[] stringArray = new String[]{binPath, qtDiagBinaryName};
            String string5 = FileUtil.join((String[])stringArray);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"join(...)");
            String qtDiagPath = string5;
            String qtDiagOutput = null;
            if (FileUtil.exists((String)qtDiagPath)) {
                GeneralCommandLine commandLine = new GeneralCommandLine();
                commandLine.setExePath(qtDiagPath);
                commandLine.addParameter("--no-gl");
                commandLine.addParameter("--no-vulkan");
                commandLine.addParameter("--no-rhi");
                environment.prepare(commandLine, CidrToolEnvironment.PrepareFor.RUN);
                ProcessOutput processOutput2 = host.runProcess(commandLine, 5000);
                Intrinsics.checkNotNullExpressionValue((Object)processOutput2, (String)"runProcess(...)");
                ProcessOutput output = processOutput2;
                qtDiagOutput = output.getStdout();
            } else {
                CMakeExecutableTool cmake = environment.getCMake();
                GeneralCommandLine cmakeBuildCommandLine = new GeneralCommandLine();
                CMakeExecutableTool cMakeExecutableTool2 = cmake;
                Intrinsics.checkNotNull((Object)cMakeExecutableTool2);
                cmakeBuildCommandLine.setExePath(cMakeExecutableTool2.getExecutablePath());
                cmakeBuildCommandLine.addParameter("--build");
                cmakeBuildCommandLine.addParameter(environment.toEnvPath(((Object)outputDir).toString()));
                cmakeBuildCommandLine.addParameter("--target");
                cmakeBuildCommandLine.addParameter("all");
                environment.prepare(cmakeBuildCommandLine, CidrToolEnvironment.PrepareFor.BUILD);
                host.runProcess(cmakeBuildCommandLine, 5000);
                GeneralCommandLine commandLine = new GeneralCommandLine();
                commandLine.setExePath(environment.toEnvPath(((Object)outputDir.resolve(qtDiagBinaryName)).toString()));
                environment.prepare(commandLine, CidrToolEnvironment.PrepareFor.RUN);
                ProcessOutput processOutput3 = host.runProcess(commandLine, 5000);
                Intrinsics.checkNotNullExpressionValue((Object)processOutput3, (String)"runProcess(...)");
                ProcessOutput output = processOutput3;
                qtDiagOutput = output.getStderr();
            }
            int qmlImportsPathStart = StringsKt.indexOf$default((CharSequence)qtDiagOutput, (String)"Qml2ImportsPath: ", (int)0, (boolean)false, (int)6, null);
            if (qmlImportsPathStart != -1) {
                qmlImportsPathStart += 17;
            } else {
                qmlImportsPathStart = StringsKt.indexOf$default((CharSequence)qtDiagOutput, (String)"QmlImportsPath: ", (int)0, (boolean)false, (int)6, null);
                if (qmlImportsPathStart != -1) {
                    qmlImportsPathStart += 16;
                }
            }
            if (qmlImportsPathStart == -1) {
                return null;
            }
            int endOfLine = StringsKt.indexOf$default((CharSequence)qtDiagOutput, (String)"\n", (int)qmlImportsPathStart, (boolean)false, (int)4, null);
            String string6 = qtDiagOutput.substring(qmlImportsPathStart, endOfLine);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
            char[] cArray = new char[]{'\"'};
            String string7 = StringsKt.trimStart((String)string6, (char[])cArray);
            cArray = new char[]{'\"'};
            qmlPath = StringsKt.trimEnd((String)string7, (char[])cArray);
        }
        if (host.isWsl()) {
            CidrWSLHost wslHost = (CidrWSLHost)host;
            String string8 = wslHost.convertToLocal(qmlPath);
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"convertToLocal(...)");
            qmlPath = string8;
            String string9 = wslHost.convertToLocal(binPath);
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"convertToLocal(...)");
            binPath = string9;
        }
        if (qmlPath.length() < 2 || !FileUtil.exists((String)qmlPath)) {
            qmlPath = "";
        }
        if (binPath.length() < 2 || !FileUtil.exists((String)binPath)) {
            binPath = "";
        }
        if (((CharSequence)qmlPath).length() == 0 && ((CharSequence)binPath).length() == 0) {
            return null;
        }
        return new Pair((Object)PathUtil.toSystemIndependentName((String)qmlPath), (Object)PathUtil.toSystemIndependentName((String)binPath));
    }

    private final CMakeModelConfigurationData getMatchingModelConfig(CMakeProfileInfo profileInfo, List<CMakeModelConfigurationData> modelConfigs) {
        for (CMakeModelConfigurationData modelConfig : modelConfigs) {
            if (!Intrinsics.areEqual((Object)modelConfig.getConfigName(), (Object)profileInfo.getProfile().getName())) continue;
            return modelConfig;
        }
        return null;
    }

    private final void updateQtSettings(Project project) {
        CMakeWorkspace cmakeWorkspace = CMakeWorkspace.Companion.getInstance(project);
        if (!cmakeWorkspace.isInitialized()) {
            return;
        }
        List modelConfigs = cmakeWorkspace.getModelConfigurationData();
        List profileInfos = CollectionsKt.toList((Iterable)cmakeWorkspace.getProfileInfos());
        Map nextProfileNameToPaths = new LinkedHashMap();
        Map pathsCache = new LinkedHashMap();
        for (Object profileInfo : profileInfos) {
            String cmakePrefix;
            CMakeModelConfigurationData cMakeModelConfigurationData;
            if (profileInfo.getEnvironment() == null || (cMakeModelConfigurationData = this.getMatchingModelConfig((CMakeProfileInfo)profileInfo, modelConfigs)) == null) continue;
            CMakeConfigurator cache = null;
            try {
                cache = cMakeModelConfigurationData.getCacheConfigurator();
            }
            catch (CMakeException cmakeEx) {
                continue;
            }
            CMakeVariable qt5 = cache.findVariable("Qt5_DIR");
            CMakeVariable qt6 = cache.findVariable("Qt6_DIR");
            if (qt5 == null && qt6 == null) continue;
            CMakeVariable cMakeVariable = qt5;
            if (cMakeVariable != null) {
                v1 = cMakeVariable.getValue();
            } else {
                CMakeVariable cMakeVariable2 = qt6;
                Intrinsics.checkNotNull((Object)cMakeVariable2);
                v1 = cmakePrefix = cMakeVariable2.getValue();
            }
            if (cmakePrefix == null) continue;
            cmakePrefix = PathUtil.getParentPath((String)cmakePrefix);
            Pair<String, String> paths = null;
            if (pathsCache.containsKey(cmakePrefix)) {
                paths = (Pair<String, String>)pathsCache.get(cmakePrefix);
            } else {
                paths = this.findQtPaths(cmakePrefix, profileInfo.getEnvironmentSafe(false), qt5 != null, qt6 != null);
                pathsCache.put(cmakePrefix, paths);
            }
            if (paths == null) continue;
            nextProfileNameToPaths.put(profileInfo.getProfile().getName(), paths);
        }
        QtSettings settings = QtSettings.getInstance(project);
        for (String string : settings.getProfilesList()) {
            Intrinsics.checkNotNull((Object)string);
            if (((CharSequence)string).length() == 0 || nextProfileNameToPaths.containsKey(string)) continue;
            settings.removeProfileSettings(string);
        }
        if (nextProfileNameToPaths.isEmpty()) {
            return;
        }
        for (Map.Entry entry : nextProfileNameToPaths.entrySet()) {
            settings.setProfileWithPaths((String)entry.getKey(), (String)((Pair)entry.getValue()).getFirst(), (String)((Pair)entry.getValue()).getSecond());
        }
        CMakeBuildProfileExecutionTarget currentBuildProfile = CMakeAppRunConfiguration.getSelectedBuildProfile((Project)project);
        if (currentBuildProfile != null) {
            settings.setCurrentProfile(currentBuildProfile.getProfileName());
        } else {
            settings.setCurrentProfile("");
        }
    }

    private final void listenChanges(Project project) {
        MessageBusConnection connection = project.getMessageBus().connect();
        Topic topic = CMakeWorkspaceListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        connection.subscribe(topic, (Object)new CMakeWorkspaceListener(project, this){
            final /* synthetic */ Project $project;
            final /* synthetic */ QtWorkspaceListenerActivity this$0;
            {
                this.$project = $project;
                this.this$0 = $receiver;
            }

            public void reloadingFinished(boolean canceled) {
                ComponentManager $this$service$iv = (ComponentManager)this.$project;
                boolean $i$f$service = false;
                Class<QtScopeService> serviceClass$iv = QtScopeService.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                BuildersKt.launch$default((CoroutineScope)((QtScopeService)object).getCoroutineScope$intellij_qt_clion(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$project, null){
                    int label;
                    final /* synthetic */ QtWorkspaceListenerActivity this$0;
                    final /* synthetic */ Project $project;
                    {
                        this.this$0 = $receiver;
                        this.$project = $project;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                QtWorkspaceListenerActivity.access$updateQtSettings(this.this$0, this.$project);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
        });
        Topic topic2 = OCWorkspaceListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"TOPIC");
        connection.subscribe(topic2, (Object)new OCWorkspaceListener(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
            }

            public void selectedResolveConfigurationChanged() {
                ComponentManager $this$service$iv = (ComponentManager)this.$project;
                boolean $i$f$service = false;
                Class<QtScopeService> serviceClass$iv = QtScopeService.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                BuildersKt.launch$default((CoroutineScope)((QtScopeService)object).getCoroutineScope$intellij_qt_clion(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$project, null){
                    int label;
                    final /* synthetic */ Project $project;
                    {
                        this.$project = $project;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                QtSettings settings = QtSettings.getInstance(this.$project);
                                CMakeBuildProfileExecutionTarget currentBuildProfile = CMakeAppRunConfiguration.getSelectedBuildProfile((Project)this.$project);
                                if (currentBuildProfile != null && settings.getProfilesList().contains(currentBuildProfile.getProfileName())) {
                                    settings.setCurrentProfile(currentBuildProfile.getProfileName());
                                } else {
                                    settings.setCurrentProfile("");
                                }
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
        });
    }

    @Nullable
    public Object execute(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
        this.updateQtSettings(project);
        this.listenChanges(project);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$updateQtSettings(QtWorkspaceListenerActivity $this, Project project) {
        $this.updateQtSettings(project);
    }
}

