/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.firebase.auth.ErrorInfo;
import com.google.firebase.auth.internal.BatchDeleteResponse;
import com.google.firebase.internal.NonNull;
import java.util.List;

public final class DeleteUsersResult {
    private final int successCount;
    private final List<ErrorInfo> errors;

    DeleteUsersResult(int users, BatchDeleteResponse response) {
        ImmutableList.Builder errorsBuilder = ImmutableList.builder();
        List<BatchDeleteResponse.ErrorInfo> responseErrors = response.getErrors();
        if (responseErrors != null) {
            Preconditions.checkArgument((users >= responseErrors.size() ? 1 : 0) != 0);
            for (BatchDeleteResponse.ErrorInfo error : responseErrors) {
                errorsBuilder.add((Object)new ErrorInfo(error.getIndex(), error.getMessage()));
            }
        }
        this.errors = errorsBuilder.build();
        this.successCount = users - this.errors.size();
    }

    public int getSuccessCount() {
        return this.successCount;
    }

    public int getFailureCount() {
        return this.errors.size();
    }

    @NonNull
    public List<ErrorInfo> getErrors() {
        return this.errors;
    }
}

