/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.datatype;

import nu.validator.datatype.CdoCdcPair;
import org.relaxng.datatype.DatatypeException;

public final class ScriptDocumentation
extends CdoCdcPair {
    public static final ScriptDocumentation THE_INSTANCE = new ScriptDocumentation();

    private ScriptDocumentation() {
    }

    @Override
    public void checkValid(CharSequence literal) throws DatatypeException {
        State state = State.BEFORE_DOCUMENTATION;
        block24: for (int i = 0; i < literal.length(); ++i) {
            char c = literal.charAt(i);
            switch (state.ordinal()) {
                case 0: {
                    switch (c) {
                        case '\t': 
                        case '\n': 
                        case ' ': {
                            continue block24;
                        }
                        case '/': {
                            if (i == literal.length() - 1) {
                                throw this.newDatatypeException("Expected asterisk or slash but content ended with a single slash instead.");
                            }
                            state = State.SLASH;
                            continue block24;
                        }
                    }
                    throw this.newDatatypeException("Expected space, tab, newline, or slash but found \u201c" + c + "\u201d instead.");
                }
                case 1: {
                    switch (c) {
                        case '*': {
                            state = State.IN_COMMENT;
                            continue block24;
                        }
                        case '/': {
                            state = State.IN_LINE_COMMENT;
                            continue block24;
                        }
                    }
                    throw this.newDatatypeException("Expected asterisk or slash but found \u201c" + c + "\u201d instead.");
                }
                case 2: {
                    switch (c) {
                        case '*': {
                            state = State.STAR;
                            continue block24;
                        }
                    }
                    continue block24;
                }
                case 4: {
                    switch (c) {
                        case '/': {
                            state = State.BEFORE_DOCUMENTATION;
                            continue block24;
                        }
                    }
                    continue block24;
                }
                case 3: {
                    switch (c) {
                        case '\n': {
                            state = State.BEFORE_DOCUMENTATION;
                            continue block24;
                        }
                    }
                    continue block24;
                }
                default: {
                    throw this.newDatatypeException("Content ended prematurely.");
                }
            }
        }
        if (state == State.IN_LINE_COMMENT) {
            throw this.newDatatypeException("Content contains a line starting with the character sequence \u201c//\u201d but not ending with a newline.");
        }
        if (state == State.IN_COMMENT || state == State.STAR) {
            throw this.newDatatypeException("Content contains the character sequence \u201c/*\u201d without a later occurrence of the character sequence \u201c*/\u201d.");
        }
        super.checkValid(literal);
    }

    @Override
    public String getName() {
        return "script documentation";
    }

    private static enum State {
        BEFORE_DOCUMENTATION,
        SLASH,
        IN_COMMENT,
        IN_LINE_COMMENT,
        STAR;

    }
}

