/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.snaptracer.impl;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.LogRecord;
import javax.swing.Icon;
import org.graalvm.visualvm.lib.jfluid.results.cpu.PrestimeCPUCCTNode;
import org.graalvm.visualvm.lib.profiler.LoadedSnapshot;
import org.graalvm.visualvm.lib.profiler.SampledCPUSnapshot;
import org.graalvm.visualvm.lib.profiler.snaptracer.logs.LogReader;
import org.openide.filesystems.FileObject;

public final class IdeSnapshot {
    private final SampledCPUSnapshot cpuSnapshot;
    private LogReader xmlLogs;
    private LogRecord lastRecord;
    private Map<Integer, LogRecord> recordsMap;
    private Map<Integer, LogRecordInfo> infosMap;
    private final FileObject npssFileObject;

    public IdeSnapshot(FileObject npssFO, FileObject uigestureFO) throws IOException {
        this.cpuSnapshot = new SampledCPUSnapshot(npssFO);
        this.npssFileObject = npssFO;
        if (uigestureFO != null) {
            this.xmlLogs = new LogReader(uigestureFO);
            this.xmlLogs.load();
            this.recordsMap = new HashMap<Integer, LogRecord>();
            this.infosMap = new HashMap<Integer, LogRecordInfo>();
        }
    }

    int getSamplesCount() {
        return this.cpuSnapshot.getSamplesCount();
    }

    long getTimestamp(int sampleIndex) throws IOException {
        return this.cpuSnapshot.getTimestamp(sampleIndex);
    }

    FileObject getNpssFileObject() {
        return this.npssFileObject;
    }

    public boolean hasUiGestures() {
        return this.xmlLogs != null;
    }

    LoadedSnapshot getCPUSnapshot(int startIndex, int endIndex) throws IOException {
        return this.cpuSnapshot.getCPUSnapshot(startIndex, endIndex);
    }

    public long getValue(int sampleIndex, int valIndex) throws IOException {
        Integer val;
        if (valIndex == 0) {
            return this.cpuSnapshot.getValue(sampleIndex, valIndex);
        }
        if (this.xmlLogs != null && (val = this.getLogRecordValue(sampleIndex)) != null) {
            return val.intValue();
        }
        return 0L;
    }

    public LogRecordInfo getLogInfoForValue(long loggerValue) {
        if (this.xmlLogs == null || loggerValue == 0L) {
            return null;
        }
        Integer index = new Integer((int)loggerValue);
        LogRecordInfo info = this.infosMap.get(index);
        if (info == null) {
            LogRecord rec = this.recordsMap.get(index);
            assert (rec != null) : "Null record for value " + index;
            info = new LogRecordInfo(rec);
            this.infosMap.put(index, info);
        }
        return info;
    }

    private Integer getLogRecordValue(int sampleIndex) throws IOException {
        long timestamp = this.getTimestamp(sampleIndex);
        LogRecord rec = this.xmlLogs.getRecordFor(timestamp / 1000000L);
        if (rec != null) {
            long startTime = this.cpuSnapshot.getStartTime();
            long endTime = this.getTimestamp(this.getSamplesCount() - 1);
            long recTime = rec.getMillis() * 1000000L;
            if (recTime > startTime && recTime < endTime && rec != this.lastRecord) {
                Integer index = new Integer(sampleIndex + 1);
                this.lastRecord = rec;
                this.recordsMap.put(index, rec);
                return index;
            }
        }
        return null;
    }

    String getThreadDump(int sampleIndex) throws IOException {
        return this.cpuSnapshot.getThreadDump(sampleIndex);
    }

    List<Integer> getIntervals(int start, int end, PrestimeCPUCCTNode node) throws IOException {
        return this.cpuSnapshot.getIntervals(start, end, node);
    }

    public static final class LogRecordInfo {
        private static final int MAX_DISPLAY_NAME = 40;
        private String name;
        private String displayName;
        private String toolTip;
        private Icon icon;
        private LogRecord record;

        LogRecordInfo(LogRecord rec) {
            this.record = rec;
        }

        void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            String message;
            if (this.displayName == null && (message = this.record.getMessage()) != null && !message.isEmpty()) {
                StringBuilder sb = new StringBuilder(message);
                Object[] arr = this.record.getParameters();
                if (arr != null && arr.length > 0) {
                    String sep = " (";
                    for (Object par : arr) {
                        sb.append(sep);
                        sb.append(par);
                        sep = ", ";
                        if (sb.length() <= 40) continue;
                        return sb.substring(0, 40).concat(" ...");
                    }
                    sb.append(")");
                }
                return sb.toString();
            }
            return this.displayName;
        }

        void setToolTip(String toolTip) {
            this.toolTip = toolTip;
        }

        public String getToolTip() {
            return this.toolTip;
        }

        void setIcon(Icon icon) {
            this.icon = icon;
        }

        public Icon getIcon() {
            return this.icon;
        }
    }
}

