/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.messages;

import java.util.SortedSet;
import nu.validator.json.JsonHandler;
import nu.validator.source.SourceHandler;
import org.xml.sax.SAXException;

public class JsonExtractHandler
implements SourceHandler {
    private static final char[] NEWLINE = new char[]{'\n'};
    private final JsonHandler handler;
    private int hiliteStart;
    private int hiliteLength;
    private HiliteState hiliteState;

    public JsonExtractHandler(JsonHandler handler) {
        this.handler = handler;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.handler.characters(ch, start, length);
        switch (this.hiliteState.ordinal()) {
            case 0: {
                this.hiliteStart += length;
                break;
            }
            case 1: {
                this.hiliteLength += length;
            }
        }
    }

    @Override
    public void endCharHilite() throws SAXException {
        assert (this.hiliteState == HiliteState.INSIDE);
        this.hiliteState = HiliteState.AFTER;
    }

    @Override
    public void endRange() throws SAXException {
        assert (this.hiliteState == HiliteState.INSIDE);
        this.hiliteState = HiliteState.AFTER;
    }

    @Override
    public void endSource() throws SAXException {
        this.handler.endString();
    }

    @Override
    public void newLine() throws SAXException {
        this.handler.characters(NEWLINE, 0, 1);
        switch (this.hiliteState.ordinal()) {
            case 0: {
                ++this.hiliteStart;
                break;
            }
            case 1: {
                ++this.hiliteLength;
            }
        }
    }

    @Override
    public void startCharHilite(int oneBasedLine, int oneBasedColumn) throws SAXException {
        assert (this.hiliteState == HiliteState.BEFORE);
        this.hiliteState = HiliteState.INSIDE;
    }

    @Override
    public void startRange(int oneBasedLine, int oneBasedColumn) throws SAXException {
        assert (this.hiliteState == HiliteState.BEFORE);
        this.hiliteState = HiliteState.INSIDE;
    }

    @Override
    public void startSource(String type, String encoding) throws SAXException {
        this.hiliteStart = 0;
        this.hiliteLength = 0;
        this.hiliteState = HiliteState.BEFORE;
        this.handler.startString();
    }

    public int getHiliteLength() {
        return this.hiliteLength;
    }

    public int getHiliteStart() {
        return this.hiliteStart;
    }

    @Override
    public void setLineErrors(SortedSet<Integer> oneBasedLineErrors) throws SAXException {
    }

    private static enum HiliteState {
        BEFORE,
        INSIDE,
        AFTER;

    }
}

