/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    For copyright information, see AUTHORS.

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

using GLib;

namespace DejaDup {

public class ConfigChoice : ConfigWidget
{
  public signal void choice_changed(string val);

  private Hdy.ComboRow row;
  protected string default_val = null;

  // Subclasses use this to setup the choice list
  public void init(Hdy.ComboRow row)
  {
    this.row = row;
    set_from_config.begin();
    row.notify["selected-index"].connect(handle_changed);
  }

  public Value? get_current_value()
  {
    var model = row.get_model();
    if (model == null)
      return null;

    if (row.selected_index >= model.get_n_items())
      return null;

    var val_object = model.get_object(row.selected_index) as Hdy.ValueObject;
    if (val_object == null)
      return null;

    return val_object.get_value();
  }

  protected virtual void handle_changed()
  {
    Value? val = get_current_value();
    string strval = val == null ? "" : val.get_string();

    settings.set_string(key, strval);

    choice_changed(strval);
  }

  protected override async void set_from_config()
  {
    string confval = settings.get_string(key);
    if (confval == null || confval == "")
      confval = default_val;
    if (confval == null)
      return;

    bool valid = false;
    var model = row.get_model();
    for (int i = 0; i < model.get_n_items(); i++) {
      var val_object = model.get_object(i) as Hdy.ValueObject;
      var val = val_object.get_value();

      if (val.get_string() != confval)
        continue;

      valid = true;
      row.selected_index = i;

      break;
    }
  }
}

}
