/*
 * Copyright (C) 2018 Purism SPC
 *
 * This file is part of Hægtesse.
 *
 * Hægtesse is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * Hægtesse is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Hægtesse.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Bob Ham <bob.ham@puri.sm>
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */

#ifndef HAEG_AUDIO_H__
#define HAEG_AUDIO_H__

#include <glib-object.h>

G_BEGIN_DECLS

#define HAEG_TYPE_AUDIO (haeg_audio_get_type ())

G_DECLARE_FINAL_TYPE (HaegAudio, haeg_audio, HAEG, AUDIO, GObject);

HaegAudio *haeg_audio_new               (gsize       fragment_size);
gboolean   haeg_audio_is_corked         (HaegAudio  *audio);
void       haeg_audio_cork              (HaegAudio  *audio);
void       haeg_audio_uncork            (HaegAudio  *self);
void       haeg_audio_begin_write       (HaegAudio  *self,
                                         void      **buf,
                                         size_t     *buf_size);
void       haeg_audio_cancel_write      (HaegAudio  *self);
void       haeg_audio_write             (HaegAudio  *self,
                                         const void *buf,
                                         size_t      buf_size);
void       haeg_audio_get_mic_buffer    (HaegAudio  *self,
                                         void      **data,
                                         size_t     *write_len);
void       haeg_audio_update_mic_buffer (HaegAudio  *self,
                                         size_t      written);
void       haeg_audio_clear_mic_buffer  (HaegAudio  *self);

G_END_DECLS

#endif /* HAEG_AUDIO_H__ */
