/*
 * Copyright (C) 2018 Purism SPC
 *
 * This file is part of Hægtesse.
 *
 * Hægtesse is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * Hægtesse is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Hægtesse.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Bob Ham <bob.ham@puri.sm>
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */

#ifndef HAEG_PORT_H__
#define HAEG_PORT_H__

#include <glib-object.h>

G_BEGIN_DECLS

#define HAEG_TYPE_PORT (haeg_port_get_type ())

G_DECLARE_FINAL_TYPE (HaegPort, haeg_port, HAEG, PORT, GObject);

HaegPort *haeg_port_new   (const gchar *file_name,
                           gsize        sample_len,
                           GError     **error);
void      haeg_port_start (HaegPort    *port);
void      haeg_port_stop  (HaegPort    *self);
gsize     haeg_port_read  (HaegPort    *self,
                           void        *buf,
                           size_t       buf_size,
                           GError     **error);
gsize     haeg_port_write (HaegPort    *self,
                           void        *buf,
                           size_t       buf_size,
                           gboolean    *not_ready,
                           GError     **error);

G_END_DECLS

#endif /* HAEG_PORT_H__ */
