/* valainterface.c generated by valac, the Vala compiler
 * generated from valainterface.vala, do not modify */

/* valainterface.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <valagee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))

struct _ValaInterfacePrivate {
	ValaList* prerequisites;
	ValaList* virtuals;
};

static gint ValaInterface_private_offset;
static gpointer vala_interface_parent_class = NULL;

static void vala_interface_real_add_method (ValaSymbol* base,
                                     ValaMethod* m);
static void vala_interface_real_add_property (ValaSymbol* base,
                                       ValaProperty* prop);
static ValaList* vala_interface_real_get_virtuals (ValaInterface* self);
static void vala_interface_real_accept (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor);
static void vala_interface_real_accept_children (ValaCodeNode* base,
                                          ValaCodeVisitor* visitor);
static gboolean vala_interface_real_is_reference_type (ValaTypeSymbol* base);
static gboolean vala_interface_real_is_subtype_of (ValaTypeSymbol* base,
                                            ValaTypeSymbol* t);
static void vala_interface_real_replace_type (ValaCodeNode* base,
                                       ValaDataType* old_type,
                                       ValaDataType* new_type);
static gboolean vala_interface_real_check (ValaCodeNode* base,
                                    ValaCodeContext* context);
static void vala_interface_finalize (ValaCodeNode * obj);
static GType vala_interface_get_type_once (void);

static inline gpointer
vala_interface_get_instance_private (ValaInterface* self)
{
	return G_STRUCT_MEMBER_P (self, ValaInterface_private_offset);
}

/**
 * Creates a new interface.
 *
 * @param name              type name
 * @param source_reference  reference to source code
 * @return                  newly created interface
 */
ValaInterface*
vala_interface_construct (GType object_type,
                          const gchar* name,
                          ValaSourceReference* source_reference,
                          ValaComment* comment)
{
	ValaInterface* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaInterface*) vala_object_type_symbol_construct (object_type, name, source_reference, comment);
	return self;
}

ValaInterface*
vala_interface_new (const gchar* name,
                    ValaSourceReference* source_reference,
                    ValaComment* comment)
{
	return vala_interface_construct (VALA_TYPE_INTERFACE, name, source_reference, comment);
}

/**
 * Adds the specified interface or class to the list of prerequisites of
 * this interface.
 *
 * @param type an interface or class reference
 */
void
vala_interface_add_prerequisite (ValaInterface* self,
                                 ValaDataType* type)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	_tmp0_ = self->priv->prerequisites;
	vala_collection_add ((ValaCollection*) _tmp0_, type);
	vala_code_node_set_parent_node ((ValaCodeNode*) type, (ValaCodeNode*) self);
}

/**
 * Returns the base type list.
 *
 * @return list of base types
 */
ValaList*
vala_interface_get_prerequisites (ValaInterface* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->prerequisites;
	result = _tmp0_;
	return result;
}

/**
 * Adds the specified method as a member to this interface.
 *
 * @param m a method
 */
static void
vala_interface_real_add_method (ValaSymbol* base,
                                ValaMethod* m)
{
	ValaInterface * self;
	ValaMemberBinding _tmp2_;
	ValaMemberBinding _tmp3_;
	gboolean _tmp16_ = FALSE;
	ValaDataType* _tmp17_;
	ValaDataType* _tmp18_;
	self = (ValaInterface*) base;
	g_return_if_fail (m != NULL);
	if (VALA_IS_CREATION_METHOD (m)) {
		ValaSourceReference* _tmp0_;
		ValaSourceReference* _tmp1_;
		_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
		_tmp1_ = _tmp0_;
		vala_report_error (_tmp1_, "construction methods may only be declared within classes and structs");
		vala_code_node_set_error ((ValaCodeNode*) m, TRUE);
		return;
	}
	_tmp2_ = vala_method_get_binding (m);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != VALA_MEMBER_BINDING_STATIC) {
		ValaDataType* _tmp4_;
		ValaDataType* _tmp5_;
		ValaParameter* _tmp6_;
		ValaParameter* _tmp7_;
		ValaScope* _tmp8_;
		ValaScope* _tmp9_;
		ValaParameter* _tmp10_;
		ValaParameter* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		ValaParameter* _tmp14_;
		ValaParameter* _tmp15_;
		_tmp4_ = vala_semantic_analyzer_get_this_type ((ValaSymbol*) m, (ValaTypeSymbol*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_parameter_new ("this", _tmp5_, NULL);
		_tmp7_ = _tmp6_;
		vala_method_set_this_parameter (m, _tmp7_);
		_vala_code_node_unref0 (_tmp7_);
		_vala_code_node_unref0 (_tmp5_);
		_tmp8_ = vala_symbol_get_scope ((ValaSymbol*) m);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_method_get_this_parameter (m);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_symbol_get_name ((ValaSymbol*) _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_method_get_this_parameter (m);
		_tmp15_ = _tmp14_;
		vala_scope_add (_tmp9_, _tmp13_, (ValaSymbol*) _tmp15_);
	}
	_tmp17_ = vala_callable_get_return_type ((ValaCallable*) m);
	_tmp18_ = _tmp17_;
	if (!VALA_IS_VOID_TYPE (_tmp18_)) {
		ValaList* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		_tmp19_ = vala_method_get_postconditions (m);
		_tmp20_ = vala_collection_get_size ((ValaCollection*) _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp16_ = _tmp21_ > 0;
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		ValaDataType* _tmp22_;
		ValaDataType* _tmp23_;
		ValaDataType* _tmp24_;
		ValaDataType* _tmp25_;
		ValaSourceReference* _tmp26_;
		ValaSourceReference* _tmp27_;
		ValaLocalVariable* _tmp28_;
		ValaLocalVariable* _tmp29_;
		ValaLocalVariable* _tmp30_;
		ValaLocalVariable* _tmp31_;
		_tmp22_ = vala_callable_get_return_type ((ValaCallable*) m);
		_tmp23_ = _tmp22_;
		_tmp24_ = vala_data_type_copy (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp27_ = _tmp26_;
		_tmp28_ = vala_local_variable_new (_tmp25_, "result", NULL, _tmp27_);
		_tmp29_ = _tmp28_;
		vala_subroutine_set_result_var ((ValaSubroutine*) m, _tmp29_);
		_vala_code_node_unref0 (_tmp29_);
		_vala_code_node_unref0 (_tmp25_);
		_tmp30_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
		_tmp31_ = _tmp30_;
		vala_local_variable_set_is_result (_tmp31_, TRUE);
	}
	VALA_SYMBOL_CLASS (vala_interface_parent_class)->add_method ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), m);
}

/**
 * Adds the specified property as a member to this interface.
 *
 * @param prop a property
 */
static void
vala_interface_real_add_property (ValaSymbol* base,
                                  ValaProperty* prop)
{
	ValaInterface * self;
	ValaField* _tmp0_;
	ValaField* _tmp1_;
	ValaMemberBinding _tmp4_;
	ValaMemberBinding _tmp5_;
	self = (ValaInterface*) base;
	g_return_if_fail (prop != NULL);
	_tmp0_ = vala_property_get_field (prop);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaSourceReference* _tmp2_;
		ValaSourceReference* _tmp3_;
		_tmp2_ = vala_code_node_get_source_reference ((ValaCodeNode*) prop);
		_tmp3_ = _tmp2_;
		vala_report_error (_tmp3_, "interface properties should be `abstract' or have `get' accessor and/o" \
"r `set' mutator");
		vala_code_node_set_error ((ValaCodeNode*) prop, TRUE);
		return;
	}
	VALA_SYMBOL_CLASS (vala_interface_parent_class)->add_property ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), prop);
	_tmp4_ = vala_property_get_binding (prop);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != VALA_MEMBER_BINDING_STATIC) {
		ValaDataType* _tmp6_;
		ValaDataType* _tmp7_;
		ValaParameter* _tmp8_;
		ValaParameter* _tmp9_;
		ValaScope* _tmp10_;
		ValaScope* _tmp11_;
		ValaParameter* _tmp12_;
		ValaParameter* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		ValaParameter* _tmp16_;
		ValaParameter* _tmp17_;
		_tmp6_ = vala_semantic_analyzer_get_this_type ((ValaSymbol*) prop, (ValaTypeSymbol*) self);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_parameter_new ("this", _tmp7_, NULL);
		_tmp9_ = _tmp8_;
		vala_property_set_this_parameter (prop, _tmp9_);
		_vala_code_node_unref0 (_tmp9_);
		_vala_code_node_unref0 (_tmp7_);
		_tmp10_ = vala_symbol_get_scope ((ValaSymbol*) prop);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_property_get_this_parameter (prop);
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_symbol_get_name ((ValaSymbol*) _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_property_get_this_parameter (prop);
		_tmp17_ = _tmp16_;
		vala_scope_add (_tmp11_, _tmp15_, (ValaSymbol*) _tmp17_);
	}
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static ValaList*
vala_interface_real_get_virtuals (ValaInterface* self)
{
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	ValaList* result = NULL;
	_tmp0_ = self->priv->virtuals;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

ValaList*
vala_interface_get_virtuals (ValaInterface* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_INTERFACE_GET_CLASS (self)->get_virtuals (self);
}

static void
vala_interface_real_accept (ValaCodeNode* base,
                            ValaCodeVisitor* visitor)
{
	ValaInterface * self;
	self = (ValaInterface*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_interface (visitor, self);
}

static void
vala_interface_real_accept_children (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor)
{
	ValaInterface * self;
	self = (ValaInterface*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _type_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _type_index = 0;
		_tmp0_ = self->priv->prerequisites;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_type_list = _tmp1_;
		_tmp2_ = _type_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_type_size = _tmp4_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaDataType* type = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaDataType* _tmp9_;
			_type_index = _type_index + 1;
			_tmp5_ = _type_index;
			_tmp6_ = _type_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _type_list;
			_tmp8_ = vala_list_get (_tmp7_, _type_index);
			type = (ValaDataType*) _tmp8_;
			_tmp9_ = type;
			vala_code_node_accept ((ValaCodeNode*) _tmp9_, visitor);
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	VALA_CODE_NODE_CLASS (vala_interface_parent_class)->accept_children ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), visitor);
}

static gboolean
vala_interface_real_is_reference_type (ValaTypeSymbol* base)
{
	ValaInterface * self;
	gboolean result = FALSE;
	self = (ValaInterface*) base;
	result = TRUE;
	return result;
}

static gboolean
vala_interface_real_is_subtype_of (ValaTypeSymbol* base,
                                   ValaTypeSymbol* t)
{
	ValaInterface * self;
	gboolean result = FALSE;
	self = (ValaInterface*) base;
	g_return_val_if_fail (t != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol) == t) {
		result = TRUE;
		return result;
	}
	{
		ValaList* _prerequisite_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _prerequisite_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _prerequisite_index = 0;
		_tmp0_ = self->priv->prerequisites;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_prerequisite_list = _tmp1_;
		_tmp2_ = _prerequisite_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_prerequisite_size = _tmp4_;
		_prerequisite_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaDataType* prerequisite = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			gboolean _tmp9_ = FALSE;
			ValaDataType* _tmp10_;
			ValaTypeSymbol* _tmp11_;
			ValaTypeSymbol* _tmp12_;
			_prerequisite_index = _prerequisite_index + 1;
			_tmp5_ = _prerequisite_index;
			_tmp6_ = _prerequisite_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _prerequisite_list;
			_tmp8_ = vala_list_get (_tmp7_, _prerequisite_index);
			prerequisite = (ValaDataType*) _tmp8_;
			_tmp10_ = prerequisite;
			_tmp11_ = vala_data_type_get_type_symbol (_tmp10_);
			_tmp12_ = _tmp11_;
			if (_tmp12_ != NULL) {
				ValaDataType* _tmp13_;
				ValaTypeSymbol* _tmp14_;
				ValaTypeSymbol* _tmp15_;
				_tmp13_ = prerequisite;
				_tmp14_ = vala_data_type_get_type_symbol (_tmp13_);
				_tmp15_ = _tmp14_;
				_tmp9_ = vala_typesymbol_is_subtype_of (_tmp15_, t);
			} else {
				_tmp9_ = FALSE;
			}
			if (_tmp9_) {
				result = TRUE;
				_vala_code_node_unref0 (prerequisite);
				_vala_iterable_unref0 (_prerequisite_list);
				return result;
			}
			_vala_code_node_unref0 (prerequisite);
		}
		_vala_iterable_unref0 (_prerequisite_list);
	}
	result = FALSE;
	return result;
}

static void
vala_interface_real_replace_type (ValaCodeNode* base,
                                  ValaDataType* old_type,
                                  ValaDataType* new_type)
{
	ValaInterface * self;
	self = (ValaInterface*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaDataType* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->prerequisites;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->prerequisites;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaDataType*) _tmp6_;
				_tmp8_ = _tmp7_ == old_type;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->prerequisites;
					vala_list_set (_tmp9_, i, new_type);
					vala_code_node_set_parent_node ((ValaCodeNode*) new_type, (ValaCodeNode*) self);
					return;
				}
			}
		}
	}
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_interface_real_check (ValaCodeNode* base,
                           ValaCodeContext* context)
{
	ValaInterface * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSourceFile* _tmp6_;
	ValaSourceFile* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp9_;
	ValaSemanticAnalyzer* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSourceReference* _tmp14_;
	ValaSourceReference* _tmp15_;
	ValaSemanticAnalyzer* _tmp22_;
	ValaSemanticAnalyzer* _tmp23_;
	ValaClass* prereq_class = NULL;
	gboolean _tmp136_;
	gboolean _tmp137_;
	ValaMap* positions = NULL;
	GHashFunc _tmp275_;
	GEqualFunc _tmp276_;
	GEqualFunc _tmp277_;
	ValaHashMap* _tmp278_;
	gboolean ordered_seen = FALSE;
	gboolean unordered_seen = FALSE;
	ValaSemanticAnalyzer* _tmp354_;
	ValaSemanticAnalyzer* _tmp355_;
	ValaSourceFile* _tmp356_;
	ValaSemanticAnalyzer* _tmp357_;
	ValaSemanticAnalyzer* _tmp358_;
	ValaSymbol* _tmp359_;
	gboolean _tmp360_;
	gboolean _tmp361_;
	gboolean result = FALSE;
	self = (ValaInterface*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_context_get_analyzer (context);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_semantic_analyzer_get_current_source_file (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_source_file_ref0 (_tmp7_);
	old_source_file = _tmp8_;
	_tmp9_ = vala_code_context_get_analyzer (context);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_semantic_analyzer_get_current_symbol (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	old_symbol = _tmp13_;
	_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ValaSemanticAnalyzer* _tmp16_;
		ValaSemanticAnalyzer* _tmp17_;
		ValaSourceReference* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceFile* _tmp20_;
		ValaSourceFile* _tmp21_;
		_tmp16_ = vala_code_context_get_analyzer (context);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_source_reference_get_file (_tmp19_);
		_tmp21_ = _tmp20_;
		vala_semantic_analyzer_set_current_source_file (_tmp17_, _tmp21_);
	}
	_tmp22_ = vala_code_context_get_analyzer (context);
	_tmp23_ = _tmp22_;
	vala_semantic_analyzer_set_current_symbol (_tmp23_, (ValaSymbol*) self);
	{
		ValaList* _prerequisite_reference_list = NULL;
		ValaList* _tmp24_;
		ValaList* _tmp25_;
		gint _prerequisite_reference_size = 0;
		ValaList* _tmp26_;
		gint _tmp27_;
		gint _tmp28_;
		gint _prerequisite_reference_index = 0;
		_tmp24_ = vala_interface_get_prerequisites (self);
		_tmp25_ = _vala_iterable_ref0 (_tmp24_);
		_prerequisite_reference_list = _tmp25_;
		_tmp26_ = _prerequisite_reference_list;
		_tmp27_ = vala_collection_get_size ((ValaCollection*) _tmp26_);
		_tmp28_ = _tmp27_;
		_prerequisite_reference_size = _tmp28_;
		_prerequisite_reference_index = -1;
		while (TRUE) {
			gint _tmp29_;
			gint _tmp30_;
			ValaDataType* prerequisite_reference = NULL;
			ValaList* _tmp31_;
			gpointer _tmp32_;
			ValaSemanticAnalyzer* _tmp33_;
			ValaSemanticAnalyzer* _tmp34_;
			ValaDataType* _tmp35_;
			_prerequisite_reference_index = _prerequisite_reference_index + 1;
			_tmp29_ = _prerequisite_reference_index;
			_tmp30_ = _prerequisite_reference_size;
			if (!(_tmp29_ < _tmp30_)) {
				break;
			}
			_tmp31_ = _prerequisite_reference_list;
			_tmp32_ = vala_list_get (_tmp31_, _prerequisite_reference_index);
			prerequisite_reference = (ValaDataType*) _tmp32_;
			_tmp33_ = vala_code_context_get_analyzer (context);
			_tmp34_ = _tmp33_;
			_tmp35_ = prerequisite_reference;
			if (!vala_semantic_analyzer_is_type_accessible (_tmp34_, (ValaSymbol*) self, _tmp35_)) {
				ValaSourceReference* _tmp36_;
				ValaSourceReference* _tmp37_;
				ValaDataType* _tmp38_;
				gchar* _tmp39_;
				gchar* _tmp40_;
				gchar* _tmp41_;
				gchar* _tmp42_;
				gchar* _tmp43_;
				gchar* _tmp44_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp36_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp37_ = _tmp36_;
				_tmp38_ = prerequisite_reference;
				_tmp39_ = vala_code_node_to_string ((ValaCodeNode*) _tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp42_ = _tmp41_;
				_tmp43_ = g_strdup_printf ("prerequisite `%s' is less accessible than interface `%s'", _tmp40_, _tmp42_);
				_tmp44_ = _tmp43_;
				vala_report_error (_tmp37_, _tmp44_);
				_g_free0 (_tmp44_);
				_g_free0 (_tmp42_);
				_g_free0 (_tmp40_);
				result = FALSE;
				_vala_code_node_unref0 (prerequisite_reference);
				_vala_iterable_unref0 (_prerequisite_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_vala_code_node_unref0 (prerequisite_reference);
		}
		_vala_iterable_unref0 (_prerequisite_reference_list);
	}
	prereq_class = NULL;
	{
		ValaList* _prereq_list = NULL;
		ValaList* _tmp45_;
		ValaList* _tmp46_;
		gint _prereq_size = 0;
		ValaList* _tmp47_;
		gint _tmp48_;
		gint _tmp49_;
		gint _prereq_index = 0;
		_tmp45_ = vala_interface_get_prerequisites (self);
		_tmp46_ = _vala_iterable_ref0 (_tmp45_);
		_prereq_list = _tmp46_;
		_tmp47_ = _prereq_list;
		_tmp48_ = vala_collection_get_size ((ValaCollection*) _tmp47_);
		_tmp49_ = _tmp48_;
		_prereq_size = _tmp49_;
		_prereq_index = -1;
		while (TRUE) {
			gint _tmp50_;
			gint _tmp51_;
			ValaDataType* prereq = NULL;
			ValaList* _tmp52_;
			gpointer _tmp53_;
			ValaDataType* _tmp54_;
			ValaDataType* _tmp64_;
			ValaTypeSymbol* _tmp65_;
			ValaTypeSymbol* _tmp66_;
			_prereq_index = _prereq_index + 1;
			_tmp50_ = _prereq_index;
			_tmp51_ = _prereq_size;
			if (!(_tmp50_ < _tmp51_)) {
				break;
			}
			_tmp52_ = _prereq_list;
			_tmp53_ = vala_list_get (_tmp52_, _prereq_index);
			prereq = (ValaDataType*) _tmp53_;
			_tmp54_ = prereq;
			if (!VALA_IS_OBJECT_TYPE (_tmp54_)) {
				ValaSourceReference* _tmp55_;
				ValaSourceReference* _tmp56_;
				ValaDataType* _tmp57_;
				gchar* _tmp58_;
				gchar* _tmp59_;
				gchar* _tmp60_;
				gchar* _tmp61_;
				gchar* _tmp62_;
				gchar* _tmp63_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp55_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp56_ = _tmp55_;
				_tmp57_ = prereq;
				_tmp58_ = vala_code_node_to_string ((ValaCodeNode*) _tmp57_);
				_tmp59_ = _tmp58_;
				_tmp60_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp61_ = _tmp60_;
				_tmp62_ = g_strdup_printf ("Prerequisite `%s' of interface `%s' is not a class or interface", _tmp59_, _tmp61_);
				_tmp63_ = _tmp62_;
				vala_report_error (_tmp56_, _tmp63_);
				_g_free0 (_tmp63_);
				_g_free0 (_tmp61_);
				_g_free0 (_tmp59_);
				result = FALSE;
				_vala_code_node_unref0 (prereq);
				_vala_iterable_unref0 (_prereq_list);
				_vala_code_node_unref0 (prereq_class);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp64_ = prereq;
			_tmp65_ = vala_data_type_get_type_symbol (_tmp64_);
			_tmp66_ = _tmp65_;
			if (VALA_IS_CLASS (_tmp66_)) {
				ValaClass* _tmp67_;
				ValaDataType* _tmp82_;
				ValaTypeSymbol* _tmp83_;
				ValaTypeSymbol* _tmp84_;
				ValaClass* _tmp85_;
				_tmp67_ = prereq_class;
				if (_tmp67_ != NULL) {
					ValaSourceReference* _tmp68_;
					ValaSourceReference* _tmp69_;
					gchar* _tmp70_;
					gchar* _tmp71_;
					ValaDataType* _tmp72_;
					ValaTypeSymbol* _tmp73_;
					ValaTypeSymbol* _tmp74_;
					gchar* _tmp75_;
					gchar* _tmp76_;
					ValaClass* _tmp77_;
					gchar* _tmp78_;
					gchar* _tmp79_;
					gchar* _tmp80_;
					gchar* _tmp81_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp68_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp69_ = _tmp68_;
					_tmp70_ = vala_symbol_get_full_name ((ValaSymbol*) self);
					_tmp71_ = _tmp70_;
					_tmp72_ = prereq;
					_tmp73_ = vala_data_type_get_type_symbol (_tmp72_);
					_tmp74_ = _tmp73_;
					_tmp75_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp74_);
					_tmp76_ = _tmp75_;
					_tmp77_ = prereq_class;
					_tmp78_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp77_);
					_tmp79_ = _tmp78_;
					_tmp80_ = g_strdup_printf ("%s: Interfaces cannot have multiple instantiable prerequisites (`%s' a" \
"nd `%s')", _tmp71_, _tmp76_, _tmp79_);
					_tmp81_ = _tmp80_;
					vala_report_error (_tmp69_, _tmp81_);
					_g_free0 (_tmp81_);
					_g_free0 (_tmp79_);
					_g_free0 (_tmp76_);
					_g_free0 (_tmp71_);
					result = FALSE;
					_vala_code_node_unref0 (prereq);
					_vala_iterable_unref0 (_prereq_list);
					_vala_code_node_unref0 (prereq_class);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					return result;
				}
				_tmp82_ = prereq;
				_tmp83_ = vala_data_type_get_type_symbol (_tmp82_);
				_tmp84_ = _tmp83_;
				_tmp85_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp84_, VALA_TYPE_CLASS, ValaClass));
				_vala_code_node_unref0 (prereq_class);
				prereq_class = _tmp85_;
			}
			_vala_code_node_unref0 (prereq);
		}
		_vala_iterable_unref0 (_prereq_list);
	}
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp86_;
		ValaList* _tmp87_;
		gint _type_size = 0;
		ValaList* _tmp88_;
		gint _tmp89_;
		gint _tmp90_;
		gint _type_index = 0;
		_tmp86_ = self->priv->prerequisites;
		_tmp87_ = _vala_iterable_ref0 (_tmp86_);
		_type_list = _tmp87_;
		_tmp88_ = _type_list;
		_tmp89_ = vala_collection_get_size ((ValaCollection*) _tmp88_);
		_tmp90_ = _tmp89_;
		_type_size = _tmp90_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp91_;
			gint _tmp92_;
			ValaDataType* type = NULL;
			ValaList* _tmp93_;
			gpointer _tmp94_;
			ValaDataType* _tmp95_;
			_type_index = _type_index + 1;
			_tmp91_ = _type_index;
			_tmp92_ = _type_size;
			if (!(_tmp91_ < _tmp92_)) {
				break;
			}
			_tmp93_ = _type_list;
			_tmp94_ = vala_list_get (_tmp93_, _type_index);
			type = (ValaDataType*) _tmp94_;
			_tmp95_ = type;
			vala_code_node_check ((ValaCodeNode*) _tmp95_, context);
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp96_;
		ValaList* _tmp97_;
		gint _p_size = 0;
		ValaList* _tmp98_;
		gint _tmp99_;
		gint _tmp100_;
		gint _p_index = 0;
		_tmp96_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) self);
		_tmp97_ = _vala_iterable_ref0 (_tmp96_);
		_p_list = _tmp97_;
		_tmp98_ = _p_list;
		_tmp99_ = vala_collection_get_size ((ValaCollection*) _tmp98_);
		_tmp100_ = _tmp99_;
		_p_size = _tmp100_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp101_;
			gint _tmp102_;
			ValaTypeParameter* p = NULL;
			ValaList* _tmp103_;
			gpointer _tmp104_;
			ValaTypeParameter* _tmp105_;
			_p_index = _p_index + 1;
			_tmp101_ = _p_index;
			_tmp102_ = _p_size;
			if (!(_tmp101_ < _tmp102_)) {
				break;
			}
			_tmp103_ = _p_list;
			_tmp104_ = vala_list_get (_tmp103_, _p_index);
			p = (ValaTypeParameter*) _tmp104_;
			_tmp105_ = p;
			vala_code_node_check ((ValaCodeNode*) _tmp105_, context);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	{
		ValaList* _en_list = NULL;
		ValaList* _tmp106_;
		ValaList* _tmp107_;
		gint _en_size = 0;
		ValaList* _tmp108_;
		gint _tmp109_;
		gint _tmp110_;
		gint _en_index = 0;
		_tmp106_ = vala_object_type_symbol_get_enums ((ValaObjectTypeSymbol*) self);
		_tmp107_ = _vala_iterable_ref0 (_tmp106_);
		_en_list = _tmp107_;
		_tmp108_ = _en_list;
		_tmp109_ = vala_collection_get_size ((ValaCollection*) _tmp108_);
		_tmp110_ = _tmp109_;
		_en_size = _tmp110_;
		_en_index = -1;
		while (TRUE) {
			gint _tmp111_;
			gint _tmp112_;
			ValaEnum* en = NULL;
			ValaList* _tmp113_;
			gpointer _tmp114_;
			ValaEnum* _tmp115_;
			_en_index = _en_index + 1;
			_tmp111_ = _en_index;
			_tmp112_ = _en_size;
			if (!(_tmp111_ < _tmp112_)) {
				break;
			}
			_tmp113_ = _en_list;
			_tmp114_ = vala_list_get (_tmp113_, _en_index);
			en = (ValaEnum*) _tmp114_;
			_tmp115_ = en;
			vala_code_node_check ((ValaCodeNode*) _tmp115_, context);
			_vala_code_node_unref0 (en);
		}
		_vala_iterable_unref0 (_en_list);
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp116_;
		ValaList* _tmp117_;
		gint _f_size = 0;
		ValaList* _tmp118_;
		gint _tmp119_;
		gint _tmp120_;
		gint _f_index = 0;
		_tmp116_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) self);
		_tmp117_ = _vala_iterable_ref0 (_tmp116_);
		_f_list = _tmp117_;
		_tmp118_ = _f_list;
		_tmp119_ = vala_collection_get_size ((ValaCollection*) _tmp118_);
		_tmp120_ = _tmp119_;
		_f_size = _tmp120_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp121_;
			gint _tmp122_;
			ValaField* f = NULL;
			ValaList* _tmp123_;
			gpointer _tmp124_;
			ValaField* _tmp125_;
			_f_index = _f_index + 1;
			_tmp121_ = _f_index;
			_tmp122_ = _f_size;
			if (!(_tmp121_ < _tmp122_)) {
				break;
			}
			_tmp123_ = _f_list;
			_tmp124_ = vala_list_get (_tmp123_, _f_index);
			f = (ValaField*) _tmp124_;
			_tmp125_ = f;
			vala_code_node_check ((ValaCodeNode*) _tmp125_, context);
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp126_;
		ValaList* _tmp127_;
		gint _c_size = 0;
		ValaList* _tmp128_;
		gint _tmp129_;
		gint _tmp130_;
		gint _c_index = 0;
		_tmp126_ = vala_object_type_symbol_get_constants ((ValaObjectTypeSymbol*) self);
		_tmp127_ = _vala_iterable_ref0 (_tmp126_);
		_c_list = _tmp127_;
		_tmp128_ = _c_list;
		_tmp129_ = vala_collection_get_size ((ValaCollection*) _tmp128_);
		_tmp130_ = _tmp129_;
		_c_size = _tmp130_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp131_;
			gint _tmp132_;
			ValaConstant* c = NULL;
			ValaList* _tmp133_;
			gpointer _tmp134_;
			ValaConstant* _tmp135_;
			_c_index = _c_index + 1;
			_tmp131_ = _c_index;
			_tmp132_ = _c_size;
			if (!(_tmp131_ < _tmp132_)) {
				break;
			}
			_tmp133_ = _c_list;
			_tmp134_ = vala_list_get (_tmp133_, _c_index);
			c = (ValaConstant*) _tmp134_;
			_tmp135_ = c;
			vala_code_node_check ((ValaCodeNode*) _tmp135_, context);
			_vala_code_node_unref0 (c);
		}
		_vala_iterable_unref0 (_c_list);
	}
	_tmp136_ = vala_code_context_get_abi_stability (context);
	_tmp137_ = _tmp136_;
	if (_tmp137_) {
		{
			ValaList* _s_list = NULL;
			ValaList* _tmp138_;
			ValaList* _tmp139_;
			gint _s_size = 0;
			ValaList* _tmp140_;
			gint _tmp141_;
			gint _tmp142_;
			gint _s_index = 0;
			_tmp138_ = vala_object_type_symbol_get_members ((ValaObjectTypeSymbol*) self);
			_tmp139_ = _vala_iterable_ref0 (_tmp138_);
			_s_list = _tmp139_;
			_tmp140_ = _s_list;
			_tmp141_ = vala_collection_get_size ((ValaCollection*) _tmp140_);
			_tmp142_ = _tmp141_;
			_s_size = _tmp142_;
			_s_index = -1;
			while (TRUE) {
				gint _tmp143_;
				gint _tmp144_;
				ValaSymbol* s = NULL;
				ValaList* _tmp145_;
				gpointer _tmp146_;
				ValaSymbol* _tmp147_;
				_s_index = _s_index + 1;
				_tmp143_ = _s_index;
				_tmp144_ = _s_size;
				if (!(_tmp143_ < _tmp144_)) {
					break;
				}
				_tmp145_ = _s_list;
				_tmp146_ = vala_list_get (_tmp145_, _s_index);
				s = (ValaSymbol*) _tmp146_;
				_tmp147_ = s;
				if (VALA_IS_METHOD (_tmp147_)) {
					ValaMethod* m = NULL;
					ValaSymbol* _tmp148_;
					ValaMethod* _tmp149_;
					ValaMethod* _tmp150_;
					gboolean _tmp151_ = FALSE;
					ValaMethod* _tmp152_;
					gboolean _tmp153_;
					gboolean _tmp154_;
					_tmp148_ = s;
					_tmp149_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp148_, VALA_TYPE_METHOD, ValaMethod));
					m = _tmp149_;
					_tmp150_ = m;
					vala_code_node_check ((ValaCodeNode*) _tmp150_, context);
					_tmp152_ = m;
					_tmp153_ = vala_method_get_is_virtual (_tmp152_);
					_tmp154_ = _tmp153_;
					if (_tmp154_) {
						_tmp151_ = TRUE;
					} else {
						ValaMethod* _tmp155_;
						gboolean _tmp156_;
						gboolean _tmp157_;
						_tmp155_ = m;
						_tmp156_ = vala_method_get_is_abstract (_tmp155_);
						_tmp157_ = _tmp156_;
						_tmp151_ = _tmp157_;
					}
					if (_tmp151_) {
						ValaList* _tmp158_;
						ValaMethod* _tmp159_;
						_tmp158_ = self->priv->virtuals;
						_tmp159_ = m;
						vala_collection_add ((ValaCollection*) _tmp158_, (ValaSymbol*) _tmp159_);
					}
					_vala_code_node_unref0 (m);
				} else {
					ValaSymbol* _tmp160_;
					_tmp160_ = s;
					if (VALA_IS_SIGNAL (_tmp160_)) {
						ValaSignal* sig = NULL;
						ValaSymbol* _tmp161_;
						ValaSignal* _tmp162_;
						ValaSignal* _tmp163_;
						ValaSignal* _tmp164_;
						gboolean _tmp165_;
						gboolean _tmp166_;
						_tmp161_ = s;
						_tmp162_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp161_, VALA_TYPE_SIGNAL, ValaSignal));
						sig = _tmp162_;
						_tmp163_ = sig;
						vala_code_node_check ((ValaCodeNode*) _tmp163_, context);
						_tmp164_ = sig;
						_tmp165_ = vala_signal_get_is_virtual (_tmp164_);
						_tmp166_ = _tmp165_;
						if (_tmp166_) {
							ValaList* _tmp167_;
							ValaSignal* _tmp168_;
							_tmp167_ = self->priv->virtuals;
							_tmp168_ = sig;
							vala_collection_add ((ValaCollection*) _tmp167_, (ValaSymbol*) _tmp168_);
						}
						_vala_code_node_unref0 (sig);
					} else {
						ValaSymbol* _tmp169_;
						_tmp169_ = s;
						if (VALA_IS_PROPERTY (_tmp169_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp170_;
							ValaProperty* _tmp171_;
							ValaProperty* _tmp172_;
							gboolean _tmp173_ = FALSE;
							ValaProperty* _tmp174_;
							gboolean _tmp175_;
							gboolean _tmp176_;
							_tmp170_ = s;
							_tmp171_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp170_, VALA_TYPE_PROPERTY, ValaProperty));
							prop = _tmp171_;
							_tmp172_ = prop;
							vala_code_node_check ((ValaCodeNode*) _tmp172_, context);
							_tmp174_ = prop;
							_tmp175_ = vala_property_get_is_virtual (_tmp174_);
							_tmp176_ = _tmp175_;
							if (_tmp176_) {
								_tmp173_ = TRUE;
							} else {
								ValaProperty* _tmp177_;
								gboolean _tmp178_;
								gboolean _tmp179_;
								_tmp177_ = prop;
								_tmp178_ = vala_property_get_is_abstract (_tmp177_);
								_tmp179_ = _tmp178_;
								_tmp173_ = _tmp179_;
							}
							if (_tmp173_) {
								ValaList* _tmp180_;
								ValaProperty* _tmp181_;
								_tmp180_ = self->priv->virtuals;
								_tmp181_ = prop;
								vala_collection_add ((ValaCollection*) _tmp180_, (ValaSymbol*) _tmp181_);
							}
							_vala_code_node_unref0 (prop);
						}
					}
				}
				_vala_code_node_unref0 (s);
			}
			_vala_iterable_unref0 (_s_list);
		}
	} else {
		{
			ValaList* _m_list = NULL;
			ValaList* _tmp182_;
			ValaList* _tmp183_;
			gint _m_size = 0;
			ValaList* _tmp184_;
			gint _tmp185_;
			gint _tmp186_;
			gint _m_index = 0;
			_tmp182_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) self);
			_tmp183_ = _vala_iterable_ref0 (_tmp182_);
			_m_list = _tmp183_;
			_tmp184_ = _m_list;
			_tmp185_ = vala_collection_get_size ((ValaCollection*) _tmp184_);
			_tmp186_ = _tmp185_;
			_m_size = _tmp186_;
			_m_index = -1;
			while (TRUE) {
				gint _tmp187_;
				gint _tmp188_;
				ValaMethod* m = NULL;
				ValaList* _tmp189_;
				gpointer _tmp190_;
				ValaMethod* _tmp191_;
				gboolean _tmp192_ = FALSE;
				ValaMethod* _tmp193_;
				gboolean _tmp194_;
				gboolean _tmp195_;
				_m_index = _m_index + 1;
				_tmp187_ = _m_index;
				_tmp188_ = _m_size;
				if (!(_tmp187_ < _tmp188_)) {
					break;
				}
				_tmp189_ = _m_list;
				_tmp190_ = vala_list_get (_tmp189_, _m_index);
				m = (ValaMethod*) _tmp190_;
				_tmp191_ = m;
				vala_code_node_check ((ValaCodeNode*) _tmp191_, context);
				_tmp193_ = m;
				_tmp194_ = vala_method_get_is_virtual (_tmp193_);
				_tmp195_ = _tmp194_;
				if (_tmp195_) {
					_tmp192_ = TRUE;
				} else {
					ValaMethod* _tmp196_;
					gboolean _tmp197_;
					gboolean _tmp198_;
					_tmp196_ = m;
					_tmp197_ = vala_method_get_is_abstract (_tmp196_);
					_tmp198_ = _tmp197_;
					_tmp192_ = _tmp198_;
				}
				if (_tmp192_) {
					ValaList* _tmp199_;
					ValaMethod* _tmp200_;
					_tmp199_ = self->priv->virtuals;
					_tmp200_ = m;
					vala_collection_add ((ValaCollection*) _tmp199_, (ValaSymbol*) _tmp200_);
				}
				_vala_code_node_unref0 (m);
			}
			_vala_iterable_unref0 (_m_list);
		}
		{
			ValaList* _sig_list = NULL;
			ValaList* _tmp201_;
			ValaList* _tmp202_;
			gint _sig_size = 0;
			ValaList* _tmp203_;
			gint _tmp204_;
			gint _tmp205_;
			gint _sig_index = 0;
			_tmp201_ = vala_object_type_symbol_get_signals ((ValaObjectTypeSymbol*) self);
			_tmp202_ = _vala_iterable_ref0 (_tmp201_);
			_sig_list = _tmp202_;
			_tmp203_ = _sig_list;
			_tmp204_ = vala_collection_get_size ((ValaCollection*) _tmp203_);
			_tmp205_ = _tmp204_;
			_sig_size = _tmp205_;
			_sig_index = -1;
			while (TRUE) {
				gint _tmp206_;
				gint _tmp207_;
				ValaSignal* sig = NULL;
				ValaList* _tmp208_;
				gpointer _tmp209_;
				ValaSignal* _tmp210_;
				ValaSignal* _tmp211_;
				gboolean _tmp212_;
				gboolean _tmp213_;
				_sig_index = _sig_index + 1;
				_tmp206_ = _sig_index;
				_tmp207_ = _sig_size;
				if (!(_tmp206_ < _tmp207_)) {
					break;
				}
				_tmp208_ = _sig_list;
				_tmp209_ = vala_list_get (_tmp208_, _sig_index);
				sig = (ValaSignal*) _tmp209_;
				_tmp210_ = sig;
				vala_code_node_check ((ValaCodeNode*) _tmp210_, context);
				_tmp211_ = sig;
				_tmp212_ = vala_signal_get_is_virtual (_tmp211_);
				_tmp213_ = _tmp212_;
				if (_tmp213_) {
					ValaList* _tmp214_;
					ValaSignal* _tmp215_;
					_tmp214_ = self->priv->virtuals;
					_tmp215_ = sig;
					vala_collection_add ((ValaCollection*) _tmp214_, (ValaSymbol*) _tmp215_);
				}
				_vala_code_node_unref0 (sig);
			}
			_vala_iterable_unref0 (_sig_list);
		}
		{
			ValaList* _prop_list = NULL;
			ValaList* _tmp216_;
			ValaList* _tmp217_;
			gint _prop_size = 0;
			ValaList* _tmp218_;
			gint _tmp219_;
			gint _tmp220_;
			gint _prop_index = 0;
			_tmp216_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) self);
			_tmp217_ = _vala_iterable_ref0 (_tmp216_);
			_prop_list = _tmp217_;
			_tmp218_ = _prop_list;
			_tmp219_ = vala_collection_get_size ((ValaCollection*) _tmp218_);
			_tmp220_ = _tmp219_;
			_prop_size = _tmp220_;
			_prop_index = -1;
			while (TRUE) {
				gint _tmp221_;
				gint _tmp222_;
				ValaProperty* prop = NULL;
				ValaList* _tmp223_;
				gpointer _tmp224_;
				ValaProperty* _tmp225_;
				gboolean _tmp226_ = FALSE;
				ValaProperty* _tmp227_;
				gboolean _tmp228_;
				gboolean _tmp229_;
				_prop_index = _prop_index + 1;
				_tmp221_ = _prop_index;
				_tmp222_ = _prop_size;
				if (!(_tmp221_ < _tmp222_)) {
					break;
				}
				_tmp223_ = _prop_list;
				_tmp224_ = vala_list_get (_tmp223_, _prop_index);
				prop = (ValaProperty*) _tmp224_;
				_tmp225_ = prop;
				vala_code_node_check ((ValaCodeNode*) _tmp225_, context);
				_tmp227_ = prop;
				_tmp228_ = vala_property_get_is_virtual (_tmp227_);
				_tmp229_ = _tmp228_;
				if (_tmp229_) {
					_tmp226_ = TRUE;
				} else {
					ValaProperty* _tmp230_;
					gboolean _tmp231_;
					gboolean _tmp232_;
					_tmp230_ = prop;
					_tmp231_ = vala_property_get_is_abstract (_tmp230_);
					_tmp232_ = _tmp231_;
					_tmp226_ = _tmp232_;
				}
				if (_tmp226_) {
					ValaList* _tmp233_;
					ValaProperty* _tmp234_;
					_tmp233_ = self->priv->virtuals;
					_tmp234_ = prop;
					vala_collection_add ((ValaCollection*) _tmp233_, (ValaSymbol*) _tmp234_);
				}
				_vala_code_node_unref0 (prop);
			}
			_vala_iterable_unref0 (_prop_list);
		}
	}
	{
		ValaList* _cl_list = NULL;
		ValaList* _tmp235_;
		ValaList* _tmp236_;
		gint _cl_size = 0;
		ValaList* _tmp237_;
		gint _tmp238_;
		gint _tmp239_;
		gint _cl_index = 0;
		_tmp235_ = vala_object_type_symbol_get_classes ((ValaObjectTypeSymbol*) self);
		_tmp236_ = _vala_iterable_ref0 (_tmp235_);
		_cl_list = _tmp236_;
		_tmp237_ = _cl_list;
		_tmp238_ = vala_collection_get_size ((ValaCollection*) _tmp237_);
		_tmp239_ = _tmp238_;
		_cl_size = _tmp239_;
		_cl_index = -1;
		while (TRUE) {
			gint _tmp240_;
			gint _tmp241_;
			ValaClass* cl = NULL;
			ValaList* _tmp242_;
			gpointer _tmp243_;
			ValaClass* _tmp244_;
			_cl_index = _cl_index + 1;
			_tmp240_ = _cl_index;
			_tmp241_ = _cl_size;
			if (!(_tmp240_ < _tmp241_)) {
				break;
			}
			_tmp242_ = _cl_list;
			_tmp243_ = vala_list_get (_tmp242_, _cl_index);
			cl = (ValaClass*) _tmp243_;
			_tmp244_ = cl;
			vala_code_node_check ((ValaCodeNode*) _tmp244_, context);
			_vala_code_node_unref0 (cl);
		}
		_vala_iterable_unref0 (_cl_list);
	}
	{
		ValaList* _iface_list = NULL;
		ValaList* _tmp245_;
		ValaList* _tmp246_;
		gint _iface_size = 0;
		ValaList* _tmp247_;
		gint _tmp248_;
		gint _tmp249_;
		gint _iface_index = 0;
		_tmp245_ = vala_object_type_symbol_get_interfaces ((ValaObjectTypeSymbol*) self);
		_tmp246_ = _vala_iterable_ref0 (_tmp245_);
		_iface_list = _tmp246_;
		_tmp247_ = _iface_list;
		_tmp248_ = vala_collection_get_size ((ValaCollection*) _tmp247_);
		_tmp249_ = _tmp248_;
		_iface_size = _tmp249_;
		_iface_index = -1;
		while (TRUE) {
			gint _tmp250_;
			gint _tmp251_;
			ValaInterface* iface = NULL;
			ValaList* _tmp252_;
			gpointer _tmp253_;
			ValaInterface* _tmp254_;
			_iface_index = _iface_index + 1;
			_tmp250_ = _iface_index;
			_tmp251_ = _iface_size;
			if (!(_tmp250_ < _tmp251_)) {
				break;
			}
			_tmp252_ = _iface_list;
			_tmp253_ = vala_list_get (_tmp252_, _iface_index);
			iface = (ValaInterface*) _tmp253_;
			_tmp254_ = iface;
			vala_code_node_check ((ValaCodeNode*) _tmp254_, context);
			_vala_code_node_unref0 (iface);
		}
		_vala_iterable_unref0 (_iface_list);
	}
	{
		ValaList* _st_list = NULL;
		ValaList* _tmp255_;
		ValaList* _tmp256_;
		gint _st_size = 0;
		ValaList* _tmp257_;
		gint _tmp258_;
		gint _tmp259_;
		gint _st_index = 0;
		_tmp255_ = vala_object_type_symbol_get_structs ((ValaObjectTypeSymbol*) self);
		_tmp256_ = _vala_iterable_ref0 (_tmp255_);
		_st_list = _tmp256_;
		_tmp257_ = _st_list;
		_tmp258_ = vala_collection_get_size ((ValaCollection*) _tmp257_);
		_tmp259_ = _tmp258_;
		_st_size = _tmp259_;
		_st_index = -1;
		while (TRUE) {
			gint _tmp260_;
			gint _tmp261_;
			ValaStruct* st = NULL;
			ValaList* _tmp262_;
			gpointer _tmp263_;
			ValaStruct* _tmp264_;
			_st_index = _st_index + 1;
			_tmp260_ = _st_index;
			_tmp261_ = _st_size;
			if (!(_tmp260_ < _tmp261_)) {
				break;
			}
			_tmp262_ = _st_list;
			_tmp263_ = vala_list_get (_tmp262_, _st_index);
			st = (ValaStruct*) _tmp263_;
			_tmp264_ = st;
			vala_code_node_check ((ValaCodeNode*) _tmp264_, context);
			_vala_code_node_unref0 (st);
		}
		_vala_iterable_unref0 (_st_list);
	}
	{
		ValaList* _d_list = NULL;
		ValaList* _tmp265_;
		ValaList* _tmp266_;
		gint _d_size = 0;
		ValaList* _tmp267_;
		gint _tmp268_;
		gint _tmp269_;
		gint _d_index = 0;
		_tmp265_ = vala_object_type_symbol_get_delegates ((ValaObjectTypeSymbol*) self);
		_tmp266_ = _vala_iterable_ref0 (_tmp265_);
		_d_list = _tmp266_;
		_tmp267_ = _d_list;
		_tmp268_ = vala_collection_get_size ((ValaCollection*) _tmp267_);
		_tmp269_ = _tmp268_;
		_d_size = _tmp269_;
		_d_index = -1;
		while (TRUE) {
			gint _tmp270_;
			gint _tmp271_;
			ValaDelegate* d = NULL;
			ValaList* _tmp272_;
			gpointer _tmp273_;
			ValaDelegate* _tmp274_;
			_d_index = _d_index + 1;
			_tmp270_ = _d_index;
			_tmp271_ = _d_size;
			if (!(_tmp270_ < _tmp271_)) {
				break;
			}
			_tmp272_ = _d_list;
			_tmp273_ = vala_list_get (_tmp272_, _d_index);
			d = (ValaDelegate*) _tmp273_;
			_tmp274_ = d;
			vala_code_node_check ((ValaCodeNode*) _tmp274_, context);
			_vala_code_node_unref0 (d);
		}
		_vala_iterable_unref0 (_d_list);
	}
	_tmp275_ = g_direct_hash;
	_tmp276_ = g_direct_equal;
	_tmp277_ = g_direct_equal;
	_tmp278_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp275_, _tmp276_, _tmp277_);
	positions = (ValaMap*) _tmp278_;
	ordered_seen = FALSE;
	unordered_seen = FALSE;
	{
		ValaList* _sym_list = NULL;
		ValaList* _tmp279_;
		ValaList* _tmp280_;
		gint _sym_size = 0;
		ValaList* _tmp281_;
		gint _tmp282_;
		gint _tmp283_;
		gint _sym_index = 0;
		_tmp279_ = self->priv->virtuals;
		_tmp280_ = _vala_iterable_ref0 (_tmp279_);
		_sym_list = _tmp280_;
		_tmp281_ = _sym_list;
		_tmp282_ = vala_collection_get_size ((ValaCollection*) _tmp281_);
		_tmp283_ = _tmp282_;
		_sym_size = _tmp283_;
		_sym_index = -1;
		while (TRUE) {
			gint _tmp284_;
			gint _tmp285_;
			ValaSymbol* sym = NULL;
			ValaList* _tmp286_;
			gpointer _tmp287_;
			gint ordering = 0;
			ValaSymbol* _tmp288_;
			gboolean ordered = FALSE;
			gboolean _tmp297_ = FALSE;
			gboolean _tmp298_ = FALSE;
			gboolean _tmp307_ = FALSE;
			gboolean _tmp308_ = FALSE;
			gboolean _tmp309_ = FALSE;
			gboolean _tmp318_ = FALSE;
			gboolean _tmp319_ = FALSE;
			_sym_index = _sym_index + 1;
			_tmp284_ = _sym_index;
			_tmp285_ = _sym_size;
			if (!(_tmp284_ < _tmp285_)) {
				break;
			}
			_tmp286_ = _sym_list;
			_tmp287_ = vala_list_get (_tmp286_, _sym_index);
			sym = (ValaSymbol*) _tmp287_;
			_tmp288_ = sym;
			ordering = vala_code_node_get_attribute_integer ((ValaCodeNode*) _tmp288_, "CCode", "ordering", -1);
			if (ordering < -1) {
				ValaSymbol* _tmp289_;
				ValaSourceReference* _tmp290_;
				ValaSourceReference* _tmp291_;
				ValaSymbol* _tmp292_;
				gchar* _tmp293_;
				gchar* _tmp294_;
				gchar* _tmp295_;
				gchar* _tmp296_;
				_tmp289_ = sym;
				_tmp290_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp289_);
				_tmp291_ = _tmp290_;
				_tmp292_ = sym;
				_tmp293_ = vala_symbol_get_full_name (_tmp292_);
				_tmp294_ = _tmp293_;
				_tmp295_ = g_strdup_printf ("%s: Invalid ordering", _tmp294_);
				_tmp296_ = _tmp295_;
				vala_report_error (_tmp291_, _tmp296_);
				_g_free0 (_tmp296_);
				_g_free0 (_tmp294_);
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				ordered_seen = TRUE;
				unordered_seen = TRUE;
				_vala_code_node_unref0 (sym);
				continue;
			}
			ordered = ordering != -1;
			if (ordered) {
				_tmp298_ = unordered_seen;
			} else {
				_tmp298_ = FALSE;
			}
			if (_tmp298_) {
				_tmp297_ = !ordered_seen;
			} else {
				_tmp297_ = FALSE;
			}
			if (_tmp297_) {
				ValaSymbol* _tmp299_;
				ValaSourceReference* _tmp300_;
				ValaSourceReference* _tmp301_;
				ValaSymbol* _tmp302_;
				gchar* _tmp303_;
				gchar* _tmp304_;
				gchar* _tmp305_;
				gchar* _tmp306_;
				_tmp299_ = sym;
				_tmp300_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp299_);
				_tmp301_ = _tmp300_;
				_tmp302_ = sym;
				_tmp303_ = vala_symbol_get_full_name (_tmp302_);
				_tmp304_ = _tmp303_;
				_tmp305_ = g_strdup_printf ("%s: Cannot mix ordered and unordered virtuals", _tmp304_);
				_tmp306_ = _tmp305_;
				vala_report_error (_tmp301_, _tmp306_);
				_g_free0 (_tmp306_);
				_g_free0 (_tmp304_);
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			if (ordered_seen) {
				_tmp307_ = TRUE;
			} else {
				_tmp307_ = ordered;
			}
			ordered_seen = _tmp307_;
			if (!ordered) {
				_tmp309_ = !unordered_seen;
			} else {
				_tmp309_ = FALSE;
			}
			if (_tmp309_) {
				_tmp308_ = ordered_seen;
			} else {
				_tmp308_ = FALSE;
			}
			if (_tmp308_) {
				ValaSymbol* _tmp310_;
				ValaSourceReference* _tmp311_;
				ValaSourceReference* _tmp312_;
				ValaSymbol* _tmp313_;
				gchar* _tmp314_;
				gchar* _tmp315_;
				gchar* _tmp316_;
				gchar* _tmp317_;
				_tmp310_ = sym;
				_tmp311_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp310_);
				_tmp312_ = _tmp311_;
				_tmp313_ = sym;
				_tmp314_ = vala_symbol_get_full_name (_tmp313_);
				_tmp315_ = _tmp314_;
				_tmp316_ = g_strdup_printf ("%s: Cannot mix ordered and unordered virtuals", _tmp315_);
				_tmp317_ = _tmp316_;
				vala_report_error (_tmp312_, _tmp317_);
				_g_free0 (_tmp317_);
				_g_free0 (_tmp315_);
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			if (unordered_seen) {
				_tmp318_ = TRUE;
			} else {
				_tmp318_ = !ordered;
			}
			unordered_seen = _tmp318_;
			if (!ordered_seen) {
				_tmp319_ = TRUE;
			} else {
				_tmp319_ = !unordered_seen;
			}
			if (_tmp319_) {
				if (ordered) {
					ValaSymbol* prev = NULL;
					ValaMap* _tmp320_;
					gpointer _tmp321_;
					ValaSymbol* _tmp322_;
					ValaMap* _tmp334_;
					ValaSymbol* _tmp335_;
					_tmp320_ = positions;
					_tmp321_ = vala_map_get (_tmp320_, (gpointer) ((gintptr) ordering));
					prev = (ValaSymbol*) _tmp321_;
					_tmp322_ = prev;
					if (_tmp322_ != NULL) {
						ValaSymbol* _tmp323_;
						ValaSourceReference* _tmp324_;
						ValaSourceReference* _tmp325_;
						ValaSymbol* _tmp326_;
						gchar* _tmp327_;
						gchar* _tmp328_;
						ValaSymbol* _tmp329_;
						const gchar* _tmp330_;
						const gchar* _tmp331_;
						gchar* _tmp332_;
						gchar* _tmp333_;
						_tmp323_ = sym;
						_tmp324_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp323_);
						_tmp325_ = _tmp324_;
						_tmp326_ = sym;
						_tmp327_ = vala_symbol_get_full_name (_tmp326_);
						_tmp328_ = _tmp327_;
						_tmp329_ = prev;
						_tmp330_ = vala_symbol_get_name (_tmp329_);
						_tmp331_ = _tmp330_;
						_tmp332_ = g_strdup_printf ("%s: Duplicate ordering (previous virtual with the same position is %s)", _tmp328_, _tmp331_);
						_tmp333_ = _tmp332_;
						vala_report_error (_tmp325_, _tmp333_);
						_g_free0 (_tmp333_);
						_g_free0 (_tmp328_);
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					}
					_tmp334_ = positions;
					_tmp335_ = sym;
					vala_map_set (_tmp334_, (gpointer) ((gintptr) ordering), _tmp335_);
					_vala_code_node_unref0 (prev);
				}
			}
			_vala_code_node_unref0 (sym);
		}
		_vala_iterable_unref0 (_sym_list);
	}
	if (ordered_seen) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp336_ = FALSE;
				_tmp336_ = TRUE;
				while (TRUE) {
					ValaList* _tmp338_;
					gint _tmp339_;
					gint _tmp340_;
					ValaSymbol* sym = NULL;
					ValaMap* _tmp341_;
					gpointer _tmp342_;
					ValaSymbol* _tmp343_;
					gboolean _tmp350_;
					gboolean _tmp351_;
					if (!_tmp336_) {
						gint _tmp337_;
						_tmp337_ = i;
						i = _tmp337_ + 1;
					}
					_tmp336_ = FALSE;
					_tmp338_ = self->priv->virtuals;
					_tmp339_ = vala_collection_get_size ((ValaCollection*) _tmp338_);
					_tmp340_ = _tmp339_;
					if (!(i < _tmp340_)) {
						break;
					}
					_tmp341_ = positions;
					_tmp342_ = vala_map_get (_tmp341_, (gpointer) ((gintptr) i));
					sym = (ValaSymbol*) _tmp342_;
					_tmp343_ = sym;
					if (_tmp343_ == NULL) {
						ValaSourceReference* _tmp344_;
						ValaSourceReference* _tmp345_;
						gchar* _tmp346_;
						gchar* _tmp347_;
						gchar* _tmp348_;
						gchar* _tmp349_;
						_tmp344_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp345_ = _tmp344_;
						_tmp346_ = vala_symbol_get_full_name ((ValaSymbol*) self);
						_tmp347_ = _tmp346_;
						_tmp348_ = g_strdup_printf ("%s: Gap in ordering in position %d", _tmp347_, i);
						_tmp349_ = _tmp348_;
						vala_report_error (_tmp345_, _tmp349_);
						_g_free0 (_tmp349_);
						_g_free0 (_tmp347_);
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					}
					_tmp350_ = vala_code_node_get_error ((ValaCodeNode*) self);
					_tmp351_ = _tmp350_;
					if (!_tmp351_) {
						ValaList* _tmp352_;
						ValaSymbol* _tmp353_;
						_tmp352_ = self->priv->virtuals;
						_tmp353_ = sym;
						vala_list_set (_tmp352_, i, _tmp353_);
					}
					_vala_code_node_unref0 (sym);
				}
			}
		}
	}
	_tmp354_ = vala_code_context_get_analyzer (context);
	_tmp355_ = _tmp354_;
	_tmp356_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp355_, _tmp356_);
	_tmp357_ = vala_code_context_get_analyzer (context);
	_tmp358_ = _tmp357_;
	_tmp359_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp358_, _tmp359_);
	_tmp360_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp361_ = _tmp360_;
	result = !_tmp361_;
	_vala_map_unref0 (positions);
	_vala_code_node_unref0 (prereq_class);
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}

static void
vala_interface_class_init (ValaInterfaceClass * klass,
                           gpointer klass_data)
{
	vala_interface_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_interface_finalize;
	g_type_class_adjust_private_offset (klass, &ValaInterface_private_offset);
	((ValaSymbolClass *) klass)->add_method = (void (*) (ValaSymbol*, ValaMethod*)) vala_interface_real_add_method;
	((ValaSymbolClass *) klass)->add_property = (void (*) (ValaSymbol*, ValaProperty*)) vala_interface_real_add_property;
	((ValaInterfaceClass *) klass)->get_virtuals = (ValaList* (*) (ValaInterface*)) vala_interface_real_get_virtuals;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_interface_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_interface_real_accept_children;
	((ValaTypeSymbolClass *) klass)->is_reference_type = (gboolean (*) (ValaTypeSymbol*)) vala_interface_real_is_reference_type;
	((ValaTypeSymbolClass *) klass)->is_subtype_of = (gboolean (*) (ValaTypeSymbol*, ValaTypeSymbol*)) vala_interface_real_is_subtype_of;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_interface_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_interface_real_check;
}

static void
vala_interface_instance_init (ValaInterface * self,
                              gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	self->priv = vala_interface_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->prerequisites = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
	self->priv->virtuals = (ValaList*) _tmp3_;
}

static void
vala_interface_finalize (ValaCodeNode * obj)
{
	ValaInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_INTERFACE, ValaInterface);
	_vala_iterable_unref0 (self->priv->prerequisites);
	_vala_iterable_unref0 (self->priv->virtuals);
	VALA_CODE_NODE_CLASS (vala_interface_parent_class)->finalize (obj);
}

/**
 * Represents an interface declaration in the source code.
 */
static GType
vala_interface_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaInterfaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_interface_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaInterface), 0, (GInstanceInitFunc) vala_interface_instance_init, NULL };
	GType vala_interface_type_id;
	vala_interface_type_id = g_type_register_static (VALA_TYPE_OBJECT_TYPE_SYMBOL, "ValaInterface", &g_define_type_info, 0);
	ValaInterface_private_offset = g_type_add_instance_private (vala_interface_type_id, sizeof (ValaInterfacePrivate));
	return vala_interface_type_id;
}

GType
vala_interface_get_type (void)
{
	static volatile gsize vala_interface_type_id__volatile = 0;
	if (g_once_init_enter (&vala_interface_type_id__volatile)) {
		GType vala_interface_type_id;
		vala_interface_type_id = vala_interface_get_type_once ();
		g_once_init_leave (&vala_interface_type_id__volatile, vala_interface_type_id);
	}
	return vala_interface_type_id__volatile;
}

