# NMake Makefile portion for displaying config info

!ifdef INTROSPECTION
BUILD_INTROSPECTION = yes
!else
BUILD_INTROSPECTION = no
!endif

!if "$(CFG)" == "release" || "$(CFG)" == "Release"
BUILD_TYPE = release
!else
BUILD_TYPE = debug
!endif

build-info-amtk:
	@echo.
	@echo =========================
	@echo Configuration for amtk
	@echo =========================
	@echo Build Type: $(BUILD_TYPE)
	@echo.
	@echo.
	@echo Introspection: $(BUILD_INTROSPECTION)

help:
	@echo.
	@echo ============================
	@echo Building amtk Using NMake
	@echo ============================
	@echo nmake /f Makefile.vc CFG=[release^|debug] ^<PREFIX=PATH^> ... OPTION=1 ...
	@echo.
	@echo Where:
	@echo ------
	@echo CFG: Required, use CFG=release for an optimized build and CFG=debug
	@echo for a debug build.  PDB files are generated for all builds.
	@echo.
	@echo PREFIX: Optional, the path where dependent libraries and tools may be
	@echo found, default is ^$(srcrootdir)\..\vs^$(short_vs_ver)\^$(platform),
	@echo where ^$(short_vs_ver) is 9 for VS 2008, 14 for VS 2015 and so on; and
	@echo ^$(platform) is Win32 for 32-bit builds and x64 for x64 builds.
	@echo.
	@echo BINDIR: Optional, the path where dependent external DLL and executables
	@echo may be found, default is ^$(PREFIX)\bin.  Note that for introspection
	@echo builds, dependent .gir and .typelib files are searched first in
	@echo $(BINDIR)\..\share\gir-1.0 and $(BINDIR)\..\lib\girepository-1.0.
	@echo.
	@echo LIBDIR: Optional, the path where dependent external .lib's may be found,
	@echo default is ^$(PREFIX)\lib.  Note that for introspection builds, this
	@echo influences that $(LIBDIR)\pkgconfig will be searched first for pkg-config
	@echo files.
	@echo.
	@echo INCLUDEDIR: Optional, the base path where dependent external headers may
	@echo be found, default is ^$(PREFIX)\include.  Note that headers for GLib, etc,
	@echo will be searched for in ^$(INCLUDEDIR)\glib-2.0 and
	@echo ^$(LIBDIR)\glib-2.0\include.
	@echo.
	@echo PKG_CONFIG_PATH: Full path to pkg-config.exe.  Required if building
	@echo introspection files and if pkg-config.exe is not in your PATH or it
	@echo is called something other than pkg-config.
	@echo.
	@echo GLIB_MKENUMS, G_IR_SCANNER, G_IR_COMPILER: Full path to glib-mkenums,
	@echo g-ir-scanner and g-ir-compiler.exe if any of them are not in ^$(PREFIX)\bin.
	@echo Note that G_IR_SCANNER and G_IR_COMPILER are only used if building
	@echo introspection.
	@echo.
	@echo PYTHON: Full path to your Python interpreter executable.  Required
	@echo if building introspection files or if using the Python version of glib-mkenums
	@echo that is found in newer GLib instead of the former PERL versions,
	@echo and if python.exe is not in your PATH.
	@echo Note that it must be of the same configuration (x86/x64 and Debug/Release)
	@echo and Python release series that was used to build GObject-Introspection
	@echo if building introspection files is desired.  If using
	@echo GObject-Introspection built with Meson, consult the shebang line in
	@echo ^$(G_IR_SCANNER) for determining the correct Python interpreter.
	@echo.
	@echo PERL: Full path to your PERL interpreter executable if it is not in your PATH
	@echo This is required if LEGACY_GLIB_MKENUMS is specified, meaning that an older version
	@echo of glib-mkenums (written in PERL) is used.
	@echo.
	@echo OPTION: Optional, may be any of the following, use OPTION=1 to enable;
	@echo multiple OPTION's may be used.  If no OPTION is specified, a default
	@echo amtk, without the introspection files.
	@echo ======
	@echo.
	@echo INTROSPECTION:
	@echo Enable the build of introspection files requires the GNOME
	@echo gobject-introspection libraries and tools.  Please see the PYTHON section
	@echo above for more details.
	@echo.
	@echo LEGACY_GLIB_MKENUMS:
	@echo Enable this option if using glib-mkenums that is written using PERL, provided
	@echo by older GLib versions.
	@echo.
	@echo LIBTOOL_DLL_NAME:
	@echo Use a libtool-style DLL name to mimic the DLL file naming generated by
	@echo MinGW/autotools builds.  Please note that this does not enable one to use
	@echo this build with MinGW builds.
	@echo ======
	@echo.
	@echo Other options:
	@echo --------------
	@echo LIBINTL_LIB: This defaults to intl.lib, which is the gettext-runtime library
	@echo that we need to link to.  Define this if your gettext-runtime library .lib is
	@echo named differently, such as libintl.lib.
	@echo ======
	@echo.
	@echo A 'clean' target is supported to remove all generated files, intermediate
	@echo object files and binaries for the specified configuration.
	@echo.
	@echo An 'install' target is supported to copy the build (DLLs, utility programs,
	@echo LIBs, along with the introspection files if applicable) to appropriate
	@echo locations under ^$(PREFIX).
	@echo ======
	@echo.
