/* SPDX-License-Identifier: GPL-2.0+ */
/*
 * Copyright 2020-2022 Bootlin
 * Author: Paul Kocialkowski <paul.kocialkowski@bootlin.com>
 */

#ifndef _SUN6I_MIPI_CSI2_REG_H_
#define _SUN6I_MIPI_CSI2_REG_H_

#define SUN6I_MIPI_CSI2_CTL_REG				0x0
#define SUN6I_MIPI_CSI2_CTL_RESET_N			BIT(31)
#define SUN6I_MIPI_CSI2_CTL_VERSION_EN			BIT(30)
#define SUN6I_MIPI_CSI2_CTL_UNPK_EN			BIT(1)
#define SUN6I_MIPI_CSI2_CTL_EN				BIT(0)

#define SUN6I_MIPI_CSI2_CFG_REG				0x4
#define SUN6I_MIPI_CSI2_CFG_CHANNEL_MODE(v)		((((v) - 1) << 8) & \
							 GENMASK(9, 8))
#define SUN6I_MIPI_CSI2_CFG_LANE_COUNT(v)		(((v) - 1) & GENMASK(1, 0))

#define SUN6I_MIPI_CSI2_VCDT_RX_REG			0x8
#define SUN6I_MIPI_CSI2_VCDT_RX_CH_VC(ch, vc)		(((vc) & GENMASK(1, 0)) << \
							 ((ch) * 8 + 6))
#define SUN6I_MIPI_CSI2_VCDT_RX_CH_DT(ch, t)		(((t) & GENMASK(5, 0)) << \
							 ((ch) * 8))
#define SUN6I_MIPI_CSI2_RX_PKT_NUM_REG			0xc

#define SUN6I_MIPI_CSI2_VERSION_REG			0x3c

#define SUN6I_MIPI_CSI2_CH_CFG_REG			0x40
#define SUN6I_MIPI_CSI2_CH_INT_EN_REG			0x50
#define SUN6I_MIPI_CSI2_CH_INT_EN_EOT_ERR		BIT(29)
#define SUN6I_MIPI_CSI2_CH_INT_EN_CHKSUM_ERR		BIT(28)
#define SUN6I_MIPI_CSI2_CH_INT_EN_ECC_WRN		BIT(27)
#define SUN6I_MIPI_CSI2_CH_INT_EN_ECC_ERR		BIT(26)
#define SUN6I_MIPI_CSI2_CH_INT_EN_LINE_SYNC_ERR		BIT(25)
#define SUN6I_MIPI_CSI2_CH_INT_EN_FRAME_SYNC_ERR	BIT(24)
#define SUN6I_MIPI_CSI2_CH_INT_EN_EMB_DATA		BIT(18)
#define SUN6I_MIPI_CSI2_CH_INT_EN_PF			BIT(17)
#define SUN6I_MIPI_CSI2_CH_INT_EN_PH_UPDATE		BIT(16)
#define SUN6I_MIPI_CSI2_CH_INT_EN_LINE_START_SYNC	BIT(11)
#define SUN6I_MIPI_CSI2_CH_INT_EN_LINE_END_SYNC		BIT(10)
#define SUN6I_MIPI_CSI2_CH_INT_EN_FRAME_START_SYNC	BIT(9)
#define SUN6I_MIPI_CSI2_CH_INT_EN_FRAME_END_SYNC	BIT(8)
#define SUN6I_MIPI_CSI2_CH_INT_EN_FIFO_OVER		BIT(0)

#define SUN6I_MIPI_CSI2_CH_INT_PD_REG			0x58
#define SUN6I_MIPI_CSI2_CH_INT_PD_CLEAR			0xff
#define SUN6I_MIPI_CSI2_CH_INT_PD_EOT_ERR		BIT(29)
#define SUN6I_MIPI_CSI2_CH_INT_PD_CHKSUM_ERR		BIT(28)
#define SUN6I_MIPI_CSI2_CH_INT_PD_ECC_WRN		BIT(27)
#define SUN6I_MIPI_CSI2_CH_INT_PD_ECC_ERR		BIT(26)
#define SUN6I_MIPI_CSI2_CH_INT_PD_LINE_SYNC_ERR		BIT(25)
#define SUN6I_MIPI_CSI2_CH_INT_PD_FRAME_SYNC_ERR	BIT(24)
#define SUN6I_MIPI_CSI2_CH_INT_PD_EMB_DATA		BIT(18)
#define SUN6I_MIPI_CSI2_CH_INT_PD_PF			BIT(17)
#define SUN6I_MIPI_CSI2_CH_INT_PD_PH_UPDATE		BIT(16)
#define SUN6I_MIPI_CSI2_CH_INT_PD_LINE_START_SYNC	BIT(11)
#define SUN6I_MIPI_CSI2_CH_INT_PD_LINE_END_SYNC		BIT(10)
#define SUN6I_MIPI_CSI2_CH_INT_PD_FRAME_START_SYNC	BIT(9)
#define SUN6I_MIPI_CSI2_CH_INT_PD_FRAME_END_SYNC	BIT(8)
#define SUN6I_MIPI_CSI2_CH_INT_PD_FIFO_OVER		BIT(0)

#define SUN6I_MIPI_CSI2_CH_DT_TRIGGER_REG		0x60
#define SUN6I_MIPI_CSI2_CH_CUR_PH_REG			0x70
#define SUN6I_MIPI_CSI2_CH_ECC_REG			0x74
#define SUN6I_MIPI_CSI2_CH_CKS_REG			0x78
#define SUN6I_MIPI_CSI2_CH_FRAME_NUM_REG		0x7c
#define SUN6I_MIPI_CSI2_CH_LINE_NUM_REG			0x80

#define SUN6I_MIPI_CSI2_CH_OFFSET			0x100

#define SUN6I_MIPI_CSI2_CH_REG(reg, ch) \
	(SUN6I_MIPI_CSI2_CH_OFFSET * (ch) + (reg))

#endif
