/*****************************************************************************
 * Copyright (c) 2014-2025 OpenRCT2 developers
 *
 * For a complete list of all authors, please refer to contributors.md
 * Interested in contributing? Visit https://github.com/OpenRCT2/OpenRCT2
 *
 * OpenRCT2 is licensed under the GNU General Public License version 3.
 *****************************************************************************/

#include "WoodenRollerCoaster.hpp"

#include "../../../SpriteIds.h"
#include "../../../config/Config.h"
#include "../../../drawing/Drawing.h"
#include "../../../interface/Viewport.h"
#include "../../../ride/RideData.h"
#include "../../../ride/TrackData.h"
#include "../../../ride/TrackPaint.h"
#include "../../../world/tile_element/TrackElement.h"
#include "../../Boundbox.h"
#include "../../Paint.h"
#include "../../support/WoodenSupports.h"
#include "../../tile_element/Paint.Surface.h"
#include "../../tile_element/Paint.TileElement.h"
#include "../../tile_element/Segment.h"
#include "../../track/Segment.h"
#include "../../track/Support.h"

using namespace OpenRCT2;

// static constexpr TunnelGroup kTunnelGroup = TunnelGroup::Square;

enum
{
    SPR_WOODEN_RC_FLAT_TO_LEFT_BANK_SW_NE = 23497,
    SPR_WOODEN_RC_FLAT_TO_LEFT_BANK_NW_SE = 23498,
    SPR_WOODEN_RC_FLAT_TO_LEFT_BANK_NE_SW = 23499,
    SPR_WOODEN_RC_FLAT_TO_LEFT_BANK_SE_NW = 23500,
    SPR_WOODEN_RC_FLAT_TO_RIGHT_BANK_SW_NE = 23501,
    SPR_WOODEN_RC_FLAT_TO_RIGHT_BANK_NW_SE = 23502,
    SPR_WOODEN_RC_FLAT_TO_RIGHT_BANK_NE_SW = 23503,
    SPR_WOODEN_RC_FLAT_TO_RIGHT_BANK_SE_NW = 23504,
    SPR_WOODEN_RC_LEFT_BANK_SW_NE = 23505,
    SPR_WOODEN_RC_LEFT_BANK_NW_SE = 23506,
    SPR_WOODEN_RC_LEFT_BANK_NE_SW = 23507,
    SPR_WOODEN_RC_LEFT_BANK_SE_NW = 23508,
    SPR_WOODEN_RC_25_DEG_TO_LEFT_BANK_SW_NE = 23509,
    SPR_WOODEN_RC_25_DEG_TO_LEFT_BANK_NW_SE = 23510,
    SPR_WOODEN_RC_25_DEG_TO_LEFT_BANK_NE_SW = 23511,
    SPR_WOODEN_RC_25_DEG_TO_LEFT_BANK_SE_NW = 23512,
    SPR_WOODEN_RC_25_DEG_TO_RIGHT_BANK_SW_NE = 23513,
    SPR_WOODEN_RC_25_DEG_TO_RIGHT_BANK_NW_SE = 23514,
    SPR_WOODEN_RC_25_DEG_TO_RIGHT_BANK_NE_SW = 23515,
    SPR_WOODEN_RC_25_DEG_TO_RIGHT_BANK_SE_NW = 23516,
    SPR_WOODEN_RC_LEFT_BANK_TO_25_DEG_SW_NE = 23517,
    SPR_WOODEN_RC_LEFT_BANK_TO_25_DEG_NW_SE = 23518,
    SPR_WOODEN_RC_LEFT_BANK_TO_25_DEG_NE_SW = 23519,
    SPR_WOODEN_RC_LEFT_BANK_TO_25_DEG_SE_NW = 23520,
    SPR_WOODEN_RC_RIGHT_BANK_TO_25_DEG_SW_NE = 23521,
    SPR_WOODEN_RC_RIGHT_BANK_TO_25_DEG_NW_SE = 23522,
    SPR_WOODEN_RC_RIGHT_BANK_TO_25_DEG_NE_SW = 23523,
    SPR_WOODEN_RC_RIGHT_BANK_TO_25_DEG_SE_NW = 23524,
    SPR_WOODEN_RC_FLAT_TO_LEFT_BANK_FRONT_NW_SE = 23525,
    SPR_WOODEN_RC_FLAT_TO_LEFT_BANK_FRONT_SE_NW = 23526,
    SPR_WOODEN_RC_FLAT_TO_RIGHT_BANK_FRONT_NE_SW = 23527,
    SPR_WOODEN_RC_25_DEG_TO_LEFT_BANK_FRONT_NW_SE = 23528,
    SPR_WOODEN_RC_25_DEG_TO_LEFT_BANK_FRONT_NE_SW = 23529,
    SPR_WOODEN_RC_25_DEG_TO_RIGHT_BANK_FRONT_NW_SE = 23530,
    SPR_WOODEN_RC_25_DEG_TO_RIGHT_BANK_FRONT_NE_SW = 23531,
    SPR_WOODEN_RC_LEFT_BANK_TO_25_DEG_FRONT_NW_SE = 23532,
    SPR_WOODEN_RC_LEFT_BANK_TO_25_DEG_FRONT_NE_SW = 23533,
    SPR_WOODEN_RC_RIGHT_BANK_TO_25_DEG_FRONT_NW_SE = 23534,
    SPR_WOODEN_RC_RIGHT_BANK_TO_25_DEG_FRONT_NE_SW = 23535,
    SPR_WOODEN_RC_FLAT_TO_RIGHT_BANK_FRONT_SW_NE = 23536,
    SPR_WOODEN_RC_FLAT_TO_25_DEG_SW_NE = 23537,
    SPR_WOODEN_RC_FLAT_TO_25_DEG_NW_SE = 23538,
    SPR_WOODEN_RC_FLAT_TO_25_DEG_NE_SW = 23539,
    SPR_WOODEN_RC_FLAT_TO_25_DEG_SE_NW = 23540,
    SPR_WOODEN_RC_25_DEG_TO_FLAT_SW_NE = 23541,
    SPR_WOODEN_RC_25_DEG_TO_FLAT_NW_SE = 23542,
    SPR_WOODEN_RC_25_DEG_TO_FLAT_NE_SW = 23543,
    SPR_WOODEN_RC_25_DEG_TO_FLAT_SE_NW = 23544,
    SPR_WOODEN_RC_25_DEG_SW_NE = 23545,
    SPR_WOODEN_RC_25_DEG_NW_SE = 23546,
    SPR_WOODEN_RC_25_DEG_NE_SW = 23547,
    SPR_WOODEN_RC_25_DEG_SE_NW = 23548,
    SPR_WOODEN_RC_25_DEG_TO_60_DEG_SW_NE = 23549,
    SPR_WOODEN_RC_25_DEG_TO_60_DEG_FRONT_NW_SE = 23550,
    SPR_WOODEN_RC_25_DEG_TO_60_DEG_NW_SE = 23551,
    SPR_WOODEN_RC_25_DEG_TO_60_DEG_FRONT_NE_SW = 23552,
    SPR_WOODEN_RC_25_DEG_TO_60_DEG_NE_SW = 23553,
    SPR_WOODEN_RC_25_DEG_TO_60_DEG_SE_NW = 23554,
    SPR_WOODEN_RC_60_DEG_TO_25_DEG_SW_NE = 23555,
    SPR_WOODEN_RC_60_DEG_TO_25_DEG_FRONT_NW_SE = 23556,
    SPR_WOODEN_RC_60_DEG_TO_25_DEG_NW_SE = 23557,
    SPR_WOODEN_RC_60_DEG_TO_25_DEG_FRONT_NE_SW = 23558,
    SPR_WOODEN_RC_60_DEG_TO_25_DEG_NE_SW = 23559,
    SPR_WOODEN_RC_60_DEG_TO_25_DEG_SE_NW = 23560,
    SPR_WOODEN_RC_60_DEG_SW_NE = 23561,
    SPR_WOODEN_RC_60_DEG_CHAIN_SW_NE = 23561,
    SPR_WOODEN_RC_60_DEG_NW_SE = 23562,
    SPR_WOODEN_RC_60_DEG_CHAIN_NW_SE = 23562,
    SPR_WOODEN_RC_60_DEG_NE_SW = 23563,
    SPR_WOODEN_RC_60_DEG_CHAIN_NE_SW = 23563,
    SPR_WOODEN_RC_60_DEG_SE_NW = 23564,
    SPR_WOODEN_RC_60_DEG_CHAIN_SE_NW = 23564,
    SPR_WOODEN_RC_FLAT_TO_25_DEG_FRONT_NW_SE = 23565,
    SPR_WOODEN_RC_FLAT_TO_25_DEG_FRONT_NE_SW = 23566,
    SPR_WOODEN_RC_25_DEG_TO_FLAT_FRONT_NW_SE = 23567,
    SPR_WOODEN_RC_25_DEG_TO_FLAT_FRONT_NE_SW = 23568,
    SPR_WOODEN_RC_25_DEG_FRONT_NW_SE = 23569,
    SPR_WOODEN_RC_60_DEG_FRONT_NW_SE = 23569,
    SPR_WOODEN_RC_25_DEG_FRONT_NE_SW = 23570,
    SPR_WOODEN_RC_60_DEG_FRONT_NE_SW = 23570,
    SPR_WOODEN_RC_FLAT_TO_25_DEG_CHAIN_SW_NE = 23571,
    SPR_WOODEN_RC_FLAT_TO_25_DEG_CHAIN_NW_SE = 23572,
    SPR_WOODEN_RC_FLAT_TO_25_DEG_CHAIN_NE_SW = 23573,
    SPR_WOODEN_RC_FLAT_TO_25_DEG_CHAIN_SE_NW = 23574,
    SPR_WOODEN_RC_25_DEG_TO_FLAT_CHAIN_SW_NE = 23575,
    SPR_WOODEN_RC_25_DEG_TO_FLAT_CHAIN_NW_SE = 23576,
    SPR_WOODEN_RC_25_DEG_TO_FLAT_CHAIN_NE_SW = 23577,
    SPR_WOODEN_RC_25_DEG_TO_FLAT_CHAIN_SE_NW = 23578,
    SPR_WOODEN_RC_25_DEG_CHAIN_SW_NE = 23579,
    SPR_WOODEN_RC_25_DEG_CHAIN_NW_SE = 23580,
    SPR_WOODEN_RC_25_DEG_CHAIN_NE_SW = 23581,
    SPR_WOODEN_RC_25_DEG_CHAIN_SE_NW = 23582,

    SPR_WOODEN_RC_FLAT_TO_25_DEG_CHAIN_FRONT_NW_SE = 23599,
    SPR_WOODEN_RC_FLAT_TO_25_DEG_CHAIN_FRONT_NE_SW = 23600,
    SPR_WOODEN_RC_25_DEG_TO_FLAT_CHAIN_FRONT_NW_SE = 23601,
    SPR_WOODEN_RC_25_DEG_TO_FLAT_CHAIN_FRONT_NE_SW = 23602,
    SPR_WOODEN_RC_25_DEG_CHAIN_FRONT_NW_SE = 23603,
    SPR_WOODEN_RC_60_DEG_CHAIN_FRONT_NW_SE = 23603,
    SPR_WOODEN_RC_25_DEG_CHAIN_FRONT_NE_SW = 23604,
    SPR_WOODEN_RC_60_DEG_CHAIN_FRONT_NE_SW = 23604,
    SPR_WOODEN_RC_QUARTER_TURN_5_SW_SE_SEQ_0 = 23605,
    SPR_WOODEN_RC_QUARTER_TURN_5_SW_SE_SEQ_2 = 23606,
    SPR_WOODEN_RC_QUARTER_TURN_5_SW_SE_SEQ_3 = 23607,
    SPR_WOODEN_RC_QUARTER_TURN_5_SW_SE_SEQ_5 = 23608,
    SPR_WOODEN_RC_QUARTER_TURN_5_SW_SE_SEQ_6 = 23609,
    SPR_WOODEN_RC_QUARTER_TURN_5_NW_SW_SEQ_0 = 23610,
    SPR_WOODEN_RC_QUARTER_TURN_5_NW_SW_SEQ_2 = 23611,
    SPR_WOODEN_RC_QUARTER_TURN_5_NW_SW_SEQ_3 = 23612,
    SPR_WOODEN_RC_QUARTER_TURN_5_NW_SW_SEQ_5 = 23613,
    SPR_WOODEN_RC_QUARTER_TURN_5_NW_SW_SEQ_6 = 23614,
    SPR_WOODEN_RC_QUARTER_TURN_5_NE_NW_SEQ_0 = 23615,
    SPR_WOODEN_RC_QUARTER_TURN_5_NE_NW_SEQ_2 = 23616,
    SPR_WOODEN_RC_QUARTER_TURN_5_NE_NW_SEQ_3 = 23617,
    SPR_WOODEN_RC_QUARTER_TURN_5_NE_NW_SEQ_5 = 23618,
    SPR_WOODEN_RC_QUARTER_TURN_5_NE_NW_SEQ_6 = 23619,
    SPR_WOODEN_RC_QUARTER_TURN_5_SE_NE_SEQ_0 = 23620,
    SPR_WOODEN_RC_QUARTER_TURN_5_SE_NE_SEQ_2 = 23621,
    SPR_WOODEN_RC_QUARTER_TURN_5_SE_NE_SEQ_3 = 23622,
    SPR_WOODEN_RC_QUARTER_TURN_5_SE_NE_SEQ_5 = 23623,
    SPR_WOODEN_RC_QUARTER_TURN_5_SE_NE_SEQ_6 = 23624,
    SPR_WOODEN_RC_QUARTER_TURN_5_FRONT_SW_SE_SEQ_0 = 23625,
    SPR_WOODEN_RC_QUARTER_TURN_5_FRONT_SW_SE_SEQ_2 = 23626,
    SPR_WOODEN_RC_QUARTER_TURN_5_FRONT_SW_SE_SEQ_3 = 23627,
    SPR_WOODEN_RC_QUARTER_TURN_5_FRONT_SW_SE_SEQ_5 = 23628,
    SPR_WOODEN_RC_QUARTER_TURN_5_FRONT_SW_SE_SEQ_6 = 23629,
    SPR_WOODEN_RC_QUARTER_TURN_5_FRONT_NE_NW_SEQ_0 = 23630,
    SPR_WOODEN_RC_QUARTER_TURN_5_FRONT_NE_NW_SEQ_2 = 23631,
    SPR_WOODEN_RC_QUARTER_TURN_5_FRONT_NE_NW_SEQ_3 = 23632,
    SPR_WOODEN_RC_QUARTER_TURN_5_FRONT_NE_NW_SEQ_5 = 23633,
    SPR_WOODEN_RC_QUARTER_TURN_5_FRONT_NE_NW_SEQ_6 = 23634,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_SW_SE_SEQ_0 = 23635,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_SW_SE_SEQ_2 = 23636,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_SW_SE_SEQ_3 = 23637,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_SW_SE_SEQ_5 = 23638,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_SW_SE_SEQ_6 = 23639,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_NW_SW_SEQ_0 = 23640,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_NW_SW_SEQ_2 = 23641,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_NW_SW_SEQ_3 = 23642,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_NW_SW_SEQ_5 = 23643,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_NW_SW_SEQ_6 = 23644,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_NE_NW_SEQ_0 = 23645,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_NE_NW_SEQ_2 = 23646,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_NE_NW_SEQ_3 = 23647,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_NE_NW_SEQ_5 = 23648,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_NE_NW_SEQ_6 = 23649,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_SE_NE_SEQ_0 = 23650,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_SE_NE_SEQ_2 = 23651,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_SE_NE_SEQ_3 = 23652,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_SE_NE_SEQ_5 = 23653,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_SE_NE_SEQ_6 = 23654,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_FRONT_SW_SE_SEQ_0 = 23655,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_FRONT_SW_SE_SEQ_2 = 23656,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_FRONT_SW_SE_SEQ_3 = 23657,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_FRONT_SW_SE_SEQ_5 = 23658,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_FRONT_SW_SE_SEQ_6 = 23659,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_FRONT_NE_NW_SEQ_0 = 23660,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_FRONT_NE_NW_SEQ_2 = 23661,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_FRONT_NE_NW_SEQ_3 = 23662,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_FRONT_NE_NW_SEQ_5 = 23663,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_FRONT_NE_NW_SEQ_6 = 23664,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_0_0 = 23665,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_1_0 = 23666,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_2_0 = 23667,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_3_0 = 23668,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_4_0 = 23669,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_0_1 = 23670,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_1_1 = 23671,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_2_1 = 23672,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_3_1 = 23673,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_4_1 = 23674,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_0_2 = 23675,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_1_2 = 23676,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_2_2 = 23677,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_3_2 = 23678,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_4_2 = 23679,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_0_3 = 23680,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_1_3 = 23681,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_2_3 = 23682,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_3_3 = 23683,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_4_3 = 23684,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_FRONT_0_0 = 23685,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_FRONT_1_0 = 23686,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_FRONT_2_0 = 23687,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_FRONT_3_0 = 23688,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_FRONT_4_0 = 23689,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_FRONT_0_2 = 23690,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_FRONT_1_2 = 23691,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_FRONT_2_2 = 23692,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_FRONT_3_2 = 23693,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_FRONT_4_2 = 23694,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_4_3 = 23695,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_3_3 = 23696,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_2_3 = 23697,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_1_3 = 23698,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_0_3 = 23699,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_4_0 = 23700,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_3_0 = 23701,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_2_0 = 23702,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_1_0 = 23703,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_0_0 = 23704,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_4_1 = 23705,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_3_1 = 23706,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_2_1 = 23707,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_1_1 = 23708,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_0_1 = 23709,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_4_2 = 23710,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_3_2 = 23711,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_2_2 = 23712,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_1_2 = 23713,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_0_2 = 23714,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_FRONT_4_3 = 23715,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_FRONT_3_3 = 23716,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_FRONT_2_3 = 23717,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_FRONT_1_3 = 23718,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_FRONT_0_3 = 23719,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_FRONT_4_1 = 23720,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_FRONT_3_1 = 23721,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_FRONT_2_1 = 23722,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_FRONT_1_1 = 23723,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_FRONT_0_1 = 23724,

    SPR_WOODEN_RC_FLAT_CHAIN_SW_NE = 23749,
    SPR_WOODEN_RC_FLAT_CHAIN_NW_SE = 23750,
    SPR_WOODEN_RC_FLAT_CHAIN_NE_SW = 23751,
    SPR_WOODEN_RC_FLAT_CHAIN_SE_NW = 23752,
    SPR_WOODEN_RC_FLAT_SW_NE = 23753,
    SPR_WOODEN_RC_FLAT_NW_SE = 23754,
    SPR_WOODEN_RC_BRAKES_SW_NE = 23755,
    SPR_WOODEN_RC_BRAKES_NW_SE = 23756,
    SPR_WOODEN_RC_BLOCK_BRAKES_SW_NE_OPEN = 23757,
    SPR_WOODEN_RC_BLOCK_BRAKES_NW_SE_OPEN = 23758,
    SPR_WOODEN_RC_BLOCK_BRAKES_SW_NE_CLOSED = 23759,
    SPR_WOODEN_RC_BLOCK_BRAKES_NW_SE_CLOSED = 23760,

    SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_2_3 = 23841,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_1_3 = 23842,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_0_3 = 23843,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_2_0 = 23844,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_1_0 = 23845,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_0_0 = 23846,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_2_1 = 23847,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_1_1 = 23848,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_0_1 = 23849,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_2_2 = 23850,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_1_2 = 23851,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_0_2 = 23852,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_FRONT_2_3 = 23853,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_FRONT_1_3 = 23854,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_FRONT_0_3 = 23855,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_FRONT_2_1 = 23856,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_FRONT_1_1 = 23857,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_FRONT_0_1 = 23858,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_0_0 = 23859,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_1_0 = 23860,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_2_0 = 23861,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_0_1 = 23862,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_1_1 = 23863,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_2_1 = 23864,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_0_2 = 23865,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_1_2 = 23866,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_2_2 = 23867,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_0_3 = 23868,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_1_3 = 23869,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_2_3 = 23870,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_FRONT_0_0 = 23871,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_FRONT_1_0 = 23872,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_FRONT_2_0 = 23873,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_FRONT_0_2 = 23874,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_FRONT_1_2 = 23875,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_FRONT_2_2 = 23876,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_2_3 = 23877,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_1_3 = 23878,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_0_3 = 23879,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_2_0 = 23880,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_1_0 = 23881,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_0_0 = 23882,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_2_1 = 23883,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_1_1 = 23884,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_0_1 = 23885,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_2_2 = 23886,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_1_2 = 23887,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_0_2 = 23888,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_FRONT_2_3 = 23889,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_FRONT_1_3 = 23890,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_FRONT_0_3 = 23891,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_FRONT_2_1 = 23892,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_FRONT_1_1 = 23893,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_FRONT_0_1 = 23894,

    SPR_WOODEN_RC_RIGHT_BANK_TO_RIGHT_QUARTER_TURN_3_25_DEG_UP_0_0 = 23947,
    SPR_WOODEN_RC_RIGHT_BANK_TO_RIGHT_QUARTER_TURN_3_25_DEG_UP_1_0 = 23948,
    SPR_WOODEN_RC_RIGHT_BANK_TO_RIGHT_QUARTER_TURN_3_25_DEG_UP_0_1 = 23949,
    SPR_WOODEN_RC_RIGHT_BANK_TO_RIGHT_QUARTER_TURN_3_25_DEG_UP_1_1 = 23950,
    SPR_WOODEN_RC_RIGHT_BANK_TO_RIGHT_QUARTER_TURN_3_25_DEG_UP_0_2 = 23951,
    SPR_WOODEN_RC_RIGHT_BANK_TO_RIGHT_QUARTER_TURN_3_25_DEG_UP_1_2 = 23952,
    SPR_WOODEN_RC_RIGHT_BANK_TO_RIGHT_QUARTER_TURN_3_25_DEG_UP_0_3 = 23953,
    SPR_WOODEN_RC_RIGHT_BANK_TO_RIGHT_QUARTER_TURN_3_25_DEG_UP_1_3 = 23954,
    SPR_WOODEN_RC_LEFT_BANK_TO_LEFT_QUARTER_TURN_3_25_DEG_UP_1_3 = 23955,
    SPR_WOODEN_RC_LEFT_BANK_TO_LEFT_QUARTER_TURN_3_25_DEG_UP_0_3 = 23956,
    SPR_WOODEN_RC_LEFT_BANK_TO_LEFT_QUARTER_TURN_3_25_DEG_UP_1_0 = 23957,
    SPR_WOODEN_RC_LEFT_BANK_TO_LEFT_QUARTER_TURN_3_25_DEG_UP_0_0 = 23958,
    SPR_WOODEN_RC_LEFT_BANK_TO_LEFT_QUARTER_TURN_3_25_DEG_UP_1_1 = 23959,
    SPR_WOODEN_RC_LEFT_BANK_TO_LEFT_QUARTER_TURN_3_25_DEG_UP_0_1 = 23960,
    SPR_WOODEN_RC_LEFT_BANK_TO_LEFT_QUARTER_TURN_3_25_DEG_UP_1_2 = 23961,
    SPR_WOODEN_RC_LEFT_BANK_TO_LEFT_QUARTER_TURN_3_25_DEG_UP_0_2 = 23962,
    SPR_WOODEN_RC_RIGHT_BANK_TO_RIGHT_QUARTER_TURN_3_25_DEG_UP_FRONT_0_0 = 23963,
    SPR_WOODEN_RC_RIGHT_BANK_TO_RIGHT_QUARTER_TURN_3_25_DEG_UP_FRONT_1_0 = 23964,
    SPR_WOODEN_RC_RIGHT_BANK_TO_RIGHT_QUARTER_TURN_3_25_DEG_UP_FRONT_1_1 = 23965,
    SPR_WOODEN_RC_RIGHT_BANK_TO_RIGHT_QUARTER_TURN_3_25_DEG_UP_FRONT_0_2 = 23966,
    SPR_WOODEN_RC_RIGHT_BANK_TO_RIGHT_QUARTER_TURN_3_25_DEG_UP_FRONT_1_2 = 23967,
    SPR_WOODEN_RC_LEFT_BANK_TO_LEFT_QUARTER_TURN_3_25_DEG_UP_FRONT_1_3 = 23968,
    SPR_WOODEN_RC_LEFT_BANK_TO_LEFT_QUARTER_TURN_3_25_DEG_UP_FRONT_0_3 = 23969,
    SPR_WOODEN_RC_LEFT_BANK_TO_LEFT_QUARTER_TURN_3_25_DEG_UP_FRONT_1_1 = 23970,
    SPR_WOODEN_RC_LEFT_BANK_TO_LEFT_QUARTER_TURN_3_25_DEG_UP_FRONT_0_1 = 23971,
    SPR_WOODEN_RC_LEFT_BANK_TO_LEFT_QUARTER_TURN_3_25_DEG_UP_FRONT_1_2 = 23972,

    SPR_WOODEN_RC_STATION_SW_NE = 23973,
    SPR_WOODEN_RC_STATION_NW_SE = 23974,

    SPR_WOODEN_RC_DIAG_FLAT_TO_LEFT_BANK_0 = 24077,
    SPR_WOODEN_RC_DIAG_FLAT_TO_LEFT_BANK_1 = 24078,
    SPR_WOODEN_RC_DIAG_FLAT_TO_LEFT_BANK_2 = 24079,
    SPR_WOODEN_RC_DIAG_FLAT_TO_LEFT_BANK_3 = 24080,
    SPR_WOODEN_RC_DIAG_FLAT_TO_LEFT_BANK_FRONT_0 = 24081,
    SPR_WOODEN_RC_DIAG_FLAT_TO_LEFT_BANK_FRONT_2 = 24082,
    SPR_WOODEN_RC_DIAG_FLAT_TO_RIGHT_BANK_0 = 24083,
    SPR_WOODEN_RC_DIAG_FLAT_TO_RIGHT_BANK_1 = 24084,
    SPR_WOODEN_RC_DIAG_FLAT_TO_RIGHT_BANK_2 = 24085,
    SPR_WOODEN_RC_DIAG_FLAT_TO_RIGHT_BANK_3 = 24086,
    SPR_WOODEN_RC_DIAG_FLAT_TO_RIGHT_BANK_FRONT_0 = 24087,
    SPR_WOODEN_RC_DIAG_FLAT_TO_RIGHT_BANK_FRONT_2 = 24088,
    SPR_WOODEN_RC_DIAG_UP_25_TO_LEFT_BANK_0 = 24089,
    SPR_WOODEN_RC_DIAG_UP_25_TO_LEFT_BANK_1 = 24090,
    SPR_WOODEN_RC_DIAG_UP_25_TO_LEFT_BANK_2 = 24091,
    SPR_WOODEN_RC_DIAG_UP_25_TO_LEFT_BANK_3 = 24092,
    SPR_WOODEN_RC_DIAG_UP_25_TO_LEFT_BANK_FRONT_0 = 24093,
    SPR_WOODEN_RC_DIAG_UP_25_TO_LEFT_BANK_FRONT_2 = 24094,
    SPR_WOODEN_RC_DIAG_UP_25_TO_RIGHT_BANK_0 = 24095,
    SPR_WOODEN_RC_DIAG_UP_25_TO_RIGHT_BANK_1 = 24096,
    SPR_WOODEN_RC_DIAG_UP_25_TO_RIGHT_BANK_2 = 24097,
    SPR_WOODEN_RC_DIAG_UP_25_TO_RIGHT_BANK_3 = 24098,
    SPR_WOODEN_RC_DIAG_UP_25_TO_RIGHT_BANK_FRONT_0 = 24099,
    SPR_WOODEN_RC_DIAG_UP_25_TO_RIGHT_BANK_FRONT_2 = 24100,
    SPR_WOODEN_RC_DIAG_LEFT_BANK_TO_25_DEG_UP_0 = 24101,
    SPR_WOODEN_RC_DIAG_LEFT_BANK_TO_25_DEG_UP_1 = 24102,
    SPR_WOODEN_RC_DIAG_LEFT_BANK_TO_25_DEG_UP_2 = 24103,
    SPR_WOODEN_RC_DIAG_LEFT_BANK_TO_25_DEG_UP_3 = 24104,
    SPR_WOODEN_RC_DIAG_LEFT_BANK_TO_25_DEG_UP_FRONT_0 = 24105,
    SPR_WOODEN_RC_DIAG_LEFT_BANK_TO_25_DEG_UP_FRONT_2 = 24106,
    SPR_WOODEN_RC_DIAG_RIGHT_BANK_TO_25_DEG_UP_0 = 24107,
    SPR_WOODEN_RC_DIAG_RIGHT_BANK_TO_25_DEG_UP_1 = 24108,
    SPR_WOODEN_RC_DIAG_RIGHT_BANK_TO_25_DEG_UP_2 = 24109,
    SPR_WOODEN_RC_DIAG_RIGHT_BANK_TO_25_DEG_UP_3 = 24110,
    SPR_WOODEN_RC_DIAG_RIGHT_BANK_TO_25_DEG_UP_FRONT_0 = 24111,
    SPR_WOODEN_RC_DIAG_RIGHT_BANK_TO_25_DEG_UP_FRONT_2 = 24112,

    SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_0_0 = 24161,
    SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_1_0 = 24162,
    SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_2_0 = 24163,
    SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_3_0 = 24164,
    SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_0_1 = 24165,
    SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_1_1 = 24166,
    SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_2_1 = 24167,
    SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_3_1 = 24168,
    SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_0_2 = 24169,
    SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_1_2 = 24170,
    SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_2_2 = 24171,
    SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_3_2 = 24172,
    SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_0_3 = 24173,
    SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_1_3 = 24174,
    SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_2_3 = 24175,
    SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_3_3 = 24176,
    SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_FRONT_0_0 = 24177,
    SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_FRONT_1_0 = 24178,
    SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_FRONT_2_0 = 24179,
    SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_FRONT_3_0 = 24180,
    SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_FRONT_0_2 = 24181,
    SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_FRONT_1_2 = 24182,
    SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_FRONT_2_2 = 24183,
    SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_FRONT_3_2 = 24184,
    SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_0_0 = 24185,
    SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_1_0 = 24186,
    SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_2_0 = 24187,
    SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_3_0 = 24188,
    SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_0_1 = 24189,
    SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_1_1 = 24190,
    SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_2_1 = 24191,
    SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_3_1 = 24192,
    SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_0_2 = 24193,
    SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_1_2 = 24194,
    SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_2_2 = 24195,
    SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_3_2 = 24196,
    SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_0_3 = 24197,
    SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_1_3 = 24198,
    SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_2_3 = 24199,
    SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_3_3 = 24200,
    SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_FRONT_0_1 = 24201,
    SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_FRONT_1_1 = 24202,
    SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_FRONT_2_1 = 24203,
    SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_FRONT_3_1 = 24204,
    SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_FRONT_0_3 = 24205,
    SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_FRONT_1_3 = 24206,
    SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_FRONT_2_3 = 24207,
    SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_FRONT_3_3 = 24208,

    SPR_WOODEN_RC_FLAT_TO_LEFT_BANK_RAILS_SW_NE = 24363,
    SPR_WOODEN_RC_FLAT_TO_LEFT_BANK_RAILS_NW_SE = 24364,
    SPR_WOODEN_RC_FLAT_TO_LEFT_BANK_RAILS_NE_SW = 24365,
    SPR_WOODEN_RC_FLAT_TO_LEFT_BANK_RAILS_SE_NW = 24366,
    SPR_WOODEN_RC_FLAT_TO_RIGHT_BANK_RAILS_SW_NE = 24367,
    SPR_WOODEN_RC_FLAT_TO_RIGHT_BANK_RAILS_NW_SE = 24368,
    SPR_WOODEN_RC_FLAT_TO_RIGHT_BANK_RAILS_NE_SW = 24369,
    SPR_WOODEN_RC_FLAT_TO_RIGHT_BANK_RAILS_SE_NW = 24370,
    SPR_WOODEN_RC_LEFT_BANK_RAILS_SW_NE = 24371,
    SPR_WOODEN_RC_LEFT_BANK_RAILS_NW_SE = 24372,
    SPR_WOODEN_RC_LEFT_BANK_RAILS_NE_SW = 24373,
    SPR_WOODEN_RC_LEFT_BANK_RAILS_SE_NW = 24374,
    SPR_WOODEN_RC_25_DEG_TO_LEFT_BANK_RAILS_SW_NE = 24375,
    SPR_WOODEN_RC_25_DEG_TO_LEFT_BANK_RAILS_NW_SE = 24376,
    SPR_WOODEN_RC_25_DEG_TO_LEFT_BANK_RAILS_NE_SW = 24377,
    SPR_WOODEN_RC_25_DEG_TO_LEFT_BANK_RAILS_SE_NW = 24378,
    SPR_WOODEN_RC_25_DEG_TO_RIGHT_BANK_RAILS_SW_NE = 24379,
    SPR_WOODEN_RC_25_DEG_TO_RIGHT_BANK_RAILS_NW_SE = 24380,
    SPR_WOODEN_RC_25_DEG_TO_RIGHT_BANK_RAILS_NE_SW = 24381,
    SPR_WOODEN_RC_25_DEG_TO_RIGHT_BANK_RAILS_SE_NW = 24382,
    SPR_WOODEN_RC_LEFT_BANK_TO_25_DEG_RAILS_SW_NE = 24383,
    SPR_WOODEN_RC_LEFT_BANK_TO_25_DEG_RAILS_NW_SE = 24384,
    SPR_WOODEN_RC_LEFT_BANK_TO_25_DEG_RAILS_NE_SW = 24385,
    SPR_WOODEN_RC_LEFT_BANK_TO_25_DEG_RAILS_SE_NW = 24386,
    SPR_WOODEN_RC_RIGHT_BANK_TO_25_DEG_RAILS_SW_NE = 24387,
    SPR_WOODEN_RC_RIGHT_BANK_TO_25_DEG_RAILS_NW_SE = 24388,
    SPR_WOODEN_RC_RIGHT_BANK_TO_25_DEG_RAILS_NE_SW = 24389,
    SPR_WOODEN_RC_RIGHT_BANK_TO_25_DEG_RAILS_SE_NW = 24390,
    SPR_WOODEN_RC_FLAT_TO_LEFT_BANK_RAILS_FRONT_NW_SE = 24391,
    SPR_WOODEN_RC_FLAT_TO_LEFT_BANK_RAILS_FRONT_SE_NW = 24392,
    SPR_WOODEN_RC_FLAT_TO_RIGHT_BANK_RAILS_FRONT_NE_SW = 24393,
    SPR_WOODEN_RC_25_DEG_TO_LEFT_BANK_RAILS_FRONT_NW_SE = 24394,
    SPR_WOODEN_RC_25_DEG_TO_LEFT_BANK_RAILS_FRONT_NE_SW = 24395,
    SPR_WOODEN_RC_25_DEG_TO_RIGHT_BANK_RAILS_FRONT_NW_SE = 24396,
    SPR_WOODEN_RC_25_DEG_TO_RIGHT_BANK_RAILS_FRONT_NE_SW = 24397,
    SPR_WOODEN_RC_LEFT_BANK_TO_25_DEG_RAILS_FRONT_NW_SE = 24398,
    SPR_WOODEN_RC_LEFT_BANK_TO_25_DEG_RAILS_FRONT_NE_SW = 24399,
    SPR_WOODEN_RC_RIGHT_BANK_TO_25_DEG_RAILS_FRONT_NW_SE = 24400,
    SPR_WOODEN_RC_RIGHT_BANK_TO_25_DEG_RAILS_FRONT_NE_SW = 24401,
    SPR_WOODEN_RC_FLAT_TO_RIGHT_BANK_RAILS_FRONT_SW_NE = 24402,
    SPR_WOODEN_RC_FLAT_TO_25_DEG_RAILS_SW_NE = 24403,
    SPR_WOODEN_RC_FLAT_TO_25_DEG_RAILS_NW_SE = 24404,
    SPR_WOODEN_RC_FLAT_TO_25_DEG_RAILS_NE_SW = 24405,
    SPR_WOODEN_RC_FLAT_TO_25_DEG_RAILS_SE_NW = 24406,
    SPR_WOODEN_RC_25_DEG_TO_FLAT_RAILS_SW_NE = 24407,
    SPR_WOODEN_RC_25_DEG_TO_FLAT_RAILS_NW_SE = 24408,
    SPR_WOODEN_RC_25_DEG_TO_FLAT_RAILS_NE_SW = 24409,
    SPR_WOODEN_RC_25_DEG_TO_FLAT_RAILS_SE_NW = 24410,
    SPR_WOODEN_RC_25_DEG_RAILS_SW_NE = 24411,
    SPR_WOODEN_RC_25_DEG_RAILS_NW_SE = 24412,
    SPR_WOODEN_RC_25_DEG_RAILS_NE_SW = 24413,
    SPR_WOODEN_RC_25_DEG_RAILS_SE_NW = 24414,
    SPR_WOODEN_RC_25_DEG_TO_60_DEG_RAILS_SW_NE = 24415,
    SPR_WOODEN_RC_25_DEG_TO_60_DEG_RAILS_FRONT_NW_SE = 24416,
    SPR_WOODEN_RC_25_DEG_TO_60_DEG_RAILS_NW_SE = 24417,
    SPR_WOODEN_RC_25_DEG_TO_60_DEG_RAILS_FRONT_NE_SW = 24418,
    SPR_WOODEN_RC_25_DEG_TO_60_DEG_RAILS_NE_SW = 24419,
    SPR_WOODEN_RC_25_DEG_TO_60_DEG_RAILS_SE_NW = 24420,
    SPR_WOODEN_RC_60_DEG_TO_25_DEG_RAILS_SW_NE = 24421,
    SPR_WOODEN_RC_60_DEG_TO_25_DEG_RAILS_FRONT_NW_SE = 24422,
    SPR_WOODEN_RC_60_DEG_TO_25_DEG_RAILS_NW_SE = 24423,
    SPR_WOODEN_RC_60_DEG_TO_25_DEG_RAILS_FRONT_NE_SW = 24424,
    SPR_WOODEN_RC_60_DEG_TO_25_DEG_RAILS_NE_SW = 24425,
    SPR_WOODEN_RC_60_DEG_TO_25_DEG_RAILS_SE_NW = 24426,
    SPR_WOODEN_RC_60_DEG_RAILS_SW_NE = 24427,
    SPR_WOODEN_RC_60_DEG_CHAIN_RAILS_SW_NE = 24427,
    SPR_WOODEN_RC_60_DEG_RAILS_NW_SE = 24428,
    SPR_WOODEN_RC_60_DEG_CHAIN_RAILS_NW_SE = 24428,
    SPR_WOODEN_RC_60_DEG_RAILS_NE_SW = 24429,
    SPR_WOODEN_RC_60_DEG_CHAIN_RAILS_NE_SW = 24429,
    SPR_WOODEN_RC_60_DEG_RAILS_SE_NW = 24430,
    SPR_WOODEN_RC_60_DEG_CHAIN_RAILS_SE_NW = 24430,
    SPR_WOODEN_RC_FLAT_TO_25_DEG_RAILS_FRONT_NW_SE = 24431,
    SPR_WOODEN_RC_FLAT_TO_25_DEG_RAILS_FRONT_NE_SW = 24432,
    SPR_WOODEN_RC_25_DEG_TO_FLAT_RAILS_FRONT_NW_SE = 24433,
    SPR_WOODEN_RC_25_DEG_TO_FLAT_RAILS_FRONT_NE_SW = 24434,
    SPR_WOODEN_RC_25_DEG_RAILS_FRONT_NW_SE = 24435,
    SPR_WOODEN_RC_60_DEG_RAILS_FRONT_NW_SE = 24435,
    SPR_WOODEN_RC_25_DEG_RAILS_FRONT_NE_SW = 24436,
    SPR_WOODEN_RC_60_DEG_RAILS_FRONT_NE_SW = 24436,
    SPR_WOODEN_RC_FLAT_TO_25_DEG_CHAIN_RAILS_SW_NE = 24437,
    SPR_WOODEN_RC_FLAT_TO_25_DEG_CHAIN_RAILS_NW_SE = 24438,
    SPR_WOODEN_RC_FLAT_TO_25_DEG_CHAIN_RAILS_NE_SW = 24439,
    SPR_WOODEN_RC_FLAT_TO_25_DEG_CHAIN_RAILS_SE_NW = 24440,
    SPR_WOODEN_RC_25_DEG_TO_FLAT_CHAIN_RAILS_SW_NE = 24441,
    SPR_WOODEN_RC_25_DEG_TO_FLAT_CHAIN_RAILS_NW_SE = 24442,
    SPR_WOODEN_RC_25_DEG_TO_FLAT_CHAIN_RAILS_NE_SW = 24443,
    SPR_WOODEN_RC_25_DEG_TO_FLAT_CHAIN_RAILS_SE_NW = 24444,
    SPR_WOODEN_RC_25_DEG_CHAIN_RAILS_SW_NE = 24445,
    SPR_WOODEN_RC_25_DEG_CHAIN_RAILS_NW_SE = 24446,
    SPR_WOODEN_RC_25_DEG_CHAIN_RAILS_NE_SW = 24447,
    SPR_WOODEN_RC_25_DEG_CHAIN_RAILS_SE_NW = 24448,

    SPR_WOODEN_RC_FLAT_TO_25_DEG_CHAIN_RAILS_FRONT_NW_SE = 24465,
    SPR_WOODEN_RC_FLAT_TO_25_DEG_CHAIN_RAILS_FRONT_NE_SW = 24466,
    SPR_WOODEN_RC_25_DEG_TO_FLAT_CHAIN_RAILS_FRONT_NW_SE = 24467,
    SPR_WOODEN_RC_25_DEG_TO_FLAT_CHAIN_RAILS_FRONT_NE_SW = 24468,
    SPR_WOODEN_RC_25_DEG_CHAIN_RAILS_FRONT_NW_SE = 24469,
    SPR_WOODEN_RC_60_DEG_CHAIN_RAILS_FRONT_NW_SE = 24469,
    SPR_WOODEN_RC_25_DEG_CHAIN_RAILS_FRONT_NE_SW = 24470,
    SPR_WOODEN_RC_60_DEG_CHAIN_RAILS_FRONT_NE_SW = 24470,
    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_SW_SE_SEQ_0 = 24471,
    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_SW_SE_SEQ_2 = 24472,
    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_SW_SE_SEQ_3 = 24473,
    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_SW_SE_SEQ_5 = 24474,
    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_SW_SE_SEQ_6 = 24475,
    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_NW_SW_SEQ_0 = 24476,
    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_NW_SW_SEQ_2 = 24477,
    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_NW_SW_SEQ_3 = 24478,
    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_NW_SW_SEQ_5 = 24479,
    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_NW_SW_SEQ_6 = 24480,
    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_NE_NW_SEQ_0 = 24481,
    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_NE_NW_SEQ_2 = 24482,
    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_NE_NW_SEQ_3 = 24483,
    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_NE_NW_SEQ_5 = 24484,
    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_NE_NW_SEQ_6 = 24485,
    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_SE_NE_SEQ_0 = 24486,
    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_SE_NE_SEQ_2 = 24487,
    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_SE_NE_SEQ_3 = 24488,
    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_SE_NE_SEQ_5 = 24489,
    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_SE_NE_SEQ_6 = 24490,
    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_FRONT_SW_SE_SEQ_0 = 24491,
    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_FRONT_SW_SE_SEQ_2 = 24492,
    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_FRONT_SW_SE_SEQ_3 = 24493,
    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_FRONT_SW_SE_SEQ_5 = 24494,
    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_FRONT_SW_SE_SEQ_6 = 24495,
    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_FRONT_NE_NW_SEQ_0 = 24496,
    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_FRONT_NE_NW_SEQ_2 = 24497,
    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_FRONT_NE_NW_SEQ_3 = 24498,
    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_FRONT_NE_NW_SEQ_5 = 24499,
    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_FRONT_NE_NW_SEQ_6 = 24500,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_SW_SE_SEQ_0 = 24501,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_SW_SE_SEQ_2 = 24502,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_SW_SE_SEQ_3 = 24503,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_SW_SE_SEQ_5 = 24504,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_SW_SE_SEQ_6 = 24505,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_NW_SW_SEQ_0 = 24506,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_NW_SW_SEQ_2 = 24507,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_NW_SW_SEQ_3 = 24508,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_NW_SW_SEQ_5 = 24509,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_NW_SW_SEQ_6 = 24510,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_NE_NW_SEQ_0 = 24511,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_NE_NW_SEQ_2 = 24512,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_NE_NW_SEQ_3 = 24513,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_NE_NW_SEQ_5 = 24514,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_NE_NW_SEQ_6 = 24515,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_SE_NE_SEQ_0 = 24516,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_SE_NE_SEQ_2 = 24517,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_SE_NE_SEQ_3 = 24518,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_SE_NE_SEQ_5 = 24519,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_SE_NE_SEQ_6 = 24520,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_FRONT_SW_SE_SEQ_0 = 24521,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_FRONT_SW_SE_SEQ_2 = 24522,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_FRONT_SW_SE_SEQ_3 = 24523,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_FRONT_SW_SE_SEQ_5 = 24524,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_FRONT_SW_SE_SEQ_6 = 24525,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_FRONT_NE_NW_SEQ_0 = 24526,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_FRONT_NE_NW_SEQ_2 = 24527,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_FRONT_NE_NW_SEQ_3 = 24528,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_FRONT_NE_NW_SEQ_5 = 24529,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_FRONT_NE_NW_SEQ_6 = 24530,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_0_0 = 24531,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_1_0 = 24532,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_2_0 = 24533,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_3_0 = 24534,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_4_0 = 24535,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_0_1 = 24536,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_1_1 = 24537,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_2_1 = 24538,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_3_1 = 24539,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_4_1 = 24540,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_0_2 = 24541,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_1_2 = 24542,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_2_2 = 24543,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_3_2 = 24544,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_4_2 = 24545,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_0_3 = 24546,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_1_3 = 24547,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_2_3 = 24548,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_3_3 = 24549,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_4_3 = 24550,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_FRONT_HANDRAIL_0_0 = 24551,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_FRONT_HANDRAIL_1_0 = 24552,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_FRONT_HANDRAIL_2_0 = 24553,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_FRONT_HANDRAIL_3_0 = 24554,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_FRONT_HANDRAIL_4_0 = 24555,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_FRONT_HANDRAIL_0_2 = 24556,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_FRONT_HANDRAIL_1_2 = 24557,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_FRONT_HANDRAIL_2_2 = 24558,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_FRONT_HANDRAIL_3_2 = 24559,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_FRONT_HANDRAIL_4_2 = 24560,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_4_3 = 24561,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_3_3 = 24562,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_2_3 = 24563,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_1_3 = 24564,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_0_3 = 24565,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_4_0 = 24566,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_3_0 = 24567,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_2_0 = 24568,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_1_0 = 24569,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_0_0 = 24570,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_4_1 = 24571,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_3_1 = 24572,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_2_1 = 24573,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_1_1 = 24574,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_0_1 = 24575,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_4_2 = 24576,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_3_2 = 24577,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_2_2 = 24578,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_1_2 = 24579,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_0_2 = 24580,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_FRONT_HANDRAIL_4_3 = 24581,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_FRONT_HANDRAIL_3_3 = 24582,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_FRONT_HANDRAIL_2_3 = 24583,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_FRONT_HANDRAIL_1_3 = 24584,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_FRONT_HANDRAIL_0_3 = 24585,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_FRONT_HANDRAIL_4_1 = 24586,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_FRONT_HANDRAIL_3_1 = 24587,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_FRONT_HANDRAIL_2_1 = 24588,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_FRONT_HANDRAIL_1_1 = 24589,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_FRONT_HANDRAIL_0_1 = 24590,

    SPR_WOODEN_RC_FLAT_CHAIN_RAILS_SW_NE = 24615,
    SPR_WOODEN_RC_FLAT_CHAIN_RAILS_NW_SE = 24616,
    SPR_WOODEN_RC_FLAT_CHAIN_RAILS_NE_SW = 24617,
    SPR_WOODEN_RC_FLAT_CHAIN_RAILS_SE_NW = 24618,
    SPR_WOODEN_RC_FLAT_RAILS_SW_NE = 24619,
    SPR_WOODEN_RC_FLAT_RAILS_NW_SE = 24620,
    SPR_WOODEN_RC_BRAKES_RAILS_SW_NE = 24621,
    SPR_WOODEN_RC_BRAKES_RAILS_NW_SE = 24622,
    SPR_WOODEN_RC_BLOCK_BRAKES_RAILS_SW_NE = 24623,
    SPR_WOODEN_RC_BLOCK_BRAKES_RAILS_NW_SE = 24624,

    SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_HANDRAIL_2_3 = 24707,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_HANDRAIL_1_3 = 24708,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_HANDRAIL_0_3 = 24709,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_HANDRAIL_2_0 = 24710,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_HANDRAIL_1_0 = 24711,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_HANDRAIL_0_0 = 24712,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_HANDRAIL_2_1 = 24713,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_HANDRAIL_1_1 = 24714,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_HANDRAIL_0_1 = 24715,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_HANDRAIL_2_2 = 24716,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_HANDRAIL_1_2 = 24717,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_HANDRAIL_0_2 = 24718,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_FRONT_HANDRAIL_2_3 = 24719,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_FRONT_HANDRAIL_1_3 = 24720,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_FRONT_HANDRAIL_0_3 = 24721,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_FRONT_HANDRAIL_2_1 = 24722,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_FRONT_HANDRAIL_1_1 = 24723,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_FRONT_HANDRAIL_0_1 = 24724,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_HANDRAIL_0_0 = 24725,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_HANDRAIL_1_0 = 24726,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_HANDRAIL_2_0 = 24727,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_HANDRAIL_0_1 = 24728,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_HANDRAIL_1_1 = 24729,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_HANDRAIL_2_1 = 24730,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_HANDRAIL_0_2 = 24731,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_HANDRAIL_1_2 = 24732,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_HANDRAIL_2_2 = 24733,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_HANDRAIL_0_3 = 24734,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_HANDRAIL_1_3 = 24735,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_HANDRAIL_2_3 = 24736,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_FRONT_HANDRAIL_0_0 = 24737,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_FRONT_HANDRAIL_1_0 = 24738,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_FRONT_HANDRAIL_2_0 = 24739,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_FRONT_HANDRAIL_0_2 = 24740,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_FRONT_HANDRAIL_1_2 = 24741,
    SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_FRONT_HANDRAIL_2_2 = 24742,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_HANDRAIL_2_3 = 24743,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_HANDRAIL_1_3 = 24744,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_HANDRAIL_0_3 = 24745,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_HANDRAIL_2_0 = 24746,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_HANDRAIL_1_0 = 24747,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_HANDRAIL_0_0 = 24748,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_HANDRAIL_2_1 = 24749,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_HANDRAIL_1_1 = 24750,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_HANDRAIL_0_1 = 24751,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_HANDRAIL_2_2 = 24752,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_HANDRAIL_1_2 = 24753,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_HANDRAIL_0_2 = 24754,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_FRONT_HANDRAIL_2_3 = 24755,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_FRONT_HANDRAIL_1_3 = 24756,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_FRONT_HANDRAIL_0_3 = 24757,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_FRONT_HANDRAIL_2_1 = 24758,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_FRONT_HANDRAIL_1_1 = 24759,
    SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_FRONT_HANDRAIL_0_1 = 24760,

    SPR_WOODEN_RC_RIGHT_BANK_TO_RIGHT_QUARTER_TURN_3_25_DEG_UP_HANDRAIL_0_0 = 24813,
    SPR_WOODEN_RC_RIGHT_BANK_TO_RIGHT_QUARTER_TURN_3_25_DEG_UP_HANDRAIL_1_0 = 24814,
    SPR_WOODEN_RC_RIGHT_BANK_TO_RIGHT_QUARTER_TURN_3_25_DEG_UP_HANDRAIL_0_1 = 24815,
    SPR_WOODEN_RC_RIGHT_BANK_TO_RIGHT_QUARTER_TURN_3_25_DEG_UP_HANDRAIL_1_1 = 24816,
    SPR_WOODEN_RC_RIGHT_BANK_TO_RIGHT_QUARTER_TURN_3_25_DEG_UP_HANDRAIL_0_2 = 24817,
    SPR_WOODEN_RC_RIGHT_BANK_TO_RIGHT_QUARTER_TURN_3_25_DEG_UP_HANDRAIL_1_2 = 24818,
    SPR_WOODEN_RC_RIGHT_BANK_TO_RIGHT_QUARTER_TURN_3_25_DEG_UP_HANDRAIL_0_3 = 24819,
    SPR_WOODEN_RC_RIGHT_BANK_TO_RIGHT_QUARTER_TURN_3_25_DEG_UP_HANDRAIL_1_3 = 24820,
    SPR_WOODEN_RC_LEFT_BANK_TO_LEFT_QUARTER_TURN_3_25_DEG_UP_HANDRAIL_1_3 = 24821,
    SPR_WOODEN_RC_LEFT_BANK_TO_LEFT_QUARTER_TURN_3_25_DEG_UP_HANDRAIL_0_3 = 24822,
    SPR_WOODEN_RC_LEFT_BANK_TO_LEFT_QUARTER_TURN_3_25_DEG_UP_HANDRAIL_1_0 = 24823,
    SPR_WOODEN_RC_LEFT_BANK_TO_LEFT_QUARTER_TURN_3_25_DEG_UP_HANDRAIL_0_0 = 24824,
    SPR_WOODEN_RC_LEFT_BANK_TO_LEFT_QUARTER_TURN_3_25_DEG_UP_HANDRAIL_1_1 = 24825,
    SPR_WOODEN_RC_LEFT_BANK_TO_LEFT_QUARTER_TURN_3_25_DEG_UP_HANDRAIL_0_1 = 24826,
    SPR_WOODEN_RC_LEFT_BANK_TO_LEFT_QUARTER_TURN_3_25_DEG_UP_HANDRAIL_1_2 = 24827,
    SPR_WOODEN_RC_LEFT_BANK_TO_LEFT_QUARTER_TURN_3_25_DEG_UP_HANDRAIL_0_2 = 24828,
    SPR_WOODEN_RC_RIGHT_BANK_TO_RIGHT_QUARTER_TURN_3_25_DEG_UP_FRONT_HANDRAIL_0_0 = 24829,
    SPR_WOODEN_RC_RIGHT_BANK_TO_RIGHT_QUARTER_TURN_3_25_DEG_UP_FRONT_HANDRAIL_1_0 = 24830,
    SPR_WOODEN_RC_RIGHT_BANK_TO_RIGHT_QUARTER_TURN_3_25_DEG_UP_FRONT_HANDRAIL_1_1 = 24831,
    SPR_WOODEN_RC_RIGHT_BANK_TO_RIGHT_QUARTER_TURN_3_25_DEG_UP_FRONT_HANDRAIL_0_2 = 24832,
    SPR_WOODEN_RC_RIGHT_BANK_TO_RIGHT_QUARTER_TURN_3_25_DEG_UP_FRONT_HANDRAIL_1_2 = 24833,
    SPR_WOODEN_RC_LEFT_BANK_TO_LEFT_QUARTER_TURN_3_25_DEG_UP_FRONT_HANDRAIL_1_3 = 24834,
    SPR_WOODEN_RC_LEFT_BANK_TO_LEFT_QUARTER_TURN_3_25_DEG_UP_FRONT_HANDRAIL_0_3 = 24835,
    SPR_WOODEN_RC_LEFT_BANK_TO_LEFT_QUARTER_TURN_3_25_DEG_UP_FRONT_HANDRAIL_1_1 = 24836,
    SPR_WOODEN_RC_LEFT_BANK_TO_LEFT_QUARTER_TURN_3_25_DEG_UP_FRONT_HANDRAIL_0_1 = 24837,
    SPR_WOODEN_RC_LEFT_BANK_TO_LEFT_QUARTER_TURN_3_25_DEG_UP_FRONT_HANDRAIL_1_2 = 24838,

    SPR_WOODEN_RC_STATION_RAILS_SW_NE = 24839,
    SPR_WOODEN_RC_STATION_RAILS_NW_SE = 24840,

    SPR_WOODEN_RC_DIAG_FLAT_TO_LEFT_BANK_HANDRAIL_0 = 24943,
    SPR_WOODEN_RC_DIAG_FLAT_TO_LEFT_BANK_HANDRAIL_1 = 24944,
    SPR_WOODEN_RC_DIAG_FLAT_TO_LEFT_BANK_HANDRAIL_2 = 24945,
    SPR_WOODEN_RC_DIAG_FLAT_TO_LEFT_BANK_HANDRAIL_3 = 24946,
    SPR_WOODEN_RC_DIAG_FLAT_TO_LEFT_BANK_FRONT_HANDRAIL_0 = 24947,
    SPR_WOODEN_RC_DIAG_FLAT_TO_LEFT_BANK_FRONT_HANDRAIL_2 = 24948,
    SPR_WOODEN_RC_DIAG_FLAT_TO_RIGHT_BANK_HANDRAIL_0 = 24949,
    SPR_WOODEN_RC_DIAG_FLAT_TO_RIGHT_BANK_HANDRAIL_1 = 24950,
    SPR_WOODEN_RC_DIAG_FLAT_TO_RIGHT_BANK_HANDRAIL_2 = 24951,
    SPR_WOODEN_RC_DIAG_FLAT_TO_RIGHT_BANK_HANDRAIL_3 = 24952,
    SPR_WOODEN_RC_DIAG_FLAT_TO_RIGHT_BANK_FRONT_HANDRAIL_0 = 24953,
    SPR_WOODEN_RC_DIAG_FLAT_TO_RIGHT_BANK_FRONT_HANDRAIL_2 = 24954,
    SPR_WOODEN_RC_DIAG_UP_25_TO_LEFT_BANK_HANDRAIL_0 = 24955,
    SPR_WOODEN_RC_DIAG_UP_25_TO_LEFT_BANK_HANDRAIL_1 = 24956,
    SPR_WOODEN_RC_DIAG_UP_25_TO_LEFT_BANK_HANDRAIL_2 = 24957,
    SPR_WOODEN_RC_DIAG_UP_25_TO_LEFT_BANK_HANDRAIL_3 = 24958,
    SPR_WOODEN_RC_DIAG_UP_25_TO_LEFT_BANK_FRONT_HANDRAIL_0 = 24959,
    SPR_WOODEN_RC_DIAG_UP_25_TO_LEFT_BANK_FRONT_HANDRAIL_2 = 24960,
    SPR_WOODEN_RC_DIAG_UP_25_TO_RIGHT_BANK_HANDRAIL_0 = 24961,
    SPR_WOODEN_RC_DIAG_UP_25_TO_RIGHT_BANK_HANDRAIL_1 = 24962,
    SPR_WOODEN_RC_DIAG_UP_25_TO_RIGHT_BANK_HANDRAIL_2 = 24963,
    SPR_WOODEN_RC_DIAG_UP_25_TO_RIGHT_BANK_HANDRAIL_3 = 24964,
    SPR_WOODEN_RC_DIAG_UP_25_TO_RIGHT_BANK_FRONT_HANDRAIL_0 = 24965,
    SPR_WOODEN_RC_DIAG_UP_25_TO_RIGHT_BANK_FRONT_HANDRAIL_2 = 24966,
    SPR_WOODEN_RC_DIAG_LEFT_BANK_TO_25_DEG_UP_HANDRAIL_0 = 24967,
    SPR_WOODEN_RC_DIAG_LEFT_BANK_TO_25_DEG_UP_HANDRAIL_1 = 24968,
    SPR_WOODEN_RC_DIAG_LEFT_BANK_TO_25_DEG_UP_HANDRAIL_2 = 24969,
    SPR_WOODEN_RC_DIAG_LEFT_BANK_TO_25_DEG_UP_HANDRAIL_3 = 24970,
    SPR_WOODEN_RC_DIAG_LEFT_BANK_TO_25_DEG_UP_FRONT_HANDRAIL_0 = 24971,
    SPR_WOODEN_RC_DIAG_LEFT_BANK_TO_25_DEG_UP_FRONT_HANDRAIL_2 = 24972,
    SPR_WOODEN_RC_DIAG_RIGHT_BANK_TO_25_DEG_UP_HANDRAIL_0 = 24973,
    SPR_WOODEN_RC_DIAG_RIGHT_BANK_TO_25_DEG_UP_HANDRAIL_1 = 24974,
    SPR_WOODEN_RC_DIAG_RIGHT_BANK_TO_25_DEG_UP_HANDRAIL_2 = 24975,
    SPR_WOODEN_RC_DIAG_RIGHT_BANK_TO_25_DEG_UP_HANDRAIL_3 = 24976,
    SPR_WOODEN_RC_DIAG_RIGHT_BANK_TO_25_DEG_UP_FRONT_HANDRAIL_0 = 24977,
    SPR_WOODEN_RC_DIAG_RIGHT_BANK_TO_25_DEG_UP_FRONT_HANDRAIL_2 = 24978,

    SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_HANDRAIL_0_0 = 25027,
    SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_HANDRAIL_1_0 = 25028,
    SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_HANDRAIL_2_0 = 25029,
    SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_HANDRAIL_3_0 = 25030,
    SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_HANDRAIL_0_1 = 25031,
    SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_HANDRAIL_1_1 = 25032,
    SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_HANDRAIL_2_1 = 25033,
    SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_HANDRAIL_3_1 = 25034,
    SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_HANDRAIL_0_2 = 25035,
    SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_HANDRAIL_1_2 = 25036,
    SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_HANDRAIL_2_2 = 25037,
    SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_HANDRAIL_3_2 = 25038,
    SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_HANDRAIL_0_3 = 25039,
    SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_HANDRAIL_1_3 = 25040,
    SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_HANDRAIL_2_3 = 25041,
    SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_HANDRAIL_3_3 = 25042,
    SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_FRONT_HANDRAIL_0_0 = 25043,
    SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_FRONT_HANDRAIL_1_0 = 25044,
    SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_FRONT_HANDRAIL_2_0 = 25045,
    SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_FRONT_HANDRAIL_3_0 = 25046,
    SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_FRONT_HANDRAIL_0_2 = 25047,
    SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_FRONT_HANDRAIL_1_2 = 25048,
    SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_FRONT_HANDRAIL_2_2 = 25049,
    SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_FRONT_HANDRAIL_3_2 = 25050,
    SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_HANDRAIL_0_0 = 25051,
    SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_HANDRAIL_1_0 = 25052,
    SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_HANDRAIL_2_0 = 25053,
    SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_HANDRAIL_3_0 = 25054,
    SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_HANDRAIL_0_1 = 25055,
    SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_HANDRAIL_1_1 = 25056,
    SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_HANDRAIL_2_1 = 25057,
    SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_HANDRAIL_3_1 = 25058,
    SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_HANDRAIL_0_2 = 25059,
    SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_HANDRAIL_1_2 = 25060,
    SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_HANDRAIL_2_2 = 25061,
    SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_HANDRAIL_3_2 = 25062,
    SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_HANDRAIL_0_3 = 25063,
    SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_HANDRAIL_1_3 = 25064,
    SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_HANDRAIL_2_3 = 25065,
    SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_HANDRAIL_3_3 = 25066,
    SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_FRONT_HANDRAIL_0_1 = 25067,
    SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_FRONT_HANDRAIL_1_1 = 25068,
    SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_FRONT_HANDRAIL_2_1 = 25069,
    SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_FRONT_HANDRAIL_3_1 = 25070,
    SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_FRONT_HANDRAIL_0_3 = 25071,
    SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_FRONT_HANDRAIL_1_3 = 25072,
    SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_FRONT_HANDRAIL_2_3 = 25073,
    SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_FRONT_HANDRAIL_3_3 = 25074,
};

static constexpr uint32_t kBlockBrakesImageIds[4][3] = {
    { SPR_WOODEN_RC_BLOCK_BRAKES_SW_NE_OPEN, SPR_WOODEN_RC_BLOCK_BRAKES_SW_NE_CLOSED, SPR_WOODEN_RC_BLOCK_BRAKES_RAILS_SW_NE },
    { SPR_WOODEN_RC_BLOCK_BRAKES_NW_SE_OPEN, SPR_WOODEN_RC_BLOCK_BRAKES_NW_SE_CLOSED, SPR_WOODEN_RC_BLOCK_BRAKES_RAILS_NW_SE },
    { SPR_WOODEN_RC_BLOCK_BRAKES_SW_NE_OPEN, SPR_WOODEN_RC_BLOCK_BRAKES_SW_NE_CLOSED, SPR_WOODEN_RC_BLOCK_BRAKES_RAILS_SW_NE },
    { SPR_WOODEN_RC_BLOCK_BRAKES_NW_SE_OPEN, SPR_WOODEN_RC_BLOCK_BRAKES_NW_SE_CLOSED, SPR_WOODEN_RC_BLOCK_BRAKES_RAILS_NW_SE },
};

static constexpr ImageIndex kStationBlockBrakesImageIds[2][kNumOrthogonalDirections][2] = {
    {
        { SPR_TRACKS_WOODEN_RC_STATION_NO_PLATFORM_BLOCK_BRAKE_OPEN_SW_NE,
          SPR_TRACKS_WOODEN_RC_STATION_NO_PLATFORM_BLOCK_BRAKE_CLOSED_SW_NE },
        { SPR_TRACKS_WOODEN_RC_STATION_NO_PLATFORM_BLOCK_BRAKE_OPEN_NW_SE,
          SPR_TRACKS_WOODEN_RC_STATION_NO_PLATFORM_BLOCK_BRAKE_CLOSED_NW_SE },
        { SPR_TRACKS_WOODEN_RC_STATION_NO_PLATFORM_BLOCK_BRAKE_OPEN_SW_NE,
          SPR_TRACKS_WOODEN_RC_STATION_NO_PLATFORM_BLOCK_BRAKE_CLOSED_SW_NE },
        { SPR_TRACKS_WOODEN_RC_STATION_NO_PLATFORM_BLOCK_BRAKE_OPEN_NW_SE,
          SPR_TRACKS_WOODEN_RC_STATION_NO_PLATFORM_BLOCK_BRAKE_CLOSED_NW_SE },
    },
    {
        { SPR_TRACKS_WOODEN_RC_STATION_BLOCK_BRAKE_OPEN_SW_NE, SPR_TRACKS_WOODEN_RC_STATION_BLOCK_BRAKE_CLOSED_SW_NE },
        { SPR_TRACKS_WOODEN_RC_STATION_BLOCK_BRAKE_OPEN_NW_SE, SPR_TRACKS_WOODEN_RC_STATION_BLOCK_BRAKE_CLOSED_NW_SE },
        { SPR_TRACKS_WOODEN_RC_STATION_BLOCK_BRAKE_OPEN_SW_NE, SPR_TRACKS_WOODEN_RC_STATION_BLOCK_BRAKE_CLOSED_SW_NE },
        { SPR_TRACKS_WOODEN_RC_STATION_BLOCK_BRAKE_OPEN_NW_SE, SPR_TRACKS_WOODEN_RC_STATION_BLOCK_BRAKE_CLOSED_NW_SE },
    },
};

static constexpr const uint32_t kWoodenRCDiagBrakeImages[kNumOrthogonalDirections] = {
    SPR_TRACKS_WOODEN_RC_DIAG_BRAKES,
    SPR_TRACKS_WOODEN_RC_DIAG_BRAKES + 1,
    SPR_TRACKS_WOODEN_RC_DIAG_BRAKES,
    SPR_TRACKS_WOODEN_RC_DIAG_BRAKES + 1,
};

static constexpr const uint32_t kWoodenRCDiagBlockBrakeImages[2][kNumOrthogonalDirections] = {
    {
        SPR_TRACKS_WOODEN_RC_DIAG_BRAKES + 3,
        SPR_TRACKS_WOODEN_RC_DIAG_BRAKES + 5,
        SPR_TRACKS_WOODEN_RC_DIAG_BRAKES + 3,
        SPR_TRACKS_WOODEN_RC_DIAG_BRAKES + 5,
    },
    {
        SPR_TRACKS_WOODEN_RC_DIAG_BRAKES + 2,
        SPR_TRACKS_WOODEN_RC_DIAG_BRAKES + 4,
        SPR_TRACKS_WOODEN_RC_DIAG_BRAKES + 2,
        SPR_TRACKS_WOODEN_RC_DIAG_BRAKES + 4,
    },
};

static constexpr std::array<WoodenTrackSection, kNumOrthogonalDirections> kFlatToLeftBankImages = { {
    {
        SPR_WOODEN_RC_FLAT_TO_LEFT_BANK_SW_NE,
        SPR_WOODEN_RC_FLAT_TO_LEFT_BANK_RAILS_SW_NE,
    },
    {
        SPR_WOODEN_RC_FLAT_TO_LEFT_BANK_NW_SE,
        SPR_WOODEN_RC_FLAT_TO_LEFT_BANK_RAILS_NW_SE,
        SPR_WOODEN_RC_FLAT_TO_LEFT_BANK_FRONT_NW_SE,
        SPR_WOODEN_RC_FLAT_TO_LEFT_BANK_RAILS_FRONT_NW_SE,
    },
    {
        SPR_WOODEN_RC_FLAT_TO_LEFT_BANK_NE_SW,
        SPR_WOODEN_RC_FLAT_TO_LEFT_BANK_RAILS_NE_SW,
    },
    {
        SPR_WOODEN_RC_FLAT_TO_LEFT_BANK_SE_NW,
        SPR_WOODEN_RC_FLAT_TO_LEFT_BANK_RAILS_SE_NW,
        SPR_WOODEN_RC_FLAT_TO_LEFT_BANK_FRONT_SE_NW,
        SPR_WOODEN_RC_FLAT_TO_LEFT_BANK_RAILS_FRONT_SE_NW,
    },
} };

static constexpr std::array<WoodenTrackSection, kNumOrthogonalDirections> kFlatToRightBankImages = { {
    {
        SPR_WOODEN_RC_FLAT_TO_RIGHT_BANK_SW_NE,
        SPR_WOODEN_RC_FLAT_TO_RIGHT_BANK_RAILS_SW_NE,
        SPR_WOODEN_RC_FLAT_TO_RIGHT_BANK_FRONT_SW_NE,
        SPR_WOODEN_RC_FLAT_TO_RIGHT_BANK_RAILS_FRONT_SW_NE,
    },
    {
        SPR_WOODEN_RC_FLAT_TO_RIGHT_BANK_NW_SE,
        SPR_WOODEN_RC_FLAT_TO_RIGHT_BANK_RAILS_NW_SE,
    },
    {
        SPR_WOODEN_RC_FLAT_TO_RIGHT_BANK_NE_SW,
        SPR_WOODEN_RC_FLAT_TO_RIGHT_BANK_RAILS_NE_SW,
        SPR_WOODEN_RC_FLAT_TO_RIGHT_BANK_FRONT_NE_SW,
        SPR_WOODEN_RC_FLAT_TO_RIGHT_BANK_RAILS_FRONT_NE_SW,
    },
    {
        SPR_WOODEN_RC_FLAT_TO_RIGHT_BANK_SE_NW,
        SPR_WOODEN_RC_FLAT_TO_RIGHT_BANK_RAILS_SE_NW,
    },
} };

static constexpr std::array<WoodenTrackSection, kNumOrthogonalDirections> kLeftBankImages = { {
    { SPR_WOODEN_RC_LEFT_BANK_SW_NE, SPR_WOODEN_RC_LEFT_BANK_RAILS_SW_NE, SPR_TRACKS_WOODEN_RC_LEFT_BANK_FRONT_SW_NE,
      SPR_TRACKS_WOODEN_RC_LEFT_BANK_RAILS_FRONT_SW_NE },
    { SPR_WOODEN_RC_LEFT_BANK_NW_SE, SPR_WOODEN_RC_LEFT_BANK_RAILS_NW_SE, SPR_TRACKS_WOODEN_RC_LEFT_BANK_FRONT_NW_SE,
      SPR_TRACKS_WOODEN_RC_LEFT_BANK_RAILS_FRONT_NW_SE },
    { SPR_WOODEN_RC_LEFT_BANK_NE_SW, SPR_WOODEN_RC_LEFT_BANK_RAILS_NE_SW },
    { SPR_WOODEN_RC_LEFT_BANK_SE_NW, SPR_WOODEN_RC_LEFT_BANK_RAILS_SE_NW },
} };

static constexpr std::array<WoodenTrackSection, kNumOrthogonalDirections> kUp25ToLeftBankImages = { {
    {
        SPR_WOODEN_RC_25_DEG_TO_LEFT_BANK_SW_NE,
        SPR_WOODEN_RC_25_DEG_TO_LEFT_BANK_RAILS_SW_NE,
    },
    {
        SPR_WOODEN_RC_25_DEG_TO_LEFT_BANK_NW_SE,
        SPR_WOODEN_RC_25_DEG_TO_LEFT_BANK_RAILS_NW_SE,
        SPR_WOODEN_RC_25_DEG_TO_LEFT_BANK_FRONT_NW_SE,
        SPR_WOODEN_RC_25_DEG_TO_LEFT_BANK_RAILS_FRONT_NW_SE,
    },
    {
        SPR_WOODEN_RC_25_DEG_TO_LEFT_BANK_NE_SW,
        SPR_WOODEN_RC_25_DEG_TO_LEFT_BANK_RAILS_NE_SW,
        SPR_WOODEN_RC_25_DEG_TO_LEFT_BANK_FRONT_NE_SW,
        SPR_WOODEN_RC_25_DEG_TO_LEFT_BANK_RAILS_FRONT_NE_SW,
    },
    {
        SPR_WOODEN_RC_25_DEG_TO_LEFT_BANK_SE_NW,
        SPR_WOODEN_RC_25_DEG_TO_LEFT_BANK_RAILS_SE_NW,
    },
} };

static constexpr std::array<WoodenTrackSection, kNumOrthogonalDirections> kUp25ToRightBankImages = { {
    {
        SPR_WOODEN_RC_25_DEG_TO_RIGHT_BANK_SW_NE,
        SPR_WOODEN_RC_25_DEG_TO_RIGHT_BANK_RAILS_SW_NE,
    },
    {
        SPR_WOODEN_RC_25_DEG_TO_RIGHT_BANK_NW_SE,
        SPR_WOODEN_RC_25_DEG_TO_RIGHT_BANK_RAILS_NW_SE,
        SPR_WOODEN_RC_25_DEG_TO_RIGHT_BANK_FRONT_NW_SE,
        SPR_WOODEN_RC_25_DEG_TO_RIGHT_BANK_RAILS_FRONT_NW_SE,
    },
    {
        SPR_WOODEN_RC_25_DEG_TO_RIGHT_BANK_NE_SW,
        SPR_WOODEN_RC_25_DEG_TO_RIGHT_BANK_RAILS_NE_SW,
        SPR_WOODEN_RC_25_DEG_TO_RIGHT_BANK_FRONT_NE_SW,
        SPR_WOODEN_RC_25_DEG_TO_RIGHT_BANK_RAILS_FRONT_NE_SW,
    },
    {
        SPR_WOODEN_RC_25_DEG_TO_RIGHT_BANK_SE_NW,
        SPR_WOODEN_RC_25_DEG_TO_RIGHT_BANK_RAILS_SE_NW,
    },
} };

static constexpr std::array<WoodenTrackSection, kNumOrthogonalDirections> kLeftBankToUp25Images = { {
    {
        SPR_WOODEN_RC_LEFT_BANK_TO_25_DEG_SW_NE,
        SPR_WOODEN_RC_LEFT_BANK_TO_25_DEG_RAILS_SW_NE,
    },
    {
        SPR_WOODEN_RC_LEFT_BANK_TO_25_DEG_NW_SE,
        SPR_WOODEN_RC_LEFT_BANK_TO_25_DEG_RAILS_NW_SE,
        SPR_WOODEN_RC_LEFT_BANK_TO_25_DEG_FRONT_NW_SE,
        SPR_WOODEN_RC_LEFT_BANK_TO_25_DEG_RAILS_FRONT_NW_SE,
    },
    {
        SPR_WOODEN_RC_LEFT_BANK_TO_25_DEG_NE_SW,
        SPR_WOODEN_RC_LEFT_BANK_TO_25_DEG_RAILS_NE_SW,
        SPR_WOODEN_RC_LEFT_BANK_TO_25_DEG_FRONT_NE_SW,
        SPR_WOODEN_RC_LEFT_BANK_TO_25_DEG_RAILS_FRONT_NE_SW,
    },
    {
        SPR_WOODEN_RC_LEFT_BANK_TO_25_DEG_SE_NW,
        SPR_WOODEN_RC_LEFT_BANK_TO_25_DEG_RAILS_SE_NW,
    },
} };
static constexpr std::array<WoodenTrackSection, kNumOrthogonalDirections> kRightBankToUp25Images = { {
    {
        SPR_WOODEN_RC_RIGHT_BANK_TO_25_DEG_SW_NE,
        SPR_WOODEN_RC_RIGHT_BANK_TO_25_DEG_RAILS_SW_NE,
    },
    {
        SPR_WOODEN_RC_RIGHT_BANK_TO_25_DEG_NW_SE,
        SPR_WOODEN_RC_RIGHT_BANK_TO_25_DEG_RAILS_NW_SE,
        SPR_WOODEN_RC_RIGHT_BANK_TO_25_DEG_FRONT_NW_SE,
        SPR_WOODEN_RC_RIGHT_BANK_TO_25_DEG_RAILS_FRONT_NW_SE,
    },
    {
        SPR_WOODEN_RC_RIGHT_BANK_TO_25_DEG_NE_SW,
        SPR_WOODEN_RC_RIGHT_BANK_TO_25_DEG_RAILS_NE_SW,
        SPR_WOODEN_RC_RIGHT_BANK_TO_25_DEG_FRONT_NE_SW,
        SPR_WOODEN_RC_RIGHT_BANK_TO_25_DEG_RAILS_FRONT_NE_SW,
    },
    {
        SPR_WOODEN_RC_RIGHT_BANK_TO_25_DEG_SE_NW,
        SPR_WOODEN_RC_RIGHT_BANK_TO_25_DEG_RAILS_SE_NW,
    },
} };

static constexpr std::array<std::array<WoodenTrackSection, kNumOrthogonalDirections>, 3> kBankedQuarterTurn3Images = { {
    { {
        {
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_0_0,
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_HANDRAIL_0_0,
        },
        {
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_0_1,
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_HANDRAIL_0_1,
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_FRONT_0_1,
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_FRONT_HANDRAIL_0_1,
        },
        {
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_0_2,
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_HANDRAIL_0_2,
        },
        {
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_0_3,
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_HANDRAIL_0_3,
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_FRONT_0_3,
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_FRONT_HANDRAIL_0_3,
        },
    } },
    { {
        {
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_1_0,
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_HANDRAIL_1_0,
        },
        {
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_1_1,
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_HANDRAIL_1_1,
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_FRONT_1_1,
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_FRONT_HANDRAIL_1_1,
        },
        {
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_1_2,
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_HANDRAIL_1_2,
        },
        {
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_1_3,
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_HANDRAIL_1_3,
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_FRONT_1_3,
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_FRONT_HANDRAIL_1_3,
        },
    } },
    { {
        {
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_2_0,
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_HANDRAIL_2_0,
        },
        {
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_2_1,
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_HANDRAIL_2_1,
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_FRONT_2_1,
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_FRONT_HANDRAIL_2_1,
        },
        {
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_2_2,
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_HANDRAIL_2_2,
        },
        {
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_2_3,
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_HANDRAIL_2_3,
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_FRONT_2_3,
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_3_FRONT_HANDRAIL_2_3,
        },
    } },
} };

static constexpr std::array<std::array<WoodenTrackSection, kNumOrthogonalDirections>, 5> kBankedQuarterTurn5Images = { {
    { {
        {
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_SW_SE_SEQ_0,
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_SW_SE_SEQ_0,
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_FRONT_SW_SE_SEQ_0,
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_FRONT_SW_SE_SEQ_0,
        },
        {
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_NW_SW_SEQ_0,
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_NW_SW_SEQ_0,
        },
        {
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_NE_NW_SEQ_0,
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_NE_NW_SEQ_0,
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_FRONT_NE_NW_SEQ_0,
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_FRONT_NE_NW_SEQ_0,
        },
        {
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_SE_NE_SEQ_0,
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_SE_NE_SEQ_0,
        },
    } },
    { {
        {
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_SW_SE_SEQ_2,
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_SW_SE_SEQ_2,
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_FRONT_SW_SE_SEQ_2,
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_FRONT_SW_SE_SEQ_2,
        },
        {
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_NW_SW_SEQ_2,
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_NW_SW_SEQ_2,
        },
        {
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_NE_NW_SEQ_2,
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_NE_NW_SEQ_2,
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_FRONT_NE_NW_SEQ_2,
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_FRONT_NE_NW_SEQ_2,
        },
        {
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_SE_NE_SEQ_2,
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_SE_NE_SEQ_2,
        },
    } },
    { {
        {
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_SW_SE_SEQ_3,
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_SW_SE_SEQ_3,
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_FRONT_SW_SE_SEQ_3,
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_FRONT_SW_SE_SEQ_3,
        },
        {
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_NW_SW_SEQ_3,
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_NW_SW_SEQ_3,
        },
        {
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_NE_NW_SEQ_3,
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_NE_NW_SEQ_3,
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_FRONT_NE_NW_SEQ_3,
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_FRONT_NE_NW_SEQ_3,
        },
        {
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_SE_NE_SEQ_3,
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_SE_NE_SEQ_3,
        },
    } },
    { {
        {
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_SW_SE_SEQ_5,
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_SW_SE_SEQ_5,
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_FRONT_SW_SE_SEQ_5,
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_FRONT_SW_SE_SEQ_5,
        },
        {
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_NW_SW_SEQ_5,
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_NW_SW_SEQ_5,
        },
        {
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_NE_NW_SEQ_5,
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_NE_NW_SEQ_5,
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_FRONT_NE_NW_SEQ_5,
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_FRONT_NE_NW_SEQ_5,
        },
        {
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_SE_NE_SEQ_5,
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_SE_NE_SEQ_5,
        },
    } },
    { {
        {
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_SW_SE_SEQ_6,
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_SW_SE_SEQ_6,
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_FRONT_SW_SE_SEQ_6,
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_FRONT_SW_SE_SEQ_6,
        },
        {
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_NW_SW_SEQ_6,
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_NW_SW_SEQ_6,
        },
        {
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_NE_NW_SEQ_6,
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_NE_NW_SEQ_6,
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_FRONT_NE_NW_SEQ_6,
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_FRONT_NE_NW_SEQ_6,
        },
        {
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_SE_NE_SEQ_6,
            SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_SE_NE_SEQ_6,
        },
    } },
} };

static constexpr std::array<std::array<WoodenTrackSection, kNumOrthogonalDirections>, 3> kLeftHalfBankedHelixUpSmallImages = { {
    { {
        {
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_0_0,
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_HANDRAIL_0_0,
        },
        {
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_0_1,
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_HANDRAIL_0_1,
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_FRONT_0_1,
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_FRONT_HANDRAIL_0_1,
        },
        {
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_0_2,
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_HANDRAIL_0_2,
        },
        {
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_0_3,
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_HANDRAIL_0_3,
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_FRONT_0_3,
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_FRONT_HANDRAIL_0_3,
        },
    } },
    { {
        {
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_1_0,
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_HANDRAIL_1_0,
        },
        {
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_1_1,
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_HANDRAIL_1_1,
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_FRONT_1_1,
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_FRONT_HANDRAIL_1_1,
        },
        {
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_1_2,
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_HANDRAIL_1_2,
        },
        {
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_1_3,
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_HANDRAIL_1_3,
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_FRONT_1_3,
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_FRONT_HANDRAIL_1_3,
        },
    } },
    { {
        {
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_2_0,
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_HANDRAIL_2_0,
        },
        {
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_2_1,
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_HANDRAIL_2_1,
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_FRONT_2_1,
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_FRONT_HANDRAIL_2_1,
        },
        {
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_2_2,
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_HANDRAIL_2_2,
        },
        {
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_2_3,
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_HANDRAIL_2_3,
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_FRONT_2_3,
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_UP_SMALL_FRONT_HANDRAIL_2_3,
        },
    } },
} };

static constexpr std::array<std::array<WoodenTrackSection, kNumOrthogonalDirections>, 3> kRightHalfBankedHelixUpSmallImages = {
    {
        { {
            {
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_0_0,
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_HANDRAIL_0_0,
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_FRONT_0_0,
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_FRONT_HANDRAIL_0_0,
            },
            {
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_0_1,
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_HANDRAIL_0_1,
            },
            {
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_0_2,
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_HANDRAIL_0_2,
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_FRONT_0_2,
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_FRONT_HANDRAIL_0_2,
            },
            {
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_0_3,
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_HANDRAIL_0_3,
            },
        } },
        { {
            {
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_1_0,
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_HANDRAIL_1_0,
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_FRONT_1_0,
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_FRONT_HANDRAIL_1_0,
            },
            {
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_1_1,
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_HANDRAIL_1_1,
            },
            {
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_1_2,
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_HANDRAIL_1_2,
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_FRONT_1_2,
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_FRONT_HANDRAIL_1_2,
            },
            {
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_1_3,
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_HANDRAIL_1_3,
            },
        } },
        { {
            {
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_2_0,
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_HANDRAIL_2_0,
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_FRONT_2_0,
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_FRONT_HANDRAIL_2_0,
            },
            {
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_2_1,
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_HANDRAIL_2_1,
            },
            {
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_2_2,
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_HANDRAIL_2_2,
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_FRONT_2_2,
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_FRONT_HANDRAIL_2_2,
            },
            {
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_2_3,
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_UP_SMALL_HANDRAIL_2_3,
            },
        } },
    }
};

static constexpr std::array<std::array<WoodenTrackSection, kNumOrthogonalDirections>, 5> kLeftHalfBankedHelixUpLargeImages = { {
    { {
        {
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_0_0,
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_0_0,
        },
        {
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_0_1,
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_0_1,
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_FRONT_0_1,
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_FRONT_HANDRAIL_0_1,
        },
        {
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_0_2,
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_0_2,
        },
        {
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_0_3,
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_0_3,
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_FRONT_0_3,
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_FRONT_HANDRAIL_0_3,
        },
    } },
    { {
        {
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_1_0,
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_1_0,
        },
        {
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_1_1,
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_1_1,
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_FRONT_1_1,
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_FRONT_HANDRAIL_1_1,
        },
        {
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_1_2,
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_1_2,
        },
        {
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_1_3,
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_1_3,
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_FRONT_1_3,
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_FRONT_HANDRAIL_1_3,
        },
    } },
    { {
        {
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_2_0,
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_2_0,
        },
        {
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_2_1,
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_2_1,
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_FRONT_2_1,
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_FRONT_HANDRAIL_2_1,
        },
        {
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_2_2,
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_2_2,
        },
        {
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_2_3,
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_2_3,
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_FRONT_2_3,
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_FRONT_HANDRAIL_2_3,
        },
    } },
    { {
        {
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_3_0,
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_3_0,
        },
        {
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_3_1,
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_3_1,
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_FRONT_3_1,
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_FRONT_HANDRAIL_3_1,
        },
        {
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_3_2,
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_3_2,
        },
        {
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_3_3,
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_3_3,
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_FRONT_3_3,
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_FRONT_HANDRAIL_3_3,
        },
    } },
    { {
        {
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_4_0,
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_4_0,
        },
        {
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_4_1,
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_4_1,
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_FRONT_4_1,
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_FRONT_HANDRAIL_4_1,
        },
        {
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_4_2,
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_4_2,
        },
        {
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_4_3,
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_4_3,
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_FRONT_4_3,
            SPR_WOODEN_RC_LEFT_HALF_BANKED_HELIX_LARGE_UP_FRONT_HANDRAIL_4_3,
        },
    } },
} };

static constexpr std::array<std::array<WoodenTrackSection, kNumOrthogonalDirections>, 5> kRightHalfBankedHelixUpLargeImages = {
    {
        { {
            {
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_0_0,
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_0_0,
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_FRONT_0_0,
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_FRONT_HANDRAIL_0_0,
            },
            {
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_0_1,
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_0_1,
            },
            {
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_0_2,
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_0_2,
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_FRONT_0_2,
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_FRONT_HANDRAIL_0_2,
            },
            {
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_0_3,
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_0_3,
            },
        } },
        { {
            {
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_1_0,
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_1_0,
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_FRONT_1_0,
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_FRONT_HANDRAIL_1_0,
            },
            {
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_1_1,
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_1_1,
            },
            {
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_1_2,
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_1_2,
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_FRONT_1_2,
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_FRONT_HANDRAIL_1_2,
            },
            {
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_1_3,
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_1_3,
            },
        } },
        { {
            {
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_2_0,
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_2_0,
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_FRONT_2_0,
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_FRONT_HANDRAIL_2_0,
            },
            {
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_2_1,
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_2_1,
            },
            {
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_2_2,
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_2_2,
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_FRONT_2_2,
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_FRONT_HANDRAIL_2_2,
            },
            {
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_2_3,
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_2_3,
            },
        } },
        { {
            {
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_3_0,
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_3_0,
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_FRONT_3_0,
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_FRONT_HANDRAIL_3_0,
            },
            {
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_3_1,
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_3_1,
            },
            {
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_3_2,
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_3_2,
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_FRONT_3_2,
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_FRONT_HANDRAIL_3_2,
            },
            {
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_3_3,
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_3_3,
            },
        } },
        { {
            {
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_4_0,
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_4_0,
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_FRONT_4_0,
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_FRONT_HANDRAIL_4_0,
            },
            {
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_4_1,
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_4_1,
            },
            {
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_4_2,
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_4_2,
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_FRONT_4_2,
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_FRONT_HANDRAIL_4_2,
            },
            {
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_4_3,
                SPR_WOODEN_RC_RIGHT_HALF_BANKED_HELIX_LARGE_UP_HANDRAIL_4_3,
            },
        } },
    }
};

static constexpr std::array<std::array<WoodenTrackSection, kNumOrthogonalDirections>, 2>
    kLeftBankToLeftQuarterTurn325DegUpImages = { {
        { {
            {
                SPR_WOODEN_RC_LEFT_BANK_TO_LEFT_QUARTER_TURN_3_25_DEG_UP_0_0,
                SPR_WOODEN_RC_LEFT_BANK_TO_LEFT_QUARTER_TURN_3_25_DEG_UP_HANDRAIL_0_0,
            },
            {
                SPR_WOODEN_RC_LEFT_BANK_TO_LEFT_QUARTER_TURN_3_25_DEG_UP_0_1,
                SPR_WOODEN_RC_LEFT_BANK_TO_LEFT_QUARTER_TURN_3_25_DEG_UP_HANDRAIL_0_1,
                SPR_WOODEN_RC_LEFT_BANK_TO_LEFT_QUARTER_TURN_3_25_DEG_UP_FRONT_0_1,
                SPR_WOODEN_RC_LEFT_BANK_TO_LEFT_QUARTER_TURN_3_25_DEG_UP_FRONT_HANDRAIL_0_1,
            },
            {
                SPR_WOODEN_RC_LEFT_BANK_TO_LEFT_QUARTER_TURN_3_25_DEG_UP_0_2,
                SPR_WOODEN_RC_LEFT_BANK_TO_LEFT_QUARTER_TURN_3_25_DEG_UP_HANDRAIL_0_2,
            },
            {
                SPR_WOODEN_RC_LEFT_BANK_TO_LEFT_QUARTER_TURN_3_25_DEG_UP_0_3,
                SPR_WOODEN_RC_LEFT_BANK_TO_LEFT_QUARTER_TURN_3_25_DEG_UP_HANDRAIL_0_3,
                SPR_WOODEN_RC_LEFT_BANK_TO_LEFT_QUARTER_TURN_3_25_DEG_UP_FRONT_0_3,
                SPR_WOODEN_RC_LEFT_BANK_TO_LEFT_QUARTER_TURN_3_25_DEG_UP_FRONT_HANDRAIL_0_3,
            },
        } },
        { {
            {
                SPR_WOODEN_RC_LEFT_BANK_TO_LEFT_QUARTER_TURN_3_25_DEG_UP_1_0,
                SPR_WOODEN_RC_LEFT_BANK_TO_LEFT_QUARTER_TURN_3_25_DEG_UP_HANDRAIL_1_0,
            },
            {
                SPR_WOODEN_RC_LEFT_BANK_TO_LEFT_QUARTER_TURN_3_25_DEG_UP_1_1,
                SPR_WOODEN_RC_LEFT_BANK_TO_LEFT_QUARTER_TURN_3_25_DEG_UP_HANDRAIL_1_1,
                SPR_WOODEN_RC_LEFT_BANK_TO_LEFT_QUARTER_TURN_3_25_DEG_UP_FRONT_1_1,
                SPR_WOODEN_RC_LEFT_BANK_TO_LEFT_QUARTER_TURN_3_25_DEG_UP_FRONT_HANDRAIL_1_1,
            },
            {
                SPR_WOODEN_RC_LEFT_BANK_TO_LEFT_QUARTER_TURN_3_25_DEG_UP_1_2,
                SPR_WOODEN_RC_LEFT_BANK_TO_LEFT_QUARTER_TURN_3_25_DEG_UP_HANDRAIL_1_2,
                SPR_WOODEN_RC_LEFT_BANK_TO_LEFT_QUARTER_TURN_3_25_DEG_UP_FRONT_1_2,
                SPR_WOODEN_RC_LEFT_BANK_TO_LEFT_QUARTER_TURN_3_25_DEG_UP_FRONT_HANDRAIL_1_2,
            },
            {
                SPR_WOODEN_RC_LEFT_BANK_TO_LEFT_QUARTER_TURN_3_25_DEG_UP_1_3,
                SPR_WOODEN_RC_LEFT_BANK_TO_LEFT_QUARTER_TURN_3_25_DEG_UP_HANDRAIL_1_3,
                SPR_WOODEN_RC_LEFT_BANK_TO_LEFT_QUARTER_TURN_3_25_DEG_UP_FRONT_1_3,
                SPR_WOODEN_RC_LEFT_BANK_TO_LEFT_QUARTER_TURN_3_25_DEG_UP_FRONT_HANDRAIL_1_3,
            },
        } },
    } };

static constexpr std::array<std::array<WoodenTrackSection, kNumOrthogonalDirections>, 2>
    kRightBankToRightQuarterTurn325DegUpImages = { {
        { {
            {
                SPR_WOODEN_RC_RIGHT_BANK_TO_RIGHT_QUARTER_TURN_3_25_DEG_UP_0_0,
                SPR_WOODEN_RC_RIGHT_BANK_TO_RIGHT_QUARTER_TURN_3_25_DEG_UP_HANDRAIL_0_0,
                SPR_WOODEN_RC_RIGHT_BANK_TO_RIGHT_QUARTER_TURN_3_25_DEG_UP_FRONT_0_0,
                SPR_WOODEN_RC_RIGHT_BANK_TO_RIGHT_QUARTER_TURN_3_25_DEG_UP_FRONT_HANDRAIL_0_0,
            },
            {
                SPR_WOODEN_RC_RIGHT_BANK_TO_RIGHT_QUARTER_TURN_3_25_DEG_UP_0_1,
                SPR_WOODEN_RC_RIGHT_BANK_TO_RIGHT_QUARTER_TURN_3_25_DEG_UP_HANDRAIL_0_1,
            },
            {
                SPR_WOODEN_RC_RIGHT_BANK_TO_RIGHT_QUARTER_TURN_3_25_DEG_UP_0_2,
                SPR_WOODEN_RC_RIGHT_BANK_TO_RIGHT_QUARTER_TURN_3_25_DEG_UP_HANDRAIL_0_2,
                SPR_WOODEN_RC_RIGHT_BANK_TO_RIGHT_QUARTER_TURN_3_25_DEG_UP_FRONT_0_2,
                SPR_WOODEN_RC_RIGHT_BANK_TO_RIGHT_QUARTER_TURN_3_25_DEG_UP_FRONT_HANDRAIL_0_2,
            },
            {
                SPR_WOODEN_RC_RIGHT_BANK_TO_RIGHT_QUARTER_TURN_3_25_DEG_UP_0_3,
                SPR_WOODEN_RC_RIGHT_BANK_TO_RIGHT_QUARTER_TURN_3_25_DEG_UP_HANDRAIL_0_3,
            },
        } },
        { {
            {
                SPR_WOODEN_RC_RIGHT_BANK_TO_RIGHT_QUARTER_TURN_3_25_DEG_UP_1_0,
                SPR_WOODEN_RC_RIGHT_BANK_TO_RIGHT_QUARTER_TURN_3_25_DEG_UP_HANDRAIL_1_0,
                SPR_WOODEN_RC_RIGHT_BANK_TO_RIGHT_QUARTER_TURN_3_25_DEG_UP_FRONT_1_0,
                SPR_WOODEN_RC_RIGHT_BANK_TO_RIGHT_QUARTER_TURN_3_25_DEG_UP_FRONT_HANDRAIL_1_0,
            },
            {
                SPR_WOODEN_RC_RIGHT_BANK_TO_RIGHT_QUARTER_TURN_3_25_DEG_UP_1_1,
                SPR_WOODEN_RC_RIGHT_BANK_TO_RIGHT_QUARTER_TURN_3_25_DEG_UP_HANDRAIL_1_1,
                SPR_WOODEN_RC_RIGHT_BANK_TO_RIGHT_QUARTER_TURN_3_25_DEG_UP_FRONT_1_1,
                SPR_WOODEN_RC_RIGHT_BANK_TO_RIGHT_QUARTER_TURN_3_25_DEG_UP_FRONT_HANDRAIL_1_1,
            },
            {
                SPR_WOODEN_RC_RIGHT_BANK_TO_RIGHT_QUARTER_TURN_3_25_DEG_UP_1_2,
                SPR_WOODEN_RC_RIGHT_BANK_TO_RIGHT_QUARTER_TURN_3_25_DEG_UP_HANDRAIL_1_2,
                SPR_WOODEN_RC_RIGHT_BANK_TO_RIGHT_QUARTER_TURN_3_25_DEG_UP_FRONT_1_2,
                SPR_WOODEN_RC_RIGHT_BANK_TO_RIGHT_QUARTER_TURN_3_25_DEG_UP_FRONT_HANDRAIL_1_2,
            },
            {
                SPR_WOODEN_RC_RIGHT_BANK_TO_RIGHT_QUARTER_TURN_3_25_DEG_UP_1_3,
                SPR_WOODEN_RC_RIGHT_BANK_TO_RIGHT_QUARTER_TURN_3_25_DEG_UP_HANDRAIL_1_3,
            },
        } },
    } };

static constexpr std::array<WoodenTrackSection, kNumOrthogonalDirections> kDiagFlatToLeftBankImages = { {
    {
        SPR_WOODEN_RC_DIAG_FLAT_TO_LEFT_BANK_0,
        SPR_WOODEN_RC_DIAG_FLAT_TO_LEFT_BANK_HANDRAIL_0,
        SPR_WOODEN_RC_DIAG_FLAT_TO_LEFT_BANK_FRONT_0,
        SPR_WOODEN_RC_DIAG_FLAT_TO_LEFT_BANK_FRONT_HANDRAIL_0,
    },
    {
        SPR_WOODEN_RC_DIAG_FLAT_TO_LEFT_BANK_1,
        SPR_WOODEN_RC_DIAG_FLAT_TO_LEFT_BANK_HANDRAIL_1,
    },
    {
        SPR_WOODEN_RC_DIAG_FLAT_TO_LEFT_BANK_2,
        SPR_WOODEN_RC_DIAG_FLAT_TO_LEFT_BANK_HANDRAIL_2,
        SPR_WOODEN_RC_DIAG_FLAT_TO_LEFT_BANK_FRONT_2,
        SPR_WOODEN_RC_DIAG_FLAT_TO_LEFT_BANK_FRONT_HANDRAIL_2,
    },
    {
        SPR_WOODEN_RC_DIAG_FLAT_TO_LEFT_BANK_3,
        SPR_WOODEN_RC_DIAG_FLAT_TO_LEFT_BANK_HANDRAIL_3,
    },
} };

static constexpr std::array<WoodenTrackSection, kNumOrthogonalDirections> kDiagFlatToRightBankImages = { {
    {
        SPR_WOODEN_RC_DIAG_FLAT_TO_RIGHT_BANK_0,
        SPR_WOODEN_RC_DIAG_FLAT_TO_RIGHT_BANK_HANDRAIL_0,
        SPR_WOODEN_RC_DIAG_FLAT_TO_RIGHT_BANK_FRONT_0,
        SPR_WOODEN_RC_DIAG_FLAT_TO_RIGHT_BANK_FRONT_HANDRAIL_0,
    },
    {
        SPR_WOODEN_RC_DIAG_FLAT_TO_RIGHT_BANK_1,
        SPR_WOODEN_RC_DIAG_FLAT_TO_RIGHT_BANK_HANDRAIL_1,
    },
    {
        SPR_WOODEN_RC_DIAG_FLAT_TO_RIGHT_BANK_2,
        SPR_WOODEN_RC_DIAG_FLAT_TO_RIGHT_BANK_HANDRAIL_2,
        SPR_WOODEN_RC_DIAG_FLAT_TO_RIGHT_BANK_FRONT_2,
        SPR_WOODEN_RC_DIAG_FLAT_TO_RIGHT_BANK_FRONT_HANDRAIL_2,
    },
    {
        SPR_WOODEN_RC_DIAG_FLAT_TO_RIGHT_BANK_3,
        SPR_WOODEN_RC_DIAG_FLAT_TO_RIGHT_BANK_HANDRAIL_3,
    },
} };

static constexpr std::array<WoodenTrackSection, kNumOrthogonalDirections> kDiagLeftBankTo25DegUpImages = { {
    {
        SPR_WOODEN_RC_DIAG_LEFT_BANK_TO_25_DEG_UP_0,
        SPR_WOODEN_RC_DIAG_LEFT_BANK_TO_25_DEG_UP_HANDRAIL_0,
        SPR_WOODEN_RC_DIAG_LEFT_BANK_TO_25_DEG_UP_FRONT_0,
        SPR_WOODEN_RC_DIAG_LEFT_BANK_TO_25_DEG_UP_FRONT_HANDRAIL_0,
    },
    {
        SPR_WOODEN_RC_DIAG_LEFT_BANK_TO_25_DEG_UP_1,
        SPR_WOODEN_RC_DIAG_LEFT_BANK_TO_25_DEG_UP_HANDRAIL_1,
    },
    {
        SPR_WOODEN_RC_DIAG_LEFT_BANK_TO_25_DEG_UP_2,
        SPR_WOODEN_RC_DIAG_LEFT_BANK_TO_25_DEG_UP_HANDRAIL_2,
        SPR_WOODEN_RC_DIAG_LEFT_BANK_TO_25_DEG_UP_FRONT_2,
        SPR_WOODEN_RC_DIAG_LEFT_BANK_TO_25_DEG_UP_FRONT_HANDRAIL_2,
    },
    {
        SPR_WOODEN_RC_DIAG_LEFT_BANK_TO_25_DEG_UP_3,
        SPR_WOODEN_RC_DIAG_LEFT_BANK_TO_25_DEG_UP_HANDRAIL_3,
    },
} };

static constexpr std::array<WoodenTrackSection, kNumOrthogonalDirections> kDiagRightBankTo25DegUpImages = { {
    {
        SPR_WOODEN_RC_DIAG_RIGHT_BANK_TO_25_DEG_UP_0,
        SPR_WOODEN_RC_DIAG_RIGHT_BANK_TO_25_DEG_UP_HANDRAIL_0,
        SPR_WOODEN_RC_DIAG_RIGHT_BANK_TO_25_DEG_UP_FRONT_0,
        SPR_WOODEN_RC_DIAG_RIGHT_BANK_TO_25_DEG_UP_FRONT_HANDRAIL_0,
    },
    {
        SPR_WOODEN_RC_DIAG_RIGHT_BANK_TO_25_DEG_UP_1,
        SPR_WOODEN_RC_DIAG_RIGHT_BANK_TO_25_DEG_UP_HANDRAIL_1,
    },
    {
        SPR_WOODEN_RC_DIAG_RIGHT_BANK_TO_25_DEG_UP_2,
        SPR_WOODEN_RC_DIAG_RIGHT_BANK_TO_25_DEG_UP_HANDRAIL_2,
        SPR_WOODEN_RC_DIAG_RIGHT_BANK_TO_25_DEG_UP_FRONT_2,
        SPR_WOODEN_RC_DIAG_RIGHT_BANK_TO_25_DEG_UP_FRONT_HANDRAIL_2,
    },
    {
        SPR_WOODEN_RC_DIAG_RIGHT_BANK_TO_25_DEG_UP_3,
        SPR_WOODEN_RC_DIAG_RIGHT_BANK_TO_25_DEG_UP_HANDRAIL_3,
    },
} };

static constexpr std::array<WoodenTrackSection, kNumOrthogonalDirections> kDiagUp25ToLeftBankImages = { {
    {
        SPR_WOODEN_RC_DIAG_UP_25_TO_LEFT_BANK_0,
        SPR_WOODEN_RC_DIAG_UP_25_TO_LEFT_BANK_HANDRAIL_0,
        SPR_WOODEN_RC_DIAG_UP_25_TO_LEFT_BANK_FRONT_0,
        SPR_WOODEN_RC_DIAG_UP_25_TO_LEFT_BANK_FRONT_HANDRAIL_0,
    },
    {
        SPR_WOODEN_RC_DIAG_UP_25_TO_LEFT_BANK_1,
        SPR_WOODEN_RC_DIAG_UP_25_TO_LEFT_BANK_HANDRAIL_1,
    },
    {
        SPR_WOODEN_RC_DIAG_UP_25_TO_LEFT_BANK_2,
        SPR_WOODEN_RC_DIAG_UP_25_TO_LEFT_BANK_HANDRAIL_2,
        SPR_WOODEN_RC_DIAG_UP_25_TO_LEFT_BANK_FRONT_2,
        SPR_WOODEN_RC_DIAG_UP_25_TO_LEFT_BANK_FRONT_HANDRAIL_2,
    },
    {
        SPR_WOODEN_RC_DIAG_UP_25_TO_LEFT_BANK_3,
        SPR_WOODEN_RC_DIAG_UP_25_TO_LEFT_BANK_HANDRAIL_3,
    },
} };

static constexpr std::array<WoodenTrackSection, kNumOrthogonalDirections> kDiagUp25ToRightBankImages = { {
    {
        SPR_WOODEN_RC_DIAG_UP_25_TO_RIGHT_BANK_0,
        SPR_WOODEN_RC_DIAG_UP_25_TO_RIGHT_BANK_HANDRAIL_0,
        SPR_WOODEN_RC_DIAG_UP_25_TO_RIGHT_BANK_FRONT_0,
        SPR_WOODEN_RC_DIAG_UP_25_TO_RIGHT_BANK_FRONT_HANDRAIL_0,
    },
    {
        SPR_WOODEN_RC_DIAG_UP_25_TO_RIGHT_BANK_1,
        SPR_WOODEN_RC_DIAG_UP_25_TO_RIGHT_BANK_HANDRAIL_1,
    },
    {
        SPR_WOODEN_RC_DIAG_UP_25_TO_RIGHT_BANK_2,
        SPR_WOODEN_RC_DIAG_UP_25_TO_RIGHT_BANK_HANDRAIL_2,
        SPR_WOODEN_RC_DIAG_UP_25_TO_RIGHT_BANK_FRONT_2,
        SPR_WOODEN_RC_DIAG_UP_25_TO_RIGHT_BANK_FRONT_HANDRAIL_2,
    },
    {
        SPR_WOODEN_RC_DIAG_UP_25_TO_RIGHT_BANK_3,
        SPR_WOODEN_RC_DIAG_UP_25_TO_RIGHT_BANK_HANDRAIL_3,
    },
} };

static constexpr std::array<std::array<WoodenTrackSection, kNumOrthogonalDirections>, 4> kLeftEighthBankToDiagImages = { {
    { {
        {
            SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_0_0,
            SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_HANDRAIL_0_0,
        },
        {
            SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_0_1,
            SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_HANDRAIL_0_1,
            SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_FRONT_0_1,
            SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_FRONT_HANDRAIL_0_1,
        },
        {
            SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_0_2,
            SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_HANDRAIL_0_2,
        },
        {
            SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_0_3,
            SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_HANDRAIL_0_3,
            SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_FRONT_0_3,
            SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_FRONT_HANDRAIL_0_3,
        },
    } },
    { {
        {
            SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_1_0,
            SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_HANDRAIL_1_0,
        },
        {
            SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_1_1,
            SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_HANDRAIL_1_1,
            SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_FRONT_1_1,
            SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_FRONT_HANDRAIL_1_1,
        },
        {
            SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_1_2,
            SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_HANDRAIL_1_2,
        },
        {
            SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_1_3,
            SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_HANDRAIL_1_3,
            SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_FRONT_1_3,
            SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_FRONT_HANDRAIL_1_3,
        },
    } },
    { {
        {
            SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_2_0,
            SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_HANDRAIL_2_0,
        },
        {
            SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_2_1,
            SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_HANDRAIL_2_1,
            SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_FRONT_2_1,
            SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_FRONT_HANDRAIL_2_1,
        },
        {
            SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_2_2,
            SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_HANDRAIL_2_2,
        },
        {
            SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_2_3,
            SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_HANDRAIL_2_3,
            SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_FRONT_2_3,
            SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_FRONT_HANDRAIL_2_3,
        },
    } },
    { {
        {
            SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_3_0,
            SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_HANDRAIL_3_0,
        },
        {
            SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_3_1,
            SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_HANDRAIL_3_1,
            SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_FRONT_3_1,
            SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_FRONT_HANDRAIL_3_1,
        },
        {
            SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_3_2,
            SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_HANDRAIL_3_2,
        },
        {
            SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_3_3,
            SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_HANDRAIL_3_3,
            SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_FRONT_3_3,
            SPR_WOODEN_RC_LEFT_EIGHTH_BANK_TO_DIAG_FRONT_HANDRAIL_3_3,
        },
    } },
} };

static constexpr std::array<std::array<WoodenTrackSection, kNumOrthogonalDirections>, 4> kRightEighthBankToDiagImages = { {
    { {
        {
            SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_0_0,
            SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_HANDRAIL_0_0,
            SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_FRONT_0_0,
            SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_FRONT_HANDRAIL_0_0,
        },
        {
            SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_0_1,
            SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_HANDRAIL_0_1,
        },
        {
            SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_0_2,
            SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_HANDRAIL_0_2,
            SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_FRONT_0_2,
            SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_FRONT_HANDRAIL_0_2,
        },
        {
            SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_0_3,
            SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_HANDRAIL_0_3,
        },
    } },
    { {
        {
            SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_1_0,
            SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_HANDRAIL_1_0,
            SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_FRONT_1_0,
            SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_FRONT_HANDRAIL_1_0,
        },
        {
            SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_1_1,
            SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_HANDRAIL_1_1,
        },
        {
            SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_1_2,
            SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_HANDRAIL_1_2,
            SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_FRONT_1_2,
            SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_FRONT_HANDRAIL_1_2,
        },
        {
            SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_1_3,
            SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_HANDRAIL_1_3,
        },
    } },
    { {
        {
            SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_2_0,
            SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_HANDRAIL_2_0,
            SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_FRONT_2_0,
            SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_FRONT_HANDRAIL_2_0,
        },
        {
            SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_2_1,
            SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_HANDRAIL_2_1,
        },
        {
            SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_2_2,
            SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_HANDRAIL_2_2,
            SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_FRONT_2_2,
            SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_FRONT_HANDRAIL_2_2,
        },
        {
            SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_2_3,
            SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_HANDRAIL_2_3,
        },
    } },
    { {
        {
            SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_3_0,
            SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_HANDRAIL_3_0,
            SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_FRONT_3_0,
            SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_FRONT_HANDRAIL_3_0,
        },
        {
            SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_3_1,
            SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_HANDRAIL_3_1,
        },
        {
            SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_3_2,
            SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_HANDRAIL_3_2,
            SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_FRONT_3_2,
            SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_FRONT_HANDRAIL_3_2,
        },
        {
            SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_3_3,
            SPR_WOODEN_RC_RIGHT_EIGHTH_BANK_TO_DIAG_HANDRAIL_3_3,
        },
    } },
} };

ImageId WoodenRCGetRailsColour(PaintSession& session)
{
    return session.TrackColours;
}

/** rct2: 0x008AC568 */
template<bool isClassic>
static void WoodenRCTrackFlat(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    static constexpr uint32_t imageIds[4][2] = {
        { SPR_WOODEN_RC_FLAT_SW_NE, SPR_WOODEN_RC_FLAT_CHAIN_SW_NE },
        { SPR_WOODEN_RC_FLAT_NW_SE, SPR_WOODEN_RC_FLAT_CHAIN_NW_SE },
        { SPR_WOODEN_RC_FLAT_SW_NE, SPR_WOODEN_RC_FLAT_CHAIN_NE_SW },
        { SPR_WOODEN_RC_FLAT_NW_SE, SPR_WOODEN_RC_FLAT_CHAIN_SE_NW },
    };
    static constexpr uint32_t railsImageIds[4][2] = {
        { SPR_WOODEN_RC_FLAT_RAILS_SW_NE, SPR_WOODEN_RC_FLAT_CHAIN_RAILS_SW_NE },
        { SPR_WOODEN_RC_FLAT_RAILS_NW_SE, SPR_WOODEN_RC_FLAT_CHAIN_RAILS_NW_SE },
        { SPR_WOODEN_RC_FLAT_RAILS_SW_NE, SPR_WOODEN_RC_FLAT_CHAIN_RAILS_NE_SW },
        { SPR_WOODEN_RC_FLAT_RAILS_NW_SE, SPR_WOODEN_RC_FLAT_CHAIN_RAILS_SE_NW },
    };

    uint8_t isChained = trackElement.HasChain() ? 1 : 0;
    WoodenRCTrackPaint<isClassic>(
        session, direction, imageIds[direction][isChained], railsImageIds[direction][isChained], { 0, 2, height },
        { { 0, 3, height }, { 32, 25, 2 } });
    WoodenASupportsPaintSetupRotated(
        session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours);
    PaintUtilPushTunnelRotated(session, direction, height, kTunnelGroup, TunnelSubType::Flat);
    PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + kDefaultGeneralSupportHeight);
}

template<bool isClassic>
static void WoodenRCTrackStation(
    PaintSession& session, const Ride& ride, [[maybe_unused]] uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    static constexpr ImageIndex stationImageIds[2][kNumOrthogonalDirections] = {
        {
            SPR_TRACKS_WOODEN_RC_STATION_NO_PLATFORM_SW_NE,
            SPR_TRACKS_WOODEN_RC_STATION_NO_PLATFORM_NW_SE,
            SPR_TRACKS_WOODEN_RC_STATION_NO_PLATFORM_SW_NE,
            SPR_TRACKS_WOODEN_RC_STATION_NO_PLATFORM_NW_SE,
        },
        {
            SPR_WOODEN_RC_STATION_SW_NE,
            SPR_WOODEN_RC_STATION_NW_SE,
            SPR_WOODEN_RC_STATION_SW_NE,
            SPR_WOODEN_RC_STATION_NW_SE,
        },
    };
    const bool drewStation = TrackPaintUtilDrawStation2(
        session, ride, direction, height, trackElement, StationBaseType::none, 0, 9, 11);
    const ImageId colours = isClassic ? session.TrackColours : session.SupportColours;
    if (trackElement.GetTrackType() == TrackElemType::EndStation)
    {
        const ImageIndex imageIndex = kStationBlockBrakesImageIds[drewStation][direction][trackElement.IsBrakeClosed()];
        PaintAddImageAsParentRotated(
            session, direction, colours.WithIndex(imageIndex), { 0, 2, height }, { { 0, 2, height }, { 32, 27, 2 } });
    }
    else
    {
        PaintAddImageAsParentRotated(
            session, direction, colours.WithIndex(stationImageIds[drewStation][direction]), { 0, 2, height },
            { { 0, 2, height }, { 32, 27, 2 } });
    }
    WoodenASupportsPaintSetupRotated(
        session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours);
    TrackPaintUtilDrawStationTunnel(session, direction, height);
    PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + kDefaultGeneralSupportHeight);
}

/** rct2: 0x008AC578 */
template<bool isClassic>
static void WoodenRCTrack25DegUp(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    static constexpr uint32_t imageIds[2][4][4] = {
        {
            {
                SPR_WOODEN_RC_25_DEG_SW_NE,
                SPR_WOODEN_RC_25_DEG_RAILS_SW_NE,
                0,
                0,
            },
            {
                SPR_WOODEN_RC_25_DEG_NW_SE,
                SPR_WOODEN_RC_25_DEG_RAILS_NW_SE,
                SPR_WOODEN_RC_25_DEG_FRONT_NW_SE,
                SPR_WOODEN_RC_25_DEG_RAILS_FRONT_NW_SE,
            },
            {
                SPR_WOODEN_RC_25_DEG_NE_SW,
                SPR_WOODEN_RC_25_DEG_RAILS_NE_SW,
                SPR_WOODEN_RC_25_DEG_FRONT_NE_SW,
                SPR_WOODEN_RC_25_DEG_RAILS_FRONT_NE_SW,
            },
            {
                SPR_WOODEN_RC_25_DEG_SE_NW,
                SPR_WOODEN_RC_25_DEG_RAILS_SE_NW,
                0,
                0,
            },
        },
        {
            {
                SPR_WOODEN_RC_25_DEG_CHAIN_SW_NE,
                SPR_WOODEN_RC_25_DEG_CHAIN_RAILS_SW_NE,
                0,
                0,
            },
            {
                SPR_WOODEN_RC_25_DEG_CHAIN_NW_SE,
                SPR_WOODEN_RC_25_DEG_CHAIN_RAILS_NW_SE,
                SPR_WOODEN_RC_25_DEG_CHAIN_FRONT_NW_SE,
                SPR_WOODEN_RC_25_DEG_CHAIN_RAILS_FRONT_NW_SE,
            },
            {
                SPR_WOODEN_RC_25_DEG_CHAIN_NE_SW,
                SPR_WOODEN_RC_25_DEG_CHAIN_RAILS_NE_SW,
                SPR_WOODEN_RC_25_DEG_CHAIN_FRONT_NE_SW,
                SPR_WOODEN_RC_25_DEG_CHAIN_RAILS_FRONT_NE_SW,
            },
            {
                SPR_WOODEN_RC_25_DEG_CHAIN_SE_NW,
                SPR_WOODEN_RC_25_DEG_CHAIN_RAILS_SE_NW,
                0,
                0,
            },
        },
    };

    uint8_t isChained = trackElement.HasChain() ? 1 : 0;
    WoodenRCTrackPaint<isClassic>(
        session, direction, imageIds[isChained][direction][0], imageIds[isChained][direction][1], { 0, 0, height },
        { { 0, 3, height }, { 32, 25, 2 } });
    if (direction == 1 || direction == 2)
    {
        WoodenRCTrackPaint<isClassic>(
            session, direction, imageIds[isChained][direction][2], imageIds[isChained][direction][3], { 0, 0, height },
            { { 0, 26, height + 5 }, { 32, 1, 9 } });
    }
    WoodenASupportsPaintSetupRotated(
        session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
        WoodenSupportTransitionType::up25Deg);

    if (direction == 0 || direction == 3)
    {
        PaintUtilPushTunnelRotated(session, direction, height - 8, kTunnelGroup, TunnelSubType::SlopeStart);
    }
    else
    {
        PaintUtilPushTunnelRotated(session, direction, height + 8, kTunnelGroup, TunnelSubType::SlopeEnd);
    }

    PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + 56);
}

/** rct2: 0x008AC588 */
template<bool isClassic>
static void WoodenRCTrack60DegUp(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    static constexpr uint32_t imageIdsChained[4][2] = {
        { SPR_TRACKS_WOODEN_RC_60_SWNE_CHAINED, SPR_WOODEN_RC_60_DEG_RAILS_SW_NE },
        { SPR_TRACKS_WOODEN_RC_60_SWNE_CHAINED_BACK, SPR_WOODEN_RC_60_DEG_RAILS_NW_SE },
        { SPR_TRACKS_WOODEN_RC_60_SENW_CHAINED_BACK, SPR_WOODEN_RC_60_DEG_RAILS_NE_SW },
        { SPR_TRACKS_WOODEN_RC_60_SENW_CHAINED, SPR_WOODEN_RC_60_DEG_RAILS_SE_NW },
    };

    static constexpr uint32_t imageIds[4][2] = {
        { SPR_WOODEN_RC_60_DEG_SW_NE, SPR_WOODEN_RC_60_DEG_RAILS_SW_NE },
        { SPR_WOODEN_RC_60_DEG_NW_SE, SPR_WOODEN_RC_60_DEG_RAILS_NW_SE },
        { SPR_WOODEN_RC_60_DEG_NE_SW, SPR_WOODEN_RC_60_DEG_RAILS_NE_SW },
        { SPR_WOODEN_RC_60_DEG_SE_NW, SPR_WOODEN_RC_60_DEG_RAILS_SE_NW },
    };

    if (trackElement.HasChain())
    {
        if (direction == 0 || direction == 3)
        {
            WoodenRCTrackPaint<isClassic>(
                session, direction, imageIdsChained[direction][0], imageIdsChained[direction][1], { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
        }
        else
        {
            session.WoodenSupportsPrependTo = WoodenRCTrackPaint<isClassic>(
                session, direction, imageIdsChained[direction][0], imageIdsChained[direction][1], { 0, 0, height },
                { { 28, 4, height - 16 }, { 2, 24, 93 } });
        }
    }
    else
    {
        if (direction == 0 || direction == 3)
        {
            WoodenRCTrackPaint<isClassic>(
                session, direction, imageIds[direction][0], imageIds[direction][1], { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
        }
        else
        {
            session.WoodenSupportsPrependTo = WoodenRCTrackPaint<isClassic>(
                session, direction, imageIds[direction][0], imageIds[direction][1], { 0, 0, height },
                { { 28, 4, height - 16 }, { 2, 24, 93 } });
        }
    }

    WoodenASupportsPaintSetupRotated(
        session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
        WoodenSupportTransitionType::up60Deg);

    if (direction == 0 || direction == 3)
    {
        PaintUtilPushTunnelRotated(session, direction, height - 8, kTunnelGroup, TunnelSubType::SlopeStart);
    }
    else
    {
        PaintUtilPushTunnelRotated(session, direction, height + 56, kTunnelGroup, TunnelSubType::SlopeEnd);
    }

    PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + 104);
}

/** rct2: 0x008AC598 */
template<bool isClassic>
static void WoodenRCTrackFlatTo25DegUp(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    static constexpr uint32_t imageIds[2][4][4] = {
        {
            {
                SPR_WOODEN_RC_FLAT_TO_25_DEG_SW_NE,
                SPR_WOODEN_RC_FLAT_TO_25_DEG_RAILS_SW_NE,
                0,
                0,
            },
            {
                SPR_WOODEN_RC_FLAT_TO_25_DEG_NW_SE,
                SPR_WOODEN_RC_FLAT_TO_25_DEG_RAILS_NW_SE,
                SPR_WOODEN_RC_FLAT_TO_25_DEG_FRONT_NW_SE,
                SPR_WOODEN_RC_FLAT_TO_25_DEG_RAILS_FRONT_NW_SE,
            },
            {
                SPR_WOODEN_RC_FLAT_TO_25_DEG_NE_SW,
                SPR_WOODEN_RC_FLAT_TO_25_DEG_RAILS_NE_SW,
                SPR_WOODEN_RC_FLAT_TO_25_DEG_FRONT_NE_SW,
                SPR_WOODEN_RC_FLAT_TO_25_DEG_RAILS_FRONT_NE_SW,
            },
            {
                SPR_WOODEN_RC_FLAT_TO_25_DEG_SE_NW,
                SPR_WOODEN_RC_FLAT_TO_25_DEG_RAILS_SE_NW,
                0,
                0,
            },
        },
        {
            {
                SPR_WOODEN_RC_FLAT_TO_25_DEG_CHAIN_SW_NE,
                SPR_WOODEN_RC_FLAT_TO_25_DEG_CHAIN_RAILS_SW_NE,
                0,
                0,
            },
            {
                SPR_WOODEN_RC_FLAT_TO_25_DEG_CHAIN_NW_SE,
                SPR_WOODEN_RC_FLAT_TO_25_DEG_CHAIN_RAILS_NW_SE,
                SPR_WOODEN_RC_FLAT_TO_25_DEG_CHAIN_FRONT_NW_SE,
                SPR_WOODEN_RC_FLAT_TO_25_DEG_CHAIN_RAILS_FRONT_NW_SE,
            },
            {
                SPR_WOODEN_RC_FLAT_TO_25_DEG_CHAIN_NE_SW,
                SPR_WOODEN_RC_FLAT_TO_25_DEG_CHAIN_RAILS_NE_SW,
                SPR_WOODEN_RC_FLAT_TO_25_DEG_CHAIN_FRONT_NE_SW,
                SPR_WOODEN_RC_FLAT_TO_25_DEG_CHAIN_RAILS_FRONT_NE_SW,
            },
            {
                SPR_WOODEN_RC_FLAT_TO_25_DEG_CHAIN_SE_NW,
                SPR_WOODEN_RC_FLAT_TO_25_DEG_CHAIN_RAILS_SE_NW,
                0,
                0,
            },
        },
    };

    uint8_t isChained = trackElement.HasChain() ? 1 : 0;
    WoodenRCTrackPaint<isClassic>(
        session, direction, imageIds[isChained][direction][0], imageIds[isChained][direction][1], { 0, 0, height },
        { { 0, 3, height }, { 32, 25, 2 } });
    if (direction == 1 || direction == 2)
    {
        WoodenRCTrackPaint<isClassic>(
            session, direction, imageIds[isChained][direction][2], imageIds[isChained][direction][3], { 0, 0, height },
            { { 0, 26, height + 5 }, { 32, 1, 9 } });
    }
    WoodenASupportsPaintSetupRotated(
        session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
        WoodenSupportTransitionType::flatToUp25Deg);

    if (direction == 0 || direction == 3)
    {
        PaintUtilPushTunnelRotated(session, direction, height, kTunnelGroup, TunnelSubType::Flat);
    }
    else
    {
        PaintUtilPushTunnelRotated(session, direction, height, kTunnelGroup, TunnelSubType::SlopeEnd);
    }

    PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + 48);
}

/** rct2: 0x008AC5A8 */
template<bool isClassic>
static void WoodenRCTrack25DegUpTo60DegUp(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    static constexpr uint32_t imageIdsChained[4][4] = {
        {
            SPR_TRACKS_WOODEN_RC_25_60_SWNE_CHAINED,
            SPR_WOODEN_RC_25_DEG_TO_60_DEG_RAILS_SW_NE,
            0,
            0,
        },
        {
            SPR_WOODEN_RC_25_DEG_TO_60_DEG_NW_SE,
            SPR_WOODEN_RC_25_DEG_TO_60_DEG_RAILS_NW_SE,
            SPR_TRACKS_WOODEN_RC_25_60_SENW_CHAINED_BACK,
            SPR_WOODEN_RC_25_DEG_TO_60_DEG_RAILS_FRONT_NW_SE,
        },
        {
            SPR_WOODEN_RC_25_DEG_TO_60_DEG_NE_SW,
            SPR_WOODEN_RC_25_DEG_TO_60_DEG_RAILS_NE_SW,
            SPR_TRACKS_WOODEN_RC_25_60_SWNE_CHAINED_BACK,
            SPR_WOODEN_RC_25_DEG_TO_60_DEG_RAILS_FRONT_NE_SW,
        },
        {
            SPR_TRACKS_WOODEN_RC_25_60_SENW_CHAINED,
            SPR_WOODEN_RC_25_DEG_TO_60_DEG_RAILS_SE_NW,
            0,
            0,
        },
    };

    static constexpr uint32_t imageIds[4][4] = {
        {
            SPR_WOODEN_RC_25_DEG_TO_60_DEG_SW_NE,
            SPR_WOODEN_RC_25_DEG_TO_60_DEG_RAILS_SW_NE,
            0,
            0,
        },
        {
            SPR_WOODEN_RC_25_DEG_TO_60_DEG_NW_SE,
            SPR_WOODEN_RC_25_DEG_TO_60_DEG_RAILS_NW_SE,
            SPR_WOODEN_RC_25_DEG_TO_60_DEG_FRONT_NW_SE,
            SPR_WOODEN_RC_25_DEG_TO_60_DEG_RAILS_FRONT_NW_SE,
        },
        {
            SPR_WOODEN_RC_25_DEG_TO_60_DEG_NE_SW,
            SPR_WOODEN_RC_25_DEG_TO_60_DEG_RAILS_NE_SW,
            SPR_WOODEN_RC_25_DEG_TO_60_DEG_FRONT_NE_SW,
            SPR_WOODEN_RC_25_DEG_TO_60_DEG_RAILS_FRONT_NE_SW,
        },
        {
            SPR_WOODEN_RC_25_DEG_TO_60_DEG_SE_NW,
            SPR_WOODEN_RC_25_DEG_TO_60_DEG_RAILS_SE_NW,
            0,
            0,
        },
    };
    if (trackElement.HasChain())
    {
        if (direction == 0 || direction == 3)
        {
            WoodenRCTrackPaint<isClassic>(
                session, direction, imageIdsChained[direction][0], imageIdsChained[direction][1], { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
        }
        else
        {
            session.WoodenSupportsPrependTo = WoodenRCTrackPaint<isClassic>(
                session, direction, imageIdsChained[direction][0], imageIdsChained[direction][1], { 0, 0, height },
                { { 28, 4, height + 2 }, { 2, 24, 43 } });
            WoodenRCTrackPaint<isClassic>(
                session, direction, imageIdsChained[direction][2], imageIdsChained[direction][3], { 0, 0, height },
                { { 0, 4, height }, { 32, 2, 43 } });
        }
    }
    else
    {
        if (direction == 0 || direction == 3)
        {
            WoodenRCTrackPaint<isClassic>(
                session, direction, imageIds[direction][0], imageIds[direction][1], { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
        }
        else
        {
            session.WoodenSupportsPrependTo = WoodenRCTrackPaint<isClassic>(
                session, direction, imageIds[direction][0], imageIds[direction][1], { 0, 0, height },
                { { 28, 4, height + 2 }, { 2, 24, 43 } });
            WoodenRCTrackPaint<isClassic>(
                session, direction, imageIds[direction][2], imageIds[direction][3], { 0, 0, height },
                { { 0, 4, height }, { 32, 2, 43 } });
        }
    }

    WoodenASupportsPaintSetupRotated(
        session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
        WoodenSupportTransitionType::up25DegToUp60Deg);

    if (direction == 0 || direction == 3)
    {
        PaintUtilPushTunnelRotated(session, direction, height - 8, kTunnelGroup, TunnelSubType::SlopeStart);
    }
    else
    {
        PaintUtilPushTunnelRotated(session, direction, height + 24, kTunnelGroup, TunnelSubType::SlopeEnd);
    }

    PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + 72);
}

/** rct2: 0x008AC5B8 */
template<bool isClassic>
static void WoodenRCTrack60DegUpTo25DegUp(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    static constexpr uint32_t imageIdsChained[4][4] = {
        {
            SPR_TRACKS_WOODEN_RC_60_25_SWNE_CHAINED,
            SPR_WOODEN_RC_60_DEG_TO_25_DEG_RAILS_SW_NE,
            0,
            0,
        },
        {
            SPR_WOODEN_RC_60_DEG_TO_25_DEG_NW_SE,
            SPR_WOODEN_RC_60_DEG_TO_25_DEG_RAILS_NW_SE,
            SPR_TRACKS_WOODEN_RC_60_25_SWNE_CHAINED_BACK,
            SPR_WOODEN_RC_60_DEG_TO_25_DEG_RAILS_FRONT_NW_SE,
        },
        {
            SPR_WOODEN_RC_60_DEG_TO_25_DEG_NE_SW,
            SPR_WOODEN_RC_60_DEG_TO_25_DEG_RAILS_NE_SW,
            SPR_TRACKS_WOODEN_RC_60_25_SENW_CHAINED_BACK,
            SPR_WOODEN_RC_60_DEG_TO_25_DEG_RAILS_FRONT_NE_SW,
        },
        {
            SPR_TRACKS_WOODEN_RC_60_25_SENW_CHAINED,
            SPR_WOODEN_RC_60_DEG_TO_25_DEG_RAILS_SE_NW,
            0,
            0,
        },
    };

    static constexpr uint32_t imageIds[4][4] = {
        {
            SPR_WOODEN_RC_60_DEG_TO_25_DEG_SW_NE,
            SPR_WOODEN_RC_60_DEG_TO_25_DEG_RAILS_SW_NE,
            0,
            0,
        },
        {
            SPR_WOODEN_RC_60_DEG_TO_25_DEG_NW_SE,
            SPR_WOODEN_RC_60_DEG_TO_25_DEG_RAILS_NW_SE,
            SPR_WOODEN_RC_60_DEG_TO_25_DEG_FRONT_NW_SE,
            SPR_WOODEN_RC_60_DEG_TO_25_DEG_RAILS_FRONT_NW_SE,
        },
        {
            SPR_WOODEN_RC_60_DEG_TO_25_DEG_NE_SW,
            SPR_WOODEN_RC_60_DEG_TO_25_DEG_RAILS_NE_SW,
            SPR_WOODEN_RC_60_DEG_TO_25_DEG_FRONT_NE_SW,
            SPR_WOODEN_RC_60_DEG_TO_25_DEG_RAILS_FRONT_NE_SW,
        },
        {
            SPR_WOODEN_RC_60_DEG_TO_25_DEG_SE_NW,
            SPR_WOODEN_RC_60_DEG_TO_25_DEG_RAILS_SE_NW,
            0,
            0,
        },
    };

    if (trackElement.HasChain())
    {
        if (direction == 0 || direction == 3)
        {
            WoodenRCTrackPaint<isClassic>(
                session, direction, imageIdsChained[direction][0], imageIdsChained[direction][1], { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
        }
        else
        {
            session.WoodenSupportsPrependTo = WoodenRCTrackPaint<isClassic>(
                session, direction, imageIdsChained[direction][0], imageIdsChained[direction][1], { 0, 0, height },
                { { 28, 4, height + 2 }, { 2, 24, 43 } });
            WoodenRCTrackPaint<isClassic>(
                session, direction, imageIdsChained[direction][2], imageIdsChained[direction][3], { 0, 0, height },
                { { 0, 4, height }, { 32, 2, 43 } });
        }
    }
    else
    {
        if (direction == 0 || direction == 3)
        {
            WoodenRCTrackPaint<isClassic>(
                session, direction, imageIds[direction][0], imageIds[direction][1], { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
        }
        else
        {
            session.WoodenSupportsPrependTo = WoodenRCTrackPaint<isClassic>(
                session, direction, imageIds[direction][0], imageIds[direction][1], { 0, 0, height },
                { { 28, 4, height + 2 }, { 2, 24, 43 } });
            WoodenRCTrackPaint<isClassic>(
                session, direction, imageIds[direction][2], imageIds[direction][3], { 0, 0, height },
                { { 0, 4, height }, { 32, 2, 43 } });
        }
    }

    WoodenASupportsPaintSetupRotated(
        session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
        WoodenSupportTransitionType::up60DegToUp25Deg);

    if (direction == 0 || direction == 3)
    {
        PaintUtilPushTunnelRotated(session, direction, height - 8, kTunnelGroup, TunnelSubType::SlopeStart);
    }
    else
    {
        PaintUtilPushTunnelRotated(session, direction, height + 24, kTunnelGroup, TunnelSubType::SlopeEnd);
    }

    PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + 72);
}

/** rct2: 0x008AC5C8 */
template<bool isClassic>
static void WoodenRCTrack25DegUpToFlat(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    static constexpr uint32_t imageIds[2][4][4] = {
        {
            {
                SPR_WOODEN_RC_25_DEG_TO_FLAT_SW_NE,
                SPR_WOODEN_RC_25_DEG_TO_FLAT_RAILS_SW_NE,
                0,
                0,
            },
            {
                SPR_WOODEN_RC_25_DEG_TO_FLAT_NW_SE,
                SPR_WOODEN_RC_25_DEG_TO_FLAT_RAILS_NW_SE,
                SPR_WOODEN_RC_25_DEG_TO_FLAT_FRONT_NW_SE,
                SPR_WOODEN_RC_25_DEG_TO_FLAT_RAILS_FRONT_NW_SE,
            },
            {
                SPR_WOODEN_RC_25_DEG_TO_FLAT_NE_SW,
                SPR_WOODEN_RC_25_DEG_TO_FLAT_RAILS_NE_SW,
                SPR_WOODEN_RC_25_DEG_TO_FLAT_FRONT_NE_SW,
                SPR_WOODEN_RC_25_DEG_TO_FLAT_RAILS_FRONT_NE_SW,
            },
            {
                SPR_WOODEN_RC_25_DEG_TO_FLAT_SE_NW,
                SPR_WOODEN_RC_25_DEG_TO_FLAT_RAILS_SE_NW,
                0,
                0,
            },
        },
        {
            {
                SPR_WOODEN_RC_25_DEG_TO_FLAT_CHAIN_SW_NE,
                SPR_WOODEN_RC_25_DEG_TO_FLAT_CHAIN_RAILS_SW_NE,
                0,
                0,
            },
            {
                SPR_WOODEN_RC_25_DEG_TO_FLAT_CHAIN_NW_SE,
                SPR_WOODEN_RC_25_DEG_TO_FLAT_CHAIN_RAILS_NW_SE,
                SPR_WOODEN_RC_25_DEG_TO_FLAT_CHAIN_FRONT_NW_SE,
                SPR_WOODEN_RC_25_DEG_TO_FLAT_CHAIN_RAILS_FRONT_NW_SE,
            },
            {
                SPR_WOODEN_RC_25_DEG_TO_FLAT_CHAIN_NE_SW,
                SPR_WOODEN_RC_25_DEG_TO_FLAT_CHAIN_RAILS_NE_SW,
                SPR_WOODEN_RC_25_DEG_TO_FLAT_CHAIN_FRONT_NE_SW,
                SPR_WOODEN_RC_25_DEG_TO_FLAT_CHAIN_RAILS_FRONT_NE_SW,
            },
            {
                SPR_WOODEN_RC_25_DEG_TO_FLAT_CHAIN_SE_NW,
                SPR_WOODEN_RC_25_DEG_TO_FLAT_CHAIN_RAILS_SE_NW,
                0,
                0,
            },
        },
    };

    uint8_t isChained = trackElement.HasChain() ? 1 : 0;
    WoodenRCTrackPaint<isClassic>(
        session, direction, imageIds[isChained][direction][0], imageIds[isChained][direction][1], { 0, 0, height },
        { { 0, 3, height }, { 32, 25, 2 } });
    if (direction == 1 || direction == 2)
    {
        WoodenRCTrackPaint<isClassic>(
            session, direction, imageIds[isChained][direction][2], imageIds[isChained][direction][3], { 0, 0, height },
            { { 0, 26, height + 5 }, { 32, 1, 9 } });
    }
    WoodenASupportsPaintSetupRotated(
        session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
        WoodenSupportTransitionType::up25DegToFlat);

    if (direction == 0 || direction == 3)
    {
        PaintUtilPushTunnelRotated(session, direction, height - 8, kTunnelGroup, TunnelSubType::Flat);
    }
    else
    {
        PaintUtilPushTunnelRotated(session, direction, height + 8, kTunnelGroup, TunnelSubType::FlatTo25Deg);
    }

    PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + 40);
}

/** rct2: 0x008AC5D8 */
template<bool isClassic>
static void WoodenRCTrack25DegDown(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    WoodenRCTrack25DegUp<isClassic>(session, ride, trackSequence, (direction + 2) & 3, height, trackElement, supportType);
}

/** rct2: 0x008AC5E8 */
template<bool isClassic>
static void WoodenRCTrack60DegDown(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    WoodenRCTrack60DegUp<isClassic>(session, ride, trackSequence, (direction + 2) & 3, height, trackElement, supportType);
}

/** rct2: 0x008AC5F8 */
template<bool isClassic>
static void WoodenRCTrackFlatTo25DegDown(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    WoodenRCTrack25DegUpToFlat<isClassic>(session, ride, trackSequence, (direction + 2) & 3, height, trackElement, supportType);
}

/** rct2: 0x008AC608 */
template<bool isClassic>
static void WoodenRCTrack25DegDownTo60DegDown(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    WoodenRCTrack60DegUpTo25DegUp<isClassic>(
        session, ride, trackSequence, (direction + 2) & 3, height, trackElement, supportType);
}

/** rct2: 0x008AC618 */
template<bool isClassic>
static void WoodenRCTrack60DegDownTo25DegDown(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    WoodenRCTrack25DegUpTo60DegUp<isClassic>(
        session, ride, trackSequence, (direction + 2) & 3, height, trackElement, supportType);
}

/** rct2: 0x008AC628 */
template<bool isClassic>
static void WoodenRCTrack25DegDownToFlat(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    WoodenRCTrackFlatTo25DegUp<isClassic>(session, ride, trackSequence, (direction + 2) & 3, height, trackElement, supportType);
}

template<bool isClassic>
static void WoodenRCTrackRightQuarterTurn5(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    static constexpr SpriteBoundBox2 imageIds[2][4][7] = {
        {
            {
                {
                    SPR_WOODEN_RC_QUARTER_TURN_5_SW_SE_SEQ_0,
                    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_SW_SE_SEQ_0,
                    { 0, 2, 0 },
                    BoundBoxXYZ({ 0, 2, 0 }, { 32, 32, 2 }),
                },
                {
                    0,
                    0,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }),
                },
                {
                    SPR_WOODEN_RC_QUARTER_TURN_5_SW_SE_SEQ_2,
                    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_SW_SE_SEQ_2,
                    { 0, 16, 0 },
                    BoundBoxXYZ({ 0, 16, 0 }, { 32, 16, 2 }),
                },
                {
                    SPR_WOODEN_RC_QUARTER_TURN_5_SW_SE_SEQ_3,
                    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_SW_SE_SEQ_3,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 0, 0 }, { 16, 16, 2 }),
                },
                {
                    0,
                    0,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }),
                },
                {
                    SPR_WOODEN_RC_QUARTER_TURN_5_SW_SE_SEQ_5,
                    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_SW_SE_SEQ_5,
                    { 16, 0, 0 },
                    BoundBoxXYZ({ 16, 0, 0 }, { 16, 32, 2 }),
                },
                {
                    SPR_WOODEN_RC_QUARTER_TURN_5_SW_SE_SEQ_6,
                    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_SW_SE_SEQ_6,
                    { 2, 0, 0 },
                    BoundBoxXYZ({ 2, 0, 0 }, { 32, 32, 2 }),
                },
            },
            {
                {
                    SPR_WOODEN_RC_QUARTER_TURN_5_NW_SW_SEQ_0,
                    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_NW_SW_SEQ_0,
                    { 2, 0, 0 },
                    BoundBoxXYZ({ 2, 0, 0 }, { 32, 32, 2 }),
                },
                {
                    0,
                    0,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }),
                },
                {
                    SPR_WOODEN_RC_QUARTER_TURN_5_NW_SW_SEQ_2,
                    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_NW_SW_SEQ_2,
                    { 16, 0, 0 },
                    BoundBoxXYZ({ 16, 0, 0 }, { 16, 34, 2 }),
                },
                {
                    SPR_WOODEN_RC_QUARTER_TURN_5_NW_SW_SEQ_3,
                    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_NW_SW_SEQ_3,
                    { 0, 16, 0 },
                    BoundBoxXYZ({ 0, 16, 0 }, { 16, 16, 2 }),
                },
                {
                    0,
                    0,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }),
                },
                {
                    SPR_WOODEN_RC_QUARTER_TURN_5_NW_SW_SEQ_5,
                    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_NW_SW_SEQ_5,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 0, 0 }, { 32, 16, 2 }),
                },
                {
                    SPR_WOODEN_RC_QUARTER_TURN_5_NW_SW_SEQ_6,
                    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_NW_SW_SEQ_6,
                    { 0, 2, 0 },
                    BoundBoxXYZ({ 0, 2, 0 }, { 32, 27, 2 }),
                },
            },
            {
                {
                    SPR_WOODEN_RC_QUARTER_TURN_5_NE_NW_SEQ_0,
                    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_NE_NW_SEQ_0,
                    { 0, 2, 0 },
                    BoundBoxXYZ({ 0, 2, 0 }, { 32, 27, 2 }),
                },
                {
                    0,
                    0,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }),
                },
                {
                    SPR_WOODEN_RC_QUARTER_TURN_5_NE_NW_SEQ_2,
                    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_NE_NW_SEQ_2,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 0, 0 }, { 32, 16, 2 }),
                },
                {
                    SPR_WOODEN_RC_QUARTER_TURN_5_NE_NW_SEQ_3,
                    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_NE_NW_SEQ_3,
                    { 16, 16, 0 },
                    BoundBoxXYZ({ 16, 16, 0 }, { 16, 16, 2 }),
                },
                {
                    0,
                    0,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }),
                },
                {
                    SPR_WOODEN_RC_QUARTER_TURN_5_NE_NW_SEQ_5,
                    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_NE_NW_SEQ_5,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 0, 0 }, { 16, 32, 2 }),
                },
                {
                    SPR_WOODEN_RC_QUARTER_TURN_5_NE_NW_SEQ_6,
                    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_NE_NW_SEQ_6,
                    { 2, 0, 0 },
                    BoundBoxXYZ({ 2, 0, 0 }, { 27, 32, 2 }),
                },
            },
            {
                {
                    SPR_WOODEN_RC_QUARTER_TURN_5_SE_NE_SEQ_0,
                    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_SE_NE_SEQ_0,
                    { 2, 0, 0 },
                    BoundBoxXYZ({ 2, 0, 0 }, { 27, 32, 2 }),
                },
                {
                    0,
                    0,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }),
                },
                {
                    SPR_WOODEN_RC_QUARTER_TURN_5_SE_NE_SEQ_2,
                    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_SE_NE_SEQ_2,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 0, 0 }, { 16, 32, 2 }),
                },
                {
                    SPR_WOODEN_RC_QUARTER_TURN_5_SE_NE_SEQ_3,
                    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_SE_NE_SEQ_3,
                    { 16, 0, 0 },
                    BoundBoxXYZ({ 16, 0, 0 }, { 16, 16, 2 }),
                },
                {
                    0,
                    0,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }),
                },
                {
                    SPR_WOODEN_RC_QUARTER_TURN_5_SE_NE_SEQ_5,
                    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_SE_NE_SEQ_5,
                    { 0, 16, 0 },
                    BoundBoxXYZ({ 0, 16, 0 }, { 32, 16, 2 }),
                },
                {
                    SPR_WOODEN_RC_QUARTER_TURN_5_SE_NE_SEQ_6,
                    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_SE_NE_SEQ_6,
                    { 0, 2, 0 },
                    BoundBoxXYZ({ 0, 2, 0 }, { 32, 32, 2 }),
                },
            },
        },
        {
            {
                {
                    SPR_WOODEN_RC_QUARTER_TURN_5_FRONT_SW_SE_SEQ_0,
                    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_FRONT_SW_SE_SEQ_0,
                    { 0, 2, 0 },
                    BoundBoxXYZ({ 0, 2, 27 }, { 32, 32, 0 }),
                },
                {
                    0,
                    0,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }),
                },
                {
                    SPR_WOODEN_RC_QUARTER_TURN_5_FRONT_SW_SE_SEQ_2,
                    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_FRONT_SW_SE_SEQ_2,
                    { 0, 16, 0 },
                    BoundBoxXYZ({ 0, 16, 27 }, { 32, 16, 0 }),
                },
                {
                    SPR_WOODEN_RC_QUARTER_TURN_5_FRONT_SW_SE_SEQ_3,
                    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_FRONT_SW_SE_SEQ_3,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 0, 27 }, { 16, 16, 0 }),
                },
                {
                    0,
                    0,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }),
                },
                {
                    SPR_WOODEN_RC_QUARTER_TURN_5_FRONT_SW_SE_SEQ_5,
                    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_FRONT_SW_SE_SEQ_5,
                    { 16, 0, 0 },
                    BoundBoxXYZ({ 16, 0, 27 }, { 16, 32, 0 }),
                },
                {
                    SPR_WOODEN_RC_QUARTER_TURN_5_FRONT_SW_SE_SEQ_6,
                    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_FRONT_SW_SE_SEQ_6,
                    { 2, 0, 0 },
                    BoundBoxXYZ({ 2, 0, 27 }, { 32, 32, 0 }),
                },
            },
            {
                { 0, 0, { 0, 0, 0 }, BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }) },
                { 0, 0, { 0, 0, 0 }, BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }) },
                { 0, 0, { 0, 0, 0 }, BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }) },
                { 0, 0, { 0, 0, 0 }, BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }) },
                { 0, 0, { 0, 0, 0 }, BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }) },
                { 0, 0, { 0, 0, 0 }, BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }) },
                { 0, 0, { 0, 0, 0 }, BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }) },
            },
            {
                {
                    SPR_WOODEN_RC_QUARTER_TURN_5_FRONT_NE_NW_SEQ_0,
                    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_FRONT_NE_NW_SEQ_0,
                    { 0, 2, 0 },
                    BoundBoxXYZ({ 0, 2, 27 }, { 32, 27, 0 }),
                },
                {
                    0,
                    0,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }),
                },
                {
                    SPR_WOODEN_RC_QUARTER_TURN_5_FRONT_NE_NW_SEQ_2,
                    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_FRONT_NE_NW_SEQ_2,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 0, 27 }, { 32, 16, 0 }),
                },
                {
                    SPR_WOODEN_RC_QUARTER_TURN_5_FRONT_NE_NW_SEQ_3,
                    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_FRONT_NE_NW_SEQ_3,
                    { 16, 16, 0 },
                    BoundBoxXYZ({ 16, 16, 27 }, { 16, 16, 0 }),
                },
                {
                    0,
                    0,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }),
                },
                {
                    SPR_WOODEN_RC_QUARTER_TURN_5_FRONT_NE_NW_SEQ_5,
                    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_FRONT_NE_NW_SEQ_5,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 0, 27 }, { 16, 32, 0 }),
                },
                {
                    SPR_WOODEN_RC_QUARTER_TURN_5_FRONT_NE_NW_SEQ_6,
                    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_FRONT_NE_NW_SEQ_6,
                    { 2, 0, 0 },
                    BoundBoxXYZ({ 2, 0, 27 }, { 27, 32, 0 }),
                },
            },
            {
                { 0, 0, { 0, 0, 0 }, BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }) },
                { 0, 0, { 0, 0, 0 }, BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }) },
                { 0, 0, { 0, 0, 0 }, BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }) },
                { 0, 0, { 0, 0, 0 }, BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }) },
                { 0, 0, { 0, 0, 0 }, BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }) },
                { 0, 0, { 0, 0, 0 }, BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }) },
                { 0, 0, { 0, 0, 0 }, BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }) },
            },
        },
    };
    static WoodenSupportSubType supportSubType[kNumOrthogonalDirections][7] = {
        { WoodenSupportSubType::neSw, WoodenSupportSubType::null, WoodenSupportSubType::corner2, WoodenSupportSubType::corner0,
          WoodenSupportSubType::null, WoodenSupportSubType::corner2, WoodenSupportSubType::nwSe },
        { WoodenSupportSubType::nwSe, WoodenSupportSubType::null, WoodenSupportSubType::corner3, WoodenSupportSubType::corner1,
          WoodenSupportSubType::null, WoodenSupportSubType::corner3, WoodenSupportSubType::neSw },
        { WoodenSupportSubType::neSw, WoodenSupportSubType::null, WoodenSupportSubType::corner0, WoodenSupportSubType::corner2,
          WoodenSupportSubType::null, WoodenSupportSubType::corner0, WoodenSupportSubType::nwSe },
        { WoodenSupportSubType::nwSe, WoodenSupportSubType::null, WoodenSupportSubType::corner1, WoodenSupportSubType::corner3,
          WoodenSupportSubType::null, WoodenSupportSubType::corner1, WoodenSupportSubType::neSw },
    };

    WoodenRCTrackPaintBb<isClassic>(session, &imageIds[0][direction][trackSequence], height);
    WoodenRCTrackPaintBb<isClassic>(session, &imageIds[1][direction][trackSequence], height);
    TrackPaintUtilRightQuarterTurn5TilesTunnel(session, kTunnelGroup, TunnelSubType::Flat, height, direction, trackSequence);

    if (supportSubType[direction][trackSequence] != WoodenSupportSubType::null)
    {
        WoodenASupportsPaintSetup(
            session, supportType.wooden, supportSubType[direction][trackSequence], height, session.SupportColours);
    }

    int32_t blockedSegments = 0;
    switch (trackSequence)
    {
        case 0:
            blockedSegments = kSegmentsAll;
            break;
        case 1:
            blockedSegments = EnumsToFlags(PaintSegment::top, PaintSegment::topLeft, PaintSegment::topRight);
            break;
        case 2:
            blockedSegments = EnumsToFlags(
                PaintSegment::right, PaintSegment::bottom, PaintSegment::centre, PaintSegment::topRight,
                PaintSegment::bottomLeft, PaintSegment::bottomRight);
            break;
        case 3:
            blockedSegments = EnumsToFlags(
                PaintSegment::top, PaintSegment::left, PaintSegment::right, PaintSegment::centre, PaintSegment::topLeft,
                PaintSegment::topRight, PaintSegment::bottomLeft, PaintSegment::bottomRight);
            break;
        case 4:
            blockedSegments = EnumsToFlags(PaintSegment::top, PaintSegment::topLeft, PaintSegment::topRight);
            break;
        case 5:
            blockedSegments = EnumsToFlags(
                PaintSegment::left, PaintSegment::bottom, PaintSegment::centre, PaintSegment::topLeft, PaintSegment::bottomLeft,
                PaintSegment::bottomRight);
            break;
        case 6:
            blockedSegments = kSegmentsAll;
            break;
    }
    PaintUtilSetSegmentSupportHeight(session, PaintUtilRotateSegments(blockedSegments, direction), 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + kDefaultGeneralSupportHeight);
}

template<bool isClassic>
static void WoodenRCTrackLeftQuarterTurn5(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    trackSequence = kMapLeftQuarterTurn5TilesToRightQuarterTurn5Tiles[trackSequence];
    WoodenRCTrackRightQuarterTurn5<isClassic>(
        session, ride, trackSequence, (direction + 1) & 3, height, trackElement, supportType);
}

/** rct2: 0x008AC678 */
template<bool isClassic>
static void WoodenRCTrackLeftBankToFlat(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    WoodenRCTrackFlatToBank<isClassic, kFlatToRightBankImages>(
        session, ride, trackSequence, (direction + 2) & 3, height, trackElement, supportType);
}

/** rct2: 0x008AC688 */
template<bool isClassic>
static void WoodenRCTrackRightBankToFlat(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    WoodenRCTrackFlatToBank<isClassic, kFlatToLeftBankImages>(
        session, ride, trackSequence, (direction + 2) & 3, height, trackElement, supportType);
}

template<bool isClassic>
static void WoodenRCTrackBankedLeftQuarterTurn5(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    trackSequence = kMapLeftQuarterTurn5TilesToRightQuarterTurn5Tiles[trackSequence];
    WoodenRCTrackBankedRightQuarterTurn5<isClassic, kBankedQuarterTurn5Images>(
        session, ride, trackSequence, DirectionNext(direction), height, trackElement, supportType);
}

/** rct2:  */

/** rct2: 0x008AC6F8 */
template<bool isClassic>
static void WoodenRCTrackLeftBankTo25DegDown(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    WoodenRCTrack25DegUpToBank<isClassic, kUp25ToRightBankImages>(
        session, ride, trackSequence, (direction + 2) & 3, height, trackElement, supportType);
}

/** rct2: 0x008AC708 */
template<bool isClassic>
static void WoodenRCTrackRightBankTo25DegDown(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    WoodenRCTrack25DegUpToBank<isClassic, kUp25ToLeftBankImages>(
        session, ride, trackSequence, (direction + 2) & 3, height, trackElement, supportType);
}

/** rct2: 0x008AC718 */
template<bool isClassic>
static void WoodenRCTrack25DegDownToLeftBank(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    WoodenRCTrackBankTo25DegUp<isClassic, kRightBankToUp25Images>(
        session, ride, trackSequence, DirectionReverse(direction), height, trackElement, supportType);
}

/** rct2: 0x008AC728 */
template<bool isClassic>
static void WoodenRCTrack25DegDownToRightBank(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    WoodenRCTrackBankTo25DegUp<isClassic, kLeftBankToUp25Images>(
        session, ride, trackSequence, DirectionReverse(direction), height, trackElement, supportType);
}

/** rct2: 0x008AC748 */
template<bool isClassic>
static void WoodenRCTrackRightBank(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    WoodenRCTrackFlatToBank<isClassic, kLeftBankImages>(
        session, ride, trackSequence, (direction + 2) & 3, height, trackElement, supportType);
}

/** rct2: 0x008AC758 */
template<bool isClassic>
static void WoodenRCTrackLeftQuarterTurn525DegUp(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23781), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24647), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    WoodenASupportsPaintSetupRotated(
                        session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                        WoodenSupportTransitionType::up25Deg);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23786), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24652), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23812), { 0, 0, height },
                        { { 0, 2, height + 67 }, { 32, 27, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24678), { 0, 0, height },
                        { { 0, 2, height + 67 }, { 32, 27, 0 } });
                    WoodenASupportsPaintSetupRotated(
                        session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                        WoodenSupportTransitionType::up25Deg);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23791), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24657), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    WoodenASupportsPaintSetupRotated(
                        session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                        WoodenSupportTransitionType::up25Deg);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23796), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24662), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    WoodenASupportsPaintSetupRotated(
                        session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                        WoodenSupportTransitionType::up25Deg);
                    break;
            }
            if (direction == 0 || direction == 3)
            {
                PaintUtilPushTunnelRotated(session, direction, height - 8, kTunnelGroup, TunnelSubType::SlopeStart);
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72);
            break;
        case 1:
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(PaintSegment::right, PaintSegment::topRight, PaintSegment::bottomRight), direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72);
            break;
        case 2:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23782), { 0, 0, height },
                        { { 0, 0, height }, { 32, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24648), { 0, 0, height },
                        { { 0, 0, height }, { 32, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner3, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23787), { 0, 0, height },
                        { { 0, 0, height }, { 32, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24653), { 0, 0, height },
                        { { 0, 0, height }, { 32, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23813), { 0, 0, height },
                        { { 0, 0, height + 67 }, { 32, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24679), { 0, 0, height },
                        { { 0, 0, height + 67 }, { 32, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner0, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23792), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24658), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner1, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23797), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24663), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23819), { 0, 0, height },
                        { { 0, 16, height + 67 }, { 32, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24685), { 0, 0, height },
                        { { 0, 16, height + 67 }, { 32, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner2, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::top, PaintSegment::left, PaintSegment::centre, PaintSegment::topLeft,
                        PaintSegment::topRight, PaintSegment::bottomLeft),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72);
            break;
        case 3:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23783), { 0, 0, height },
                        { { 0, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24649), { 0, 0, height },
                        { { 0, 16, height }, { 16, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner1, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23788), { 0, 0, height },
                        { { 16, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24654), { 0, 0, height },
                        { { 16, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23814), { 0, 0, height },
                        { { 16, 16, height + 59 }, { 16, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24680), { 0, 0, height },
                        { { 16, 16, height + 59 }, { 16, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner2, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23793), { 0, 0, height },
                        { { 16, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24659), { 0, 0, height },
                        { { 16, 0, height }, { 16, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner3, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23798), { 0, 0, height },
                        { { 0, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24664), { 0, 0, height },
                        { { 0, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23820), { 0, 0, height },
                        { { 0, 0, height + 59 }, { 16, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24686), { 0, 0, height },
                        { { 0, 0, height + 59 }, { 16, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner0, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::top, PaintSegment::right, PaintSegment::bottom, PaintSegment::centre,
                        PaintSegment::topLeft, PaintSegment::topRight, PaintSegment::bottomLeft, PaintSegment::bottomRight),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 64);
            break;
        case 4:
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(PaintSegment::right, PaintSegment::topRight, PaintSegment::bottomRight), direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72);
            break;
        case 5:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23784), { 0, 0, height },
                        { { 16, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24650), { 0, 0, height },
                        { { 16, 0, height }, { 16, 32, 2 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner3, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23789), { 0, 0, height },
                        { { 0, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24655), { 0, 0, height },
                        { { 0, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23815), { 0, 0, height },
                        { { 0, 0, height + 67 }, { 16, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24681), { 0, 0, height },
                        { { 0, 0, height + 67 }, { 16, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner0, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23794), { 0, 0, height },
                        { { 0, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24660), { 0, 0, height },
                        { { 0, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23817), { 0, 0, height },
                        { { 0, 0, height + 67 }, { 16, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24683), { 0, 0, height },
                        { { 0, 0, height + 67 }, { 16, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner1, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23799), { 0, 0, height },
                        { { 16, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24665), { 0, 0, height },
                        { { 16, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23821), { 0, 0, height },
                        { { 16, 0, height + 67 }, { 16, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24687), { 0, 0, height },
                        { { 16, 0, height + 67 }, { 16, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner2, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::left, PaintSegment::bottom, PaintSegment::centre, PaintSegment::topLeft,
                        PaintSegment::bottomLeft, PaintSegment::bottomRight),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72);
            break;
        case 6:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23785), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24651), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23790), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24656), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23816), { 0, 0, height },
                        { { 2, 0, height + 67 }, { 27, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24682), { 0, 0, height },
                        { { 2, 0, height + 67 }, { 27, 32, 0 } });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23795), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24661), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23818), { 0, 0, height },
                        { { 2, 0, height + 67 }, { 27, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24684), { 0, 0, height },
                        { { 2, 0, height + 67 }, { 27, 32, 0 } });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23800), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24666), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23822), { 0, 0, height },
                        { { 2, 0, height + 67 }, { 27, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24688), { 0, 0, height },
                        { { 2, 0, height + 67 }, { 27, 32, 0 } });
                    break;
            }
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, DirectionPrev(direction), height,
                session.SupportColours, WoodenSupportTransitionType::up25Deg);
            switch (direction)
            {
                case 2:
                    PaintUtilPushTunnelRight(session, height + 8, kTunnelGroup, TunnelSubType::SlopeEnd);
                    break;
                case 3:
                    PaintUtilPushTunnelLeft(session, height + 8, kTunnelGroup, TunnelSubType::SlopeEnd);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72);
            break;
    }
}

/** rct2: 0x008AC768 */
template<bool isClassic>
static void WoodenRCTrackRightQuarterTurn525DegUp(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23761), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24627), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    WoodenASupportsPaintSetupRotated(
                        session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                        WoodenSupportTransitionType::up25Deg);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23766), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24632), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    WoodenASupportsPaintSetupRotated(
                        session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                        WoodenSupportTransitionType::up25Deg);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23771), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24637), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23807), { 0, 0, height },
                        { { 0, 2, height + 67 }, { 32, 27, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24673), { 0, 0, height },
                        { { 0, 2, height + 67 }, { 32, 27, 0 } });
                    WoodenASupportsPaintSetupRotated(
                        session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                        WoodenSupportTransitionType::up25Deg);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23776), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24642), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    WoodenASupportsPaintSetupRotated(
                        session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                        WoodenSupportTransitionType::up25Deg);
                    break;
            }
            if (direction == 0 || direction == 3)
            {
                PaintUtilPushTunnelRotated(session, direction, height - 8, kTunnelGroup, TunnelSubType::SlopeStart);
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72);
            break;
        case 1:
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(PaintSegment::top, PaintSegment::topLeft, PaintSegment::topRight), direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72);
            break;
        case 2:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23762), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24628), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23801), { 0, 0, height },
                        { { 0, 16, height + 67 }, { 32, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24667), { 0, 0, height },
                        { { 0, 16, height + 67 }, { 32, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner2, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23767), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24633), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner3, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23772), { 0, 0, height },
                        { { 0, 0, height }, { 32, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24638), { 0, 0, height },
                        { { 0, 0, height }, { 32, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23808), { 0, 0, height },
                        { { 0, 0, height + 67 }, { 32, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24674), { 0, 0, height },
                        { { 0, 0, height + 67 }, { 32, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner0, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23777), { 0, 0, height },
                        { { 0, 0, height }, { 32, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24643), { 0, 0, height },
                        { { 0, 0, height }, { 32, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner1, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::right, PaintSegment::bottom, PaintSegment::centre, PaintSegment::topRight,
                        PaintSegment::bottomLeft, PaintSegment::bottomRight),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72);
            break;
        case 3:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23763), { 0, 0, height },
                        { { 0, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24629), { 0, 0, height },
                        { { 0, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23802), { 0, 0, height },
                        { { 0, 0, height + 59 }, { 16, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24668), { 0, 0, height },
                        { { 0, 0, height + 59 }, { 16, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner0, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23768), { 0, 0, height },
                        { { 16, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24634), { 0, 0, height },
                        { { 16, 0, height }, { 16, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner1, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23773), { 0, 0, height },
                        { { 16, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24639), { 0, 0, height },
                        { { 16, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23809), { 0, 0, height },
                        { { 16, 16, height + 59 }, { 16, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24675), { 0, 0, height },
                        { { 16, 16, height + 59 }, { 16, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner2, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23778), { 0, 0, height },
                        { { 0, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24644), { 0, 0, height },
                        { { 0, 16, height }, { 16, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner3, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::top, PaintSegment::left, PaintSegment::right, PaintSegment::centre, PaintSegment::topLeft,
                        PaintSegment::topRight, PaintSegment::bottomLeft, PaintSegment::bottomRight),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 64);
            break;
        case 4:
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(PaintSegment::top, PaintSegment::topLeft, PaintSegment::topRight), direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72);
            break;
        case 5:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23764), { 0, 0, height },
                        { { 16, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24630), { 0, 0, height },
                        { { 16, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23803), { 0, 0, height },
                        { { 16, 0, height + 67 }, { 16, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24669), { 0, 0, height },
                        { { 16, 0, height + 67 }, { 16, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner2, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23769), { 0, 0, height },
                        { { 0, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24635), { 0, 0, height },
                        { { 0, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23805), { 0, 0, height },
                        { { 0, 0, height + 67 }, { 16, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24671), { 0, 0, height },
                        { { 0, 0, height + 67 }, { 16, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner3, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23774), { 0, 0, height },
                        { { 0, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24640), { 0, 0, height },
                        { { 0, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23810), { 0, 0, height },
                        { { 0, 0, height + 67 }, { 16, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24676), { 0, 0, height },
                        { { 0, 0, height + 67 }, { 16, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner0, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23779), { 0, 0, height },
                        { { 16, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24645), { 0, 0, height },
                        { { 16, 0, height }, { 16, 32, 2 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner1, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::left, PaintSegment::bottom, PaintSegment::centre, PaintSegment::topLeft,
                        PaintSegment::bottomLeft, PaintSegment::bottomRight),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72);
            break;
        case 6:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23765), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24631), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23804), { 0, 0, height },
                        { { 2, 0, height + 67 }, { 27, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24670), { 0, 0, height },
                        { { 2, 0, height + 67 }, { 27, 32, 0 } });

                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23770), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24636), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23806), { 0, 0, height },
                        { { 2, 0, height + 67 }, { 27, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24672), { 0, 0, height },
                        { { 2, 0, height + 67 }, { 27, 32, 0 } });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23775), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24641), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23811), { 0, 0, height },
                        { { 2, 0, height + 67 }, { 27, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24677), { 0, 0, height },
                        { { 2, 0, height + 67 }, { 27, 32, 0 } });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23780), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24646), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    break;
            }
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, DirectionNext(direction), height,
                session.SupportColours, WoodenSupportTransitionType::up25Deg);
            switch (direction)
            {
                case 0:
                    PaintUtilPushTunnelRight(session, height + 8, kTunnelGroup, TunnelSubType::SlopeEnd);
                    break;
                case 1:
                    PaintUtilPushTunnelLeft(session, height + 8, kTunnelGroup, TunnelSubType::SlopeEnd);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72);
            break;
    }
}

/** rct2: 0x008AC778 */
template<bool isClassic>
static void WoodenRCTrackLeftQuarterTurn525DegDown(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    trackSequence = kMapLeftQuarterTurn5TilesToRightQuarterTurn5Tiles[trackSequence];
    WoodenRCTrackRightQuarterTurn525DegUp<isClassic>(
        session, ride, trackSequence, (direction + 1) & 3, height, trackElement, supportType);
}

/** rct2: 0x008AC788 */
template<bool isClassic>
static void WoodenRCTrackRightQuarterTurn525DegDown(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    trackSequence = kMapLeftQuarterTurn5TilesToRightQuarterTurn5Tiles[trackSequence];
    WoodenRCTrackLeftQuarterTurn525DegUp<isClassic>(
        session, ride, trackSequence, (direction - 1) & 3, height, trackElement, supportType);
}

/** rct2: 0x008AC798 */
template<bool isClassic>
static void WoodenRCTrackSBendLeft(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23725), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24591), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::neSw, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23729), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24595), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23741), { 0, 0, height },
                        { { 0, 3, height + 27 }, { 32, 25, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24607), { 0, 0, height },
                        { { 0, 3, height + 27 }, { 32, 25, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::nwSe, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23728), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24594), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::neSw, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23732), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24598), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23744), { 0, 0, height },
                        { { 0, 2, height + 27 }, { 32, 27, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24610), { 0, 0, height },
                        { { 0, 2, height + 27 }, { 32, 27, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::nwSe, height, session.SupportColours);
                    break;
            }
            if (direction == 0 || direction == 3)
            {
                PaintUtilPushTunnelRotated(session, direction, height, kTunnelGroup, TunnelSubType::Flat);
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + kDefaultGeneralSupportHeight);
            break;
        case 1:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23726), { 0, 0, height },
                        { { 0, 0, height }, { 32, 26, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24592), { 0, 0, height },
                        { { 0, 0, height }, { 32, 26, 2 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner3, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23730), { 0, 0, height },
                        { { 0, 0, height }, { 32, 26, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24596), { 0, 0, height },
                        { { 0, 0, height }, { 32, 26, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23742), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 32, 26, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24608), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 32, 26, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner0, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23727), { 0, 0, height },
                        { { 0, 6, height }, { 32, 26, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24593), { 0, 0, height },
                        { { 0, 6, height }, { 32, 26, 2 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner1, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23731), { 0, 0, height },
                        { { 0, 6, height }, { 32, 26, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24597), { 0, 0, height },
                        { { 0, 6, height }, { 32, 26, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23743), { 0, 0, height },
                        { { 0, 6, height + 27 }, { 32, 26, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24609), { 0, 0, height },
                        { { 0, 6, height + 27 }, { 32, 26, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner2, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::top, PaintSegment::left, PaintSegment::centre, PaintSegment::topLeft,
                        PaintSegment::topRight, PaintSegment::bottomLeft),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + kDefaultGeneralSupportHeight);
            break;
        case 2:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23727), { 0, 0, height },
                        { { 0, 6, height }, { 32, 26, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24593), { 0, 0, height },
                        { { 0, 6, height }, { 32, 26, 2 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner1, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23731), { 0, 0, height },
                        { { 0, 6, height }, { 32, 26, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24597), { 0, 0, height },
                        { { 0, 6, height }, { 32, 26, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23743), { 0, 0, height },
                        { { 0, 6, height + 27 }, { 32, 26, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24609), { 0, 0, height },
                        { { 0, 6, height + 27 }, { 32, 26, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner2, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23726), { 0, 0, height },
                        { { 0, 0, height }, { 32, 26, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24592), { 0, 0, height },
                        { { 0, 0, height }, { 32, 26, 2 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner3, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23730), { 0, 0, height },
                        { { 0, 0, height }, { 32, 26, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24596), { 0, 0, height },
                        { { 0, 0, height }, { 32, 26, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23742), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 32, 26, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24608), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 32, 26, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner0, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::right, PaintSegment::bottom, PaintSegment::centre, PaintSegment::topRight,
                        PaintSegment::bottomLeft, PaintSegment::bottomRight),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + kDefaultGeneralSupportHeight);
            break;
        case 3:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23728), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24594), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::neSw, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23732), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24598), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23744), { 0, 0, height },
                        { { 0, 2, height + 27 }, { 32, 27, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24610), { 0, 0, height },
                        { { 0, 2, height + 27 }, { 32, 27, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::nwSe, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23725), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24591), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::neSw, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23729), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24595), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23741), { 0, 0, height },
                        { { 0, 3, height + 27 }, { 32, 25, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24607), { 0, 0, height },
                        { { 0, 3, height + 27 }, { 32, 25, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::nwSe, height, session.SupportColours);
                    break;
            }
            switch (direction)
            {
                case 1:
                    PaintUtilPushTunnelRight(session, height, kTunnelGroup, TunnelSubType::Flat);
                    break;
                case 2:
                    PaintUtilPushTunnelLeft(session, height, kTunnelGroup, TunnelSubType::Flat);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + kDefaultGeneralSupportHeight);
            break;
    }
}

/** rct2: 0x008AC7A8 */
template<bool isClassic>
static void WoodenRCTrackSBendRight(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23733), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24599), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23745), { 0, 0, height },
                        { { 0, 3, height + 27 }, { 32, 25, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24611), { 0, 0, height },
                        { { 0, 3, height + 27 }, { 32, 25, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::neSw, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23737), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24603), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::nwSe, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23736), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24602), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23748), { 0, 0, height },
                        { { 0, 3, height + 27 }, { 32, 25, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24614), { 0, 0, height },
                        { { 0, 3, height + 27 }, { 32, 25, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::neSw, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23740), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24606), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::nwSe, height, session.SupportColours);
                    break;
            }
            if (direction == 0 || direction == 3)
            {
                PaintUtilPushTunnelRotated(session, direction, height, kTunnelGroup, TunnelSubType::Flat);
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + kDefaultGeneralSupportHeight);
            break;
        case 1:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23734), { 0, 0, height },
                        { { 0, 6, height }, { 32, 26, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24600), { 0, 0, height },
                        { { 0, 6, height }, { 32, 26, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23746), { 0, 0, height },
                        { { 0, 6, height + 27 }, { 32, 26, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24612), { 0, 0, height },
                        { { 0, 6, height + 27 }, { 32, 26, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner2, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23738), { 0, 0, height },
                        { { 0, 6, height }, { 32, 26, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24604), { 0, 0, height },
                        { { 0, 6, height }, { 32, 26, 2 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner3, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23735), { 0, 0, height },
                        { { 0, 0, height }, { 32, 26, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24601), { 0, 0, height },
                        { { 0, 0, height }, { 32, 26, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23747), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 32, 26, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24613), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 32, 26, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner0, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23739), { 0, 0, height },
                        { { 0, 0, height }, { 32, 26, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24605), { 0, 0, height },
                        { { 0, 0, height }, { 32, 26, 2 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner1, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::right, PaintSegment::bottom, PaintSegment::centre, PaintSegment::topRight,
                        PaintSegment::bottomLeft, PaintSegment::bottomRight),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + kDefaultGeneralSupportHeight);
            break;
        case 2:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23735), { 0, 0, height },
                        { { 0, 0, height }, { 32, 26, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24601), { 0, 0, height },
                        { { 0, 0, height }, { 32, 26, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23747), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 32, 26, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24613), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 32, 26, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner0, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23739), { 0, 0, height },
                        { { 0, 0, height }, { 32, 26, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24605), { 0, 0, height },
                        { { 0, 0, height }, { 32, 26, 2 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner1, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23734), { 0, 0, height },
                        { { 0, 6, height }, { 32, 26, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24600), { 0, 0, height },
                        { { 0, 6, height }, { 32, 26, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23746), { 0, 0, height },
                        { { 0, 6, height + 27 }, { 32, 26, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24612), { 0, 0, height },
                        { { 0, 6, height + 27 }, { 32, 26, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner2, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23738), { 0, 0, height },
                        { { 0, 6, height }, { 32, 26, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24604), { 0, 0, height },
                        { { 0, 6, height }, { 32, 26, 2 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner3, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::top, PaintSegment::left, PaintSegment::centre, PaintSegment::topLeft,
                        PaintSegment::topRight, PaintSegment::bottomLeft),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + kDefaultGeneralSupportHeight);
            break;
        case 3:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23736), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24602), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23748), { 0, 0, height },
                        { { 0, 3, height + 27 }, { 32, 25, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24614), { 0, 0, height },
                        { { 0, 3, height + 27 }, { 32, 25, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::neSw, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23740), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24606), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::nwSe, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23733), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24599), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23745), { 0, 0, height },
                        { { 0, 3, height + 27 }, { 32, 25, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24611), { 0, 0, height },
                        { { 0, 3, height + 27 }, { 32, 25, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::neSw, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23737), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24603), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::nwSe, height, session.SupportColours);
                    break;
            }
            switch (direction)
            {
                case 1:
                    PaintUtilPushTunnelRight(session, height, kTunnelGroup, TunnelSubType::Flat);
                    break;
                case 2:
                    PaintUtilPushTunnelLeft(session, height, kTunnelGroup, TunnelSubType::Flat);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + kDefaultGeneralSupportHeight);
            break;
    }
}

/** rct2: 0x008ACE18 */
static void WoodenRCTrackLeftVerticalLoop(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23453), { 0, 6, height }, { 32, 20, 3 });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23461), { 0, 6, height }, { 32, 20, 3 });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23460), { 0, 6, height }, { 32, 20, 3 });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23468), { 0, 6, height }, { 32, 20, 7 });
                    break;
            }
            MetalASupportsPaintSetup(
                session, MetalSupportType::boxed, MetalSupportPlace::centre, 8, height, session.SupportColours);
            if (direction == 0 || direction == 3)
            {
                PaintUtilPushTunnelRotated(session, direction, height - 8, kTunnelGroup, TunnelSubType::SlopeStart);
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::top, PaintSegment::left, PaintSegment::centre, PaintSegment::topLeft,
                        PaintSegment::topRight, PaintSegment::bottomLeft),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 56);
            break;
        case 1:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23454), { 0, 0, height }, { 32, 26, 3 });
                    MetalASupportsPaintSetup(
                        session, MetalSupportType::boxed, MetalSupportPlace::centre, 20, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23462), { 0, 14, height }, { 32, 2, 63 });
                    MetalASupportsPaintSetup(
                        session, MetalSupportType::boxed, MetalSupportPlace::centre, 9, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23459), { 0, 6, height }, { 32, 26, 3 });
                    MetalASupportsPaintSetup(
                        session, MetalSupportType::boxed, MetalSupportPlace::centre, 16, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23467), { 0, 6, height }, { 32, 26, 3 });
                    MetalASupportsPaintSetup(
                        session, MetalSupportType::boxed, MetalSupportPlace::centre, 16, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::top, PaintSegment::left, PaintSegment::centre, PaintSegment::topLeft,
                        PaintSegment::topRight, PaintSegment::bottomLeft),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72);
            break;
        case 2:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23455), { 16, 0, height },
                        { 5, 16, 119 });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23463), { 12, 0, height },
                        { 3, 16, 119 });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23458), { 10, 16, height },
                        { 4, 16, 119 });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23466), { 16, 16, height },
                        { 4, 16, 119 });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(PaintSegment::left, PaintSegment::centre, PaintSegment::topLeft, PaintSegment::bottomLeft),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 168);
            break;
        case 3:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23456), { 0, 0, height + 32 },
                        { 32, 16, 3 });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23464), { 0, 0, height + 32 },
                        { 32, 16, 3 });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23457), { 0, 16, height + 32 },
                        { 32, 16, 3 });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23465), { 0, 16, height + 32 },
                        { 32, 16, 3 });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::top, PaintSegment::left, PaintSegment::centre, PaintSegment::topLeft,
                        PaintSegment::topRight, PaintSegment::bottomLeft),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 48);
            break;
        case 4:
            PaintUtilSetGeneralSupportHeight(session, height + 48);
            break;
        case 5:
            PaintUtilSetGeneralSupportHeight(session, height + 48);
            break;
        case 6:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23457), { 0, 16, height + 32 },
                        { 32, 16, 3 });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23465), { 0, 16, height + 32 },
                        { 32, 16, 3 });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23456), { 0, 0, height + 32 },
                        { 32, 16, 3 });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23464), { 0, 0, height + 32 },
                        { 32, 16, 3 });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::right, PaintSegment::bottom, PaintSegment::centre, PaintSegment::topRight,
                        PaintSegment::bottomLeft, PaintSegment::bottomRight),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 48);
            break;
        case 7:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23458), { 10, 16, height },
                        { 4, 16, 119 });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23466), { 16, 16, height },
                        { 4, 16, 119 });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23455), { 16, 0, height },
                        { 5, 16, 119 });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23463), { 12, 0, height },
                        { 3, 16, 119 });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(PaintSegment::right, PaintSegment::centre, PaintSegment::topRight, PaintSegment::bottomRight),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 168);
            break;
        case 8:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23459), { 0, 6, height }, { 32, 26, 3 });
                    MetalASupportsPaintSetup(
                        session, MetalSupportType::boxed, MetalSupportPlace::centre, 16, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23467), { 0, 6, height }, { 32, 26, 3 });
                    MetalASupportsPaintSetup(
                        session, MetalSupportType::boxed, MetalSupportPlace::centre, 16, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23454), { 0, 0, height }, { 32, 26, 3 });
                    MetalASupportsPaintSetup(
                        session, MetalSupportType::boxed, MetalSupportPlace::centre, 20, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23462), { 0, 14, height }, { 32, 2, 63 });
                    MetalASupportsPaintSetup(
                        session, MetalSupportType::boxed, MetalSupportPlace::centre, 9, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::right, PaintSegment::bottom, PaintSegment::centre, PaintSegment::topRight,
                        PaintSegment::bottomLeft, PaintSegment::bottomRight),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72);
            break;
        case 9:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23460), { 0, 6, height }, { 32, 20, 3 });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23468), { 0, 6, height }, { 32, 20, 7 });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23453), { 0, 6, height }, { 32, 20, 3 });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23461), { 0, 6, height }, { 32, 20, 3 });
                    break;
            }
            MetalASupportsPaintSetup(
                session, MetalSupportType::boxed, MetalSupportPlace::centre, 8, height, session.SupportColours);
            switch (direction)
            {
                case 1:
                    PaintUtilPushTunnelRight(session, height - 8, kTunnelGroup, TunnelSubType::SlopeStart);
                    break;
                case 2:
                    PaintUtilPushTunnelLeft(session, height - 8, kTunnelGroup, TunnelSubType::SlopeStart);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::right, PaintSegment::bottom, PaintSegment::centre, PaintSegment::topRight,
                        PaintSegment::bottomLeft, PaintSegment::bottomRight),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 56);
            break;
    }
}

/** rct2: 0x008ACE28 */
static void WoodenRCTrackRightVerticalLoop(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23484), { 0, 6, height }, { 32, 20, 7 });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23476), { 0, 6, height }, { 32, 20, 3 });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23477), { 0, 6, height }, { 32, 20, 3 });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23469), { 0, 6, height }, { 32, 20, 3 });
                    break;
            }
            MetalASupportsPaintSetup(
                session, MetalSupportType::boxed, MetalSupportPlace::centre, 8, height, session.SupportColours);
            if (direction == 0 || direction == 3)
            {
                PaintUtilPushTunnelRotated(session, direction, height - 8, kTunnelGroup, TunnelSubType::SlopeStart);
            }
            PaintUtilSetGeneralSupportHeight(session, height + 56);
            break;
        case 1:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23483), { 0, 6, height }, { 32, 26, 3 });
                    MetalASupportsPaintSetup(
                        session, MetalSupportType::boxed, MetalSupportPlace::centre, 16, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23475), { 0, 6, height }, { 32, 26, 3 });
                    MetalASupportsPaintSetup(
                        session, MetalSupportType::boxed, MetalSupportPlace::centre, 16, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23478), { 0, 14, height }, { 32, 2, 63 });
                    MetalASupportsPaintSetup(
                        session, MetalSupportType::boxed, MetalSupportPlace::centre, 9, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23470), { 0, 0, height }, { 32, 26, 3 });
                    MetalASupportsPaintSetup(
                        session, MetalSupportType::boxed, MetalSupportPlace::centre, 20, height, session.SupportColours);
                    break;
            }
            PaintUtilSetGeneralSupportHeight(session, height + 72);
            break;
        case 2:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23482), { 16, 16, height },
                        { 4, 16, 119 });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23474), { 10, 16, height },
                        { 4, 16, 119 });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23479), { 12, 0, height },
                        { 3, 16, 119 });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23471), { 16, 0, height },
                        { 5, 16, 119 });
                    break;
            }
            PaintUtilSetGeneralSupportHeight(session, height + 168);
            break;
        case 3:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23481), { 0, 16, height + 32 },
                        { 32, 16, 3 });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23473), { 0, 16, height + 32 },
                        { 32, 16, 3 });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23480), { 0, 0, height + 32 },
                        { 32, 16, 3 });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23472), { 0, 0, height + 32 },
                        { 32, 16, 3 });
                    break;
            }
            PaintUtilSetGeneralSupportHeight(session, height + 48);
            break;
        case 4:
            PaintUtilSetGeneralSupportHeight(session, height + 48);
            break;
        case 5:
            PaintUtilSetGeneralSupportHeight(session, height + 48);
            break;
        case 6:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23480), { 0, 0, height + 32 },
                        { 32, 16, 3 });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23472), { 0, 0, height + 32 },
                        { 32, 16, 3 });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23481), { 0, 16, height + 32 },
                        { 32, 16, 3 });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23473), { 0, 16, height + 32 },
                        { 32, 16, 3 });
                    break;
            }
            PaintUtilSetGeneralSupportHeight(session, height + 48);
            break;
        case 7:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23479), { 12, 0, height },
                        { 3, 16, 119 });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23471), { 16, 0, height },
                        { 5, 16, 119 });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23482), { 16, 16, height },
                        { 4, 16, 119 });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23474), { 10, 16, height },
                        { 4, 16, 119 });
                    break;
            }
            PaintUtilSetGeneralSupportHeight(session, height + 168);
            break;
        case 8:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23478), { 0, 14, height }, { 32, 2, 63 });
                    MetalASupportsPaintSetup(
                        session, MetalSupportType::boxed, MetalSupportPlace::centre, 9, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23470), { 0, 0, height }, { 32, 26, 3 });
                    MetalASupportsPaintSetup(
                        session, MetalSupportType::boxed, MetalSupportPlace::centre, 20, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23483), { 0, 6, height }, { 32, 26, 3 });
                    MetalASupportsPaintSetup(
                        session, MetalSupportType::boxed, MetalSupportPlace::centre, 16, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23475), { 0, 6, height }, { 32, 26, 3 });
                    MetalASupportsPaintSetup(
                        session, MetalSupportType::boxed, MetalSupportPlace::centre, 16, height, session.SupportColours);
                    break;
            }
            PaintUtilSetGeneralSupportHeight(session, height + 72);
            break;
        case 9:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23477), { 0, 6, height }, { 32, 20, 3 });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23469), { 0, 6, height }, { 32, 20, 3 });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23484), { 0, 6, height }, { 32, 20, 7 });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23476), { 0, 6, height }, { 32, 20, 3 });
                    break;
            }
            MetalASupportsPaintSetup(
                session, MetalSupportType::boxed, MetalSupportPlace::centre, 8, height, session.SupportColours);
            switch (direction)
            {
                case 1:
                    PaintUtilPushTunnelRight(session, height - 8, kTunnelGroup, TunnelSubType::SlopeStart);
                    break;
                case 2:
                    PaintUtilPushTunnelLeft(session, height - 8, kTunnelGroup, TunnelSubType::SlopeStart);
                    break;
            }
            PaintUtilSetGeneralSupportHeight(session, height + 56);
            break;
    }

    TrackPaintUtilRightVerticalLoopSegments(session, direction, trackSequence);
}

/** rct2: 0x008AC7E8 */
template<bool isClassic>
static void WoodenRCTrackLeftQuarterTurn3(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23828), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24694), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner3, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23831), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24697), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23840), { 0, 6, height },
                        { { 0, 6, height + 27 }, { 32, 20, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24706), { 0, 6, height },
                        { { 0, 6, height + 27 }, { 32, 20, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner0, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23834), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24700), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner1, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23825), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24691), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23837), { 0, 6, height },
                        { { 0, 6, height + 27 }, { 32, 20, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24703), { 0, 6, height },
                        { { 0, 6, height + 27 }, { 32, 20, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner2, height, session.SupportColours);
                    break;
            }
            if (direction == 0 || direction == 3)
            {
                PaintUtilPushTunnelRotated(session, direction, height, kTunnelGroup, TunnelSubType::Flat);
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + kDefaultGeneralSupportHeight);
            break;
        case 1:
            PaintUtilSetGeneralSupportHeight(session, height + kDefaultGeneralSupportHeight);
            break;
        case 2:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23827), { 16, 0, height },
                        { { 16, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24693), { 16, 0, height },
                        { { 16, 0, height }, { 16, 16, 2 } });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23830), { 0, 0, height },
                        { { 0, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24696), { 0, 0, height },
                        { { 0, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23839), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 16, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24705), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 16, 16, 0 } });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23833), { 0, 16, height },
                        { { 0, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24699), { 0, 16, height },
                        { { 0, 16, height }, { 16, 16, 2 } });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23824), { 16, 16, height },
                        { { 16, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24690), { 16, 16, height },
                        { { 16, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23836), { 16, 16, height },
                        { { 16, 16, height + 27 }, { 16, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24702), { 16, 16, height },
                        { { 16, 16, height + 27 }, { 16, 16, 0 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(PaintSegment::left, PaintSegment::centre, PaintSegment::topLeft, PaintSegment::bottomLeft),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + kDefaultGeneralSupportHeight);
            break;
        case 3:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23826), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24692), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner3, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23829), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24695), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23838), { 6, 0, height },
                        { { 6, 0, height + 27 }, { 20, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24704), { 6, 0, height },
                        { { 6, 0, height + 27 }, { 20, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner0, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23832), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24698), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner1, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23823), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24689), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23835), { 6, 0, height },
                        { { 6, 0, height + 27 }, { 20, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24701), { 6, 0, height },
                        { { 6, 0, height + 27 }, { 20, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner2, height, session.SupportColours);
                    break;
            }
            switch (direction)
            {
                case 2:
                    PaintUtilPushTunnelRight(session, height, kTunnelGroup, TunnelSubType::Flat);
                    break;
                case 3:
                    PaintUtilPushTunnelLeft(session, height, kTunnelGroup, TunnelSubType::Flat);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + kDefaultGeneralSupportHeight);
            break;
    }
}

/** rct2: 0x008AC7F8 */
template<bool isClassic>
static void WoodenRCTrackRightQuarterTurn3(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    trackSequence = kMapLeftQuarterTurn3TilesToRightQuarterTurn3Tiles[trackSequence];
    WoodenRCTrackLeftQuarterTurn3<isClassic>(
        session, ride, trackSequence, (direction - 1) & 3, height, trackElement, supportType);
}

/** rct2: 0x008AC818 */
template<bool isClassic>
static void WoodenRCTrackRightQuarterTurn3Bank(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    trackSequence = kMapLeftQuarterTurn3TilesToRightQuarterTurn3Tiles[trackSequence];
    WoodenRCTrackLeftQuarterTurn3Bank<isClassic, kBankedQuarterTurn3Images>(
        session, ride, trackSequence, DirectionPrev(direction), height, trackElement, supportType);
}

/** rct2: 0x008AC828 */
template<bool isClassic>
static void WoodenRCTrackLeftQuarterTurn325DegUp(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23906), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24772), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner3, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23908), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24774), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23919), { 0, 6, height },
                        { { 0, 6, height + 67 }, { 32, 20, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24785), { 0, 6, height },
                        { { 0, 6, height + 67 }, { 32, 20, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner0, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23910), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24776), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner1, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23904), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24770), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23917), { 0, 6, height },
                        { { 0, 6, height + 67 }, { 32, 20, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24783), { 0, 6, height },
                        { { 0, 6, height + 67 }, { 32, 20, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner2, height, session.SupportColours);
                    break;
            }
            if (direction == 0 || direction == 3)
            {
                PaintUtilPushTunnelRotated(session, direction, height - 8, kTunnelGroup, TunnelSubType::SlopeStart);
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72);
            break;
        case 1:
            PaintUtilSetGeneralSupportHeight(session, height + 56);
            break;
        case 2:
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(PaintSegment::left, PaintSegment::centre, PaintSegment::topLeft, PaintSegment::bottomLeft),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 56);
            break;
        case 3:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23905), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24771), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner3, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23907), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24773), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23918), { 6, 0, height },
                        { { 6, 0, height + 67 }, { 20, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24784), { 6, 0, height },
                        { { 6, 0, height + 67 }, { 20, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner0, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23909), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24775), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23920), { 6, 0, height },
                        { { 6, 0, height + 67 }, { 20, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24786), { 6, 0, height },
                        { { 6, 0, height + 67 }, { 20, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner1, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23903), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24769), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23916), { 6, 0, height },
                        { { 6, 0, height + 67 }, { 20, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24782), { 6, 0, height },
                        { { 6, 0, height + 67 }, { 20, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner2, height, session.SupportColours);
                    break;
            }
            switch (direction)
            {
                case 2:
                    PaintUtilPushTunnelRight(session, height + 8, kTunnelGroup, TunnelSubType::SlopeEnd);
                    break;
                case 3:
                    PaintUtilPushTunnelLeft(session, height + 8, kTunnelGroup, TunnelSubType::SlopeEnd);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72);
            break;
    }
}

/** rct2: 0x008AC838 */
template<bool isClassic>
static void WoodenRCTrackRightQuarterTurn325DegUp(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23895), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24761), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23911), { 0, 6, height },
                        { { 0, 6, height + 67 }, { 32, 20, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24777), { 0, 6, height },
                        { { 0, 6, height + 67 }, { 32, 20, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner2, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23897), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24763), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner3, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23899), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24765), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23914), { 0, 6, height },
                        { { 0, 6, height + 67 }, { 32, 20, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24780), { 0, 6, height },
                        { { 0, 6, height + 67 }, { 32, 20, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner0, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23901), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24767), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner1, height, session.SupportColours);
                    break;
            }
            if (direction == 0 || direction == 3)
            {
                PaintUtilPushTunnelRotated(session, direction, height - 8, kTunnelGroup, TunnelSubType::SlopeStart);
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72);
            break;
        case 1:
            PaintUtilSetGeneralSupportHeight(session, height + 56);
            break;
        case 2:
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::bottom, PaintSegment::centre, PaintSegment::bottomLeft, PaintSegment::bottomRight),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 56);
            break;
        case 3:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23896), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24762), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23912), { 6, 0, height },
                        { { 6, 0, height + 67 }, { 20, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24778), { 6, 0, height },
                        { { 6, 0, height + 67 }, { 20, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner2, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23898), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24764), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23913), { 6, 0, height },
                        { { 6, 0, height + 67 }, { 20, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24779), { 6, 0, height },
                        { { 6, 0, height + 67 }, { 20, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner3, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23900), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24766), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23915), { 6, 0, height },
                        { { 6, 0, height + 67 }, { 20, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24781), { 6, 0, height },
                        { { 6, 0, height + 67 }, { 20, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner0, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23902), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24768), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner1, height, session.SupportColours);
                    break;
            }
            switch (direction)
            {
                case 0:
                    PaintUtilPushTunnelRight(session, height + 8, kTunnelGroup, TunnelSubType::SlopeEnd);
                    break;
                case 1:
                    PaintUtilPushTunnelLeft(session, height + 8, kTunnelGroup, TunnelSubType::SlopeEnd);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72);
            break;
    }
}

/** rct2: 0x008AC848 */
template<bool isClassic>
static void WoodenRCTrackLeftQuarterTurn325DegDown(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    trackSequence = kMapLeftQuarterTurn3TilesToRightQuarterTurn3Tiles[trackSequence];
    WoodenRCTrackRightQuarterTurn325DegUp<isClassic>(
        session, ride, trackSequence, (direction + 1) & 3, height, trackElement, supportType);
}

/** rct2: 0x008AC858 */
template<bool isClassic>
static void WoodenRCTrackRightQuarterTurn325DegDown(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    trackSequence = kMapLeftQuarterTurn3TilesToRightQuarterTurn3Tiles[trackSequence];
    WoodenRCTrackLeftQuarterTurn325DegUp<isClassic>(
        session, ride, trackSequence, (direction - 1) & 3, height, trackElement, supportType);
}

/** rct2: 0x008ACAD8 */
template<bool isClassic>
static void WoodenRCTrackLeftHalfBankedHelixDownSmall(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    if (trackSequence >= 4)
    {
        trackSequence -= 4;
        direction = DirectionPrev(direction);
    }
    trackSequence = kMapLeftQuarterTurn3TilesToRightQuarterTurn3Tiles[trackSequence];
    WoodenRCTrackRightHalfBankedHelixUpSmall<isClassic, kRightHalfBankedHelixUpSmallImages>(
        session, ride, trackSequence, DirectionNext(direction), height, trackElement, supportType);
}

/** rct2: 0x008ACAE8 */
template<bool isClassic>
static void WoodenRCTrackRightHalfBankedHelixDownSmall(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    if (trackSequence >= 4)
    {
        trackSequence -= 4;
        direction = DirectionNext(direction);
    }
    trackSequence = kMapLeftQuarterTurn3TilesToRightQuarterTurn3Tiles[trackSequence];
    WoodenRCTrackLeftHalfBankedHelixUpSmall<isClassic, kLeftHalfBankedHelixUpSmallImages>(
        session, ride, trackSequence, DirectionPrev(direction), height, trackElement, supportType);
}

/** rct2: 0x008ACB18 */
template<bool isClassic>
static void WoodenRCTrackLeftHalfBankedHelixDownLarge(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    if (trackSequence >= 7)
    {
        trackSequence -= 7;
        direction = DirectionPrev(direction);
    }
    trackSequence = kMapLeftQuarterTurn5TilesToRightQuarterTurn5Tiles[trackSequence];
    WoodenRCTrackRightHalfBankedHelixUpLarge<isClassic, kRightHalfBankedHelixUpLargeImages>(
        session, ride, trackSequence, DirectionNext(direction), height, trackElement, supportType);
}

/** rct2: 0x008ACB28 */
template<bool isClassic>
static void WoodenRCTrackRightHalfBankedHelixDownLarge(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    if (trackSequence >= 7)
    {
        trackSequence -= 7;
        direction = DirectionNext(direction);
    }
    trackSequence = kMapLeftQuarterTurn5TilesToRightQuarterTurn5Tiles[trackSequence];
    WoodenRCTrackLeftHalfBankedHelixUpLarge<isClassic, kLeftHalfBankedHelixUpLargeImages>(
        session, ride, trackSequence, DirectionPrev(direction), height, trackElement, supportType);
}

/** rct2: 0x008ACB98 */
template<bool isClassic>
static void WoodenRCTrackLeftQuarterTurn160DegUp(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    switch (direction)
    {
        case 0:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24209), { 0, 0, height },
                { { 2, 2, height }, { 28, 28, 3 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25075), { 0, 0, height },
                { { 2, 2, height }, { 28, 28, 3 } });
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24217), { 0, 0, height },
                { { 2, 2, height + 86 }, { 28, 28, 1 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25083), { 0, 0, height },
                { { 2, 2, height + 86 }, { 28, 28, 1 } });
            break;
        case 1:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24210), { 0, 0, height },
                { { 2, 2, height }, { 28, 28, 3 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25076), { 0, 0, height },
                { { 2, 2, height }, { 28, 28, 3 } });
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24218), { 0, 0, height },
                { { 26, 26, height }, { 2, 2, 87 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25084), { 0, 0, height },
                { { 26, 26, height }, { 2, 2, 87 } });
            break;
        case 2:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24211), { 0, 0, height },
                { { 2, 2, height }, { 28, 28, 3 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25077), { 0, 0, height },
                { { 2, 2, height }, { 28, 28, 3 } });
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24219), { 0, 0, height },
                { { 26, 28, height }, { 2, 2, 87 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25085), { 0, 0, height },
                { { 26, 28, height }, { 2, 2, 87 } });
            break;
        case 3:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24212), { 0, 0, height },
                { { 2, 2, height }, { 28, 28, 3 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25078), { 0, 0, height },
                { { 2, 2, height }, { 28, 28, 3 } });
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24220), { 0, 0, height },
                { { 28, 28, height }, { 2, 2, 87 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25086), { 0, 0, height },
                { { 28, 28, height }, { 2, 2, 87 } });
            break;
    }
    TrackPaintUtilLeftQuarterTurn1TileTunnel(
        session, kTunnelGroup, direction, height, -8, TunnelSubType::SlopeStart, +56, TunnelSubType::SlopeEnd);
    PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + 104);
}

/** rct2: 0x008ACB78 */
template<bool isClassic>
static void WoodenRCTrackRightQuarterTurn160DegUp(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    switch (direction)
    {
        case 0:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24213), { 0, 0, height },
                { { 2, 2, height }, { 28, 28, 3 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25079), { 0, 0, height },
                { { 2, 2, height }, { 28, 28, 3 } });
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24221), { 0, 0, height },
                { { 28, 28, height }, { 2, 2, 87 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25087), { 0, 0, height },
                { { 28, 28, height }, { 2, 2, 87 } });
            break;
        case 1:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24214), { 0, 0, height },
                { { 2, 2, height }, { 28, 28, 3 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25080), { 0, 0, height },
                { { 2, 2, height }, { 28, 28, 3 } });
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24222), { 0, 0, height },
                { { 26, 28, height }, { 2, 2, 87 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25088), { 0, 0, height },
                { { 26, 28, height }, { 2, 2, 87 } });
            break;
        case 2:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24215), { 0, 0, height },
                { { 2, 2, height }, { 28, 28, 3 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25081), { 0, 0, height },
                { { 2, 2, height }, { 28, 28, 3 } });
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24223), { 0, 0, height },
                { { 26, 26, height }, { 2, 2, 87 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25089), { 0, 0, height },
                { { 26, 26, height }, { 2, 2, 87 } });
            break;
        case 3:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24216), { 0, 0, height },
                { { 2, 2, height }, { 28, 28, 3 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25082), { 0, 0, height },
                { { 2, 2, height }, { 28, 28, 3 } });
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24224), { 0, 0, height },
                { { 2, 2, height + 86 }, { 28, 28, 1 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25090), { 0, 0, height },
                { { 2, 2, height + 86 }, { 28, 28, 1 } });
            break;
    }
    TrackPaintUtilRightQuarterTurn1TileTunnel(
        session, kTunnelGroup, direction, height, -8, TunnelSubType::SlopeStart, +56, TunnelSubType::SlopeEnd);
    PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + 104);
}

/** rct2: 0x008ACB88 */
template<bool isClassic>
static void WoodenRCTrackLeftQuarterTurn160DegDown(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    WoodenRCTrackRightQuarterTurn160DegUp<isClassic>(
        session, ride, trackSequence, (direction + 1) & 3, height, trackElement, supportType);
}

/** rct2: 0x008ACBA8 */
template<bool isClassic>
static void WoodenRCTrackRightQuarterTurn160DegDown(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    WoodenRCTrackLeftQuarterTurn160DegUp<isClassic>(
        session, ride, trackSequence, (direction - 1) & 3, height, trackElement, supportType);
}

/** rct2: 0x008AC868 */
template<bool isClassic>
static void WoodenRCTrackBrakes(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    static constexpr uint32_t imageIds[4][2] = {
        { SPR_WOODEN_RC_BRAKES_SW_NE, SPR_WOODEN_RC_BRAKES_RAILS_SW_NE },
        { SPR_WOODEN_RC_BRAKES_NW_SE, SPR_WOODEN_RC_BRAKES_RAILS_NW_SE },
        { SPR_WOODEN_RC_BRAKES_SW_NE, SPR_WOODEN_RC_BRAKES_RAILS_SW_NE },
        { SPR_WOODEN_RC_BRAKES_NW_SE, SPR_WOODEN_RC_BRAKES_RAILS_NW_SE },
    };

    WoodenRCTrackPaint<isClassic>(
        session, direction, imageIds[direction][0], imageIds[direction][1], { 0, 2, height },
        { { 0, 3, height }, { 32, 25, 2 } });
    WoodenASupportsPaintSetupRotated(
        session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours);
    PaintUtilPushTunnelRotated(session, direction, height, kTunnelGroup, TunnelSubType::Flat);
    PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + kDefaultGeneralSupportHeight);
}

/** rct2: 0x008ACC78 */
template<bool isClassic>
static void WoodenRCTrack25DegUpLeftBanked(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    switch (direction)
    {
        case 0:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24249), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25115), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_TRACKS_WOODEN_RC_24249_FRONT),
                { 0, 0, height }, { { 4, 26, height + 5 }, { 24, 1, 9 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(SPR_TRACKS_WOODEN_RC_25115_FRONT),
                { 0, 0, height }, { { 4, 26, height + 5 }, { 24, 1, 9 } });
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::up25Deg);
            break;
        case 1:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24250), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25116), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24257), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25123), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::up25Deg);
            break;
        case 2:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24251), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25117), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24258), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25124), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::up25Deg);
            break;
        case 3:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24252), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25118), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::up25Deg);
            break;
    }
    if (direction == 0 || direction == 3)
    {
        PaintUtilPushTunnelRotated(session, direction, height - 8, kTunnelGroup, TunnelSubType::SlopeStart);
    }
    else
    {
        PaintUtilPushTunnelRotated(session, direction, height + 8, kTunnelGroup, TunnelSubType::SlopeEnd);
    }
    PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + 56);
}

/** rct2: 0x008ACC88 */
template<bool isClassic>
static void WoodenRCTrack25DegUpRightBanked(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    switch (direction)
    {
        case 0:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24253), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25119), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::up25Deg);
            break;
        case 1:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24254), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25120), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24259), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25125), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::up25Deg);
            break;
        case 2:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24255), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25121), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24260), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25126), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::up25Deg);
            break;
        case 3:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24256), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25122), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_TRACKS_WOODEN_RC_24256_FRONT),
                { 0, 0, height }, { { 0, 26, height + 5 }, { 32, 1, 9 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(SPR_TRACKS_WOODEN_RC_25122_FRONT),
                { 0, 0, height }, { { 0, 26, height + 5 }, { 32, 1, 9 } });
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::up25Deg);
            break;
    }
    if (direction == 0 || direction == 3)
    {
        PaintUtilPushTunnelRotated(session, direction, height - 8, kTunnelGroup, TunnelSubType::SlopeStart);
    }
    else
    {
        PaintUtilPushTunnelRotated(session, direction, height + 8, kTunnelGroup, TunnelSubType::SlopeEnd);
    }
    PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + 56);
}

/** rct2: 0x008AC878 */
template<bool isClassic>
static void WoodenRCTrackOnRidePhoto(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    switch (direction)
    {
        case 0:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23753), { 0, 2, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(24619), { 0, 2, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            break;
        case 1:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23754), { 0, 2, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(24620), { 0, 2, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            break;
        case 2:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23753), { 0, 2, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(24619), { 0, 2, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            break;
        case 3:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23754), { 0, 2, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(24620), { 0, 2, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            break;
    }
    WoodenASupportsPaintSetupRotated(
        session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours);
    TrackPaintUtilOnridePhotoSmallPaint(session, direction, height + 16, trackElement);
    PaintUtilPushTunnelRotated(session, direction, height, TunnelType::InvertedSquare);
    PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + 48);
}

template<bool isClassic>
static void WoodenRCTrackFlatTo60DegUpLongBase(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP + 0),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    PaintAddImageAsChildRotated(
                        session, direction,
                        WoodenRCGetRailsColour(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP_RAILS + 0),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP + 4),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    PaintAddImageAsChildRotated(
                        session, direction,
                        WoodenRCGetRailsColour(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP_RAILS + 4),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP_FRONT + 0),
                        { 0, 0, height }, { { 0, 6, height + 16 }, { 32, 18, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction,
                        WoodenRCGetRailsColour(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP_FRONT_RAILS + 0),
                        { 0, 0, height }, { { 0, 6, height + 16 }, { 32, 18, 0 } });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP + 8),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    PaintAddImageAsChildRotated(
                        session, direction,
                        WoodenRCGetRailsColour(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP_RAILS + 8),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP_FRONT + 4),
                        { 0, 0, height }, { { 0, 6, height + 16 }, { 32, 18, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction,
                        WoodenRCGetRailsColour(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP_FRONT_RAILS + 4),
                        { 0, 0, height }, { { 0, 6, height + 16 }, { 32, 18, 0 } });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP + 12),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    PaintAddImageAsChildRotated(
                        session, direction,
                        WoodenRCGetRailsColour(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP_RAILS + 12),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    break;
            }
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::flatToUp60DegLongBaseSeq0);
            if (direction == 0 || direction == 3)
            {
                PaintUtilPushTunnelRotated(session, direction, height, kTunnelGroup, TunnelSubType::Flat);
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 48);
            break;
        case 1:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP + 1),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    PaintAddImageAsChildRotated(
                        session, direction,
                        WoodenRCGetRailsColour(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP_RAILS + 1),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP + 5),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    PaintAddImageAsChildRotated(
                        session, direction,
                        WoodenRCGetRailsColour(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP_RAILS + 5),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP_FRONT + 1),
                        { 0, 0, height }, { { 0, 6, height + 32 }, { 32, 18, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction,
                        WoodenRCGetRailsColour(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP_FRONT_RAILS + 1),
                        { 0, 0, height }, { { 0, 6, height + 32 }, { 32, 18, 0 } });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP + 9),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    PaintAddImageAsChildRotated(
                        session, direction,
                        WoodenRCGetRailsColour(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP_RAILS + 9),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP_FRONT + 5),
                        { 0, 0, height }, { { 0, 6, height + 32 }, { 32, 18, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction,
                        WoodenRCGetRailsColour(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP_FRONT_RAILS + 5),
                        { 0, 0, height }, { { 0, 6, height + 32 }, { 32, 18, 0 } });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP + 13),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    PaintAddImageAsChildRotated(
                        session, direction,
                        WoodenRCGetRailsColour(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP_RAILS + 13),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    break;
            }
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::flatToUp60DegLongBaseSeq1);
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 48);
            break;
        case 2:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP + 2),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    PaintAddImageAsChildRotated(
                        session, direction,
                        WoodenRCGetRailsColour(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP_RAILS + 2),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP + 6),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    PaintAddImageAsChildRotated(
                        session, direction,
                        WoodenRCGetRailsColour(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP_RAILS + 6),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP_FRONT + 2),
                        { 0, 0, height }, { { 0, 6, height + 35 }, { 32, 18, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction,
                        WoodenRCGetRailsColour(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP_FRONT_RAILS + 2),
                        { 0, 0, height }, { { 0, 6, height + 35 }, { 32, 18, 0 } });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP + 10),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    PaintAddImageAsChildRotated(
                        session, direction,
                        WoodenRCGetRailsColour(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP_RAILS + 10),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP_FRONT + 6),
                        { 0, 0, height }, { { 0, 6, height + 35 }, { 32, 18, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction,
                        WoodenRCGetRailsColour(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP_FRONT_RAILS + 6),
                        { 0, 0, height }, { { 0, 6, height + 35 }, { 32, 18, 0 } });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP + 14),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    PaintAddImageAsChildRotated(
                        session, direction,
                        WoodenRCGetRailsColour(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP_RAILS + 14),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    break;
            }
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::flatToUp60DegLongBaseSeq2);
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 64);
            break;
        case 3:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP + 3),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    PaintAddImageAsChildRotated(
                        session, direction,
                        WoodenRCGetRailsColour(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP_RAILS + 3),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    break;
                case 1:
                    session.WoodenSupportsPrependTo = WoodenRCTrackPaint<isClassic>(
                        session, direction, SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP + 7,
                        SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP_RAILS + 7, { 0, 0, height },
                        { { 28, 4, height - 16 }, { 2, 24, 56 } });
                    break;
                case 2:
                    session.WoodenSupportsPrependTo = WoodenRCTrackPaint<isClassic>(
                        session, direction, SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP + 11,
                        SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP_RAILS + 11, { 0, 0, height },
                        { { 28, 4, height - 16 }, { 2, 24, 56 } });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP + 15),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    PaintAddImageAsChildRotated(
                        session, direction,
                        WoodenRCGetRailsColour(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP_RAILS + 15),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    break;
            }
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::flatToUp60DegLongBaseSeq3);
            switch (direction)
            {
                case 1:
                    PaintUtilPushTunnelRight(session, height + 24, kTunnelGroup, TunnelSubType::SlopeEnd);
                    break;
                case 2:
                    PaintUtilPushTunnelLeft(session, height + 24, kTunnelGroup, TunnelSubType::SlopeEnd);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 80);
            break;
    }
}

template<bool isClassic>
static void WoodenRCTrack60DegUpToFlatLongBase(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP + 16),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    PaintAddImageAsChildRotated(
                        session, direction,
                        WoodenRCGetRailsColour(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP_RAILS + 16),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    break;
                case 1:
                    session.WoodenSupportsPrependTo = WoodenRCTrackPaint<isClassic>(
                        session, direction, SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP + 20,
                        SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP_RAILS + 20, { 0, 0, height },
                        { { 28, 4, height - 16 }, { 2, 24, 76 } });
                    break;
                case 2:
                    session.WoodenSupportsPrependTo = WoodenRCTrackPaint<isClassic>(
                        session, direction, SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP + 24,
                        SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP_RAILS + 24, { 0, 0, height },
                        { { 28, 4, height - 16 }, { 2, 24, 76 } });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP + 28),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    PaintAddImageAsChildRotated(
                        session, direction,
                        WoodenRCGetRailsColour(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP_RAILS + 28),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    break;
            }
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::up60DegToFlatLongBaseSeq0);
            if (direction == 0 || direction == 3)
            {
                PaintUtilPushTunnelRotated(session, direction, height, kTunnelGroup, TunnelSubType::SlopeStart);
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 80);
            break;
        case 1:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP + 17),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    PaintAddImageAsChildRotated(
                        session, direction,
                        WoodenRCGetRailsColour(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP_RAILS + 17),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP + 21),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    PaintAddImageAsChildRotated(
                        session, direction,
                        WoodenRCGetRailsColour(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP_RAILS + 21),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP_FRONT + 9),
                        { 0, 0, height }, { { 0, 6, height + 40 }, { 32, 18, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction,
                        WoodenRCGetRailsColour(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP_FRONT_RAILS + 9),
                        { 0, 0, height }, { { 0, 6, height + 40 }, { 32, 18, 0 } });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP + 25),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    PaintAddImageAsChildRotated(
                        session, direction,
                        WoodenRCGetRailsColour(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP_RAILS + 25),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP_FRONT + 13),
                        { 0, 0, height }, { { 0, 6, height + 40 }, { 32, 18, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction,
                        WoodenRCGetRailsColour(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP_FRONT_RAILS + 13),
                        { 0, 0, height }, { { 0, 6, height + 40 }, { 32, 18, 0 } });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP + 29),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    PaintAddImageAsChildRotated(
                        session, direction,
                        WoodenRCGetRailsColour(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP_RAILS + 29),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    break;
            }
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::up60DegToFlatLongBaseSeq1);
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 80);
            break;
        case 2:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP + 18),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    PaintAddImageAsChildRotated(
                        session, direction,
                        WoodenRCGetRailsColour(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP_RAILS + 18),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP + 22),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    PaintAddImageAsChildRotated(
                        session, direction,
                        WoodenRCGetRailsColour(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP_RAILS + 22),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP_FRONT + 10),
                        { 0, 0, height }, { { 0, 6, height + 25 }, { 32, 18, 3 } });
                    PaintAddImageAsChildRotated(
                        session, direction,
                        WoodenRCGetRailsColour(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP_FRONT_RAILS + 10),
                        { 0, 0, height }, { { 0, 6, height + 25 }, { 32, 18, 3 } });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP + 26),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    PaintAddImageAsChildRotated(
                        session, direction,
                        WoodenRCGetRailsColour(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP_RAILS + 26),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP_FRONT + 14),
                        { 0, 0, height }, { { 0, 6, height + 25 }, { 32, 18, 3 } });
                    PaintAddImageAsChildRotated(
                        session, direction,
                        WoodenRCGetRailsColour(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP_FRONT_RAILS + 14),
                        { 0, 0, height }, { { 0, 6, height + 25 }, { 32, 18, 3 } });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP + 30),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    PaintAddImageAsChildRotated(
                        session, direction,
                        WoodenRCGetRailsColour(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP_RAILS + 30),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    break;
            }
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::up60DegToFlatLongBaseSeq2);
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 56);
            break;
        case 3:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP + 19),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    PaintAddImageAsChildRotated(
                        session, direction,
                        WoodenRCGetRailsColour(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP_RAILS + 19),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP + 23),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    PaintAddImageAsChildRotated(
                        session, direction,
                        WoodenRCGetRailsColour(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP_RAILS + 23),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP_FRONT + 11),
                        { 0, 0, height }, { { 0, 6, height + 25 }, { 32, 18, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction,
                        WoodenRCGetRailsColour(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP_FRONT_RAILS + 11),
                        { 0, 0, height }, { { 0, 6, height + 25 }, { 32, 18, 0 } });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP + 27),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    PaintAddImageAsChildRotated(
                        session, direction,
                        WoodenRCGetRailsColour(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP_RAILS + 27),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP_FRONT + 15),
                        { 0, 0, height }, { { 0, 6, height + 25 }, { 32, 18, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction,
                        WoodenRCGetRailsColour(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP_FRONT_RAILS + 15),
                        { 0, 0, height }, { { 0, 6, height + 25 }, { 32, 18, 0 } });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP + 31),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    PaintAddImageAsChildRotated(
                        session, direction,
                        WoodenRCGetRailsColour(session).WithIndex(SPR_TRACKS_WOODEN_RC_FLAT_TO_STEEP_RAILS + 31),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    break;
            }
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::up60DegToFlatLongBaseSeq3);
            switch (direction)
            {
                case 1:
                    PaintUtilPushTunnelRight(session, height + 8, kTunnelGroup, TunnelSubType::FlatTo25Deg);
                    break;
                case 2:
                    PaintUtilPushTunnelLeft(session, height + 8, kTunnelGroup, TunnelSubType::FlatTo25Deg);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 40);
            break;
    }
}

template<bool isClassic>
static void WoodenRCTrackFlatTo60DegDownLongBase(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    WoodenRCTrack60DegUpToFlatLongBase<isClassic>(
        session, ride, 3 - trackSequence, (direction + 2) & 3, height, trackElement, supportType);
}

template<bool isClassic>
static void WoodenRCTrack60DegDownToFlatLongBase(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    WoodenRCTrackFlatTo60DegUpLongBase<isClassic>(
        session, ride, 3 - trackSequence, (direction + 2) & 3, height, trackElement, supportType);
}

/** rct2: 0x008ACC98 */
template<bool isClassic>
static void WoodenRCTrack25DegDownLeftBanked(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    WoodenRCTrack25DegUpRightBanked<isClassic>(
        session, ride, trackSequence, (direction + 2) & 3, height, trackElement, supportType);
}

/** rct2: 0x008ACCA8 */
template<bool isClassic>
static void WoodenRCTrack25DegDownRightBanked(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    WoodenRCTrack25DegUpLeftBanked<isClassic>(
        session, ride, trackSequence, (direction + 2) & 3, height, trackElement, supportType);
}

/** rct2: 0x008ACE08 */
template<bool isClassic>
static void WoodenRCTrackWaterSplash(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    const bool transparent = Config::Get().general.transparentWater || (session.ViewFlags & VIEWPORT_FLAG_UNDERGROUND_INSIDE);
    const auto waterMask = ImageId(SPR_WATER_MASK).WithRemap(FilterPaletteID::paletteWater).WithBlended(true);
    const auto waterOverlay = ImageId(transparent ? EnumValue(SPR_WATER_OVERLAY) : EnumValue(SPR_G2_OPAQUE_WATER_OVERLAY));

    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23989), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24855), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterMask, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterOverlay, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(23997), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(24863), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23993), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24859), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23990), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24856), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterMask, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterOverlay, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(23998), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(24864), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23994), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24860), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23987), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24853), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterMask, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterOverlay, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(23995), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(24861), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23991), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24857), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23988), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24854), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterMask, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterOverlay, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(23996), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(24862), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23992), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24858), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    break;
            }
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours);
            PaintUtilPushTunnelRotated(session, direction, height + 16, kTunnelGroup, TunnelSubType::Flat);
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 48);
            break;
        case 1:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23977), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24843), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterMask, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterOverlay, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(23985), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(24851), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23981), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24847), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23978), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24844), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterMask, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterOverlay, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(23986), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(24852), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23982), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24848), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23975), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24841), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterMask, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterOverlay, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(23983), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(24849), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23979), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24845), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23976), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24842), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterMask, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterOverlay, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(23984), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(24850), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23980), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24846), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    break;
            }
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours);
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 48);
            break;
        case 2:
            switch (direction)
            {
                case 0:
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23999), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24865), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterMask, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterOverlay, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(24003), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(24869), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24001), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24867), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    break;
                case 1:
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24000), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24866), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterMask, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterOverlay, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(24004), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(24870), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24002), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24868), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    break;
            }
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours);
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 48);
            break;
        case 3:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23975), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24841), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterMask, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterOverlay, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(23983), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(24849), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23979), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24845), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23976), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24842), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterMask, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterOverlay, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(23984), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(24850), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23980), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24846), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23977), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24843), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterMask, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterOverlay, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(23985), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(24851), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23981), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24847), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23978), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24844), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterMask, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterOverlay, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(23986), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(24852), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23982), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24848), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    break;
            }
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours);
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 48);
            break;
        case 4:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23987), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24853), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterMask, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterOverlay, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(23995), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(24861), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23991), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24857), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23988), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24854), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterMask, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterOverlay, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(23996), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(24862), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23992), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24858), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23989), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24855), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterMask, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterOverlay, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(23997), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(24863), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23993), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24859), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23990), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24856), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterMask, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterOverlay, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(23998), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(24864), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23994), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24860), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    break;
            }
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours);
            PaintUtilPushTunnelRotated(session, direction, height + 16, kTunnelGroup, TunnelSubType::Flat);
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 48);
            break;
    }
}

/** rct2: 0x008AC958 */
template<bool isClassic>
static void WoodenRCTrackLeftEighthToDiag(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24137), { 0, 0, height },
                        { { 0, 0, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25003), { 0, 0, height },
                        { { 0, 0, height }, { 32, 32, 2 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::neSw, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24141), { 0, 0, height },
                        { { 0, 0, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25007), { 0, 0, height },
                        { { 0, 0, height }, { 32, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24153), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 32, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25019), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 32, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::nwSe, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24145), { 0, 0, height },
                        { { 0, 0, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25011), { 0, 0, height },
                        { { 0, 0, height }, { 32, 32, 2 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::neSw, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24149), { 0, 0, height },
                        { { 0, 0, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25015), { 0, 0, height },
                        { { 0, 0, height }, { 32, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24157), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 32, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25023), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 32, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::nwSe, height, session.SupportColours);
                    break;
            }
            if (direction == 0 || direction == 3)
            {
                PaintUtilPushTunnelRotated(session, direction, height, kTunnelGroup, TunnelSubType::Flat);
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + kDefaultGeneralSupportHeight);
            break;
        case 1:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24138), { 0, 0, height },
                        { { 0, 0, height }, { 32, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25004), { 0, 0, height },
                        { { 0, 0, height }, { 32, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::neSw, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24142), { 0, 0, height },
                        { { 0, 0, height }, { 34, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25008), { 0, 0, height },
                        { { 0, 0, height }, { 34, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24154), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 32, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25020), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 32, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::nwSe, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24146), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25012), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::neSw, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24150), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25016), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24158), { 0, 0, height },
                        { { 0, 16, height + 27 }, { 32, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25024), { 0, 0, height },
                        { { 0, 16, height + 27 }, { 32, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::nwSe, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + kDefaultGeneralSupportHeight);
            break;
        case 2:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24139), { 0, 0, height },
                        { { 0, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25005), { 0, 0, height },
                        { { 0, 16, height }, { 16, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner1, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24143), { 0, 0, height },
                        { { 16, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25009), { 0, 0, height },
                        { { 16, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24155), { 0, 0, height },
                        { { 16, 16, height + 27 }, { 16, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25021), { 0, 0, height },
                        { { 16, 16, height + 27 }, { 16, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner2, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24147), { 0, 0, height },
                        { { 16, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25013), { 0, 0, height },
                        { { 16, 0, height }, { 16, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner3, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24151), { 0, 0, height },
                        { { 0, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25017), { 0, 0, height },
                        { { 0, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24159), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 16, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25025), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 16, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner0, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + kDefaultGeneralSupportHeight);
            break;
        case 3:
            switch (direction)
            {
                case 0:
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner3, height, session.SupportColours);
                    break;
                case 1:
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner0, height, session.SupportColours);
                    break;
                case 2:
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner1, height, session.SupportColours);
                    break;
                case 3:
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner2, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + kDefaultGeneralSupportHeight);
            break;
        case 4:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24140), { 0, 0, height },
                        { { 16, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25006), { 0, 0, height },
                        { { 16, 16, height }, { 16, 16, 2 } });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24144), { 0, 0, height },
                        { { 0, 16, height }, { 16, 18, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25010), { 0, 0, height },
                        { { 0, 16, height }, { 16, 18, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24156), { 0, 0, height },
                        { { 0, 16, height + 27 }, { 16, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25022), { 0, 0, height },
                        { { 0, 16, height + 27 }, { 16, 16, 0 } });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24148), { 0, 0, height },
                        { { 0, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25014), { 0, 0, height },
                        { { 0, 0, height }, { 16, 16, 2 } });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24152), { 0, 0, height },
                        { { 16, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25018), { 0, 0, height },
                        { { 16, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24160), { 0, 0, height },
                        { { 16, 0, height + 27 }, { 16, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25026), { 0, 0, height },
                        { { 16, 0, height + 27 }, { 16, 16, 0 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + kDefaultGeneralSupportHeight);
            break;
    }
}

/** rct2: 0x008AC968 */
template<bool isClassic>
static void WoodenRCTrackRightEighthToDiag(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24113), { 0, 0, height },
                        { { 0, 0, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24979), { 0, 0, height },
                        { { 0, 0, height }, { 32, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24129), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 32, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24995), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 32, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::neSw, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24117), { 0, 0, height },
                        { { 0, 0, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24983), { 0, 0, height },
                        { { 0, 0, height }, { 32, 32, 2 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::nwSe, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24121), { 0, 0, height },
                        { { 0, 0, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24987), { 0, 0, height },
                        { { 0, 0, height }, { 32, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24133), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 32, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24999), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 32, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::neSw, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24125), { 0, 0, height },
                        { { 0, 0, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24991), { 0, 0, height },
                        { { 0, 0, height }, { 32, 32, 2 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::nwSe, height, session.SupportColours);
                    break;
            }
            if (direction == 0 || direction == 3)
            {
                PaintUtilPushTunnelRotated(session, direction, height, kTunnelGroup, TunnelSubType::Flat);
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + kDefaultGeneralSupportHeight);
            break;
        case 1:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24114), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24980), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24130), { 0, 0, height },
                        { { 0, 16, height + 27 }, { 32, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24996), { 0, 0, height },
                        { { 0, 16, height + 27 }, { 32, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::neSw, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24118), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24984), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::nwSe, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24122), { 0, 0, height },
                        { { 0, 0, height }, { 34, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24988), { 0, 0, height },
                        { { 0, 0, height }, { 34, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24134), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 32, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25000), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 32, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::neSw, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24126), { 0, 0, height },
                        { { 0, 0, height }, { 32, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24992), { 0, 0, height },
                        { { 0, 0, height }, { 32, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::nwSe, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + kDefaultGeneralSupportHeight);
            break;
        case 2:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24115), { 0, 0, height },
                        { { 0, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24981), { 0, 0, height },
                        { { 0, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24131), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 16, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24997), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 16, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner0, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24119), { 0, 0, height },
                        { { 16, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24985), { 0, 0, height },
                        { { 16, 0, height }, { 16, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner1, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24123), { 0, 0, height },
                        { { 16, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24989), { 0, 0, height },
                        { { 16, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24135), { 0, 0, height },
                        { { 16, 16, height + 27 }, { 16, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25001), { 0, 0, height },
                        { { 16, 16, height + 27 }, { 16, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner2, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24127), { 0, 0, height },
                        { { 0, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24993), { 0, 0, height },
                        { { 0, 16, height }, { 16, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner3, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + kDefaultGeneralSupportHeight);
            break;
        case 3:
            switch (direction)
            {
                case 0:
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner2, height, session.SupportColours);
                    break;
                case 1:
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner3, height, session.SupportColours);
                    break;
                case 2:
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner0, height, session.SupportColours);
                    break;
                case 3:
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner1, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + kDefaultGeneralSupportHeight);
            break;
        case 4:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24116), { 0, 0, height },
                        { { 16, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24982), { 0, 0, height },
                        { { 16, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24132), { 0, 0, height },
                        { { 16, 0, height + 27 }, { 16, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24998), { 0, 0, height },
                        { { 16, 0, height + 27 }, { 16, 16, 0 } });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24120), { 0, 0, height },
                        { { 0, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24986), { 0, 0, height },
                        { { 0, 0, height }, { 16, 16, 2 } });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24124), { 0, 0, height },
                        { { 0, 16, height }, { 16, 18, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24990), { 0, 0, height },
                        { { 0, 16, height }, { 16, 18, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24136), { 0, 0, height },
                        { { 0, 16, height + 27 }, { 16, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25002), { 0, 0, height },
                        { { 0, 16, height + 27 }, { 16, 16, 0 } });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24128), { 0, 0, height },
                        { { 16, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24994), { 0, 0, height },
                        { { 16, 16, height }, { 16, 16, 2 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + kDefaultGeneralSupportHeight);
            break;
    }
}

/** rct2: 0x008AC978 */
template<bool isClassic>
static void WoodenRCTrackLeftEighthToOrthogonal(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    trackSequence = mapLeftEighthTurnToOrthogonal[trackSequence];
    WoodenRCTrackRightEighthToDiag<isClassic>(
        session, ride, trackSequence, (direction + 2) & 3, height, trackElement, supportType);
}

/** rct2: 0x008AC988 */
template<bool isClassic>
static void WoodenRCTrackRightEighthToOrthogonal(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    trackSequence = mapLeftEighthTurnToOrthogonal[trackSequence];
    WoodenRCTrackLeftEighthToDiag<isClassic>(
        session, ride, trackSequence, (direction + 3) & 3, height, trackElement, supportType);
}

/** rct2: 0x008AC9B8 */
template<bool isClassic>
static void WoodenRCTrackLeftEighthBankToOrthogonal(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    trackSequence = mapLeftEighthTurnToOrthogonal[trackSequence];
    WoodenRCTrackRightEighthBankToDiag<isClassic, kRightEighthBankToDiagImages>(
        session, ride, trackSequence, DirectionReverse(direction), height, trackElement, supportType);
}

/** rct2: 0x008AC9C8 */
template<bool isClassic>
static void WoodenRCTrackRightEighthBankToOrthogonal(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    trackSequence = mapLeftEighthTurnToOrthogonal[trackSequence];
    WoodenRCTrackLeftEighthBankToDiag<isClassic, kLeftEighthBankToDiagImages>(
        session, ride, trackSequence, DirectionPrev(direction), height, trackElement, supportType);
}

template<bool isClassic>
static void WoodenRCTrackDiagBrakes(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    static constexpr SpriteBoundBox2 imageIds[4][kNumOrthogonalDirections][2] = {
        {
            // sequence 0
            {
                // direction 0
                { 0, 0, {}, BoundBoxXYZ({}, {}) },
                { 0, 0, {}, BoundBoxXYZ({}, {}) },
            },
            {
                // direction 1
                { 0, 0, {}, BoundBoxXYZ({}, {}) },
                { 0, 0, {}, BoundBoxXYZ({}, {}) },
            },
            {
                // direction 2
                { 0, 0, {}, BoundBoxXYZ({}, {}) },
                { 0, 0, {}, BoundBoxXYZ({}, {}) },
            },
            {
                // direction 3
                {
                    kWoodenRCDiagBrakeImages[3],
                    24916, // diagonal vertical trim image
                    { -16, -16, 0 },
                    { { -16, -16, 0 }, { 32, 32, 2 } },
                },
                { 0, 0, {}, BoundBoxXYZ({}, {}) },
            },
        },
        {
            // sequence 1
            {
                // direction 0
                {
                    kWoodenRCDiagBrakeImages[0],
                    24913, // diagonal horizontal trim image
                    { -16, -16, 0 },
                    { { -16, -16, 0 }, { 32, 32, 2 } },
                },
                {
                    24051, // diagonal horizontal railing image
                    24917, // diagonal horizontal foreground trim image
                    { -16, -16, 0 },
                    { { -16, -16, 27 }, { 32, 32, 0 } },
                },
            },
            {
                // direction 1
                { 0, 0, {}, BoundBoxXYZ({}, {}) },
                { 0, 0, {}, BoundBoxXYZ({}, {}) },
            },
            {
                // direction 2
                { 0, 0, {}, BoundBoxXYZ({}, {}) },
                { 0, 0, {}, BoundBoxXYZ({}, {}) },
            },
            {
                // direction 3
                { 0, 0, {}, BoundBoxXYZ({}, {}) },
                { 0, 0, {}, BoundBoxXYZ({}, {}) },
            },
        },
        {
            // sequence 2
            {
                // direction 0
                { 0, 0, {}, BoundBoxXYZ({}, {}) },
                { 0, 0, {}, BoundBoxXYZ({}, {}) },
            },
            {
                // direction 1
                { 0, 0, {}, BoundBoxXYZ({}, {}) },
                { 0, 0, {}, BoundBoxXYZ({}, {}) },
            },
            {
                // direction 2
                {
                    kWoodenRCDiagBrakeImages[2],
                    24913, // diagonal vertical trim image
                    { -16, -16, 0 },
                    { { -16, -16, 0 }, { 32, 32, 2 } },
                },
                {
                    24051, // diagonal vertical railing image
                    24917, // diagonal vertical foreground trim image
                    { -16, -16, 0 },
                    { { -16, -16, 27 }, { 32, 32, 0 } },
                },
            },
            {
                { 0, 0, {}, BoundBoxXYZ({}, {}) },
                { 0, 0, {}, BoundBoxXYZ({}, {}) },
            }, // direction 3
        },
        {
            // sequence 3
            {
                // direction 0
                { 0, 0, {}, BoundBoxXYZ({}, {}) },
                { 0, 0, {}, BoundBoxXYZ({}, {}) },
            },
            {
                // direction 1
                {
                    kWoodenRCDiagBrakeImages[1],
                    24916, // diagonal vertical trim image
                    { -16, -16, 0 },
                    { { -16, -16, 0 }, { 32, 32, 2 } },
                },
                { 0, 0, {}, BoundBoxXYZ({}, {}) },
            },
            {
                // direction 2
                { 0, 0, {}, BoundBoxXYZ({}, {}) },
                { 0, 0, {}, BoundBoxXYZ({}, {}) },
            },
            {
                // direction 3
                { 0, 0, {}, BoundBoxXYZ({}, {}) },
                { 0, 0, {}, BoundBoxXYZ({}, {}) },
            },
        },
    };

    WoodenRCTrackPaintBb<isClassic>(session, &imageIds[trackSequence][direction][0], height);
    WoodenRCTrackPaintBb<isClassic>(session, &imageIds[trackSequence][direction][0], height);

    if (kWoodenRCDiagonalSupports[trackSequence][direction] != WoodenSupportSubType::null)
    {
        WoodenASupportsPaintSetup(
            session, supportType.wooden, kWoodenRCDiagonalSupports[trackSequence][direction], height, session.SupportColours);
    }

    PaintUtilSetSegmentSupportHeight(session, PaintUtilRotateSegments(kSegmentsAll, direction), 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + kDefaultGeneralSupportHeight);
}

template<bool isClassic>
static void WoodenRCTrackDiagBlockBrakes(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    static constexpr SpriteBoundBox2 imageIds[2][4][kNumOrthogonalDirections][2] = {
        {
            {
                // sequence 0
                {
                    // direction 0
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                },
                {
                    // direction 1
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                },
                {
                    // direction 2
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                },
                {
                    // direction 3
                    {
                        kWoodenRCDiagBlockBrakeImages[0][3],
                        24916,           // diagonal vertical trim image
                        { -16, -16, 0 }, // todo: rotate these bboxes
                        BoundBoxXYZ({ -16, -16, 0 }, { 32, 32, 2 }),
                    },
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                },
            },
            {
                // sequence 1
                {
                    // direction 0
                    {
                        kWoodenRCDiagBlockBrakeImages[0][0],
                        24913, // diagonal horizontal trim image
                        { -16, -16, 0 },
                        BoundBoxXYZ({ -16, -16, 0 }, { 32, 32, 2 }),
                    },
                    {
                        24051, // diagonal horizontal railing image
                        24917, // diagonal horizontal foreground trim image
                        { -16, -16, 0 },
                        BoundBoxXYZ({ -16, -16, 27 }, { 32, 32, 0 }),
                    },
                },
                {
                    // direction 1
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                },
                {
                    // direction 2
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                },
                {
                    // direction 3
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                },
            },
            {
                // sequence 2
                {
                    // direction 0
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                },
                {
                    // direction 1
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                },
                {
                    // direction 2
                    {
                        kWoodenRCDiagBlockBrakeImages[0][2],
                        24913, // diagonal vertical trim image
                        { -16, -16, 0 },
                        BoundBoxXYZ({ -16, -16, 0 }, { 32, 32, 2 }),
                    },
                    {
                        24051, // diagonal vertical railing image
                        24917, // diagonal vertical foreground trim image
                        { -16, -16, 0 },
                        BoundBoxXYZ({ -16, -16, 27 }, { 32, 32, 0 }),
                    },
                },
                {
                    // direction 3
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                },
            },
            {
                // sequence 3
                {
                    // direction 0
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                },
                {
                    // direction 1
                    {
                        kWoodenRCDiagBlockBrakeImages[0][1],
                        24916, // diagonal vertical trim image
                        { -16, -16, 0 },
                        BoundBoxXYZ({ -16, -16, 0 }, { 32, 32, 2 }),
                    },
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                },
                {
                    // direction 2
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                },
                {
                    // direction 3
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                },
            },
        },
        {
            {
                // sequence 0
                {
                    // direction 0
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                },
                {
                    // direction 1
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                },
                {
                    // direction 2
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                },
                {
                    // direction 3
                    {
                        kWoodenRCDiagBlockBrakeImages[1][3],
                        24916, // diagonal vertical trim image
                        { -16, -16, 0 },
                        BoundBoxXYZ({ -16, -16, 0 }, { 32, 32, 2 }),
                    },
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                },
            },
            {
                // sequence 1
                {
                    // direction 0
                    {
                        kWoodenRCDiagBlockBrakeImages[1][0],
                        24913, // diagonal horizontal trim image
                        { -16, -16, 0 },
                        BoundBoxXYZ({ -16, -16, 0 }, { 32, 32, 2 }),
                    },
                    {
                        24051, // diagonal horizontal railing image
                        24917, // diagonal horizontal foreground trim image
                        { -16, -16, 0 },
                        BoundBoxXYZ({ -16, -16, 27 }, { 32, 32, 0 }),
                    },
                },
                {
                    // direction 1
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                },
                {
                    // direction 2
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                },
                {
                    // direction 3
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                },
            },
            {
                // sequence 2
                {
                    // direction 0
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                },
                {
                    // direction 1
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                },
                {
                    // direction 2
                    {
                        kWoodenRCDiagBlockBrakeImages[1][2],
                        24913, // diagonal vertical trim image
                        { -16, -16, 0 },
                        BoundBoxXYZ({ -16, -16, 0 }, { 32, 32, 2 }),
                    },
                    {
                        24051, // diagonal vertical railing image
                        24917, // diagonal vertical foreground trim image
                        { -16, -16, 0 },
                        BoundBoxXYZ({ -16, -16, 27 }, { 32, 32, 0 }),
                    },
                },
                {
                    // direction 3
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                },
            },
            {
                // sequence 3
                {
                    // direction 0
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                },
                {
                    // direction 1
                    {
                        kWoodenRCDiagBlockBrakeImages[1][1],
                        24916, // diagonal vertical trim image
                        { -16, -16, 0 },
                        BoundBoxXYZ({ -16, -16, 0 }, { 32, 32, 2 }),
                    },
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                },
                {
                    // direction 2
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                },
                {
                    // direction 3
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                },
            },
        },
    };

    WoodenRCTrackPaintBb<isClassic>(session, &imageIds[trackElement.IsBrakeClosed()][trackSequence][direction][0], height);
    WoodenRCTrackPaintBb<isClassic>(session, &imageIds[trackElement.IsBrakeClosed()][trackSequence][direction][0], height);

    if (kWoodenRCDiagonalSupports[trackSequence][direction] != WoodenSupportSubType::null)
    {
        WoodenASupportsPaintSetup(
            session, supportType.wooden, kWoodenRCDiagonalSupports[trackSequence][direction], height, session.SupportColours);
    }

    PaintUtilSetSegmentSupportHeight(session, PaintUtilRotateSegments(kSegmentsAll, direction), 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + kDefaultGeneralSupportHeight);
}

/** rct2: 0x008AC888 */
template<bool isClassic>
static void WoodenRCTrackDiagFlat(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    switch (trackSequence)
    {
        case 0:
            if (trackElement.HasChain())
            {
                switch (direction)
                {
                    case 3:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24050),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24916), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        break;
                }
            }
            else
            {
                switch (direction)
                {
                    case 3:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24008),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24874), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        break;
                }
            }

            break;
        case 1:
            if (trackElement.HasChain())
            {
                switch (direction)
                {
                    case 0:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24047),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24913), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24051),
                            { -16, -16, height }, { { -16, -16, height + 24 }, { 32, 32, 0 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24917), { -16, -16, height },
                            { { -16, -16, height + 24 }, { 32, 32, 0 } });
                        break;
                }
            }
            else
            {
                switch (direction)
                {
                    case 0:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24005),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24871), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24009),
                            { -16, -16, height }, { { -16, -16, height + 24 }, { 32, 32, 0 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24875), { -16, -16, height },
                            { { -16, -16, height + 24 }, { 32, 32, 0 } });
                        break;
                }
            }

            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::corner0, direction, height, session.SupportColours);

            break;
        case 2:
            if (trackElement.HasChain())
            {
                switch (direction)
                {
                    case 2:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24049),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24915), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24052),
                            { -16, -16, height }, { { -16, -16, height + 24 }, { 32, 32, 0 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24918), { -16, -16, height },
                            { { -16, -16, height + 24 }, { 32, 32, 0 } });
                        break;
                }
            }
            else
            {
                switch (direction)
                {
                    case 2:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24007),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24873), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24010),
                            { -16, -16, height }, { { -16, -16, height + 24 }, { 32, 32, 0 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24876), { -16, -16, height },
                            { { -16, -16, height + 24 }, { 32, 32, 0 } });
                        break;
                }
            }

            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::corner2, direction, height, session.SupportColours);

            break;
        case 3:
            if (trackElement.HasChain())
            {
                switch (direction)
                {
                    case 1:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24048),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24914), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        break;
                }
            }
            else
            {
                switch (direction)
                {
                    case 1:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24006),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24872), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        break;
                }
            }

            break;
    }

    PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + kDefaultGeneralSupportHeight);
}

/** rct2: 0x008AC8B8 */
template<bool isClassic>
static void WoodenRCTrackDiag25DegUp(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    switch (trackSequence)
    {
        case 0:
            if (trackElement.HasChain())
            {
                switch (direction)
                {
                    case 3:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24068),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24934), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        break;
                }
            }
            else
            {
                switch (direction)
                {
                    case 3:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24026),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24892), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        break;
                }
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 56);
            break;
        case 1:
            if (trackElement.HasChain())
            {
                switch (direction)
                {
                    case 0:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24065),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24931), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24069),
                            { -16, -16, height }, { { -16, -16, height + 43 }, { 32, 32, 0 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24935), { -16, -16, height },
                            { { -16, -16, height + 43 }, { 32, 32, 0 } });
                        break;
                }
                WoodenBSupportsPaintSetupRotated(
                    session, supportType.wooden, WoodenSupportSubType::corner0, direction, height + 16, session.SupportColours);
            }
            else
            {
                switch (direction)
                {
                    case 0:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24023),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24889), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24027),
                            { -16, -16, height }, { { -16, -16, height + 43 }, { 32, 32, 0 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24893), { -16, -16, height },
                            { { -16, -16, height + 43 }, { 32, 32, 0 } });
                        break;
                }
                WoodenBSupportsPaintSetupRotated(
                    session, supportType.wooden, WoodenSupportSubType::corner0, direction, height + 16, session.SupportColours);
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 56);
            break;
        case 2:
            if (trackElement.HasChain())
            {
                switch (direction)
                {
                    case 2:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24067),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24933), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24070),
                            { -16, -16, height }, { { -16, -16, height + 43 }, { 32, 32, 0 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24936), { -16, -16, height },
                            { { -16, -16, height + 43 }, { 32, 32, 0 } });
                        break;
                }
            }
            else
            {
                switch (direction)
                {
                    case 2:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24025),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24891), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24028),
                            { -16, -16, height }, { { -16, -16, height + 43 }, { 32, 32, 0 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24894), { -16, -16, height },
                            { { -16, -16, height + 43 }, { 32, 32, 0 } });
                        break;
                }
            }

            WoodenBSupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::corner2, direction, height + 16, session.SupportColours);

            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 56);
            break;
        case 3:
            if (trackElement.HasChain())
            {
                switch (direction)
                {
                    case 1:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24066),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24932), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        break;
                }
            }
            else
            {
                switch (direction)
                {
                    case 1:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24024),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24890), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        break;
                }
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 56);
            break;
    }
}

/** rct2: 0x008AC8E8 */
template<bool isClassic>
static void WoodenRCTrackDiag60DegUp(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24044), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24910), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 104);
            break;
        case 1:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24041), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24907), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24045), { -16, -16, height },
                        { { -16, -16, height + 91 }, { 32, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24911), { -16, -16, height },
                        { { -16, -16, height + 91 }, { 32, 32, 0 } });
                    break;
            }
            WoodenBSupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::corner0, direction, height + 16, session.SupportColours);
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 104);
            break;
        case 2:
            switch (direction)
            {
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24043), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24909), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24046), { -16, -16, height },
                        { { -16, -16, height + 91 }, { 32, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24912), { -16, -16, height },
                        { { -16, -16, height + 91 }, { 32, 32, 0 } });
                    break;
            }

            WoodenBSupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::corner2, direction, height + 16, session.SupportColours);

            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 104);
            break;
        case 3:
            switch (direction)
            {
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24042), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24908), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 104);
            break;
    }
}

/** rct2: 0x008AC898 */
template<bool isClassic>
static void WoodenRCTrackDiagFlatTo25DegUp(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    switch (trackSequence)
    {
        case 0:
            if (trackElement.HasChain())
            {
                switch (direction)
                {
                    case 3:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24056),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24922), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        break;
                }
            }
            else
            {
                switch (direction)
                {
                    case 3:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24014),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24880), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        break;
                }
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 48);
            break;
        case 1:
            if (trackElement.HasChain())
            {
                switch (direction)
                {
                    case 0:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24053),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24919), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24057),
                            { -16, -16, height }, { { -16, -16, height + 35 }, { 32, 32, 0 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24923), { -16, -16, height },
                            { { -16, -16, height + 35 }, { 32, 32, 0 } });
                        WoodenASupportsPaintSetup(
                            session, supportType.wooden, WoodenSupportSubType::corner0, height, session.SupportColours);
                        break;
                    case 1:
                        WoodenASupportsPaintSetup(
                            session, supportType.wooden, WoodenSupportSubType::corner1, height, session.SupportColours);
                        break;
                    case 2:
                        WoodenASupportsPaintSetup(
                            session, supportType.wooden, WoodenSupportSubType::corner2, height, session.SupportColours);
                        break;
                    case 3:
                        WoodenASupportsPaintSetup(
                            session, supportType.wooden, WoodenSupportSubType::corner3, height, session.SupportColours);
                        break;
                }
            }
            else
            {
                switch (direction)
                {
                    case 0:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24011),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24877), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24015),
                            { -16, -16, height }, { { -16, -16, height + 35 }, { 32, 32, 0 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24881), { -16, -16, height },
                            { { -16, -16, height + 35 }, { 32, 32, 0 } });
                        WoodenASupportsPaintSetup(
                            session, supportType.wooden, WoodenSupportSubType::corner0, height, session.SupportColours);
                        break;
                    case 1:
                        WoodenASupportsPaintSetup(
                            session, supportType.wooden, WoodenSupportSubType::corner1, height, session.SupportColours);
                        break;
                    case 2:
                        WoodenASupportsPaintSetup(
                            session, supportType.wooden, WoodenSupportSubType::corner2, height, session.SupportColours);
                        break;
                    case 3:
                        WoodenASupportsPaintSetup(
                            session, supportType.wooden, WoodenSupportSubType::corner3, height, session.SupportColours);
                        break;
                }
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 48);
            break;
        case 2:
            if (trackElement.HasChain())
            {
                switch (direction)
                {
                    case 0:
                        WoodenASupportsPaintSetup(
                            session, supportType.wooden, WoodenSupportSubType::corner2, height, session.SupportColours);
                        break;
                    case 1:
                        WoodenASupportsPaintSetup(
                            session, supportType.wooden, WoodenSupportSubType::corner3, height, session.SupportColours);
                        break;
                    case 2:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24055),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24921), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24058),
                            { -16, -16, height }, { { -16, -16, height + 35 }, { 32, 32, 0 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24924), { -16, -16, height },
                            { { -16, -16, height + 35 }, { 32, 32, 0 } });
                        WoodenASupportsPaintSetup(
                            session, supportType.wooden, WoodenSupportSubType::corner0, height, session.SupportColours);
                        break;
                    case 3:
                        WoodenASupportsPaintSetup(
                            session, supportType.wooden, WoodenSupportSubType::corner1, height, session.SupportColours);
                        break;
                }
            }
            else
            {
                switch (direction)
                {
                    case 0:
                        WoodenASupportsPaintSetup(
                            session, supportType.wooden, WoodenSupportSubType::corner2, height, session.SupportColours);
                        break;
                    case 1:
                        WoodenASupportsPaintSetup(
                            session, supportType.wooden, WoodenSupportSubType::corner3, height, session.SupportColours);
                        break;
                    case 2:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24013),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24879), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24016),
                            { -16, -16, height }, { { -16, -16, height + 35 }, { 32, 32, 0 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24882), { -16, -16, height },
                            { { -16, -16, height + 35 }, { 32, 32, 0 } });
                        WoodenASupportsPaintSetup(
                            session, supportType.wooden, WoodenSupportSubType::corner0, height, session.SupportColours);
                        break;
                    case 3:
                        WoodenASupportsPaintSetup(
                            session, supportType.wooden, WoodenSupportSubType::corner1, height, session.SupportColours);
                        break;
                }
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 48);
            break;
        case 3:
            if (trackElement.HasChain())
            {
                switch (direction)
                {
                    case 1:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24054),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24920), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        break;
                }
            }
            else
            {
                switch (direction)
                {
                    case 1:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24012),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24878), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        break;
                }
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 48);
            break;
    }
}

/** rct2: 0x008AC8C8 */
template<bool isClassic>
static void WoodenRCTrackDiag25DegUpTo60DegUp(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24032), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24898), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72);
            break;
        case 1:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24029), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24895), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24033), { -16, -16, height },
                        { { -16, -16, height + 59 }, { 32, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24899), { -16, -16, height },
                        { { -16, -16, height + 59 }, { 32, 32, 0 } });
                    break;
            }
            WoodenBSupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::corner0, direction, height + 16, session.SupportColours);
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72);
            break;
        case 2:
            switch (direction)
            {
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24031), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24897), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24034), { -16, -16, height },
                        { { -16, -16, height + 59 }, { 32, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24900), { -16, -16, height },
                        { { -16, -16, height + 59 }, { 32, 32, 0 } });
                    break;
            }

            WoodenBSupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::corner2, direction, height + 16, session.SupportColours);

            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72);
            break;
        case 3:
            switch (direction)
            {
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24030), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24896), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72);
            break;
    }
}

/** rct2: 0x008AC8D8 */
template<bool isClassic>
static void WoodenRCTrackDiag60DegUpTo25DegUp(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24038), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24904), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72);
            break;
        case 1:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24035), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24901), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24039), { -16, -16, height },
                        { { -16, -16, height + 59 }, { 32, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24905), { -16, -16, height },
                        { { -16, -16, height + 59 }, { 32, 32, 0 } });
                    break;
            }
            WoodenBSupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::corner0, direction, height + 16, session.SupportColours);
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72);
            break;
        case 2:
            switch (direction)
            {
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24037), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24903), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24040), { -16, -16, height },
                        { { -16, -16, height + 59 }, { 32, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24906), { -16, -16, height },
                        { { -16, -16, height + 59 }, { 32, 32, 0 } });
                    break;
            }
            WoodenBSupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::corner2, direction, height + 16, session.SupportColours);
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72);
            break;
        case 3:
            switch (direction)
            {
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24036), { -16, -16, height },
                        { { 0, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24902), { -16, -16, height },
                        { { 0, 0, height }, { 16, 16, 2 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72);
            break;
    }
}

/** rct2: 0x008AC8A8 */
template<bool isClassic>
static void WoodenRCTrackDiag25DegUpToFlat(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    switch (trackSequence)
    {
        case 0:
            if (trackElement.HasChain())
            {
                switch (direction)
                {
                    case 3:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24062),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24928), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        break;
                }
            }
            else
            {
                switch (direction)
                {
                    case 3:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24020),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24886), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        break;
                }
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 56);
            break;
        case 1:
            if (trackElement.HasChain())
            {
                switch (direction)
                {
                    case 0:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24059),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24925), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24063),
                            { -16, -16, height }, { { -16, -16, height + 35 }, { 32, 32, 0 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24929), { -16, -16, height },
                            { { -16, -16, height + 35 }, { 32, 32, 0 } });
                        break;
                }
                WoodenBSupportsPaintSetupRotated(
                    session, supportType.wooden, WoodenSupportSubType::corner0, direction, height + 16, session.SupportColours);
            }
            else
            {
                switch (direction)
                {
                    case 0:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24017),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24883), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24021),
                            { -16, -16, height }, { { -16, -16, height + 35 }, { 32, 32, 0 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24887), { -16, -16, height },
                            { { -16, -16, height + 35 }, { 32, 32, 0 } });
                        break;
                }
                WoodenBSupportsPaintSetupRotated(
                    session, supportType.wooden, WoodenSupportSubType::corner0, direction, height + 16, session.SupportColours);
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 56);
            break;
        case 2:
            if (trackElement.HasChain())
            {
                switch (direction)
                {
                    case 2:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24061),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24927), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24064),
                            { -16, -16, height }, { { -16, -16, height + 35 }, { 32, 32, 0 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24930), { -16, -16, height },
                            { { -16, -16, height + 35 }, { 32, 32, 0 } });
                        break;
                }
            }
            else
            {
                switch (direction)
                {
                    case 2:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24019),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24885), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24022),
                            { -16, -16, height }, { { -16, -16, height + 35 }, { 32, 32, 0 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24888), { -16, -16, height },
                            { { -16, -16, height + 35 }, { 32, 32, 0 } });
                        break;
                }
            }

            WoodenBSupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::corner2, direction, height + 16, session.SupportColours);

            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 56);
            break;
        case 3:
            if (trackElement.HasChain())
            {
                switch (direction)
                {
                    case 1:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24060),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24926), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        break;
                }
            }
            else
            {
                switch (direction)
                {
                    case 1:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24018),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24884), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        break;
                }
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 56);
            break;
    }
}

/** rct2: 0x008AC918 */
template<bool isClassic>
static void WoodenRCTrackDiag25DegDown(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    switch (trackSequence)
    {
        case 0:
            if (trackElement.HasChain())
            {
                switch (direction)
                {
                    case 3:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24066),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24932), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        break;
                }
            }
            else
            {
                switch (direction)
                {
                    case 3:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24024),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24890), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        break;
                }
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 56);
            break;
        case 1:
            if (trackElement.HasChain())
            {
                switch (direction)
                {
                    case 0:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24067),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24933), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24070),
                            { -16, -16, height }, { { -16, -16, height + 43 }, { 32, 32, 0 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24936), { -16, -16, height },
                            { { -16, -16, height + 43 }, { 32, 32, 0 } });
                        break;
                }
                WoodenBSupportsPaintSetupRotated(
                    session, supportType.wooden, WoodenSupportSubType::corner0, direction, height + 16, session.SupportColours);
            }
            else
            {
                switch (direction)
                {
                    case 0:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24025),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24891), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24028),
                            { -16, -16, height }, { { -16, -16, height + 43 }, { 32, 32, 0 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24894), { -16, -16, height },
                            { { -16, -16, height + 43 }, { 32, 32, 0 } });
                        break;
                }
                WoodenBSupportsPaintSetupRotated(
                    session, supportType.wooden, WoodenSupportSubType::corner0, direction, height + 16, session.SupportColours);
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 56);
            break;
        case 2:
            if (trackElement.HasChain())
            {
                switch (direction)
                {
                    case 2:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24065),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24931), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24069),
                            { -16, -16, height }, { { -16, -16, height + 43 }, { 32, 32, 0 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24935), { -16, -16, height },
                            { { -16, -16, height + 43 }, { 32, 32, 0 } });
                        break;
                }
            }
            else
            {
                switch (direction)
                {
                    case 2:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24023),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24889), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24027),
                            { -16, -16, height }, { { -16, -16, height + 43 }, { 32, 32, 0 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24893), { -16, -16, height },
                            { { -16, -16, height + 43 }, { 32, 32, 0 } });
                        break;
                }
            }

            WoodenBSupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::corner2, direction, height + 16, session.SupportColours);

            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 56);
            break;
        case 3:
            if (trackElement.HasChain())
            {
                switch (direction)
                {
                    case 1:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24068),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24934), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        break;
                }
            }
            else
            {
                switch (direction)
                {
                    case 1:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24026),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24892), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        break;
                }
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 56);
            break;
    }
}

/** rct2: 0x008AC948 */
template<bool isClassic>
static void WoodenRCTrackDiag60DegDown(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24042), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24908), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 104);
            break;
        case 1:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24043), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24909), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24046), { -16, -16, height },
                        { { -16, -16, height + 91 }, { 32, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24912), { -16, -16, height },
                        { { -16, -16, height + 91 }, { 32, 32, 0 } });
                    break;
            }
            WoodenBSupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::corner0, direction, height + 16, session.SupportColours);
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 104);
            break;
        case 2:
            switch (direction)
            {
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24041), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24907), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24045), { -16, -16, height },
                        { { -16, -16, height + 91 }, { 32, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24911), { -16, -16, height },
                        { { -16, -16, height + 91 }, { 32, 32, 0 } });
                    break;
            }
            WoodenBSupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::corner2, direction, height + 16, session.SupportColours);
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 104);
            break;
        case 3:
            switch (direction)
            {
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24044), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24910), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 104);
            break;
    }
}

/** rct2: 0x008AC8F8 */
template<bool isClassic>
static void WoodenRCTrackDiagFlatTo25DegDown(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    switch (trackSequence)
    {
        case 0:
            if (trackElement.HasChain())
            {
                switch (direction)
                {
                    case 3:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24060),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24926), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        break;
                }
            }
            else
            {
                switch (direction)
                {
                    case 3:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24018),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24884), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        break;
                }
            }
            break;
        case 1:
            if (trackElement.HasChain())
            {
                switch (direction)
                {
                    case 0:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24061),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24927), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24064),
                            { -16, -16, height }, { { -16, -16, height + 32 }, { 32, 32, 0 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24930), { -16, -16, height },
                            { { -16, -16, height + 32 }, { 32, 32, 0 } });
                        break;
                }
                WoodenBSupportsPaintSetupRotated(
                    session, supportType.wooden, WoodenSupportSubType::corner0, direction, height + 16, session.SupportColours);
            }
            else
            {
                switch (direction)
                {
                    case 0:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24019),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24885), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24022),
                            { -16, -16, height }, { { -16, -16, height + 32 }, { 32, 32, 0 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24888), { -16, -16, height },
                            { { -16, -16, height + 32 }, { 32, 32, 0 } });
                        break;
                }
                WoodenBSupportsPaintSetupRotated(
                    session, supportType.wooden, WoodenSupportSubType::corner0, direction, height + 16, session.SupportColours);
            }
            break;
        case 2:
            if (trackElement.HasChain())
            {
                switch (direction)
                {
                    case 2:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24059),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24925), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24063),
                            { -16, -16, height }, { { -16, -16, height + 32 }, { 32, 32, 0 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24929), { -16, -16, height },
                            { { -16, -16, height + 32 }, { 32, 32, 0 } });
                        break;
                }
            }
            else
            {
                switch (direction)
                {
                    case 2:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24017),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24883), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24021),
                            { -16, -16, height }, { { -16, -16, height + 32 }, { 32, 32, 0 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24887), { -16, -16, height },
                            { { -16, -16, height + 32 }, { 32, 32, 0 } });
                        break;
                }
            }

            WoodenBSupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::corner2, direction, height + 16, session.SupportColours);

            break;
        case 3:
            if (trackElement.HasChain())
            {
                switch (direction)
                {
                    case 1:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24062),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24928), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        break;
                }
            }
            else
            {
                switch (direction)
                {
                    case 1:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24020),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24886), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        break;
                }
            }
            break;
    }

    PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + 56);
}

/** rct2: 0x008AC928 */
template<bool isClassic>
static void WoodenRCTrackDiag25DegDownTo60DegDown(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24036), { -16, -16, height },
                        { { 0, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24902), { -16, -16, height },
                        { { 0, 0, height }, { 16, 16, 2 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72);
            break;
        case 1:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24037), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24903), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24040), { -16, -16, height },
                        { { -16, -16, height + 59 }, { 32, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24906), { -16, -16, height },
                        { { -16, -16, height + 59 }, { 32, 32, 0 } });
                    break;
            }
            WoodenBSupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::corner0, direction, height + 16, session.SupportColours);
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72);
            break;
        case 2:
            switch (direction)
            {
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24035), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24901), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24039), { -16, -16, height },
                        { { -16, -16, height + 59 }, { 32, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24905), { -16, -16, height },
                        { { -16, -16, height + 59 }, { 32, 32, 0 } });
                    break;
            }
            WoodenBSupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::corner2, direction, height + 16, session.SupportColours);
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72);
            break;
        case 3:
            switch (direction)
            {
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24038), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24904), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72);
            break;
    }
}

/** rct2: 0x008AC938 */
template<bool isClassic>
static void WoodenRCTrackDiag60DegDownTo25DegDown(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24030), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24896), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72);
            break;
        case 1:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24031), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24897), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24034), { -16, -16, height },
                        { { -16, -16, height + 59 }, { 32, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24900), { -16, -16, height },
                        { { -16, -16, height + 59 }, { 32, 32, 0 } });
                    break;
            }
            WoodenBSupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::corner0, direction, height + 16, session.SupportColours);
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72);
            break;
        case 2:
            switch (direction)
            {
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24029), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24895), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24033), { -16, -16, height },
                        { { -16, -16, height + 59 }, { 32, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24899), { -16, -16, height },
                        { { -16, -16, height + 59 }, { 32, 32, 0 } });
                    break;
            }
            WoodenBSupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::corner2, direction, height + 16, session.SupportColours);
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72);
            break;
        case 3:
            switch (direction)
            {
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24032), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24898), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72);
            break;
    }
}

/** rct2: 0x008AC908 */
template<bool isClassic>
static void WoodenRCTrackDiag25DegDownToFlat(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    switch (trackSequence)
    {
        case 0:
            if (trackElement.HasChain())
            {
                switch (direction)
                {
                    case 3:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24054),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24920), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        break;
                }
            }
            else
            {
                switch (direction)
                {
                    case 3:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24012),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24878), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        break;
                }
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 48);
            break;
        case 1:
            if (trackElement.HasChain())
            {
                switch (direction)
                {
                    case 0:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24055),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24921), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24058),
                            { -16, -16, height }, { { -16, -16, height + 35 }, { 32, 32, 0 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24924), { -16, -16, height },
                            { { -16, -16, height + 35 }, { 32, 32, 0 } });
                        WoodenASupportsPaintSetup(
                            session, supportType.wooden, WoodenSupportSubType::corner0, height, session.SupportColours);
                        break;
                    case 1:
                        WoodenASupportsPaintSetup(
                            session, supportType.wooden, WoodenSupportSubType::corner1, height, session.SupportColours);
                        break;
                    case 2:
                        WoodenASupportsPaintSetup(
                            session, supportType.wooden, WoodenSupportSubType::corner2, height, session.SupportColours);
                        break;
                    case 3:
                        WoodenASupportsPaintSetup(
                            session, supportType.wooden, WoodenSupportSubType::corner3, height, session.SupportColours);
                        break;
                }
            }
            else
            {
                switch (direction)
                {
                    case 0:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24013),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24879), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24016),
                            { -16, -16, height }, { { -16, -16, height + 35 }, { 32, 32, 0 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24882), { -16, -16, height },
                            { { -16, -16, height + 35 }, { 32, 32, 0 } });
                        WoodenASupportsPaintSetup(
                            session, supportType.wooden, WoodenSupportSubType::corner0, height, session.SupportColours);
                        break;
                    case 1:
                        WoodenASupportsPaintSetup(
                            session, supportType.wooden, WoodenSupportSubType::corner1, height, session.SupportColours);
                        break;
                    case 2:
                        WoodenASupportsPaintSetup(
                            session, supportType.wooden, WoodenSupportSubType::corner2, height, session.SupportColours);
                        break;
                    case 3:
                        WoodenASupportsPaintSetup(
                            session, supportType.wooden, WoodenSupportSubType::corner3, height, session.SupportColours);
                        break;
                }
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 48);
            break;
        case 2:
            if (trackElement.HasChain())
            {
                switch (direction)
                {
                    case 0:
                        WoodenASupportsPaintSetup(
                            session, supportType.wooden, WoodenSupportSubType::corner2, height, session.SupportColours);
                        break;
                    case 1:
                        WoodenASupportsPaintSetup(
                            session, supportType.wooden, WoodenSupportSubType::corner3, height, session.SupportColours);
                        break;
                    case 2:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24053),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24919), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24057),
                            { -16, -16, height }, { { -16, -16, height + 35 }, { 32, 32, 0 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24923), { -16, -16, height },
                            { { -16, -16, height + 35 }, { 32, 32, 0 } });
                        WoodenASupportsPaintSetup(
                            session, supportType.wooden, WoodenSupportSubType::corner0, height, session.SupportColours);
                        break;
                    case 3:
                        WoodenASupportsPaintSetup(
                            session, supportType.wooden, WoodenSupportSubType::corner1, height, session.SupportColours);
                        break;
                }
            }
            else
            {
                switch (direction)
                {
                    case 0:
                        WoodenASupportsPaintSetup(
                            session, supportType.wooden, WoodenSupportSubType::corner2, height, session.SupportColours);
                        break;
                    case 1:
                        WoodenASupportsPaintSetup(
                            session, supportType.wooden, WoodenSupportSubType::corner3, height, session.SupportColours);
                        break;
                    case 2:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24011),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24877), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24015),
                            { -16, -16, height }, { { -16, -16, height + 35 }, { 32, 32, 0 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24881), { -16, -16, height },
                            { { -16, -16, height + 35 }, { 32, 32, 0 } });
                        WoodenASupportsPaintSetup(
                            session, supportType.wooden, WoodenSupportSubType::corner0, height, session.SupportColours);
                        break;
                    case 3:
                        WoodenASupportsPaintSetup(
                            session, supportType.wooden, WoodenSupportSubType::corner1, height, session.SupportColours);
                        break;
                }
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 48);
            break;
        case 3:
            if (trackElement.HasChain())
            {
                switch (direction)
                {
                    case 1:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24056),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24922), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        break;
                }
            }
            else
            {
                switch (direction)
                {
                    case 1:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24014),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24880), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        break;
                }
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 48);
            break;
    }
}

template<bool isClassic>
static void WoodenRCTrackDiagLeftBankToFlat(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    trackSequence = kMapReversedDiagonalStraight[trackSequence];
    return WoodenRCTrackDiagFlatToBank<isClassic, kDiagFlatToRightBankImages>(
        session, ride, trackSequence, DirectionReverse(direction), height, trackElement, supportType);
}

template<bool isClassic>
static void WoodenRCTrackDiagRightBankToFlat(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    trackSequence = kMapReversedDiagonalStraight[trackSequence];
    return WoodenRCTrackDiagFlatToBank<isClassic, kDiagFlatToLeftBankImages>(
        session, ride, trackSequence, DirectionReverse(direction), height, trackElement, supportType);
}

static void WoodenRCTrackDiagLeftBankToDown25(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    trackSequence = kMapReversedDiagonalStraight[trackSequence];
    return WoodenRCTrackDiagUp25ToBank<false, kDiagUp25ToRightBankImages>(
        session, ride, trackSequence, DirectionReverse(direction), height, trackElement, supportType);
}

static void WoodenRCTrackDiagRightBankToDown25(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    trackSequence = kMapReversedDiagonalStraight[trackSequence];
    return WoodenRCTrackDiagUp25ToBank<false, kDiagUp25ToLeftBankImages>(
        session, ride, trackSequence, DirectionReverse(direction), height, trackElement, supportType);
}

template<bool isClassic>
static void WoodenRCTrackDiagDown25ToLeftBank(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    trackSequence = kMapReversedDiagonalStraight[trackSequence];
    return WoodenRCTrackDiagBankTo25DegUp<isClassic, kDiagRightBankTo25DegUpImages>(
        session, ride, trackSequence, DirectionReverse(direction), height, trackElement, supportType);
}

template<bool isClassic>
static void WoodenRCTrackDiagDown25ToRightBank(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    trackSequence = kMapReversedDiagonalStraight[trackSequence];
    return WoodenRCTrackDiagBankTo25DegUp<isClassic, kDiagLeftBankTo25DegUpImages>(
        session, ride, trackSequence, DirectionReverse(direction), height, trackElement, supportType);
}

/** rct2: 0x008AC9D8 */
template<bool isClassic>
static void WoodenRCTrackDiagLeftBank(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24074), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24940), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + kDefaultGeneralSupportHeight);
            break;
        case 1:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24071), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24937), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24075), { -16, -16, height },
                        { { -16, -16, height + 27 }, { 32, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24941), { -16, -16, height },
                        { { -16, -16, height + 27 }, { 32, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner0, height, session.SupportColours);
                    break;
                case 1:
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner1, height, session.SupportColours);
                    break;
                case 2:
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner2, height, session.SupportColours);
                    break;
                case 3:
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner3, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + kDefaultGeneralSupportHeight);
            break;
        case 2:
            switch (direction)
            {
                case 0:
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner2, height, session.SupportColours);
                    break;
                case 1:
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner3, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24073), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24939), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24076), { -16, -16, height },
                        { { -16, -16, height + 27 }, { 32, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24942), { -16, -16, height },
                        { { -16, -16, height + 27 }, { 32, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner0, height, session.SupportColours);
                    break;
                case 3:
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner1, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + kDefaultGeneralSupportHeight);
            break;
        case 3:
            switch (direction)
            {
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24072), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24938), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + kDefaultGeneralSupportHeight);
            break;
    }
}

/** rct2: 0x008AC9E8 */
template<bool isClassic>
static void WoodenRCTrackDiagRightBank(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24072), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24938), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + kDefaultGeneralSupportHeight);
            break;
        case 1:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24073), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24939), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24076), { -16, -16, height },
                        { { -16, -16, height + 27 }, { 32, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24942), { -16, -16, height },
                        { { -16, -16, height + 27 }, { 32, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner0, height, session.SupportColours);
                    break;
                case 1:
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner1, height, session.SupportColours);
                    break;
                case 2:
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner2, height, session.SupportColours);
                    break;
                case 3:
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner3, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + kDefaultGeneralSupportHeight);
            break;
        case 2:
            switch (direction)
            {
                case 0:
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner2, height, session.SupportColours);
                    break;
                case 1:
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner3, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24071), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24937), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24075), { -16, -16, height },
                        { { -16, -16, height + 27 }, { 32, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24941), { -16, -16, height },
                        { { -16, -16, height + 27 }, { 32, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner0, height, session.SupportColours);
                    break;
                case 3:
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner1, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + kDefaultGeneralSupportHeight);
            break;
        case 3:
            switch (direction)
            {
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24074), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24940), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + kDefaultGeneralSupportHeight);
            break;
    }
}

/** rct2: 0x008ACB58 */
template<bool isClassic>
static void WoodenRCTrackLeftQuarterTurn325DegDownToLeftBank(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    trackSequence = kMapLeftQuarterTurn3TilesToRightQuarterTurn3Tiles[trackSequence];
    WoodenRCTrackRightBankToRightQuarterTurn325DegUp<isClassic, kRightBankToRightQuarterTurn325DegUpImages>(
        session, ride, trackSequence, DirectionNext(direction), height, trackElement, supportType);
}

/** rct2: 0x008ACB68 */
template<bool isClassic>
static void WoodenRCTrackRightQuarterTurn325DegDownToRightBank(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    trackSequence = kMapLeftQuarterTurn3TilesToRightQuarterTurn3Tiles[trackSequence];
    WoodenRCTrackLeftBankToLeftQuarterTurn325DegUp<isClassic, kLeftBankToLeftQuarterTurn325DegUpImages>(
        session, ride, trackSequence, DirectionPrev(direction), height, trackElement, supportType);
}

/** rct2: 0x008ACDF8 */
template<bool isClassic>
static void WoodenRCTrackBlockBrakes(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    const auto brakeImg = trackElement.IsBrakeClosed() ? kBlockBrakesImageIds[direction][1]
                                                       : kBlockBrakesImageIds[direction][0];
    WoodenRCTrackPaint<isClassic>(
        session, direction, brakeImg, kBlockBrakesImageIds[direction][2], { 0, 2, height },
        { { 0, 3, height }, { 32, 25, 2 } });
    WoodenASupportsPaintSetupRotated(
        session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours);
    PaintUtilPushTunnelRotated(session, direction, height, kTunnelGroup, TunnelSubType::Flat);
    PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + kDefaultGeneralSupportHeight);
}

/** rct2: 0x008ACCB8 */
template<bool isClassic>
static void WoodenRCTrackLeftBankedQuarterTurn325DegUp(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23932), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24798), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner3, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23934), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24800), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23945), { 0, 6, height },
                        { { 0, 6, height + 67 }, { 32, 20, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24811), { 0, 6, height },
                        { { 0, 6, height + 67 }, { 32, 20, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner0, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23936), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24802), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner1, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23930), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24796), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23943), { 0, 6, height },
                        { { 0, 6, height + 67 }, { 32, 20, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24809), { 0, 6, height },
                        { { 0, 6, height + 67 }, { 32, 20, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner2, height, session.SupportColours);
                    break;
            }
            if (direction == 0 || direction == 3)
            {
                PaintUtilPushTunnelRotated(session, direction, height - 8, kTunnelGroup, TunnelSubType::SlopeStart);
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72);
            break;
        case 1:
            PaintUtilSetGeneralSupportHeight(session, height + 56);
            break;
        case 2:
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(PaintSegment::left, PaintSegment::centre, PaintSegment::topLeft, PaintSegment::bottomLeft),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 56);
            break;
        case 3:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23931), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24797), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner3, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23933), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24799), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23944), { 6, 0, height },
                        { { 6, 0, height + 67 }, { 20, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24810), { 6, 0, height },
                        { { 6, 0, height + 67 }, { 20, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner0, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23935), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24801), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23946), { 6, 0, height },
                        { { 6, 0, height + 67 }, { 20, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24812), { 6, 0, height },
                        { { 6, 0, height + 67 }, { 20, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner1, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23929), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24795), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23942), { 6, 0, height },
                        { { 6, 0, height + 67 }, { 20, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24808), { 6, 0, height },
                        { { 6, 0, height + 67 }, { 20, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner2, height, session.SupportColours);
                    break;
            }
            switch (direction)
            {
                case 2:
                    PaintUtilPushTunnelRight(session, height + 8, kTunnelGroup, TunnelSubType::SlopeEnd);
                    break;
                case 3:
                    PaintUtilPushTunnelLeft(session, height + 8, kTunnelGroup, TunnelSubType::SlopeEnd);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72);
            break;
    }
}

/** rct2: 0x008ACCC8 */
template<bool isClassic>
static void WoodenRCTrackRightBankedQuarterTurn325DegUp(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23921), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24787), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23937), { 0, 6, height },
                        { { 0, 6, height + 67 }, { 32, 20, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24803), { 0, 6, height },
                        { { 0, 6, height + 67 }, { 32, 20, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner2, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23923), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24789), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner3, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23925), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24791), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23940), { 0, 6, height },
                        { { 0, 6, height + 67 }, { 32, 20, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24806), { 0, 6, height },
                        { { 0, 6, height + 67 }, { 32, 20, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner0, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23927), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24793), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner1, height, session.SupportColours);
                    break;
            }
            if (direction == 0 || direction == 3)
            {
                PaintUtilPushTunnelRotated(session, direction, height - 8, kTunnelGroup, TunnelSubType::SlopeStart);
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72);
            break;
        case 1:
            PaintUtilSetGeneralSupportHeight(session, height + 56);
            break;
        case 2:
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::bottom, PaintSegment::centre, PaintSegment::bottomLeft, PaintSegment::bottomRight),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 56);
            break;
        case 3:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23922), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24788), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23938), { 6, 0, height },
                        { { 6, 0, height + 67 }, { 20, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24804), { 6, 0, height },
                        { { 6, 0, height + 67 }, { 20, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner2, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23924), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24790), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23939), { 6, 0, height },
                        { { 6, 0, height + 67 }, { 20, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24805), { 6, 0, height },
                        { { 6, 0, height + 67 }, { 20, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner3, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23926), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24792), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23941), { 6, 0, height },
                        { { 6, 0, height + 67 }, { 20, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24807), { 6, 0, height },
                        { { 6, 0, height + 67 }, { 20, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner0, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23928), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24794), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner1, height, session.SupportColours);
                    break;
            }
            switch (direction)
            {
                case 0:
                    PaintUtilPushTunnelRight(session, height + 8, kTunnelGroup, TunnelSubType::SlopeEnd);
                    break;
                case 1:
                    PaintUtilPushTunnelLeft(session, height + 8, kTunnelGroup, TunnelSubType::SlopeEnd);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72);
            break;
    }
}

/** rct2: 0x008ACCD8 */
template<bool isClassic>
static void WoodenRCTrackLeftBankedQuarterTurn325DegDown(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    trackSequence = kMapLeftQuarterTurn3TilesToRightQuarterTurn3Tiles[trackSequence];
    WoodenRCTrackRightBankedQuarterTurn325DegUp<isClassic>(
        session, ride, trackSequence, (direction + 1) & 3, height, trackElement, supportType);
}

/** rct2: 0x008ACCE8 */
template<bool isClassic>
static void WoodenRCTrackRightBankedQuarterTurn325DegDown(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    trackSequence = kMapLeftQuarterTurn3TilesToRightQuarterTurn3Tiles[trackSequence];
    WoodenRCTrackLeftBankedQuarterTurn325DegUp<isClassic>(
        session, ride, trackSequence, (direction - 1) & 3, height, trackElement, supportType);
}

/** rct2: 0x008ACC38 */
template<bool isClassic>
static void WoodenRCTrackLeftBankedQuarterTurn525DegUp(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24321), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25187), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    WoodenASupportsPaintSetupRotated(
                        session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                        WoodenSupportTransitionType::up25Deg);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24326), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25192), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24352), { 0, 0, height },
                        { { 0, 2, height + 67 }, { 32, 27, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25218), { 0, 0, height },
                        { { 0, 2, height + 67 }, { 32, 27, 0 } });
                    WoodenASupportsPaintSetupRotated(
                        session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                        WoodenSupportTransitionType::up25Deg);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24331), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25197), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    WoodenASupportsPaintSetupRotated(
                        session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                        WoodenSupportTransitionType::up25Deg);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24336), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25202), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    WoodenASupportsPaintSetupRotated(
                        session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                        WoodenSupportTransitionType::up25Deg);
                    break;
            }
            if (direction == 0 || direction == 3)
            {
                PaintUtilPushTunnelRotated(session, direction, height - 8, kTunnelGroup, TunnelSubType::SlopeStart);
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72);
            break;
        case 1:
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(PaintSegment::right, PaintSegment::topRight, PaintSegment::bottomRight), direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72);
            break;
        case 2:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24322), { 0, 0, height },
                        { { 0, 0, height }, { 32, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25188), { 0, 0, height },
                        { { 0, 0, height }, { 32, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner3, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24327), { 0, 0, height },
                        { { 0, 0, height }, { 32, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25193), { 0, 0, height },
                        { { 0, 0, height }, { 32, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24353), { 0, 0, height },
                        { { 0, 0, height + 67 }, { 32, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25219), { 0, 0, height },
                        { { 0, 0, height + 67 }, { 32, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner0, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24332), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25198), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner1, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24337), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25203), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24359), { 0, 0, height },
                        { { 0, 16, height + 67 }, { 32, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25225), { 0, 0, height },
                        { { 0, 16, height + 67 }, { 32, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner2, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::top, PaintSegment::left, PaintSegment::centre, PaintSegment::topLeft,
                        PaintSegment::topRight, PaintSegment::bottomLeft),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72);
            break;
        case 3:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24323), { 0, 0, height },
                        { { 0, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25189), { 0, 0, height },
                        { { 0, 16, height }, { 16, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner1, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24328), { 0, 0, height },
                        { { 16, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25194), { 0, 0, height },
                        { { 16, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24354), { 0, 0, height },
                        { { 16, 16, height + 59 }, { 16, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25220), { 0, 0, height },
                        { { 16, 16, height + 59 }, { 16, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner2, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24333), { 0, 0, height },
                        { { 16, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25199), { 0, 0, height },
                        { { 16, 0, height }, { 16, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner3, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24338), { 0, 0, height },
                        { { 0, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25204), { 0, 0, height },
                        { { 0, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24360), { 0, 0, height },
                        { { 0, 0, height + 59 }, { 16, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25226), { 0, 0, height },
                        { { 0, 0, height + 59 }, { 16, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner0, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::top, PaintSegment::right, PaintSegment::bottom, PaintSegment::centre,
                        PaintSegment::topLeft, PaintSegment::topRight, PaintSegment::bottomLeft, PaintSegment::bottomRight),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 64);
            break;
        case 4:
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(PaintSegment::right, PaintSegment::topRight, PaintSegment::bottomRight), direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72);
            break;
        case 5:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24324), { 0, 0, height },
                        { { 16, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25190), { 0, 0, height },
                        { { 16, 0, height }, { 16, 32, 2 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner3, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24329), { 0, 0, height },
                        { { 0, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25195), { 0, 0, height },
                        { { 0, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24355), { 0, 0, height },
                        { { 0, 0, height + 67 }, { 16, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25221), { 0, 0, height },
                        { { 0, 0, height + 67 }, { 16, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner0, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24334), { 0, 0, height },
                        { { 0, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25200), { 0, 0, height },
                        { { 0, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24357), { 0, 0, height },
                        { { 0, 0, height + 67 }, { 16, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25223), { 0, 0, height },
                        { { 0, 0, height + 67 }, { 16, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner1, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24339), { 0, 0, height },
                        { { 16, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25205), { 0, 0, height },
                        { { 16, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24361), { 0, 0, height },
                        { { 16, 0, height + 67 }, { 16, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25227), { 0, 0, height },
                        { { 16, 0, height + 67 }, { 16, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner2, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::left, PaintSegment::bottom, PaintSegment::centre, PaintSegment::topLeft,
                        PaintSegment::bottomLeft, PaintSegment::bottomRight),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72);
            break;
        case 6:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24325), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25191), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24330), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25196), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24356), { 0, 0, height },
                        { { 2, 0, height + 67 }, { 27, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25222), { 0, 0, height },
                        { { 2, 0, height + 67 }, { 27, 32, 0 } });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24335), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25201), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24358), { 0, 0, height },
                        { { 2, 0, height + 67 }, { 27, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25224), { 0, 0, height },
                        { { 2, 0, height + 67 }, { 27, 32, 0 } });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24340), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25206), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24362), { 0, 0, height },
                        { { 2, 0, height + 67 }, { 27, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25228), { 0, 0, height },
                        { { 2, 0, height + 67 }, { 27, 32, 0 } });
                    break;
            }
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, DirectionPrev(direction), height,
                session.SupportColours, WoodenSupportTransitionType::up25Deg);
            switch (direction)
            {
                case 2:
                    PaintUtilPushTunnelRight(session, height + 8, kTunnelGroup, TunnelSubType::SlopeEnd);
                    break;
                case 3:
                    PaintUtilPushTunnelLeft(session, height + 8, kTunnelGroup, TunnelSubType::SlopeEnd);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72);
            break;
    }
}

/** rct2: 0x008ACC48 */
template<bool isClassic>
static void WoodenRCTrackRightBankedQuarterTurn525DegUp(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24301), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25167), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    WoodenASupportsPaintSetupRotated(
                        session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                        WoodenSupportTransitionType::up25Deg);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24306), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25172), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    WoodenASupportsPaintSetupRotated(
                        session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                        WoodenSupportTransitionType::up25Deg);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24311), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25177), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24347), { 0, 0, height },
                        { { 0, 2, height + 67 }, { 32, 27, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25213), { 0, 0, height },
                        { { 0, 2, height + 67 }, { 32, 27, 0 } });
                    WoodenASupportsPaintSetupRotated(
                        session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                        WoodenSupportTransitionType::up25Deg);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24316), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25182), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    WoodenASupportsPaintSetupRotated(
                        session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                        WoodenSupportTransitionType::up25Deg);
                    break;
            }
            if (direction == 0 || direction == 3)
            {
                PaintUtilPushTunnelRotated(session, direction, height - 8, kTunnelGroup, TunnelSubType::SlopeStart);
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72);
            break;
        case 1:
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(PaintSegment::top, PaintSegment::topLeft, PaintSegment::topRight), direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72);
            break;
        case 2:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24302), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25168), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24341), { 0, 0, height },
                        { { 0, 16, height + 67 }, { 32, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25207), { 0, 0, height },
                        { { 0, 16, height + 67 }, { 32, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner2, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24307), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25173), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner3, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24312), { 0, 0, height },
                        { { 0, 0, height }, { 32, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25178), { 0, 0, height },
                        { { 0, 0, height }, { 32, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24348), { 0, 0, height },
                        { { 0, 0, height + 67 }, { 32, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25214), { 0, 0, height },
                        { { 0, 0, height + 67 }, { 32, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner0, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24317), { 0, 0, height },
                        { { 0, 0, height }, { 32, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25183), { 0, 0, height },
                        { { 0, 0, height }, { 32, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner1, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::right, PaintSegment::bottom, PaintSegment::centre, PaintSegment::topRight,
                        PaintSegment::bottomLeft, PaintSegment::bottomRight),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72);
            break;
        case 3:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24303), { 0, 0, height },
                        { { 0, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25169), { 0, 0, height },
                        { { 0, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24342), { 0, 0, height },
                        { { 0, 0, height + 59 }, { 16, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25208), { 0, 0, height },
                        { { 0, 0, height + 59 }, { 16, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner0, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24308), { 0, 0, height },
                        { { 16, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25174), { 0, 0, height },
                        { { 16, 0, height }, { 16, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner1, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24313), { 0, 0, height },
                        { { 16, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25179), { 0, 0, height },
                        { { 16, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24349), { 0, 0, height },
                        { { 16, 16, height + 59 }, { 16, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25215), { 0, 0, height },
                        { { 16, 16, height + 59 }, { 16, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner2, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24318), { 0, 0, height },
                        { { 0, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25184), { 0, 0, height },
                        { { 0, 16, height }, { 16, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner3, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::top, PaintSegment::left, PaintSegment::right, PaintSegment::centre, PaintSegment::topLeft,
                        PaintSegment::topRight, PaintSegment::bottomLeft, PaintSegment::bottomRight),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 64);
            break;
        case 4:
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(PaintSegment::top, PaintSegment::topLeft, PaintSegment::topRight), direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72);
            break;
        case 5:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24304), { 0, 0, height },
                        { { 16, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25170), { 0, 0, height },
                        { { 16, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24343), { 0, 0, height },
                        { { 16, 0, height + 67 }, { 16, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25209), { 0, 0, height },
                        { { 16, 0, height + 67 }, { 16, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner2, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24309), { 0, 0, height },
                        { { 0, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25175), { 0, 0, height },
                        { { 0, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24345), { 0, 0, height },
                        { { 0, 0, height + 67 }, { 16, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25211), { 0, 0, height },
                        { { 0, 0, height + 67 }, { 16, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner3, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24314), { 0, 0, height },
                        { { 0, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25180), { 0, 0, height },
                        { { 0, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24350), { 0, 0, height },
                        { { 0, 0, height + 67 }, { 16, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25216), { 0, 0, height },
                        { { 0, 0, height + 67 }, { 16, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner0, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24319), { 0, 0, height },
                        { { 16, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25185), { 0, 0, height },
                        { { 16, 0, height }, { 16, 32, 2 } });
                    WoodenASupportsPaintSetup(
                        session, supportType.wooden, WoodenSupportSubType::corner1, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::left, PaintSegment::bottom, PaintSegment::centre, PaintSegment::topLeft,
                        PaintSegment::bottomLeft, PaintSegment::bottomRight),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72);
            break;
        case 6:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24305), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25171), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24344), { 0, 0, height },
                        { { 2, 0, height + 67 }, { 27, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25210), { 0, 0, height },
                        { { 2, 0, height + 67 }, { 27, 32, 0 } });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24310), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25176), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24346), { 0, 0, height },
                        { { 2, 0, height + 67 }, { 27, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25212), { 0, 0, height },
                        { { 2, 0, height + 67 }, { 27, 32, 0 } });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24315), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25181), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24351), { 0, 0, height },
                        { { 2, 0, height + 67 }, { 27, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25217), { 0, 0, height },
                        { { 2, 0, height + 67 }, { 27, 32, 0 } });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24320), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25186), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    break;
            }
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, DirectionNext(direction), height,
                session.SupportColours, WoodenSupportTransitionType::up25Deg);
            switch (direction)
            {
                case 0:
                    PaintUtilPushTunnelRight(session, height + 8, kTunnelGroup, TunnelSubType::SlopeEnd);
                    break;
                case 1:
                    PaintUtilPushTunnelLeft(session, height + 8, kTunnelGroup, TunnelSubType::SlopeEnd);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72);
            break;
    }
}

/** rct2: 0x008ACC58 */
template<bool isClassic>
static void WoodenRCTrackLeftBankedQuarterTurn525DegDown(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    trackSequence = kMapLeftQuarterTurn5TilesToRightQuarterTurn5Tiles[trackSequence];
    WoodenRCTrackRightBankedQuarterTurn525DegUp<isClassic>(
        session, ride, trackSequence, (direction + 1) & 3, height, trackElement, supportType);
}

/** rct2: 0x008ACC68 */
template<bool isClassic>
static void WoodenRCTrackRightBankedQuarterTurn525DegDown(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    trackSequence = kMapLeftQuarterTurn5TilesToRightQuarterTurn5Tiles[trackSequence];
    WoodenRCTrackLeftBankedQuarterTurn525DegUp<isClassic>(
        session, ride, trackSequence, (direction - 1) & 3, height, trackElement, supportType);
}

/** rct2: 0x008ACCF8 */
template<bool isClassic>
static void WoodenRCTrack25DegUpToLeftBanked25DegUp(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    switch (direction)
    {
        case 0:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24261), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25127), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_TRACKS_WOODEN_RC_24261_FRONT),
                { 0, 0, height }, { { 0, 26, height + 5 }, { 32, 1, 9 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(SPR_TRACKS_WOODEN_RC_25127_FRONT),
                { 0, 0, height }, { { 0, 26, height + 5 }, { 32, 1, 9 } });
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::up25Deg);
            break;
        case 1:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24262), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25128), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_TRACKS_WOODEN_RC_24262_FRONT),
                { 0, 0, height }, { { 0, 26, height + 5 }, { 32, 1, 9 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(SPR_TRACKS_WOODEN_RC_25128_FRONT),
                { 0, 0, height }, { { 0, 26, height + 5 }, { 32, 1, 9 } });
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::up25Deg);
            break;
        case 2:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24263), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25129), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::up25Deg);
            break;
        case 3:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24264), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25130), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::up25Deg);
            break;
    }
    if (direction == 0 || direction == 3)
    {
        PaintUtilPushTunnelRotated(session, direction, height - 8, kTunnelGroup, TunnelSubType::SlopeStart);
    }
    else
    {
        PaintUtilPushTunnelRotated(session, direction, height + 8, kTunnelGroup, TunnelSubType::SlopeEnd);
    }
    PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + 56);
}

/** rct2: 0x008ACD08 */
template<bool isClassic>
static void WoodenRCTrack25DegUpToRightBanked25DegUp(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    switch (direction)
    {
        case 0:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24265), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25131), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::up25Deg);
            break;
        case 1:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24266), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25132), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::up25Deg);
            break;
        case 2:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24267), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25133), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_TRACKS_WOODEN_RC_24267_FRONT),
                { 0, 0, height }, { { 0, 26, height + 5 }, { 32, 1, 9 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(SPR_TRACKS_WOODEN_RC_25133_FRONT),
                { 0, 0, height }, { { 0, 26, height + 5 }, { 32, 1, 9 } });
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::up25Deg);
            break;
        case 3:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24268), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25134), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_TRACKS_WOODEN_RC_24268_FRONT),
                { 0, 0, height }, { { 0, 26, height + 5 }, { 32, 1, 9 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(SPR_TRACKS_WOODEN_RC_25134_FRONT),
                { 0, 0, height }, { { 0, 26, height + 5 }, { 32, 1, 9 } });
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::up25Deg);
            break;
    }
    if (direction == 0 || direction == 3)
    {
        PaintUtilPushTunnelRotated(session, direction, height - 8, kTunnelGroup, TunnelSubType::SlopeStart);
    }
    else
    {
        PaintUtilPushTunnelRotated(session, direction, height + 8, kTunnelGroup, TunnelSubType::SlopeEnd);
    }
    PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + 56);
}

/** rct2: 0x008ACD18 */
template<bool isClassic>
static void WoodenRCTrackLeftBanked25DegUpTo25DegUp(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    switch (direction)
    {
        case 0:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24269), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25135), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::up25Deg);
            break;
        case 1:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24270), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25136), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::up25Deg);
            break;
        case 2:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24271), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25137), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::up25Deg);
            break;
        case 3:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24272), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25138), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::up25Deg);
            break;
    }
    if (direction == 0 || direction == 3)
    {
        PaintUtilPushTunnelRotated(session, direction, height - 8, kTunnelGroup, TunnelSubType::SlopeStart);
    }
    else
    {
        PaintUtilPushTunnelRotated(session, direction, height + 8, kTunnelGroup, TunnelSubType::SlopeEnd);
    }
    PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + 56);
}

/** rct2: 0x008ACD28 */
template<bool isClassic>
static void WoodenRCTrackRightBanked25DegUpTo25DegUp(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    switch (direction)
    {
        case 0:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24273), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25139), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::up25Deg);
            break;
        case 1:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24274), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25140), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::up25Deg);
            break;
        case 2:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24275), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25141), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::up25Deg);
            break;
        case 3:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24276), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25142), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::up25Deg);
            break;
    }
    if (direction == 0 || direction == 3)
    {
        PaintUtilPushTunnelRotated(session, direction, height - 8, kTunnelGroup, TunnelSubType::SlopeStart);
    }
    else
    {
        PaintUtilPushTunnelRotated(session, direction, height + 8, kTunnelGroup, TunnelSubType::SlopeEnd);
    }
    PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + 56);
}

/** rct2: 0x008ACD38 */
template<bool isClassic>
static void WoodenRCTrack25DegDownToLeftBanked25DegDown(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    WoodenRCTrackRightBanked25DegUpTo25DegUp<isClassic>(
        session, ride, trackSequence, (direction + 2) & 3, height, trackElement, supportType);
}

/** rct2: 0x008ACD48 */
template<bool isClassic>
static void WoodenRCTrack25DegDownToRightBanked25DegDown(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    WoodenRCTrackLeftBanked25DegUpTo25DegUp<isClassic>(
        session, ride, trackSequence, (direction + 2) & 3, height, trackElement, supportType);
}

/** rct2: 0x008ACD58 */
template<bool isClassic>
static void WoodenRCTrackLeftBanked25DegDownTo25DegDown(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    WoodenRCTrack25DegUpToRightBanked25DegUp<isClassic>(
        session, ride, trackSequence, (direction + 2) & 3, height, trackElement, supportType);
}

/** rct2: 0x008ACD68 */
template<bool isClassic>
static void WoodenRCTrackRightBanked25DegDownTo25DegDown(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    WoodenRCTrack25DegUpToLeftBanked25DegUp<isClassic>(
        session, ride, trackSequence, (direction + 2) & 3, height, trackElement, supportType);
}

/** rct2: 0x008ACD78 */
template<bool isClassic>
static void WoodenRCTrackLeftBankedFlatToLeftBanked25DegUp(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    switch (direction)
    {
        case 0:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24277), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25143), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_TRACKS_WOODEN_RC_24277_FRONT),
                { 0, 0, height }, { { 0, 26, height + 5 }, { 32, 1, 9 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(SPR_TRACKS_WOODEN_RC_25143_FRONT),
                { 0, 0, height }, { { 0, 26, height + 5 }, { 32, 1, 9 } });
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::flatToUp25Deg);
            break;
        case 1:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24278), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25144), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24293), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25159), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::flatToUp25Deg);
            break;
        case 2:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24279), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25145), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24294), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25160), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::flatToUp25Deg);
            break;
        case 3:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24280), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25146), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::flatToUp25Deg);
            break;
    }
    if (direction == 0 || direction == 3)
    {
        PaintUtilPushTunnelRotated(session, direction, height, kTunnelGroup, TunnelSubType::Flat);
    }
    else
    {
        PaintUtilPushTunnelRotated(session, direction, height, kTunnelGroup, TunnelSubType::SlopeEnd);
    }
    PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + 48);
}

/** rct2: 0x008ACD88 */
template<bool isClassic>
static void WoodenRCTrackRightBankedFlatToRightBanked25DegUp(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    switch (direction)
    {
        case 0:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24281), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25147), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::flatToUp25Deg);
            break;
        case 1:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24282), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25148), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24295), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25161), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::flatToUp25Deg);
            break;
        case 2:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24283), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25149), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24296), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25162), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::flatToUp25Deg);
            break;
        case 3:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24284), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25150), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_TRACKS_WOODEN_RC_24284_FRONT),
                { 0, 0, height }, { { 0, 26, height + 5 }, { 32, 1, 9 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(SPR_TRACKS_WOODEN_RC_25150_FRONT),
                { 0, 0, height }, { { 0, 26, height + 5 }, { 32, 1, 9 } });
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::flatToUp25Deg);
            break;
    }
    if (direction == 0 || direction == 3)
    {
        PaintUtilPushTunnelRotated(session, direction, height, kTunnelGroup, TunnelSubType::Flat);
    }
    else
    {
        PaintUtilPushTunnelRotated(session, direction, height, kTunnelGroup, TunnelSubType::SlopeEnd);
    }
    PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + 48);
}

/** rct2: 0x008ACD98 */
template<bool isClassic>
static void WoodenRCTrackLeftBanked25DegUpToLeftBankedFlat(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    switch (direction)
    {
        case 0:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24285), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25151), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_TRACKS_WOODEN_RC_24285_FRONT),
                { 0, 0, height }, { { 0, 26, height + 5 }, { 32, 1, 9 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(SPR_TRACKS_WOODEN_RC_25151_FRONT),
                { 0, 0, height }, { { 0, 26, height + 5 }, { 32, 1, 9 } });
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::up25DegToFlat);
            break;
        case 1:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24286), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25152), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24297), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25163), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::up25DegToFlat);
            break;
        case 2:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24287), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25153), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24298), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25164), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::up25DegToFlat);
            break;
        case 3:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24288), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25154), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::up25DegToFlat);
            break;
    }
    if (direction == 0 || direction == 3)
    {
        PaintUtilPushTunnelRotated(session, direction, height - 8, kTunnelGroup, TunnelSubType::Flat);
    }
    else
    {
        PaintUtilPushTunnelRotated(session, direction, height + 8, kTunnelGroup, TunnelSubType::FlatTo25Deg);
    }
    PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + 40);
}

/** rct2: 0x008ACDA8 */
template<bool isClassic>
static void WoodenRCTrackRightBanked25DegUpToRightBankedFlat(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    switch (direction)
    {
        case 0:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24289), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25155), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::up25DegToFlat);
            break;
        case 1:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24290), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25156), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24299), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25165), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::up25DegToFlat);
            break;
        case 2:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24291), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25157), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24300), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25166), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::up25DegToFlat);
            break;
        case 3:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24292), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25158), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_TRACKS_WOODEN_RC_24292_FRONT),
                { 0, 0, height }, { { 0, 26, height + 5 }, { 32, 1, 9 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(SPR_TRACKS_WOODEN_RC_25158_FRONT),
                { 0, 0, height }, { { 0, 26, height + 5 }, { 32, 1, 9 } });
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::up25DegToFlat);
            break;
    }
    if (direction == 0 || direction == 3)
    {
        PaintUtilPushTunnelRotated(session, direction, height - 8, kTunnelGroup, TunnelSubType::Flat);
    }
    else
    {
        PaintUtilPushTunnelRotated(session, direction, height + 8, kTunnelGroup, TunnelSubType::FlatTo25Deg);
    }
    PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + 40);
}

/** rct2: 0x008ACDB8 */
template<bool isClassic>
static void WoodenRCTrackLeftBankedFlatToLeftBanked25DegDown(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    WoodenRCTrackRightBanked25DegUpToRightBankedFlat<isClassic>(
        session, ride, trackSequence, (direction + 2) & 3, height, trackElement, supportType);
}

/** rct2: 0x008ACDC8 */
template<bool isClassic>
static void WoodenRCTrackRightBankedFlatToRightBanked25DegDown(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    WoodenRCTrackLeftBanked25DegUpToLeftBankedFlat<isClassic>(
        session, ride, trackSequence, (direction + 2) & 3, height, trackElement, supportType);
}

/** rct2: 0x008ACDD8 */
template<bool isClassic>
static void WoodenRCTrackLeftBanked25DegDownToLeftBankedFlat(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    WoodenRCTrackRightBankedFlatToRightBanked25DegUp<isClassic>(
        session, ride, trackSequence, (direction + 2) & 3, height, trackElement, supportType);
}

/** rct2: 0x008ACDE8 */
template<bool isClassic>
static void WoodenRCTrackRightBanked25DegDownToRightBankedFlat(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    WoodenRCTrackLeftBankedFlatToLeftBanked25DegUp<isClassic>(
        session, ride, trackSequence, (direction + 2) & 3, height, trackElement, supportType);
}

/** rct2: 0x008ACBB8 */
template<bool isClassic>
static void WoodenRCTrackFlatToLeftBanked25DegUp(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    switch (direction)
    {
        case 0:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24225), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25091), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_TRACKS_WOODEN_RC_24225_FRONT),
                { 0, 0, height }, { { 0, 26, height + 5 }, { 32, 1, 9 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(SPR_TRACKS_WOODEN_RC_25091_FRONT),
                { 0, 0, height }, { { 0, 26, height + 5 }, { 32, 1, 9 } });
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::flatToUp25Deg);
            break;
        case 1:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24226), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25092), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24241), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25107), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::flatToUp25Deg);
            break;
        case 2:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24227), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25093), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24242), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25108), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::flatToUp25Deg);
            break;
        case 3:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24228), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25094), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::flatToUp25Deg);
            break;
    }
    if (direction == 0 || direction == 3)
    {
        PaintUtilPushTunnelRotated(session, direction, height, kTunnelGroup, TunnelSubType::Flat);
    }
    else
    {
        PaintUtilPushTunnelRotated(session, direction, height, kTunnelGroup, TunnelSubType::SlopeEnd);
    }
    PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + 48);
}

/** rct2: 0x008ACBC8 */
template<bool isClassic>
static void WoodenRCTrackFlatToRightBanked25DegUp(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    switch (direction)
    {
        case 0:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24229), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25095), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::flatToUp25Deg);
            break;
        case 1:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24230), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25096), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24243), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25109), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::flatToUp25Deg);
            break;
        case 2:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24231), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25097), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24244), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25110), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::flatToUp25Deg);
            break;
        case 3:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24232), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25098), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_TRACKS_WOODEN_RC_24232_FRONT),
                { 0, 0, height }, { { 0, 26, height + 5 }, { 32, 1, 9 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(SPR_TRACKS_WOODEN_RC_25098_FRONT),
                { 0, 0, height }, { { 0, 26, height + 5 }, { 32, 1, 9 } });
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::flatToUp25Deg);
            break;
    }
    if (direction == 0 || direction == 3)
    {
        PaintUtilPushTunnelRotated(session, direction, height, kTunnelGroup, TunnelSubType::Flat);
    }
    else
    {
        PaintUtilPushTunnelRotated(session, direction, height, kTunnelGroup, TunnelSubType::SlopeEnd);
    }
    PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + 48);
}

/** rct2: 0x008ACBD8 */
template<bool isClassic>
static void WoodenRCTrackLeftBanked25DegUpToFlat(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    switch (direction)
    {
        case 0:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24233), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25099), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::up25DegToFlat);
            break;
        case 1:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24234), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25100), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24245), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25111), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::up25DegToFlat);
            break;
        case 2:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24235), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25101), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24246), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25112), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::up25DegToFlat);
            break;
        case 3:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24236), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25102), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::up25DegToFlat);
            break;
    }
    if (direction == 0 || direction == 3)
    {
        PaintUtilPushTunnelRotated(session, direction, height - 8, kTunnelGroup, TunnelSubType::Flat);
    }
    else
    {
        PaintUtilPushTunnelRotated(session, direction, height + 8, kTunnelGroup, TunnelSubType::FlatTo25Deg);
    }
    PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + 40);
}

/** rct2: 0x008ACBE8 */
template<bool isClassic>
static void WoodenRCTrackRightBanked25DegUpToFlat(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    switch (direction)
    {
        case 0:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24237), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25103), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::up25DegToFlat);
            break;
        case 1:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24238), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25104), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24247), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25113), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::up25DegToFlat);
            break;
        case 2:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24239), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25105), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24248), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25114), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::up25DegToFlat);
            break;
        case 3:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24240), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25106), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            WoodenASupportsPaintSetupRotated(
                session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::up25DegToFlat);
            break;
    }
    if (direction == 0 || direction == 3)
    {
        PaintUtilPushTunnelRotated(session, direction, height - 8, kTunnelGroup, TunnelSubType::Flat);
    }
    else
    {
        PaintUtilPushTunnelRotated(session, direction, height + 8, kTunnelGroup, TunnelSubType::FlatTo25Deg);
    }
    PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + 40);
}

/** rct2: 0x008ACBF8 */
template<bool isClassic>
static void WoodenRCTrackFlatToLeftBanked25DegDown(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    WoodenRCTrackRightBanked25DegUpToFlat<isClassic>(
        session, ride, trackSequence, (direction + 2) & 3, height, trackElement, supportType);
}

/** rct2: 0x008ACC08 */
template<bool isClassic>
static void WoodenRCTrackFlatToRightBanked25DegDown(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    WoodenRCTrackLeftBanked25DegUpToFlat<isClassic>(
        session, ride, trackSequence, (direction + 2) & 3, height, trackElement, supportType);
}

/** rct2: 0x008ACC18 */
template<bool isClassic>
static void WoodenRCTrackLeftBanked25DegDownToFlat(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    WoodenRCTrackFlatToRightBanked25DegUp<isClassic>(
        session, ride, trackSequence, (direction + 2) & 3, height, trackElement, supportType);
}

/** rct2: 0x008ACC28 */
template<bool isClassic>
static void WoodenRCTrackRightBanked25DegDownToFlat(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    WoodenRCTrackFlatToLeftBanked25DegUp<isClassic>(
        session, ride, trackSequence, (direction + 2) & 3, height, trackElement, supportType);
}

template<bool isClassic>
static void WoodenRCTrackBooster(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    static constexpr uint32_t imageIds[4] = {
        SPR_TRACKS_WOODEN_RC_BOOSTER_SW_NE,
        SPR_TRACKS_WOODEN_RC_BOOSTER_NW_SE,
        SPR_TRACKS_WOODEN_RC_BOOSTER_SW_NE,
        SPR_TRACKS_WOODEN_RC_BOOSTER_NW_SE,
    };
    static constexpr uint32_t railsImageIds[4] = {
        SPR_WOODEN_RC_FLAT_CHAIN_RAILS_SW_NE,
        SPR_WOODEN_RC_FLAT_CHAIN_RAILS_NW_SE,
        SPR_WOODEN_RC_FLAT_CHAIN_RAILS_NE_SW,
        SPR_WOODEN_RC_FLAT_CHAIN_RAILS_SE_NW,
    };

    WoodenRCTrackPaint<isClassic>(
        session, direction, imageIds[direction], railsImageIds[direction], { 0, 2, height },
        { { 0, 3, height }, { 32, 25, 2 } });
    WoodenASupportsPaintSetupRotated(
        session, supportType.wooden, WoodenSupportSubType::neSw, direction, height, session.SupportColours);
    PaintUtilPushTunnelRotated(session, direction, height, kTunnelGroup, TunnelSubType::Flat);
    PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + kDefaultGeneralSupportHeight);
}

template<bool isClassic>
static void WoodenRCTrackLeftMediumHalfLoopUp(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex(SPR_TRACKS_WOODEN_RC_MEDIUM_HALF_LOOP + 0),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex(SPR_TRACKS_WOODEN_RC_MEDIUM_HALF_LOOP + 5),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex(SPR_TRACKS_WOODEN_RC_MEDIUM_HALF_LOOP + 40),
                        { 0, 0, height }, { { 0, 0, height + 44 }, { 32, 20, 2 } });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex(SPR_TRACKS_WOODEN_RC_MEDIUM_HALF_LOOP + 10),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex(SPR_TRACKS_WOODEN_RC_MEDIUM_HALF_LOOP + 45),
                        { 0, 0, height }, { { 0, 6, height + 44 }, { 32, 20, 3 } });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex(SPR_TRACKS_WOODEN_RC_MEDIUM_HALF_LOOP + 15),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    break;
            }

            MetalASupportsPaintSetup(
                session, MetalSupportType::boxed, MetalSupportPlace::centre, 7, height, session.SupportColours);

            if (direction == 0 || direction == 3)
            {
                PaintUtilPushTunnelRotated(session, direction, height - 8, kTunnelGroup, TunnelSubType::SlopeStart);
            }
            PaintUtilSetSegmentSupportHeight(
                session, PaintUtilRotateSegments(BlockedSegments::kStraightFlat, direction), 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 48);
            break;
        case 1:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex(SPR_TRACKS_WOODEN_RC_MEDIUM_HALF_LOOP + 1),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex(SPR_TRACKS_WOODEN_RC_MEDIUM_HALF_LOOP + 6),
                        { 0, 0, height }, { { 0, 0, height }, { 32, 20, 3 } });
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex(SPR_TRACKS_WOODEN_RC_MEDIUM_HALF_LOOP + 41),
                        { 0, 0, height }, { { 0, 0, height + 70 }, { 32, 20, 2 } });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex(SPR_TRACKS_WOODEN_RC_MEDIUM_HALF_LOOP + 11),
                        { 0, 0, height }, { { 0, 32, height }, { 40, 0, 64 } });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex(SPR_TRACKS_WOODEN_RC_MEDIUM_HALF_LOOP + 16),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    break;
            }

            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::left, PaintSegment::topLeft, PaintSegment::centre, PaintSegment::topRight,
                        PaintSegment::bottomLeft, PaintSegment::top),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72);
            break;
        case 2:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex(SPR_TRACKS_WOODEN_RC_MEDIUM_HALF_LOOP + 2),
                        { 0, 0, height }, { { 0, 0, height + 2 }, { 32, 32, 0 } });
                    MetalBSupportsPaintSetup(
                        session, MetalSupportType::boxed, MetalSupportPlace::topLeftSide, 14, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex(SPR_TRACKS_WOODEN_RC_MEDIUM_HALF_LOOP + 7),
                        { 0, 0, height }, { { 29, 0, height }, { 1, 32, 96 } });
                    MetalBSupportsPaintSetup(
                        session, MetalSupportType::boxed, MetalSupportPlace::topRightSide, 16, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex(SPR_TRACKS_WOODEN_RC_MEDIUM_HALF_LOOP + 12),
                        { 0, 0, height }, { { 31, 0, height }, { 1, 32, 96 } });
                    MetalBSupportsPaintSetup(
                        session, MetalSupportType::boxed, MetalSupportPlace::bottomRightSide, 18, height,
                        session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex(SPR_TRACKS_WOODEN_RC_MEDIUM_HALF_LOOP + 17),
                        { 0, 0, height }, { { 0, 0, height }, { 32, 32, 0 } });
                    MetalBSupportsPaintSetup(
                        session, MetalSupportType::boxed, MetalSupportPlace::bottomLeftSide, 14, height,
                        session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(PaintSegment::left, PaintSegment::topLeft, PaintSegment::centre, PaintSegment::bottomLeft),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 144);
            break;
        case 3:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex(SPR_TRACKS_WOODEN_RC_MEDIUM_HALF_LOOP + 3),
                        { 0, 0, height }, { { 2, 0, height }, { 1, 32, 160 } });
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex(SPR_TRACKS_WOODEN_RC_MEDIUM_HALF_LOOP + 44),
                        { 0, 0, height }, { { 0, 0, height + 144 }, { 32, 20, 0 } });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex(SPR_TRACKS_WOODEN_RC_MEDIUM_HALF_LOOP + 8),
                        { 0, 0, height }, { { 0, 0, height + 140 }, { 32, 32, 3 } });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex(SPR_TRACKS_WOODEN_RC_MEDIUM_HALF_LOOP + 13),
                        { 0, 0, height }, { { 29, 0, height }, { 1, 32, 160 } });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex(SPR_TRACKS_WOODEN_RC_MEDIUM_HALF_LOOP + 18),
                        { 0, 0, height }, { { 0, 0, height }, { 1, 32, 160 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::bottom, PaintSegment::bottomRight, PaintSegment::centre, PaintSegment::bottomLeft),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 144);
            break;
        case 4:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex(SPR_TRACKS_WOODEN_RC_MEDIUM_HALF_LOOP + 4),
                        { 0, 0, height }, { { 0, 2, height + 48 }, { 32, 32, 1 } });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex(SPR_TRACKS_WOODEN_RC_MEDIUM_HALF_LOOP + 9),
                        { 0, 0, height }, { { 0, 2, height + 48 }, { 32, 32, 1 } });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex(SPR_TRACKS_WOODEN_RC_MEDIUM_HALF_LOOP + 14),
                        { 0, 0, height }, { { 0, 0, height + 48 }, { 32, 32, 1 } });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex(SPR_TRACKS_WOODEN_RC_MEDIUM_HALF_LOOP + 19),
                        { 0, 0, height }, { { 0, 0, height + 48 }, { 32, 32, 1 } });
                    break;
            }

            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::topRight, PaintSegment::centre, PaintSegment::bottomLeft, PaintSegment::bottom,
                        PaintSegment::bottomRight, PaintSegment::right),
                    direction),
                0xFFFF, 0);

            if (direction == 0 || direction == 3)
            {
                PaintUtilPushTunnelRotated(session, direction, height + 16, kTunnelGroup, TunnelSubType::Flat);
            }
            PaintUtilSetGeneralSupportHeight(session, height + 48);
            break;
    }
}

template<bool isClassic>
static void WoodenRCTrackRightMediumHalfLoopUp(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex(SPR_TRACKS_WOODEN_RC_MEDIUM_HALF_LOOP + 20),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex(SPR_TRACKS_WOODEN_RC_MEDIUM_HALF_LOOP + 25),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex(SPR_TRACKS_WOODEN_RC_MEDIUM_HALF_LOOP + 46),
                        { 0, 0, height }, { { 0, 6, height + 44 }, { 32, 20, 3 } });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex(SPR_TRACKS_WOODEN_RC_MEDIUM_HALF_LOOP + 30),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex(SPR_TRACKS_WOODEN_RC_MEDIUM_HALF_LOOP + 42),
                        { 0, 0, height }, { { 0, 6, height + 44 }, { 32, 20, 3 } });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex(SPR_TRACKS_WOODEN_RC_MEDIUM_HALF_LOOP + 35),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    break;
            }

            MetalASupportsPaintSetup(
                session, MetalSupportType::boxed, MetalSupportPlace::centre, 7, height, session.SupportColours);

            if (direction == 0 || direction == 3)
            {
                PaintUtilPushTunnelRotated(session, direction, height - 8, kTunnelGroup, TunnelSubType::SlopeStart);
            }
            PaintUtilSetSegmentSupportHeight(
                session, PaintUtilRotateSegments(BlockedSegments::kStraightFlat, direction), 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 48);
            break;
        case 1:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex(SPR_TRACKS_WOODEN_RC_MEDIUM_HALF_LOOP + 21),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex(SPR_TRACKS_WOODEN_RC_MEDIUM_HALF_LOOP + 26),
                        { 0, 0, height }, { { 0, 32, height }, { 40, 0, 64 } });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex(SPR_TRACKS_WOODEN_RC_MEDIUM_HALF_LOOP + 31),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex(SPR_TRACKS_WOODEN_RC_MEDIUM_HALF_LOOP + 43),
                        { 0, 0, height }, { { 0, 6, height + 70 }, { 32, 20, 2 } });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex(SPR_TRACKS_WOODEN_RC_MEDIUM_HALF_LOOP + 36),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    break;
            }

            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::topRight, PaintSegment::centre, PaintSegment::bottomLeft, PaintSegment::bottom,
                        PaintSegment::bottomRight, PaintSegment::right),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72);
            break;
        case 2:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex(SPR_TRACKS_WOODEN_RC_MEDIUM_HALF_LOOP + 22),
                        { 0, 0, height }, { { 0, 0, height }, { 32, 32, 0 } });
                    MetalBSupportsPaintSetup(
                        session, MetalSupportType::boxed, MetalSupportPlace::bottomRightSide, 14, height,
                        session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex(SPR_TRACKS_WOODEN_RC_MEDIUM_HALF_LOOP + 27),
                        { 0, 0, height }, { { 30, 16, height }, { 0, 32, 96 } });
                    MetalBSupportsPaintSetup(
                        session, MetalSupportType::boxed, MetalSupportPlace::bottomLeftSide, 18, height,
                        session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex(SPR_TRACKS_WOODEN_RC_MEDIUM_HALF_LOOP + 32),
                        { 0, 0, height }, { { 29, 0, height }, { 0, 32, 96 } });
                    MetalBSupportsPaintSetup(
                        session, MetalSupportType::boxed, MetalSupportPlace::topLeftSide, 16, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex(SPR_TRACKS_WOODEN_RC_MEDIUM_HALF_LOOP + 37),
                        { 0, 0, height }, { { 0, 0, height + 2 }, { 32, 32, 0 } });
                    MetalBSupportsPaintSetup(
                        session, MetalSupportType::boxed, MetalSupportPlace::topRightSide, 14, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::bottom, PaintSegment::bottomRight, PaintSegment::centre, PaintSegment::bottomLeft),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 144);
            break;
        case 3:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex(SPR_TRACKS_WOODEN_RC_MEDIUM_HALF_LOOP + 23),
                        { 0, 0, height }, { { 0, 0, height }, { 1, 32, 160 } });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex(SPR_TRACKS_WOODEN_RC_MEDIUM_HALF_LOOP + 28),
                        { 0, 0, height }, { { 29, 16, height }, { 0, 16, 160 } });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex(SPR_TRACKS_WOODEN_RC_MEDIUM_HALF_LOOP + 33),
                        { 0, 0, height }, { { 0, 0, height + 140 }, { 32, 32, 3 } });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex(SPR_TRACKS_WOODEN_RC_MEDIUM_HALF_LOOP + 38),
                        { 0, 0, height }, { { 0, 0, height }, { 0, 32, 160 } });
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex(SPR_TRACKS_WOODEN_RC_MEDIUM_HALF_LOOP + 47),
                        { 0, 0, height }, { { 0, 0, height + 144 }, { 32, 20, 0 } });
                    break;
            }

            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(PaintSegment::left, PaintSegment::centre, PaintSegment::topLeft, PaintSegment::bottomLeft),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 144);
            break;
        case 4:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex(SPR_TRACKS_WOODEN_RC_MEDIUM_HALF_LOOP + 24),
                        { 0, 0, height }, { { 0, 0, height + 48 }, { 32, 32, 1 } });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex(SPR_TRACKS_WOODEN_RC_MEDIUM_HALF_LOOP + 29),
                        { 0, 0, height }, { { 0, 0, height + 48 }, { 32, 32, 1 } });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex(SPR_TRACKS_WOODEN_RC_MEDIUM_HALF_LOOP + 34),
                        { 0, 0, height }, { { 0, 0, height + 48 }, { 32, 32, 1 } });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex(SPR_TRACKS_WOODEN_RC_MEDIUM_HALF_LOOP + 39),
                        { 0, 0, height }, { { 0, 0, height + 48 }, { 32, 32, 1 } });
                    break;
            }

            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::left, PaintSegment::topLeft, PaintSegment::centre, PaintSegment::topRight,
                        PaintSegment::bottomLeft, PaintSegment::top),
                    direction),
                0xFFFF, 0);
            if (direction == 0 || direction == 3)
            {
                PaintUtilPushTunnelRotated(session, direction, height + 16, kTunnelGroup, TunnelSubType::Flat);
            }
            PaintUtilSetGeneralSupportHeight(session, height + 48);
            break;
    }
}

template<bool isClassic>
static void WoodenRCTrackLeftMediumHalfLoopDown(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    WoodenRCTrackRightMediumHalfLoopUp<isClassic>(
        session, ride, 4 - trackSequence, direction, height, trackElement, supportType);
}

template<bool isClassic>
static void WoodenRCTrackRightMediumHalfLoopDown(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    WoodenRCTrackLeftMediumHalfLoopUp<isClassic>(
        session, ride, 4 - trackSequence, direction, height, trackElement, supportType);
}

template<bool isClassic>
static void WoodenRCTrackLeftLargeHalfLoopUp(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex((SPR_TRACKS_WOODEN_RC_LARGE_HALF_LOOP + 0)),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex((SPR_TRACKS_WOODEN_RC_LARGE_HALF_LOOP + 7)),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex((SPR_TRACKS_WOODEN_RC_LARGE_HALF_LOOP + 14)),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex((SPR_TRACKS_WOODEN_RC_LARGE_HALF_LOOP + 21)),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    break;
            }
            MetalASupportsPaintSetup(
                session, MetalSupportType::boxed, MetalSupportPlace::centre, 5, height, session.SupportColours);
            if (direction == 0 || direction == 3)
            {
                PaintUtilPushTunnelRotated(session, direction, height - 8, kTunnelGroup, TunnelSubType::SlopeStart);
            }
            PaintUtilSetSegmentSupportHeight(
                session, PaintUtilRotateSegments(BlockedSegments::kStraightFlat, direction), 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 56);
            break;
        case 1:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex((SPR_TRACKS_WOODEN_RC_LARGE_HALF_LOOP + 1)),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    MetalASupportsPaintSetup(
                        session, MetalSupportType::boxed, MetalSupportPlace::centre, 12, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex((SPR_TRACKS_WOODEN_RC_LARGE_HALF_LOOP + 8)),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 9 } });
                    MetalASupportsPaintSetup(
                        session, MetalSupportType::boxed, MetalSupportPlace::centre, 6, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex((SPR_TRACKS_WOODEN_RC_LARGE_HALF_LOOP + 15)),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex((SPR_TRACKS_WOODEN_RC_LARGE_HALF_LOOP + 58)),
                        { 0, 0, height }, { { 0, 6, height + 64 }, { 32, 20, 3 } });
                    MetalASupportsPaintSetup(
                        session, MetalSupportType::boxed, MetalSupportPlace::centre, 0, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex((SPR_TRACKS_WOODEN_RC_LARGE_HALF_LOOP + 22)),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    MetalASupportsPaintSetup(
                        session, MetalSupportType::boxed, MetalSupportPlace::centre, 0, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session, PaintUtilRotateSegments(BlockedSegments::kStraightFlat, direction), 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72);
            break;
        case 2:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex((SPR_TRACKS_WOODEN_RC_LARGE_HALF_LOOP + 2)),
                        { 0, 0, height }, { { 0, 0, height }, { 32, 16, 3 } });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex((SPR_TRACKS_WOODEN_RC_LARGE_HALF_LOOP + 9)),
                        { 0, 0, height }, { { 0, 0, height }, { 32, 16, 0 } });
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex((SPR_TRACKS_WOODEN_RC_LARGE_HALF_LOOP + 57)),
                        { 0, 0, height }, { { 0, 0, height + 70 }, { 32, 16, 0 } });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex((SPR_TRACKS_WOODEN_RC_LARGE_HALF_LOOP + 16)),
                        { 0, 0, height }, { { 0, 16, height + 80 }, { 32, 16, 0 } });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex((SPR_TRACKS_WOODEN_RC_LARGE_HALF_LOOP + 23)),
                        { 0, 0, height }, { { 0, 16, height }, { 32, 16, 3 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::top, PaintSegment::left, PaintSegment::centre, PaintSegment::topLeft,
                        PaintSegment::topRight, PaintSegment::bottomLeft),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 88);
            break;
        case 3:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex((SPR_TRACKS_WOODEN_RC_LARGE_HALF_LOOP + 3)),
                        { 0, 0, height }, { { 0, 0, height }, { 32, 16, 3 } });
                    MetalASupportsPaintSetup(
                        session, MetalSupportType::boxed, MetalSupportPlace::topLeftSide, 22, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex((SPR_TRACKS_WOODEN_RC_LARGE_HALF_LOOP + 10)),
                        { 0, 0, height }, { { 0, 0, height + 200 }, { 32, 16, 0 } });
                    MetalASupportsPaintSetup(
                        session, MetalSupportType::boxed, MetalSupportPlace::topRightSide, 14, height + 8,
                        session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex((SPR_TRACKS_WOODEN_RC_LARGE_HALF_LOOP + 17)),
                        { 0, 0, height }, { { 0, 16, height + 200 }, { 32, 16, 0 } });
                    MetalASupportsPaintSetup(
                        session, MetalSupportType::boxed, MetalSupportPlace::bottomRightSide, 0, height + 21,
                        session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex((SPR_TRACKS_WOODEN_RC_LARGE_HALF_LOOP + 24)),
                        { 0, 0, height }, { { 0, 16, height }, { 32, 16, 3 } });
                    MetalASupportsPaintSetup(
                        session, MetalSupportType::boxed, MetalSupportPlace::bottomLeftSide, 22, height,
                        session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::top, PaintSegment::left, PaintSegment::centre, PaintSegment::topLeft,
                        PaintSegment::topRight, PaintSegment::bottomLeft),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 224);
            break;
        case 4:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex((SPR_TRACKS_WOODEN_RC_LARGE_HALF_LOOP + 4)),
                        { 0, 0, height }, { { 16, 16, height }, { 16, 16, 3 } });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex((SPR_TRACKS_WOODEN_RC_LARGE_HALF_LOOP + 11)),
                        { 0, 0, height }, { { 0, 16, height + 110 }, { 16, 16, 0 } });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex((SPR_TRACKS_WOODEN_RC_LARGE_HALF_LOOP + 18)),
                        { 0, 0, height }, { { 0, 0, height + 100 }, { 16, 16, 0 } });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex((SPR_TRACKS_WOODEN_RC_LARGE_HALF_LOOP + 25)),
                        { 0, 0, height }, { { 16, 0, height }, { 16, 16, 3 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::bottom, PaintSegment::centre, PaintSegment::bottomLeft, PaintSegment::bottomRight),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 128);
            break;
        case 5:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex((SPR_TRACKS_WOODEN_RC_LARGE_HALF_LOOP + 5)),
                        { 0, 0, height }, { { 0, 16, height }, { 32, 16, 3 } });
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex((SPR_TRACKS_WOODEN_RC_LARGE_HALF_LOOP + 56)),
                        { 0, 0, height }, { { 0, 16, height + 210 }, { 32, 16, 3 } });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex((SPR_TRACKS_WOODEN_RC_LARGE_HALF_LOOP + 12)),
                        { 0, 0, height }, { { 0, 16, height + 200 }, { 32, 16, 0 } });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex((SPR_TRACKS_WOODEN_RC_LARGE_HALF_LOOP + 19)),
                        { 0, 0, height }, { { 0, 0, height + 200 }, { 32, 16, 0 } });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex((SPR_TRACKS_WOODEN_RC_LARGE_HALF_LOOP + 26)),
                        { 0, 0, height }, { { 0, 0, height }, { 32, 16, 3 } });
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex((SPR_TRACKS_WOODEN_RC_LARGE_HALF_LOOP + 59)),
                        { 0, 0, height }, { { 0, 0, height + 210 }, { 32, 16, 3 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::right, PaintSegment::bottom, PaintSegment::centre, PaintSegment::topRight,
                        PaintSegment::bottomLeft, PaintSegment::bottomRight),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 224);
            break;
        case 6:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex((SPR_TRACKS_WOODEN_RC_LARGE_HALF_LOOP + 6)),
                        { 0, 0, height }, { { 0, 16, height + 32 }, { 32, 16, 0 } });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex((SPR_TRACKS_WOODEN_RC_LARGE_HALF_LOOP + 13)),
                        { 0, 0, height }, { { 0, 16, height + 32 }, { 32, 16, 0 } });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex((SPR_TRACKS_WOODEN_RC_LARGE_HALF_LOOP + 20)),
                        { 0, 0, height }, { { 0, 0, height + 32 }, { 32, 16, 0 } });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex((SPR_TRACKS_WOODEN_RC_LARGE_HALF_LOOP + 27)),
                        { 0, 0, height }, { { 0, 0, height + 32 }, { 32, 16, 0 } });
                    break;
            }
            if (direction == 0 || direction == 3)
            {
                PaintUtilPushTunnelRotated(session, direction, height, kTunnelGroup, TunnelSubType::Flat);
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::right, PaintSegment::bottom, PaintSegment::centre, PaintSegment::topRight,
                        PaintSegment::bottomLeft, PaintSegment::bottomRight),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 40);
            break;
    }
}

template<bool isClassic>
static void WoodenRCTrackRightLargeHalfLoopUp(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex((SPR_TRACKS_WOODEN_RC_LARGE_HALF_LOOP + 28)),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex((SPR_TRACKS_WOODEN_RC_LARGE_HALF_LOOP + 35)),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex((SPR_TRACKS_WOODEN_RC_LARGE_HALF_LOOP + 42)),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex((SPR_TRACKS_WOODEN_RC_LARGE_HALF_LOOP + 49)),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    break;
            }
            MetalASupportsPaintSetup(
                session, MetalSupportType::boxed, MetalSupportPlace::centre, 5, height, session.SupportColours);
            if (direction == 0 || direction == 3)
            {
                PaintUtilPushTunnelRotated(session, direction, height - 8, kTunnelGroup, TunnelSubType::SlopeStart);
            }
            PaintUtilSetSegmentSupportHeight(
                session, PaintUtilRotateSegments(BlockedSegments::kStraightFlat, direction), 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 56);
            break;
        case 1:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex((SPR_TRACKS_WOODEN_RC_LARGE_HALF_LOOP + 29)),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    MetalASupportsPaintSetup(
                        session, MetalSupportType::boxed, MetalSupportPlace::centre, 0, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex((SPR_TRACKS_WOODEN_RC_LARGE_HALF_LOOP + 36)),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex((SPR_TRACKS_WOODEN_RC_LARGE_HALF_LOOP + 61)),
                        { 0, 0, height }, { { 0, 6, height + 64 }, { 32, 20, 3 } });
                    MetalASupportsPaintSetup(
                        session, MetalSupportType::boxed, MetalSupportPlace::centre, 0, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex((SPR_TRACKS_WOODEN_RC_LARGE_HALF_LOOP + 43)),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 9 } });
                    MetalASupportsPaintSetup(
                        session, MetalSupportType::boxed, MetalSupportPlace::centre, 6, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex((SPR_TRACKS_WOODEN_RC_LARGE_HALF_LOOP + 50)),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 3 } });
                    MetalASupportsPaintSetup(
                        session, MetalSupportType::boxed, MetalSupportPlace::centre, 12, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session, PaintUtilRotateSegments(BlockedSegments::kStraightFlat, direction), 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72);
            break;
        case 2:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex((SPR_TRACKS_WOODEN_RC_LARGE_HALF_LOOP + 30)),
                        { 0, 0, height }, { { 0, 16, height }, { 32, 16, 3 } });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex((SPR_TRACKS_WOODEN_RC_LARGE_HALF_LOOP + 37)),
                        { 0, 0, height }, { { 0, 16, height + 80 }, { 32, 16, 0 } });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex((SPR_TRACKS_WOODEN_RC_LARGE_HALF_LOOP + 44)),
                        { 0, 0, height }, { { 0, 0, height + 0 }, { 32, 16, 0 } });
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex((SPR_TRACKS_WOODEN_RC_LARGE_HALF_LOOP + 62)),
                        { 0, 0, height }, { { 0, 0, height + 70 }, { 32, 16, 0 } });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex((SPR_TRACKS_WOODEN_RC_LARGE_HALF_LOOP + 51)),
                        { 0, 0, height }, { { 0, 0, height }, { 32, 16, 3 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::right, PaintSegment::bottom, PaintSegment::centre, PaintSegment::topRight,
                        PaintSegment::bottomLeft, PaintSegment::bottomRight),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 88);
            break;
        case 3:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex((SPR_TRACKS_WOODEN_RC_LARGE_HALF_LOOP + 31)),
                        { 0, 0, height }, { { 0, 16, height }, { 32, 16, 3 } });
                    MetalASupportsPaintSetup(
                        session, MetalSupportType::boxed, MetalSupportPlace::bottomRightSide, 22, height,
                        session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex((SPR_TRACKS_WOODEN_RC_LARGE_HALF_LOOP + 38)),
                        { 0, 0, height }, { { 0, 16, height + 200 }, { 32, 16, 0 } });
                    MetalASupportsPaintSetup(
                        session, MetalSupportType::boxed, MetalSupportPlace::bottomLeftSide, 0, height + 21,
                        session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex((SPR_TRACKS_WOODEN_RC_LARGE_HALF_LOOP + 45)),
                        { 0, 0, height }, { { 0, 0, height + 200 }, { 32, 16, 0 } });
                    MetalASupportsPaintSetup(
                        session, MetalSupportType::boxed, MetalSupportPlace::topLeftSide, 14, height + 8,
                        session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex((SPR_TRACKS_WOODEN_RC_LARGE_HALF_LOOP + 52)),
                        { 0, 0, height }, { { 0, 0, height }, { 32, 16, 3 } });
                    MetalASupportsPaintSetup(
                        session, MetalSupportType::boxed, MetalSupportPlace::topRightSide, 22, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::right, PaintSegment::bottom, PaintSegment::centre, PaintSegment::topRight,
                        PaintSegment::bottomLeft, PaintSegment::bottomRight),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 224);
            break;
        case 4:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex((SPR_TRACKS_WOODEN_RC_LARGE_HALF_LOOP + 32)),
                        { 0, 0, height }, { { 16, 0, height }, { 16, 16, 3 } });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex((SPR_TRACKS_WOODEN_RC_LARGE_HALF_LOOP + 39)),
                        { 0, 0, height }, { { 0, 0, height + 100 }, { 16, 16, 0 } });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex((SPR_TRACKS_WOODEN_RC_LARGE_HALF_LOOP + 46)),
                        { 0, 0, height }, { { 0, 16, height + 110 }, { 16, 16, 0 } });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex((SPR_TRACKS_WOODEN_RC_LARGE_HALF_LOOP + 53)),
                        { 0, 0, height }, { { 16, 16, height }, { 16, 16, 3 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(PaintSegment::left, PaintSegment::centre, PaintSegment::topLeft, PaintSegment::bottomLeft),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 128);
            break;
        case 5:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex((SPR_TRACKS_WOODEN_RC_LARGE_HALF_LOOP + 33)),
                        { 0, 0, height }, { { 0, 0, height }, { 32, 16, 3 } });
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex((SPR_TRACKS_WOODEN_RC_LARGE_HALF_LOOP + 60)),
                        { 0, 0, height }, { { 0, 0, height + 210 }, { 32, 16, 3 } });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex((SPR_TRACKS_WOODEN_RC_LARGE_HALF_LOOP + 40)),
                        { 0, 0, height }, { { 0, 0, height + 200 }, { 32, 16, 0 } });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex((SPR_TRACKS_WOODEN_RC_LARGE_HALF_LOOP + 47)),
                        { 0, 0, height }, { { 0, 16, height + 200 }, { 32, 16, 0 } });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex((SPR_TRACKS_WOODEN_RC_LARGE_HALF_LOOP + 54)),
                        { 0, 0, height }, { { 0, 16, height }, { 32, 16, 3 } });
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex((SPR_TRACKS_WOODEN_RC_LARGE_HALF_LOOP + 63)),
                        { 0, 0, height }, { { 0, 16, height + 210 }, { 32, 16, 3 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::top, PaintSegment::left, PaintSegment::centre, PaintSegment::topLeft,
                        PaintSegment::topRight, PaintSegment::bottomLeft),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 224);
            break;
        case 6:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex((SPR_TRACKS_WOODEN_RC_LARGE_HALF_LOOP + 34)),
                        { 0, 0, height }, { { 0, 0, height + 32 }, { 32, 16, 0 } });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex((SPR_TRACKS_WOODEN_RC_LARGE_HALF_LOOP + 41)),
                        { 0, 0, height }, { { 0, 0, height + 32 }, { 32, 16, 0 } });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex((SPR_TRACKS_WOODEN_RC_LARGE_HALF_LOOP + 48)),
                        { 0, 0, height }, { { 0, 16, height + 32 }, { 32, 16, 0 } });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, session.TrackColours.WithIndex((SPR_TRACKS_WOODEN_RC_LARGE_HALF_LOOP + 55)),
                        { 0, 0, height }, { { 0, 16, height + 32 }, { 32, 16, 0 } });
                    break;
            }
            if (direction == 0 || direction == 3)
            {
                PaintUtilPushTunnelRotated(session, direction, height, kTunnelGroup, TunnelSubType::Flat);
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::top, PaintSegment::left, PaintSegment::centre, PaintSegment::topLeft,
                        PaintSegment::topRight, PaintSegment::bottomLeft),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 40);
            break;
    }
}

template<bool isClassic>
static void WoodenRCTrackLeftLargeHalfLoopDown(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    WoodenRCTrackRightLargeHalfLoopUp<isClassic>(
        session, ride, 6 - trackSequence, direction, height, trackElement, supportType);
}

template<bool isClassic>
static void WoodenRCTrackRightLargeHalfLoopDown(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement, SupportType supportType)
{
    WoodenRCTrackLeftLargeHalfLoopUp<isClassic>(session, ride, 6 - trackSequence, direction, height, trackElement, supportType);
}

template<bool isClassic>
TrackPaintFunction GetTrackPaintFunctionWoodenAndClassicWoodenRC(OpenRCT2::TrackElemType trackType)
{
    switch (trackType)
    {
        case TrackElemType::Flat:
            return WoodenRCTrackFlat<isClassic>;
        case TrackElemType::EndStation:
        case TrackElemType::BeginStation:
        case TrackElemType::MiddleStation:
            return WoodenRCTrackStation<isClassic>;
        case TrackElemType::Up25:
            return WoodenRCTrack25DegUp<isClassic>;
        case TrackElemType::Up60:
            return WoodenRCTrack60DegUp<isClassic>;
        case TrackElemType::FlatToUp25:
            return WoodenRCTrackFlatTo25DegUp<isClassic>;
        case TrackElemType::Up25ToUp60:
            return WoodenRCTrack25DegUpTo60DegUp<isClassic>;
        case TrackElemType::Up60ToUp25:
            return WoodenRCTrack60DegUpTo25DegUp<isClassic>;
        case TrackElemType::Up25ToFlat:
            return WoodenRCTrack25DegUpToFlat<isClassic>;
        case TrackElemType::Down25:
            return WoodenRCTrack25DegDown<isClassic>;
        case TrackElemType::Down60:
            return WoodenRCTrack60DegDown<isClassic>;
        case TrackElemType::FlatToDown25:
            return WoodenRCTrackFlatTo25DegDown<isClassic>;
        case TrackElemType::Down25ToDown60:
            return WoodenRCTrack25DegDownTo60DegDown<isClassic>;
        case TrackElemType::Down60ToDown25:
            return WoodenRCTrack60DegDownTo25DegDown<isClassic>;
        case TrackElemType::Down25ToFlat:
            return WoodenRCTrack25DegDownToFlat<isClassic>;
        case TrackElemType::LeftQuarterTurn5Tiles:
            return WoodenRCTrackLeftQuarterTurn5<isClassic>;
        case TrackElemType::RightQuarterTurn5Tiles:
            return WoodenRCTrackRightQuarterTurn5<isClassic>;
        case TrackElemType::FlatToLeftBank:
            return WoodenRCTrackFlatToBank<isClassic, kFlatToLeftBankImages>;
        case TrackElemType::FlatToRightBank:
            return WoodenRCTrackFlatToBank<isClassic, kFlatToRightBankImages>;
        case TrackElemType::LeftBankToFlat:
            return WoodenRCTrackLeftBankToFlat<isClassic>;
        case TrackElemType::RightBankToFlat:
            return WoodenRCTrackRightBankToFlat<isClassic>;
        case TrackElemType::BankedLeftQuarterTurn5Tiles:
            return WoodenRCTrackBankedLeftQuarterTurn5<isClassic>;
        case TrackElemType::BankedRightQuarterTurn5Tiles:
            return WoodenRCTrackBankedRightQuarterTurn5<isClassic, kBankedQuarterTurn5Images>;
        case TrackElemType::LeftBankToUp25:
            return WoodenRCTrackBankTo25DegUp<isClassic, kLeftBankToUp25Images>;
        case TrackElemType::RightBankToUp25:
            return WoodenRCTrackBankTo25DegUp<isClassic, kRightBankToUp25Images>;
        case TrackElemType::Up25ToLeftBank:
            return WoodenRCTrack25DegUpToBank<isClassic, kUp25ToLeftBankImages>;
        case TrackElemType::Up25ToRightBank:
            return WoodenRCTrack25DegUpToBank<isClassic, kUp25ToRightBankImages>;
        case TrackElemType::LeftBankToDown25:
            return WoodenRCTrackLeftBankTo25DegDown<isClassic>;
        case TrackElemType::RightBankToDown25:
            return WoodenRCTrackRightBankTo25DegDown<isClassic>;
        case TrackElemType::Down25ToLeftBank:
            return WoodenRCTrack25DegDownToLeftBank<isClassic>;
        case TrackElemType::Down25ToRightBank:
            return WoodenRCTrack25DegDownToRightBank<isClassic>;
        case TrackElemType::LeftBank:
            return WoodenRCTrackFlatToBank<isClassic, kLeftBankImages>;
        case TrackElemType::RightBank:
            return WoodenRCTrackRightBank<isClassic>;
        case TrackElemType::LeftQuarterTurn5TilesUp25:
            return WoodenRCTrackLeftQuarterTurn525DegUp<isClassic>;
        case TrackElemType::RightQuarterTurn5TilesUp25:
            return WoodenRCTrackRightQuarterTurn525DegUp<isClassic>;
        case TrackElemType::LeftQuarterTurn5TilesDown25:
            return WoodenRCTrackLeftQuarterTurn525DegDown<isClassic>;
        case TrackElemType::RightQuarterTurn5TilesDown25:
            return WoodenRCTrackRightQuarterTurn525DegDown<isClassic>;
        case TrackElemType::SBendLeft:
            return WoodenRCTrackSBendLeft<isClassic>;
        case TrackElemType::SBendRight:
            return WoodenRCTrackSBendRight<isClassic>;
        case TrackElemType::LeftVerticalLoop:
            return WoodenRCTrackLeftVerticalLoop;
        case TrackElemType::RightVerticalLoop:
            return WoodenRCTrackRightVerticalLoop;
        case TrackElemType::LeftQuarterTurn3Tiles:
            return WoodenRCTrackLeftQuarterTurn3<isClassic>;
        case TrackElemType::RightQuarterTurn3Tiles:
            return WoodenRCTrackRightQuarterTurn3<isClassic>;
        case TrackElemType::LeftBankedQuarterTurn3Tiles:
            return WoodenRCTrackLeftQuarterTurn3Bank<isClassic, kBankedQuarterTurn3Images>;
        case TrackElemType::RightBankedQuarterTurn3Tiles:
            return WoodenRCTrackRightQuarterTurn3Bank<isClassic>;
        case TrackElemType::LeftQuarterTurn3TilesUp25:
            return WoodenRCTrackLeftQuarterTurn325DegUp<isClassic>;
        case TrackElemType::RightQuarterTurn3TilesUp25:
            return WoodenRCTrackRightQuarterTurn325DegUp<isClassic>;
        case TrackElemType::LeftQuarterTurn3TilesDown25:
            return WoodenRCTrackLeftQuarterTurn325DegDown<isClassic>;
        case TrackElemType::RightQuarterTurn3TilesDown25:
            return WoodenRCTrackRightQuarterTurn325DegDown<isClassic>;
        case TrackElemType::LeftHalfBankedHelixUpSmall:
            return WoodenRCTrackLeftHalfBankedHelixUpSmall<isClassic, kLeftHalfBankedHelixUpSmallImages>;
        case TrackElemType::RightHalfBankedHelixUpSmall:
            return WoodenRCTrackRightHalfBankedHelixUpSmall<isClassic, kRightHalfBankedHelixUpSmallImages>;
        case TrackElemType::LeftHalfBankedHelixDownSmall:
            return WoodenRCTrackLeftHalfBankedHelixDownSmall<isClassic>;
        case TrackElemType::RightHalfBankedHelixDownSmall:
            return WoodenRCTrackRightHalfBankedHelixDownSmall<isClassic>;
        case TrackElemType::LeftHalfBankedHelixUpLarge:
            return WoodenRCTrackLeftHalfBankedHelixUpLarge<isClassic, kLeftHalfBankedHelixUpLargeImages>;
        case TrackElemType::RightHalfBankedHelixUpLarge:
            return WoodenRCTrackRightHalfBankedHelixUpLarge<isClassic, kRightHalfBankedHelixUpLargeImages>;
        case TrackElemType::LeftHalfBankedHelixDownLarge:
            return WoodenRCTrackLeftHalfBankedHelixDownLarge<isClassic>;
        case TrackElemType::RightHalfBankedHelixDownLarge:
            return WoodenRCTrackRightHalfBankedHelixDownLarge<isClassic>;
        case TrackElemType::LeftQuarterTurn1TileUp60:
            return WoodenRCTrackLeftQuarterTurn160DegUp<isClassic>;
        case TrackElemType::RightQuarterTurn1TileUp60:
            return WoodenRCTrackRightQuarterTurn160DegUp<isClassic>;
        case TrackElemType::LeftQuarterTurn1TileDown60:
            return WoodenRCTrackLeftQuarterTurn160DegDown<isClassic>;
        case TrackElemType::RightQuarterTurn1TileDown60:
            return WoodenRCTrackRightQuarterTurn160DegDown<isClassic>;
        case TrackElemType::Brakes:
            return WoodenRCTrackBrakes<isClassic>;
        case TrackElemType::Up25LeftBanked:
            return WoodenRCTrack25DegUpLeftBanked<isClassic>;
        case TrackElemType::Up25RightBanked:
            return WoodenRCTrack25DegUpRightBanked<isClassic>;
        case TrackElemType::OnRidePhoto:
            return WoodenRCTrackOnRidePhoto<isClassic>;
        case TrackElemType::FlatToUp60LongBase:
            return WoodenRCTrackFlatTo60DegUpLongBase<isClassic>;
        case TrackElemType::Up60ToFlatLongBase:
            return WoodenRCTrack60DegUpToFlatLongBase<isClassic>;
        case TrackElemType::FlatToDown60LongBase:
            return WoodenRCTrackFlatTo60DegDownLongBase<isClassic>;
        case TrackElemType::Down60ToFlatLongBase:
            return WoodenRCTrack60DegDownToFlatLongBase<isClassic>;
        case TrackElemType::Down25LeftBanked:
            return WoodenRCTrack25DegDownLeftBanked<isClassic>;
        case TrackElemType::Down25RightBanked:
            return WoodenRCTrack25DegDownRightBanked<isClassic>;
        case TrackElemType::Watersplash:
            return WoodenRCTrackWaterSplash<isClassic>;
        case TrackElemType::LeftEighthToDiag:
            return WoodenRCTrackLeftEighthToDiag<isClassic>;
        case TrackElemType::RightEighthToDiag:
            return WoodenRCTrackRightEighthToDiag<isClassic>;
        case TrackElemType::LeftEighthToOrthogonal:
            return WoodenRCTrackLeftEighthToOrthogonal<isClassic>;
        case TrackElemType::RightEighthToOrthogonal:
            return WoodenRCTrackRightEighthToOrthogonal<isClassic>;
        case TrackElemType::LeftEighthBankToDiag:
            return WoodenRCTrackLeftEighthBankToDiag<isClassic, kLeftEighthBankToDiagImages>;
        case TrackElemType::RightEighthBankToDiag:
            return WoodenRCTrackRightEighthBankToDiag<isClassic, kRightEighthBankToDiagImages>;
        case TrackElemType::LeftEighthBankToOrthogonal:
            return WoodenRCTrackLeftEighthBankToOrthogonal<isClassic>;
        case TrackElemType::RightEighthBankToOrthogonal:
            return WoodenRCTrackRightEighthBankToOrthogonal<isClassic>;
        case TrackElemType::DiagFlat:
            return WoodenRCTrackDiagFlat<isClassic>;
        case TrackElemType::DiagUp25:
            return WoodenRCTrackDiag25DegUp<isClassic>;
        case TrackElemType::DiagUp60:
            return WoodenRCTrackDiag60DegUp<isClassic>;
        case TrackElemType::DiagFlatToUp25:
            return WoodenRCTrackDiagFlatTo25DegUp<isClassic>;
        case TrackElemType::DiagUp25ToUp60:
            return WoodenRCTrackDiag25DegUpTo60DegUp<isClassic>;
        case TrackElemType::DiagUp60ToUp25:
            return WoodenRCTrackDiag60DegUpTo25DegUp<isClassic>;
        case TrackElemType::DiagUp25ToFlat:
            return WoodenRCTrackDiag25DegUpToFlat<isClassic>;
        case TrackElemType::DiagDown25:
            return WoodenRCTrackDiag25DegDown<isClassic>;
        case TrackElemType::DiagDown60:
            return WoodenRCTrackDiag60DegDown<isClassic>;
        case TrackElemType::DiagFlatToDown25:
            return WoodenRCTrackDiagFlatTo25DegDown<isClassic>;
        case TrackElemType::DiagDown25ToDown60:
            return WoodenRCTrackDiag25DegDownTo60DegDown<isClassic>;
        case TrackElemType::DiagDown60ToDown25:
            return WoodenRCTrackDiag60DegDownTo25DegDown<isClassic>;
        case TrackElemType::DiagDown25ToFlat:
            return WoodenRCTrackDiag25DegDownToFlat<isClassic>;
        case TrackElemType::DiagFlatToLeftBank:
            return WoodenRCTrackDiagFlatToBank<isClassic, kDiagFlatToLeftBankImages>;
        case TrackElemType::DiagFlatToRightBank:
            return WoodenRCTrackDiagFlatToBank<isClassic, kDiagFlatToRightBankImages>;
        case TrackElemType::DiagLeftBankToFlat:
            return WoodenRCTrackDiagLeftBankToFlat<isClassic>;
        case TrackElemType::DiagRightBankToFlat:
            return WoodenRCTrackDiagRightBankToFlat<isClassic>;
        case TrackElemType::DiagLeftBankToUp25:
            return WoodenRCTrackDiagBankTo25DegUp<isClassic, kDiagLeftBankTo25DegUpImages>;
        case TrackElemType::DiagRightBankToUp25:
            return WoodenRCTrackDiagBankTo25DegUp<isClassic, kDiagRightBankTo25DegUpImages>;
        case TrackElemType::DiagUp25ToLeftBank:
            return WoodenRCTrackDiagUp25ToBank<isClassic, kDiagUp25ToLeftBankImages>;
        case TrackElemType::DiagUp25ToRightBank:
            return WoodenRCTrackDiagUp25ToBank<isClassic, kDiagUp25ToRightBankImages>;
        case TrackElemType::DiagLeftBankToDown25:
            return WoodenRCTrackDiagLeftBankToDown25;
        case TrackElemType::DiagRightBankToDown25:
            return WoodenRCTrackDiagRightBankToDown25;
        case TrackElemType::DiagDown25ToLeftBank:
            return WoodenRCTrackDiagDown25ToLeftBank<isClassic>;
        case TrackElemType::DiagDown25ToRightBank:
            return WoodenRCTrackDiagDown25ToRightBank<isClassic>;
        case TrackElemType::DiagLeftBank:
            return WoodenRCTrackDiagLeftBank<isClassic>;
        case TrackElemType::DiagRightBank:
            return WoodenRCTrackDiagRightBank<isClassic>;
        case TrackElemType::LeftBankToLeftQuarterTurn3TilesUp25:
            return WoodenRCTrackLeftBankToLeftQuarterTurn325DegUp<isClassic, kLeftBankToLeftQuarterTurn325DegUpImages>;
        case TrackElemType::RightBankToRightQuarterTurn3TilesUp25:
            return WoodenRCTrackRightBankToRightQuarterTurn325DegUp<isClassic, kRightBankToRightQuarterTurn325DegUpImages>;
        case TrackElemType::LeftQuarterTurn3TilesDown25ToLeftBank:
            return WoodenRCTrackLeftQuarterTurn325DegDownToLeftBank<isClassic>;
        case TrackElemType::RightQuarterTurn3TilesDown25ToRightBank:
            return WoodenRCTrackRightQuarterTurn325DegDownToRightBank<isClassic>;
        case TrackElemType::BlockBrakes:
            return WoodenRCTrackBlockBrakes<isClassic>;
        case TrackElemType::LeftBankedQuarterTurn3TileUp25:
            return WoodenRCTrackLeftBankedQuarterTurn325DegUp<isClassic>;
        case TrackElemType::RightBankedQuarterTurn3TileUp25:
            return WoodenRCTrackRightBankedQuarterTurn325DegUp<isClassic>;
        case TrackElemType::LeftBankedQuarterTurn3TileDown25:
            return WoodenRCTrackLeftBankedQuarterTurn325DegDown<isClassic>;
        case TrackElemType::RightBankedQuarterTurn3TileDown25:
            return WoodenRCTrackRightBankedQuarterTurn325DegDown<isClassic>;
        case TrackElemType::LeftBankedQuarterTurn5TileUp25:
            return WoodenRCTrackLeftBankedQuarterTurn525DegUp<isClassic>;
        case TrackElemType::RightBankedQuarterTurn5TileUp25:
            return WoodenRCTrackRightBankedQuarterTurn525DegUp<isClassic>;
        case TrackElemType::LeftBankedQuarterTurn5TileDown25:
            return WoodenRCTrackLeftBankedQuarterTurn525DegDown<isClassic>;
        case TrackElemType::RightBankedQuarterTurn5TileDown25:
            return WoodenRCTrackRightBankedQuarterTurn525DegDown<isClassic>;
        case TrackElemType::Up25ToLeftBankedUp25:
            return WoodenRCTrack25DegUpToLeftBanked25DegUp<isClassic>;
        case TrackElemType::Up25ToRightBankedUp25:
            return WoodenRCTrack25DegUpToRightBanked25DegUp<isClassic>;
        case TrackElemType::LeftBankedUp25ToUp25:
            return WoodenRCTrackLeftBanked25DegUpTo25DegUp<isClassic>;
        case TrackElemType::RightBankedUp25ToUp25:
            return WoodenRCTrackRightBanked25DegUpTo25DegUp<isClassic>;
        case TrackElemType::Down25ToLeftBankedDown25:
            return WoodenRCTrack25DegDownToLeftBanked25DegDown<isClassic>;
        case TrackElemType::Down25ToRightBankedDown25:
            return WoodenRCTrack25DegDownToRightBanked25DegDown<isClassic>;
        case TrackElemType::LeftBankedDown25ToDown25:
            return WoodenRCTrackLeftBanked25DegDownTo25DegDown<isClassic>;
        case TrackElemType::RightBankedDown25ToDown25:
            return WoodenRCTrackRightBanked25DegDownTo25DegDown<isClassic>;
        case TrackElemType::LeftBankedFlatToLeftBankedUp25:
            return WoodenRCTrackLeftBankedFlatToLeftBanked25DegUp<isClassic>;
        case TrackElemType::RightBankedFlatToRightBankedUp25:
            return WoodenRCTrackRightBankedFlatToRightBanked25DegUp<isClassic>;
        case TrackElemType::LeftBankedUp25ToLeftBankedFlat:
            return WoodenRCTrackLeftBanked25DegUpToLeftBankedFlat<isClassic>;
        case TrackElemType::RightBankedUp25ToRightBankedFlat:
            return WoodenRCTrackRightBanked25DegUpToRightBankedFlat<isClassic>;
        case TrackElemType::LeftBankedFlatToLeftBankedDown25:
            return WoodenRCTrackLeftBankedFlatToLeftBanked25DegDown<isClassic>;
        case TrackElemType::RightBankedFlatToRightBankedDown25:
            return WoodenRCTrackRightBankedFlatToRightBanked25DegDown<isClassic>;
        case TrackElemType::LeftBankedDown25ToLeftBankedFlat:
            return WoodenRCTrackLeftBanked25DegDownToLeftBankedFlat<isClassic>;
        case TrackElemType::RightBankedDown25ToRightBankedFlat:
            return WoodenRCTrackRightBanked25DegDownToRightBankedFlat<isClassic>;
        case TrackElemType::FlatToLeftBankedUp25:
            return WoodenRCTrackFlatToLeftBanked25DegUp<isClassic>;
        case TrackElemType::FlatToRightBankedUp25:
            return WoodenRCTrackFlatToRightBanked25DegUp<isClassic>;
        case TrackElemType::LeftBankedUp25ToFlat:
            return WoodenRCTrackLeftBanked25DegUpToFlat<isClassic>;
        case TrackElemType::RightBankedUp25ToFlat:
            return WoodenRCTrackRightBanked25DegUpToFlat<isClassic>;
        case TrackElemType::FlatToLeftBankedDown25:
            return WoodenRCTrackFlatToLeftBanked25DegDown<isClassic>;
        case TrackElemType::FlatToRightBankedDown25:
            return WoodenRCTrackFlatToRightBanked25DegDown<isClassic>;
        case TrackElemType::LeftBankedDown25ToFlat:
            return WoodenRCTrackLeftBanked25DegDownToFlat<isClassic>;
        case TrackElemType::RightBankedDown25ToFlat:
            return WoodenRCTrackRightBanked25DegDownToFlat<isClassic>;
        case TrackElemType::Booster:
            return WoodenRCTrackBooster<isClassic>;
        case TrackElemType::DiagBrakes:
            return WoodenRCTrackDiagBrakes<isClassic>;
        case TrackElemType::DiagBlockBrakes:
            return WoodenRCTrackDiagBlockBrakes<isClassic>;
        case TrackElemType::LeftMediumHalfLoopUp:
            return WoodenRCTrackLeftMediumHalfLoopUp<isClassic>;
        case TrackElemType::RightMediumHalfLoopUp:
            return WoodenRCTrackRightMediumHalfLoopUp<isClassic>;
        case TrackElemType::LeftMediumHalfLoopDown:
            return WoodenRCTrackLeftMediumHalfLoopDown<isClassic>;
        case TrackElemType::RightMediumHalfLoopDown:
            return WoodenRCTrackRightMediumHalfLoopDown<isClassic>;
        case TrackElemType::LeftLargeHalfLoopUp:
            return WoodenRCTrackLeftLargeHalfLoopUp<isClassic>;
        case TrackElemType::RightLargeHalfLoopUp:
            return WoodenRCTrackRightLargeHalfLoopUp<isClassic>;
        case TrackElemType::LeftLargeHalfLoopDown:
            return WoodenRCTrackLeftLargeHalfLoopDown<isClassic>;
        case TrackElemType::RightLargeHalfLoopDown:
            return WoodenRCTrackRightLargeHalfLoopDown<isClassic>;
        default:
            return TrackPaintFunctionDummy;
    }
}

TrackPaintFunction GetTrackPaintFunctionWoodenRC(OpenRCT2::TrackElemType trackType)
{
    return GetTrackPaintFunctionWoodenAndClassicWoodenRC<false>(trackType);
}

TrackPaintFunction GetTrackPaintFunctionClassicWoodenRCFallback(OpenRCT2::TrackElemType trackType)
{
    return GetTrackPaintFunctionWoodenAndClassicWoodenRC<true>(trackType);
}
