/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package tdb2.cmdline;

import jena.cmd.ArgDecl;
import jena.cmd.CmdArgModule;
import jena.cmd.CmdGeneral;
import jena.cmd.ModBase;
import org.apache.jena.dboe.base.file.Location;

public class ModLocation extends ModBase
{
    public ModLocation() {}
    
    protected final ArgDecl locationDecl = new ArgDecl(ArgDecl.HasValue, "location", "loc") ;
    protected Location location = null ;
    
    @Override
    public void registerWith(CmdGeneral cmdLine)
    {
        cmdLine.getUsage().startCategory("Location") ;
        cmdLine.add(locationDecl, "--loc=DIR", "Location (a directory)") ;
    }
    
    public void checkCommandLine(CmdArgModule cmdLine)
    {}

    @Override
    public void processArgs(CmdArgModule cmdLine)
    {
        if ( cmdLine.contains(locationDecl) )
        {
            String dir = cmdLine.getValue(locationDecl) ;
            location = Location.create(dir) ;
        }
    }
    
    public Location getLocation() { return location ; }
}
