/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.instrument;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.sourceforge.cobertura.util.RegexUtil;
import org.apache.oro.text.regex.Pattern;

public class ClassPattern {
    private Set<Pattern> includeClassesRegexes = new HashSet<Pattern>();
    private Set<Pattern> excludeClassesRegexes = new HashSet<Pattern>();
    private static final String WEBINF_CLASSES = "WEB-INF/classes/";

    boolean isSpecified() {
        return this.includeClassesRegexes.size() > 0;
    }

    boolean matches(String filename) {
        boolean matches = true;
        if (this.isSpecified()) {
            matches = false;
            if (filename.endsWith(".class")) {
                filename = filename.substring(0, filename.length() - 6);
            }
            filename = filename.replace('\\', '/');
            filename = this.removeAnyWebInfClassesString(filename);
            if (RegexUtil.matches(this.includeClassesRegexes, filename = filename.replace('/', '.'))) {
                matches = true;
            }
            if (matches && RegexUtil.matches(this.excludeClassesRegexes, filename)) {
                matches = false;
            }
        }
        return matches;
    }

    private String removeAnyWebInfClassesString(String filename) {
        if (filename.startsWith(WEBINF_CLASSES)) {
            filename = filename.substring(WEBINF_CLASSES.length());
        }
        return filename;
    }

    void addIncludeClassesRegex(String regex) {
        RegexUtil.addRegex(this.includeClassesRegexes, regex);
    }

    void addIncludeClassesRegex(Collection<Pattern> regexes) {
        this.includeClassesRegexes.addAll(regexes);
    }

    void addExcludeClassesRegex(String regex) {
        RegexUtil.addRegex(this.excludeClassesRegexes, regex);
    }

    void addExcludeClassesRegex(Collection<Pattern> regexes) {
        this.excludeClassesRegexes.addAll(regexes);
    }
}

