/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.util;

import java.io.File;
import java.io.InputStream;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Source {
    private InputStream is;
    private Object streamOrigin;
    private static Logger LOGGER = LoggerFactory.getLogger(Source.class);

    public Source(InputStream is, Object streamOrigin) {
        this.is = is;
        this.streamOrigin = streamOrigin;
    }

    public InputStream getInputStream() {
        return this.is;
    }

    public void close() {
        try {
            this.is.close();
        }
        catch (Throwable t) {
            LOGGER.warn("Failure closing input stream for " + this.getOriginDesc(), t);
        }
        if (this.streamOrigin instanceof ZipFile) {
            try {
                ((ZipFile)this.streamOrigin).close();
            }
            catch (Throwable t) {
                LOGGER.warn("Failure closing " + this.getOriginDesc(), t);
            }
        }
    }

    public String getOriginDesc() {
        String ret = "";
        ret = this.streamOrigin instanceof File ? "file " + ((File)this.streamOrigin).getAbsolutePath() : "archive " + ((ZipFile)this.streamOrigin).getName();
        return ret;
    }
}

