pragma Ada_2005;
pragma Style_Checks (Off);

with Interfaces.C; use Interfaces.C;
with System;
with dbus_types_h;
with Interfaces.C.Strings;
with dbus_shared_h;
limited with dbus_errors_h;
with dbus_arch_deps_h;
with dbus_memory_h;

package dbus_connection_h is

   --  skipped empty struct DBusWatch

   --  skipped empty struct DBusTimeout

   --  skipped empty struct DBusPreallocatedSend

   --  skipped empty struct DBusPendingCall

   --  skipped empty struct DBusConnection

   subtype DBusWatchFlags is unsigned;
   DBUS_WATCH_READABLE : constant DBusWatchFlags := 1;
   DBUS_WATCH_WRITABLE : constant DBusWatchFlags := 2;
   DBUS_WATCH_ERROR : constant DBusWatchFlags := 4;
   DBUS_WATCH_HANGUP : constant DBusWatchFlags := 8;  -- ../dbus/dbus-connection.h:73

   type DBusDispatchStatus is
     (DBUS_DISPATCH_DATA_REMAINS,
      DBUS_DISPATCH_COMPLETE,
      DBUS_DISPATCH_NEED_MEMORY);
   pragma Convention (C, DBusDispatchStatus);  -- ../dbus/dbus-connection.h:84

   type DBusAddWatchFunction is access function (arg1 : System.Address; arg2 : System.Address) return dbus_types_h.dbus_bool_t;
   pragma Convention (C, DBusAddWatchFunction);  -- ../dbus/dbus-connection.h:91

   type DBusWatchToggledFunction is access procedure (arg1 : System.Address; arg2 : System.Address);
   pragma Convention (C, DBusWatchToggledFunction);  -- ../dbus/dbus-connection.h:97

   type DBusRemoveWatchFunction is access procedure (arg1 : System.Address; arg2 : System.Address);
   pragma Convention (C, DBusRemoveWatchFunction);  -- ../dbus/dbus-connection.h:103

   type DBusAddTimeoutFunction is access function (arg1 : System.Address; arg2 : System.Address) return dbus_types_h.dbus_bool_t;
   pragma Convention (C, DBusAddTimeoutFunction);  -- ../dbus/dbus-connection.h:110

   type DBusTimeoutToggledFunction is access procedure (arg1 : System.Address; arg2 : System.Address);
   pragma Convention (C, DBusTimeoutToggledFunction);  -- ../dbus/dbus-connection.h:117

   type DBusRemoveTimeoutFunction is access procedure (arg1 : System.Address; arg2 : System.Address);
   pragma Convention (C, DBusRemoveTimeoutFunction);  -- ../dbus/dbus-connection.h:123

   type DBusDispatchStatusFunction is access procedure
        (arg1 : System.Address;
         arg2 : DBusDispatchStatus;
         arg3 : System.Address);
   pragma Convention (C, DBusDispatchStatusFunction);  -- ../dbus/dbus-connection.h:128

   type DBusWakeupMainFunction is access procedure (arg1 : System.Address);
   pragma Convention (C, DBusWakeupMainFunction);  -- ../dbus/dbus-connection.h:135

   type DBusAllowUnixUserFunction is access function
        (arg1 : System.Address;
         arg2 : unsigned_long;
         arg3 : System.Address) return dbus_types_h.dbus_bool_t;
   pragma Convention (C, DBusAllowUnixUserFunction);  -- ../dbus/dbus-connection.h:143

   type DBusAllowWindowsUserFunction is access function
        (arg1 : System.Address;
         arg2 : Interfaces.C.Strings.chars_ptr;
         arg3 : System.Address) return dbus_types_h.dbus_bool_t;
   pragma Convention (C, DBusAllowWindowsUserFunction);  -- ../dbus/dbus-connection.h:153

   type DBusPendingCallNotifyFunction is access procedure (arg1 : System.Address; arg2 : System.Address);
   pragma Convention (C, DBusPendingCallNotifyFunction);  -- ../dbus/dbus-connection.h:162

   type DBusHandleMessageFunction is access function
        (arg1 : System.Address;
         arg2 : System.Address;
         arg3 : System.Address) return dbus_shared_h.DBusHandlerResult;
   pragma Convention (C, DBusHandleMessageFunction);  -- ../dbus/dbus-connection.h:169

   function dbus_connection_open (address : Interfaces.C.Strings.chars_ptr; error : access dbus_errors_h.DBusError) return System.Address;  -- ../dbus/dbus-connection.h:173
   pragma Import (C, dbus_connection_open, "dbus_connection_open");

   function dbus_connection_open_private (address : Interfaces.C.Strings.chars_ptr; error : access dbus_errors_h.DBusError) return System.Address;  -- ../dbus/dbus-connection.h:176
   pragma Import (C, dbus_connection_open_private, "dbus_connection_open_private");

   function dbus_connection_ref (connection : System.Address) return System.Address;  -- ../dbus/dbus-connection.h:179
   pragma Import (C, dbus_connection_ref, "dbus_connection_ref");

   procedure dbus_connection_unref (connection : System.Address);  -- ../dbus/dbus-connection.h:181
   pragma Import (C, dbus_connection_unref, "dbus_connection_unref");

   procedure dbus_connection_close (connection : System.Address);  -- ../dbus/dbus-connection.h:183
   pragma Import (C, dbus_connection_close, "dbus_connection_close");

   function dbus_connection_get_is_connected (connection : System.Address) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-connection.h:185
   pragma Import (C, dbus_connection_get_is_connected, "dbus_connection_get_is_connected");

   function dbus_connection_get_is_authenticated (connection : System.Address) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-connection.h:187
   pragma Import (C, dbus_connection_get_is_authenticated, "dbus_connection_get_is_authenticated");

   function dbus_connection_get_is_anonymous (connection : System.Address) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-connection.h:189
   pragma Import (C, dbus_connection_get_is_anonymous, "dbus_connection_get_is_anonymous");

   function dbus_connection_get_server_id (connection : System.Address) return Interfaces.C.Strings.chars_ptr;  -- ../dbus/dbus-connection.h:191
   pragma Import (C, dbus_connection_get_server_id, "dbus_connection_get_server_id");

   function dbus_connection_can_send_type (connection : System.Address; c_type : int) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-connection.h:193
   pragma Import (C, dbus_connection_can_send_type, "dbus_connection_can_send_type");

   procedure dbus_connection_set_exit_on_disconnect (connection : System.Address; exit_on_disconnect : dbus_types_h.dbus_bool_t);  -- ../dbus/dbus-connection.h:197
   pragma Import (C, dbus_connection_set_exit_on_disconnect, "dbus_connection_set_exit_on_disconnect");

   procedure dbus_connection_flush (connection : System.Address);  -- ../dbus/dbus-connection.h:200
   pragma Import (C, dbus_connection_flush, "dbus_connection_flush");

   function dbus_connection_read_write_dispatch (connection : System.Address; timeout_milliseconds : int) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-connection.h:202
   pragma Import (C, dbus_connection_read_write_dispatch, "dbus_connection_read_write_dispatch");

   function dbus_connection_read_write (connection : System.Address; timeout_milliseconds : int) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-connection.h:205
   pragma Import (C, dbus_connection_read_write, "dbus_connection_read_write");

   function dbus_connection_borrow_message (connection : System.Address) return System.Address;  -- ../dbus/dbus-connection.h:208
   pragma Import (C, dbus_connection_borrow_message, "dbus_connection_borrow_message");

   procedure dbus_connection_return_message (connection : System.Address; message : System.Address);  -- ../dbus/dbus-connection.h:210
   pragma Import (C, dbus_connection_return_message, "dbus_connection_return_message");

   procedure dbus_connection_steal_borrowed_message (connection : System.Address; message : System.Address);  -- ../dbus/dbus-connection.h:213
   pragma Import (C, dbus_connection_steal_borrowed_message, "dbus_connection_steal_borrowed_message");

   function dbus_connection_pop_message (connection : System.Address) return System.Address;  -- ../dbus/dbus-connection.h:216
   pragma Import (C, dbus_connection_pop_message, "dbus_connection_pop_message");

   function dbus_connection_get_dispatch_status (connection : System.Address) return DBusDispatchStatus;  -- ../dbus/dbus-connection.h:218
   pragma Import (C, dbus_connection_get_dispatch_status, "dbus_connection_get_dispatch_status");

   function dbus_connection_dispatch (connection : System.Address) return DBusDispatchStatus;  -- ../dbus/dbus-connection.h:220
   pragma Import (C, dbus_connection_dispatch, "dbus_connection_dispatch");

   function dbus_connection_has_messages_to_send (connection : System.Address) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-connection.h:222
   pragma Import (C, dbus_connection_has_messages_to_send, "dbus_connection_has_messages_to_send");

   function dbus_connection_send
     (connection : System.Address;
      message : System.Address;
      client_serial : access dbus_arch_deps_h.dbus_uint32_t) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-connection.h:224
   pragma Import (C, dbus_connection_send, "dbus_connection_send");

   function dbus_connection_send_with_reply
     (connection : System.Address;
      message : System.Address;
      pending_return : System.Address;
      timeout_milliseconds : int) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-connection.h:228
   pragma Import (C, dbus_connection_send_with_reply, "dbus_connection_send_with_reply");

   function dbus_connection_send_with_reply_and_block
     (connection : System.Address;
      message : System.Address;
      timeout_milliseconds : int;
      error : access dbus_errors_h.DBusError) return System.Address;  -- ../dbus/dbus-connection.h:233
   pragma Import (C, dbus_connection_send_with_reply_and_block, "dbus_connection_send_with_reply_and_block");

   function dbus_connection_set_watch_functions
     (connection : System.Address;
      add_function : DBusAddWatchFunction;
      remove_function : DBusRemoveWatchFunction;
      toggled_function : DBusWatchToggledFunction;
      data : System.Address;
      free_data_function : dbus_memory_h.DBusFreeFunction) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-connection.h:238
   pragma Import (C, dbus_connection_set_watch_functions, "dbus_connection_set_watch_functions");

   function dbus_connection_set_timeout_functions
     (connection : System.Address;
      add_function : DBusAddTimeoutFunction;
      remove_function : DBusRemoveTimeoutFunction;
      toggled_function : DBusTimeoutToggledFunction;
      data : System.Address;
      free_data_function : dbus_memory_h.DBusFreeFunction) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-connection.h:245
   pragma Import (C, dbus_connection_set_timeout_functions, "dbus_connection_set_timeout_functions");

   procedure dbus_connection_set_wakeup_main_function
     (connection : System.Address;
      wakeup_main_function : DBusWakeupMainFunction;
      data : System.Address;
      free_data_function : dbus_memory_h.DBusFreeFunction);  -- ../dbus/dbus-connection.h:252
   pragma Import (C, dbus_connection_set_wakeup_main_function, "dbus_connection_set_wakeup_main_function");

   procedure dbus_connection_set_dispatch_status_function
     (connection : System.Address;
      c_function : DBusDispatchStatusFunction;
      data : System.Address;
      free_data_function : dbus_memory_h.DBusFreeFunction);  -- ../dbus/dbus-connection.h:257
   pragma Import (C, dbus_connection_set_dispatch_status_function, "dbus_connection_set_dispatch_status_function");

   function dbus_connection_get_unix_user (connection : System.Address; uid : access unsigned_long) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-connection.h:262
   pragma Import (C, dbus_connection_get_unix_user, "dbus_connection_get_unix_user");

   function dbus_connection_get_unix_process_id (connection : System.Address; pid : access unsigned_long) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-connection.h:265
   pragma Import (C, dbus_connection_get_unix_process_id, "dbus_connection_get_unix_process_id");

   function dbus_connection_get_adt_audit_session_data
     (connection : System.Address;
      data : System.Address;
      data_size : access dbus_arch_deps_h.dbus_int32_t) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-connection.h:268
   pragma Import (C, dbus_connection_get_adt_audit_session_data, "dbus_connection_get_adt_audit_session_data");

   procedure dbus_connection_set_unix_user_function
     (connection : System.Address;
      c_function : DBusAllowUnixUserFunction;
      data : System.Address;
      free_data_function : dbus_memory_h.DBusFreeFunction);  -- ../dbus/dbus-connection.h:272
   pragma Import (C, dbus_connection_set_unix_user_function, "dbus_connection_set_unix_user_function");

   function dbus_connection_get_windows_user (connection : System.Address; windows_sid_p : System.Address) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-connection.h:277
   pragma Import (C, dbus_connection_get_windows_user, "dbus_connection_get_windows_user");

   procedure dbus_connection_set_windows_user_function
     (connection : System.Address;
      c_function : DBusAllowWindowsUserFunction;
      data : System.Address;
      free_data_function : dbus_memory_h.DBusFreeFunction);  -- ../dbus/dbus-connection.h:280
   pragma Import (C, dbus_connection_set_windows_user_function, "dbus_connection_set_windows_user_function");

   procedure dbus_connection_set_allow_anonymous (connection : System.Address; value : dbus_types_h.dbus_bool_t);  -- ../dbus/dbus-connection.h:285
   pragma Import (C, dbus_connection_set_allow_anonymous, "dbus_connection_set_allow_anonymous");

   procedure dbus_connection_set_route_peer_messages (connection : System.Address; value : dbus_types_h.dbus_bool_t);  -- ../dbus/dbus-connection.h:288
   pragma Import (C, dbus_connection_set_route_peer_messages, "dbus_connection_set_route_peer_messages");

   function dbus_connection_add_filter
     (connection : System.Address;
      c_function : DBusHandleMessageFunction;
      user_data : System.Address;
      free_data_function : dbus_memory_h.DBusFreeFunction) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-connection.h:295
   pragma Import (C, dbus_connection_add_filter, "dbus_connection_add_filter");

   procedure dbus_connection_remove_filter
     (connection : System.Address;
      c_function : DBusHandleMessageFunction;
      user_data : System.Address);  -- ../dbus/dbus-connection.h:300
   pragma Import (C, dbus_connection_remove_filter, "dbus_connection_remove_filter");

   function dbus_connection_allocate_data_slot (slot_p : access dbus_arch_deps_h.dbus_int32_t) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-connection.h:307
   pragma Import (C, dbus_connection_allocate_data_slot, "dbus_connection_allocate_data_slot");

   procedure dbus_connection_free_data_slot (slot_p : access dbus_arch_deps_h.dbus_int32_t);  -- ../dbus/dbus-connection.h:309
   pragma Import (C, dbus_connection_free_data_slot, "dbus_connection_free_data_slot");

   function dbus_connection_set_data
     (connection : System.Address;
      slot : dbus_arch_deps_h.dbus_int32_t;
      data : System.Address;
      free_data_func : dbus_memory_h.DBusFreeFunction) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-connection.h:311
   pragma Import (C, dbus_connection_set_data, "dbus_connection_set_data");

   function dbus_connection_get_data (connection : System.Address; slot : dbus_arch_deps_h.dbus_int32_t) return System.Address;  -- ../dbus/dbus-connection.h:316
   pragma Import (C, dbus_connection_get_data, "dbus_connection_get_data");

   procedure dbus_connection_set_change_sigpipe (will_modify_sigpipe : dbus_types_h.dbus_bool_t);  -- ../dbus/dbus-connection.h:320
   pragma Import (C, dbus_connection_set_change_sigpipe, "dbus_connection_set_change_sigpipe");

   procedure dbus_connection_set_max_message_size (connection : System.Address; size : long);  -- ../dbus/dbus-connection.h:323
   pragma Import (C, dbus_connection_set_max_message_size, "dbus_connection_set_max_message_size");

   function dbus_connection_get_max_message_size (connection : System.Address) return long;  -- ../dbus/dbus-connection.h:326
   pragma Import (C, dbus_connection_get_max_message_size, "dbus_connection_get_max_message_size");

   procedure dbus_connection_set_max_received_size (connection : System.Address; size : long);  -- ../dbus/dbus-connection.h:328
   pragma Import (C, dbus_connection_set_max_received_size, "dbus_connection_set_max_received_size");

   function dbus_connection_get_max_received_size (connection : System.Address) return long;  -- ../dbus/dbus-connection.h:331
   pragma Import (C, dbus_connection_get_max_received_size, "dbus_connection_get_max_received_size");

   procedure dbus_connection_set_max_message_unix_fds (connection : System.Address; n : long);  -- ../dbus/dbus-connection.h:334
   pragma Import (C, dbus_connection_set_max_message_unix_fds, "dbus_connection_set_max_message_unix_fds");

   function dbus_connection_get_max_message_unix_fds (connection : System.Address) return long;  -- ../dbus/dbus-connection.h:337
   pragma Import (C, dbus_connection_get_max_message_unix_fds, "dbus_connection_get_max_message_unix_fds");

   procedure dbus_connection_set_max_received_unix_fds (connection : System.Address; n : long);  -- ../dbus/dbus-connection.h:339
   pragma Import (C, dbus_connection_set_max_received_unix_fds, "dbus_connection_set_max_received_unix_fds");

   function dbus_connection_get_max_received_unix_fds (connection : System.Address) return long;  -- ../dbus/dbus-connection.h:342
   pragma Import (C, dbus_connection_get_max_received_unix_fds, "dbus_connection_get_max_received_unix_fds");

   function dbus_connection_get_outgoing_size (connection : System.Address) return long;  -- ../dbus/dbus-connection.h:345
   pragma Import (C, dbus_connection_get_outgoing_size, "dbus_connection_get_outgoing_size");

   function dbus_connection_get_outgoing_unix_fds (connection : System.Address) return long;  -- ../dbus/dbus-connection.h:347
   pragma Import (C, dbus_connection_get_outgoing_unix_fds, "dbus_connection_get_outgoing_unix_fds");

   function dbus_connection_preallocate_send (connection : System.Address) return System.Address;  -- ../dbus/dbus-connection.h:350
   pragma Import (C, dbus_connection_preallocate_send, "dbus_connection_preallocate_send");

   procedure dbus_connection_free_preallocated_send (connection : System.Address; preallocated : System.Address);  -- ../dbus/dbus-connection.h:352
   pragma Import (C, dbus_connection_free_preallocated_send, "dbus_connection_free_preallocated_send");

   procedure dbus_connection_send_preallocated
     (connection : System.Address;
      preallocated : System.Address;
      message : System.Address;
      client_serial : access dbus_arch_deps_h.dbus_uint32_t);  -- ../dbus/dbus-connection.h:355
   pragma Import (C, dbus_connection_send_preallocated, "dbus_connection_send_preallocated");

   type DBusObjectPathUnregisterFunction is access procedure (arg1 : System.Address; arg2 : System.Address);
   pragma Convention (C, DBusObjectPathUnregisterFunction);  -- ../dbus/dbus-connection.h:367

   type DBusObjectPathMessageFunction is access function
        (arg1 : System.Address;
         arg2 : System.Address;
         arg3 : System.Address) return dbus_shared_h.DBusHandlerResult;
   pragma Convention (C, DBusObjectPathMessageFunction);  -- ../dbus/dbus-connection.h:374

   type DBusObjectPathVTable is record
      unregister_function : DBusObjectPathUnregisterFunction;  -- ../dbus/dbus-connection.h:386
      message_function : DBusObjectPathMessageFunction;  -- ../dbus/dbus-connection.h:387
      dbus_internal_pad1 : access procedure (arg1 : System.Address);  -- ../dbus/dbus-connection.h:389
      dbus_internal_pad2 : access procedure (arg1 : System.Address);  -- ../dbus/dbus-connection.h:390
      dbus_internal_pad3 : access procedure (arg1 : System.Address);  -- ../dbus/dbus-connection.h:391
      dbus_internal_pad4 : access procedure (arg1 : System.Address);  -- ../dbus/dbus-connection.h:392
   end record;
   pragma Convention (C_Pass_By_Copy, DBusObjectPathVTable);  -- ../dbus/dbus-connection.h:384

   function dbus_connection_try_register_object_path
     (connection : System.Address;
      path : Interfaces.C.Strings.chars_ptr;
      vtable : access constant DBusObjectPathVTable;
      user_data : System.Address;
      error : access dbus_errors_h.DBusError) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-connection.h:396
   pragma Import (C, dbus_connection_try_register_object_path, "dbus_connection_try_register_object_path");

   function dbus_connection_register_object_path
     (connection : System.Address;
      path : Interfaces.C.Strings.chars_ptr;
      vtable : access constant DBusObjectPathVTable;
      user_data : System.Address) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-connection.h:403
   pragma Import (C, dbus_connection_register_object_path, "dbus_connection_register_object_path");

   function dbus_connection_try_register_fallback
     (connection : System.Address;
      path : Interfaces.C.Strings.chars_ptr;
      vtable : access constant DBusObjectPathVTable;
      user_data : System.Address;
      error : access dbus_errors_h.DBusError) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-connection.h:409
   pragma Import (C, dbus_connection_try_register_fallback, "dbus_connection_try_register_fallback");

   function dbus_connection_register_fallback
     (connection : System.Address;
      path : Interfaces.C.Strings.chars_ptr;
      vtable : access constant DBusObjectPathVTable;
      user_data : System.Address) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-connection.h:416
   pragma Import (C, dbus_connection_register_fallback, "dbus_connection_register_fallback");

   function dbus_connection_unregister_object_path (connection : System.Address; path : Interfaces.C.Strings.chars_ptr) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-connection.h:421
   pragma Import (C, dbus_connection_unregister_object_path, "dbus_connection_unregister_object_path");

   function dbus_connection_get_object_path_data
     (connection : System.Address;
      path : Interfaces.C.Strings.chars_ptr;
      data_p : System.Address) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-connection.h:425
   pragma Import (C, dbus_connection_get_object_path_data, "dbus_connection_get_object_path_data");

   function dbus_connection_list_registered
     (connection : System.Address;
      parent_path : Interfaces.C.Strings.chars_ptr;
      child_entries : System.Address) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-connection.h:430
   pragma Import (C, dbus_connection_list_registered, "dbus_connection_list_registered");

   function dbus_connection_get_unix_fd (connection : System.Address; fd : access int) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-connection.h:435
   pragma Import (C, dbus_connection_get_unix_fd, "dbus_connection_get_unix_fd");

   function dbus_connection_get_socket (connection : System.Address; fd : access int) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-connection.h:438
   pragma Import (C, dbus_connection_get_socket, "dbus_connection_get_socket");

   function dbus_watch_get_fd (watch : System.Address) return int;  -- ../dbus/dbus-connection.h:451
   pragma Import (C, dbus_watch_get_fd, "dbus_watch_get_fd");

   function dbus_watch_get_unix_fd (watch : System.Address) return int;  -- ../dbus/dbus-connection.h:455
   pragma Import (C, dbus_watch_get_unix_fd, "dbus_watch_get_unix_fd");

   function dbus_watch_get_socket (watch : System.Address) return int;  -- ../dbus/dbus-connection.h:457
   pragma Import (C, dbus_watch_get_socket, "dbus_watch_get_socket");

   function dbus_watch_get_flags (watch : System.Address) return unsigned;  -- ../dbus/dbus-connection.h:459
   pragma Import (C, dbus_watch_get_flags, "dbus_watch_get_flags");

   function dbus_watch_get_data (watch : System.Address) return System.Address;  -- ../dbus/dbus-connection.h:461
   pragma Import (C, dbus_watch_get_data, "dbus_watch_get_data");

   procedure dbus_watch_set_data
     (watch : System.Address;
      data : System.Address;
      free_data_function : dbus_memory_h.DBusFreeFunction);  -- ../dbus/dbus-connection.h:463
   pragma Import (C, dbus_watch_set_data, "dbus_watch_set_data");

   function dbus_watch_handle (watch : System.Address; flags : unsigned) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-connection.h:467
   pragma Import (C, dbus_watch_handle, "dbus_watch_handle");

   function dbus_watch_get_enabled (watch : System.Address) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-connection.h:470
   pragma Import (C, dbus_watch_get_enabled, "dbus_watch_get_enabled");

   function dbus_timeout_get_interval (timeout : System.Address) return int;  -- ../dbus/dbus-connection.h:480
   pragma Import (C, dbus_timeout_get_interval, "dbus_timeout_get_interval");

   function dbus_timeout_get_data (timeout : System.Address) return System.Address;  -- ../dbus/dbus-connection.h:482
   pragma Import (C, dbus_timeout_get_data, "dbus_timeout_get_data");

   procedure dbus_timeout_set_data
     (timeout : System.Address;
      data : System.Address;
      free_data_function : dbus_memory_h.DBusFreeFunction);  -- ../dbus/dbus-connection.h:484
   pragma Import (C, dbus_timeout_set_data, "dbus_timeout_set_data");

   function dbus_timeout_handle (timeout : System.Address) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-connection.h:488
   pragma Import (C, dbus_timeout_handle, "dbus_timeout_handle");

   function dbus_timeout_get_enabled (timeout : System.Address) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-connection.h:490
   pragma Import (C, dbus_timeout_get_enabled, "dbus_timeout_get_enabled");

end dbus_connection_h;
