#
# Set the DFLAGS global variable matching the current default D compiler on the given architecture,
# to apply the D flags we want for release builds in Debian.
# This also applies arch-specific quirks, like not building with NEON on armhf when LDC is used.
#
# This script is supposed to be included by debian/rules directly
#

include /usr/share/dpkg/buildflags.mk

DC = gdc

ifeq (,$(filter not-installed, $(shell dpkg-query -W -f='$${Status}' ldc 2>/dev/null)))
    DC_LDC_FOUND := yes
endif

ifeq (,$(filter not-installed, $(shell dpkg-query -W -f='$${Status}' gdc 2>/dev/null)))
    DC_GDC_FOUND := yes
endif

# by default, use GCC/GDC Debian optimization flags for D,
# but remove the warning flags that aren't supported in D.
DFLAGS = $(filter-out -Wformat -Werror=format-security,$(CFLAGS)) -frelease

# set DC to the LDC compiler on platforms where we should use it,
# and also set the right D flags on those architectures (since LDC uses different flag names)
ifneq (,$(filter $(DEB_HOST_ARCH), amd64 arm64 i386 riscv64))
    # only set LDC build flags if our compiler is LDC
    ifeq ($(DC_LDC_FOUND),yes)
        DC = ldc2
        DFLAGS = -O -g -release -wi
        ifeq ($(DEB_HOST_ARCH),armhf)
            DFLAGS += -mattr=-neon
        endif
    endif
endif
export DFLAGS
export DC
