﻿// <auto-generated />

using System;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Razor.Language;
using Microsoft.AspNetCore.Razor.Test.Common;
using Microsoft.CodeAnalysis.ExternalAccess.Razor.Features;
using Microsoft.CodeAnalysis.Razor.Formatting;
using Xunit;
using Xunit.Abstractions;

namespace Microsoft.VisualStudio.Razor.LanguageClient.Cohost.Formatting;

[Collection(HtmlFormattingCollection.Name)]
public class CSharpSyntaxFormattingOptionsTest(FormattingTestContext context, HtmlFormattingFixture fixture, ITestOutputHelper testOutput)
    : FormattingTestBase(context, fixture.Service, testOutput), IClassFixture<FormattingTestContext>
{
    [FormattingTestFact]
    public async Task CSharpSyntaxFormattingOptions_WithoutBeforeMembersInObjectInitializers_SingleLine_PreserveSingle()
    {
        await RunFormattingTestAsync(
            input: """
                @code
                {
                private bool IconMenuActive { get; set; } = false;
                protected void ToggleIconMenu(bool iconMenuActive)
                {
                IconMenuActive = iconMenuActive;
                }
                }
                """,
            expected: """
                @code
                {
                    private bool IconMenuActive { get; set; } = false;
                    protected void ToggleIconMenu(bool iconMenuActive)
                    {
                        IconMenuActive = iconMenuActive;
                    }
                }
                """,
            csharpSyntaxFormattingOptions: RazorCSharpSyntaxFormattingOptions.Default with
            {
                NewLines = RazorNewLinePlacement.BeforeMembersInAnonymousTypes | RazorNewLinePlacement.BeforeElse | RazorNewLinePlacement.BeforeCatch | RazorNewLinePlacement.BeforeFinally | RazorNewLinePlacement.BeforeOpenBraceInTypes | RazorNewLinePlacement.BeforeOpenBraceInAnonymousTypes | RazorNewLinePlacement.BeforeOpenBraceInObjectCollectionArrayInitializers | RazorNewLinePlacement.BeforeOpenBraceInProperties | RazorNewLinePlacement.BeforeOpenBraceInMethods | RazorNewLinePlacement.BeforeOpenBraceInAccessors | RazorNewLinePlacement.BeforeOpenBraceInAnonymousMethods | RazorNewLinePlacement.BeforeOpenBraceInLambdaExpressionBody | RazorNewLinePlacement.BeforeOpenBraceInControlBlocks | RazorNewLinePlacement.BetweenQueryExpressionClauses,
                WrappingKeepStatementsOnSingleLine = true,
                WrappingPreserveSingleLine = true,
            });
    }

    [FormattingTestFact]
    public async Task CSharpSyntaxFormattingOptions_WithoutBeforeMembersInObjectInitializers_SingleLine_DontPreserve()
    {
        await RunFormattingTestAsync(
            input: """
                @code
                {
                private bool IconMenuActive { get; set; } = false;
                protected void ToggleIconMenu(bool iconMenuActive)
                {
                IconMenuActive = iconMenuActive;
                }
                }
                """,
            expected: """
                @code
                {
                    private bool IconMenuActive { get; set; } = false;
                    protected void ToggleIconMenu(bool iconMenuActive)
                    {
                        IconMenuActive = iconMenuActive;
                    }
                }
                """,
            csharpSyntaxFormattingOptions: RazorCSharpSyntaxFormattingOptions.Default with
            {
                NewLines = RazorNewLinePlacement.BeforeMembersInAnonymousTypes | RazorNewLinePlacement.BeforeElse | RazorNewLinePlacement.BeforeCatch | RazorNewLinePlacement.BeforeFinally | RazorNewLinePlacement.BeforeOpenBraceInTypes | RazorNewLinePlacement.BeforeOpenBraceInAnonymousTypes | RazorNewLinePlacement.BeforeOpenBraceInObjectCollectionArrayInitializers | RazorNewLinePlacement.BeforeOpenBraceInProperties | RazorNewLinePlacement.BeforeOpenBraceInMethods | RazorNewLinePlacement.BeforeOpenBraceInAccessors | RazorNewLinePlacement.BeforeOpenBraceInAnonymousMethods | RazorNewLinePlacement.BeforeOpenBraceInLambdaExpressionBody | RazorNewLinePlacement.BeforeOpenBraceInControlBlocks | RazorNewLinePlacement.BetweenQueryExpressionClauses,
                WrappingKeepStatementsOnSingleLine = true,
                WrappingPreserveSingleLine = false,
            });
    }

    [FormattingTestFact]
    public async Task CSharpSyntaxFormattingOptions_WithoutBeforeMembersInObjectInitializers_MultiLine_PreserveSingle()
    {
        await RunFormattingTestAsync(
            input: """
                @code
                {
                private bool IconMenuActive { get; set; } = false;
                protected void ToggleIconMenu(bool iconMenuActive)
                {
                IconMenuActive = iconMenuActive;
                }
                }
                """,
            expected: """
                @code
                {
                    private bool IconMenuActive { get; set; } = false;
                    protected void ToggleIconMenu(bool iconMenuActive)
                    {
                        IconMenuActive = iconMenuActive;
                    }
                }
                """,
            csharpSyntaxFormattingOptions: RazorCSharpSyntaxFormattingOptions.Default with
            {
                NewLines = RazorNewLinePlacement.BeforeMembersInAnonymousTypes | RazorNewLinePlacement.BeforeElse | RazorNewLinePlacement.BeforeCatch | RazorNewLinePlacement.BeforeFinally | RazorNewLinePlacement.BeforeOpenBraceInTypes | RazorNewLinePlacement.BeforeOpenBraceInAnonymousTypes | RazorNewLinePlacement.BeforeOpenBraceInObjectCollectionArrayInitializers | RazorNewLinePlacement.BeforeOpenBraceInProperties | RazorNewLinePlacement.BeforeOpenBraceInMethods | RazorNewLinePlacement.BeforeOpenBraceInAccessors | RazorNewLinePlacement.BeforeOpenBraceInAnonymousMethods | RazorNewLinePlacement.BeforeOpenBraceInLambdaExpressionBody | RazorNewLinePlacement.BeforeOpenBraceInControlBlocks | RazorNewLinePlacement.BetweenQueryExpressionClauses,
                WrappingKeepStatementsOnSingleLine = false,
                WrappingPreserveSingleLine = true,
            });
    }

    [FormattingTestFact]
    public async Task CSharpSyntaxFormattingOptions_WithoutBeforeMembersInObjectInitializers_MultiLine_DontPreserve()
    {
        await RunFormattingTestAsync(
            input: """
                @code
                {
                private bool IconMenuActive { get; set; } = false;
                protected void ToggleIconMenu(bool iconMenuActive)
                {
                IconMenuActive = iconMenuActive;
                }
                }
                """,
            expected: """
                @code
                {
                    private bool IconMenuActive { get; set; } = false;
                    protected void ToggleIconMenu(bool iconMenuActive)
                    {
                        IconMenuActive = iconMenuActive;
                    }
                }
                """,
            csharpSyntaxFormattingOptions: RazorCSharpSyntaxFormattingOptions.Default with
            {
                NewLines = RazorNewLinePlacement.BeforeMembersInAnonymousTypes | RazorNewLinePlacement.BeforeElse | RazorNewLinePlacement.BeforeCatch | RazorNewLinePlacement.BeforeFinally | RazorNewLinePlacement.BeforeOpenBraceInTypes | RazorNewLinePlacement.BeforeOpenBraceInAnonymousTypes | RazorNewLinePlacement.BeforeOpenBraceInObjectCollectionArrayInitializers | RazorNewLinePlacement.BeforeOpenBraceInProperties | RazorNewLinePlacement.BeforeOpenBraceInMethods | RazorNewLinePlacement.BeforeOpenBraceInAccessors | RazorNewLinePlacement.BeforeOpenBraceInAnonymousMethods | RazorNewLinePlacement.BeforeOpenBraceInLambdaExpressionBody | RazorNewLinePlacement.BeforeOpenBraceInControlBlocks | RazorNewLinePlacement.BetweenQueryExpressionClauses,
                WrappingKeepStatementsOnSingleLine = false,
                WrappingPreserveSingleLine = false,
            });
    }

    [FormattingTestFact]
    public async Task CSharpSyntaxFormattingOptions_WithoutBeforeMembersInAnonymousTypes_SingleLine_PreserveSingle()
    {
        await RunFormattingTestAsync(
            input: """
                @code
                {
                private bool IconMenuActive { get; set; } = false;
                protected void ToggleIconMenu(bool iconMenuActive)
                {
                IconMenuActive = iconMenuActive;
                }
                }
                """,
            expected: """
                @code
                {
                    private bool IconMenuActive { get; set; } = false;
                    protected void ToggleIconMenu(bool iconMenuActive)
                    {
                        IconMenuActive = iconMenuActive;
                    }
                }
                """,
            csharpSyntaxFormattingOptions: RazorCSharpSyntaxFormattingOptions.Default with
            {
                NewLines = RazorNewLinePlacement.BeforeMembersInObjectInitializers | RazorNewLinePlacement.BeforeElse | RazorNewLinePlacement.BeforeCatch | RazorNewLinePlacement.BeforeFinally | RazorNewLinePlacement.BeforeOpenBraceInTypes | RazorNewLinePlacement.BeforeOpenBraceInAnonymousTypes | RazorNewLinePlacement.BeforeOpenBraceInObjectCollectionArrayInitializers | RazorNewLinePlacement.BeforeOpenBraceInProperties | RazorNewLinePlacement.BeforeOpenBraceInMethods | RazorNewLinePlacement.BeforeOpenBraceInAccessors | RazorNewLinePlacement.BeforeOpenBraceInAnonymousMethods | RazorNewLinePlacement.BeforeOpenBraceInLambdaExpressionBody | RazorNewLinePlacement.BeforeOpenBraceInControlBlocks | RazorNewLinePlacement.BetweenQueryExpressionClauses,
                WrappingKeepStatementsOnSingleLine = true,
                WrappingPreserveSingleLine = true,
            });
    }

    [FormattingTestFact]
    public async Task CSharpSyntaxFormattingOptions_WithoutBeforeMembersInAnonymousTypes_SingleLine_DontPreserve()
    {
        await RunFormattingTestAsync(
            input: """
                @code
                {
                private bool IconMenuActive { get; set; } = false;
                protected void ToggleIconMenu(bool iconMenuActive)
                {
                IconMenuActive = iconMenuActive;
                }
                }
                """,
            expected: """
                @code
                {
                    private bool IconMenuActive { get; set; } = false;
                    protected void ToggleIconMenu(bool iconMenuActive)
                    {
                        IconMenuActive = iconMenuActive;
                    }
                }
                """,
            csharpSyntaxFormattingOptions: RazorCSharpSyntaxFormattingOptions.Default with
            {
                NewLines = RazorNewLinePlacement.BeforeMembersInObjectInitializers | RazorNewLinePlacement.BeforeElse | RazorNewLinePlacement.BeforeCatch | RazorNewLinePlacement.BeforeFinally | RazorNewLinePlacement.BeforeOpenBraceInTypes | RazorNewLinePlacement.BeforeOpenBraceInAnonymousTypes | RazorNewLinePlacement.BeforeOpenBraceInObjectCollectionArrayInitializers | RazorNewLinePlacement.BeforeOpenBraceInProperties | RazorNewLinePlacement.BeforeOpenBraceInMethods | RazorNewLinePlacement.BeforeOpenBraceInAccessors | RazorNewLinePlacement.BeforeOpenBraceInAnonymousMethods | RazorNewLinePlacement.BeforeOpenBraceInLambdaExpressionBody | RazorNewLinePlacement.BeforeOpenBraceInControlBlocks | RazorNewLinePlacement.BetweenQueryExpressionClauses,
                WrappingKeepStatementsOnSingleLine = true,
                WrappingPreserveSingleLine = false,
            });
    }

    [FormattingTestFact]
    public async Task CSharpSyntaxFormattingOptions_WithoutBeforeMembersInAnonymousTypes_MultiLine_PreserveSingle()
    {
        await RunFormattingTestAsync(
            input: """
                @code
                {
                private bool IconMenuActive { get; set; } = false;
                protected void ToggleIconMenu(bool iconMenuActive)
                {
                IconMenuActive = iconMenuActive;
                }
                }
                """,
            expected: """
                @code
                {
                    private bool IconMenuActive { get; set; } = false;
                    protected void ToggleIconMenu(bool iconMenuActive)
                    {
                        IconMenuActive = iconMenuActive;
                    }
                }
                """,
            csharpSyntaxFormattingOptions: RazorCSharpSyntaxFormattingOptions.Default with
            {
                NewLines = RazorNewLinePlacement.BeforeMembersInObjectInitializers | RazorNewLinePlacement.BeforeElse | RazorNewLinePlacement.BeforeCatch | RazorNewLinePlacement.BeforeFinally | RazorNewLinePlacement.BeforeOpenBraceInTypes | RazorNewLinePlacement.BeforeOpenBraceInAnonymousTypes | RazorNewLinePlacement.BeforeOpenBraceInObjectCollectionArrayInitializers | RazorNewLinePlacement.BeforeOpenBraceInProperties | RazorNewLinePlacement.BeforeOpenBraceInMethods | RazorNewLinePlacement.BeforeOpenBraceInAccessors | RazorNewLinePlacement.BeforeOpenBraceInAnonymousMethods | RazorNewLinePlacement.BeforeOpenBraceInLambdaExpressionBody | RazorNewLinePlacement.BeforeOpenBraceInControlBlocks | RazorNewLinePlacement.BetweenQueryExpressionClauses,
                WrappingKeepStatementsOnSingleLine = false,
                WrappingPreserveSingleLine = true,
            });
    }

    [FormattingTestFact]
    public async Task CSharpSyntaxFormattingOptions_WithoutBeforeMembersInAnonymousTypes_MultiLine_DontPreserve()
    {
        await RunFormattingTestAsync(
            input: """
                @code
                {
                private bool IconMenuActive { get; set; } = false;
                protected void ToggleIconMenu(bool iconMenuActive)
                {
                IconMenuActive = iconMenuActive;
                }
                }
                """,
            expected: """
                @code
                {
                    private bool IconMenuActive { get; set; } = false;
                    protected void ToggleIconMenu(bool iconMenuActive)
                    {
                        IconMenuActive = iconMenuActive;
                    }
                }
                """,
            csharpSyntaxFormattingOptions: RazorCSharpSyntaxFormattingOptions.Default with
            {
                NewLines = RazorNewLinePlacement.BeforeMembersInObjectInitializers | RazorNewLinePlacement.BeforeElse | RazorNewLinePlacement.BeforeCatch | RazorNewLinePlacement.BeforeFinally | RazorNewLinePlacement.BeforeOpenBraceInTypes | RazorNewLinePlacement.BeforeOpenBraceInAnonymousTypes | RazorNewLinePlacement.BeforeOpenBraceInObjectCollectionArrayInitializers | RazorNewLinePlacement.BeforeOpenBraceInProperties | RazorNewLinePlacement.BeforeOpenBraceInMethods | RazorNewLinePlacement.BeforeOpenBraceInAccessors | RazorNewLinePlacement.BeforeOpenBraceInAnonymousMethods | RazorNewLinePlacement.BeforeOpenBraceInLambdaExpressionBody | RazorNewLinePlacement.BeforeOpenBraceInControlBlocks | RazorNewLinePlacement.BetweenQueryExpressionClauses,
                WrappingKeepStatementsOnSingleLine = false,
                WrappingPreserveSingleLine = false,
            });
    }

    [FormattingTestFact]
    public async Task CSharpSyntaxFormattingOptions_WithoutBeforeElse_SingleLine_PreserveSingle()
    {
        await RunFormattingTestAsync(
            input: """
                @code
                {
                private bool IconMenuActive { get; set; } = false;
                protected void ToggleIconMenu(bool iconMenuActive)
                {
                IconMenuActive = iconMenuActive;
                }
                }
                """,
            expected: """
                @code
                {
                    private bool IconMenuActive { get; set; } = false;
                    protected void ToggleIconMenu(bool iconMenuActive)
                    {
                        IconMenuActive = iconMenuActive;
                    }
                }
                """,
            csharpSyntaxFormattingOptions: RazorCSharpSyntaxFormattingOptions.Default with
            {
                NewLines = RazorNewLinePlacement.BeforeMembersInObjectInitializers | RazorNewLinePlacement.BeforeMembersInAnonymousTypes | RazorNewLinePlacement.BeforeCatch | RazorNewLinePlacement.BeforeFinally | RazorNewLinePlacement.BeforeOpenBraceInTypes | RazorNewLinePlacement.BeforeOpenBraceInAnonymousTypes | RazorNewLinePlacement.BeforeOpenBraceInObjectCollectionArrayInitializers | RazorNewLinePlacement.BeforeOpenBraceInProperties | RazorNewLinePlacement.BeforeOpenBraceInMethods | RazorNewLinePlacement.BeforeOpenBraceInAccessors | RazorNewLinePlacement.BeforeOpenBraceInAnonymousMethods | RazorNewLinePlacement.BeforeOpenBraceInLambdaExpressionBody | RazorNewLinePlacement.BeforeOpenBraceInControlBlocks | RazorNewLinePlacement.BetweenQueryExpressionClauses,
                WrappingKeepStatementsOnSingleLine = true,
                WrappingPreserveSingleLine = true,
            });
    }

    [FormattingTestFact]
    public async Task CSharpSyntaxFormattingOptions_WithoutBeforeElse_SingleLine_DontPreserve()
    {
        await RunFormattingTestAsync(
            input: """
                @code
                {
                private bool IconMenuActive { get; set; } = false;
                protected void ToggleIconMenu(bool iconMenuActive)
                {
                IconMenuActive = iconMenuActive;
                }
                }
                """,
            expected: """
                @code
                {
                    private bool IconMenuActive { get; set; } = false;
                    protected void ToggleIconMenu(bool iconMenuActive)
                    {
                        IconMenuActive = iconMenuActive;
                    }
                }
                """,
            csharpSyntaxFormattingOptions: RazorCSharpSyntaxFormattingOptions.Default with
            {
                NewLines = RazorNewLinePlacement.BeforeMembersInObjectInitializers | RazorNewLinePlacement.BeforeMembersInAnonymousTypes | RazorNewLinePlacement.BeforeCatch | RazorNewLinePlacement.BeforeFinally | RazorNewLinePlacement.BeforeOpenBraceInTypes | RazorNewLinePlacement.BeforeOpenBraceInAnonymousTypes | RazorNewLinePlacement.BeforeOpenBraceInObjectCollectionArrayInitializers | RazorNewLinePlacement.BeforeOpenBraceInProperties | RazorNewLinePlacement.BeforeOpenBraceInMethods | RazorNewLinePlacement.BeforeOpenBraceInAccessors | RazorNewLinePlacement.BeforeOpenBraceInAnonymousMethods | RazorNewLinePlacement.BeforeOpenBraceInLambdaExpressionBody | RazorNewLinePlacement.BeforeOpenBraceInControlBlocks | RazorNewLinePlacement.BetweenQueryExpressionClauses,
                WrappingKeepStatementsOnSingleLine = true,
                WrappingPreserveSingleLine = false,
            });
    }

    [FormattingTestFact]
    public async Task CSharpSyntaxFormattingOptions_WithoutBeforeElse_MultiLine_PreserveSingle()
    {
        await RunFormattingTestAsync(
            input: """
                @code
                {
                private bool IconMenuActive { get; set; } = false;
                protected void ToggleIconMenu(bool iconMenuActive)
                {
                IconMenuActive = iconMenuActive;
                }
                }
                """,
            expected: """
                @code
                {
                    private bool IconMenuActive { get; set; } = false;
                    protected void ToggleIconMenu(bool iconMenuActive)
                    {
                        IconMenuActive = iconMenuActive;
                    }
                }
                """,
            csharpSyntaxFormattingOptions: RazorCSharpSyntaxFormattingOptions.Default with
            {
                NewLines = RazorNewLinePlacement.BeforeMembersInObjectInitializers | RazorNewLinePlacement.BeforeMembersInAnonymousTypes | RazorNewLinePlacement.BeforeCatch | RazorNewLinePlacement.BeforeFinally | RazorNewLinePlacement.BeforeOpenBraceInTypes | RazorNewLinePlacement.BeforeOpenBraceInAnonymousTypes | RazorNewLinePlacement.BeforeOpenBraceInObjectCollectionArrayInitializers | RazorNewLinePlacement.BeforeOpenBraceInProperties | RazorNewLinePlacement.BeforeOpenBraceInMethods | RazorNewLinePlacement.BeforeOpenBraceInAccessors | RazorNewLinePlacement.BeforeOpenBraceInAnonymousMethods | RazorNewLinePlacement.BeforeOpenBraceInLambdaExpressionBody | RazorNewLinePlacement.BeforeOpenBraceInControlBlocks | RazorNewLinePlacement.BetweenQueryExpressionClauses,
                WrappingKeepStatementsOnSingleLine = false,
                WrappingPreserveSingleLine = true,
            });
    }

    [FormattingTestFact]
    public async Task CSharpSyntaxFormattingOptions_WithoutBeforeElse_MultiLine_DontPreserve()
    {
        await RunFormattingTestAsync(
            input: """
                @code
                {
                private bool IconMenuActive { get; set; } = false;
                protected void ToggleIconMenu(bool iconMenuActive)
                {
                IconMenuActive = iconMenuActive;
                }
                }
                """,
            expected: """
                @code
                {
                    private bool IconMenuActive { get; set; } = false;
                    protected void ToggleIconMenu(bool iconMenuActive)
                    {
                        IconMenuActive = iconMenuActive;
                    }
                }
                """,
            csharpSyntaxFormattingOptions: RazorCSharpSyntaxFormattingOptions.Default with
            {
                NewLines = RazorNewLinePlacement.BeforeMembersInObjectInitializers | RazorNewLinePlacement.BeforeMembersInAnonymousTypes | RazorNewLinePlacement.BeforeCatch | RazorNewLinePlacement.BeforeFinally | RazorNewLinePlacement.BeforeOpenBraceInTypes | RazorNewLinePlacement.BeforeOpenBraceInAnonymousTypes | RazorNewLinePlacement.BeforeOpenBraceInObjectCollectionArrayInitializers | RazorNewLinePlacement.BeforeOpenBraceInProperties | RazorNewLinePlacement.BeforeOpenBraceInMethods | RazorNewLinePlacement.BeforeOpenBraceInAccessors | RazorNewLinePlacement.BeforeOpenBraceInAnonymousMethods | RazorNewLinePlacement.BeforeOpenBraceInLambdaExpressionBody | RazorNewLinePlacement.BeforeOpenBraceInControlBlocks | RazorNewLinePlacement.BetweenQueryExpressionClauses,
                WrappingKeepStatementsOnSingleLine = false,
                WrappingPreserveSingleLine = false,
            });
    }

    [FormattingTestFact]
    public async Task CSharpSyntaxFormattingOptions_WithoutBeforeCatch_SingleLine_PreserveSingle()
    {
        await RunFormattingTestAsync(
            input: """
                @code
                {
                private bool IconMenuActive { get; set; } = false;
                protected void ToggleIconMenu(bool iconMenuActive)
                {
                IconMenuActive = iconMenuActive;
                }
                }
                """,
            expected: """
                @code
                {
                    private bool IconMenuActive { get; set; } = false;
                    protected void ToggleIconMenu(bool iconMenuActive)
                    {
                        IconMenuActive = iconMenuActive;
                    }
                }
                """,
            csharpSyntaxFormattingOptions: RazorCSharpSyntaxFormattingOptions.Default with
            {
                NewLines = RazorNewLinePlacement.BeforeMembersInObjectInitializers | RazorNewLinePlacement.BeforeMembersInAnonymousTypes | RazorNewLinePlacement.BeforeElse | RazorNewLinePlacement.BeforeFinally | RazorNewLinePlacement.BeforeOpenBraceInTypes | RazorNewLinePlacement.BeforeOpenBraceInAnonymousTypes | RazorNewLinePlacement.BeforeOpenBraceInObjectCollectionArrayInitializers | RazorNewLinePlacement.BeforeOpenBraceInProperties | RazorNewLinePlacement.BeforeOpenBraceInMethods | RazorNewLinePlacement.BeforeOpenBraceInAccessors | RazorNewLinePlacement.BeforeOpenBraceInAnonymousMethods | RazorNewLinePlacement.BeforeOpenBraceInLambdaExpressionBody | RazorNewLinePlacement.BeforeOpenBraceInControlBlocks | RazorNewLinePlacement.BetweenQueryExpressionClauses,
                WrappingKeepStatementsOnSingleLine = true,
                WrappingPreserveSingleLine = true,
            });
    }

    [FormattingTestFact]
    public async Task CSharpSyntaxFormattingOptions_WithoutBeforeCatch_SingleLine_DontPreserve()
    {
        await RunFormattingTestAsync(
            input: """
                @code
                {
                private bool IconMenuActive { get; set; } = false;
                protected void ToggleIconMenu(bool iconMenuActive)
                {
                IconMenuActive = iconMenuActive;
                }
                }
                """,
            expected: """
                @code
                {
                    private bool IconMenuActive { get; set; } = false;
                    protected void ToggleIconMenu(bool iconMenuActive)
                    {
                        IconMenuActive = iconMenuActive;
                    }
                }
                """,
            csharpSyntaxFormattingOptions: RazorCSharpSyntaxFormattingOptions.Default with
            {
                NewLines = RazorNewLinePlacement.BeforeMembersInObjectInitializers | RazorNewLinePlacement.BeforeMembersInAnonymousTypes | RazorNewLinePlacement.BeforeElse | RazorNewLinePlacement.BeforeFinally | RazorNewLinePlacement.BeforeOpenBraceInTypes | RazorNewLinePlacement.BeforeOpenBraceInAnonymousTypes | RazorNewLinePlacement.BeforeOpenBraceInObjectCollectionArrayInitializers | RazorNewLinePlacement.BeforeOpenBraceInProperties | RazorNewLinePlacement.BeforeOpenBraceInMethods | RazorNewLinePlacement.BeforeOpenBraceInAccessors | RazorNewLinePlacement.BeforeOpenBraceInAnonymousMethods | RazorNewLinePlacement.BeforeOpenBraceInLambdaExpressionBody | RazorNewLinePlacement.BeforeOpenBraceInControlBlocks | RazorNewLinePlacement.BetweenQueryExpressionClauses,
                WrappingKeepStatementsOnSingleLine = true,
                WrappingPreserveSingleLine = false,
            });
    }

    [FormattingTestFact]
    public async Task CSharpSyntaxFormattingOptions_WithoutBeforeCatch_MultiLine_PreserveSingle()
    {
        await RunFormattingTestAsync(
            input: """
                @code
                {
                private bool IconMenuActive { get; set; } = false;
                protected void ToggleIconMenu(bool iconMenuActive)
                {
                IconMenuActive = iconMenuActive;
                }
                }
                """,
            expected: """
                @code
                {
                    private bool IconMenuActive { get; set; } = false;
                    protected void ToggleIconMenu(bool iconMenuActive)
                    {
                        IconMenuActive = iconMenuActive;
                    }
                }
                """,
            csharpSyntaxFormattingOptions: RazorCSharpSyntaxFormattingOptions.Default with
            {
                NewLines = RazorNewLinePlacement.BeforeMembersInObjectInitializers | RazorNewLinePlacement.BeforeMembersInAnonymousTypes | RazorNewLinePlacement.BeforeElse | RazorNewLinePlacement.BeforeFinally | RazorNewLinePlacement.BeforeOpenBraceInTypes | RazorNewLinePlacement.BeforeOpenBraceInAnonymousTypes | RazorNewLinePlacement.BeforeOpenBraceInObjectCollectionArrayInitializers | RazorNewLinePlacement.BeforeOpenBraceInProperties | RazorNewLinePlacement.BeforeOpenBraceInMethods | RazorNewLinePlacement.BeforeOpenBraceInAccessors | RazorNewLinePlacement.BeforeOpenBraceInAnonymousMethods | RazorNewLinePlacement.BeforeOpenBraceInLambdaExpressionBody | RazorNewLinePlacement.BeforeOpenBraceInControlBlocks | RazorNewLinePlacement.BetweenQueryExpressionClauses,
                WrappingKeepStatementsOnSingleLine = false,
                WrappingPreserveSingleLine = true,
            });
    }

    [FormattingTestFact]
    public async Task CSharpSyntaxFormattingOptions_WithoutBeforeCatch_MultiLine_DontPreserve()
    {
        await RunFormattingTestAsync(
            input: """
                @code
                {
                private bool IconMenuActive { get; set; } = false;
                protected void ToggleIconMenu(bool iconMenuActive)
                {
                IconMenuActive = iconMenuActive;
                }
                }
                """,
            expected: """
                @code
                {
                    private bool IconMenuActive { get; set; } = false;
                    protected void ToggleIconMenu(bool iconMenuActive)
                    {
                        IconMenuActive = iconMenuActive;
                    }
                }
                """,
            csharpSyntaxFormattingOptions: RazorCSharpSyntaxFormattingOptions.Default with
            {
                NewLines = RazorNewLinePlacement.BeforeMembersInObjectInitializers | RazorNewLinePlacement.BeforeMembersInAnonymousTypes | RazorNewLinePlacement.BeforeElse | RazorNewLinePlacement.BeforeFinally | RazorNewLinePlacement.BeforeOpenBraceInTypes | RazorNewLinePlacement.BeforeOpenBraceInAnonymousTypes | RazorNewLinePlacement.BeforeOpenBraceInObjectCollectionArrayInitializers | RazorNewLinePlacement.BeforeOpenBraceInProperties | RazorNewLinePlacement.BeforeOpenBraceInMethods | RazorNewLinePlacement.BeforeOpenBraceInAccessors | RazorNewLinePlacement.BeforeOpenBraceInAnonymousMethods | RazorNewLinePlacement.BeforeOpenBraceInLambdaExpressionBody | RazorNewLinePlacement.BeforeOpenBraceInControlBlocks | RazorNewLinePlacement.BetweenQueryExpressionClauses,
                WrappingKeepStatementsOnSingleLine = false,
                WrappingPreserveSingleLine = false,
            });
    }

    [FormattingTestFact]
    public async Task CSharpSyntaxFormattingOptions_WithoutBeforeFinally_SingleLine_PreserveSingle()
    {
        await RunFormattingTestAsync(
            input: """
                @code
                {
                private bool IconMenuActive { get; set; } = false;
                protected void ToggleIconMenu(bool iconMenuActive)
                {
                IconMenuActive = iconMenuActive;
                }
                }
                """,
            expected: """
                @code
                {
                    private bool IconMenuActive { get; set; } = false;
                    protected void ToggleIconMenu(bool iconMenuActive)
                    {
                        IconMenuActive = iconMenuActive;
                    }
                }
                """,
            csharpSyntaxFormattingOptions: RazorCSharpSyntaxFormattingOptions.Default with
            {
                NewLines = RazorNewLinePlacement.BeforeMembersInObjectInitializers | RazorNewLinePlacement.BeforeMembersInAnonymousTypes | RazorNewLinePlacement.BeforeElse | RazorNewLinePlacement.BeforeCatch | RazorNewLinePlacement.BeforeOpenBraceInTypes | RazorNewLinePlacement.BeforeOpenBraceInAnonymousTypes | RazorNewLinePlacement.BeforeOpenBraceInObjectCollectionArrayInitializers | RazorNewLinePlacement.BeforeOpenBraceInProperties | RazorNewLinePlacement.BeforeOpenBraceInMethods | RazorNewLinePlacement.BeforeOpenBraceInAccessors | RazorNewLinePlacement.BeforeOpenBraceInAnonymousMethods | RazorNewLinePlacement.BeforeOpenBraceInLambdaExpressionBody | RazorNewLinePlacement.BeforeOpenBraceInControlBlocks | RazorNewLinePlacement.BetweenQueryExpressionClauses,
                WrappingKeepStatementsOnSingleLine = true,
                WrappingPreserveSingleLine = true,
            });
    }

    [FormattingTestFact]
    public async Task CSharpSyntaxFormattingOptions_WithoutBeforeFinally_SingleLine_DontPreserve()
    {
        await RunFormattingTestAsync(
            input: """
                @code
                {
                private bool IconMenuActive { get; set; } = false;
                protected void ToggleIconMenu(bool iconMenuActive)
                {
                IconMenuActive = iconMenuActive;
                }
                }
                """,
            expected: """
                @code
                {
                    private bool IconMenuActive { get; set; } = false;
                    protected void ToggleIconMenu(bool iconMenuActive)
                    {
                        IconMenuActive = iconMenuActive;
                    }
                }
                """,
            csharpSyntaxFormattingOptions: RazorCSharpSyntaxFormattingOptions.Default with
            {
                NewLines = RazorNewLinePlacement.BeforeMembersInObjectInitializers | RazorNewLinePlacement.BeforeMembersInAnonymousTypes | RazorNewLinePlacement.BeforeElse | RazorNewLinePlacement.BeforeCatch | RazorNewLinePlacement.BeforeOpenBraceInTypes | RazorNewLinePlacement.BeforeOpenBraceInAnonymousTypes | RazorNewLinePlacement.BeforeOpenBraceInObjectCollectionArrayInitializers | RazorNewLinePlacement.BeforeOpenBraceInProperties | RazorNewLinePlacement.BeforeOpenBraceInMethods | RazorNewLinePlacement.BeforeOpenBraceInAccessors | RazorNewLinePlacement.BeforeOpenBraceInAnonymousMethods | RazorNewLinePlacement.BeforeOpenBraceInLambdaExpressionBody | RazorNewLinePlacement.BeforeOpenBraceInControlBlocks | RazorNewLinePlacement.BetweenQueryExpressionClauses,
                WrappingKeepStatementsOnSingleLine = true,
                WrappingPreserveSingleLine = false,
            });
    }

    [FormattingTestFact]
    public async Task CSharpSyntaxFormattingOptions_WithoutBeforeFinally_MultiLine_PreserveSingle()
    {
        await RunFormattingTestAsync(
            input: """
                @code
                {
                private bool IconMenuActive { get; set; } = false;
                protected void ToggleIconMenu(bool iconMenuActive)
                {
                IconMenuActive = iconMenuActive;
                }
                }
                """,
            expected: """
                @code
                {
                    private bool IconMenuActive { get; set; } = false;
                    protected void ToggleIconMenu(bool iconMenuActive)
                    {
                        IconMenuActive = iconMenuActive;
                    }
                }
                """,
            csharpSyntaxFormattingOptions: RazorCSharpSyntaxFormattingOptions.Default with
            {
                NewLines = RazorNewLinePlacement.BeforeMembersInObjectInitializers | RazorNewLinePlacement.BeforeMembersInAnonymousTypes | RazorNewLinePlacement.BeforeElse | RazorNewLinePlacement.BeforeCatch | RazorNewLinePlacement.BeforeOpenBraceInTypes | RazorNewLinePlacement.BeforeOpenBraceInAnonymousTypes | RazorNewLinePlacement.BeforeOpenBraceInObjectCollectionArrayInitializers | RazorNewLinePlacement.BeforeOpenBraceInProperties | RazorNewLinePlacement.BeforeOpenBraceInMethods | RazorNewLinePlacement.BeforeOpenBraceInAccessors | RazorNewLinePlacement.BeforeOpenBraceInAnonymousMethods | RazorNewLinePlacement.BeforeOpenBraceInLambdaExpressionBody | RazorNewLinePlacement.BeforeOpenBraceInControlBlocks | RazorNewLinePlacement.BetweenQueryExpressionClauses,
                WrappingKeepStatementsOnSingleLine = false,
                WrappingPreserveSingleLine = true,
            });
    }

    [FormattingTestFact]
    public async Task CSharpSyntaxFormattingOptions_WithoutBeforeFinally_MultiLine_DontPreserve()
    {
        await RunFormattingTestAsync(
            input: """
                @code
                {
                private bool IconMenuActive { get; set; } = false;
                protected void ToggleIconMenu(bool iconMenuActive)
                {
                IconMenuActive = iconMenuActive;
                }
                }
                """,
            expected: """
                @code
                {
                    private bool IconMenuActive { get; set; } = false;
                    protected void ToggleIconMenu(bool iconMenuActive)
                    {
                        IconMenuActive = iconMenuActive;
                    }
                }
                """,
            csharpSyntaxFormattingOptions: RazorCSharpSyntaxFormattingOptions.Default with
            {
                NewLines = RazorNewLinePlacement.BeforeMembersInObjectInitializers | RazorNewLinePlacement.BeforeMembersInAnonymousTypes | RazorNewLinePlacement.BeforeElse | RazorNewLinePlacement.BeforeCatch | RazorNewLinePlacement.BeforeOpenBraceInTypes | RazorNewLinePlacement.BeforeOpenBraceInAnonymousTypes | RazorNewLinePlacement.BeforeOpenBraceInObjectCollectionArrayInitializers | RazorNewLinePlacement.BeforeOpenBraceInProperties | RazorNewLinePlacement.BeforeOpenBraceInMethods | RazorNewLinePlacement.BeforeOpenBraceInAccessors | RazorNewLinePlacement.BeforeOpenBraceInAnonymousMethods | RazorNewLinePlacement.BeforeOpenBraceInLambdaExpressionBody | RazorNewLinePlacement.BeforeOpenBraceInControlBlocks | RazorNewLinePlacement.BetweenQueryExpressionClauses,
                WrappingKeepStatementsOnSingleLine = false,
                WrappingPreserveSingleLine = false,
            });
    }

    [FormattingTestFact]
    public async Task CSharpSyntaxFormattingOptions_WithoutBeforeOpenBraceInTypes_SingleLine_PreserveSingle()
    {
        await RunFormattingTestAsync(
            input: """
                @code
                {
                private bool IconMenuActive { get; set; } = false;
                protected void ToggleIconMenu(bool iconMenuActive)
                {
                IconMenuActive = iconMenuActive;
                }
                }
                """,
            expected: """
                @code
                {
                    private bool IconMenuActive { get; set; } = false;
                    protected void ToggleIconMenu(bool iconMenuActive)
                    {
                        IconMenuActive = iconMenuActive;
                    }
                }
                """,
            csharpSyntaxFormattingOptions: RazorCSharpSyntaxFormattingOptions.Default with
            {
                NewLines = RazorNewLinePlacement.BeforeMembersInObjectInitializers | RazorNewLinePlacement.BeforeMembersInAnonymousTypes | RazorNewLinePlacement.BeforeElse | RazorNewLinePlacement.BeforeCatch | RazorNewLinePlacement.BeforeFinally | RazorNewLinePlacement.BeforeOpenBraceInAnonymousTypes | RazorNewLinePlacement.BeforeOpenBraceInObjectCollectionArrayInitializers | RazorNewLinePlacement.BeforeOpenBraceInProperties | RazorNewLinePlacement.BeforeOpenBraceInMethods | RazorNewLinePlacement.BeforeOpenBraceInAccessors | RazorNewLinePlacement.BeforeOpenBraceInAnonymousMethods | RazorNewLinePlacement.BeforeOpenBraceInLambdaExpressionBody | RazorNewLinePlacement.BeforeOpenBraceInControlBlocks | RazorNewLinePlacement.BetweenQueryExpressionClauses,
                WrappingKeepStatementsOnSingleLine = true,
                WrappingPreserveSingleLine = true,
            });
    }

    [FormattingTestFact]
    public async Task CSharpSyntaxFormattingOptions_WithoutBeforeOpenBraceInTypes_SingleLine_DontPreserve()
    {
        await RunFormattingTestAsync(
            input: """
                @code
                {
                private bool IconMenuActive { get; set; } = false;
                protected void ToggleIconMenu(bool iconMenuActive)
                {
                IconMenuActive = iconMenuActive;
                }
                }
                """,
            expected: """
                @code
                {
                    private bool IconMenuActive { get; set; } = false;
                    protected void ToggleIconMenu(bool iconMenuActive)
                    {
                        IconMenuActive = iconMenuActive;
                    }
                }
                """,
            csharpSyntaxFormattingOptions: RazorCSharpSyntaxFormattingOptions.Default with
            {
                NewLines = RazorNewLinePlacement.BeforeMembersInObjectInitializers | RazorNewLinePlacement.BeforeMembersInAnonymousTypes | RazorNewLinePlacement.BeforeElse | RazorNewLinePlacement.BeforeCatch | RazorNewLinePlacement.BeforeFinally | RazorNewLinePlacement.BeforeOpenBraceInAnonymousTypes | RazorNewLinePlacement.BeforeOpenBraceInObjectCollectionArrayInitializers | RazorNewLinePlacement.BeforeOpenBraceInProperties | RazorNewLinePlacement.BeforeOpenBraceInMethods | RazorNewLinePlacement.BeforeOpenBraceInAccessors | RazorNewLinePlacement.BeforeOpenBraceInAnonymousMethods | RazorNewLinePlacement.BeforeOpenBraceInLambdaExpressionBody | RazorNewLinePlacement.BeforeOpenBraceInControlBlocks | RazorNewLinePlacement.BetweenQueryExpressionClauses,
                WrappingKeepStatementsOnSingleLine = true,
                WrappingPreserveSingleLine = false,
            });
    }

    [FormattingTestFact]
    public async Task CSharpSyntaxFormattingOptions_WithoutBeforeOpenBraceInTypes_MultiLine_PreserveSingle()
    {
        await RunFormattingTestAsync(
            input: """
                @code
                {
                private bool IconMenuActive { get; set; } = false;
                protected void ToggleIconMenu(bool iconMenuActive)
                {
                IconMenuActive = iconMenuActive;
                }
                }
                """,
            expected: """
                @code
                {
                    private bool IconMenuActive { get; set; } = false;
                    protected void ToggleIconMenu(bool iconMenuActive)
                    {
                        IconMenuActive = iconMenuActive;
                    }
                }
                """,
            csharpSyntaxFormattingOptions: RazorCSharpSyntaxFormattingOptions.Default with
            {
                NewLines = RazorNewLinePlacement.BeforeMembersInObjectInitializers | RazorNewLinePlacement.BeforeMembersInAnonymousTypes | RazorNewLinePlacement.BeforeElse | RazorNewLinePlacement.BeforeCatch | RazorNewLinePlacement.BeforeFinally | RazorNewLinePlacement.BeforeOpenBraceInAnonymousTypes | RazorNewLinePlacement.BeforeOpenBraceInObjectCollectionArrayInitializers | RazorNewLinePlacement.BeforeOpenBraceInProperties | RazorNewLinePlacement.BeforeOpenBraceInMethods | RazorNewLinePlacement.BeforeOpenBraceInAccessors | RazorNewLinePlacement.BeforeOpenBraceInAnonymousMethods | RazorNewLinePlacement.BeforeOpenBraceInLambdaExpressionBody | RazorNewLinePlacement.BeforeOpenBraceInControlBlocks | RazorNewLinePlacement.BetweenQueryExpressionClauses,
                WrappingKeepStatementsOnSingleLine = false,
                WrappingPreserveSingleLine = true,
            });
    }

    [FormattingTestFact]
    public async Task CSharpSyntaxFormattingOptions_WithoutBeforeOpenBraceInTypes_MultiLine_DontPreserve()
    {
        await RunFormattingTestAsync(
            input: """
                @code
                {
                private bool IconMenuActive { get; set; } = false;
                protected void ToggleIconMenu(bool iconMenuActive)
                {
                IconMenuActive = iconMenuActive;
                }
                }
                """,
            expected: """
                @code
                {
                    private bool IconMenuActive { get; set; } = false;
                    protected void ToggleIconMenu(bool iconMenuActive)
                    {
                        IconMenuActive = iconMenuActive;
                    }
                }
                """,
            csharpSyntaxFormattingOptions: RazorCSharpSyntaxFormattingOptions.Default with
            {
                NewLines = RazorNewLinePlacement.BeforeMembersInObjectInitializers | RazorNewLinePlacement.BeforeMembersInAnonymousTypes | RazorNewLinePlacement.BeforeElse | RazorNewLinePlacement.BeforeCatch | RazorNewLinePlacement.BeforeFinally | RazorNewLinePlacement.BeforeOpenBraceInAnonymousTypes | RazorNewLinePlacement.BeforeOpenBraceInObjectCollectionArrayInitializers | RazorNewLinePlacement.BeforeOpenBraceInProperties | RazorNewLinePlacement.BeforeOpenBraceInMethods | RazorNewLinePlacement.BeforeOpenBraceInAccessors | RazorNewLinePlacement.BeforeOpenBraceInAnonymousMethods | RazorNewLinePlacement.BeforeOpenBraceInLambdaExpressionBody | RazorNewLinePlacement.BeforeOpenBraceInControlBlocks | RazorNewLinePlacement.BetweenQueryExpressionClauses,
                WrappingKeepStatementsOnSingleLine = false,
                WrappingPreserveSingleLine = false,
            });
    }

    [FormattingTestFact]
    public async Task CSharpSyntaxFormattingOptions_WithoutBeforeOpenBraceInAnonymousTypes_SingleLine_PreserveSingle()
    {
        await RunFormattingTestAsync(
            input: """
                @code
                {
                private bool IconMenuActive { get; set; } = false;
                protected void ToggleIconMenu(bool iconMenuActive)
                {
                IconMenuActive = iconMenuActive;
                }
                }
                """,
            expected: """
                @code
                {
                    private bool IconMenuActive { get; set; } = false;
                    protected void ToggleIconMenu(bool iconMenuActive)
                    {
                        IconMenuActive = iconMenuActive;
                    }
                }
                """,
            csharpSyntaxFormattingOptions: RazorCSharpSyntaxFormattingOptions.Default with
            {
                NewLines = RazorNewLinePlacement.BeforeMembersInObjectInitializers | RazorNewLinePlacement.BeforeMembersInAnonymousTypes | RazorNewLinePlacement.BeforeElse | RazorNewLinePlacement.BeforeCatch | RazorNewLinePlacement.BeforeFinally | RazorNewLinePlacement.BeforeOpenBraceInTypes | RazorNewLinePlacement.BeforeOpenBraceInObjectCollectionArrayInitializers | RazorNewLinePlacement.BeforeOpenBraceInProperties | RazorNewLinePlacement.BeforeOpenBraceInMethods | RazorNewLinePlacement.BeforeOpenBraceInAccessors | RazorNewLinePlacement.BeforeOpenBraceInAnonymousMethods | RazorNewLinePlacement.BeforeOpenBraceInLambdaExpressionBody | RazorNewLinePlacement.BeforeOpenBraceInControlBlocks | RazorNewLinePlacement.BetweenQueryExpressionClauses,
                WrappingKeepStatementsOnSingleLine = true,
                WrappingPreserveSingleLine = true,
            });
    }

    [FormattingTestFact]
    public async Task CSharpSyntaxFormattingOptions_WithoutBeforeOpenBraceInAnonymousTypes_SingleLine_DontPreserve()
    {
        await RunFormattingTestAsync(
            input: """
                @code
                {
                private bool IconMenuActive { get; set; } = false;
                protected void ToggleIconMenu(bool iconMenuActive)
                {
                IconMenuActive = iconMenuActive;
                }
                }
                """,
            expected: """
                @code
                {
                    private bool IconMenuActive { get; set; } = false;
                    protected void ToggleIconMenu(bool iconMenuActive)
                    {
                        IconMenuActive = iconMenuActive;
                    }
                }
                """,
            csharpSyntaxFormattingOptions: RazorCSharpSyntaxFormattingOptions.Default with
            {
                NewLines = RazorNewLinePlacement.BeforeMembersInObjectInitializers | RazorNewLinePlacement.BeforeMembersInAnonymousTypes | RazorNewLinePlacement.BeforeElse | RazorNewLinePlacement.BeforeCatch | RazorNewLinePlacement.BeforeFinally | RazorNewLinePlacement.BeforeOpenBraceInTypes | RazorNewLinePlacement.BeforeOpenBraceInObjectCollectionArrayInitializers | RazorNewLinePlacement.BeforeOpenBraceInProperties | RazorNewLinePlacement.BeforeOpenBraceInMethods | RazorNewLinePlacement.BeforeOpenBraceInAccessors | RazorNewLinePlacement.BeforeOpenBraceInAnonymousMethods | RazorNewLinePlacement.BeforeOpenBraceInLambdaExpressionBody | RazorNewLinePlacement.BeforeOpenBraceInControlBlocks | RazorNewLinePlacement.BetweenQueryExpressionClauses,
                WrappingKeepStatementsOnSingleLine = true,
                WrappingPreserveSingleLine = false,
            });
    }

    [FormattingTestFact]
    public async Task CSharpSyntaxFormattingOptions_WithoutBeforeOpenBraceInAnonymousTypes_MultiLine_PreserveSingle()
    {
        await RunFormattingTestAsync(
            input: """
                @code
                {
                private bool IconMenuActive { get; set; } = false;
                protected void ToggleIconMenu(bool iconMenuActive)
                {
                IconMenuActive = iconMenuActive;
                }
                }
                """,
            expected: """
                @code
                {
                    private bool IconMenuActive { get; set; } = false;
                    protected void ToggleIconMenu(bool iconMenuActive)
                    {
                        IconMenuActive = iconMenuActive;
                    }
                }
                """,
            csharpSyntaxFormattingOptions: RazorCSharpSyntaxFormattingOptions.Default with
            {
                NewLines = RazorNewLinePlacement.BeforeMembersInObjectInitializers | RazorNewLinePlacement.BeforeMembersInAnonymousTypes | RazorNewLinePlacement.BeforeElse | RazorNewLinePlacement.BeforeCatch | RazorNewLinePlacement.BeforeFinally | RazorNewLinePlacement.BeforeOpenBraceInTypes | RazorNewLinePlacement.BeforeOpenBraceInObjectCollectionArrayInitializers | RazorNewLinePlacement.BeforeOpenBraceInProperties | RazorNewLinePlacement.BeforeOpenBraceInMethods | RazorNewLinePlacement.BeforeOpenBraceInAccessors | RazorNewLinePlacement.BeforeOpenBraceInAnonymousMethods | RazorNewLinePlacement.BeforeOpenBraceInLambdaExpressionBody | RazorNewLinePlacement.BeforeOpenBraceInControlBlocks | RazorNewLinePlacement.BetweenQueryExpressionClauses,
                WrappingKeepStatementsOnSingleLine = false,
                WrappingPreserveSingleLine = true,
            });
    }

    [FormattingTestFact]
    public async Task CSharpSyntaxFormattingOptions_WithoutBeforeOpenBraceInAnonymousTypes_MultiLine_DontPreserve()
    {
        await RunFormattingTestAsync(
            input: """
                @code
                {
                private bool IconMenuActive { get; set; } = false;
                protected void ToggleIconMenu(bool iconMenuActive)
                {
                IconMenuActive = iconMenuActive;
                }
                }
                """,
            expected: """
                @code
                {
                    private bool IconMenuActive { get; set; } = false;
                    protected void ToggleIconMenu(bool iconMenuActive)
                    {
                        IconMenuActive = iconMenuActive;
                    }
                }
                """,
            csharpSyntaxFormattingOptions: RazorCSharpSyntaxFormattingOptions.Default with
            {
                NewLines = RazorNewLinePlacement.BeforeMembersInObjectInitializers | RazorNewLinePlacement.BeforeMembersInAnonymousTypes | RazorNewLinePlacement.BeforeElse | RazorNewLinePlacement.BeforeCatch | RazorNewLinePlacement.BeforeFinally | RazorNewLinePlacement.BeforeOpenBraceInTypes | RazorNewLinePlacement.BeforeOpenBraceInObjectCollectionArrayInitializers | RazorNewLinePlacement.BeforeOpenBraceInProperties | RazorNewLinePlacement.BeforeOpenBraceInMethods | RazorNewLinePlacement.BeforeOpenBraceInAccessors | RazorNewLinePlacement.BeforeOpenBraceInAnonymousMethods | RazorNewLinePlacement.BeforeOpenBraceInLambdaExpressionBody | RazorNewLinePlacement.BeforeOpenBraceInControlBlocks | RazorNewLinePlacement.BetweenQueryExpressionClauses,
                WrappingKeepStatementsOnSingleLine = false,
                WrappingPreserveSingleLine = false,
            });
    }

    [FormattingTestFact]
    public async Task CSharpSyntaxFormattingOptions_WithoutBeforeOpenBraceInObjectCollectionArrayInitializers_SingleLine_PreserveSingle()
    {
        await RunFormattingTestAsync(
            input: """
                @code
                {
                private bool IconMenuActive { get; set; } = false;
                protected void ToggleIconMenu(bool iconMenuActive)
                {
                IconMenuActive = iconMenuActive;
                }
                }
                """,
            expected: """
                @code
                {
                    private bool IconMenuActive { get; set; } = false;
                    protected void ToggleIconMenu(bool iconMenuActive)
                    {
                        IconMenuActive = iconMenuActive;
                    }
                }
                """,
            csharpSyntaxFormattingOptions: RazorCSharpSyntaxFormattingOptions.Default with
            {
                NewLines = RazorNewLinePlacement.BeforeMembersInObjectInitializers | RazorNewLinePlacement.BeforeMembersInAnonymousTypes | RazorNewLinePlacement.BeforeElse | RazorNewLinePlacement.BeforeCatch | RazorNewLinePlacement.BeforeFinally | RazorNewLinePlacement.BeforeOpenBraceInTypes | RazorNewLinePlacement.BeforeOpenBraceInAnonymousTypes | RazorNewLinePlacement.BeforeOpenBraceInProperties | RazorNewLinePlacement.BeforeOpenBraceInMethods | RazorNewLinePlacement.BeforeOpenBraceInAccessors | RazorNewLinePlacement.BeforeOpenBraceInAnonymousMethods | RazorNewLinePlacement.BeforeOpenBraceInLambdaExpressionBody | RazorNewLinePlacement.BeforeOpenBraceInControlBlocks | RazorNewLinePlacement.BetweenQueryExpressionClauses,
                WrappingKeepStatementsOnSingleLine = true,
                WrappingPreserveSingleLine = true,
            });
    }

    [FormattingTestFact]
    public async Task CSharpSyntaxFormattingOptions_WithoutBeforeOpenBraceInObjectCollectionArrayInitializers_SingleLine_DontPreserve()
    {
        await RunFormattingTestAsync(
            input: """
                @code
                {
                private bool IconMenuActive { get; set; } = false;
                protected void ToggleIconMenu(bool iconMenuActive)
                {
                IconMenuActive = iconMenuActive;
                }
                }
                """,
            expected: """
                @code
                {
                    private bool IconMenuActive { get; set; } = false;
                    protected void ToggleIconMenu(bool iconMenuActive)
                    {
                        IconMenuActive = iconMenuActive;
                    }
                }
                """,
            csharpSyntaxFormattingOptions: RazorCSharpSyntaxFormattingOptions.Default with
            {
                NewLines = RazorNewLinePlacement.BeforeMembersInObjectInitializers | RazorNewLinePlacement.BeforeMembersInAnonymousTypes | RazorNewLinePlacement.BeforeElse | RazorNewLinePlacement.BeforeCatch | RazorNewLinePlacement.BeforeFinally | RazorNewLinePlacement.BeforeOpenBraceInTypes | RazorNewLinePlacement.BeforeOpenBraceInAnonymousTypes | RazorNewLinePlacement.BeforeOpenBraceInProperties | RazorNewLinePlacement.BeforeOpenBraceInMethods | RazorNewLinePlacement.BeforeOpenBraceInAccessors | RazorNewLinePlacement.BeforeOpenBraceInAnonymousMethods | RazorNewLinePlacement.BeforeOpenBraceInLambdaExpressionBody | RazorNewLinePlacement.BeforeOpenBraceInControlBlocks | RazorNewLinePlacement.BetweenQueryExpressionClauses,
                WrappingKeepStatementsOnSingleLine = true,
                WrappingPreserveSingleLine = false,
            });
    }

    [FormattingTestFact]
    public async Task CSharpSyntaxFormattingOptions_WithoutBeforeOpenBraceInObjectCollectionArrayInitializers_MultiLine_PreserveSingle()
    {
        await RunFormattingTestAsync(
            input: """
                @code
                {
                private bool IconMenuActive { get; set; } = false;
                protected void ToggleIconMenu(bool iconMenuActive)
                {
                IconMenuActive = iconMenuActive;
                }
                }
                """,
            expected: """
                @code
                {
                    private bool IconMenuActive { get; set; } = false;
                    protected void ToggleIconMenu(bool iconMenuActive)
                    {
                        IconMenuActive = iconMenuActive;
                    }
                }
                """,
            csharpSyntaxFormattingOptions: RazorCSharpSyntaxFormattingOptions.Default with
            {
                NewLines = RazorNewLinePlacement.BeforeMembersInObjectInitializers | RazorNewLinePlacement.BeforeMembersInAnonymousTypes | RazorNewLinePlacement.BeforeElse | RazorNewLinePlacement.BeforeCatch | RazorNewLinePlacement.BeforeFinally | RazorNewLinePlacement.BeforeOpenBraceInTypes | RazorNewLinePlacement.BeforeOpenBraceInAnonymousTypes | RazorNewLinePlacement.BeforeOpenBraceInProperties | RazorNewLinePlacement.BeforeOpenBraceInMethods | RazorNewLinePlacement.BeforeOpenBraceInAccessors | RazorNewLinePlacement.BeforeOpenBraceInAnonymousMethods | RazorNewLinePlacement.BeforeOpenBraceInLambdaExpressionBody | RazorNewLinePlacement.BeforeOpenBraceInControlBlocks | RazorNewLinePlacement.BetweenQueryExpressionClauses,
                WrappingKeepStatementsOnSingleLine = false,
                WrappingPreserveSingleLine = true,
            });
    }

    [FormattingTestFact]
    public async Task CSharpSyntaxFormattingOptions_WithoutBeforeOpenBraceInObjectCollectionArrayInitializers_MultiLine_DontPreserve()
    {
        await RunFormattingTestAsync(
            input: """
                @code
                {
                private bool IconMenuActive { get; set; } = false;
                protected void ToggleIconMenu(bool iconMenuActive)
                {
                IconMenuActive = iconMenuActive;
                }
                }
                """,
            expected: """
                @code
                {
                    private bool IconMenuActive { get; set; } = false;
                    protected void ToggleIconMenu(bool iconMenuActive)
                    {
                        IconMenuActive = iconMenuActive;
                    }
                }
                """,
            csharpSyntaxFormattingOptions: RazorCSharpSyntaxFormattingOptions.Default with
            {
                NewLines = RazorNewLinePlacement.BeforeMembersInObjectInitializers | RazorNewLinePlacement.BeforeMembersInAnonymousTypes | RazorNewLinePlacement.BeforeElse | RazorNewLinePlacement.BeforeCatch | RazorNewLinePlacement.BeforeFinally | RazorNewLinePlacement.BeforeOpenBraceInTypes | RazorNewLinePlacement.BeforeOpenBraceInAnonymousTypes | RazorNewLinePlacement.BeforeOpenBraceInProperties | RazorNewLinePlacement.BeforeOpenBraceInMethods | RazorNewLinePlacement.BeforeOpenBraceInAccessors | RazorNewLinePlacement.BeforeOpenBraceInAnonymousMethods | RazorNewLinePlacement.BeforeOpenBraceInLambdaExpressionBody | RazorNewLinePlacement.BeforeOpenBraceInControlBlocks | RazorNewLinePlacement.BetweenQueryExpressionClauses,
                WrappingKeepStatementsOnSingleLine = false,
                WrappingPreserveSingleLine = false,
            });
    }

    [FormattingTestFact]
    public async Task CSharpSyntaxFormattingOptions_WithoutBeforeOpenBraceInProperties_SingleLine_PreserveSingle()
    {
        await RunFormattingTestAsync(
            input: """
                @code
                {
                private bool IconMenuActive { get; set; } = false;
                protected void ToggleIconMenu(bool iconMenuActive)
                {
                IconMenuActive = iconMenuActive;
                }
                }
                """,
            expected: """
                @code
                {
                    private bool IconMenuActive { get; set; } = false;
                    protected void ToggleIconMenu(bool iconMenuActive)
                    {
                        IconMenuActive = iconMenuActive;
                    }
                }
                """,
            csharpSyntaxFormattingOptions: RazorCSharpSyntaxFormattingOptions.Default with
            {
                NewLines = RazorNewLinePlacement.BeforeMembersInObjectInitializers | RazorNewLinePlacement.BeforeMembersInAnonymousTypes | RazorNewLinePlacement.BeforeElse | RazorNewLinePlacement.BeforeCatch | RazorNewLinePlacement.BeforeFinally | RazorNewLinePlacement.BeforeOpenBraceInTypes | RazorNewLinePlacement.BeforeOpenBraceInAnonymousTypes | RazorNewLinePlacement.BeforeOpenBraceInObjectCollectionArrayInitializers | RazorNewLinePlacement.BeforeOpenBraceInMethods | RazorNewLinePlacement.BeforeOpenBraceInAccessors | RazorNewLinePlacement.BeforeOpenBraceInAnonymousMethods | RazorNewLinePlacement.BeforeOpenBraceInLambdaExpressionBody | RazorNewLinePlacement.BeforeOpenBraceInControlBlocks | RazorNewLinePlacement.BetweenQueryExpressionClauses,
                WrappingKeepStatementsOnSingleLine = true,
                WrappingPreserveSingleLine = true,
            });
    }

    [FormattingTestFact]
    public async Task CSharpSyntaxFormattingOptions_WithoutBeforeOpenBraceInProperties_SingleLine_DontPreserve()
    {
        await RunFormattingTestAsync(
            input: """
                @code
                {
                private bool IconMenuActive { get; set; } = false;
                protected void ToggleIconMenu(bool iconMenuActive)
                {
                IconMenuActive = iconMenuActive;
                }
                }
                """,
            expected: """
                @code
                {
                    private bool IconMenuActive { get; set; } = false;
                    protected void ToggleIconMenu(bool iconMenuActive)
                    {
                        IconMenuActive = iconMenuActive;
                    }
                }
                """,
            csharpSyntaxFormattingOptions: RazorCSharpSyntaxFormattingOptions.Default with
            {
                NewLines = RazorNewLinePlacement.BeforeMembersInObjectInitializers | RazorNewLinePlacement.BeforeMembersInAnonymousTypes | RazorNewLinePlacement.BeforeElse | RazorNewLinePlacement.BeforeCatch | RazorNewLinePlacement.BeforeFinally | RazorNewLinePlacement.BeforeOpenBraceInTypes | RazorNewLinePlacement.BeforeOpenBraceInAnonymousTypes | RazorNewLinePlacement.BeforeOpenBraceInObjectCollectionArrayInitializers | RazorNewLinePlacement.BeforeOpenBraceInMethods | RazorNewLinePlacement.BeforeOpenBraceInAccessors | RazorNewLinePlacement.BeforeOpenBraceInAnonymousMethods | RazorNewLinePlacement.BeforeOpenBraceInLambdaExpressionBody | RazorNewLinePlacement.BeforeOpenBraceInControlBlocks | RazorNewLinePlacement.BetweenQueryExpressionClauses,
                WrappingKeepStatementsOnSingleLine = true,
                WrappingPreserveSingleLine = false,
            });
    }

    [FormattingTestFact]
    public async Task CSharpSyntaxFormattingOptions_WithoutBeforeOpenBraceInProperties_MultiLine_PreserveSingle()
    {
        await RunFormattingTestAsync(
            input: """
                @code
                {
                private bool IconMenuActive { get; set; } = false;
                protected void ToggleIconMenu(bool iconMenuActive)
                {
                IconMenuActive = iconMenuActive;
                }
                }
                """,
            expected: """
                @code
                {
                    private bool IconMenuActive { get; set; } = false;
                    protected void ToggleIconMenu(bool iconMenuActive)
                    {
                        IconMenuActive = iconMenuActive;
                    }
                }
                """,
            csharpSyntaxFormattingOptions: RazorCSharpSyntaxFormattingOptions.Default with
            {
                NewLines = RazorNewLinePlacement.BeforeMembersInObjectInitializers | RazorNewLinePlacement.BeforeMembersInAnonymousTypes | RazorNewLinePlacement.BeforeElse | RazorNewLinePlacement.BeforeCatch | RazorNewLinePlacement.BeforeFinally | RazorNewLinePlacement.BeforeOpenBraceInTypes | RazorNewLinePlacement.BeforeOpenBraceInAnonymousTypes | RazorNewLinePlacement.BeforeOpenBraceInObjectCollectionArrayInitializers | RazorNewLinePlacement.BeforeOpenBraceInMethods | RazorNewLinePlacement.BeforeOpenBraceInAccessors | RazorNewLinePlacement.BeforeOpenBraceInAnonymousMethods | RazorNewLinePlacement.BeforeOpenBraceInLambdaExpressionBody | RazorNewLinePlacement.BeforeOpenBraceInControlBlocks | RazorNewLinePlacement.BetweenQueryExpressionClauses,
                WrappingKeepStatementsOnSingleLine = false,
                WrappingPreserveSingleLine = true,
            });
    }

    [FormattingTestFact]
    public async Task CSharpSyntaxFormattingOptions_WithoutBeforeOpenBraceInProperties_MultiLine_DontPreserve()
    {
        await RunFormattingTestAsync(
            input: """
                @code
                {
                private bool IconMenuActive { get; set; } = false;
                protected void ToggleIconMenu(bool iconMenuActive)
                {
                IconMenuActive = iconMenuActive;
                }
                }
                """,
            expected: """
                @code
                {
                    private bool IconMenuActive { get; set; } = false;
                    protected void ToggleIconMenu(bool iconMenuActive)
                    {
                        IconMenuActive = iconMenuActive;
                    }
                }
                """,
            csharpSyntaxFormattingOptions: RazorCSharpSyntaxFormattingOptions.Default with
            {
                NewLines = RazorNewLinePlacement.BeforeMembersInObjectInitializers | RazorNewLinePlacement.BeforeMembersInAnonymousTypes | RazorNewLinePlacement.BeforeElse | RazorNewLinePlacement.BeforeCatch | RazorNewLinePlacement.BeforeFinally | RazorNewLinePlacement.BeforeOpenBraceInTypes | RazorNewLinePlacement.BeforeOpenBraceInAnonymousTypes | RazorNewLinePlacement.BeforeOpenBraceInObjectCollectionArrayInitializers | RazorNewLinePlacement.BeforeOpenBraceInMethods | RazorNewLinePlacement.BeforeOpenBraceInAccessors | RazorNewLinePlacement.BeforeOpenBraceInAnonymousMethods | RazorNewLinePlacement.BeforeOpenBraceInLambdaExpressionBody | RazorNewLinePlacement.BeforeOpenBraceInControlBlocks | RazorNewLinePlacement.BetweenQueryExpressionClauses,
                WrappingKeepStatementsOnSingleLine = false,
                WrappingPreserveSingleLine = false,
            });
    }

    [FormattingTestFact]
    public async Task CSharpSyntaxFormattingOptions_WithoutBeforeOpenBraceInMethods_SingleLine_PreserveSingle()
    {
        await RunFormattingTestAsync(
            input: """
                @code
                {
                private bool IconMenuActive { get; set; } = false;
                protected void ToggleIconMenu(bool iconMenuActive)
                {
                IconMenuActive = iconMenuActive;
                }
                }
                """,
            expected: """
                @code
                {
                    private bool IconMenuActive { get; set; } = false;
                    protected void ToggleIconMenu(bool iconMenuActive) {
                        IconMenuActive = iconMenuActive;
                    }
                }
                """,
            csharpSyntaxFormattingOptions: RazorCSharpSyntaxFormattingOptions.Default with
            {
                NewLines = RazorNewLinePlacement.BeforeMembersInObjectInitializers | RazorNewLinePlacement.BeforeMembersInAnonymousTypes | RazorNewLinePlacement.BeforeElse | RazorNewLinePlacement.BeforeCatch | RazorNewLinePlacement.BeforeFinally | RazorNewLinePlacement.BeforeOpenBraceInTypes | RazorNewLinePlacement.BeforeOpenBraceInAnonymousTypes | RazorNewLinePlacement.BeforeOpenBraceInObjectCollectionArrayInitializers | RazorNewLinePlacement.BeforeOpenBraceInProperties | RazorNewLinePlacement.BeforeOpenBraceInAccessors | RazorNewLinePlacement.BeforeOpenBraceInAnonymousMethods | RazorNewLinePlacement.BeforeOpenBraceInLambdaExpressionBody | RazorNewLinePlacement.BeforeOpenBraceInControlBlocks | RazorNewLinePlacement.BetweenQueryExpressionClauses,
                WrappingKeepStatementsOnSingleLine = true,
                WrappingPreserveSingleLine = true,
            });
    }

    [FormattingTestFact]
    public async Task CSharpSyntaxFormattingOptions_WithoutBeforeOpenBraceInMethods_SingleLine_DontPreserve()
    {
        await RunFormattingTestAsync(
            input: """
                @code
                {
                private bool IconMenuActive { get; set; } = false;
                protected void ToggleIconMenu(bool iconMenuActive)
                {
                IconMenuActive = iconMenuActive;
                }
                }
                """,
            expected: """
                @code
                {
                    private bool IconMenuActive { get; set; } = false;
                    protected void ToggleIconMenu(bool iconMenuActive) {
                        IconMenuActive = iconMenuActive;
                    }
                }
                """,
            csharpSyntaxFormattingOptions: RazorCSharpSyntaxFormattingOptions.Default with
            {
                NewLines = RazorNewLinePlacement.BeforeMembersInObjectInitializers | RazorNewLinePlacement.BeforeMembersInAnonymousTypes | RazorNewLinePlacement.BeforeElse | RazorNewLinePlacement.BeforeCatch | RazorNewLinePlacement.BeforeFinally | RazorNewLinePlacement.BeforeOpenBraceInTypes | RazorNewLinePlacement.BeforeOpenBraceInAnonymousTypes | RazorNewLinePlacement.BeforeOpenBraceInObjectCollectionArrayInitializers | RazorNewLinePlacement.BeforeOpenBraceInProperties | RazorNewLinePlacement.BeforeOpenBraceInAccessors | RazorNewLinePlacement.BeforeOpenBraceInAnonymousMethods | RazorNewLinePlacement.BeforeOpenBraceInLambdaExpressionBody | RazorNewLinePlacement.BeforeOpenBraceInControlBlocks | RazorNewLinePlacement.BetweenQueryExpressionClauses,
                WrappingKeepStatementsOnSingleLine = true,
                WrappingPreserveSingleLine = false,
            });
    }

    [FormattingTestFact]
    public async Task CSharpSyntaxFormattingOptions_WithoutBeforeOpenBraceInMethods_MultiLine_PreserveSingle()
    {
        await RunFormattingTestAsync(
            input: """
                @code
                {
                private bool IconMenuActive { get; set; } = false;
                protected void ToggleIconMenu(bool iconMenuActive)
                {
                IconMenuActive = iconMenuActive;
                }
                }
                """,
            expected: """
                @code
                {
                    private bool IconMenuActive { get; set; } = false;
                    protected void ToggleIconMenu(bool iconMenuActive) {
                        IconMenuActive = iconMenuActive;
                    }
                }
                """,
            csharpSyntaxFormattingOptions: RazorCSharpSyntaxFormattingOptions.Default with
            {
                NewLines = RazorNewLinePlacement.BeforeMembersInObjectInitializers | RazorNewLinePlacement.BeforeMembersInAnonymousTypes | RazorNewLinePlacement.BeforeElse | RazorNewLinePlacement.BeforeCatch | RazorNewLinePlacement.BeforeFinally | RazorNewLinePlacement.BeforeOpenBraceInTypes | RazorNewLinePlacement.BeforeOpenBraceInAnonymousTypes | RazorNewLinePlacement.BeforeOpenBraceInObjectCollectionArrayInitializers | RazorNewLinePlacement.BeforeOpenBraceInProperties | RazorNewLinePlacement.BeforeOpenBraceInAccessors | RazorNewLinePlacement.BeforeOpenBraceInAnonymousMethods | RazorNewLinePlacement.BeforeOpenBraceInLambdaExpressionBody | RazorNewLinePlacement.BeforeOpenBraceInControlBlocks | RazorNewLinePlacement.BetweenQueryExpressionClauses,
                WrappingKeepStatementsOnSingleLine = false,
                WrappingPreserveSingleLine = true,
            });
    }

    [FormattingTestFact]
    public async Task CSharpSyntaxFormattingOptions_WithoutBeforeOpenBraceInMethods_MultiLine_DontPreserve()
    {
        await RunFormattingTestAsync(
            input: """
                @code
                {
                private bool IconMenuActive { get; set; } = false;
                protected void ToggleIconMenu(bool iconMenuActive)
                {
                IconMenuActive = iconMenuActive;
                }
                }
                """,
            expected: """
                @code
                {
                    private bool IconMenuActive { get; set; } = false;
                    protected void ToggleIconMenu(bool iconMenuActive) {
                        IconMenuActive = iconMenuActive;
                    }
                }
                """,
            csharpSyntaxFormattingOptions: RazorCSharpSyntaxFormattingOptions.Default with
            {
                NewLines = RazorNewLinePlacement.BeforeMembersInObjectInitializers | RazorNewLinePlacement.BeforeMembersInAnonymousTypes | RazorNewLinePlacement.BeforeElse | RazorNewLinePlacement.BeforeCatch | RazorNewLinePlacement.BeforeFinally | RazorNewLinePlacement.BeforeOpenBraceInTypes | RazorNewLinePlacement.BeforeOpenBraceInAnonymousTypes | RazorNewLinePlacement.BeforeOpenBraceInObjectCollectionArrayInitializers | RazorNewLinePlacement.BeforeOpenBraceInProperties | RazorNewLinePlacement.BeforeOpenBraceInAccessors | RazorNewLinePlacement.BeforeOpenBraceInAnonymousMethods | RazorNewLinePlacement.BeforeOpenBraceInLambdaExpressionBody | RazorNewLinePlacement.BeforeOpenBraceInControlBlocks | RazorNewLinePlacement.BetweenQueryExpressionClauses,
                WrappingKeepStatementsOnSingleLine = false,
                WrappingPreserveSingleLine = false,
            });
    }

    [FormattingTestFact]
    public async Task CSharpSyntaxFormattingOptions_WithoutBeforeOpenBraceInAccessors_SingleLine_PreserveSingle()
    {
        await RunFormattingTestAsync(
            input: """
                @code
                {
                private bool IconMenuActive { get; set; } = false;
                protected void ToggleIconMenu(bool iconMenuActive)
                {
                IconMenuActive = iconMenuActive;
                }
                }
                """,
            expected: """
                @code
                {
                    private bool IconMenuActive { get; set; } = false;
                    protected void ToggleIconMenu(bool iconMenuActive)
                    {
                        IconMenuActive = iconMenuActive;
                    }
                }
                """,
            csharpSyntaxFormattingOptions: RazorCSharpSyntaxFormattingOptions.Default with
            {
                NewLines = RazorNewLinePlacement.BeforeMembersInObjectInitializers | RazorNewLinePlacement.BeforeMembersInAnonymousTypes | RazorNewLinePlacement.BeforeElse | RazorNewLinePlacement.BeforeCatch | RazorNewLinePlacement.BeforeFinally | RazorNewLinePlacement.BeforeOpenBraceInTypes | RazorNewLinePlacement.BeforeOpenBraceInAnonymousTypes | RazorNewLinePlacement.BeforeOpenBraceInObjectCollectionArrayInitializers | RazorNewLinePlacement.BeforeOpenBraceInProperties | RazorNewLinePlacement.BeforeOpenBraceInMethods | RazorNewLinePlacement.BeforeOpenBraceInAnonymousMethods | RazorNewLinePlacement.BeforeOpenBraceInLambdaExpressionBody | RazorNewLinePlacement.BeforeOpenBraceInControlBlocks | RazorNewLinePlacement.BetweenQueryExpressionClauses,
                WrappingKeepStatementsOnSingleLine = true,
                WrappingPreserveSingleLine = true,
            });
    }

    [FormattingTestFact]
    public async Task CSharpSyntaxFormattingOptions_WithoutBeforeOpenBraceInAccessors_SingleLine_DontPreserve()
    {
        await RunFormattingTestAsync(
            input: """
                @code
                {
                private bool IconMenuActive { get; set; } = false;
                protected void ToggleIconMenu(bool iconMenuActive)
                {
                IconMenuActive = iconMenuActive;
                }
                }
                """,
            expected: """
                @code
                {
                    private bool IconMenuActive { get; set; } = false;
                    protected void ToggleIconMenu(bool iconMenuActive)
                    {
                        IconMenuActive = iconMenuActive;
                    }
                }
                """,
            csharpSyntaxFormattingOptions: RazorCSharpSyntaxFormattingOptions.Default with
            {
                NewLines = RazorNewLinePlacement.BeforeMembersInObjectInitializers | RazorNewLinePlacement.BeforeMembersInAnonymousTypes | RazorNewLinePlacement.BeforeElse | RazorNewLinePlacement.BeforeCatch | RazorNewLinePlacement.BeforeFinally | RazorNewLinePlacement.BeforeOpenBraceInTypes | RazorNewLinePlacement.BeforeOpenBraceInAnonymousTypes | RazorNewLinePlacement.BeforeOpenBraceInObjectCollectionArrayInitializers | RazorNewLinePlacement.BeforeOpenBraceInProperties | RazorNewLinePlacement.BeforeOpenBraceInMethods | RazorNewLinePlacement.BeforeOpenBraceInAnonymousMethods | RazorNewLinePlacement.BeforeOpenBraceInLambdaExpressionBody | RazorNewLinePlacement.BeforeOpenBraceInControlBlocks | RazorNewLinePlacement.BetweenQueryExpressionClauses,
                WrappingKeepStatementsOnSingleLine = true,
                WrappingPreserveSingleLine = false,
            });
    }

    [FormattingTestFact]
    public async Task CSharpSyntaxFormattingOptions_WithoutBeforeOpenBraceInAccessors_MultiLine_PreserveSingle()
    {
        await RunFormattingTestAsync(
            input: """
                @code
                {
                private bool IconMenuActive { get; set; } = false;
                protected void ToggleIconMenu(bool iconMenuActive)
                {
                IconMenuActive = iconMenuActive;
                }
                }
                """,
            expected: """
                @code
                {
                    private bool IconMenuActive { get; set; } = false;
                    protected void ToggleIconMenu(bool iconMenuActive)
                    {
                        IconMenuActive = iconMenuActive;
                    }
                }
                """,
            csharpSyntaxFormattingOptions: RazorCSharpSyntaxFormattingOptions.Default with
            {
                NewLines = RazorNewLinePlacement.BeforeMembersInObjectInitializers | RazorNewLinePlacement.BeforeMembersInAnonymousTypes | RazorNewLinePlacement.BeforeElse | RazorNewLinePlacement.BeforeCatch | RazorNewLinePlacement.BeforeFinally | RazorNewLinePlacement.BeforeOpenBraceInTypes | RazorNewLinePlacement.BeforeOpenBraceInAnonymousTypes | RazorNewLinePlacement.BeforeOpenBraceInObjectCollectionArrayInitializers | RazorNewLinePlacement.BeforeOpenBraceInProperties | RazorNewLinePlacement.BeforeOpenBraceInMethods | RazorNewLinePlacement.BeforeOpenBraceInAnonymousMethods | RazorNewLinePlacement.BeforeOpenBraceInLambdaExpressionBody | RazorNewLinePlacement.BeforeOpenBraceInControlBlocks | RazorNewLinePlacement.BetweenQueryExpressionClauses,
                WrappingKeepStatementsOnSingleLine = false,
                WrappingPreserveSingleLine = true,
            });
    }

    [FormattingTestFact]
    public async Task CSharpSyntaxFormattingOptions_WithoutBeforeOpenBraceInAccessors_MultiLine_DontPreserve()
    {
        await RunFormattingTestAsync(
            input: """
                @code
                {
                private bool IconMenuActive { get; set; } = false;
                protected void ToggleIconMenu(bool iconMenuActive)
                {
                IconMenuActive = iconMenuActive;
                }
                }
                """,
            expected: """
                @code
                {
                    private bool IconMenuActive { get; set; } = false;
                    protected void ToggleIconMenu(bool iconMenuActive)
                    {
                        IconMenuActive = iconMenuActive;
                    }
                }
                """,
            csharpSyntaxFormattingOptions: RazorCSharpSyntaxFormattingOptions.Default with
            {
                NewLines = RazorNewLinePlacement.BeforeMembersInObjectInitializers | RazorNewLinePlacement.BeforeMembersInAnonymousTypes | RazorNewLinePlacement.BeforeElse | RazorNewLinePlacement.BeforeCatch | RazorNewLinePlacement.BeforeFinally | RazorNewLinePlacement.BeforeOpenBraceInTypes | RazorNewLinePlacement.BeforeOpenBraceInAnonymousTypes | RazorNewLinePlacement.BeforeOpenBraceInObjectCollectionArrayInitializers | RazorNewLinePlacement.BeforeOpenBraceInProperties | RazorNewLinePlacement.BeforeOpenBraceInMethods | RazorNewLinePlacement.BeforeOpenBraceInAnonymousMethods | RazorNewLinePlacement.BeforeOpenBraceInLambdaExpressionBody | RazorNewLinePlacement.BeforeOpenBraceInControlBlocks | RazorNewLinePlacement.BetweenQueryExpressionClauses,
                WrappingKeepStatementsOnSingleLine = false,
                WrappingPreserveSingleLine = false,
            });
    }

    [FormattingTestFact]
    public async Task CSharpSyntaxFormattingOptions_WithoutBeforeOpenBraceInAnonymousMethods_SingleLine_PreserveSingle()
    {
        await RunFormattingTestAsync(
            input: """
                @code
                {
                private bool IconMenuActive { get; set; } = false;
                protected void ToggleIconMenu(bool iconMenuActive)
                {
                IconMenuActive = iconMenuActive;
                }
                }
                """,
            expected: """
                @code
                {
                    private bool IconMenuActive { get; set; } = false;
                    protected void ToggleIconMenu(bool iconMenuActive)
                    {
                        IconMenuActive = iconMenuActive;
                    }
                }
                """,
            csharpSyntaxFormattingOptions: RazorCSharpSyntaxFormattingOptions.Default with
            {
                NewLines = RazorNewLinePlacement.BeforeMembersInObjectInitializers | RazorNewLinePlacement.BeforeMembersInAnonymousTypes | RazorNewLinePlacement.BeforeElse | RazorNewLinePlacement.BeforeCatch | RazorNewLinePlacement.BeforeFinally | RazorNewLinePlacement.BeforeOpenBraceInTypes | RazorNewLinePlacement.BeforeOpenBraceInAnonymousTypes | RazorNewLinePlacement.BeforeOpenBraceInObjectCollectionArrayInitializers | RazorNewLinePlacement.BeforeOpenBraceInProperties | RazorNewLinePlacement.BeforeOpenBraceInMethods | RazorNewLinePlacement.BeforeOpenBraceInAccessors | RazorNewLinePlacement.BeforeOpenBraceInLambdaExpressionBody | RazorNewLinePlacement.BeforeOpenBraceInControlBlocks | RazorNewLinePlacement.BetweenQueryExpressionClauses,
                WrappingKeepStatementsOnSingleLine = true,
                WrappingPreserveSingleLine = true,
            });
    }

    [FormattingTestFact]
    public async Task CSharpSyntaxFormattingOptions_WithoutBeforeOpenBraceInAnonymousMethods_SingleLine_DontPreserve()
    {
        await RunFormattingTestAsync(
            input: """
                @code
                {
                private bool IconMenuActive { get; set; } = false;
                protected void ToggleIconMenu(bool iconMenuActive)
                {
                IconMenuActive = iconMenuActive;
                }
                }
                """,
            expected: """
                @code
                {
                    private bool IconMenuActive { get; set; } = false;
                    protected void ToggleIconMenu(bool iconMenuActive)
                    {
                        IconMenuActive = iconMenuActive;
                    }
                }
                """,
            csharpSyntaxFormattingOptions: RazorCSharpSyntaxFormattingOptions.Default with
            {
                NewLines = RazorNewLinePlacement.BeforeMembersInObjectInitializers | RazorNewLinePlacement.BeforeMembersInAnonymousTypes | RazorNewLinePlacement.BeforeElse | RazorNewLinePlacement.BeforeCatch | RazorNewLinePlacement.BeforeFinally | RazorNewLinePlacement.BeforeOpenBraceInTypes | RazorNewLinePlacement.BeforeOpenBraceInAnonymousTypes | RazorNewLinePlacement.BeforeOpenBraceInObjectCollectionArrayInitializers | RazorNewLinePlacement.BeforeOpenBraceInProperties | RazorNewLinePlacement.BeforeOpenBraceInMethods | RazorNewLinePlacement.BeforeOpenBraceInAccessors | RazorNewLinePlacement.BeforeOpenBraceInLambdaExpressionBody | RazorNewLinePlacement.BeforeOpenBraceInControlBlocks | RazorNewLinePlacement.BetweenQueryExpressionClauses,
                WrappingKeepStatementsOnSingleLine = true,
                WrappingPreserveSingleLine = false,
            });
    }

    [FormattingTestFact]
    public async Task CSharpSyntaxFormattingOptions_WithoutBeforeOpenBraceInAnonymousMethods_MultiLine_PreserveSingle()
    {
        await RunFormattingTestAsync(
            input: """
                @code
                {
                private bool IconMenuActive { get; set; } = false;
                protected void ToggleIconMenu(bool iconMenuActive)
                {
                IconMenuActive = iconMenuActive;
                }
                }
                """,
            expected: """
                @code
                {
                    private bool IconMenuActive { get; set; } = false;
                    protected void ToggleIconMenu(bool iconMenuActive)
                    {
                        IconMenuActive = iconMenuActive;
                    }
                }
                """,
            csharpSyntaxFormattingOptions: RazorCSharpSyntaxFormattingOptions.Default with
            {
                NewLines = RazorNewLinePlacement.BeforeMembersInObjectInitializers | RazorNewLinePlacement.BeforeMembersInAnonymousTypes | RazorNewLinePlacement.BeforeElse | RazorNewLinePlacement.BeforeCatch | RazorNewLinePlacement.BeforeFinally | RazorNewLinePlacement.BeforeOpenBraceInTypes | RazorNewLinePlacement.BeforeOpenBraceInAnonymousTypes | RazorNewLinePlacement.BeforeOpenBraceInObjectCollectionArrayInitializers | RazorNewLinePlacement.BeforeOpenBraceInProperties | RazorNewLinePlacement.BeforeOpenBraceInMethods | RazorNewLinePlacement.BeforeOpenBraceInAccessors | RazorNewLinePlacement.BeforeOpenBraceInLambdaExpressionBody | RazorNewLinePlacement.BeforeOpenBraceInControlBlocks | RazorNewLinePlacement.BetweenQueryExpressionClauses,
                WrappingKeepStatementsOnSingleLine = false,
                WrappingPreserveSingleLine = true,
            });
    }

    [FormattingTestFact]
    public async Task CSharpSyntaxFormattingOptions_WithoutBeforeOpenBraceInAnonymousMethods_MultiLine_DontPreserve()
    {
        await RunFormattingTestAsync(
            input: """
                @code
                {
                private bool IconMenuActive { get; set; } = false;
                protected void ToggleIconMenu(bool iconMenuActive)
                {
                IconMenuActive = iconMenuActive;
                }
                }
                """,
            expected: """
                @code
                {
                    private bool IconMenuActive { get; set; } = false;
                    protected void ToggleIconMenu(bool iconMenuActive)
                    {
                        IconMenuActive = iconMenuActive;
                    }
                }
                """,
            csharpSyntaxFormattingOptions: RazorCSharpSyntaxFormattingOptions.Default with
            {
                NewLines = RazorNewLinePlacement.BeforeMembersInObjectInitializers | RazorNewLinePlacement.BeforeMembersInAnonymousTypes | RazorNewLinePlacement.BeforeElse | RazorNewLinePlacement.BeforeCatch | RazorNewLinePlacement.BeforeFinally | RazorNewLinePlacement.BeforeOpenBraceInTypes | RazorNewLinePlacement.BeforeOpenBraceInAnonymousTypes | RazorNewLinePlacement.BeforeOpenBraceInObjectCollectionArrayInitializers | RazorNewLinePlacement.BeforeOpenBraceInProperties | RazorNewLinePlacement.BeforeOpenBraceInMethods | RazorNewLinePlacement.BeforeOpenBraceInAccessors | RazorNewLinePlacement.BeforeOpenBraceInLambdaExpressionBody | RazorNewLinePlacement.BeforeOpenBraceInControlBlocks | RazorNewLinePlacement.BetweenQueryExpressionClauses,
                WrappingKeepStatementsOnSingleLine = false,
                WrappingPreserveSingleLine = false,
            });
    }

    [FormattingTestFact]
    public async Task CSharpSyntaxFormattingOptions_WithoutBeforeOpenBraceInLambdaExpressionBody_SingleLine_PreserveSingle()
    {
        await RunFormattingTestAsync(
            input: """
                @code
                {
                private bool IconMenuActive { get; set; } = false;
                protected void ToggleIconMenu(bool iconMenuActive)
                {
                IconMenuActive = iconMenuActive;
                }
                }
                """,
            expected: """
                @code
                {
                    private bool IconMenuActive { get; set; } = false;
                    protected void ToggleIconMenu(bool iconMenuActive)
                    {
                        IconMenuActive = iconMenuActive;
                    }
                }
                """,
            csharpSyntaxFormattingOptions: RazorCSharpSyntaxFormattingOptions.Default with
            {
                NewLines = RazorNewLinePlacement.BeforeMembersInObjectInitializers | RazorNewLinePlacement.BeforeMembersInAnonymousTypes | RazorNewLinePlacement.BeforeElse | RazorNewLinePlacement.BeforeCatch | RazorNewLinePlacement.BeforeFinally | RazorNewLinePlacement.BeforeOpenBraceInTypes | RazorNewLinePlacement.BeforeOpenBraceInAnonymousTypes | RazorNewLinePlacement.BeforeOpenBraceInObjectCollectionArrayInitializers | RazorNewLinePlacement.BeforeOpenBraceInProperties | RazorNewLinePlacement.BeforeOpenBraceInMethods | RazorNewLinePlacement.BeforeOpenBraceInAccessors | RazorNewLinePlacement.BeforeOpenBraceInAnonymousMethods | RazorNewLinePlacement.BeforeOpenBraceInControlBlocks | RazorNewLinePlacement.BetweenQueryExpressionClauses,
                WrappingKeepStatementsOnSingleLine = true,
                WrappingPreserveSingleLine = true,
            });
    }

    [FormattingTestFact]
    public async Task CSharpSyntaxFormattingOptions_WithoutBeforeOpenBraceInLambdaExpressionBody_SingleLine_DontPreserve()
    {
        await RunFormattingTestAsync(
            input: """
                @code
                {
                private bool IconMenuActive { get; set; } = false;
                protected void ToggleIconMenu(bool iconMenuActive)
                {
                IconMenuActive = iconMenuActive;
                }
                }
                """,
            expected: """
                @code
                {
                    private bool IconMenuActive { get; set; } = false;
                    protected void ToggleIconMenu(bool iconMenuActive)
                    {
                        IconMenuActive = iconMenuActive;
                    }
                }
                """,
            csharpSyntaxFormattingOptions: RazorCSharpSyntaxFormattingOptions.Default with
            {
                NewLines = RazorNewLinePlacement.BeforeMembersInObjectInitializers | RazorNewLinePlacement.BeforeMembersInAnonymousTypes | RazorNewLinePlacement.BeforeElse | RazorNewLinePlacement.BeforeCatch | RazorNewLinePlacement.BeforeFinally | RazorNewLinePlacement.BeforeOpenBraceInTypes | RazorNewLinePlacement.BeforeOpenBraceInAnonymousTypes | RazorNewLinePlacement.BeforeOpenBraceInObjectCollectionArrayInitializers | RazorNewLinePlacement.BeforeOpenBraceInProperties | RazorNewLinePlacement.BeforeOpenBraceInMethods | RazorNewLinePlacement.BeforeOpenBraceInAccessors | RazorNewLinePlacement.BeforeOpenBraceInAnonymousMethods | RazorNewLinePlacement.BeforeOpenBraceInControlBlocks | RazorNewLinePlacement.BetweenQueryExpressionClauses,
                WrappingKeepStatementsOnSingleLine = true,
                WrappingPreserveSingleLine = false,
            });
    }

    [FormattingTestFact]
    public async Task CSharpSyntaxFormattingOptions_WithoutBeforeOpenBraceInLambdaExpressionBody_MultiLine_PreserveSingle()
    {
        await RunFormattingTestAsync(
            input: """
                @code
                {
                private bool IconMenuActive { get; set; } = false;
                protected void ToggleIconMenu(bool iconMenuActive)
                {
                IconMenuActive = iconMenuActive;
                }
                }
                """,
            expected: """
                @code
                {
                    private bool IconMenuActive { get; set; } = false;
                    protected void ToggleIconMenu(bool iconMenuActive)
                    {
                        IconMenuActive = iconMenuActive;
                    }
                }
                """,
            csharpSyntaxFormattingOptions: RazorCSharpSyntaxFormattingOptions.Default with
            {
                NewLines = RazorNewLinePlacement.BeforeMembersInObjectInitializers | RazorNewLinePlacement.BeforeMembersInAnonymousTypes | RazorNewLinePlacement.BeforeElse | RazorNewLinePlacement.BeforeCatch | RazorNewLinePlacement.BeforeFinally | RazorNewLinePlacement.BeforeOpenBraceInTypes | RazorNewLinePlacement.BeforeOpenBraceInAnonymousTypes | RazorNewLinePlacement.BeforeOpenBraceInObjectCollectionArrayInitializers | RazorNewLinePlacement.BeforeOpenBraceInProperties | RazorNewLinePlacement.BeforeOpenBraceInMethods | RazorNewLinePlacement.BeforeOpenBraceInAccessors | RazorNewLinePlacement.BeforeOpenBraceInAnonymousMethods | RazorNewLinePlacement.BeforeOpenBraceInControlBlocks | RazorNewLinePlacement.BetweenQueryExpressionClauses,
                WrappingKeepStatementsOnSingleLine = false,
                WrappingPreserveSingleLine = true,
            });
    }

    [FormattingTestFact]
    public async Task CSharpSyntaxFormattingOptions_WithoutBeforeOpenBraceInLambdaExpressionBody_MultiLine_DontPreserve()
    {
        await RunFormattingTestAsync(
            input: """
                @code
                {
                private bool IconMenuActive { get; set; } = false;
                protected void ToggleIconMenu(bool iconMenuActive)
                {
                IconMenuActive = iconMenuActive;
                }
                }
                """,
            expected: """
                @code
                {
                    private bool IconMenuActive { get; set; } = false;
                    protected void ToggleIconMenu(bool iconMenuActive)
                    {
                        IconMenuActive = iconMenuActive;
                    }
                }
                """,
            csharpSyntaxFormattingOptions: RazorCSharpSyntaxFormattingOptions.Default with
            {
                NewLines = RazorNewLinePlacement.BeforeMembersInObjectInitializers | RazorNewLinePlacement.BeforeMembersInAnonymousTypes | RazorNewLinePlacement.BeforeElse | RazorNewLinePlacement.BeforeCatch | RazorNewLinePlacement.BeforeFinally | RazorNewLinePlacement.BeforeOpenBraceInTypes | RazorNewLinePlacement.BeforeOpenBraceInAnonymousTypes | RazorNewLinePlacement.BeforeOpenBraceInObjectCollectionArrayInitializers | RazorNewLinePlacement.BeforeOpenBraceInProperties | RazorNewLinePlacement.BeforeOpenBraceInMethods | RazorNewLinePlacement.BeforeOpenBraceInAccessors | RazorNewLinePlacement.BeforeOpenBraceInAnonymousMethods | RazorNewLinePlacement.BeforeOpenBraceInControlBlocks | RazorNewLinePlacement.BetweenQueryExpressionClauses,
                WrappingKeepStatementsOnSingleLine = false,
                WrappingPreserveSingleLine = false,
            });
    }

    [FormattingTestFact]
    public async Task CSharpSyntaxFormattingOptions_WithoutBeforeOpenBraceInControlBlocks_SingleLine_PreserveSingle()
    {
        await RunFormattingTestAsync(
            input: """
                @code
                {
                private bool IconMenuActive { get; set; } = false;
                protected void ToggleIconMenu(bool iconMenuActive)
                {
                IconMenuActive = iconMenuActive;
                }
                }
                """,
            expected: """
                @code
                {
                    private bool IconMenuActive { get; set; } = false;
                    protected void ToggleIconMenu(bool iconMenuActive)
                    {
                        IconMenuActive = iconMenuActive;
                    }
                }
                """,
            csharpSyntaxFormattingOptions: RazorCSharpSyntaxFormattingOptions.Default with
            {
                NewLines = RazorNewLinePlacement.BeforeMembersInObjectInitializers | RazorNewLinePlacement.BeforeMembersInAnonymousTypes | RazorNewLinePlacement.BeforeElse | RazorNewLinePlacement.BeforeCatch | RazorNewLinePlacement.BeforeFinally | RazorNewLinePlacement.BeforeOpenBraceInTypes | RazorNewLinePlacement.BeforeOpenBraceInAnonymousTypes | RazorNewLinePlacement.BeforeOpenBraceInObjectCollectionArrayInitializers | RazorNewLinePlacement.BeforeOpenBraceInProperties | RazorNewLinePlacement.BeforeOpenBraceInMethods | RazorNewLinePlacement.BeforeOpenBraceInAccessors | RazorNewLinePlacement.BeforeOpenBraceInAnonymousMethods | RazorNewLinePlacement.BeforeOpenBraceInLambdaExpressionBody | RazorNewLinePlacement.BetweenQueryExpressionClauses,
                WrappingKeepStatementsOnSingleLine = true,
                WrappingPreserveSingleLine = true,
            });
    }

    [FormattingTestFact]
    public async Task CSharpSyntaxFormattingOptions_WithoutBeforeOpenBraceInControlBlocks_SingleLine_DontPreserve()
    {
        await RunFormattingTestAsync(
            input: """
                @code
                {
                private bool IconMenuActive { get; set; } = false;
                protected void ToggleIconMenu(bool iconMenuActive)
                {
                IconMenuActive = iconMenuActive;
                }
                }
                """,
            expected: """
                @code
                {
                    private bool IconMenuActive { get; set; } = false;
                    protected void ToggleIconMenu(bool iconMenuActive)
                    {
                        IconMenuActive = iconMenuActive;
                    }
                }
                """,
            csharpSyntaxFormattingOptions: RazorCSharpSyntaxFormattingOptions.Default with
            {
                NewLines = RazorNewLinePlacement.BeforeMembersInObjectInitializers | RazorNewLinePlacement.BeforeMembersInAnonymousTypes | RazorNewLinePlacement.BeforeElse | RazorNewLinePlacement.BeforeCatch | RazorNewLinePlacement.BeforeFinally | RazorNewLinePlacement.BeforeOpenBraceInTypes | RazorNewLinePlacement.BeforeOpenBraceInAnonymousTypes | RazorNewLinePlacement.BeforeOpenBraceInObjectCollectionArrayInitializers | RazorNewLinePlacement.BeforeOpenBraceInProperties | RazorNewLinePlacement.BeforeOpenBraceInMethods | RazorNewLinePlacement.BeforeOpenBraceInAccessors | RazorNewLinePlacement.BeforeOpenBraceInAnonymousMethods | RazorNewLinePlacement.BeforeOpenBraceInLambdaExpressionBody | RazorNewLinePlacement.BetweenQueryExpressionClauses,
                WrappingKeepStatementsOnSingleLine = true,
                WrappingPreserveSingleLine = false,
            });
    }

    [FormattingTestFact]
    public async Task CSharpSyntaxFormattingOptions_WithoutBeforeOpenBraceInControlBlocks_MultiLine_PreserveSingle()
    {
        await RunFormattingTestAsync(
            input: """
                @code
                {
                private bool IconMenuActive { get; set; } = false;
                protected void ToggleIconMenu(bool iconMenuActive)
                {
                IconMenuActive = iconMenuActive;
                }
                }
                """,
            expected: """
                @code
                {
                    private bool IconMenuActive { get; set; } = false;
                    protected void ToggleIconMenu(bool iconMenuActive)
                    {
                        IconMenuActive = iconMenuActive;
                    }
                }
                """,
            csharpSyntaxFormattingOptions: RazorCSharpSyntaxFormattingOptions.Default with
            {
                NewLines = RazorNewLinePlacement.BeforeMembersInObjectInitializers | RazorNewLinePlacement.BeforeMembersInAnonymousTypes | RazorNewLinePlacement.BeforeElse | RazorNewLinePlacement.BeforeCatch | RazorNewLinePlacement.BeforeFinally | RazorNewLinePlacement.BeforeOpenBraceInTypes | RazorNewLinePlacement.BeforeOpenBraceInAnonymousTypes | RazorNewLinePlacement.BeforeOpenBraceInObjectCollectionArrayInitializers | RazorNewLinePlacement.BeforeOpenBraceInProperties | RazorNewLinePlacement.BeforeOpenBraceInMethods | RazorNewLinePlacement.BeforeOpenBraceInAccessors | RazorNewLinePlacement.BeforeOpenBraceInAnonymousMethods | RazorNewLinePlacement.BeforeOpenBraceInLambdaExpressionBody | RazorNewLinePlacement.BetweenQueryExpressionClauses,
                WrappingKeepStatementsOnSingleLine = false,
                WrappingPreserveSingleLine = true,
            });
    }

    [FormattingTestFact]
    public async Task CSharpSyntaxFormattingOptions_WithoutBeforeOpenBraceInControlBlocks_MultiLine_DontPreserve()
    {
        await RunFormattingTestAsync(
            input: """
                @code
                {
                private bool IconMenuActive { get; set; } = false;
                protected void ToggleIconMenu(bool iconMenuActive)
                {
                IconMenuActive = iconMenuActive;
                }
                }
                """,
            expected: """
                @code
                {
                    private bool IconMenuActive { get; set; } = false;
                    protected void ToggleIconMenu(bool iconMenuActive)
                    {
                        IconMenuActive = iconMenuActive;
                    }
                }
                """,
            csharpSyntaxFormattingOptions: RazorCSharpSyntaxFormattingOptions.Default with
            {
                NewLines = RazorNewLinePlacement.BeforeMembersInObjectInitializers | RazorNewLinePlacement.BeforeMembersInAnonymousTypes | RazorNewLinePlacement.BeforeElse | RazorNewLinePlacement.BeforeCatch | RazorNewLinePlacement.BeforeFinally | RazorNewLinePlacement.BeforeOpenBraceInTypes | RazorNewLinePlacement.BeforeOpenBraceInAnonymousTypes | RazorNewLinePlacement.BeforeOpenBraceInObjectCollectionArrayInitializers | RazorNewLinePlacement.BeforeOpenBraceInProperties | RazorNewLinePlacement.BeforeOpenBraceInMethods | RazorNewLinePlacement.BeforeOpenBraceInAccessors | RazorNewLinePlacement.BeforeOpenBraceInAnonymousMethods | RazorNewLinePlacement.BeforeOpenBraceInLambdaExpressionBody | RazorNewLinePlacement.BetweenQueryExpressionClauses,
                WrappingKeepStatementsOnSingleLine = false,
                WrappingPreserveSingleLine = false,
            });
    }

    [FormattingTestFact]
    public async Task CSharpSyntaxFormattingOptions_WithoutBetweenQueryExpressionClauses_SingleLine_PreserveSingle()
    {
        await RunFormattingTestAsync(
            input: """
                @code
                {
                private bool IconMenuActive { get; set; } = false;
                protected void ToggleIconMenu(bool iconMenuActive)
                {
                IconMenuActive = iconMenuActive;
                }
                }
                """,
            expected: """
                @code
                {
                    private bool IconMenuActive { get; set; } = false;
                    protected void ToggleIconMenu(bool iconMenuActive)
                    {
                        IconMenuActive = iconMenuActive;
                    }
                }
                """,
            csharpSyntaxFormattingOptions: RazorCSharpSyntaxFormattingOptions.Default with
            {
                NewLines = RazorNewLinePlacement.BeforeMembersInObjectInitializers | RazorNewLinePlacement.BeforeMembersInAnonymousTypes | RazorNewLinePlacement.BeforeElse | RazorNewLinePlacement.BeforeCatch | RazorNewLinePlacement.BeforeFinally | RazorNewLinePlacement.BeforeOpenBraceInTypes | RazorNewLinePlacement.BeforeOpenBraceInAnonymousTypes | RazorNewLinePlacement.BeforeOpenBraceInObjectCollectionArrayInitializers | RazorNewLinePlacement.BeforeOpenBraceInProperties | RazorNewLinePlacement.BeforeOpenBraceInMethods | RazorNewLinePlacement.BeforeOpenBraceInAccessors | RazorNewLinePlacement.BeforeOpenBraceInAnonymousMethods | RazorNewLinePlacement.BeforeOpenBraceInLambdaExpressionBody | RazorNewLinePlacement.BeforeOpenBraceInControlBlocks,
                WrappingKeepStatementsOnSingleLine = true,
                WrappingPreserveSingleLine = true,
            });
    }

    [FormattingTestFact]
    public async Task CSharpSyntaxFormattingOptions_WithoutBetweenQueryExpressionClauses_SingleLine_DontPreserve()
    {
        await RunFormattingTestAsync(
            input: """
                @code
                {
                private bool IconMenuActive { get; set; } = false;
                protected void ToggleIconMenu(bool iconMenuActive)
                {
                IconMenuActive = iconMenuActive;
                }
                }
                """,
            expected: """
                @code
                {
                    private bool IconMenuActive { get; set; } = false;
                    protected void ToggleIconMenu(bool iconMenuActive)
                    {
                        IconMenuActive = iconMenuActive;
                    }
                }
                """,
            csharpSyntaxFormattingOptions: RazorCSharpSyntaxFormattingOptions.Default with
            {
                NewLines = RazorNewLinePlacement.BeforeMembersInObjectInitializers | RazorNewLinePlacement.BeforeMembersInAnonymousTypes | RazorNewLinePlacement.BeforeElse | RazorNewLinePlacement.BeforeCatch | RazorNewLinePlacement.BeforeFinally | RazorNewLinePlacement.BeforeOpenBraceInTypes | RazorNewLinePlacement.BeforeOpenBraceInAnonymousTypes | RazorNewLinePlacement.BeforeOpenBraceInObjectCollectionArrayInitializers | RazorNewLinePlacement.BeforeOpenBraceInProperties | RazorNewLinePlacement.BeforeOpenBraceInMethods | RazorNewLinePlacement.BeforeOpenBraceInAccessors | RazorNewLinePlacement.BeforeOpenBraceInAnonymousMethods | RazorNewLinePlacement.BeforeOpenBraceInLambdaExpressionBody | RazorNewLinePlacement.BeforeOpenBraceInControlBlocks,
                WrappingKeepStatementsOnSingleLine = true,
                WrappingPreserveSingleLine = false,
            });
    }

    [FormattingTestFact]
    public async Task CSharpSyntaxFormattingOptions_WithoutBetweenQueryExpressionClauses_MultiLine_PreserveSingle()
    {
        await RunFormattingTestAsync(
            input: """
                @code
                {
                private bool IconMenuActive { get; set; } = false;
                protected void ToggleIconMenu(bool iconMenuActive)
                {
                IconMenuActive = iconMenuActive;
                }
                }
                """,
            expected: """
                @code
                {
                    private bool IconMenuActive { get; set; } = false;
                    protected void ToggleIconMenu(bool iconMenuActive)
                    {
                        IconMenuActive = iconMenuActive;
                    }
                }
                """,
            csharpSyntaxFormattingOptions: RazorCSharpSyntaxFormattingOptions.Default with
            {
                NewLines = RazorNewLinePlacement.BeforeMembersInObjectInitializers | RazorNewLinePlacement.BeforeMembersInAnonymousTypes | RazorNewLinePlacement.BeforeElse | RazorNewLinePlacement.BeforeCatch | RazorNewLinePlacement.BeforeFinally | RazorNewLinePlacement.BeforeOpenBraceInTypes | RazorNewLinePlacement.BeforeOpenBraceInAnonymousTypes | RazorNewLinePlacement.BeforeOpenBraceInObjectCollectionArrayInitializers | RazorNewLinePlacement.BeforeOpenBraceInProperties | RazorNewLinePlacement.BeforeOpenBraceInMethods | RazorNewLinePlacement.BeforeOpenBraceInAccessors | RazorNewLinePlacement.BeforeOpenBraceInAnonymousMethods | RazorNewLinePlacement.BeforeOpenBraceInLambdaExpressionBody | RazorNewLinePlacement.BeforeOpenBraceInControlBlocks,
                WrappingKeepStatementsOnSingleLine = false,
                WrappingPreserveSingleLine = true,
            });
    }

    [FormattingTestFact]
    public async Task CSharpSyntaxFormattingOptions_WithoutBetweenQueryExpressionClauses_MultiLine_DontPreserve()
    {
        await RunFormattingTestAsync(
            input: """
                @code
                {
                private bool IconMenuActive { get; set; } = false;
                protected void ToggleIconMenu(bool iconMenuActive)
                {
                IconMenuActive = iconMenuActive;
                }
                }
                """,
            expected: """
                @code
                {
                    private bool IconMenuActive { get; set; } = false;
                    protected void ToggleIconMenu(bool iconMenuActive)
                    {
                        IconMenuActive = iconMenuActive;
                    }
                }
                """,
            csharpSyntaxFormattingOptions: RazorCSharpSyntaxFormattingOptions.Default with
            {
                NewLines = RazorNewLinePlacement.BeforeMembersInObjectInitializers | RazorNewLinePlacement.BeforeMembersInAnonymousTypes | RazorNewLinePlacement.BeforeElse | RazorNewLinePlacement.BeforeCatch | RazorNewLinePlacement.BeforeFinally | RazorNewLinePlacement.BeforeOpenBraceInTypes | RazorNewLinePlacement.BeforeOpenBraceInAnonymousTypes | RazorNewLinePlacement.BeforeOpenBraceInObjectCollectionArrayInitializers | RazorNewLinePlacement.BeforeOpenBraceInProperties | RazorNewLinePlacement.BeforeOpenBraceInMethods | RazorNewLinePlacement.BeforeOpenBraceInAccessors | RazorNewLinePlacement.BeforeOpenBraceInAnonymousMethods | RazorNewLinePlacement.BeforeOpenBraceInLambdaExpressionBody | RazorNewLinePlacement.BeforeOpenBraceInControlBlocks,
                WrappingKeepStatementsOnSingleLine = false,
                WrappingPreserveSingleLine = false,
            });
    }
}
