/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.draw;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.lang.constant.Constable;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import org.emboss.jemboss.draw.DNADraw;
import org.emboss.jemboss.draw.EmbossCirdnaReader;
import org.emboss.jemboss.draw.GeneticMarker;
import org.emboss.jemboss.draw.LineAttribute;
import org.emboss.jemboss.draw.RestrictionEnzyme;
import org.emboss.jemboss.draw.Ticks;
import org.emboss.jemboss.gui.ScrollPanel;

public class Wizard {
    private DNADraw dna = null;

    public Wizard(DNADraw dna_current) {
        int n = this.getOption(dna_current);
        if (n == 0) {
            EmbossCirdnaReader dnaRead = new EmbossCirdnaReader();
            Hashtable<String, Constable> lineAttr = new Hashtable<String, Constable>();
            lineAttr.put("lsize", new Integer(5));
            lineAttr.put("circular", new Boolean(true));
            lineAttr.put("start", new Integer(dnaRead.getStart()));
            lineAttr.put("end", new Integer(dnaRead.getEnd()));
            this.dna = new DNADraw(dnaRead.getBlock(), dnaRead.getRestrictionEnzyme(), lineAttr, 0, 100, 100);
        } else if (n == 1 || n == 2) {
            int hgt;
            JFrame f = new JFrame("Genetic Feature");
            Vector block = new Vector();
            Vector restrictionEnzyme = new Vector();
            if (dna_current == null) {
                this.dna = new DNADraw();
            } else {
                this.dna = dna_current;
                block = dna_current.getGeneticMarker();
                restrictionEnzyme = dna_current.getRestrictionEnzyme();
            }
            LineAttribute la = new LineAttribute(this.dna);
            GeneticMarker gm = dna_current != null ? new GeneticMarker(dna_current, block) : new GeneticMarker(this.dna, block);
            RestrictionEnzyme re = dna_current != null ? new RestrictionEnzyme(dna_current, restrictionEnzyme) : new RestrictionEnzyme(this.dna, restrictionEnzyme);
            Ticks tk = new Ticks(dna_current, false);
            la.setMinimumSize(la.getPreferredSize());
            la.setMaximumSize(la.getPreferredSize());
            re.setMinimumSize(re.getPreferredSize());
            re.setMaximumSize(re.getPreferredSize());
            ScrollPanel pane = new ScrollPanel(new BorderLayout());
            Box bdown = Box.createVerticalBox();
            bdown.add(new JLabel("DNA Attributes"));
            Box bacross = Box.createHorizontalBox();
            bacross.add(la);
            bacross.add(tk);
            bacross.add(Box.createHorizontalGlue());
            bdown.add(bacross);
            bdown.add(Box.createHorizontalStrut(10));
            bdown.add(new JLabel("Genetic Feature"));
            bacross = Box.createHorizontalBox();
            bacross.add(gm);
            bacross.add(Box.createHorizontalGlue());
            bdown.add(bacross);
            bdown.add(Box.createHorizontalStrut(10));
            bdown.add(new JLabel("Restriction Enzymes"));
            bacross = Box.createHorizontalBox();
            bacross.add(re);
            bacross.add(Box.createHorizontalGlue());
            bdown.add(bacross);
            pane.add((Component)bdown, "Center");
            JScrollPane createWizScroll = new JScrollPane(pane);
            Dimension dscreen = f.getToolkit().getScreenSize();
            int wid = (int)dscreen.getWidth();
            if (wid > 700) {
                wid = 700;
            }
            if ((hgt = (int)dscreen.getHeight()) > 750) {
                hgt = 700;
            }
            Dimension d = new Dimension(wid, hgt -= 50);
            createWizScroll.setPreferredSize(d);
            JOptionPane.showMessageDialog(null, createWizScroll, "DNA Wizard", -1);
            this.dna.setGeneticMarker(block);
            this.dna.setRestrictionEnzyme(restrictionEnzyme);
            this.dna.setLineAttributes(la.getLineAttr());
            this.dna.setStartTick(tk.getStartTick());
            this.dna.setMinorTickInterval(tk.getMinorTickInterval());
            this.dna.setTickInterval(tk.getTickInterval());
            int s = la.getStart();
            this.dna.setStart(s);
            s = la.getEnd();
            this.dna.setEnd(s);
        }
    }

    public DNADraw getDNADraw() {
        return this.dna;
    }

    private int getOption(DNADraw dna_current) {
        Box bdown = Box.createVerticalBox();
        JRadioButton[] radioButtons = dna_current != null ? new JRadioButton[3] : new JRadioButton[2];
        ButtonGroup group = new ButtonGroup();
        radioButtons[0] = new JRadioButton("Read in data file");
        group.add(radioButtons[0]);
        radioButtons[1] = new JRadioButton("Create new dna display");
        group.add(radioButtons[1]);
        radioButtons[1].setSelected(true);
        bdown.add(radioButtons[0]);
        bdown.add(radioButtons[1]);
        if (dna_current != null) {
            radioButtons[2] = new JRadioButton("Edit current dna display");
            group.add(radioButtons[2]);
            radioButtons[2].setSelected(true);
            bdown.add(radioButtons[2]);
        }
        JPanel pane = new JPanel(new BorderLayout());
        pane.add(bdown);
        JOptionPane.showMessageDialog(null, pane, "Jemboss DNA Viewer Wizard", 3);
        if (radioButtons[0].isSelected()) {
            return 0;
        }
        if (radioButtons[1].isSelected()) {
            return 1;
        }
        if (radioButtons[2].isSelected()) {
            return 2;
        }
        return 1;
    }
}

