-- Falkon browsedata.db

-- Tables
CREATE TABLE autofill (
    id INTEGER PRIMARY KEY,
    server TEXT NOT NULL,
    data TEXT,
    password TEXT,
    username TEXT,
    last_used INTEGER DEFAULT 0 NOT NULL
);
CREATE INDEX autofill_serverindex ON autofill (server);

CREATE TABLE autofill_encrypted (
    id INTEGER PRIMARY KEY,
    server TEXT NOT NULL,
    data_encrypted TEXT,
    password_encrypted TEXT,
    username_encrypted TEXT,
    last_used INTEGER DEFAULT 0 NOT NULL
);
CREATE INDEX autofill_encrypted_serverindex ON autofill_encrypted (server);

CREATE TABLE autofill_exceptions (
    id INTEGER PRIMARY KEY,
    server TEXT NOT NULL
);
CREATE INDEX autofill_exception_serverindex ON autofill_exceptions (server);

CREATE TABLE history (
    id INTEGER PRIMARY KEY,
    url TEXT NOT NULL,
    title TEXT,
    date INTEGER DEFAULT 0 NOT NULL,
    count INTEGER DEFAULT 0 NOT NULL
);
CREATE INDEX history_titleindex ON history (title);
CREATE UNIQUE INDEX history_urluniqueindex ON history (url);

CREATE TABLE search_engines (
    id INTEGER PRIMARY KEY,
    name TEXT NOT NULL,
    url TEXT,
    icon BLOB,
    shortcut TEXT,
    suggestionsUrl TEXT,
    suggestionsParameters TEXT,
    postData TEXT
);

CREATE TABLE icons (
    id INTEGER PRIMARY KEY,
    url TEXT NOT NULL,
    icon BLOB
);
CREATE UNIQUE INDEX icons_urluniqueindex ON icons (url);

-- Data
INSERT INTO icons VALUES(1,'https://bugs.kde.org/describecomponents.cgi?product=Falkon',X'89504e470d0a1a0a0000000d49484452000000100000001008060000001ff3ff610000000970485973000011b0000011b001c827f5540000032249444154388d2593cd6b9b7500809fdfc7fbe64dd2a4499334edac650511c52fd44db65605d90ef6a0e2c9c340d941dc45c193e0c1af8b1e3abc39443ca8083a0f9ebc883010714377e8c4c3d6cd315dd3a54d96f44df27ee4fdf8fd3cf43f789e071ee1ac6e1c9d2d553f2d164a6b9ee3a295839080b5181592c9185794d1a642d12da37501632188c7173bdd5b6f6b49beb1b4b4bc7678a58d3513ca9e66f9508ba5f959da8d3200bd61c44e6fcc766f9fed9d2e59ee10f7e571a1c4598d90cf2eaf2c509d55d42a8b34eb55e62a1ea406e577114260d21a87165b949288c75af7b0b935e07a3ac57658932088938038c9c971498d224a25433fe5e4b126278f3519ec4f19dde9f3fa4bf3acaf36c94b75a4a34080140226518c950532aba9c503826e9f519ce3382eaee37077cfe7d5e71b143d8f2f7e1a21ab354a953a5608a4100274810cc5d88f39b5bec03ba716497abb68add15af3dafa3cf3b502dffdbcc7a8dc20330a63144208b49092686a49334161a6c0e6f580e505e8460a6b012178f8be0a16b8f0f7847cce258e33f6830421402215d134434e7c5ebc3fe7e9476b9c3d7f938994804008c1b9f3ff2085e08d1716d8e9eeb3d31f610021d58182c5d2f0525e7ea689eb486e7663fc7182c502f0edc50197affaac3d52e7f17acc3409c8f20cac405a633026e3f2f684f7bfdca2ef273cf750952c955863b1d6a254890fbefe0f3fc878f7f4037861489ea5580cda5a8bc9526225f9f5b6e4a9cd01af9c58e4d28d1ea73fda6298b9b4aa55560f679cf9e41af55950263f60b3160d96691ca295e2895ac48923f7a2b5e2b337dbfc76254408c191074b2cb524376e47bcf7cd5d7c6bc8a739d65ab435967032a1e83a5cf977ca8f177afc794d63929c8fdf6a20106c7cb587eb39ac1f77704949c29024336041632d45a740188cd9f5467cfe4b9956a34da532c75f577749734b87159271cca5eff7180c43a22824886224166df2f477c7ca552534ddce2d9228228ec69467aa7cf84311a514c66e11c72141e033f47b8cfd31ad5a9bc1f0ce1fc259dd385a2d78e74aa5da939e53406b8d140781721590cb1857cca04d05cf2da1b577b0f3a4b7d9e977cffc0f08aa793d8c80ab9b0000000049454e44ae426082');
INSERT INTO icons VALUES(2,'https://userbase.kde.org/Falkon',X'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');
INSERT INTO icons VALUES(3,'https://www.kde.org/',X'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');
INSERT INTO icons VALUES(4,'https://phabricator.kde.org/source/falkon',X'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');
