/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ui.velocity;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.exception.VelocityException;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.ui.velocity.CommonsLoggingLogSystem;
import org.springframework.ui.velocity.SpringResourceLoader;
import org.springframework.util.StringUtils;

public class VelocityEngineFactory {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Resource configLocation;
    private final Map velocityProperties = new HashMap();
    private String resourceLoaderPath;
    private ResourceLoader resourceLoader = new DefaultResourceLoader();
    private boolean preferFileSystemAccess = true;
    private boolean overrideLogging = true;

    public void setConfigLocation(Resource configLocation) {
        this.configLocation = configLocation;
    }

    public void setVelocityProperties(Properties velocityProperties) {
        this.setVelocityPropertiesMap(velocityProperties);
    }

    public void setVelocityPropertiesMap(Map velocityPropertiesMap) {
        if (velocityPropertiesMap != null) {
            this.velocityProperties.putAll(velocityPropertiesMap);
        }
    }

    public void setResourceLoaderPath(String resourceLoaderPath) {
        this.resourceLoaderPath = resourceLoaderPath;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    protected ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public void setPreferFileSystemAccess(boolean preferFileSystemAccess) {
        this.preferFileSystemAccess = preferFileSystemAccess;
    }

    protected boolean isPreferFileSystemAccess() {
        return this.preferFileSystemAccess;
    }

    public void setOverrideLogging(boolean overrideLogging) {
        this.overrideLogging = overrideLogging;
    }

    public VelocityEngine createVelocityEngine() throws IOException, VelocityException {
        VelocityEngine velocityEngine = this.newVelocityEngine();
        Properties props = new Properties();
        if (this.configLocation != null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Loading Velocity config from [" + this.configLocation + "]");
            }
            PropertiesLoaderUtils.fillProperties(props, this.configLocation);
        }
        if (!this.velocityProperties.isEmpty()) {
            props.putAll((Map<?, ?>)this.velocityProperties);
        }
        if (this.resourceLoaderPath != null) {
            this.initVelocityResourceLoader(velocityEngine, this.resourceLoaderPath);
        }
        if (this.overrideLogging) {
            velocityEngine.setProperty("runtime.log.logsystem", (Object)new CommonsLoggingLogSystem());
        }
        Iterator<Map.Entry<Object, Object>> it = props.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Object, Object> entry = it.next();
            if (!(entry.getKey() instanceof String)) {
                throw new IllegalArgumentException("Illegal property key [" + entry.getKey() + "]: only Strings allowed");
            }
            velocityEngine.setProperty((String)entry.getKey(), entry.getValue());
        }
        this.postProcessVelocityEngine(velocityEngine);
        try {
            velocityEngine.init();
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (VelocityException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            this.logger.error("Why does VelocityEngine throw a generic checked exception, after all?", ex);
            throw new VelocityException(ex.toString());
        }
        return velocityEngine;
    }

    protected VelocityEngine newVelocityEngine() throws IOException, VelocityException {
        return new VelocityEngine();
    }

    protected void initVelocityResourceLoader(VelocityEngine velocityEngine, String resourceLoaderPath) {
        if (this.isPreferFileSystemAccess()) {
            try {
                StringBuffer resolvedPath = new StringBuffer();
                String[] paths = StringUtils.commaDelimitedListToStringArray(resourceLoaderPath);
                for (int i = 0; i < paths.length; ++i) {
                    String path = paths[i];
                    Resource resource = this.getResourceLoader().getResource(path);
                    File file = resource.getFile();
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Resource loader path [" + path + "] resolved to file [" + file.getAbsolutePath() + "]");
                    }
                    resolvedPath.append(file.getAbsolutePath());
                    if (i >= paths.length - 1) continue;
                    resolvedPath.append(',');
                }
                velocityEngine.setProperty("resource.loader", (Object)"file");
                velocityEngine.setProperty("file.resource.loader.cache", (Object)"true");
                velocityEngine.setProperty("file.resource.loader.path", (Object)resolvedPath.toString());
            }
            catch (IOException ex) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Cannot resolve resource loader path [" + resourceLoaderPath + "] to [java.io.File]: using SpringResourceLoader", ex);
                }
                this.initSpringResourceLoader(velocityEngine, resourceLoaderPath);
            }
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("File system access not preferred: using SpringResourceLoader");
            }
            this.initSpringResourceLoader(velocityEngine, resourceLoaderPath);
        }
    }

    protected void initSpringResourceLoader(VelocityEngine velocityEngine, String resourceLoaderPath) {
        velocityEngine.setProperty("resource.loader", (Object)"spring");
        velocityEngine.setProperty("spring.resource.loader.class", (Object)SpringResourceLoader.class.getName());
        velocityEngine.setProperty("spring.resource.loader.cache", (Object)"true");
        velocityEngine.setApplicationAttribute((Object)"spring.resource.loader", (Object)this.getResourceLoader());
        velocityEngine.setApplicationAttribute((Object)"spring.resource.loader.path", (Object)resourceLoaderPath);
    }

    protected void postProcessVelocityEngine(VelocityEngine velocityEngine) throws IOException, VelocityException {
    }
}

