/*
 * Decompiled with CFR 0.152.
 */
package visad.data.hdfeos;

import visad.data.hdfeos.Calibration;
import visad.data.hdfeos.EosGrid;
import visad.data.hdfeos.EosSwath;
import visad.data.hdfeos.HdfeosException;
import visad.data.hdfeos.hdfeosc.HdfeosLib;

public abstract class EosStruct {
    static String G_TYPE = "Geolocation Fields";
    static String D_TYPE = "Data Fields";
    int struct_id;

    public int getStructId() {
        return this.struct_id;
    }

    public void readData(String f_name, int[] start, int[] stride, int[] edge, int num_type, Calibration cal, float[] f_data) throws HdfeosException {
        int status = 0;
        int n_values = f_data.length;
        if (num_type == 5) {
            if (this instanceof EosGrid) {
                status = HdfeosLib.GDreadfield(this.struct_id, f_name, start, stride, edge, f_data);
            } else if (this instanceof EosSwath) {
                status = HdfeosLib.SWreadfield(this.struct_id, f_name, start, stride, edge, f_data);
            }
        } else if (num_type == 6) {
            double[] d_data = new double[n_values];
            if (this instanceof EosGrid) {
                status = HdfeosLib.GDreadfield(this.struct_id, f_name, start, stride, edge, d_data);
            } else if (this instanceof EosSwath) {
                status = HdfeosLib.SWreadfield(this.struct_id, f_name, start, stride, edge, d_data);
            }
            for (int jj = 0; jj < n_values; ++jj) {
                f_data[jj] = (float)d_data[jj];
            }
            d_data = null;
        } else if (num_type == 24) {
            int[] i_data = new int[n_values];
            if (this instanceof EosGrid) {
                status = HdfeosLib.GDreadfield(this.struct_id, f_name, start, stride, edge, i_data);
            } else if (this instanceof EosSwath) {
                status = HdfeosLib.SWreadfield(this.struct_id, f_name, start, stride, edge, i_data);
            }
            for (int jj = 0; jj < n_values; ++jj) {
                f_data[jj] = i_data[jj];
            }
            i_data = null;
        } else if (num_type == 22 || num_type == 23) {
            short[] s_data = new short[n_values];
            if (this instanceof EosGrid) {
                status = HdfeosLib.GDreadfield(this.struct_id, f_name, start, stride, edge, s_data);
            } else if (this instanceof EosSwath) {
                status = HdfeosLib.SWreadfield(this.struct_id, f_name, start, stride, edge, s_data);
            }
            if (cal != null) {
                cal.fromCalibration(s_data, f_data);
            } else {
                for (int jj = 0; jj < n_values; ++jj) {
                    f_data[jj] = s_data[jj];
                }
            }
            s_data = null;
        } else if (num_type == 20 || num_type == 21) {
            byte[] b_data = new byte[n_values];
            if (this instanceof EosGrid) {
                status = HdfeosLib.GDreadfield(this.struct_id, f_name, start, stride, edge, b_data);
            } else if (this instanceof EosSwath) {
                status = HdfeosLib.SWreadfield(this.struct_id, f_name, start, stride, edge, b_data);
            }
            if (cal != null) {
                cal.fromCalibration(b_data, f_data);
            } else {
                for (int jj = 0; jj < n_values; ++jj) {
                    f_data[jj] = b_data[jj];
                }
            }
            b_data = null;
        } else {
            throw new HdfeosException(" number type not implemented: " + num_type);
        }
    }
}

