/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.GriddedSet;
import visad.Linear1DSet;
import visad.Linear2DSet;
import visad.Linear3DSet;
import visad.LinearLatLonSet;
import visad.LinearNDSet;
import visad.LinearSet;
import visad.MathType;
import visad.SetType;
import visad.Unit;
import visad.VisADException;
import visad.data.visad.BinaryObjectCache;
import visad.data.visad.BinaryReader;
import visad.data.visad.BinaryWriter;
import visad.data.visad.Saveable;
import visad.data.visad.object.BinaryCoordinateSystem;
import visad.data.visad.object.BinaryDoubleArray;
import visad.data.visad.object.BinaryErrorEstimate;
import visad.data.visad.object.BinaryGeneric;
import visad.data.visad.object.BinaryIntegerArray;
import visad.data.visad.object.BinaryObject;
import visad.data.visad.object.BinarySetType;
import visad.data.visad.object.BinaryUnit;
import visad.data.visad.object.BinaryUnknown;

public class BinaryLinearSet
implements BinaryObject {
    public static final int computeBytes(boolean matchedTypes, double[] firsts, double[] lasts, int[] lengths, Linear1DSet[] comps, CoordinateSystem cs, Unit[] units, ErrorEstimate[] errors) {
        int compsLen;
        if (matchedTypes) {
            compsLen = 1 + BinaryDoubleArray.computeBytes(firsts) + 1 + BinaryDoubleArray.computeBytes(lasts) + 1 + BinaryIntegerArray.computeBytes(lengths);
        } else {
            compsLen = 5;
            for (int i = 0; i < comps.length; ++i) {
                int size = BinaryGeneric.computeBytes(comps[i]);
                if (size < 0) {
                    return -1;
                }
                compsLen += size;
            }
        }
        int unitsLen = BinaryUnit.computeBytes(units);
        int errorsLen = BinaryErrorEstimate.computeBytes(errors);
        return 10 + compsLen + (cs == null ? 0 : 5) + (unitsLen == 0 ? 0 : unitsLen + 1) + (errorsLen == 0 ? 0 : errorsLen + 1) + 1;
    }

    public static boolean hasMatchedTypes(SetType type, Linear1DSet[] comps) {
        if (comps == null) {
            return true;
        }
        MathType[] dComp = type.getDomain().getComponents();
        if (dComp == null || dComp.length != comps.length) {
            return false;
        }
        boolean matchedTypes = true;
        for (int i = 0; i < dComp.length; ++i) {
            if (dComp[i].equals(comps[i].getType())) continue;
            matchedTypes = false;
            break;
        }
        return matchedTypes;
    }

    private static final Linear1DSet[] readLinear1DSets(BinaryReader reader) throws IOException, VisADException {
        DataInput file = reader.getInput();
        Linear1DSet[] sets = new Linear1DSet[file.readInt()];
        for (int i = 0; i < sets.length; ++i) {
            sets[i] = (Linear1DSet)BinaryGeneric.read(reader);
        }
        return sets;
    }

    public static final GriddedSet read(BinaryReader reader, byte dataType) throws IOException, VisADException {
        int dim;
        BinaryObjectCache cSysCache = reader.getCoordinateSystemCache();
        BinaryObjectCache typeCache = reader.getTypeCache();
        DataInput file = reader.getInput();
        int typeIndex = file.readInt();
        SetType st = (SetType)typeCache.get(typeIndex);
        double[] firsts = null;
        double[] lasts = null;
        int[] lengths = null;
        CoordinateSystem cs = null;
        Unit[] units = null;
        ErrorEstimate[] errs = null;
        Linear1DSet[] comps = null;
        boolean reading = true;
        block32: while (reading) {
            byte directive;
            try {
                directive = file.readByte();
            }
            catch (EOFException eofe) {
                return null;
            }
            switch (directive) {
                case 1: {
                    firsts = BinaryDoubleArray.read(reader);
                    continue block32;
                }
                case 2: {
                    lasts = BinaryDoubleArray.read(reader);
                    continue block32;
                }
                case 3: {
                    lengths = BinaryIntegerArray.read(reader);
                    continue block32;
                }
                case 13: {
                    comps = BinaryLinearSet.readLinear1DSets(reader);
                    continue block32;
                }
                case 32: {
                    int index = file.readInt();
                    cs = (CoordinateSystem)cSysCache.get(index);
                    continue block32;
                }
                case 40: {
                    units = BinaryUnit.readList(reader);
                    continue block32;
                }
                case 41: {
                    errs = BinaryErrorEstimate.readList(reader);
                    continue block32;
                }
                case 80: {
                    reading = false;
                    continue block32;
                }
            }
            throw new IOException("Unknown LinearSet directive " + directive);
        }
        if (st == null) {
            throw new IOException("No SetType found for LinearSet");
        }
        if (comps != null) {
            if (firsts != null) {
                throw new IOException("Both components and firsts found for LinearSet");
            }
            if (lasts != null) {
                throw new IOException("Both components and lasts found for LinearSet");
            }
            if (lengths != null) {
                throw new IOException("Both components and lengths found for LinearSet");
            }
            switch (dataType) {
                case 50: {
                    throw new IOException("Components specified for Linear1DSet");
                }
                case 51: {
                    return new Linear2DSet((MathType)st, comps, cs, units, errs);
                }
                case 52: {
                    return new Linear3DSet((MathType)st, comps, cs, units, errs);
                }
                case 53: {
                    return new LinearNDSet((MathType)st, comps, cs, units, errs);
                }
                case 54: {
                    return new LinearLatLonSet((MathType)st, comps, cs, units, errs);
                }
            }
            throw new IOException("Unknown LinearSet type " + dataType);
        }
        if (firsts == null) {
            throw new IOException("No firsts found for LinearSet");
        }
        if (lasts == null) {
            throw new IOException("No lasts found for LinearSet");
        }
        if (lengths == null) {
            throw new IOException("No lengths found for LinearSet");
        }
        switch (dataType) {
            case 50: {
                dim = 1;
                break;
            }
            case 51: {
                dim = 2;
                break;
            }
            case 52: {
                dim = 3;
                break;
            }
            case 54: {
                dim = 2;
                break;
            }
            default: {
                dim = -1;
            }
        }
        if (dim > 0 && firsts.length != dim) {
            throw new VisADException("Expected " + dim + " first value" + (dim > 1 ? "s" : "") + ", not " + firsts.length);
        }
        if (dim > 0 && lasts.length != dim) {
            throw new VisADException("Expected " + dim + " last value" + (dim > 1 ? "s" : "") + ", not " + lasts.length);
        }
        if (dim > 0 && lengths.length != dim) {
            throw new VisADException("Expected " + dim + " length" + (dim > 1 ? "s" : "") + ", not " + lengths.length);
        }
        switch (dataType) {
            case 50: {
                return new Linear1DSet((MathType)st, firsts[0], lasts[0], lengths[0], cs, units, errs);
            }
            case 51: {
                return new Linear2DSet(st, firsts[0], lasts[0], lengths[0], firsts[1], lasts[1], lengths[1], cs, units, errs);
            }
            case 52: {
                return new Linear3DSet(st, firsts[0], lasts[0], lengths[0], firsts[1], lasts[1], lengths[1], firsts[2], lasts[2], lengths[2], cs, units, errs);
            }
            case 53: {
                return new LinearNDSet((MathType)st, firsts, lasts, lengths, cs, units, errs);
            }
            case 54: {
                return new LinearLatLonSet(st, firsts[0], lasts[0], lengths[0], firsts[1], lasts[1], lengths[1], cs, units, errs);
            }
        }
        throw new IOException("Unknown LinearSet type " + dataType);
    }

    public static final void writeDependentData(BinaryWriter writer, SetType type, Linear1DSet[] comps, CoordinateSystem cs, Unit[] units, ErrorEstimate[] errors, GriddedSet set, Class canonicalClass, Object token) throws IOException {
        if (!(set.getClass().equals(canonicalClass) || set instanceof LinearSet && set instanceof Saveable)) {
            return;
        }
        Object dependToken = token == SAVE_DEPEND_BIG ? token : SAVE_DEPEND;
        BinarySetType.write(writer, type, set, SAVE_DATA);
        if (cs != null) {
            BinaryCoordinateSystem.write(writer, cs, SAVE_DATA);
        }
        if (units != null) {
            BinaryUnit.writeList(writer, units, SAVE_DATA);
        }
        if (errors != null) {
            BinaryErrorEstimate.writeList(writer, errors, SAVE_DATA);
        }
        if (comps != null) {
            for (int i = 0; i < comps.length; ++i) {
                BinaryGeneric.write(writer, comps[i], dependToken);
            }
        }
    }

    public static final void write(BinaryWriter writer, SetType type, double[] firsts, double[] lasts, int[] lengths, Linear1DSet[] comps, CoordinateSystem cs, Unit[] units, ErrorEstimate[] errors, GriddedSet set, Class canonicalClass, byte dataType, Object token) throws IOException {
        int typeIndex;
        BinaryLinearSet.writeDependentData(writer, type, comps, cs, units, errors, set, canonicalClass, token);
        if (token == SAVE_DEPEND || token == SAVE_DEPEND_BIG) {
            return;
        }
        if (!(set.getClass().equals(canonicalClass) || set instanceof LinearSet && set instanceof Saveable)) {
            BinaryUnknown.write(writer, set, token);
            return;
        }
        boolean matchedTypes = BinaryLinearSet.hasMatchedTypes(type, comps);
        int dim = set.getDimension();
        if (!matchedTypes) {
            if (dataType == 50) {
                throw new IOException("Components specified for Linear1DSet");
            }
            if (comps.length != dim) {
                throw new IOException("Expected " + dim + " LinearSet component" + (dim > 1 ? "s" : "") + ", not " + comps.length);
            }
        } else {
            if (firsts == null) {
                throw new IOException("Null " + canonicalClass.getName() + " firsts");
            }
            if (lasts == null) {
                throw new IOException("Null " + canonicalClass.getName() + " lasts");
            }
            if (lengths == null) {
                throw new IOException("Null " + canonicalClass.getName() + " lengths");
            }
            if (firsts.length != dim) {
                throw new IOException("Expected " + dim + " LinearSet first value" + (dim > 1 ? "s" : "") + ", not " + firsts.length);
            }
            if (lasts.length != dim) {
                throw new IOException("Expected " + dim + " LinearSet last value" + (dim > 1 ? "s" : "") + ", not " + lasts.length);
            }
            if (lengths.length != dim) {
                throw new IOException("Expected " + dim + " LinearSet length" + (dim > 1 ? "s" : "") + ", not " + lengths.length);
            }
        }
        if ((typeIndex = writer.getTypeCache().getIndex(type)) < 0) {
            throw new IOException("SetType " + type + " not cached");
        }
        int csIndex = -1;
        if (cs != null && (csIndex = writer.getCoordinateSystemCache().getIndex(cs)) < 0) {
            throw new IOException("CoordinateSystem " + cs + " not cached");
        }
        int[] unitsIndex = null;
        if (units != null) {
            unitsIndex = BinaryUnit.lookupList(writer.getUnitCache(), units);
        }
        int[] errorsIndex = null;
        if (errors != null) {
            errorsIndex = BinaryErrorEstimate.lookupList(writer.getErrorEstimateCache(), errors);
        }
        int objLen = BinaryLinearSet.computeBytes(matchedTypes, firsts, lasts, lengths, comps, cs, units, errors);
        DataOutput file = writer.getOutput();
        file.writeByte(2);
        file.writeInt(objLen);
        file.writeByte(dataType);
        file.writeInt(typeIndex);
        if (matchedTypes) {
            file.writeByte(1);
            BinaryDoubleArray.write(writer, firsts, token);
            file.writeByte(2);
            BinaryDoubleArray.write(writer, lasts, token);
            file.writeByte(3);
            BinaryIntegerArray.write(writer, lengths, token);
        } else {
            file.writeByte(13);
            file.writeInt(comps.length);
            for (int i = 0; i < comps.length; ++i) {
                BinaryGeneric.write(writer, comps[i], token);
            }
        }
        if (csIndex >= 0) {
            file.writeByte(32);
            file.writeInt(csIndex);
        }
        if (unitsIndex != null) {
            file.writeByte(40);
            BinaryIntegerArray.write(writer, unitsIndex, token);
        }
        if (errorsIndex != null) {
            file.writeByte(41);
            BinaryIntegerArray.write(writer, errorsIndex, token);
        }
        file.writeByte(80);
    }
}

